/*
  just a small test app for libsmtp mime functions
   
Copyright ?2001 Kevin Read <obsidian@berlios.de>

This software is available under the GNU Lesser Public License as described
in the COPYING file.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Kevin Read <obsidian@berlios.de>
Thu Aug 16 2001 */



/*******************************************************************
 * This is a demonstration for libsmtp - it is not intended to be  *
 * good coding style - it's artificial. You have been warned :)    *
 * All good coders, cover your eyes now ;)			   *
 *******************************************************************/

#include <glib.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>

#include "libsmtp.h"
#include "libsmtp_mime.h"

#define HAVE_AUTH				1

#define SEND_MIME_TEXTPLAIN		0
#define SEND_MIME_BINARY_DATA	0
#define SEND_MIME_MIXED			1

/* We need a function to read a line from stdin that cuts of the newline */

int read_line (char *buffer, int length)
{
  char *pointer;
  fgets (buffer, 255, stdin);
  
  buffer[strlen(buffer)-1]='\0';
  
/*  if ((pointer=strchr (buffer, '\n')) == NULL)
    return 0;
  
  pointer='\0'; */
  return 0;
}

/* This will spew out status messages */
char *choose_auth_method(AUTH_TYPE i)
{
	switch (i) {
	case LOGIN:
		return "LOGIN";
	case PLAIN:
		return "PLAIN";
	case CRAM_MD5:
		return "CRAM-MD5";
	case DIGEST_MD5:
		return "DIGEST-MD5";
	default:
		return "OTHERs";
	}
}

int main(int argc, char *argv[])
{
    unsigned char *jpegbuffer, sender[64], subject[64], notify_message[128];
    unsigned char server[64], to[64], user[64], password[64];
    time_t t;
	char vbuff[1024*1000];
	int fd, rcv_vbuffsz;
	AUTH_TYPE auth_method;

    /* This struct holds all session data. You need one per mail server
       connection */
    struct libsmtp_session_struct *mailsession;
    struct libsmtp_part_struct *mainpart;
  
    time(&t);
    sprintf(subject, "SENDMAIL: multipart test( %s )", ctime(&t));
    strcpy(sender, "cathys516@pchome.com.tw");//cathys516@pchome.com.tw
    strcpy(server, "smtp.pchome.com.tw");//127.0.0.1
    strcpy(user, "cathys516");//cathys516
    strcpy(password, "690620");//690620
	auth_method = LOGIN;
	if (argc > 1) auth_method = atoi(argv[1]);
    
    /* This mallocs the structs mem and initializes variables in it */
    mailsession = libsmtp_session_initialize();

	if (mailsession == NULL) {
		printf("Low memory....\n");
		return -1;
	}

    /* Set session environment (from address, subject) */
    if (libsmtp_set_environment (sender, subject, 0, mailsession)) {
        stat_message (mailsession);
        libsmtp_free (mailsession);
        return mailsession->ErrorCode;
    }

#if HAVE_AUTH
	if (libsmtp_set_authorization(auth_method, user, password, 110, "pop3.pchome.com.tw", mailsession)) {
        stat_message (mailsession);
        libsmtp_free (mailsession);
        return mailsession->ErrorCode;
	}
#endif

    printf ("\nPlease enter the mail recipient: ");
    read_line (to, 64);
    
    /* Now we add some recipients */
    libsmtp_add_recipient (LIBSMTP_REC_TO, to, mailsession);
    
    /* This starts the SMTP connection */
    if (libsmtp_connect (server, 0, 10, mailsession)) {
        stat_message (mailsession);
        libsmtp_free (mailsession);
        return mailsession->ErrorCode;
    }
    printf ("SMTP connection running.\n");

    /* This will conduct the SMTP dialogue */
    if (libsmtp_dialogue (mailsession)) {
        stat_message (mailsession);
        libsmtp_free (mailsession);
        return mailsession->ErrorCode;
    }
    printf ("Dialogue finished.\n");

	/* Now lets send the headers - you can send your own headers too */
	if (libsmtp_headers (0, mailsession)) {
	  stat_message (mailsession);
	  libsmtp_free (mailsession);
	  return mailsession->ErrorCode;
	}

	printf ("SMTP headers sent.\n");

#if SEND_MIME_TEXTPLAIN
    /* This sends a line of message body */
	sprintf(notify_message, "test libsmtp_send_singlepart by cathy");
	if (libsmtp_send_notify_message(notify_message, mailsession)) {
		stat_message (mailsession);
		libsmtp_free (mailsession);
		return mailsession->ErrorCode;
	}
#endif
 
	fd = open("/var/www/images/images.jpg", O_RDWR);
	rcv_vbuffsz = read(fd, vbuff, sizeof(vbuff));
	printf(" image size = %d\n", rcv_vbuffsz);


#if SEND_MIME_MIXED
	libsmtp_multipart_header(mailsession);
	sprintf(notify_message, "Test Auth method: %s", choose_auth_method(auth_method));
	libsmtp_send_multipart(LIBSMTP_MIME_TEXT, LIBSMTP_MIME_SUB_PLAIN, LIBSMTP_ENC_7BIT, \
						   LIBSMTP_CHARSET_USASCII,NULL,notify_message, strlen(notify_message),mailsession );
	libsmtp_send_multipart(LIBSMTP_MIME_IMAGE, LIBSMTP_MIME_SUB_JPG, LIBSMTP_ENC_BASE64, \
						   LIBSMTP_CHARSET_NOCHARSET,"a.jpg",vbuff, rcv_vbuffsz,mailsession );
	libsmtp_send_multipart(LIBSMTP_MIME_IMAGE, LIBSMTP_MIME_SUB_JPG, LIBSMTP_ENC_BASE64, \
						   LIBSMTP_CHARSET_NOCHARSET,"b.jpg",vbuff, rcv_vbuffsz,mailsession );
	libsmtp_send_multipart(LIBSMTP_MIME_IMAGE, LIBSMTP_MIME_SUB_JPG, LIBSMTP_ENC_BASE64, \
						   LIBSMTP_CHARSET_NOCHARSET,"c.jpg",vbuff, rcv_vbuffsz,mailsession );
	libsmtp_multipart_end(mailsession);
#endif

#if SEND_MIME_BINARY_DATA
	if (libsmtp_send_bdata(LIBSMTP_MIME_APPLICATION, LIBSMTP_MIME_SUB_ZIP, "imagexx.jpg", vbuff, rcv_vbuffsz, mailsession)) {
		stat_message (mailsession);
	    libsmtp_free (mailsession);
		return mailsession->ErrorCode;
	}
#endif

	close(fd);

	/* This ends the body part */
	if (libsmtp_body_end (mailsession)) {
		libsmtp_free (mailsession);
		stat_message (mailsession);
		return mailsession->ErrorCode;
	}

    /* This ends the connection gracefully */
	libsmtp_quit (mailsession);
    /* Free the allocated struct mem */
    libsmtp_free (mailsession);
    return 0;
}
