#!/bin/sh
##############################################################################
# Definitions 
##############################################################################
######################################
# General
######################################
XSUPP_TOPDIR=`pwd`
PATCHES_DIR=$XSUPP_TOPDIR/sspo_patches
SOURCE_DIR=$XSUPP_TOPDIR/source_tars
REMOVE_LIST=.remove_list
######################################
# Xsupplicant
######################################
XSUPP_NAME=xsupplicant-1.2.8
XSUPP_SOURCE=$XSUPP_NAME.tar.gz
XSUPP_DIR=$XSUPP_TOPDIR
XSUPP_SRC_DIR=$XSUPP_DIR/src
XSUPP_SRC_CARDIF_DIR=$XSUPP_DIR/src/cardif
XSUPP_SRC_EAPTYPES_DIR=$XSUPP_DIR/src/eap_types
XSUPP_LIBS_DIR=$XSUPP_DIR/lib
######################################
# SSPO Api
######################################
SSPO_API_NAME=sspo_api
SSPO_API_DIR=$XSUPP_TOPDIR/$SSPO_API_NAME
######################################
# Wireless_tools
######################################
WTOOLS_NAME=wireless_tools.29
WTOOLS_SOURCE=$WTOOLS_NAME.tar.gz
WTOOLS_DIR=$XSUPP_DIR/lib/$WTOOLS_NAME
######################################
# Flex
######################################
FLEX_NAME=flex-2.5.35
FLEX_SOURCE=$FLEX_NAME.tar.bz2
FLEX_DIR=$XSUPP_DIR/lib/$FLEX_NAME
######################################
# Machine hardware name
######################################
BUILD_MACHINE=`uname -m`

##############################################################################
# Functions 
##############################################################################
function func_Usage {
	echo 
	echo "USAGE:"
	echo 'xsupp_build.sh OP_MODE={ "build" | "clean" } CROSS=${YOUR_CROSS} OPENSSL_DIR=${YOUR_OPENSSL_DIR} MOREDEFS=${YOUR_MACRO}'
	echo 
	exit -1; 
}

function func_AbsoluteDir {
	arg="$1"
	case "$arg" in
		/*)
			echo "xsupp_build.sh: Absolute Path: $arg"
			OPENSSL_DIR="$arg"
			;;
		..*)
			echo "xsupp_build.sh: Relative Path: $arg"
			OPENSSL_DIR="$XSUPP_TOPDIR/$arg"
			;;
		*)
			echo "xsupp_build.sh: Other cases! Checking if it's in parent directory..."
			[ -d ../"$arg" ] && OPENSSL_DIR="$XSUPP_TOPDIR/$arg" && echo "yes"
			;;
        esac
	if [ -d "$OPENSSL_DIR" ] ; then
		return
	else
		echo "xsupp_build.sh: $arg directory doesn't exist."
		exit -1
	fi
}

##############################################################################
# Main Procedure
##############################################################################
######################################
# Checking input arguments
######################################
if test $# -le 0 || test $# -gt 4 ; then
	func_Usage
fi

######################################
# Parsing arguments 
######################################
while test $# != 0
do
	option=`expr "x$1" : 'x\([^=]*\)='`
	optarg=`expr "x$1" : 'x[^=]*=\(.*\)'`
	case "$option" in 
		"OP_MODE" )
			case "$optarg" in 
				"clean" )
					echo; echo
					echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
					echo "Cleaning $XSUPP_NAME/$FLEX_NAME/$WTOOLS_NAME ..."
					echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
					cat $REMOVE_LIST | xargs rm -rf {}
					rm -f $REMOVE_LIST
					echo "done"
					echo; echo
					echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
					echo "Cleaning $SSPO_API_NAME ..."
					echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
					make -C $SSPO_API_DIR clean
					echo "done"
					exit 0
					;;
				"build" )
					if test ! $# -eq 4 ; then
						func_Usage
					fi
					;;
				* )
					func_Usage
					;;
			esac
			;;
		"CROSS" ) 
			case "$optarg" in
				"" )
					func_Usage
					;;
				*)
					CROSS="$optarg"
					;;
			esac
			;;
		"OPENSSL_DIR" )
			case "$optarg" in
				"" )
					func_Usage
					;;
				*)
					func_AbsoluteDir $optarg
					OPENSSL_LIBS_DIR=$OPENSSL_DIR
					OPENSSL_INCLUDE_DIR=$OPENSSL_DIR/include
					;;
			esac
			;;
		"MOREDEFS" )
			MOREDEFS="$optarg"
			;;
		*)
			func_Usage
			;;
	esac
	shift
done

######################################
# Extracting xsupplicant tarball 
######################################
echo; echo
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
echo "Extracting $XSUPP_SOURCE ..."
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
tar zxf $SOURCE_DIR/$XSUPP_SOURCE 
echo "done"
ls $XSUPP_TOPDIR/$XSUPP_NAME > $REMOVE_LIST
echo "config.log config.status Makefile" >> $REMOVE_LIST
mv $XSUPP_TOPDIR/$XSUPP_NAME/* .
rm -rf $XSUPP_NAME

######################################
# Extracting flex tarball 
######################################
echo; echo
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
echo "Extracting $FLEX_SOURCE ..."
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
cd $XSUPP_LIBS_DIR
tar jxf $SOURCE_DIR/$FLEX_SOURCE
echo "done"

######################################
# Extracting wireless_tools tarball 
######################################
echo; echo
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
echo "Extracting $WTOOLS_SOURCE ..."
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
cd $XSUPP_LIBS_DIR
tar zxf $SOURCE_DIR/$WTOOLS_SOURCE
echo "done"

######################################
# Building flex 
######################################
echo; echo
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
echo "Configuring $FLEX_NAME ..."
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
cd $FLEX_DIR
patch -N -p0 < $PATCHES_DIR/flex.patch

./configure \
	CC="$CROSS"gcc \
  	AR="$CROSS"'ar r' \
  	STRIP="$CROSS"strip \
  	RANLIB="$CROSS"ranlib \
  	OBJDUMP="$CROSS"objdump \
	CFLAGS="$DBGFLAGS $OPTFLAGS" \
  	--host=arm \
  	--build="$BUILD_MACHINE"-pc-linux \
  	--prefix="$FLEX_DIR" \
  	--enable-shared \
  	--disable-dependency-tracking

echo; echo
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
echo "Building $FLEX_NAME ..."
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
make \
	CC="$CROSS"gcc \
  	AR="$CROSS"'ar r' \
  	STRIP="$CROSS"strip \
  	RANLIB="$CROSS"ranlib \
  	OBJDUMP="$CROSS"objdump \
	CFLAGS="$DBGFLAGS $OPTFLAGS"


######################################
# Building wireless_tools
######################################
echo; echo
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
echo "Building $WTOOLS_NAME ..."
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
cd $WTOOLS_DIR
make \
	BUILD_STATIC=y \
  	CC="$CROSS"gcc \
  	AR="$CROSS"ar \
  	STRIP="$CROSS"strip \
  	RANLIB="$CROSS"ranlib \
  	OBJDUMP="$CROSS"objdump \
	CFLAGS="$DBGFLAGS $OPTFLAGS"


######################################
# Building xsupplicant
######################################
# Flags of xsupplicant compliation
DBGFLAGS="-g"
OPTFLAGS="-O2"
CFLAGS="$DBGFLAGS $OPTFLAGS -I$WTOOLS_DIR"
CFLAGS="$CFLAGS -I$FLEX_DIR" 
CFLAGS="$CFLAGS -I$OPENSSL_INCLUDE_DIR" 
CFLAGS="$CFLAGS -I$XSUPP_SRC_DIR" 
CFLAGS="$CFLAGS -I$XSUPP_SRC_CARDIF_DIR" 
CFLAGS="$CFLAGS -I$XSUPP_SRC_EAPTYPES_DIR" 

LDFLAGS="-L$WTOOLS_DIR"
LDFLAGS="-L$FLEX_DIR $LDFLAGS" 
LDFLAGS="-L$OPENSSL_DIR $LDFLAGS"

echo; echo
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
echo "Configuring $XSUPP_NAME ..."
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
cd $XSUPP_DIR

patch -N -p0 < $PATCHES_DIR/xsupp.patch

./configure \
  	CC="$CROSS"gcc \
  	AR="$CROSS"ar \
  	STRIP="$CROSS"strip \
  	RANLIB="$CROSS"ranlib \
  	OBJDUMP="$CROSS"objdump \
  	CFLAGS="$CFLAGS" \
  	LDFLAGS="$LDFLAGS" \
  	LIBS="$LIBS" \
	MOREDEFS="$MOREDEFS" \
  	--host=arm-linux \
  	--prefix=`pwd` \
  	--build="$BUILD_MACHINE"-pc-linux-gnu \
  	--disable-generic-framer \
  	--with-openssl="$OPENSSL_DIR" \
  	--with-openssl-libs="$OPENSSL_DIR" \
  	--with-openssl-headers="$OPENSSL_DIR"/include

echo; echo
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
echo "Buildng $XSUPP_NAME ..."
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
make \
  	CC="$CROSS"gcc \
  	AR="$CROSS"ar \
  	STRIP="$CROSS"strip \
  	RANLIB="$CROSS"ranlib \
  	OBJDUMP="$CROSS"objdump

echo; echo
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
echo "Buildng $SSPO_API_NAME ..."
echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
cd $SSPO_API_DIR
pwd
make CROSS="$CROSS"
