#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include "SnmpConf.h"
#include "Common.h"

int IsProcessExists (char *s)
{
	FILE *fd = NULL;
	char buf[128];
	int ret = ERR;

	if (!s || strlen (s) == 0)
		return ERR;

	fd = popen ("ps", "r");
	if (!fd) {
		printf("popen failed. %d %s\n", errno, strerror (errno));
		return ERR;
	}

    while ((fgets (buf, sizeof (buf), fd)))
        if (strstr (buf, s))
            ret = OK;

	pclose (fd);
	return ret;
}

int read_line (char *buff, int length)
{
  char *pointer;
  char buffer[255];
  fgets (buffer, sizeof(buffer), stdin);

  buffer[strlen(buffer)-1]='\0';
  strncpy(buff, buffer, length -1);
  buff[length -1] = '\0';

/*  if ((pointer=strchr (buffer, '\n')) == NULL)
 *      return 0;
 *
 *        pointer='\0'; */
  return 0;
}

void askcommunity(char *rdcomm, char *wtcomm)
{

    printf("please setting readcommunity: ");
    read_line(rdcomm, 64);
    printf("please setting writecommunity: ");
    read_line(wtcomm, 64);
} 

void askv3setting(char *v3name, char *authpass)
{
    printf("please setting user name: ");
    read_line(v3name, 64);
    printf("please setting password: ");
    read_line(authpass, 64);
}

void asktrap(unsigned char *trap, char *trapaddr, char *trapcomm)
{
    unsigned char cmd[2];
    printf("Step2. You want to support snmp trap item is \n\t 0)not supported \n\t 1)Cold Start \n\t 2)Warm Start \n\t 3)Cold|Warm Start \n\t 4)AuthenticationFailed \n\t 5)Cold Start|AuthenticationFailed \n\t 6)Warm Start|AuthenticationFailed \n\t 7)All\n\t choose:");
    read_line(cmd, 2);
	*trap = (unsigned char)(atoi(cmd));
    if (cmd) {
	printf("please setting destination IP: ");
    	read_line(trapaddr, 64);
    	printf("please setting trap community: ");
    	read_line(trapcomm, 64);
    } 
}
void PrintSnmpConf(tSnmpConf *conf) 
{
	printf("SNMP Version: %d\n",conf->SecVer);
	if (conf->SecVer & 0x03) {
		printf("ReadCommunity: %s\n", conf->ReadCommunity);
		printf("WriteCommunity: %s\n", conf->WriteCommunity);
	}
	if (conf->SecVer & 0x04) {
		printf("V3 user name: %s\n", conf->v3user);
		printf("V3 auth passphrase: %s\n", conf->authpassphrase);
	}
	printf("SNMP Trap: %d\n", conf->TrapsState);
	if (conf->TrapsState){
		printf("Trap addr: %s\n",conf->TrapAddr);
		printf("Trap community: %s\n", conf->TrapCommunity);
	}

}

void LoadDefaultSnmpConf(tSnmpConf *conf)
{
	conf->SecVer = 0;
	strcpy(conf->ReadCommunity, "public");
	strcpy(conf->WriteCommunity, "write");
	conf->TrapsState = 0;
	strcpy(conf->TrapCommunity, "public");
}

int main(int argc, char *argv[])
{
    unsigned char version[2];
    int rc;
    tSnmpConf conf;

    if (IsProcessExists("snmpd") == ERR) {
	LoadDefaultSnmpConf(&conf);
	SNMPDaemonStart(&conf, 0, "MY Device");	
    }
    memset(&conf, 0, sizeof(tSnmpConf));
    printf("This is the net-snmp testing program.\nYou will now be asked for something setting for snmpd.conf\n\n");
    printf("Step 1. You want to support snmp version is 0)disable 1)v1 2)v2c 3)v1|v2c 4)v3: ");
    read_line(version, 2);
    conf.SecVer = version[0] - '0';
    switch (conf.SecVer) {
	case 1:
	case 2:
	case 3:
	    askcommunity(conf.ReadCommunity, conf.WriteCommunity);
	    asktrap(&conf.TrapsState, conf.TrapAddr, conf.TrapCommunity);
	    break;
	case 4:
	    askv3setting(conf.v3user, conf.authpassphrase);
	    asktrap(&conf.TrapsState, conf.TrapAddr, conf.TrapCommunity);
	    break;
	case 0:
	default:
	    break;
    }
    PrintSnmpConf(&conf);
    SNMPDaemonReconfiguring(&conf, 0, "MY Device1");
    return 0;
}
