//#include <stdio.h>
//#include <signal.h>
#include "SnmpConf.h"
#include "Common.h"
//#include "server.h"

/* ######################################################################################
 * Static Functions
 * ###################################################################################### */
static int SNMPDaemonConfGenerator(tSnmpConf *conf, int ObjectID, char *sysDescr)
{
	FILE *fp;

	fp = fopen(SNMPDCONF_FILE, "w");
	if (fp == NULL)
		return ERR;

	fprintf(fp,"sysDescr %s\n", sysDescr);
	if (ObjectID)
		fprintf(fp,"sysObjectID .1.3.6.1.4.1.%d\n", ObjectID);
		
	if (conf->SecVer) {
		fprintf(fp, "com2sec\tronet\tdefault\t\"%s\"\n", conf->ReadCommunity);
		fprintf(fp, "com2sec\trwnet\tdefault\t\"%s\"\n", conf->WriteCommunity);
		fprintf(fp, "view\tall\tincluded\t.1\t80\n");
		fprintf(fp, "access MyROGroup \"\"      any       noauth    exact  all    none   none\n");
		fprintf(fp, "access MyRWGroup \"\"      any       noauth    exact  all    all    none\n");
	}
	if (conf->SecVer & SNMPVer1) {
		fprintf(fp, "group\tMyRWGroup\tv1\trwnet\n");
		fprintf(fp, "group\tMyROGroup\tv1\tronet\n");
		if (conf->TrapsState) {
			fprintf(fp, "trapsink %s %s\n", conf->TrapAddr, conf->TrapCommunity);
		}
	}
	printf("Snmp enable Version %x\n", conf->SecVer);
	if (conf->SecVer & SNMPVer2c) {
		fprintf(fp, "group\tMyRWGroup\tv2c\trwnet\n");
		fprintf(fp, "group\tMyROGroup\tv2c\tronet\n");
		if (conf->TrapsState && !(conf->SecVer & SNMPVer1)) {
			fprintf(fp, "trap2sink %s %s\n", conf->TrapAddr, conf->TrapCommunity);
		}
	}
	if (conf->SecVer & SNMPVer3) {
		fprintf(fp, "group\tMyRWGroup\tusm\trwnet\n");
		fprintf(fp, "group\tMyROGroup\tusm\tronet\n");
		fprintf(fp, "createUser %s MD5 \"%s\" DES\n", conf->v3user, conf->authpassphrase);
		fprintf(fp, "rouser %s\n", conf->v3user);
		fprintf(fp, "rwuser %s\n", conf->v3user);
		if (conf->TrapsState && !(conf->SecVer & (SNMPVer1|SNMPVer2c))) {
			fprintf(fp, "trapsess -v 3 -u %s -a MD5 -A %s -l authNoPriv %s\n", \
					conf->v3user, conf->authpassphrase, conf->TrapAddr);
		}
	}

	if (conf->TrapsState) {
		if (conf->TrapsState & TrapColdStart)
			fprintf(fp,"coldstart %d\n", ENABLE);
		else 
			fprintf(fp,"coldstart %d\n", DISABLE);
		if (conf->TrapsState & TrapWarmStart) 
			fprintf(fp,"warmstart %d\n", ENABLE);
		else
			fprintf(fp,"warmstart %d\n", DISABLE);
		if (conf->TrapsState & TrapAuthFailed)
			fprintf(fp,"authtrapenable %d\n", ENABLE);
		else
			fprintf(fp,"authtrapenable %d\n", ENABLE+1);
	}
	fclose(fp);
	return OK;
}

/* ######################################################################################
 * Share Functions
 * ###################################################################################### */

void SNMPDaemonStop(void) 
{
	system("killall snmpd");
}

void SNMPDaemonStart(tSnmpConf *conf, int objectId, char *sysDescr) 
{
	char cmd[255];

	SNMPDaemonConfGenerator(conf, objectId, sysDescr);
	sprintf(cmd, "%s -Lo -C -p %s -c %s &", SNMPDAEMON, SNMPD_PID_FILE, SNMPDCONF_FILE);
	system(cmd);
}

void SNMPDaemonReconfiguring(tSnmpConf *conf, int objectId, char *sysDescr)
{
	FILE *fp;
	int pid;

	fp = fopen(SNMPD_PID_FILE,"r");
	if (fp > 0) {
		fscanf(fp, "%d", &pid);
		fclose(fp);
		SNMPDaemonConfGenerator(conf, objectId, sysDescr);
		kill(pid, SIGHUP);
	}
}
