// vim: ts=4 sw=4
/* #######################################################################
 * Common.h
 * created by MingYoung for ASOC2200 Encoder platform.
 * date: 2006/07/19
 * Description:
 *      common headers for all c files.
 * ####################################################################### */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <semaphore.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/termios.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <pthread.h>

/* ######################################################################################
 * MICRO
 * ###################################################################################### */
#define MyMsg1(fmt, args...)	printf(fmt, ##args)
#define MyMsg0(fmt, args...)
#define MyErrMsg		MyMsg1

/* ######################################################################################
 * Definitions of Status Code (int)
 * ###################################################################################### */
#define OK			0x00000000
#define ERR			0x80000000
#define ERR_FOPEN		(ERR|0x00000001)
#define ERR_FWRITE		(ERR|0x00000002)
#define ERR_FREAD		(ERR|0x00000004)
#define ERR_VALUE		(ERR|0x00000008)
#define ERR_ACCOUNT		(ERR|0x00000010)
#define ERR_TIMEOUT             (ERR|0x00000020)
/* ##### Definitions of state in disable and enable configurations ##### */
enum {
	DISABLE=0,
	ENABLE
};
/* ##### Definitions of mode in manual and auto configuration ##### */
enum {
	MANUAL=0,
	AUTO
};
/* ##### Definitions of the language ##### */
enum {
        ENGLISH=0, \
        TCHINESE, \
        SCHINESE, \
        JAPANSE, \
        SPANISH, \
        ITALIAN, \
        GERMAN, \
        PORTUGUESE, \
        CZECH, \
        FRENCH, \
        FINNISH, \
        HUNGARIAN, \
        DANISH, \
        LANG_MAX
};
