/* soapC.c
   Generated by gSOAP 2.7.16 from onvif.h
   Copyright(C) 2000-2010, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "soapH.h"

#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) soapC.c ver 2.7.16 2012-05-31 19:40:07 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (!soap->header)
	{	if ((soap->header = (struct SOAP_ENV__Header*)soap_malloc(soap, sizeof(struct SOAP_ENV__Header))))
			soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		if (!soap->fault)
			return;
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
//	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	if (soap->version == 1)
	{	for (;;)
		{	if (!soap_getelement(soap, &t))
				if (soap->error || soap_ignore_element(soap))
					break;
		}
	}
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_tt__IANA_IfTypes:
		return soap_in_tt__IANA_IfTypes(soap, NULL, NULL, "tt:IANA-IfTypes");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_float:
		return soap_in_float(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_time:
		return soap_in_time(soap, NULL, NULL, "xsd:dateTime");
	case SOAP_TYPE_wsu__tTimestampFault:
		return soap_in_wsu__tTimestampFault(soap, NULL, NULL, "wsu:tTimestampFault");
	case SOAP_TYPE_wsse__FaultcodeEnum:
		return soap_in_wsse__FaultcodeEnum(soap, NULL, NULL, "wsse:FaultcodeEnum");
	case SOAP_TYPE_d__FaultCodeType:
		return soap_in_d__FaultCodeType(soap, NULL, NULL, "d:FaultCodeType");
	case SOAP_TYPE_wsaw__AnonymousType:
		return soap_in_wsaw__AnonymousType(soap, NULL, NULL, "wsaw:AnonymousType");
	case SOAP_TYPE_tt__IrCutFilterMode:
		return soap_in_tt__IrCutFilterMode(soap, NULL, NULL, "tt:IrCutFilterMode");
	case SOAP_TYPE_tt__WhiteBalanceMode:
		return soap_in_tt__WhiteBalanceMode(soap, NULL, NULL, "tt:WhiteBalanceMode");
	case SOAP_TYPE_tt__Enabled:
		return soap_in_tt__Enabled(soap, NULL, NULL, "tt:Enabled");
	case SOAP_TYPE_tt__ExposureMode:
		return soap_in_tt__ExposureMode(soap, NULL, NULL, "tt:ExposureMode");
	case SOAP_TYPE_tt__ExposurePriority:
		return soap_in_tt__ExposurePriority(soap, NULL, NULL, "tt:ExposurePriority");
	case SOAP_TYPE_tt__BacklightCompensationMode:
		return soap_in_tt__BacklightCompensationMode(soap, NULL, NULL, "tt:BacklightCompensationMode");
	case SOAP_TYPE_tt__WideDynamicMode:
		return soap_in_tt__WideDynamicMode(soap, NULL, NULL, "tt:WideDynamicMode");
	case SOAP_TYPE_tt__AutoFocusMode:
		return soap_in_tt__AutoFocusMode(soap, NULL, NULL, "tt:AutoFocusMode");
	case SOAP_TYPE_tt__MoveStatus:
		return soap_in_tt__MoveStatus(soap, NULL, NULL, "tt:MoveStatus");
	case SOAP_TYPE_tt__RelayMode:
		return soap_in_tt__RelayMode(soap, NULL, NULL, "tt:RelayMode");
	case SOAP_TYPE_tt__RelayIdleState:
		return soap_in_tt__RelayIdleState(soap, NULL, NULL, "tt:RelayIdleState");
	case SOAP_TYPE_tt__RelayLogicalState:
		return soap_in_tt__RelayLogicalState(soap, NULL, NULL, "tt:RelayLogicalState");
	case SOAP_TYPE_tt__UserLevel:
		return soap_in_tt__UserLevel(soap, NULL, NULL, "tt:UserLevel");
	case SOAP_TYPE_tt__SetDateTimeType:
		return soap_in_tt__SetDateTimeType(soap, NULL, NULL, "tt:SetDateTimeType");
	case SOAP_TYPE_tt__FactoryDefaultType:
		return soap_in_tt__FactoryDefaultType(soap, NULL, NULL, "tt:FactoryDefaultType");
	case SOAP_TYPE_tt__SystemLogType:
		return soap_in_tt__SystemLogType(soap, NULL, NULL, "tt:SystemLogType");
	case SOAP_TYPE_tt__CapabilityCategory:
		return soap_in_tt__CapabilityCategory(soap, NULL, NULL, "tt:CapabilityCategory");
	case SOAP_TYPE_tt__DynamicDNSType:
		return soap_in_tt__DynamicDNSType(soap, NULL, NULL, "tt:DynamicDNSType");
	case SOAP_TYPE_tt__IPType:
		return soap_in_tt__IPType(soap, NULL, NULL, "tt:IPType");
	case SOAP_TYPE_tt__NetworkHostType:
		return soap_in_tt__NetworkHostType(soap, NULL, NULL, "tt:NetworkHostType");
	case SOAP_TYPE_tt__NetworkProtocolType:
		return soap_in_tt__NetworkProtocolType(soap, NULL, NULL, "tt:NetworkProtocolType");
	case SOAP_TYPE_tt__Duplex:
		return soap_in_tt__Duplex(soap, NULL, NULL, "tt:Duplex");
	case SOAP_TYPE_tt__DiscoveryMode:
		return soap_in_tt__DiscoveryMode(soap, NULL, NULL, "tt:DiscoveryMode");
	case SOAP_TYPE_tt__ScopeDefinition:
		return soap_in_tt__ScopeDefinition(soap, NULL, NULL, "tt:ScopeDefinition");
	case SOAP_TYPE_tt__TransportProtocol:
		return soap_in_tt__TransportProtocol(soap, NULL, NULL, "tt:TransportProtocol");
	case SOAP_TYPE_tt__StreamType:
		return soap_in_tt__StreamType(soap, NULL, NULL, "tt:StreamType");
	case SOAP_TYPE_tt__AudioEncoding:
		return soap_in_tt__AudioEncoding(soap, NULL, NULL, "tt:AudioEncoding");
	case SOAP_TYPE_tt__H264Profile:
		return soap_in_tt__H264Profile(soap, NULL, NULL, "tt:H264Profile");
	case SOAP_TYPE_tt__Mpeg4Profile:
		return soap_in_tt__Mpeg4Profile(soap, NULL, NULL, "tt:Mpeg4Profile");
	case SOAP_TYPE_tt__VideoEncoding:
		return soap_in_tt__VideoEncoding(soap, NULL, NULL, "tt:VideoEncoding");
	case SOAP_TYPE_wsa__RelationshipType:
		return soap_in_wsa__RelationshipType(soap, NULL, NULL, "wsa:RelationshipType");
	case SOAP_TYPE_xsd__boolean:
		return soap_in_xsd__boolean(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_wsu__TimestampType:
		return soap_in_wsu__TimestampType(soap, NULL, NULL, "wsu:TimestampType");
	case SOAP_TYPE_wsse__SecurityHeaderType:
		return soap_in_wsse__SecurityHeaderType(soap, NULL, NULL, "wsse:SecurityHeaderType");
	case SOAP_TYPE_wsse__UsernameTokenType:
		return soap_in_wsse__UsernameTokenType(soap, NULL, NULL, "wsse:UsernameTokenType");
	case SOAP_TYPE_wsse__PasswordString:
		return soap_in_wsse__PasswordString(soap, NULL, NULL, "wsse:PasswordString");
	case SOAP_TYPE_d__AppSequenceType:
		return soap_in_d__AppSequenceType(soap, NULL, NULL, "d:AppSequenceType");
	case SOAP_TYPE_d__ScopesType:
		return soap_in_d__ScopesType(soap, NULL, NULL, "d:ScopesType");
	case SOAP_TYPE_d__ResolveType:
		return soap_in_d__ResolveType(soap, NULL, NULL, "d:ResolveType");
	case SOAP_TYPE_d__ProbeMatchType:
		return soap_in_d__ProbeMatchType(soap, NULL, NULL, "d:ProbeMatchType");
	case SOAP_TYPE_d__ProbeMatchesType:
		return soap_in_d__ProbeMatchesType(soap, NULL, NULL, "d:ProbeMatchesType");
	case SOAP_TYPE_d__ProbeType:
		return soap_in_d__ProbeType(soap, NULL, NULL, "d:ProbeType");
	case SOAP_TYPE_d__ByeType:
		return soap_in_d__ByeType(soap, NULL, NULL, "d:ByeType");
	case SOAP_TYPE_d__HelloType:
		return soap_in_d__HelloType(soap, NULL, NULL, "d:HelloType");
	case SOAP_TYPE_trt__StreamingCapabilities:
		return soap_in_trt__StreamingCapabilities(soap, NULL, NULL, "trt:StreamingCapabilities");
	case SOAP_TYPE_trt__ProfileCapabilities:
		return soap_in_trt__ProfileCapabilities(soap, NULL, NULL, "trt:ProfileCapabilities");
	case SOAP_TYPE_trt__Capabilities:
		return soap_in_trt__Capabilities(soap, NULL, NULL, "trt:Capabilities");
	case SOAP_TYPE_wsaw__AttributedQNameType:
		return soap_in_wsaw__AttributedQNameType(soap, NULL, NULL, "wsaw:AttributedQNameType");
	case SOAP_TYPE_wsaw__ServiceNameType:
		return soap_in_wsaw__ServiceNameType(soap, NULL, NULL, "wsaw:ServiceNameType");
	case SOAP_TYPE_tnsacti__IO:
		return soap_in_tnsacti__IO(soap, NULL, NULL, "tnsacti:IO");
	case SOAP_TYPE_tnsacti__MotionDetection:
		return soap_in_tnsacti__MotionDetection(soap, NULL, NULL, "tnsacti:MotionDetection");
	case SOAP_TYPE_tnsacti__VirtualPort:
		return soap_in_tnsacti__VirtualPort(soap, NULL, NULL, "tnsacti:VirtualPort");
	case SOAP_TYPE_tns1__Device:
		return soap_in_tns1__Device(soap, NULL, NULL, "tns1:Device");
	case SOAP_TYPE_tns1__VideoAnalytics:
		return soap_in_tns1__VideoAnalytics(soap, NULL, NULL, "tns1:VideoAnalytics");
	case SOAP_TYPE_tt__EventStream:
		return soap_in_tt__EventStream(soap, NULL, NULL, "tt:EventStream");
	case SOAP_TYPE_tt__Rectangle:
		return soap_in_tt__Rectangle(soap, NULL, NULL, "tt:Rectangle");
	case SOAP_TYPE_tt__ItemListDescription:
		return soap_in_tt__ItemListDescription(soap, NULL, NULL, "tt:ItemListDescription");
	case SOAP_TYPE_tt__MessageDescription:
		return soap_in_tt__MessageDescription(soap, NULL, NULL, "tt:MessageDescription");
	case SOAP_TYPE_tt__ItemList:
		return soap_in_tt__ItemList(soap, NULL, NULL, "tt:ItemList");
	case SOAP_TYPE_tt__WhiteBalance:
		return soap_in_tt__WhiteBalance(soap, NULL, NULL, "tt:WhiteBalance");
	case SOAP_TYPE_tt__WhiteBalanceOptions:
		return soap_in_tt__WhiteBalanceOptions(soap, NULL, NULL, "tt:WhiteBalanceOptions");
	case SOAP_TYPE_tt__ExposureOptions:
		return soap_in_tt__ExposureOptions(soap, NULL, NULL, "tt:ExposureOptions");
	case SOAP_TYPE_tt__FocusOptions:
		return soap_in_tt__FocusOptions(soap, NULL, NULL, "tt:FocusOptions");
	case SOAP_TYPE_tt__BacklightCompensationOptions:
		return soap_in_tt__BacklightCompensationOptions(soap, NULL, NULL, "tt:BacklightCompensationOptions");
	case SOAP_TYPE_tt__WideDynamicRangeOptions:
		return soap_in_tt__WideDynamicRangeOptions(soap, NULL, NULL, "tt:WideDynamicRangeOptions");
	case SOAP_TYPE_tt__ImagingOptions:
		return soap_in_tt__ImagingOptions(soap, NULL, NULL, "tt:ImagingOptions");
	case SOAP_TYPE_tt__BacklightCompensation:
		return soap_in_tt__BacklightCompensation(soap, NULL, NULL, "tt:BacklightCompensation");
	case SOAP_TYPE_tt__WideDynamicRange:
		return soap_in_tt__WideDynamicRange(soap, NULL, NULL, "tt:WideDynamicRange");
	case SOAP_TYPE_tt__Exposure:
		return soap_in_tt__Exposure(soap, NULL, NULL, "tt:Exposure");
	case SOAP_TYPE_tt__ImagingSettings:
		return soap_in_tt__ImagingSettings(soap, NULL, NULL, "tt:ImagingSettings");
	case SOAP_TYPE_tt__FocusConfiguration:
		return soap_in_tt__FocusConfiguration(soap, NULL, NULL, "tt:FocusConfiguration");
	case SOAP_TYPE_tt__PTZMoveStatus:
		return soap_in_tt__PTZMoveStatus(soap, NULL, NULL, "tt:PTZMoveStatus");
	case SOAP_TYPE_tt__PTZPreset:
		return soap_in_tt__PTZPreset(soap, NULL, NULL, "tt:PTZPreset");
	case SOAP_TYPE_tt__Preset:
		return soap_in_tt__Preset(soap, NULL, NULL, "tt:Preset");
	case SOAP_TYPE_tt__PTZStatus:
		return soap_in_tt__PTZStatus(soap, NULL, NULL, "tt:PTZStatus");
	case SOAP_TYPE_tt__PTZSpeed:
		return soap_in_tt__PTZSpeed(soap, NULL, NULL, "tt:PTZSpeed");
	case SOAP_TYPE_tt__PTZVector:
		return soap_in_tt__PTZVector(soap, NULL, NULL, "tt:PTZVector");
	case SOAP_TYPE_tt__Vector1D:
		return soap_in_tt__Vector1D(soap, NULL, NULL, "tt:Vector1D");
	case SOAP_TYPE_tt__Vector2D:
		return soap_in_tt__Vector2D(soap, NULL, NULL, "tt:Vector2D");
	case SOAP_TYPE_tt__Space1DDescription:
		return soap_in_tt__Space1DDescription(soap, NULL, NULL, "tt:Space1DDescription");
	case SOAP_TYPE_tt__Space2DDescription:
		return soap_in_tt__Space2DDescription(soap, NULL, NULL, "tt:Space2DDescription");
	case SOAP_TYPE_tt__PTZSpaces:
		return soap_in_tt__PTZSpaces(soap, NULL, NULL, "tt:PTZSpaces");
	case SOAP_TYPE_tt__ZoomLimits:
		return soap_in_tt__ZoomLimits(soap, NULL, NULL, "tt:ZoomLimits");
	case SOAP_TYPE_tt__PanTiltLimits:
		return soap_in_tt__PanTiltLimits(soap, NULL, NULL, "tt:PanTiltLimits");
	case SOAP_TYPE_tt__PTZConfigurationOptions:
		return soap_in_tt__PTZConfigurationOptions(soap, NULL, NULL, "tt:PTZConfigurationOptions");
	case SOAP_TYPE_tt__PTZConfiguration:
		return soap_in_tt__PTZConfiguration(soap, NULL, NULL, "tt:PTZConfiguration");
	case SOAP_TYPE_tt__PTZNode:
		return soap_in_tt__PTZNode(soap, NULL, NULL, "tt:PTZNode");
	case SOAP_TYPE_tt__RelayOutput:
		return soap_in_tt__RelayOutput(soap, NULL, NULL, "tt:RelayOutput");
	case SOAP_TYPE_tt__RelayOutputSettings:
		return soap_in_tt__RelayOutputSettings(soap, NULL, NULL, "tt:RelayOutputSettings");
	case SOAP_TYPE_tt__User:
		return soap_in_tt__User(soap, NULL, NULL, "tt:User");
	case SOAP_TYPE_tt__TimeZone:
		return soap_in_tt__TimeZone(soap, NULL, NULL, "tt:TimeZone");
	case SOAP_TYPE_tt__Time:
		return soap_in_tt__Time(soap, NULL, NULL, "tt:Time");
	case SOAP_TYPE_tt__Date:
		return soap_in_tt__Date(soap, NULL, NULL, "tt:Date");
	case SOAP_TYPE_tt__DateTime:
		return soap_in_tt__DateTime(soap, NULL, NULL, "tt:DateTime");
	case SOAP_TYPE_tt__SystemDateTime:
		return soap_in_tt__SystemDateTime(soap, NULL, NULL, "tt:SystemDateTime");
	case SOAP_TYPE_tt__SystemLog:
		return soap_in_tt__SystemLog(soap, NULL, NULL, "tt:SystemLog");
	case SOAP_TYPE_tt__AnalyticsDeviceCapabilities:
		return soap_in_tt__AnalyticsDeviceCapabilities(soap, NULL, NULL, "tt:AnalyticsDeviceCapabilities");
	case SOAP_TYPE_tt__ReceiverCapabilities:
		return soap_in_tt__ReceiverCapabilities(soap, NULL, NULL, "tt:ReceiverCapabilities");
	case SOAP_TYPE_tt__ReplayCapabilities:
		return soap_in_tt__ReplayCapabilities(soap, NULL, NULL, "tt:ReplayCapabilities");
	case SOAP_TYPE_tt__SearchCapabilities:
		return soap_in_tt__SearchCapabilities(soap, NULL, NULL, "tt:SearchCapabilities");
	case SOAP_TYPE_tt__RecordingCapabilities:
		return soap_in_tt__RecordingCapabilities(soap, NULL, NULL, "tt:RecordingCapabilities");
	case SOAP_TYPE_tt__DisplayCapabilities:
		return soap_in_tt__DisplayCapabilities(soap, NULL, NULL, "tt:DisplayCapabilities");
	case SOAP_TYPE_tt__DeviceIOCapabilities:
		return soap_in_tt__DeviceIOCapabilities(soap, NULL, NULL, "tt:DeviceIOCapabilities");
	case SOAP_TYPE_tt__PTZCapabilities:
		return soap_in_tt__PTZCapabilities(soap, NULL, NULL, "tt:PTZCapabilities");
	case SOAP_TYPE_tt__ImagingCapabilities:
		return soap_in_tt__ImagingCapabilities(soap, NULL, NULL, "tt:ImagingCapabilities");
	case SOAP_TYPE_tt__OnvifVersion:
		return soap_in_tt__OnvifVersion(soap, NULL, NULL, "tt:OnvifVersion");
	case SOAP_TYPE_tt__SystemCapabilities:
		return soap_in_tt__SystemCapabilities(soap, NULL, NULL, "tt:SystemCapabilities");
	case SOAP_TYPE_tt__SecurityCapabilities:
		return soap_in_tt__SecurityCapabilities(soap, NULL, NULL, "tt:SecurityCapabilities");
	case SOAP_TYPE_tt__NetworkCapabilities:
		return soap_in_tt__NetworkCapabilities(soap, NULL, NULL, "tt:NetworkCapabilities");
	case SOAP_TYPE_tt__ProfileCapabilities:
		return soap_in_tt__ProfileCapabilities(soap, NULL, NULL, "tt:ProfileCapabilities");
	case SOAP_TYPE_tt__RealTimeStreamingCapabilities:
		return soap_in_tt__RealTimeStreamingCapabilities(soap, NULL, NULL, "tt:RealTimeStreamingCapabilities");
	case SOAP_TYPE_tt__MediaCapabilities:
		return soap_in_tt__MediaCapabilities(soap, NULL, NULL, "tt:MediaCapabilities");
	case SOAP_TYPE_tt__IOCapabilities:
		return soap_in_tt__IOCapabilities(soap, NULL, NULL, "tt:IOCapabilities");
	case SOAP_TYPE_tt__EventCapabilities:
		return soap_in_tt__EventCapabilities(soap, NULL, NULL, "tt:EventCapabilities");
	case SOAP_TYPE_tt__DeviceCapabilities:
		return soap_in_tt__DeviceCapabilities(soap, NULL, NULL, "tt:DeviceCapabilities");
	case SOAP_TYPE_tt__AnalyticsCapabilities:
		return soap_in_tt__AnalyticsCapabilities(soap, NULL, NULL, "tt:AnalyticsCapabilities");
	case SOAP_TYPE_tt__CapabilitiesExtension:
		return soap_in_tt__CapabilitiesExtension(soap, NULL, NULL, "tt:CapabilitiesExtension");
	case SOAP_TYPE_tt__Capabilities:
		return soap_in_tt__Capabilities(soap, NULL, NULL, "tt:Capabilities");
	case SOAP_TYPE_tt__NetworkZeroConfiguration:
		return soap_in_tt__NetworkZeroConfiguration(soap, NULL, NULL, "tt:NetworkZeroConfiguration");
	case SOAP_TYPE_tt__NetworkGateway:
		return soap_in_tt__NetworkGateway(soap, NULL, NULL, "tt:NetworkGateway");
	case SOAP_TYPE_tt__IPv4NetworkInterfaceSetConfiguration:
		return soap_in_tt__IPv4NetworkInterfaceSetConfiguration(soap, NULL, NULL, "tt:IPv4NetworkInterfaceSetConfiguration");
	case SOAP_TYPE_tt__NetworkInterfaceSetConfigurationExtension:
		return soap_in_tt__NetworkInterfaceSetConfigurationExtension(soap, NULL, NULL, "tt:NetworkInterfaceSetConfigurationExtension");
	case SOAP_TYPE_tt__NetworkInterfaceSetConfiguration:
		return soap_in_tt__NetworkInterfaceSetConfiguration(soap, NULL, NULL, "tt:NetworkInterfaceSetConfiguration");
	case SOAP_TYPE_tt__DynamicDNSInformation:
		return soap_in_tt__DynamicDNSInformation(soap, NULL, NULL, "tt:DynamicDNSInformation");
	case SOAP_TYPE_tt__NTPInformation:
		return soap_in_tt__NTPInformation(soap, NULL, NULL, "tt:NTPInformation");
	case SOAP_TYPE_tt__DNSInformation:
		return soap_in_tt__DNSInformation(soap, NULL, NULL, "tt:DNSInformation");
	case SOAP_TYPE_tt__HostnameInformation:
		return soap_in_tt__HostnameInformation(soap, NULL, NULL, "tt:HostnameInformation");
	case SOAP_TYPE_tt__PrefixedIPv4Address:
		return soap_in_tt__PrefixedIPv4Address(soap, NULL, NULL, "tt:PrefixedIPv4Address");
	case SOAP_TYPE_tt__IPAddress:
		return soap_in_tt__IPAddress(soap, NULL, NULL, "tt:IPAddress");
	case SOAP_TYPE_tt__NetworkHost:
		return soap_in_tt__NetworkHost(soap, NULL, NULL, "tt:NetworkHost");
	case SOAP_TYPE_tt__NetworkProtocol:
		return soap_in_tt__NetworkProtocol(soap, NULL, NULL, "tt:NetworkProtocol");
	case SOAP_TYPE_tt__IPv4Configuration:
		return soap_in_tt__IPv4Configuration(soap, NULL, NULL, "tt:IPv4Configuration");
	case SOAP_TYPE_tt__IPv4NetworkInterface:
		return soap_in_tt__IPv4NetworkInterface(soap, NULL, NULL, "tt:IPv4NetworkInterface");
	case SOAP_TYPE_tt__NetworkInterfaceInfo:
		return soap_in_tt__NetworkInterfaceInfo(soap, NULL, NULL, "tt:NetworkInterfaceInfo");
	case SOAP_TYPE_tt__NetworkInterfaceConnectionSetting:
		return soap_in_tt__NetworkInterfaceConnectionSetting(soap, NULL, NULL, "tt:NetworkInterfaceConnectionSetting");
	case SOAP_TYPE_tt__NetworkInterfaceLink:
		return soap_in_tt__NetworkInterfaceLink(soap, NULL, NULL, "tt:NetworkInterfaceLink");
	case SOAP_TYPE_tt__NetworkInterfaceExtension2:
		return soap_in_tt__NetworkInterfaceExtension2(soap, NULL, NULL, "tt:NetworkInterfaceExtension2");
	case SOAP_TYPE_tt__Dot3Configuration:
		return soap_in_tt__Dot3Configuration(soap, NULL, NULL, "tt:Dot3Configuration");
	case SOAP_TYPE_tt__NetworkInterfaceExtension:
		return soap_in_tt__NetworkInterfaceExtension(soap, NULL, NULL, "tt:NetworkInterfaceExtension");
	case SOAP_TYPE_tt__NetworkInterface:
		return soap_in_tt__NetworkInterface(soap, NULL, NULL, "tt:NetworkInterface");
	case SOAP_TYPE_tt__Scope:
		return soap_in_tt__Scope(soap, NULL, NULL, "tt:Scope");
	case SOAP_TYPE_tt__MediaUri:
		return soap_in_tt__MediaUri(soap, NULL, NULL, "tt:MediaUri");
	case SOAP_TYPE_tt__Transport:
		return soap_in_tt__Transport(soap, NULL, NULL, "tt:Transport");
	case SOAP_TYPE_tt__StreamSetup:
		return soap_in_tt__StreamSetup(soap, NULL, NULL, "tt:StreamSetup");
	case SOAP_TYPE_tt__MulticastConfiguration:
		return soap_in_tt__MulticastConfiguration(soap, NULL, NULL, "tt:MulticastConfiguration");
	case SOAP_TYPE_tt__PTZStatusFilterOptions:
		return soap_in_tt__PTZStatusFilterOptions(soap, NULL, NULL, "tt:PTZStatusFilterOptions");
	case SOAP_TYPE_tt__MetadataConfigurationOptions:
		return soap_in_tt__MetadataConfigurationOptions(soap, NULL, NULL, "tt:MetadataConfigurationOptions");
	case SOAP_TYPE_tt__EventSubscription:
		return soap_in_tt__EventSubscription(soap, NULL, NULL, "tt:EventSubscription");
	case SOAP_TYPE_tt__MetadataConfiguration:
		return soap_in_tt__MetadataConfiguration(soap, NULL, NULL, "tt:MetadataConfiguration");
	case SOAP_TYPE_tt__AudioEncoderConfigurationOption:
		return soap_in_tt__AudioEncoderConfigurationOption(soap, NULL, NULL, "tt:AudioEncoderConfigurationOption");
	case SOAP_TYPE_tt__AudioEncoderConfigurationOptions:
		return soap_in_tt__AudioEncoderConfigurationOptions(soap, NULL, NULL, "tt:AudioEncoderConfigurationOptions");
	case SOAP_TYPE_tt__AudioEncoderConfiguration:
		return soap_in_tt__AudioEncoderConfiguration(soap, NULL, NULL, "tt:AudioEncoderConfiguration");
	case SOAP_TYPE_tt__AudioSourceConfigurationOptions:
		return soap_in_tt__AudioSourceConfigurationOptions(soap, NULL, NULL, "tt:AudioSourceConfigurationOptions");
	case SOAP_TYPE_tt__AudioSourceConfiguration:
		return soap_in_tt__AudioSourceConfiguration(soap, NULL, NULL, "tt:AudioSourceConfiguration");
	case SOAP_TYPE_tt__H264Options:
		return soap_in_tt__H264Options(soap, NULL, NULL, "tt:H264Options");
	case SOAP_TYPE_tt__Mpeg4Options:
		return soap_in_tt__Mpeg4Options(soap, NULL, NULL, "tt:Mpeg4Options");
	case SOAP_TYPE_tt__JpegOptions:
		return soap_in_tt__JpegOptions(soap, NULL, NULL, "tt:JpegOptions");
	case SOAP_TYPE_tt__VideoEncoderConfigurationOptions:
		return soap_in_tt__VideoEncoderConfigurationOptions(soap, NULL, NULL, "tt:VideoEncoderConfigurationOptions");
	case SOAP_TYPE_tt__H264Configuration:
		return soap_in_tt__H264Configuration(soap, NULL, NULL, "tt:H264Configuration");
	case SOAP_TYPE_tt__Mpeg4Configuration:
		return soap_in_tt__Mpeg4Configuration(soap, NULL, NULL, "tt:Mpeg4Configuration");
	case SOAP_TYPE_tt__VideoRateControl:
		return soap_in_tt__VideoRateControl(soap, NULL, NULL, "tt:VideoRateControl");
	case SOAP_TYPE_tt__VideoResolution:
		return soap_in_tt__VideoResolution(soap, NULL, NULL, "tt:VideoResolution");
	case SOAP_TYPE_tt__VideoEncoderConfiguration:
		return soap_in_tt__VideoEncoderConfiguration(soap, NULL, NULL, "tt:VideoEncoderConfiguration");
	case SOAP_TYPE_tt__VideoSourceConfigurationOptions:
		return soap_in_tt__VideoSourceConfigurationOptions(soap, NULL, NULL, "tt:VideoSourceConfigurationOptions");
	case SOAP_TYPE_tt__VideoSourceConfiguration:
		return soap_in_tt__VideoSourceConfiguration(soap, NULL, NULL, "tt:VideoSourceConfiguration");
	case SOAP_TYPE_tt__ConfigurationEntity:
		return soap_in_tt__ConfigurationEntity(soap, NULL, NULL, "tt:ConfigurationEntity");
	case SOAP_TYPE_tt__Profile:
		return soap_in_tt__Profile(soap, NULL, NULL, "tt:Profile");
	case SOAP_TYPE_tt__AudioSource:
		return soap_in_tt__AudioSource(soap, NULL, NULL, "tt:AudioSource");
	case SOAP_TYPE_tt__VideoSource:
		return soap_in_tt__VideoSource(soap, NULL, NULL, "tt:VideoSource");
	case SOAP_TYPE_tt__IntList:
		return soap_in_tt__IntList(soap, NULL, NULL, "tt:IntList");
	case SOAP_TYPE_tt__DurationRange:
		return soap_in_tt__DurationRange(soap, NULL, NULL, "tt:DurationRange");
	case SOAP_TYPE_tt__FloatRange:
		return soap_in_tt__FloatRange(soap, NULL, NULL, "tt:FloatRange");
	case SOAP_TYPE_tt__IntRange:
		return soap_in_tt__IntRange(soap, NULL, NULL, "tt:IntRange");
	case SOAP_TYPE_tt__IntRectangleRange:
		return soap_in_tt__IntRectangleRange(soap, NULL, NULL, "tt:IntRectangleRange");
	case SOAP_TYPE_tt__IntRectangle:
		return soap_in_tt__IntRectangle(soap, NULL, NULL, "tt:IntRectangle");
	case SOAP_TYPE_tt__DeviceEntity:
		return soap_in_tt__DeviceEntity(soap, NULL, NULL, "tt:DeviceEntity");
	case SOAP_TYPE_wsr__ResourceUnknownFaultType:
		return soap_in_wsr__ResourceUnknownFaultType(soap, NULL, NULL, "wsr:ResourceUnknownFaultType");
	case SOAP_TYPE_wstop__TopicSetType:
		return soap_in_wstop__TopicSetType(soap, NULL, NULL, "wstop:TopicSetType");
	case SOAP_TYPE_wstop__QueryExpressionType:
		return soap_in_wstop__QueryExpressionType(soap, NULL, NULL, "wstop:QueryExpressionType");
	case SOAP_TYPE_wstop__ExtensibleDocumented:
		return soap_in_wstop__ExtensibleDocumented(soap, NULL, NULL, "wstop:ExtensibleDocumented");
	case SOAP_TYPE_wstop__Documentation:
		return soap_in_wstop__Documentation(soap, NULL, NULL, "wstop:Documentation");
	case SOAP_TYPE_wsa__AttributedURIType:
		return soap_in_wsa__AttributedURIType(soap, NULL, NULL, "wsa:AttributedURIType");
	case SOAP_TYPE_wsa__RelatesToType:
		return soap_in_wsa__RelatesToType(soap, NULL, NULL, "wsa:RelatesToType");
	case SOAP_TYPE_wsa__MetadataType:
		return soap_in_wsa__MetadataType(soap, NULL, NULL, "wsa:MetadataType");
	case SOAP_TYPE_wsa__ReferenceParametersType:
		return soap_in_wsa__ReferenceParametersType(soap, NULL, NULL, "wsa:ReferenceParametersType");
	case SOAP_TYPE_wsa__EndpointReferenceType:
		return soap_in_wsa__EndpointReferenceType(soap, NULL, NULL, "wsa:EndpointReferenceType");
	case SOAP_TYPE_wsbf__BaseFaultType:
		return soap_in_wsbf__BaseFaultType(soap, NULL, NULL, "wsbf:BaseFaultType");
	case SOAP_TYPE_wsnt__UnableToDestroySubscriptionFaultType:
		return soap_in_wsnt__UnableToDestroySubscriptionFaultType(soap, NULL, NULL, "wsnt:UnableToDestroySubscriptionFaultType");
	case SOAP_TYPE_wsnt__NotificationMessageHolderType:
		return soap_in_wsnt__NotificationMessageHolderType(soap, NULL, NULL, "wsnt:NotificationMessageHolderType");
	case SOAP_TYPE_wsnt__FilterType:
		return soap_in_wsnt__FilterType(soap, NULL, NULL, "wsnt:FilterType");
	case SOAP_TYPE_wsnt__TopicExpressionType:
		return soap_in_wsnt__TopicExpressionType(soap, NULL, NULL, "wsnt:TopicExpressionType");
	case SOAP_TYPE_wsnt__QueryExpressionType:
		return soap_in_wsnt__QueryExpressionType(soap, NULL, NULL, "wsnt:QueryExpressionType");
	case SOAP_TYPE_wsadis__AttributedURI:
		return soap_in_wsadis__AttributedURI(soap, NULL, NULL, "wsadis:AttributedURI");
	case SOAP_TYPE_wsadis__AttributedQName:
		return soap_in_wsadis__AttributedQName(soap, NULL, NULL, "wsadis:AttributedQName");
	case SOAP_TYPE_wsadis__Relationship:
		return soap_in_wsadis__Relationship(soap, NULL, NULL, "wsadis:Relationship");
	case SOAP_TYPE_wsadis__ServiceNameType:
		return soap_in_wsadis__ServiceNameType(soap, NULL, NULL, "wsadis:ServiceNameType");
	case SOAP_TYPE_wsadis__ReferenceParametersType:
		return soap_in_wsadis__ReferenceParametersType(soap, NULL, NULL, "wsadis:ReferenceParametersType");
	case SOAP_TYPE_wsadis__ReferencePropertiesType:
		return soap_in_wsadis__ReferencePropertiesType(soap, NULL, NULL, "wsadis:ReferencePropertiesType");
	case SOAP_TYPE_wsadis__EndpointReferenceType:
		return soap_in_wsadis__EndpointReferenceType(soap, NULL, NULL, "wsadis:EndpointReferenceType");
	case SOAP_TYPE_PointerTo_wsse__Security:
		return soap_in_PointerTo_wsse__Security(soap, NULL, NULL, "wsse:Security");
	case SOAP_TYPE_PointerTo_d__AppSequence:
		return soap_in_PointerTo_d__AppSequence(soap, NULL, NULL, "d:AppSequence");
	case SOAP_TYPE_PointerTo_wsa__FaultTo:
		return soap_in_PointerTo_wsa__FaultTo(soap, NULL, NULL, "wsa:FaultTo");
	case SOAP_TYPE_PointerTo_wsa__ReplyTo:
		return soap_in_PointerTo_wsa__ReplyTo(soap, NULL, NULL, "wsa:ReplyTo");
	case SOAP_TYPE_PointerTo_wsa__From:
		return soap_in_PointerTo_wsa__From(soap, NULL, NULL, "wsa:From");
	case SOAP_TYPE_PointerTo_wsa__RelatesTo:
		return soap_in_PointerTo_wsa__RelatesTo(soap, NULL, NULL, "wsa:RelatesTo");
	case SOAP_TYPE_PointerTo_trt__GetSnapshotUriResponse:
		return soap_in_PointerTo_trt__GetSnapshotUriResponse(soap, NULL, NULL, "trt:GetSnapshotUriResponse");
	case SOAP_TYPE_PointerTo_trt__GetSnapshotUri:
		return soap_in_PointerTo_trt__GetSnapshotUri(soap, NULL, NULL, "trt:GetSnapshotUri");
	case SOAP_TYPE_PointerTo_trt__SetSynchronizationPointResponse:
		return soap_in_PointerTo_trt__SetSynchronizationPointResponse(soap, NULL, NULL, "trt:SetSynchronizationPointResponse");
	case SOAP_TYPE_PointerTo_trt__SetSynchronizationPoint:
		return soap_in_PointerTo_trt__SetSynchronizationPoint(soap, NULL, NULL, "trt:SetSynchronizationPoint");
	case SOAP_TYPE_PointerTo_trt__GetStreamUriResponse:
		return soap_in_PointerTo_trt__GetStreamUriResponse(soap, NULL, NULL, "trt:GetStreamUriResponse");
	case SOAP_TYPE_PointerTo_trt__GetStreamUri:
		return soap_in_PointerTo_trt__GetStreamUri(soap, NULL, NULL, "trt:GetStreamUri");
	case SOAP_TYPE_PointerTo_trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse:
		return soap_in_PointerTo_trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse(soap, NULL, NULL, "trt:GetGuaranteedNumberOfVideoEncoderInstancesResponse");
	case SOAP_TYPE_PointerTo_trt__GetGuaranteedNumberOfVideoEncoderInstances:
		return soap_in_PointerTo_trt__GetGuaranteedNumberOfVideoEncoderInstances(soap, NULL, NULL, "trt:GetGuaranteedNumberOfVideoEncoderInstances");
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfigurationOptionsResponse:
		return soap_in_PointerTo_trt__GetMetadataConfigurationOptionsResponse(soap, NULL, NULL, "trt:GetMetadataConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfigurationOptions:
		return soap_in_PointerTo_trt__GetMetadataConfigurationOptions(soap, NULL, NULL, "trt:GetMetadataConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationOptionsResponse:
		return soap_in_PointerTo_trt__GetAudioEncoderConfigurationOptionsResponse(soap, NULL, NULL, "trt:GetAudioEncoderConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationOptions:
		return soap_in_PointerTo_trt__GetAudioEncoderConfigurationOptions(soap, NULL, NULL, "trt:GetAudioEncoderConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationOptionsResponse:
		return soap_in_PointerTo_trt__GetAudioSourceConfigurationOptionsResponse(soap, NULL, NULL, "trt:GetAudioSourceConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationOptions:
		return soap_in_PointerTo_trt__GetAudioSourceConfigurationOptions(soap, NULL, NULL, "trt:GetAudioSourceConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationOptionsResponse:
		return soap_in_PointerTo_trt__GetVideoEncoderConfigurationOptionsResponse(soap, NULL, NULL, "trt:GetVideoEncoderConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationOptions:
		return soap_in_PointerTo_trt__GetVideoEncoderConfigurationOptions(soap, NULL, NULL, "trt:GetVideoEncoderConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationOptionsResponse:
		return soap_in_PointerTo_trt__GetVideoSourceConfigurationOptionsResponse(soap, NULL, NULL, "trt:GetVideoSourceConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationOptions:
		return soap_in_PointerTo_trt__GetVideoSourceConfigurationOptions(soap, NULL, NULL, "trt:GetVideoSourceConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__SetMetadataConfigurationResponse:
		return soap_in_PointerTo_trt__SetMetadataConfigurationResponse(soap, NULL, NULL, "trt:SetMetadataConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetMetadataConfiguration:
		return soap_in_PointerTo_trt__SetMetadataConfiguration(soap, NULL, NULL, "trt:SetMetadataConfiguration");
	case SOAP_TYPE_PointerTo_trt__SetAudioEncoderConfigurationResponse:
		return soap_in_PointerTo_trt__SetAudioEncoderConfigurationResponse(soap, NULL, NULL, "trt:SetAudioEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetAudioEncoderConfiguration:
		return soap_in_PointerTo_trt__SetAudioEncoderConfiguration(soap, NULL, NULL, "trt:SetAudioEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__SetAudioSourceConfigurationResponse:
		return soap_in_PointerTo_trt__SetAudioSourceConfigurationResponse(soap, NULL, NULL, "trt:SetAudioSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetAudioSourceConfiguration:
		return soap_in_PointerTo_trt__SetAudioSourceConfiguration(soap, NULL, NULL, "trt:SetAudioSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__SetVideoEncoderConfigurationResponse:
		return soap_in_PointerTo_trt__SetVideoEncoderConfigurationResponse(soap, NULL, NULL, "trt:SetVideoEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetVideoEncoderConfiguration:
		return soap_in_PointerTo_trt__SetVideoEncoderConfiguration(soap, NULL, NULL, "trt:SetVideoEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__SetVideoSourceConfigurationResponse:
		return soap_in_PointerTo_trt__SetVideoSourceConfigurationResponse(soap, NULL, NULL, "trt:SetVideoSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetVideoSourceConfiguration:
		return soap_in_PointerTo_trt__SetVideoSourceConfiguration(soap, NULL, NULL, "trt:SetVideoSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleMetadataConfigurationsResponse:
		return soap_in_PointerTo_trt__GetCompatibleMetadataConfigurationsResponse(soap, NULL, NULL, "trt:GetCompatibleMetadataConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleMetadataConfigurations:
		return soap_in_PointerTo_trt__GetCompatibleMetadataConfigurations(soap, NULL, NULL, "trt:GetCompatibleMetadataConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioSourceConfigurationsResponse:
		return soap_in_PointerTo_trt__GetCompatibleAudioSourceConfigurationsResponse(soap, NULL, NULL, "trt:GetCompatibleAudioSourceConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioSourceConfigurations:
		return soap_in_PointerTo_trt__GetCompatibleAudioSourceConfigurations(soap, NULL, NULL, "trt:GetCompatibleAudioSourceConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioEncoderConfigurationsResponse:
		return soap_in_PointerTo_trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, NULL, NULL, "trt:GetCompatibleAudioEncoderConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioEncoderConfigurations:
		return soap_in_PointerTo_trt__GetCompatibleAudioEncoderConfigurations(soap, NULL, NULL, "trt:GetCompatibleAudioEncoderConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoSourceConfigurationsResponse:
		return soap_in_PointerTo_trt__GetCompatibleVideoSourceConfigurationsResponse(soap, NULL, NULL, "trt:GetCompatibleVideoSourceConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoSourceConfigurations:
		return soap_in_PointerTo_trt__GetCompatibleVideoSourceConfigurations(soap, NULL, NULL, "trt:GetCompatibleVideoSourceConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoEncoderConfigurationsResponse:
		return soap_in_PointerTo_trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, NULL, NULL, "trt:GetCompatibleVideoEncoderConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoEncoderConfigurations:
		return soap_in_PointerTo_trt__GetCompatibleVideoEncoderConfigurations(soap, NULL, NULL, "trt:GetCompatibleVideoEncoderConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfigurationResponse:
		return soap_in_PointerTo_trt__GetMetadataConfigurationResponse(soap, NULL, NULL, "trt:GetMetadataConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfiguration:
		return soap_in_PointerTo_trt__GetMetadataConfiguration(soap, NULL, NULL, "trt:GetMetadataConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationResponse:
		return soap_in_PointerTo_trt__GetAudioEncoderConfigurationResponse(soap, NULL, NULL, "trt:GetAudioEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfiguration:
		return soap_in_PointerTo_trt__GetAudioEncoderConfiguration(soap, NULL, NULL, "trt:GetAudioEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationResponse:
		return soap_in_PointerTo_trt__GetAudioSourceConfigurationResponse(soap, NULL, NULL, "trt:GetAudioSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfiguration:
		return soap_in_PointerTo_trt__GetAudioSourceConfiguration(soap, NULL, NULL, "trt:GetAudioSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationResponse:
		return soap_in_PointerTo_trt__GetVideoEncoderConfigurationResponse(soap, NULL, NULL, "trt:GetVideoEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfiguration:
		return soap_in_PointerTo_trt__GetVideoEncoderConfiguration(soap, NULL, NULL, "trt:GetVideoEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationResponse:
		return soap_in_PointerTo_trt__GetVideoSourceConfigurationResponse(soap, NULL, NULL, "trt:GetVideoSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfiguration:
		return soap_in_PointerTo_trt__GetVideoSourceConfiguration(soap, NULL, NULL, "trt:GetVideoSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfigurationsResponse:
		return soap_in_PointerTo_trt__GetMetadataConfigurationsResponse(soap, NULL, NULL, "trt:GetMetadataConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfigurations:
		return soap_in_PointerTo_trt__GetMetadataConfigurations(soap, NULL, NULL, "trt:GetMetadataConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationsResponse:
		return soap_in_PointerTo_trt__GetAudioEncoderConfigurationsResponse(soap, NULL, NULL, "trt:GetAudioEncoderConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurations:
		return soap_in_PointerTo_trt__GetAudioEncoderConfigurations(soap, NULL, NULL, "trt:GetAudioEncoderConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationsResponse:
		return soap_in_PointerTo_trt__GetAudioSourceConfigurationsResponse(soap, NULL, NULL, "trt:GetAudioSourceConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurations:
		return soap_in_PointerTo_trt__GetAudioSourceConfigurations(soap, NULL, NULL, "trt:GetAudioSourceConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationsResponse:
		return soap_in_PointerTo_trt__GetVideoEncoderConfigurationsResponse(soap, NULL, NULL, "trt:GetVideoEncoderConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurations:
		return soap_in_PointerTo_trt__GetVideoEncoderConfigurations(soap, NULL, NULL, "trt:GetVideoEncoderConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationsResponse:
		return soap_in_PointerTo_trt__GetVideoSourceConfigurationsResponse(soap, NULL, NULL, "trt:GetVideoSourceConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurations:
		return soap_in_PointerTo_trt__GetVideoSourceConfigurations(soap, NULL, NULL, "trt:GetVideoSourceConfigurations");
	case SOAP_TYPE_PointerTo_trt__DeleteProfileResponse:
		return soap_in_PointerTo_trt__DeleteProfileResponse(soap, NULL, NULL, "trt:DeleteProfileResponse");
	case SOAP_TYPE_PointerTo_trt__DeleteProfile:
		return soap_in_PointerTo_trt__DeleteProfile(soap, NULL, NULL, "trt:DeleteProfile");
	case SOAP_TYPE_PointerTo_trt__RemoveMetadataConfigurationResponse:
		return soap_in_PointerTo_trt__RemoveMetadataConfigurationResponse(soap, NULL, NULL, "trt:RemoveMetadataConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveMetadataConfiguration:
		return soap_in_PointerTo_trt__RemoveMetadataConfiguration(soap, NULL, NULL, "trt:RemoveMetadataConfiguration");
	case SOAP_TYPE_PointerTo_trt__RemovePTZConfigurationResponse:
		return soap_in_PointerTo_trt__RemovePTZConfigurationResponse(soap, NULL, NULL, "trt:RemovePTZConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemovePTZConfiguration:
		return soap_in_PointerTo_trt__RemovePTZConfiguration(soap, NULL, NULL, "trt:RemovePTZConfiguration");
	case SOAP_TYPE_PointerTo_trt__RemoveAudioSourceConfigurationResponse:
		return soap_in_PointerTo_trt__RemoveAudioSourceConfigurationResponse(soap, NULL, NULL, "trt:RemoveAudioSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveAudioSourceConfiguration:
		return soap_in_PointerTo_trt__RemoveAudioSourceConfiguration(soap, NULL, NULL, "trt:RemoveAudioSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__RemoveAudioEncoderConfigurationResponse:
		return soap_in_PointerTo_trt__RemoveAudioEncoderConfigurationResponse(soap, NULL, NULL, "trt:RemoveAudioEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveAudioEncoderConfiguration:
		return soap_in_PointerTo_trt__RemoveAudioEncoderConfiguration(soap, NULL, NULL, "trt:RemoveAudioEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__RemoveVideoSourceConfigurationResponse:
		return soap_in_PointerTo_trt__RemoveVideoSourceConfigurationResponse(soap, NULL, NULL, "trt:RemoveVideoSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveVideoSourceConfiguration:
		return soap_in_PointerTo_trt__RemoveVideoSourceConfiguration(soap, NULL, NULL, "trt:RemoveVideoSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__RemoveVideoEncoderConfigurationResponse:
		return soap_in_PointerTo_trt__RemoveVideoEncoderConfigurationResponse(soap, NULL, NULL, "trt:RemoveVideoEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveVideoEncoderConfiguration:
		return soap_in_PointerTo_trt__RemoveVideoEncoderConfiguration(soap, NULL, NULL, "trt:RemoveVideoEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddMetadataConfigurationResponse:
		return soap_in_PointerTo_trt__AddMetadataConfigurationResponse(soap, NULL, NULL, "trt:AddMetadataConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddMetadataConfiguration:
		return soap_in_PointerTo_trt__AddMetadataConfiguration(soap, NULL, NULL, "trt:AddMetadataConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddPTZConfigurationResponse:
		return soap_in_PointerTo_trt__AddPTZConfigurationResponse(soap, NULL, NULL, "trt:AddPTZConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddPTZConfiguration:
		return soap_in_PointerTo_trt__AddPTZConfiguration(soap, NULL, NULL, "trt:AddPTZConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddAudioSourceConfigurationResponse:
		return soap_in_PointerTo_trt__AddAudioSourceConfigurationResponse(soap, NULL, NULL, "trt:AddAudioSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddAudioSourceConfiguration:
		return soap_in_PointerTo_trt__AddAudioSourceConfiguration(soap, NULL, NULL, "trt:AddAudioSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddAudioEncoderConfigurationResponse:
		return soap_in_PointerTo_trt__AddAudioEncoderConfigurationResponse(soap, NULL, NULL, "trt:AddAudioEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddAudioEncoderConfiguration:
		return soap_in_PointerTo_trt__AddAudioEncoderConfiguration(soap, NULL, NULL, "trt:AddAudioEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddVideoSourceConfigurationResponse:
		return soap_in_PointerTo_trt__AddVideoSourceConfigurationResponse(soap, NULL, NULL, "trt:AddVideoSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddVideoSourceConfiguration:
		return soap_in_PointerTo_trt__AddVideoSourceConfiguration(soap, NULL, NULL, "trt:AddVideoSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddVideoEncoderConfigurationResponse:
		return soap_in_PointerTo_trt__AddVideoEncoderConfigurationResponse(soap, NULL, NULL, "trt:AddVideoEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddVideoEncoderConfiguration:
		return soap_in_PointerTo_trt__AddVideoEncoderConfiguration(soap, NULL, NULL, "trt:AddVideoEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetProfilesResponse:
		return soap_in_PointerTo_trt__GetProfilesResponse(soap, NULL, NULL, "trt:GetProfilesResponse");
	case SOAP_TYPE_PointerTo_trt__GetProfiles:
		return soap_in_PointerTo_trt__GetProfiles(soap, NULL, NULL, "trt:GetProfiles");
	case SOAP_TYPE_PointerTo_trt__GetProfileResponse:
		return soap_in_PointerTo_trt__GetProfileResponse(soap, NULL, NULL, "trt:GetProfileResponse");
	case SOAP_TYPE_PointerTo_trt__GetProfile:
		return soap_in_PointerTo_trt__GetProfile(soap, NULL, NULL, "trt:GetProfile");
	case SOAP_TYPE_PointerTo_trt__CreateProfileResponse:
		return soap_in_PointerTo_trt__CreateProfileResponse(soap, NULL, NULL, "trt:CreateProfileResponse");
	case SOAP_TYPE_PointerTo_trt__CreateProfile:
		return soap_in_PointerTo_trt__CreateProfile(soap, NULL, NULL, "trt:CreateProfile");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourcesResponse:
		return soap_in_PointerTo_trt__GetAudioSourcesResponse(soap, NULL, NULL, "trt:GetAudioSourcesResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioSources:
		return soap_in_PointerTo_trt__GetAudioSources(soap, NULL, NULL, "trt:GetAudioSources");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourcesResponse:
		return soap_in_PointerTo_trt__GetVideoSourcesResponse(soap, NULL, NULL, "trt:GetVideoSourcesResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoSources:
		return soap_in_PointerTo_trt__GetVideoSources(soap, NULL, NULL, "trt:GetVideoSources");
	case SOAP_TYPE_PointerTo_tptz__StopResponse:
		return soap_in_PointerTo_tptz__StopResponse(soap, NULL, NULL, "tptz:StopResponse");
	case SOAP_TYPE_PointerTo_tptz__Stop:
		return soap_in_PointerTo_tptz__Stop(soap, NULL, NULL, "tptz:Stop");
	case SOAP_TYPE_PointerTo_tptz__AbsoluteMoveResponse:
		return soap_in_PointerTo_tptz__AbsoluteMoveResponse(soap, NULL, NULL, "tptz:AbsoluteMoveResponse");
	case SOAP_TYPE_PointerTo_tptz__AbsoluteMove:
		return soap_in_PointerTo_tptz__AbsoluteMove(soap, NULL, NULL, "tptz:AbsoluteMove");
	case SOAP_TYPE_PointerTo_tptz__ContinuousMoveResponse:
		return soap_in_PointerTo_tptz__ContinuousMoveResponse(soap, NULL, NULL, "tptz:ContinuousMoveResponse");
	case SOAP_TYPE_PointerTo_tptz__ContinuousMove:
		return soap_in_PointerTo_tptz__ContinuousMove(soap, NULL, NULL, "tptz:ContinuousMove");
	case SOAP_TYPE_PointerTo_tptz__SetHomePositionResponse:
		return soap_in_PointerTo_tptz__SetHomePositionResponse(soap, NULL, NULL, "tptz:SetHomePositionResponse");
	case SOAP_TYPE_PointerTo_tptz__SetHomePosition:
		return soap_in_PointerTo_tptz__SetHomePosition(soap, NULL, NULL, "tptz:SetHomePosition");
	case SOAP_TYPE_PointerTo_tptz__GotoHomePositionResponse:
		return soap_in_PointerTo_tptz__GotoHomePositionResponse(soap, NULL, NULL, "tptz:GotoHomePositionResponse");
	case SOAP_TYPE_PointerTo_tptz__GotoHomePosition:
		return soap_in_PointerTo_tptz__GotoHomePosition(soap, NULL, NULL, "tptz:GotoHomePosition");
	case SOAP_TYPE_PointerTo_tptz__GetConfigurationOptionsResponse:
		return soap_in_PointerTo_tptz__GetConfigurationOptionsResponse(soap, NULL, NULL, "tptz:GetConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_tptz__GetConfigurationOptions:
		return soap_in_PointerTo_tptz__GetConfigurationOptions(soap, NULL, NULL, "tptz:GetConfigurationOptions");
	case SOAP_TYPE_PointerTo_tptz__SetConfigurationResponse:
		return soap_in_PointerTo_tptz__SetConfigurationResponse(soap, NULL, NULL, "tptz:SetConfigurationResponse");
	case SOAP_TYPE_PointerTo_tptz__SetConfiguration:
		return soap_in_PointerTo_tptz__SetConfiguration(soap, NULL, NULL, "tptz:SetConfiguration");
	case SOAP_TYPE_PointerTo_tptz__GetNodeResponse:
		return soap_in_PointerTo_tptz__GetNodeResponse(soap, NULL, NULL, "tptz:GetNodeResponse");
	case SOAP_TYPE_PointerTo_tptz__GetNode:
		return soap_in_PointerTo_tptz__GetNode(soap, NULL, NULL, "tptz:GetNode");
	case SOAP_TYPE_PointerTo_tptz__GetNodesResponse:
		return soap_in_PointerTo_tptz__GetNodesResponse(soap, NULL, NULL, "tptz:GetNodesResponse");
	case SOAP_TYPE_PointerTo_tptz__GetNodes:
		return soap_in_PointerTo_tptz__GetNodes(soap, NULL, NULL, "tptz:GetNodes");
	case SOAP_TYPE_PointerTo_tptz__GetConfigurationResponse:
		return soap_in_PointerTo_tptz__GetConfigurationResponse(soap, NULL, NULL, "tptz:GetConfigurationResponse");
	case SOAP_TYPE_PointerTo_tptz__GetConfiguration:
		return soap_in_PointerTo_tptz__GetConfiguration(soap, NULL, NULL, "tptz:GetConfiguration");
	case SOAP_TYPE_PointerTo_tptz__GetStatusResponse:
		return soap_in_PointerTo_tptz__GetStatusResponse(soap, NULL, NULL, "tptz:GetStatusResponse");
	case SOAP_TYPE_PointerTo_tptz__GetStatus:
		return soap_in_PointerTo_tptz__GetStatus(soap, NULL, NULL, "tptz:GetStatus");
	case SOAP_TYPE_PointerTo_tptz__GotoPresetResponse:
		return soap_in_PointerTo_tptz__GotoPresetResponse(soap, NULL, NULL, "tptz:GotoPresetResponse");
	case SOAP_TYPE_PointerTo_tptz__GotoPreset:
		return soap_in_PointerTo_tptz__GotoPreset(soap, NULL, NULL, "tptz:GotoPreset");
	case SOAP_TYPE_PointerTo_tptz__RemovePresetResponse:
		return soap_in_PointerTo_tptz__RemovePresetResponse(soap, NULL, NULL, "tptz:RemovePresetResponse");
	case SOAP_TYPE_PointerTo_tptz__RemovePreset:
		return soap_in_PointerTo_tptz__RemovePreset(soap, NULL, NULL, "tptz:RemovePreset");
	case SOAP_TYPE_PointerTo_tptz__SetPresetResponse:
		return soap_in_PointerTo_tptz__SetPresetResponse(soap, NULL, NULL, "tptz:SetPresetResponse");
	case SOAP_TYPE_PointerTo_tptz__SetPreset:
		return soap_in_PointerTo_tptz__SetPreset(soap, NULL, NULL, "tptz:SetPreset");
	case SOAP_TYPE_PointerTo_tptz__GetPresetsResponse:
		return soap_in_PointerTo_tptz__GetPresetsResponse(soap, NULL, NULL, "tptz:GetPresetsResponse");
	case SOAP_TYPE_PointerTo_tptz__GetPresets:
		return soap_in_PointerTo_tptz__GetPresets(soap, NULL, NULL, "tptz:GetPresets");
	case SOAP_TYPE_PointerTo_tptz__GetConfigurationsResponse:
		return soap_in_PointerTo_tptz__GetConfigurationsResponse(soap, NULL, NULL, "tptz:GetConfigurationsResponse");
	case SOAP_TYPE_PointerTo_tptz__GetConfigurations:
		return soap_in_PointerTo_tptz__GetConfigurations(soap, NULL, NULL, "tptz:GetConfigurations");
	case SOAP_TYPE_PointerTo_tds__SetRelayOutputStateResponse:
		return soap_in_PointerTo_tds__SetRelayOutputStateResponse(soap, NULL, NULL, "tds:SetRelayOutputStateResponse");
	case SOAP_TYPE_PointerTo_tds__SetRelayOutputState:
		return soap_in_PointerTo_tds__SetRelayOutputState(soap, NULL, NULL, "tds:SetRelayOutputState");
	case SOAP_TYPE_PointerTo_tds__SetRelayOutputSettingsResponse:
		return soap_in_PointerTo_tds__SetRelayOutputSettingsResponse(soap, NULL, NULL, "tds:SetRelayOutputSettingsResponse");
	case SOAP_TYPE_PointerTo_tds__SetRelayOutputSettings:
		return soap_in_PointerTo_tds__SetRelayOutputSettings(soap, NULL, NULL, "tds:SetRelayOutputSettings");
	case SOAP_TYPE_PointerTo_tds__GetRelayOutputsResponse:
		return soap_in_PointerTo_tds__GetRelayOutputsResponse(soap, NULL, NULL, "tds:GetRelayOutputsResponse");
	case SOAP_TYPE_PointerTo_tds__GetRelayOutputs:
		return soap_in_PointerTo_tds__GetRelayOutputs(soap, NULL, NULL, "tds:GetRelayOutputs");
	case SOAP_TYPE_PointerTo_tds__SetZeroConfigurationResponse:
		return soap_in_PointerTo_tds__SetZeroConfigurationResponse(soap, NULL, NULL, "tds:SetZeroConfigurationResponse");
	case SOAP_TYPE_PointerTo_tds__SetZeroConfiguration:
		return soap_in_PointerTo_tds__SetZeroConfiguration(soap, NULL, NULL, "tds:SetZeroConfiguration");
	case SOAP_TYPE_PointerTo_tds__GetZeroConfigurationResponse:
		return soap_in_PointerTo_tds__GetZeroConfigurationResponse(soap, NULL, NULL, "tds:GetZeroConfigurationResponse");
	case SOAP_TYPE_PointerTo_tds__GetZeroConfiguration:
		return soap_in_PointerTo_tds__GetZeroConfiguration(soap, NULL, NULL, "tds:GetZeroConfiguration");
	case SOAP_TYPE_PointerTo_tds__SetNetworkDefaultGatewayResponse:
		return soap_in_PointerTo_tds__SetNetworkDefaultGatewayResponse(soap, NULL, NULL, "tds:SetNetworkDefaultGatewayResponse");
	case SOAP_TYPE_PointerTo_tds__SetNetworkDefaultGateway:
		return soap_in_PointerTo_tds__SetNetworkDefaultGateway(soap, NULL, NULL, "tds:SetNetworkDefaultGateway");
	case SOAP_TYPE_PointerTo_tds__GetNetworkDefaultGatewayResponse:
		return soap_in_PointerTo_tds__GetNetworkDefaultGatewayResponse(soap, NULL, NULL, "tds:GetNetworkDefaultGatewayResponse");
	case SOAP_TYPE_PointerTo_tds__GetNetworkDefaultGateway:
		return soap_in_PointerTo_tds__GetNetworkDefaultGateway(soap, NULL, NULL, "tds:GetNetworkDefaultGateway");
	case SOAP_TYPE_PointerTo_tds__SetNetworkProtocolsResponse:
		return soap_in_PointerTo_tds__SetNetworkProtocolsResponse(soap, NULL, NULL, "tds:SetNetworkProtocolsResponse");
	case SOAP_TYPE_PointerTo_tds__SetNetworkProtocols:
		return soap_in_PointerTo_tds__SetNetworkProtocols(soap, NULL, NULL, "tds:SetNetworkProtocols");
	case SOAP_TYPE_PointerTo_tds__GetNetworkProtocolsResponse:
		return soap_in_PointerTo_tds__GetNetworkProtocolsResponse(soap, NULL, NULL, "tds:GetNetworkProtocolsResponse");
	case SOAP_TYPE_PointerTo_tds__GetNetworkProtocols:
		return soap_in_PointerTo_tds__GetNetworkProtocols(soap, NULL, NULL, "tds:GetNetworkProtocols");
	case SOAP_TYPE_PointerTo_tds__SetNetworkInterfacesResponse:
		return soap_in_PointerTo_tds__SetNetworkInterfacesResponse(soap, NULL, NULL, "tds:SetNetworkInterfacesResponse");
	case SOAP_TYPE_PointerTo_tds__SetNetworkInterfaces:
		return soap_in_PointerTo_tds__SetNetworkInterfaces(soap, NULL, NULL, "tds:SetNetworkInterfaces");
	case SOAP_TYPE_PointerTo_tds__GetNetworkInterfacesResponse:
		return soap_in_PointerTo_tds__GetNetworkInterfacesResponse(soap, NULL, NULL, "tds:GetNetworkInterfacesResponse");
	case SOAP_TYPE_PointerTo_tds__GetNetworkInterfaces:
		return soap_in_PointerTo_tds__GetNetworkInterfaces(soap, NULL, NULL, "tds:GetNetworkInterfaces");
	case SOAP_TYPE_PointerTo_tds__SetDynamicDNSResponse:
		return soap_in_PointerTo_tds__SetDynamicDNSResponse(soap, NULL, NULL, "tds:SetDynamicDNSResponse");
	case SOAP_TYPE_PointerTo_tds__SetDynamicDNS:
		return soap_in_PointerTo_tds__SetDynamicDNS(soap, NULL, NULL, "tds:SetDynamicDNS");
	case SOAP_TYPE_PointerTo_tds__GetDynamicDNSResponse:
		return soap_in_PointerTo_tds__GetDynamicDNSResponse(soap, NULL, NULL, "tds:GetDynamicDNSResponse");
	case SOAP_TYPE_PointerTo_tds__GetDynamicDNS:
		return soap_in_PointerTo_tds__GetDynamicDNS(soap, NULL, NULL, "tds:GetDynamicDNS");
	case SOAP_TYPE_PointerTo_tds__SetNTPResponse:
		return soap_in_PointerTo_tds__SetNTPResponse(soap, NULL, NULL, "tds:SetNTPResponse");
	case SOAP_TYPE_PointerTo_tds__SetNTP:
		return soap_in_PointerTo_tds__SetNTP(soap, NULL, NULL, "tds:SetNTP");
	case SOAP_TYPE_PointerTo_tds__GetNTPResponse:
		return soap_in_PointerTo_tds__GetNTPResponse(soap, NULL, NULL, "tds:GetNTPResponse");
	case SOAP_TYPE_PointerTo_tds__GetNTP:
		return soap_in_PointerTo_tds__GetNTP(soap, NULL, NULL, "tds:GetNTP");
	case SOAP_TYPE_PointerTo_tds__SetDNSResponse:
		return soap_in_PointerTo_tds__SetDNSResponse(soap, NULL, NULL, "tds:SetDNSResponse");
	case SOAP_TYPE_PointerTo_tds__SetDNS:
		return soap_in_PointerTo_tds__SetDNS(soap, NULL, NULL, "tds:SetDNS");
	case SOAP_TYPE_PointerTo_tds__GetDNSResponse:
		return soap_in_PointerTo_tds__GetDNSResponse(soap, NULL, NULL, "tds:GetDNSResponse");
	case SOAP_TYPE_PointerTo_tds__GetDNS:
		return soap_in_PointerTo_tds__GetDNS(soap, NULL, NULL, "tds:GetDNS");
	case SOAP_TYPE_PointerTo_tds__SetHostnameResponse:
		return soap_in_PointerTo_tds__SetHostnameResponse(soap, NULL, NULL, "tds:SetHostnameResponse");
	case SOAP_TYPE_PointerTo_tds__SetHostname:
		return soap_in_PointerTo_tds__SetHostname(soap, NULL, NULL, "tds:SetHostname");
	case SOAP_TYPE_PointerTo_tds__GetHostnameResponse:
		return soap_in_PointerTo_tds__GetHostnameResponse(soap, NULL, NULL, "tds:GetHostnameResponse");
	case SOAP_TYPE_PointerTo_tds__GetHostname:
		return soap_in_PointerTo_tds__GetHostname(soap, NULL, NULL, "tds:GetHostname");
	case SOAP_TYPE_PointerTo_tds__GetCapabilitiesResponse:
		return soap_in_PointerTo_tds__GetCapabilitiesResponse(soap, NULL, NULL, "tds:GetCapabilitiesResponse");
	case SOAP_TYPE_PointerTo_tds__GetCapabilities:
		return soap_in_PointerTo_tds__GetCapabilities(soap, NULL, NULL, "tds:GetCapabilities");
	case SOAP_TYPE_PointerTo_tds__GetWsdlUrlResponse:
		return soap_in_PointerTo_tds__GetWsdlUrlResponse(soap, NULL, NULL, "tds:GetWsdlUrlResponse");
	case SOAP_TYPE_PointerTo_tds__GetWsdlUrl:
		return soap_in_PointerTo_tds__GetWsdlUrl(soap, NULL, NULL, "tds:GetWsdlUrl");
	case SOAP_TYPE_PointerTo_tds__SetUserResponse:
		return soap_in_PointerTo_tds__SetUserResponse(soap, NULL, NULL, "tds:SetUserResponse");
	case SOAP_TYPE_PointerTo_tds__SetUser:
		return soap_in_PointerTo_tds__SetUser(soap, NULL, NULL, "tds:SetUser");
	case SOAP_TYPE_PointerTo_tds__DeleteUsersResponse:
		return soap_in_PointerTo_tds__DeleteUsersResponse(soap, NULL, NULL, "tds:DeleteUsersResponse");
	case SOAP_TYPE_PointerTo_tds__DeleteUsers:
		return soap_in_PointerTo_tds__DeleteUsers(soap, NULL, NULL, "tds:DeleteUsers");
	case SOAP_TYPE_PointerTo_tds__CreateUsersResponse:
		return soap_in_PointerTo_tds__CreateUsersResponse(soap, NULL, NULL, "tds:CreateUsersResponse");
	case SOAP_TYPE_PointerTo_tds__CreateUsers:
		return soap_in_PointerTo_tds__CreateUsers(soap, NULL, NULL, "tds:CreateUsers");
	case SOAP_TYPE_PointerTo_tds__GetUsersResponse:
		return soap_in_PointerTo_tds__GetUsersResponse(soap, NULL, NULL, "tds:GetUsersResponse");
	case SOAP_TYPE_PointerTo_tds__GetUsers:
		return soap_in_PointerTo_tds__GetUsers(soap, NULL, NULL, "tds:GetUsers");
	case SOAP_TYPE_PointerTo_tds__SetDiscoveryModeResponse:
		return soap_in_PointerTo_tds__SetDiscoveryModeResponse(soap, NULL, NULL, "tds:SetDiscoveryModeResponse");
	case SOAP_TYPE_PointerTo_tds__SetDiscoveryMode:
		return soap_in_PointerTo_tds__SetDiscoveryMode(soap, NULL, NULL, "tds:SetDiscoveryMode");
	case SOAP_TYPE_PointerTo_tds__GetDiscoveryModeResponse:
		return soap_in_PointerTo_tds__GetDiscoveryModeResponse(soap, NULL, NULL, "tds:GetDiscoveryModeResponse");
	case SOAP_TYPE_PointerTo_tds__GetDiscoveryMode:
		return soap_in_PointerTo_tds__GetDiscoveryMode(soap, NULL, NULL, "tds:GetDiscoveryMode");
	case SOAP_TYPE_PointerTo_tds__RemoveScopesResponse:
		return soap_in_PointerTo_tds__RemoveScopesResponse(soap, NULL, NULL, "tds:RemoveScopesResponse");
	case SOAP_TYPE_PointerTo_tds__RemoveScopes:
		return soap_in_PointerTo_tds__RemoveScopes(soap, NULL, NULL, "tds:RemoveScopes");
	case SOAP_TYPE_PointerTo_tds__AddScopesResponse:
		return soap_in_PointerTo_tds__AddScopesResponse(soap, NULL, NULL, "tds:AddScopesResponse");
	case SOAP_TYPE_PointerTo_tds__AddScopes:
		return soap_in_PointerTo_tds__AddScopes(soap, NULL, NULL, "tds:AddScopes");
	case SOAP_TYPE_PointerTo_tds__SetScopesResponse:
		return soap_in_PointerTo_tds__SetScopesResponse(soap, NULL, NULL, "tds:SetScopesResponse");
	case SOAP_TYPE_PointerTo_tds__SetScopes:
		return soap_in_PointerTo_tds__SetScopes(soap, NULL, NULL, "tds:SetScopes");
	case SOAP_TYPE_PointerTo_tds__GetScopesResponse:
		return soap_in_PointerTo_tds__GetScopesResponse(soap, NULL, NULL, "tds:GetScopesResponse");
	case SOAP_TYPE_PointerTo_tds__GetScopes:
		return soap_in_PointerTo_tds__GetScopes(soap, NULL, NULL, "tds:GetScopes");
	case SOAP_TYPE_PointerTo_tds__GetSystemLogResponse:
		return soap_in_PointerTo_tds__GetSystemLogResponse(soap, NULL, NULL, "tds:GetSystemLogResponse");
	case SOAP_TYPE_PointerTo_tds__GetSystemLog:
		return soap_in_PointerTo_tds__GetSystemLog(soap, NULL, NULL, "tds:GetSystemLog");
	case SOAP_TYPE_PointerTo_tds__SystemRebootResponse:
		return soap_in_PointerTo_tds__SystemRebootResponse(soap, NULL, NULL, "tds:SystemRebootResponse");
	case SOAP_TYPE_PointerTo_tds__SystemReboot:
		return soap_in_PointerTo_tds__SystemReboot(soap, NULL, NULL, "tds:SystemReboot");
	case SOAP_TYPE_PointerTo_tds__SetSystemFactoryDefaultResponse:
		return soap_in_PointerTo_tds__SetSystemFactoryDefaultResponse(soap, NULL, NULL, "tds:SetSystemFactoryDefaultResponse");
	case SOAP_TYPE_PointerTo_tds__SetSystemFactoryDefault:
		return soap_in_PointerTo_tds__SetSystemFactoryDefault(soap, NULL, NULL, "tds:SetSystemFactoryDefault");
	case SOAP_TYPE_PointerTo_tds__GetSystemDateAndTimeResponse:
		return soap_in_PointerTo_tds__GetSystemDateAndTimeResponse(soap, NULL, NULL, "tds:GetSystemDateAndTimeResponse");
	case SOAP_TYPE_PointerTo_tds__GetSystemDateAndTime:
		return soap_in_PointerTo_tds__GetSystemDateAndTime(soap, NULL, NULL, "tds:GetSystemDateAndTime");
	case SOAP_TYPE_PointerTo_tds__SetSystemDateAndTimeResponse:
		return soap_in_PointerTo_tds__SetSystemDateAndTimeResponse(soap, NULL, NULL, "tds:SetSystemDateAndTimeResponse");
	case SOAP_TYPE_PointerTo_tds__SetSystemDateAndTime:
		return soap_in_PointerTo_tds__SetSystemDateAndTime(soap, NULL, NULL, "tds:SetSystemDateAndTime");
	case SOAP_TYPE_PointerTo_tds__GetDeviceInformationResponse:
		return soap_in_PointerTo_tds__GetDeviceInformationResponse(soap, NULL, NULL, "tds:GetDeviceInformationResponse");
	case SOAP_TYPE_PointerTo_tds__GetDeviceInformation:
		return soap_in_PointerTo_tds__GetDeviceInformation(soap, NULL, NULL, "tds:GetDeviceInformation");
	case SOAP_TYPE_PointerTo_wsnt__Notify:
		return soap_in_PointerTo_wsnt__Notify(soap, NULL, NULL, "wsnt:Notify");
	case SOAP_TYPE_PointerTo_wsnt__SubscribeResponse:
		return soap_in_PointerTo_wsnt__SubscribeResponse(soap, NULL, NULL, "wsnt:SubscribeResponse");
	case SOAP_TYPE_PointerTo_wsnt__Subscribe:
		return soap_in_PointerTo_wsnt__Subscribe(soap, NULL, NULL, "wsnt:Subscribe");
	case SOAP_TYPE_PointerTo_wsnt__UnsubscribeResponse:
		return soap_in_PointerTo_wsnt__UnsubscribeResponse(soap, NULL, NULL, "wsnt:UnsubscribeResponse");
	case SOAP_TYPE_PointerTo_wsnt__Unsubscribe:
		return soap_in_PointerTo_wsnt__Unsubscribe(soap, NULL, NULL, "wsnt:Unsubscribe");
	case SOAP_TYPE_PointerTo_wsnt__RenewResponse:
		return soap_in_PointerTo_wsnt__RenewResponse(soap, NULL, NULL, "wsnt:RenewResponse");
	case SOAP_TYPE_PointerTo_wsnt__Renew:
		return soap_in_PointerTo_wsnt__Renew(soap, NULL, NULL, "wsnt:Renew");
	case SOAP_TYPE_PointerTo_tev__GetEventPropertiesResponse:
		return soap_in_PointerTo_tev__GetEventPropertiesResponse(soap, NULL, NULL, "tev:GetEventPropertiesResponse");
	case SOAP_TYPE_PointerTo_tev__GetEventProperties:
		return soap_in_PointerTo_tev__GetEventProperties(soap, NULL, NULL, "tev:GetEventProperties");
	case SOAP_TYPE_PointerTo_tev__CreatePullPointSubscriptionResponse:
		return soap_in_PointerTo_tev__CreatePullPointSubscriptionResponse(soap, NULL, NULL, "tev:CreatePullPointSubscriptionResponse");
	case SOAP_TYPE_PointerTo_tev__CreatePullPointSubscription:
		return soap_in_PointerTo_tev__CreatePullPointSubscription(soap, NULL, NULL, "tev:CreatePullPointSubscription");
	case SOAP_TYPE_PointerTo_tev__SetSynchronizationPointResponse:
		return soap_in_PointerTo_tev__SetSynchronizationPointResponse(soap, NULL, NULL, "tev:SetSynchronizationPointResponse");
	case SOAP_TYPE_PointerTo_tev__SetSynchronizationPoint:
		return soap_in_PointerTo_tev__SetSynchronizationPoint(soap, NULL, NULL, "tev:SetSynchronizationPoint");
	case SOAP_TYPE_PointerTo_tev__PullMessagesResponse:
		return soap_in_PointerTo_tev__PullMessagesResponse(soap, NULL, NULL, "tev:PullMessagesResponse");
	case SOAP_TYPE_PointerTo_tev__PullMessages:
		return soap_in_PointerTo_tev__PullMessages(soap, NULL, NULL, "tev:PullMessages");
	case SOAP_TYPE_PointerTod__ProbeMatchesType:
		return soap_in_PointerTod__ProbeMatchesType(soap, NULL, NULL, "d:ProbeMatchesType");
	case SOAP_TYPE_PointerTod__ProbeType:
		return soap_in_PointerTod__ProbeType(soap, NULL, NULL, "d:ProbeType");
	case SOAP_TYPE_PointerTod__ByeType:
		return soap_in_PointerTod__ByeType(soap, NULL, NULL, "d:ByeType");
	case SOAP_TYPE_PointerTod__ResolveType:
		return soap_in_PointerTod__ResolveType(soap, NULL, NULL, "d:ResolveType");
	case SOAP_TYPE_PointerTod__HelloType:
		return soap_in_PointerTod__HelloType(soap, NULL, NULL, "d:HelloType");
	case SOAP_TYPE_PointerTo_tev__PullMessagesFaultResponse:
		return soap_in_PointerTo_tev__PullMessagesFaultResponse(soap, NULL, NULL, "tev:PullMessagesFaultResponse");
	case SOAP_TYPE_PointerTott__ZoomLimits:
		return soap_in_PointerTott__ZoomLimits(soap, NULL, NULL, "tt:ZoomLimits");
	case SOAP_TYPE_PointerTott__PanTiltLimits:
		return soap_in_PointerTott__PanTiltLimits(soap, NULL, NULL, "tt:PanTiltLimits");
	case SOAP_TYPE_PointerTott__NetworkInterfaceExtension:
		return soap_in_PointerTott__NetworkInterfaceExtension(soap, NULL, NULL, "tt:NetworkInterfaceExtension");
	case SOAP_TYPE_PointerTott__IPv4NetworkInterface:
		return soap_in_PointerTott__IPv4NetworkInterface(soap, NULL, NULL, "tt:IPv4NetworkInterface");
	case SOAP_TYPE_PointerTott__NetworkInterfaceLink:
		return soap_in_PointerTott__NetworkInterfaceLink(soap, NULL, NULL, "tt:NetworkInterfaceLink");
	case SOAP_TYPE_PointerTott__NetworkInterfaceInfo:
		return soap_in_PointerTott__NetworkInterfaceInfo(soap, NULL, NULL, "tt:NetworkInterfaceInfo");
	case SOAP_TYPE_PointerTott__EventSubscription:
		return soap_in_PointerTott__EventSubscription(soap, NULL, NULL, "tt:EventSubscription");
	case SOAP_TYPE_PointerTott__MulticastConfiguration:
		return soap_in_PointerTott__MulticastConfiguration(soap, NULL, NULL, "tt:MulticastConfiguration");
	case SOAP_TYPE_PointerTott__H264Configuration:
		return soap_in_PointerTott__H264Configuration(soap, NULL, NULL, "tt:H264Configuration");
	case SOAP_TYPE_PointerTott__Mpeg4Configuration:
		return soap_in_PointerTott__Mpeg4Configuration(soap, NULL, NULL, "tt:Mpeg4Configuration");
	case SOAP_TYPE_PointerTott__VideoRateControl:
		return soap_in_PointerTott__VideoRateControl(soap, NULL, NULL, "tt:VideoRateControl");
	case SOAP_TYPE_PointerTott__IntRectangle:
		return soap_in_PointerTott__IntRectangle(soap, NULL, NULL, "tt:IntRectangle");
	case SOAP_TYPE_PointerTott__ImagingSettings:
		return soap_in_PointerTott__ImagingSettings(soap, NULL, NULL, "tt:ImagingSettings");
	case SOAP_TYPE_PointerTo_wsbf__ResourceUnknownFaultType_FaultCause:
		return soap_in_PointerTo_wsbf__ResourceUnknownFaultType_FaultCause(soap, NULL, NULL, "wsbf:ResourceUnknownFaultType-FaultCause");
	case SOAP_TYPE_PointerTo_wsbf__ResourceUnknownFaultType_Description:
		return soap_in_PointerTo_wsbf__ResourceUnknownFaultType_Description(soap, NULL, NULL, "wsbf:ResourceUnknownFaultType-Description");
	case SOAP_TYPE_PointerTo_wsbf__ResourceUnknownFaultType_ErrorCode:
		return soap_in_PointerTo_wsbf__ResourceUnknownFaultType_ErrorCode(soap, NULL, NULL, "wsbf:ResourceUnknownFaultType-ErrorCode");
	case SOAP_TYPE_PointerTotns1__Device:
		return soap_in_PointerTotns1__Device(soap, NULL, NULL, "tns1:Device");
	case SOAP_TYPE_PointerTotns1__VideoAnalytics:
		return soap_in_PointerTotns1__VideoAnalytics(soap, NULL, NULL, "tns1:VideoAnalytics");
	case SOAP_TYPE_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_FaultCause:
		return soap_in_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_FaultCause(soap, NULL, NULL, "wsbf:UnableToDestroySubscriptionFaultType-FaultCause");
	case SOAP_TYPE_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_Description:
		return soap_in_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_Description(soap, NULL, NULL, "wsbf:UnableToDestroySubscriptionFaultType-Description");
	case SOAP_TYPE_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_ErrorCode:
		return soap_in_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_ErrorCode(soap, NULL, NULL, "wsbf:UnableToDestroySubscriptionFaultType-ErrorCode");
	case SOAP_TYPE_PointerTowsse__UsernameTokenType:
		return soap_in_PointerTowsse__UsernameTokenType(soap, NULL, NULL, "wsse:UsernameTokenType");
	case SOAP_TYPE_PointerTowsu__TimestampType:
		return soap_in_PointerTowsu__TimestampType(soap, NULL, NULL, "wsu:TimestampType");
	case SOAP_TYPE_PointerTowsse__PasswordString:
		return soap_in_PointerTowsse__PasswordString(soap, NULL, NULL, "wsse:PasswordString");
	case SOAP_TYPE_PointerTowsadis__EndpointReferenceType:
		return soap_in_PointerTowsadis__EndpointReferenceType(soap, NULL, NULL, "wsadis:EndpointReferenceType");
	case SOAP_TYPE_PointerTod__ProbeMatchType:
		return soap_in_PointerTod__ProbeMatchType(soap, NULL, NULL, "d:ProbeMatchType");
	case SOAP_TYPE_PointerTounsignedInt:
		return soap_in_PointerTounsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_PointerTod__ScopesType:
		return soap_in_PointerTod__ScopesType(soap, NULL, NULL, "d:ScopesType");
	case SOAP_TYPE_PointerTott__PTZStatus:
		return soap_in_PointerTott__PTZStatus(soap, NULL, NULL, "tt:PTZStatus");
	case SOAP_TYPE_PointerTott__PTZPreset:
		return soap_in_PointerTott__PTZPreset(soap, NULL, NULL, "tt:PTZPreset");
	case SOAP_TYPE_PointerTott__PTZSpeed:
		return soap_in_PointerTott__PTZSpeed(soap, NULL, NULL, "tt:PTZSpeed");
	case SOAP_TYPE_PointerTott__Preset:
		return soap_in_PointerTott__Preset(soap, NULL, NULL, "tt:Preset");
	case SOAP_TYPE_PointerTott__PTZConfigurationOptions:
		return soap_in_PointerTott__PTZConfigurationOptions(soap, NULL, NULL, "tt:PTZConfigurationOptions");
	case SOAP_TYPE_PointerTott__PTZNode:
		return soap_in_PointerTott__PTZNode(soap, NULL, NULL, "tt:PTZNode");
	case SOAP_TYPE_PointerTott__MediaUri:
		return soap_in_PointerTott__MediaUri(soap, NULL, NULL, "tt:MediaUri");
	case SOAP_TYPE_PointerTott__StreamSetup:
		return soap_in_PointerTott__StreamSetup(soap, NULL, NULL, "tt:StreamSetup");
	case SOAP_TYPE_PointerTott__MetadataConfigurationOptions:
		return soap_in_PointerTott__MetadataConfigurationOptions(soap, NULL, NULL, "tt:MetadataConfigurationOptions");
	case SOAP_TYPE_PointerTott__AudioEncoderConfigurationOptions:
		return soap_in_PointerTott__AudioEncoderConfigurationOptions(soap, NULL, NULL, "tt:AudioEncoderConfigurationOptions");
	case SOAP_TYPE_PointerTott__AudioSourceConfigurationOptions:
		return soap_in_PointerTott__AudioSourceConfigurationOptions(soap, NULL, NULL, "tt:AudioSourceConfigurationOptions");
	case SOAP_TYPE_PointerTott__VideoEncoderConfigurationOptions:
		return soap_in_PointerTott__VideoEncoderConfigurationOptions(soap, NULL, NULL, "tt:VideoEncoderConfigurationOptions");
	case SOAP_TYPE_PointerTott__VideoSourceConfigurationOptions:
		return soap_in_PointerTott__VideoSourceConfigurationOptions(soap, NULL, NULL, "tt:VideoSourceConfigurationOptions");
	case SOAP_TYPE_PointerTott__Profile:
		return soap_in_PointerTott__Profile(soap, NULL, NULL, "tt:Profile");
	case SOAP_TYPE_PointerTott__AudioSource:
		return soap_in_PointerTott__AudioSource(soap, NULL, NULL, "tt:AudioSource");
	case SOAP_TYPE_PointerTott__VideoSource:
		return soap_in_PointerTott__VideoSource(soap, NULL, NULL, "tt:VideoSource");
	case SOAP_TYPE_PointerTotrt__Capabilities:
		return soap_in_PointerTotrt__Capabilities(soap, NULL, NULL, "trt:Capabilities");
	case SOAP_TYPE_PointerTotrt__StreamingCapabilities:
		return soap_in_PointerTotrt__StreamingCapabilities(soap, NULL, NULL, "trt:StreamingCapabilities");
	case SOAP_TYPE_PointerTotrt__ProfileCapabilities:
		return soap_in_PointerTotrt__ProfileCapabilities(soap, NULL, NULL, "trt:ProfileCapabilities");
	case SOAP_TYPE_PointerTowstop__TopicSetType:
		return soap_in_PointerTowstop__TopicSetType(soap, NULL, NULL, "wstop:TopicSetType");
	case SOAP_TYPE_PointerTott__RelayOutputSettings:
		return soap_in_PointerTott__RelayOutputSettings(soap, NULL, NULL, "tt:RelayOutputSettings");
	case SOAP_TYPE_PointerTott__RelayOutput:
		return soap_in_PointerTott__RelayOutput(soap, NULL, NULL, "tt:RelayOutput");
	case SOAP_TYPE_PointerTott__NetworkZeroConfiguration:
		return soap_in_PointerTott__NetworkZeroConfiguration(soap, NULL, NULL, "tt:NetworkZeroConfiguration");
	case SOAP_TYPE_PointerTott__NetworkGateway:
		return soap_in_PointerTott__NetworkGateway(soap, NULL, NULL, "tt:NetworkGateway");
	case SOAP_TYPE_PointerTott__NetworkProtocol:
		return soap_in_PointerTott__NetworkProtocol(soap, NULL, NULL, "tt:NetworkProtocol");
	case SOAP_TYPE_PointerTott__NetworkInterfaceSetConfiguration:
		return soap_in_PointerTott__NetworkInterfaceSetConfiguration(soap, NULL, NULL, "tt:NetworkInterfaceSetConfiguration");
	case SOAP_TYPE_PointerTott__NetworkInterface:
		return soap_in_PointerTott__NetworkInterface(soap, NULL, NULL, "tt:NetworkInterface");
	case SOAP_TYPE_PointerTott__DynamicDNSInformation:
		return soap_in_PointerTott__DynamicDNSInformation(soap, NULL, NULL, "tt:DynamicDNSInformation");
	case SOAP_TYPE_PointerTott__NTPInformation:
		return soap_in_PointerTott__NTPInformation(soap, NULL, NULL, "tt:NTPInformation");
	case SOAP_TYPE_PointerTott__DNSInformation:
		return soap_in_PointerTott__DNSInformation(soap, NULL, NULL, "tt:DNSInformation");
	case SOAP_TYPE_PointerTott__HostnameInformation:
		return soap_in_PointerTott__HostnameInformation(soap, NULL, NULL, "tt:HostnameInformation");
	case SOAP_TYPE_PointerTott__Capabilities:
		return soap_in_PointerTott__Capabilities(soap, NULL, NULL, "tt:Capabilities");
	case SOAP_TYPE_PointerTott__CapabilityCategory:
		return soap_in_PointerTott__CapabilityCategory(soap, NULL, NULL, "tt:CapabilityCategory");
	case SOAP_TYPE_PointerTostring:
		return soap_in_PointerTostring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerTott__User:
		return soap_in_PointerTott__User(soap, NULL, NULL, "tt:User");
	case SOAP_TYPE_PointerToxsd__anyURI:
		return soap_in_PointerToxsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
	case SOAP_TYPE_PointerTott__Scope:
		return soap_in_PointerTott__Scope(soap, NULL, NULL, "tt:Scope");
	case SOAP_TYPE_PointerTott__SystemLog:
		return soap_in_PointerTott__SystemLog(soap, NULL, NULL, "tt:SystemLog");
	case SOAP_TYPE_PointerTott__SystemDateTime:
		return soap_in_PointerTott__SystemDateTime(soap, NULL, NULL, "tt:SystemDateTime");
	case SOAP_TYPE_PointerTotnsacti__VirtualPort:
		return soap_in_PointerTotnsacti__VirtualPort(soap, NULL, NULL, "tnsacti:VirtualPort");
	case SOAP_TYPE_PointerTott__MessageDescription:
		return soap_in_PointerTott__MessageDescription(soap, NULL, NULL, "tt:MessageDescription");
	case SOAP_TYPE_PointerTotnsacti__IO:
		return soap_in_PointerTotnsacti__IO(soap, NULL, NULL, "tnsacti:IO");
	case SOAP_TYPE_PointerTotnsacti__MotionDetection:
		return soap_in_PointerTotnsacti__MotionDetection(soap, NULL, NULL, "tnsacti:MotionDetection");
	case SOAP_TYPE_PointerTott__ItemList:
		return soap_in_PointerTott__ItemList(soap, NULL, NULL, "tt:ItemList");
	case SOAP_TYPE_PointerTo_tt__ItemListDescription_SimpleItemDescription:
		return soap_in_PointerTo_tt__ItemListDescription_SimpleItemDescription(soap, NULL, NULL, "tt:ItemListDescription-SimpleItemDescription");
	case SOAP_TYPE_PointerTott__ItemListDescription:
		return soap_in_PointerTott__ItemListDescription(soap, NULL, NULL, "tt:ItemListDescription");
	case SOAP_TYPE_PointerTo_tt__ItemList_SimpleItem:
		return soap_in_PointerTo_tt__ItemList_SimpleItem(soap, NULL, NULL, "tt:ItemList-SimpleItem");
	case SOAP_TYPE_PointerTott__WhiteBalanceMode:
		return soap_in_PointerTott__WhiteBalanceMode(soap, NULL, NULL, "tt:WhiteBalanceMode");
	case SOAP_TYPE_PointerTott__ExposurePriority:
		return soap_in_PointerTott__ExposurePriority(soap, NULL, NULL, "tt:ExposurePriority");
	case SOAP_TYPE_PointerTott__ExposureMode:
		return soap_in_PointerTott__ExposureMode(soap, NULL, NULL, "tt:ExposureMode");
	case SOAP_TYPE_PointerTott__AutoFocusMode:
		return soap_in_PointerTott__AutoFocusMode(soap, NULL, NULL, "tt:AutoFocusMode");
	case SOAP_TYPE_PointerTott__WideDynamicMode:
		return soap_in_PointerTott__WideDynamicMode(soap, NULL, NULL, "tt:WideDynamicMode");
	case SOAP_TYPE_PointerTott__WhiteBalanceOptions:
		return soap_in_PointerTott__WhiteBalanceOptions(soap, NULL, NULL, "tt:WhiteBalanceOptions");
	case SOAP_TYPE_PointerTott__WideDynamicRangeOptions:
		return soap_in_PointerTott__WideDynamicRangeOptions(soap, NULL, NULL, "tt:WideDynamicRangeOptions");
	case SOAP_TYPE_PointerTott__FocusOptions:
		return soap_in_PointerTott__FocusOptions(soap, NULL, NULL, "tt:FocusOptions");
	case SOAP_TYPE_PointerTott__ExposureOptions:
		return soap_in_PointerTott__ExposureOptions(soap, NULL, NULL, "tt:ExposureOptions");
	case SOAP_TYPE_PointerTott__BacklightCompensationOptions:
		return soap_in_PointerTott__BacklightCompensationOptions(soap, NULL, NULL, "tt:BacklightCompensationOptions");
	case SOAP_TYPE_PointerTott__Rectangle:
		return soap_in_PointerTott__Rectangle(soap, NULL, NULL, "tt:Rectangle");
	case SOAP_TYPE_PointerTott__WhiteBalance:
		return soap_in_PointerTott__WhiteBalance(soap, NULL, NULL, "tt:WhiteBalance");
	case SOAP_TYPE_PointerTott__WideDynamicRange:
		return soap_in_PointerTott__WideDynamicRange(soap, NULL, NULL, "tt:WideDynamicRange");
	case SOAP_TYPE_PointerTott__IrCutFilterMode:
		return soap_in_PointerTott__IrCutFilterMode(soap, NULL, NULL, "tt:IrCutFilterMode");
	case SOAP_TYPE_PointerTott__FocusConfiguration:
		return soap_in_PointerTott__FocusConfiguration(soap, NULL, NULL, "tt:FocusConfiguration");
	case SOAP_TYPE_PointerTott__Exposure:
		return soap_in_PointerTott__Exposure(soap, NULL, NULL, "tt:Exposure");
	case SOAP_TYPE_PointerTofloat:
		return soap_in_PointerTofloat(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_PointerTott__BacklightCompensation:
		return soap_in_PointerTott__BacklightCompensation(soap, NULL, NULL, "tt:BacklightCompensation");
	case SOAP_TYPE_PointerTott__MoveStatus:
		return soap_in_PointerTott__MoveStatus(soap, NULL, NULL, "tt:MoveStatus");
	case SOAP_TYPE_PointerTott__PTZMoveStatus:
		return soap_in_PointerTott__PTZMoveStatus(soap, NULL, NULL, "tt:PTZMoveStatus");
	case SOAP_TYPE_PointerTott__PTZVector:
		return soap_in_PointerTott__PTZVector(soap, NULL, NULL, "tt:PTZVector");
	case SOAP_TYPE_PointerTott__Vector1D:
		return soap_in_PointerTott__Vector1D(soap, NULL, NULL, "tt:Vector1D");
	case SOAP_TYPE_PointerTott__Vector2D:
		return soap_in_PointerTott__Vector2D(soap, NULL, NULL, "tt:Vector2D");
	case SOAP_TYPE_PointerTott__FloatRange:
		return soap_in_PointerTott__FloatRange(soap, NULL, NULL, "tt:FloatRange");
	case SOAP_TYPE_PointerTott__Space1DDescription:
		return soap_in_PointerTott__Space1DDescription(soap, NULL, NULL, "tt:Space1DDescription");
	case SOAP_TYPE_PointerTott__Space2DDescription:
		return soap_in_PointerTott__Space2DDescription(soap, NULL, NULL, "tt:Space2DDescription");
	case SOAP_TYPE_PointerTott__DurationRange:
		return soap_in_PointerTott__DurationRange(soap, NULL, NULL, "tt:DurationRange");
	case SOAP_TYPE_PointerTott__PTZSpaces:
		return soap_in_PointerTott__PTZSpaces(soap, NULL, NULL, "tt:PTZSpaces");
	case SOAP_TYPE_PointerTott__Date:
		return soap_in_PointerTott__Date(soap, NULL, NULL, "tt:Date");
	case SOAP_TYPE_PointerTott__Time:
		return soap_in_PointerTott__Time(soap, NULL, NULL, "tt:Time");
	case SOAP_TYPE_PointerTott__DateTime:
		return soap_in_PointerTott__DateTime(soap, NULL, NULL, "tt:DateTime");
	case SOAP_TYPE_PointerTott__TimeZone:
		return soap_in_PointerTott__TimeZone(soap, NULL, NULL, "tt:TimeZone");
	case SOAP_TYPE_PointerTott__OnvifVersion:
		return soap_in_PointerTott__OnvifVersion(soap, NULL, NULL, "tt:OnvifVersion");
	case SOAP_TYPE_PointerTott__RealTimeStreamingCapabilities:
		return soap_in_PointerTott__RealTimeStreamingCapabilities(soap, NULL, NULL, "tt:RealTimeStreamingCapabilities");
	case SOAP_TYPE_PointerTott__SecurityCapabilities:
		return soap_in_PointerTott__SecurityCapabilities(soap, NULL, NULL, "tt:SecurityCapabilities");
	case SOAP_TYPE_PointerTott__IOCapabilities:
		return soap_in_PointerTott__IOCapabilities(soap, NULL, NULL, "tt:IOCapabilities");
	case SOAP_TYPE_PointerTott__SystemCapabilities:
		return soap_in_PointerTott__SystemCapabilities(soap, NULL, NULL, "tt:SystemCapabilities");
	case SOAP_TYPE_PointerTott__NetworkCapabilities:
		return soap_in_PointerTott__NetworkCapabilities(soap, NULL, NULL, "tt:NetworkCapabilities");
	case SOAP_TYPE_PointerTott__AnalyticsDeviceCapabilities:
		return soap_in_PointerTott__AnalyticsDeviceCapabilities(soap, NULL, NULL, "tt:AnalyticsDeviceCapabilities");
	case SOAP_TYPE_PointerTott__ReceiverCapabilities:
		return soap_in_PointerTott__ReceiverCapabilities(soap, NULL, NULL, "tt:ReceiverCapabilities");
	case SOAP_TYPE_PointerTott__ReplayCapabilities:
		return soap_in_PointerTott__ReplayCapabilities(soap, NULL, NULL, "tt:ReplayCapabilities");
	case SOAP_TYPE_PointerTott__SearchCapabilities:
		return soap_in_PointerTott__SearchCapabilities(soap, NULL, NULL, "tt:SearchCapabilities");
	case SOAP_TYPE_PointerTott__RecordingCapabilities:
		return soap_in_PointerTott__RecordingCapabilities(soap, NULL, NULL, "tt:RecordingCapabilities");
	case SOAP_TYPE_PointerTott__DisplayCapabilities:
		return soap_in_PointerTott__DisplayCapabilities(soap, NULL, NULL, "tt:DisplayCapabilities");
	case SOAP_TYPE_PointerTott__DeviceIOCapabilities:
		return soap_in_PointerTott__DeviceIOCapabilities(soap, NULL, NULL, "tt:DeviceIOCapabilities");
	case SOAP_TYPE_PointerTott__CapabilitiesExtension:
		return soap_in_PointerTott__CapabilitiesExtension(soap, NULL, NULL, "tt:CapabilitiesExtension");
	case SOAP_TYPE_PointerTott__PTZCapabilities:
		return soap_in_PointerTott__PTZCapabilities(soap, NULL, NULL, "tt:PTZCapabilities");
	case SOAP_TYPE_PointerTott__MediaCapabilities:
		return soap_in_PointerTott__MediaCapabilities(soap, NULL, NULL, "tt:MediaCapabilities");
	case SOAP_TYPE_PointerTott__ImagingCapabilities:
		return soap_in_PointerTott__ImagingCapabilities(soap, NULL, NULL, "tt:ImagingCapabilities");
	case SOAP_TYPE_PointerTott__EventCapabilities:
		return soap_in_PointerTott__EventCapabilities(soap, NULL, NULL, "tt:EventCapabilities");
	case SOAP_TYPE_PointerTott__DeviceCapabilities:
		return soap_in_PointerTott__DeviceCapabilities(soap, NULL, NULL, "tt:DeviceCapabilities");
	case SOAP_TYPE_PointerTott__AnalyticsCapabilities:
		return soap_in_PointerTott__AnalyticsCapabilities(soap, NULL, NULL, "tt:AnalyticsCapabilities");
	case SOAP_TYPE_PointerTott__NetworkInterfaceSetConfigurationExtension:
		return soap_in_PointerTott__NetworkInterfaceSetConfigurationExtension(soap, NULL, NULL, "tt:NetworkInterfaceSetConfigurationExtension");
	case SOAP_TYPE_PointerTott__IPv4NetworkInterfaceSetConfiguration:
		return soap_in_PointerTott__IPv4NetworkInterfaceSetConfiguration(soap, NULL, NULL, "tt:IPv4NetworkInterfaceSetConfiguration");
	case SOAP_TYPE_PointerTott__NetworkHost:
		return soap_in_PointerTott__NetworkHost(soap, NULL, NULL, "tt:NetworkHost");
	case SOAP_TYPE_PointerToxsd__token:
		return soap_in_PointerToxsd__token(soap, NULL, NULL, "xsd:token");
	case SOAP_TYPE_PointerTott__DNSName:
		return soap_in_PointerTott__DNSName(soap, NULL, NULL, "tt:DNSName");
	case SOAP_TYPE_PointerTott__IPv4Address:
		return soap_in_PointerTott__IPv4Address(soap, NULL, NULL, "tt:IPv4Address");
	case SOAP_TYPE_PointerTott__PrefixedIPv4Address:
		return soap_in_PointerTott__PrefixedIPv4Address(soap, NULL, NULL, "tt:PrefixedIPv4Address");
	case SOAP_TYPE_PointerTott__IPv4Configuration:
		return soap_in_PointerTott__IPv4Configuration(soap, NULL, NULL, "tt:IPv4Configuration");
	case SOAP_TYPE_PointerTott__NetworkInterfaceConnectionSetting:
		return soap_in_PointerTott__NetworkInterfaceConnectionSetting(soap, NULL, NULL, "tt:NetworkInterfaceConnectionSetting");
	case SOAP_TYPE_PointerTott__NetworkInterfaceExtension2:
		return soap_in_PointerTott__NetworkInterfaceExtension2(soap, NULL, NULL, "tt:NetworkInterfaceExtension2");
	case SOAP_TYPE_PointerTott__Dot3Configuration:
		return soap_in_PointerTott__Dot3Configuration(soap, NULL, NULL, "tt:Dot3Configuration");
	case SOAP_TYPE_PointerTott__Transport:
		return soap_in_PointerTott__Transport(soap, NULL, NULL, "tt:Transport");
	case SOAP_TYPE_PointerTott__IPAddress:
		return soap_in_PointerTott__IPAddress(soap, NULL, NULL, "tt:IPAddress");
	case SOAP_TYPE_PointerTott__PTZStatusFilterOptions:
		return soap_in_PointerTott__PTZStatusFilterOptions(soap, NULL, NULL, "tt:PTZStatusFilterOptions");
	case SOAP_TYPE_PointerTott__IntList:
		return soap_in_PointerTott__IntList(soap, NULL, NULL, "tt:IntList");
	case SOAP_TYPE_PointerTott__AudioEncoderConfigurationOption:
		return soap_in_PointerTott__AudioEncoderConfigurationOption(soap, NULL, NULL, "tt:AudioEncoderConfigurationOption");
	case SOAP_TYPE_PointerTott__H264Profile:
		return soap_in_PointerTott__H264Profile(soap, NULL, NULL, "tt:H264Profile");
	case SOAP_TYPE_PointerTott__Mpeg4Profile:
		return soap_in_PointerTott__Mpeg4Profile(soap, NULL, NULL, "tt:Mpeg4Profile");
	case SOAP_TYPE_PointerTott__VideoResolution:
		return soap_in_PointerTott__VideoResolution(soap, NULL, NULL, "tt:VideoResolution");
	case SOAP_TYPE_PointerTott__H264Options:
		return soap_in_PointerTott__H264Options(soap, NULL, NULL, "tt:H264Options");
	case SOAP_TYPE_PointerTott__Mpeg4Options:
		return soap_in_PointerTott__Mpeg4Options(soap, NULL, NULL, "tt:Mpeg4Options");
	case SOAP_TYPE_PointerTott__JpegOptions:
		return soap_in_PointerTott__JpegOptions(soap, NULL, NULL, "tt:JpegOptions");
	case SOAP_TYPE_PointerTott__ReferenceToken:
		return soap_in_PointerTott__ReferenceToken(soap, NULL, NULL, "tt:ReferenceToken");
	case SOAP_TYPE_PointerTott__IntRectangleRange:
		return soap_in_PointerTott__IntRectangleRange(soap, NULL, NULL, "tt:IntRectangleRange");
	case SOAP_TYPE_PointerToxsd__boolean:
		return soap_in_PointerToxsd__boolean(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_PointerTott__MetadataConfiguration:
		return soap_in_PointerTott__MetadataConfiguration(soap, NULL, NULL, "tt:MetadataConfiguration");
	case SOAP_TYPE_PointerTott__PTZConfiguration:
		return soap_in_PointerTott__PTZConfiguration(soap, NULL, NULL, "tt:PTZConfiguration");
	case SOAP_TYPE_PointerTott__AudioEncoderConfiguration:
		return soap_in_PointerTott__AudioEncoderConfiguration(soap, NULL, NULL, "tt:AudioEncoderConfiguration");
	case SOAP_TYPE_PointerTott__VideoEncoderConfiguration:
		return soap_in_PointerTott__VideoEncoderConfiguration(soap, NULL, NULL, "tt:VideoEncoderConfiguration");
	case SOAP_TYPE_PointerTott__AudioSourceConfiguration:
		return soap_in_PointerTott__AudioSourceConfiguration(soap, NULL, NULL, "tt:AudioSourceConfiguration");
	case SOAP_TYPE_PointerTott__VideoSourceConfiguration:
		return soap_in_PointerTott__VideoSourceConfiguration(soap, NULL, NULL, "tt:VideoSourceConfiguration");
	case SOAP_TYPE_PointerToint:
		return soap_in_PointerToint(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_PointerTott__IntRange:
		return soap_in_PointerTott__IntRange(soap, NULL, NULL, "tt:IntRange");
	case SOAP_TYPE_PointerTowstop__Documentation:
		return soap_in_PointerTowstop__Documentation(soap, NULL, NULL, "wstop:Documentation");
	case SOAP_TYPE_PointerTowsa__MetadataType:
		return soap_in_PointerTowsa__MetadataType(soap, NULL, NULL, "wsa:MetadataType");
	case SOAP_TYPE_PointerTowsa__ReferenceParametersType:
		return soap_in_PointerTowsa__ReferenceParametersType(soap, NULL, NULL, "wsa:ReferenceParametersType");
	case SOAP_TYPE_PointerTowsa__AttributedURIType:
		return soap_in_PointerTowsa__AttributedURIType(soap, NULL, NULL, "wsa:AttributedURIType");
	case SOAP_TYPE_PointerTo_wsbf__BaseFaultType_FaultCause:
		return soap_in_PointerTo_wsbf__BaseFaultType_FaultCause(soap, NULL, NULL, "wsbf:BaseFaultType-FaultCause");
	case SOAP_TYPE_PointerTo_wsbf__BaseFaultType_Description:
		return soap_in_PointerTo_wsbf__BaseFaultType_Description(soap, NULL, NULL, "wsbf:BaseFaultType-Description");
	case SOAP_TYPE_PointerTo_wsbf__BaseFaultType_ErrorCode:
		return soap_in_PointerTo_wsbf__BaseFaultType_ErrorCode(soap, NULL, NULL, "wsbf:BaseFaultType-ErrorCode");
	case SOAP_TYPE_PointerTotime:
		return soap_in_PointerTotime(soap, NULL, NULL, "xsd:dateTime");
	case SOAP_TYPE_PointerTowsnt__FilterType:
		return soap_in_PointerTowsnt__FilterType(soap, NULL, NULL, "wsnt:FilterType");
	case SOAP_TYPE_PointerTowsnt__NotificationMessageHolderType:
		return soap_in_PointerTowsnt__NotificationMessageHolderType(soap, NULL, NULL, "wsnt:NotificationMessageHolderType");
	case SOAP_TYPE_PointerTo_tt__Message:
		return soap_in_PointerTo_tt__Message(soap, NULL, NULL, "tt:Message");
	case SOAP_TYPE_PointerTowsa__EndpointReferenceType:
		return soap_in_PointerTowsa__EndpointReferenceType(soap, NULL, NULL, "wsa:EndpointReferenceType");
	case SOAP_TYPE_PointerTowsnt__QueryExpressionType:
		return soap_in_PointerTowsnt__QueryExpressionType(soap, NULL, NULL, "wsnt:QueryExpressionType");
	case SOAP_TYPE_PointerTowsnt__TopicExpressionType:
		return soap_in_PointerTowsnt__TopicExpressionType(soap, NULL, NULL, "wsnt:TopicExpressionType");
	case SOAP_TYPE_PointerTowsadis__ServiceNameType:
		return soap_in_PointerTowsadis__ServiceNameType(soap, NULL, NULL, "wsadis:ServiceNameType");
	case SOAP_TYPE_PointerTowsadis__AttributedQName:
		return soap_in_PointerTowsadis__AttributedQName(soap, NULL, NULL, "wsadis:AttributedQName");
	case SOAP_TYPE_PointerTowsadis__ReferenceParametersType:
		return soap_in_PointerTowsadis__ReferenceParametersType(soap, NULL, NULL, "wsadis:ReferenceParametersType");
	case SOAP_TYPE_PointerTowsadis__ReferencePropertiesType:
		return soap_in_PointerTowsadis__ReferencePropertiesType(soap, NULL, NULL, "wsadis:ReferencePropertiesType");
	case SOAP_TYPE_PointerTowsadis__AttributedURI:
		return soap_in_PointerTowsadis__AttributedURI(soap, NULL, NULL, "wsadis:AttributedURI");
	case SOAP_TYPE_tt__Domain:
	{	char **s;
		s = soap_in_tt__Domain(soap, NULL, NULL, "tt:Domain");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_tt__DNSName:
	{	char **s;
		s = soap_in_tt__DNSName(soap, NULL, NULL, "tt:DNSName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_tt__HwAddress:
	{	char **s;
		s = soap_in_tt__HwAddress(soap, NULL, NULL, "tt:HwAddress");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_tt__IPv4Address:
	{	char **s;
		s = soap_in_tt__IPv4Address(soap, NULL, NULL, "tt:IPv4Address");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_tt__Name:
	{	char **s;
		s = soap_in_tt__Name(soap, NULL, NULL, "tt:Name");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_tt__ReferenceToken:
	{	char **s;
		s = soap_in_tt__ReferenceToken(soap, NULL, NULL, "tt:ReferenceToken");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_d__UriListType:
	{	char **s;
		s = soap_in_d__UriListType(soap, NULL, NULL, "d:UriListType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_d__QNameListType:
	{	char **s;
		s = soap_in_d__QNameListType(soap, NULL, NULL, "d:QNameListType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_wsa__RelationshipTypeOpenEnum:
	{	char **s;
		s = soap_in_wsa__RelationshipTypeOpenEnum(soap, NULL, NULL, "wsa:RelationshipTypeOpenEnum");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_wsnt__AbsoluteOrRelativeTimeType:
	{	char **s;
		s = soap_in_wsnt__AbsoluteOrRelativeTimeType(soap, NULL, NULL, "wsnt:AbsoluteOrRelativeTimeType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__token:
	{	char **s;
		s = soap_in_xsd__token(soap, NULL, NULL, "xsd:token");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__duration:
	{	char **s;
		s = soap_in_xsd__duration(soap, NULL, NULL, "xsd:duration");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__anyURI:
	{	char **s;
		s = soap_in_xsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__anySimpleType:
	{	char **s;
		s = soap_in_xsd__anySimpleType(soap, NULL, NULL, "xsd:anySimpleType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__Name:
	{	char **s;
		s = soap_in_xsd__Name(soap, NULL, NULL, "xsd:Name");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__NCName:
	{	char **s;
		s = soap_in_xsd__NCName(soap, NULL, NULL, "xsd:NCName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IANA-IfTypes"))
		{	*type = SOAP_TYPE_tt__IANA_IfTypes;
			return soap_in_tt__IANA_IfTypes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:float"))
		{	*type = SOAP_TYPE_float;
			return soap_in_float(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:dateTime"))
		{	*type = SOAP_TYPE_time;
			return soap_in_time(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsu:tTimestampFault"))
		{	*type = SOAP_TYPE_wsu__tTimestampFault;
			return soap_in_wsu__tTimestampFault(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:FaultcodeEnum"))
		{	*type = SOAP_TYPE_wsse__FaultcodeEnum;
			return soap_in_wsse__FaultcodeEnum(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:FaultCodeType"))
		{	*type = SOAP_TYPE_d__FaultCodeType;
			return soap_in_d__FaultCodeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsaw:AnonymousType"))
		{	*type = SOAP_TYPE_wsaw__AnonymousType;
			return soap_in_wsaw__AnonymousType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IrCutFilterMode"))
		{	*type = SOAP_TYPE_tt__IrCutFilterMode;
			return soap_in_tt__IrCutFilterMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:WhiteBalanceMode"))
		{	*type = SOAP_TYPE_tt__WhiteBalanceMode;
			return soap_in_tt__WhiteBalanceMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Enabled"))
		{	*type = SOAP_TYPE_tt__Enabled;
			return soap_in_tt__Enabled(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ExposureMode"))
		{	*type = SOAP_TYPE_tt__ExposureMode;
			return soap_in_tt__ExposureMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ExposurePriority"))
		{	*type = SOAP_TYPE_tt__ExposurePriority;
			return soap_in_tt__ExposurePriority(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:BacklightCompensationMode"))
		{	*type = SOAP_TYPE_tt__BacklightCompensationMode;
			return soap_in_tt__BacklightCompensationMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:WideDynamicMode"))
		{	*type = SOAP_TYPE_tt__WideDynamicMode;
			return soap_in_tt__WideDynamicMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AutoFocusMode"))
		{	*type = SOAP_TYPE_tt__AutoFocusMode;
			return soap_in_tt__AutoFocusMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:MoveStatus"))
		{	*type = SOAP_TYPE_tt__MoveStatus;
			return soap_in_tt__MoveStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:RelayMode"))
		{	*type = SOAP_TYPE_tt__RelayMode;
			return soap_in_tt__RelayMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:RelayIdleState"))
		{	*type = SOAP_TYPE_tt__RelayIdleState;
			return soap_in_tt__RelayIdleState(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:RelayLogicalState"))
		{	*type = SOAP_TYPE_tt__RelayLogicalState;
			return soap_in_tt__RelayLogicalState(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:UserLevel"))
		{	*type = SOAP_TYPE_tt__UserLevel;
			return soap_in_tt__UserLevel(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:SetDateTimeType"))
		{	*type = SOAP_TYPE_tt__SetDateTimeType;
			return soap_in_tt__SetDateTimeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:FactoryDefaultType"))
		{	*type = SOAP_TYPE_tt__FactoryDefaultType;
			return soap_in_tt__FactoryDefaultType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:SystemLogType"))
		{	*type = SOAP_TYPE_tt__SystemLogType;
			return soap_in_tt__SystemLogType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:CapabilityCategory"))
		{	*type = SOAP_TYPE_tt__CapabilityCategory;
			return soap_in_tt__CapabilityCategory(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DynamicDNSType"))
		{	*type = SOAP_TYPE_tt__DynamicDNSType;
			return soap_in_tt__DynamicDNSType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IPType"))
		{	*type = SOAP_TYPE_tt__IPType;
			return soap_in_tt__IPType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkHostType"))
		{	*type = SOAP_TYPE_tt__NetworkHostType;
			return soap_in_tt__NetworkHostType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkProtocolType"))
		{	*type = SOAP_TYPE_tt__NetworkProtocolType;
			return soap_in_tt__NetworkProtocolType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Duplex"))
		{	*type = SOAP_TYPE_tt__Duplex;
			return soap_in_tt__Duplex(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DiscoveryMode"))
		{	*type = SOAP_TYPE_tt__DiscoveryMode;
			return soap_in_tt__DiscoveryMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ScopeDefinition"))
		{	*type = SOAP_TYPE_tt__ScopeDefinition;
			return soap_in_tt__ScopeDefinition(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:TransportProtocol"))
		{	*type = SOAP_TYPE_tt__TransportProtocol;
			return soap_in_tt__TransportProtocol(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:StreamType"))
		{	*type = SOAP_TYPE_tt__StreamType;
			return soap_in_tt__StreamType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioEncoding"))
		{	*type = SOAP_TYPE_tt__AudioEncoding;
			return soap_in_tt__AudioEncoding(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:H264Profile"))
		{	*type = SOAP_TYPE_tt__H264Profile;
			return soap_in_tt__H264Profile(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Mpeg4Profile"))
		{	*type = SOAP_TYPE_tt__Mpeg4Profile;
			return soap_in_tt__Mpeg4Profile(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoEncoding"))
		{	*type = SOAP_TYPE_tt__VideoEncoding;
			return soap_in_tt__VideoEncoding(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:RelationshipType"))
		{	*type = SOAP_TYPE_wsa__RelationshipType;
			return soap_in_wsa__RelationshipType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_xsd__boolean;
			return soap_in_xsd__boolean(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsu:TimestampType"))
		{	*type = SOAP_TYPE_wsu__TimestampType;
			return soap_in_wsu__TimestampType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:SecurityHeaderType"))
		{	*type = SOAP_TYPE_wsse__SecurityHeaderType;
			return soap_in_wsse__SecurityHeaderType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:UsernameTokenType"))
		{	*type = SOAP_TYPE_wsse__UsernameTokenType;
			return soap_in_wsse__UsernameTokenType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:PasswordString"))
		{	*type = SOAP_TYPE_wsse__PasswordString;
			return soap_in_wsse__PasswordString(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:AppSequenceType"))
		{	*type = SOAP_TYPE_d__AppSequenceType;
			return soap_in_d__AppSequenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ScopesType"))
		{	*type = SOAP_TYPE_d__ScopesType;
			return soap_in_d__ScopesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ResolveType"))
		{	*type = SOAP_TYPE_d__ResolveType;
			return soap_in_d__ResolveType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ProbeMatchType"))
		{	*type = SOAP_TYPE_d__ProbeMatchType;
			return soap_in_d__ProbeMatchType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ProbeMatchesType"))
		{	*type = SOAP_TYPE_d__ProbeMatchesType;
			return soap_in_d__ProbeMatchesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ProbeType"))
		{	*type = SOAP_TYPE_d__ProbeType;
			return soap_in_d__ProbeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ByeType"))
		{	*type = SOAP_TYPE_d__ByeType;
			return soap_in_d__ByeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:HelloType"))
		{	*type = SOAP_TYPE_d__HelloType;
			return soap_in_d__HelloType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:StreamingCapabilities"))
		{	*type = SOAP_TYPE_trt__StreamingCapabilities;
			return soap_in_trt__StreamingCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:ProfileCapabilities"))
		{	*type = SOAP_TYPE_trt__ProfileCapabilities;
			return soap_in_trt__ProfileCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:Capabilities"))
		{	*type = SOAP_TYPE_trt__Capabilities;
			return soap_in_trt__Capabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsaw:AttributedQNameType"))
		{	*type = SOAP_TYPE_wsaw__AttributedQNameType;
			return soap_in_wsaw__AttributedQNameType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsaw:ServiceNameType"))
		{	*type = SOAP_TYPE_wsaw__ServiceNameType;
			return soap_in_wsaw__ServiceNameType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tnsacti:IO"))
		{	*type = SOAP_TYPE_tnsacti__IO;
			return soap_in_tnsacti__IO(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tnsacti:MotionDetection"))
		{	*type = SOAP_TYPE_tnsacti__MotionDetection;
			return soap_in_tnsacti__MotionDetection(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tnsacti:VirtualPort"))
		{	*type = SOAP_TYPE_tnsacti__VirtualPort;
			return soap_in_tnsacti__VirtualPort(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tns1:Device"))
		{	*type = SOAP_TYPE_tns1__Device;
			return soap_in_tns1__Device(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tns1:VideoAnalytics"))
		{	*type = SOAP_TYPE_tns1__VideoAnalytics;
			return soap_in_tns1__VideoAnalytics(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:EventStream"))
		{	*type = SOAP_TYPE_tt__EventStream;
			return soap_in_tt__EventStream(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Rectangle"))
		{	*type = SOAP_TYPE_tt__Rectangle;
			return soap_in_tt__Rectangle(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ItemListDescription"))
		{	*type = SOAP_TYPE_tt__ItemListDescription;
			return soap_in_tt__ItemListDescription(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:MessageDescription"))
		{	*type = SOAP_TYPE_tt__MessageDescription;
			return soap_in_tt__MessageDescription(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ItemList"))
		{	*type = SOAP_TYPE_tt__ItemList;
			return soap_in_tt__ItemList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:WhiteBalance"))
		{	*type = SOAP_TYPE_tt__WhiteBalance;
			return soap_in_tt__WhiteBalance(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:WhiteBalanceOptions"))
		{	*type = SOAP_TYPE_tt__WhiteBalanceOptions;
			return soap_in_tt__WhiteBalanceOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ExposureOptions"))
		{	*type = SOAP_TYPE_tt__ExposureOptions;
			return soap_in_tt__ExposureOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:FocusOptions"))
		{	*type = SOAP_TYPE_tt__FocusOptions;
			return soap_in_tt__FocusOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:BacklightCompensationOptions"))
		{	*type = SOAP_TYPE_tt__BacklightCompensationOptions;
			return soap_in_tt__BacklightCompensationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:WideDynamicRangeOptions"))
		{	*type = SOAP_TYPE_tt__WideDynamicRangeOptions;
			return soap_in_tt__WideDynamicRangeOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ImagingOptions"))
		{	*type = SOAP_TYPE_tt__ImagingOptions;
			return soap_in_tt__ImagingOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:BacklightCompensation"))
		{	*type = SOAP_TYPE_tt__BacklightCompensation;
			return soap_in_tt__BacklightCompensation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:WideDynamicRange"))
		{	*type = SOAP_TYPE_tt__WideDynamicRange;
			return soap_in_tt__WideDynamicRange(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Exposure"))
		{	*type = SOAP_TYPE_tt__Exposure;
			return soap_in_tt__Exposure(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ImagingSettings"))
		{	*type = SOAP_TYPE_tt__ImagingSettings;
			return soap_in_tt__ImagingSettings(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:FocusConfiguration"))
		{	*type = SOAP_TYPE_tt__FocusConfiguration;
			return soap_in_tt__FocusConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:PTZMoveStatus"))
		{	*type = SOAP_TYPE_tt__PTZMoveStatus;
			return soap_in_tt__PTZMoveStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:PTZPreset"))
		{	*type = SOAP_TYPE_tt__PTZPreset;
			return soap_in_tt__PTZPreset(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Preset"))
		{	*type = SOAP_TYPE_tt__Preset;
			return soap_in_tt__Preset(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:PTZStatus"))
		{	*type = SOAP_TYPE_tt__PTZStatus;
			return soap_in_tt__PTZStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:PTZSpeed"))
		{	*type = SOAP_TYPE_tt__PTZSpeed;
			return soap_in_tt__PTZSpeed(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:PTZVector"))
		{	*type = SOAP_TYPE_tt__PTZVector;
			return soap_in_tt__PTZVector(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Vector1D"))
		{	*type = SOAP_TYPE_tt__Vector1D;
			return soap_in_tt__Vector1D(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Vector2D"))
		{	*type = SOAP_TYPE_tt__Vector2D;
			return soap_in_tt__Vector2D(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Space1DDescription"))
		{	*type = SOAP_TYPE_tt__Space1DDescription;
			return soap_in_tt__Space1DDescription(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Space2DDescription"))
		{	*type = SOAP_TYPE_tt__Space2DDescription;
			return soap_in_tt__Space2DDescription(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:PTZSpaces"))
		{	*type = SOAP_TYPE_tt__PTZSpaces;
			return soap_in_tt__PTZSpaces(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ZoomLimits"))
		{	*type = SOAP_TYPE_tt__ZoomLimits;
			return soap_in_tt__ZoomLimits(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:PanTiltLimits"))
		{	*type = SOAP_TYPE_tt__PanTiltLimits;
			return soap_in_tt__PanTiltLimits(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:PTZConfigurationOptions"))
		{	*type = SOAP_TYPE_tt__PTZConfigurationOptions;
			return soap_in_tt__PTZConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:PTZConfiguration"))
		{	*type = SOAP_TYPE_tt__PTZConfiguration;
			return soap_in_tt__PTZConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:PTZNode"))
		{	*type = SOAP_TYPE_tt__PTZNode;
			return soap_in_tt__PTZNode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:RelayOutput"))
		{	*type = SOAP_TYPE_tt__RelayOutput;
			return soap_in_tt__RelayOutput(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:RelayOutputSettings"))
		{	*type = SOAP_TYPE_tt__RelayOutputSettings;
			return soap_in_tt__RelayOutputSettings(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:User"))
		{	*type = SOAP_TYPE_tt__User;
			return soap_in_tt__User(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:TimeZone"))
		{	*type = SOAP_TYPE_tt__TimeZone;
			return soap_in_tt__TimeZone(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Time"))
		{	*type = SOAP_TYPE_tt__Time;
			return soap_in_tt__Time(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Date"))
		{	*type = SOAP_TYPE_tt__Date;
			return soap_in_tt__Date(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DateTime"))
		{	*type = SOAP_TYPE_tt__DateTime;
			return soap_in_tt__DateTime(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:SystemDateTime"))
		{	*type = SOAP_TYPE_tt__SystemDateTime;
			return soap_in_tt__SystemDateTime(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:SystemLog"))
		{	*type = SOAP_TYPE_tt__SystemLog;
			return soap_in_tt__SystemLog(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AnalyticsDeviceCapabilities"))
		{	*type = SOAP_TYPE_tt__AnalyticsDeviceCapabilities;
			return soap_in_tt__AnalyticsDeviceCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ReceiverCapabilities"))
		{	*type = SOAP_TYPE_tt__ReceiverCapabilities;
			return soap_in_tt__ReceiverCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ReplayCapabilities"))
		{	*type = SOAP_TYPE_tt__ReplayCapabilities;
			return soap_in_tt__ReplayCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:SearchCapabilities"))
		{	*type = SOAP_TYPE_tt__SearchCapabilities;
			return soap_in_tt__SearchCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:RecordingCapabilities"))
		{	*type = SOAP_TYPE_tt__RecordingCapabilities;
			return soap_in_tt__RecordingCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DisplayCapabilities"))
		{	*type = SOAP_TYPE_tt__DisplayCapabilities;
			return soap_in_tt__DisplayCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DeviceIOCapabilities"))
		{	*type = SOAP_TYPE_tt__DeviceIOCapabilities;
			return soap_in_tt__DeviceIOCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:PTZCapabilities"))
		{	*type = SOAP_TYPE_tt__PTZCapabilities;
			return soap_in_tt__PTZCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ImagingCapabilities"))
		{	*type = SOAP_TYPE_tt__ImagingCapabilities;
			return soap_in_tt__ImagingCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:OnvifVersion"))
		{	*type = SOAP_TYPE_tt__OnvifVersion;
			return soap_in_tt__OnvifVersion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:SystemCapabilities"))
		{	*type = SOAP_TYPE_tt__SystemCapabilities;
			return soap_in_tt__SystemCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:SecurityCapabilities"))
		{	*type = SOAP_TYPE_tt__SecurityCapabilities;
			return soap_in_tt__SecurityCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkCapabilities"))
		{	*type = SOAP_TYPE_tt__NetworkCapabilities;
			return soap_in_tt__NetworkCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ProfileCapabilities"))
		{	*type = SOAP_TYPE_tt__ProfileCapabilities;
			return soap_in_tt__ProfileCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:RealTimeStreamingCapabilities"))
		{	*type = SOAP_TYPE_tt__RealTimeStreamingCapabilities;
			return soap_in_tt__RealTimeStreamingCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:MediaCapabilities"))
		{	*type = SOAP_TYPE_tt__MediaCapabilities;
			return soap_in_tt__MediaCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IOCapabilities"))
		{	*type = SOAP_TYPE_tt__IOCapabilities;
			return soap_in_tt__IOCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:EventCapabilities"))
		{	*type = SOAP_TYPE_tt__EventCapabilities;
			return soap_in_tt__EventCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DeviceCapabilities"))
		{	*type = SOAP_TYPE_tt__DeviceCapabilities;
			return soap_in_tt__DeviceCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AnalyticsCapabilities"))
		{	*type = SOAP_TYPE_tt__AnalyticsCapabilities;
			return soap_in_tt__AnalyticsCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:CapabilitiesExtension"))
		{	*type = SOAP_TYPE_tt__CapabilitiesExtension;
			return soap_in_tt__CapabilitiesExtension(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Capabilities"))
		{	*type = SOAP_TYPE_tt__Capabilities;
			return soap_in_tt__Capabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkZeroConfiguration"))
		{	*type = SOAP_TYPE_tt__NetworkZeroConfiguration;
			return soap_in_tt__NetworkZeroConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkGateway"))
		{	*type = SOAP_TYPE_tt__NetworkGateway;
			return soap_in_tt__NetworkGateway(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IPv4NetworkInterfaceSetConfiguration"))
		{	*type = SOAP_TYPE_tt__IPv4NetworkInterfaceSetConfiguration;
			return soap_in_tt__IPv4NetworkInterfaceSetConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkInterfaceSetConfigurationExtension"))
		{	*type = SOAP_TYPE_tt__NetworkInterfaceSetConfigurationExtension;
			return soap_in_tt__NetworkInterfaceSetConfigurationExtension(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkInterfaceSetConfiguration"))
		{	*type = SOAP_TYPE_tt__NetworkInterfaceSetConfiguration;
			return soap_in_tt__NetworkInterfaceSetConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DynamicDNSInformation"))
		{	*type = SOAP_TYPE_tt__DynamicDNSInformation;
			return soap_in_tt__DynamicDNSInformation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NTPInformation"))
		{	*type = SOAP_TYPE_tt__NTPInformation;
			return soap_in_tt__NTPInformation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DNSInformation"))
		{	*type = SOAP_TYPE_tt__DNSInformation;
			return soap_in_tt__DNSInformation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:HostnameInformation"))
		{	*type = SOAP_TYPE_tt__HostnameInformation;
			return soap_in_tt__HostnameInformation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:PrefixedIPv4Address"))
		{	*type = SOAP_TYPE_tt__PrefixedIPv4Address;
			return soap_in_tt__PrefixedIPv4Address(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IPAddress"))
		{	*type = SOAP_TYPE_tt__IPAddress;
			return soap_in_tt__IPAddress(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkHost"))
		{	*type = SOAP_TYPE_tt__NetworkHost;
			return soap_in_tt__NetworkHost(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkProtocol"))
		{	*type = SOAP_TYPE_tt__NetworkProtocol;
			return soap_in_tt__NetworkProtocol(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IPv4Configuration"))
		{	*type = SOAP_TYPE_tt__IPv4Configuration;
			return soap_in_tt__IPv4Configuration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IPv4NetworkInterface"))
		{	*type = SOAP_TYPE_tt__IPv4NetworkInterface;
			return soap_in_tt__IPv4NetworkInterface(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkInterfaceInfo"))
		{	*type = SOAP_TYPE_tt__NetworkInterfaceInfo;
			return soap_in_tt__NetworkInterfaceInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkInterfaceConnectionSetting"))
		{	*type = SOAP_TYPE_tt__NetworkInterfaceConnectionSetting;
			return soap_in_tt__NetworkInterfaceConnectionSetting(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkInterfaceLink"))
		{	*type = SOAP_TYPE_tt__NetworkInterfaceLink;
			return soap_in_tt__NetworkInterfaceLink(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkInterfaceExtension2"))
		{	*type = SOAP_TYPE_tt__NetworkInterfaceExtension2;
			return soap_in_tt__NetworkInterfaceExtension2(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Dot3Configuration"))
		{	*type = SOAP_TYPE_tt__Dot3Configuration;
			return soap_in_tt__Dot3Configuration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkInterfaceExtension"))
		{	*type = SOAP_TYPE_tt__NetworkInterfaceExtension;
			return soap_in_tt__NetworkInterfaceExtension(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:NetworkInterface"))
		{	*type = SOAP_TYPE_tt__NetworkInterface;
			return soap_in_tt__NetworkInterface(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Scope"))
		{	*type = SOAP_TYPE_tt__Scope;
			return soap_in_tt__Scope(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:MediaUri"))
		{	*type = SOAP_TYPE_tt__MediaUri;
			return soap_in_tt__MediaUri(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Transport"))
		{	*type = SOAP_TYPE_tt__Transport;
			return soap_in_tt__Transport(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:StreamSetup"))
		{	*type = SOAP_TYPE_tt__StreamSetup;
			return soap_in_tt__StreamSetup(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:MulticastConfiguration"))
		{	*type = SOAP_TYPE_tt__MulticastConfiguration;
			return soap_in_tt__MulticastConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:PTZStatusFilterOptions"))
		{	*type = SOAP_TYPE_tt__PTZStatusFilterOptions;
			return soap_in_tt__PTZStatusFilterOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:MetadataConfigurationOptions"))
		{	*type = SOAP_TYPE_tt__MetadataConfigurationOptions;
			return soap_in_tt__MetadataConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:EventSubscription"))
		{	*type = SOAP_TYPE_tt__EventSubscription;
			return soap_in_tt__EventSubscription(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:MetadataConfiguration"))
		{	*type = SOAP_TYPE_tt__MetadataConfiguration;
			return soap_in_tt__MetadataConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioEncoderConfigurationOption"))
		{	*type = SOAP_TYPE_tt__AudioEncoderConfigurationOption;
			return soap_in_tt__AudioEncoderConfigurationOption(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioEncoderConfigurationOptions"))
		{	*type = SOAP_TYPE_tt__AudioEncoderConfigurationOptions;
			return soap_in_tt__AudioEncoderConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioEncoderConfiguration"))
		{	*type = SOAP_TYPE_tt__AudioEncoderConfiguration;
			return soap_in_tt__AudioEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioSourceConfigurationOptions"))
		{	*type = SOAP_TYPE_tt__AudioSourceConfigurationOptions;
			return soap_in_tt__AudioSourceConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioSourceConfiguration"))
		{	*type = SOAP_TYPE_tt__AudioSourceConfiguration;
			return soap_in_tt__AudioSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:H264Options"))
		{	*type = SOAP_TYPE_tt__H264Options;
			return soap_in_tt__H264Options(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Mpeg4Options"))
		{	*type = SOAP_TYPE_tt__Mpeg4Options;
			return soap_in_tt__Mpeg4Options(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:JpegOptions"))
		{	*type = SOAP_TYPE_tt__JpegOptions;
			return soap_in_tt__JpegOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoEncoderConfigurationOptions"))
		{	*type = SOAP_TYPE_tt__VideoEncoderConfigurationOptions;
			return soap_in_tt__VideoEncoderConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:H264Configuration"))
		{	*type = SOAP_TYPE_tt__H264Configuration;
			return soap_in_tt__H264Configuration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Mpeg4Configuration"))
		{	*type = SOAP_TYPE_tt__Mpeg4Configuration;
			return soap_in_tt__Mpeg4Configuration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoRateControl"))
		{	*type = SOAP_TYPE_tt__VideoRateControl;
			return soap_in_tt__VideoRateControl(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoResolution"))
		{	*type = SOAP_TYPE_tt__VideoResolution;
			return soap_in_tt__VideoResolution(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoEncoderConfiguration"))
		{	*type = SOAP_TYPE_tt__VideoEncoderConfiguration;
			return soap_in_tt__VideoEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoSourceConfigurationOptions"))
		{	*type = SOAP_TYPE_tt__VideoSourceConfigurationOptions;
			return soap_in_tt__VideoSourceConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoSourceConfiguration"))
		{	*type = SOAP_TYPE_tt__VideoSourceConfiguration;
			return soap_in_tt__VideoSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ConfigurationEntity"))
		{	*type = SOAP_TYPE_tt__ConfigurationEntity;
			return soap_in_tt__ConfigurationEntity(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Profile"))
		{	*type = SOAP_TYPE_tt__Profile;
			return soap_in_tt__Profile(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioSource"))
		{	*type = SOAP_TYPE_tt__AudioSource;
			return soap_in_tt__AudioSource(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoSource"))
		{	*type = SOAP_TYPE_tt__VideoSource;
			return soap_in_tt__VideoSource(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IntList"))
		{	*type = SOAP_TYPE_tt__IntList;
			return soap_in_tt__IntList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DurationRange"))
		{	*type = SOAP_TYPE_tt__DurationRange;
			return soap_in_tt__DurationRange(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:FloatRange"))
		{	*type = SOAP_TYPE_tt__FloatRange;
			return soap_in_tt__FloatRange(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IntRange"))
		{	*type = SOAP_TYPE_tt__IntRange;
			return soap_in_tt__IntRange(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IntRectangleRange"))
		{	*type = SOAP_TYPE_tt__IntRectangleRange;
			return soap_in_tt__IntRectangleRange(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:IntRectangle"))
		{	*type = SOAP_TYPE_tt__IntRectangle;
			return soap_in_tt__IntRectangle(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:DeviceEntity"))
		{	*type = SOAP_TYPE_tt__DeviceEntity;
			return soap_in_tt__DeviceEntity(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsr:ResourceUnknownFaultType"))
		{	*type = SOAP_TYPE_wsr__ResourceUnknownFaultType;
			return soap_in_wsr__ResourceUnknownFaultType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wstop:TopicSetType"))
		{	*type = SOAP_TYPE_wstop__TopicSetType;
			return soap_in_wstop__TopicSetType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wstop:QueryExpressionType"))
		{	*type = SOAP_TYPE_wstop__QueryExpressionType;
			return soap_in_wstop__QueryExpressionType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wstop:ExtensibleDocumented"))
		{	*type = SOAP_TYPE_wstop__ExtensibleDocumented;
			return soap_in_wstop__ExtensibleDocumented(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wstop:Documentation"))
		{	*type = SOAP_TYPE_wstop__Documentation;
			return soap_in_wstop__Documentation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:AttributedURIType"))
		{	*type = SOAP_TYPE_wsa__AttributedURIType;
			return soap_in_wsa__AttributedURIType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:RelatesToType"))
		{	*type = SOAP_TYPE_wsa__RelatesToType;
			return soap_in_wsa__RelatesToType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:MetadataType"))
		{	*type = SOAP_TYPE_wsa__MetadataType;
			return soap_in_wsa__MetadataType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:ReferenceParametersType"))
		{	*type = SOAP_TYPE_wsa__ReferenceParametersType;
			return soap_in_wsa__ReferenceParametersType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:EndpointReferenceType"))
		{	*type = SOAP_TYPE_wsa__EndpointReferenceType;
			return soap_in_wsa__EndpointReferenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsbf:BaseFaultType"))
		{	*type = SOAP_TYPE_wsbf__BaseFaultType;
			return soap_in_wsbf__BaseFaultType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:UnableToDestroySubscriptionFaultType"))
		{	*type = SOAP_TYPE_wsnt__UnableToDestroySubscriptionFaultType;
			return soap_in_wsnt__UnableToDestroySubscriptionFaultType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:NotificationMessageHolderType"))
		{	*type = SOAP_TYPE_wsnt__NotificationMessageHolderType;
			return soap_in_wsnt__NotificationMessageHolderType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:FilterType"))
		{	*type = SOAP_TYPE_wsnt__FilterType;
			return soap_in_wsnt__FilterType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:TopicExpressionType"))
		{	*type = SOAP_TYPE_wsnt__TopicExpressionType;
			return soap_in_wsnt__TopicExpressionType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:QueryExpressionType"))
		{	*type = SOAP_TYPE_wsnt__QueryExpressionType;
			return soap_in_wsnt__QueryExpressionType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:AttributedURI"))
		{	*type = SOAP_TYPE_wsadis__AttributedURI;
			return soap_in_wsadis__AttributedURI(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:AttributedQName"))
		{	*type = SOAP_TYPE_wsadis__AttributedQName;
			return soap_in_wsadis__AttributedQName(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:Relationship"))
		{	*type = SOAP_TYPE_wsadis__Relationship;
			return soap_in_wsadis__Relationship(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:ServiceNameType"))
		{	*type = SOAP_TYPE_wsadis__ServiceNameType;
			return soap_in_wsadis__ServiceNameType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:ReferenceParametersType"))
		{	*type = SOAP_TYPE_wsadis__ReferenceParametersType;
			return soap_in_wsadis__ReferenceParametersType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:ReferencePropertiesType"))
		{	*type = SOAP_TYPE_wsadis__ReferencePropertiesType;
			return soap_in_wsadis__ReferencePropertiesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:EndpointReferenceType"))
		{	*type = SOAP_TYPE_wsadis__EndpointReferenceType;
			return soap_in_wsadis__EndpointReferenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Domain"))
		{	char **s;
			*type = SOAP_TYPE_tt__Domain;
			s = soap_in_tt__Domain(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "tt:DNSName"))
		{	char **s;
			*type = SOAP_TYPE_tt__DNSName;
			s = soap_in_tt__DNSName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "tt:HwAddress"))
		{	char **s;
			*type = SOAP_TYPE_tt__HwAddress;
			s = soap_in_tt__HwAddress(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "tt:IPv4Address"))
		{	char **s;
			*type = SOAP_TYPE_tt__IPv4Address;
			s = soap_in_tt__IPv4Address(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "tt:Name"))
		{	char **s;
			*type = SOAP_TYPE_tt__Name;
			s = soap_in_tt__Name(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "tt:ReferenceToken"))
		{	char **s;
			*type = SOAP_TYPE_tt__ReferenceToken;
			s = soap_in_tt__ReferenceToken(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "d:UriListType"))
		{	char **s;
			*type = SOAP_TYPE_d__UriListType;
			s = soap_in_d__UriListType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "d:QNameListType"))
		{	char **s;
			*type = SOAP_TYPE_d__QNameListType;
			s = soap_in_d__QNameListType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsa:RelationshipTypeOpenEnum"))
		{	char **s;
			*type = SOAP_TYPE_wsa__RelationshipTypeOpenEnum;
			s = soap_in_wsa__RelationshipTypeOpenEnum(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsnt:AbsoluteOrRelativeTimeType"))
		{	char **s;
			*type = SOAP_TYPE_wsnt__AbsoluteOrRelativeTimeType;
			s = soap_in_wsnt__AbsoluteOrRelativeTimeType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:token"))
		{	char **s;
			*type = SOAP_TYPE_xsd__token;
			s = soap_in_xsd__token(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:duration"))
		{	char **s;
			*type = SOAP_TYPE_xsd__duration;
			s = soap_in_xsd__duration(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:anyURI"))
		{	char **s;
			*type = SOAP_TYPE_xsd__anyURI;
			s = soap_in_xsd__anyURI(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:anySimpleType"))
		{	char **s;
			*type = SOAP_TYPE_xsd__anySimpleType;
			s = soap_in_xsd__anySimpleType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:Name"))
		{	char **s;
			*type = SOAP_TYPE_xsd__Name;
			s = soap_in_xsd__Name(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:NCName"))
		{	char **s;
			*type = SOAP_TYPE_xsd__NCName;
			s = soap_in_xsd__NCName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "d:MetadataVersion"))
		{	*type = SOAP_TYPE__d__MetadataVersion;
			return soap_in__d__MetadataVersion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:TerminationTime"))
		{	*type = SOAP_TYPE__wsnt__TerminationTime;
			return soap_in__wsnt__TerminationTime(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:CurrentTime"))
		{	*type = SOAP_TYPE__wsnt__CurrentTime;
			return soap_in__wsnt__CurrentTime(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wstop:topic"))
		{	*type = SOAP_TYPE__wstop__topic;
			return soap_in__wstop__topic(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:FixedTopicSet"))
		{	*type = SOAP_TYPE__wsnt__FixedTopicSet;
			return soap_in__wsnt__FixedTopicSet(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsu:Timestamp"))
		{	*type = SOAP_TYPE__wsu__Timestamp;
			return soap_in__wsu__Timestamp(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:Password"))
		{	*type = SOAP_TYPE__wsse__Password;
			return soap_in__wsse__Password(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:Security"))
		{	*type = SOAP_TYPE__wsse__Security;
			return soap_in__wsse__Security(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:UsernameToken"))
		{	*type = SOAP_TYPE__wsse__UsernameToken;
			return soap_in__wsse__UsernameToken(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:AppSequence"))
		{	*type = SOAP_TYPE__d__AppSequence;
			return soap_in__d__AppSequence(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Scopes"))
		{	*type = SOAP_TYPE__d__Scopes;
			return soap_in__d__Scopes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Resolve"))
		{	*type = SOAP_TYPE__d__Resolve;
			return soap_in__d__Resolve(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ByeResponse"))
		{	*type = SOAP_TYPE__d__ByeResponse;
			return soap_in__d__ByeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Bye"))
		{	*type = SOAP_TYPE__d__Bye;
			return soap_in__d__Bye(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ProbeMatches"))
		{	*type = SOAP_TYPE__d__ProbeMatches;
			return soap_in__d__ProbeMatches(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Probe"))
		{	*type = SOAP_TYPE__d__Probe;
			return soap_in__d__Probe(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:HelloResponse"))
		{	*type = SOAP_TYPE__d__HelloResponse;
			return soap_in__d__HelloResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Hello"))
		{	*type = SOAP_TYPE__d__Hello;
			return soap_in__d__Hello(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:Capabilities"))
		{	*type = SOAP_TYPE__trt__Capabilities;
			return soap_in__trt__Capabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsaw:InterfaceName"))
		{	*type = SOAP_TYPE__wsaw__InterfaceName;
			return soap_in__wsaw__InterfaceName(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsaw:ServiceName"))
		{	*type = SOAP_TYPE__wsaw__ServiceName;
			return soap_in__wsaw__ServiceName(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:MetadataConfiguration"))
		{	*type = SOAP_TYPE__tt__MetadataConfiguration;
			return soap_in__tt__MetadataConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:PTZConfiguration"))
		{	*type = SOAP_TYPE__tt__PTZConfiguration;
			return soap_in__tt__PTZConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioEncoderConfiguration"))
		{	*type = SOAP_TYPE__tt__AudioEncoderConfiguration;
			return soap_in__tt__AudioEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoEncoderConfiguration"))
		{	*type = SOAP_TYPE__tt__VideoEncoderConfiguration;
			return soap_in__tt__VideoEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:AudioSourceConfiguration"))
		{	*type = SOAP_TYPE__tt__AudioSourceConfiguration;
			return soap_in__tt__AudioSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:VideoSourceConfiguration"))
		{	*type = SOAP_TYPE__tt__VideoSourceConfiguration;
			return soap_in__tt__VideoSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsr:ResourceUnknownFault"))
		{	*type = SOAP_TYPE__wsr__ResourceUnknownFault;
			return soap_in__wsr__ResourceUnknownFault(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wstop:TopicSet"))
		{	*type = SOAP_TYPE__wstop__TopicSet;
			return soap_in__wstop__TopicSet(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:Action"))
		{	*type = SOAP_TYPE__wsa__Action;
			return soap_in__wsa__Action(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:To"))
		{	*type = SOAP_TYPE__wsa__To;
			return soap_in__wsa__To(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:FaultTo"))
		{	*type = SOAP_TYPE__wsa__FaultTo;
			return soap_in__wsa__FaultTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:From"))
		{	*type = SOAP_TYPE__wsa__From;
			return soap_in__wsa__From(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:ReplyTo"))
		{	*type = SOAP_TYPE__wsa__ReplyTo;
			return soap_in__wsa__ReplyTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:RelatesTo"))
		{	*type = SOAP_TYPE__wsa__RelatesTo;
			return soap_in__wsa__RelatesTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:MessageID"))
		{	*type = SOAP_TYPE__wsa__MessageID;
			return soap_in__wsa__MessageID(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:Metadata"))
		{	*type = SOAP_TYPE__wsa__Metadata;
			return soap_in__wsa__Metadata(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:EndpointReference"))
		{	*type = SOAP_TYPE__wsa__EndpointReference;
			return soap_in__wsa__EndpointReference(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsbf:BaseFault"))
		{	*type = SOAP_TYPE__wsbf__BaseFault;
			return soap_in__wsbf__BaseFault(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:UnableToDestroySubscriptionFault"))
		{	*type = SOAP_TYPE__wsnt__UnableToDestroySubscriptionFault;
			return soap_in__wsnt__UnableToDestroySubscriptionFault(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:MessageContent"))
		{	*type = SOAP_TYPE__wsnt__MessageContent;
			return soap_in__wsnt__MessageContent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:NotificationMessage"))
		{	*type = SOAP_TYPE__wsnt__NotificationMessage;
			return soap_in__wsnt__NotificationMessage(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:ProducerReference"))
		{	*type = SOAP_TYPE__wsnt__ProducerReference;
			return soap_in__wsnt__ProducerReference(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:Topic"))
		{	*type = SOAP_TYPE__wsnt__Topic;
			return soap_in__wsnt__Topic(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:SubscriptionReference"))
		{	*type = SOAP_TYPE__wsnt__SubscriptionReference;
			return soap_in__wsnt__SubscriptionReference(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:TopicExpression"))
		{	*type = SOAP_TYPE__wsnt__TopicExpression;
			return soap_in__wsnt__TopicExpression(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:FaultTo"))
		{	*type = SOAP_TYPE__wsadis__FaultTo;
			return soap_in__wsadis__FaultTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:ReplyTo"))
		{	*type = SOAP_TYPE__wsadis__ReplyTo;
			return soap_in__wsadis__ReplyTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:From"))
		{	*type = SOAP_TYPE__wsadis__From;
			return soap_in__wsadis__From(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:Action"))
		{	*type = SOAP_TYPE__wsadis__Action;
			return soap_in__wsadis__Action(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:To"))
		{	*type = SOAP_TYPE__wsadis__To;
			return soap_in__wsadis__To(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:RelatesTo"))
		{	*type = SOAP_TYPE__wsadis__RelatesTo;
			return soap_in__wsadis__RelatesTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:MessageID"))
		{	*type = SOAP_TYPE__wsadis__MessageID;
			return soap_in__wsadis__MessageID(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsadis:EndpointReference"))
		{	*type = SOAP_TYPE__wsadis__EndpointReference;
			return soap_in__wsadis__EndpointReference(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsbf:ResourceUnknownFaultType-FaultCause"))
		{	*type = SOAP_TYPE__wsbf__ResourceUnknownFaultType_FaultCause;
			return soap_in__wsbf__ResourceUnknownFaultType_FaultCause(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsbf:ResourceUnknownFaultType-Description"))
		{	*type = SOAP_TYPE__wsbf__ResourceUnknownFaultType_Description;
			return soap_in__wsbf__ResourceUnknownFaultType_Description(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsbf:ResourceUnknownFaultType-ErrorCode"))
		{	*type = SOAP_TYPE__wsbf__ResourceUnknownFaultType_ErrorCode;
			return soap_in__wsbf__ResourceUnknownFaultType_ErrorCode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsbf:UnableToDestroySubscriptionFaultType-FaultCause"))
		{	*type = SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_FaultCause;
			return soap_in__wsbf__UnableToDestroySubscriptionFaultType_FaultCause(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsbf:UnableToDestroySubscriptionFaultType-Description"))
		{	*type = SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_Description;
			return soap_in__wsbf__UnableToDestroySubscriptionFaultType_Description(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsbf:UnableToDestroySubscriptionFaultType-ErrorCode"))
		{	*type = SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode;
			return soap_in__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ItemListDescription-SimpleItemDescription"))
		{	*type = SOAP_TYPE__tt__ItemListDescription_SimpleItemDescription;
			return soap_in__tt__ItemListDescription_SimpleItemDescription(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:ItemList-SimpleItem"))
		{	*type = SOAP_TYPE__tt__ItemList_SimpleItem;
			return soap_in__tt__ItemList_SimpleItem(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsbf:BaseFaultType-FaultCause"))
		{	*type = SOAP_TYPE__wsbf__BaseFaultType_FaultCause;
			return soap_in__wsbf__BaseFaultType_FaultCause(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsbf:BaseFaultType-Description"))
		{	*type = SOAP_TYPE__wsbf__BaseFaultType_Description;
			return soap_in__wsbf__BaseFaultType_Description(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsbf:BaseFaultType-ErrorCode"))
		{	*type = SOAP_TYPE__wsbf__BaseFaultType_ErrorCode;
			return soap_in__wsbf__BaseFaultType_ErrorCode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:NotificationMessageHolderType-Message"))
		{	*type = SOAP_TYPE__wsnt__NotificationMessageHolderType_Message;
			return soap_in__wsnt__NotificationMessageHolderType_Message(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:StopResponse"))
		{	*type = SOAP_TYPE__tptz__StopResponse;
			return soap_in__tptz__StopResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:Stop"))
		{	*type = SOAP_TYPE__tptz__Stop;
			return soap_in__tptz__Stop(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:AbsoluteMoveResponse"))
		{	*type = SOAP_TYPE__tptz__AbsoluteMoveResponse;
			return soap_in__tptz__AbsoluteMoveResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:AbsoluteMove"))
		{	*type = SOAP_TYPE__tptz__AbsoluteMove;
			return soap_in__tptz__AbsoluteMove(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:ContinuousMoveResponse"))
		{	*type = SOAP_TYPE__tptz__ContinuousMoveResponse;
			return soap_in__tptz__ContinuousMoveResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:ContinuousMove"))
		{	*type = SOAP_TYPE__tptz__ContinuousMove;
			return soap_in__tptz__ContinuousMove(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:SetHomePosition"))
		{	*type = SOAP_TYPE__tptz__SetHomePosition;
			return soap_in__tptz__SetHomePosition(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GotoHomePositionResponse"))
		{	*type = SOAP_TYPE__tptz__GotoHomePositionResponse;
			return soap_in__tptz__GotoHomePositionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GotoHomePosition"))
		{	*type = SOAP_TYPE__tptz__GotoHomePosition;
			return soap_in__tptz__GotoHomePosition(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GetStatusResponse"))
		{	*type = SOAP_TYPE__tptz__GetStatusResponse;
			return soap_in__tptz__GetStatusResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GetStatus"))
		{	*type = SOAP_TYPE__tptz__GetStatus;
			return soap_in__tptz__GetStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GetPresetResponse"))
		{	*type = SOAP_TYPE__tptz__GetPresetResponse;
			return soap_in__tptz__GetPresetResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GetPreset"))
		{	*type = SOAP_TYPE__tptz__GetPreset;
			return soap_in__tptz__GetPreset(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GotoPresetResponse"))
		{	*type = SOAP_TYPE__tptz__GotoPresetResponse;
			return soap_in__tptz__GotoPresetResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GotoPreset"))
		{	*type = SOAP_TYPE__tptz__GotoPreset;
			return soap_in__tptz__GotoPreset(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:RemovePresetResponse"))
		{	*type = SOAP_TYPE__tptz__RemovePresetResponse;
			return soap_in__tptz__RemovePresetResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:RemovePreset"))
		{	*type = SOAP_TYPE__tptz__RemovePreset;
			return soap_in__tptz__RemovePreset(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:SetPresetResponse"))
		{	*type = SOAP_TYPE__tptz__SetPresetResponse;
			return soap_in__tptz__SetPresetResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:SetPreset"))
		{	*type = SOAP_TYPE__tptz__SetPreset;
			return soap_in__tptz__SetPreset(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GetPresetsResponse"))
		{	*type = SOAP_TYPE__tptz__GetPresetsResponse;
			return soap_in__tptz__GetPresetsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GetPresets"))
		{	*type = SOAP_TYPE__tptz__GetPresets;
			return soap_in__tptz__GetPresets(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GetConfigurationOptionsResponse"))
		{	*type = SOAP_TYPE__tptz__GetConfigurationOptionsResponse;
			return soap_in__tptz__GetConfigurationOptionsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GetConfigurationOptions"))
		{	*type = SOAP_TYPE__tptz__GetConfigurationOptions;
			return soap_in__tptz__GetConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:SetConfigurationResponse"))
		{	*type = SOAP_TYPE__tptz__SetConfigurationResponse;
			return soap_in__tptz__SetConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:SetConfiguration"))
		{	*type = SOAP_TYPE__tptz__SetConfiguration;
			return soap_in__tptz__SetConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GetConfigurationResponse"))
		{	*type = SOAP_TYPE__tptz__GetConfigurationResponse;
			return soap_in__tptz__GetConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GetConfiguration"))
		{	*type = SOAP_TYPE__tptz__GetConfiguration;
			return soap_in__tptz__GetConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GetConfigurationsResponse"))
		{	*type = SOAP_TYPE__tptz__GetConfigurationsResponse;
			return soap_in__tptz__GetConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GetConfigurations"))
		{	*type = SOAP_TYPE__tptz__GetConfigurations;
			return soap_in__tptz__GetConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GetNodeResponse"))
		{	*type = SOAP_TYPE__tptz__GetNodeResponse;
			return soap_in__tptz__GetNodeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GetNode"))
		{	*type = SOAP_TYPE__tptz__GetNode;
			return soap_in__tptz__GetNode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GetNodesResponse"))
		{	*type = SOAP_TYPE__tptz__GetNodesResponse;
			return soap_in__tptz__GetNodesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tptz:GetNodes"))
		{	*type = SOAP_TYPE__tptz__GetNodes;
			return soap_in__tptz__GetNodes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetSnapshotUriResponse"))
		{	*type = SOAP_TYPE__trt__GetSnapshotUriResponse;
			return soap_in__trt__GetSnapshotUriResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetSnapshotUri"))
		{	*type = SOAP_TYPE__trt__GetSnapshotUri;
			return soap_in__trt__GetSnapshotUri(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetSynchronizationPointResponse"))
		{	*type = SOAP_TYPE__trt__SetSynchronizationPointResponse;
			return soap_in__trt__SetSynchronizationPointResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetSynchronizationPoint"))
		{	*type = SOAP_TYPE__trt__SetSynchronizationPoint;
			return soap_in__trt__SetSynchronizationPoint(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetStreamUriResponse"))
		{	*type = SOAP_TYPE__trt__GetStreamUriResponse;
			return soap_in__trt__GetStreamUriResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetStreamUri"))
		{	*type = SOAP_TYPE__trt__GetStreamUri;
			return soap_in__trt__GetStreamUri(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetGuaranteedNumberOfVideoEncoderInstancesResponse"))
		{	*type = SOAP_TYPE__trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse;
			return soap_in__trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetGuaranteedNumberOfVideoEncoderInstances"))
		{	*type = SOAP_TYPE__trt__GetGuaranteedNumberOfVideoEncoderInstances;
			return soap_in__trt__GetGuaranteedNumberOfVideoEncoderInstances(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetMetadataConfigurationOptionsResponse"))
		{	*type = SOAP_TYPE__trt__GetMetadataConfigurationOptionsResponse;
			return soap_in__trt__GetMetadataConfigurationOptionsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetMetadataConfigurationOptions"))
		{	*type = SOAP_TYPE__trt__GetMetadataConfigurationOptions;
			return soap_in__trt__GetMetadataConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioEncoderConfigurationOptionsResponse"))
		{	*type = SOAP_TYPE__trt__GetAudioEncoderConfigurationOptionsResponse;
			return soap_in__trt__GetAudioEncoderConfigurationOptionsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioEncoderConfigurationOptions"))
		{	*type = SOAP_TYPE__trt__GetAudioEncoderConfigurationOptions;
			return soap_in__trt__GetAudioEncoderConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioSourceConfigurationOptionsResponse"))
		{	*type = SOAP_TYPE__trt__GetAudioSourceConfigurationOptionsResponse;
			return soap_in__trt__GetAudioSourceConfigurationOptionsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioSourceConfigurationOptions"))
		{	*type = SOAP_TYPE__trt__GetAudioSourceConfigurationOptions;
			return soap_in__trt__GetAudioSourceConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoEncoderConfigurationOptionsResponse"))
		{	*type = SOAP_TYPE__trt__GetVideoEncoderConfigurationOptionsResponse;
			return soap_in__trt__GetVideoEncoderConfigurationOptionsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoEncoderConfigurationOptions"))
		{	*type = SOAP_TYPE__trt__GetVideoEncoderConfigurationOptions;
			return soap_in__trt__GetVideoEncoderConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoSourceConfigurationOptionsResponse"))
		{	*type = SOAP_TYPE__trt__GetVideoSourceConfigurationOptionsResponse;
			return soap_in__trt__GetVideoSourceConfigurationOptionsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoSourceConfigurationOptions"))
		{	*type = SOAP_TYPE__trt__GetVideoSourceConfigurationOptions;
			return soap_in__trt__GetVideoSourceConfigurationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetMetadataConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__SetMetadataConfigurationResponse;
			return soap_in__trt__SetMetadataConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetMetadataConfiguration"))
		{	*type = SOAP_TYPE__trt__SetMetadataConfiguration;
			return soap_in__trt__SetMetadataConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetAudioSourceConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__SetAudioSourceConfigurationResponse;
			return soap_in__trt__SetAudioSourceConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetAudioSourceConfiguration"))
		{	*type = SOAP_TYPE__trt__SetAudioSourceConfiguration;
			return soap_in__trt__SetAudioSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetAudioEncoderConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__SetAudioEncoderConfigurationResponse;
			return soap_in__trt__SetAudioEncoderConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetAudioEncoderConfiguration"))
		{	*type = SOAP_TYPE__trt__SetAudioEncoderConfiguration;
			return soap_in__trt__SetAudioEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetVideoSourceConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__SetVideoSourceConfigurationResponse;
			return soap_in__trt__SetVideoSourceConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetVideoSourceConfiguration"))
		{	*type = SOAP_TYPE__trt__SetVideoSourceConfiguration;
			return soap_in__trt__SetVideoSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetVideoEncoderConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__SetVideoEncoderConfigurationResponse;
			return soap_in__trt__SetVideoEncoderConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:SetVideoEncoderConfiguration"))
		{	*type = SOAP_TYPE__trt__SetVideoEncoderConfiguration;
			return soap_in__trt__SetVideoEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleMetadataConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetCompatibleMetadataConfigurationsResponse;
			return soap_in__trt__GetCompatibleMetadataConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleMetadataConfigurations"))
		{	*type = SOAP_TYPE__trt__GetCompatibleMetadataConfigurations;
			return soap_in__trt__GetCompatibleMetadataConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleAudioSourceConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurationsResponse;
			return soap_in__trt__GetCompatibleAudioSourceConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleAudioSourceConfigurations"))
		{	*type = SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurations;
			return soap_in__trt__GetCompatibleAudioSourceConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleAudioEncoderConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurationsResponse;
			return soap_in__trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleAudioEncoderConfigurations"))
		{	*type = SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurations;
			return soap_in__trt__GetCompatibleAudioEncoderConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleVideoSourceConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurationsResponse;
			return soap_in__trt__GetCompatibleVideoSourceConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleVideoSourceConfigurations"))
		{	*type = SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurations;
			return soap_in__trt__GetCompatibleVideoSourceConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleVideoEncoderConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurationsResponse;
			return soap_in__trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetCompatibleVideoEncoderConfigurations"))
		{	*type = SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurations;
			return soap_in__trt__GetCompatibleVideoEncoderConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetMetadataConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__GetMetadataConfigurationResponse;
			return soap_in__trt__GetMetadataConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetMetadataConfiguration"))
		{	*type = SOAP_TYPE__trt__GetMetadataConfiguration;
			return soap_in__trt__GetMetadataConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioEncoderConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__GetAudioEncoderConfigurationResponse;
			return soap_in__trt__GetAudioEncoderConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioEncoderConfiguration"))
		{	*type = SOAP_TYPE__trt__GetAudioEncoderConfiguration;
			return soap_in__trt__GetAudioEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioSourceConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__GetAudioSourceConfigurationResponse;
			return soap_in__trt__GetAudioSourceConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioSourceConfiguration"))
		{	*type = SOAP_TYPE__trt__GetAudioSourceConfiguration;
			return soap_in__trt__GetAudioSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoEncoderConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__GetVideoEncoderConfigurationResponse;
			return soap_in__trt__GetVideoEncoderConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoEncoderConfiguration"))
		{	*type = SOAP_TYPE__trt__GetVideoEncoderConfiguration;
			return soap_in__trt__GetVideoEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoSourceConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__GetVideoSourceConfigurationResponse;
			return soap_in__trt__GetVideoSourceConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoSourceConfiguration"))
		{	*type = SOAP_TYPE__trt__GetVideoSourceConfiguration;
			return soap_in__trt__GetVideoSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetMetadataConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetMetadataConfigurationsResponse;
			return soap_in__trt__GetMetadataConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetMetadataConfigurations"))
		{	*type = SOAP_TYPE__trt__GetMetadataConfigurations;
			return soap_in__trt__GetMetadataConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioSourceConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetAudioSourceConfigurationsResponse;
			return soap_in__trt__GetAudioSourceConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioSourceConfigurations"))
		{	*type = SOAP_TYPE__trt__GetAudioSourceConfigurations;
			return soap_in__trt__GetAudioSourceConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioEncoderConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetAudioEncoderConfigurationsResponse;
			return soap_in__trt__GetAudioEncoderConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioEncoderConfigurations"))
		{	*type = SOAP_TYPE__trt__GetAudioEncoderConfigurations;
			return soap_in__trt__GetAudioEncoderConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoSourceConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetVideoSourceConfigurationsResponse;
			return soap_in__trt__GetVideoSourceConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoSourceConfigurations"))
		{	*type = SOAP_TYPE__trt__GetVideoSourceConfigurations;
			return soap_in__trt__GetVideoSourceConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoEncoderConfigurationsResponse"))
		{	*type = SOAP_TYPE__trt__GetVideoEncoderConfigurationsResponse;
			return soap_in__trt__GetVideoEncoderConfigurationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoEncoderConfigurations"))
		{	*type = SOAP_TYPE__trt__GetVideoEncoderConfigurations;
			return soap_in__trt__GetVideoEncoderConfigurations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:DeleteProfileResponse"))
		{	*type = SOAP_TYPE__trt__DeleteProfileResponse;
			return soap_in__trt__DeleteProfileResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:DeleteProfile"))
		{	*type = SOAP_TYPE__trt__DeleteProfile;
			return soap_in__trt__DeleteProfile(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveMetadataConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__RemoveMetadataConfigurationResponse;
			return soap_in__trt__RemoveMetadataConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveMetadataConfiguration"))
		{	*type = SOAP_TYPE__trt__RemoveMetadataConfiguration;
			return soap_in__trt__RemoveMetadataConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddMetadataConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__AddMetadataConfigurationResponse;
			return soap_in__trt__AddMetadataConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddMetadataConfiguration"))
		{	*type = SOAP_TYPE__trt__AddMetadataConfiguration;
			return soap_in__trt__AddMetadataConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemovePTZConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__RemovePTZConfigurationResponse;
			return soap_in__trt__RemovePTZConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemovePTZConfiguration"))
		{	*type = SOAP_TYPE__trt__RemovePTZConfiguration;
			return soap_in__trt__RemovePTZConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddPTZConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__AddPTZConfigurationResponse;
			return soap_in__trt__AddPTZConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddPTZConfiguration"))
		{	*type = SOAP_TYPE__trt__AddPTZConfiguration;
			return soap_in__trt__AddPTZConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveAudioSourceConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__RemoveAudioSourceConfigurationResponse;
			return soap_in__trt__RemoveAudioSourceConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveAudioSourceConfiguration"))
		{	*type = SOAP_TYPE__trt__RemoveAudioSourceConfiguration;
			return soap_in__trt__RemoveAudioSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddAudioSourceConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__AddAudioSourceConfigurationResponse;
			return soap_in__trt__AddAudioSourceConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddAudioSourceConfiguration"))
		{	*type = SOAP_TYPE__trt__AddAudioSourceConfiguration;
			return soap_in__trt__AddAudioSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveAudioEncoderConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__RemoveAudioEncoderConfigurationResponse;
			return soap_in__trt__RemoveAudioEncoderConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveAudioEncoderConfiguration"))
		{	*type = SOAP_TYPE__trt__RemoveAudioEncoderConfiguration;
			return soap_in__trt__RemoveAudioEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddAudioEncoderConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__AddAudioEncoderConfigurationResponse;
			return soap_in__trt__AddAudioEncoderConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddAudioEncoderConfiguration"))
		{	*type = SOAP_TYPE__trt__AddAudioEncoderConfiguration;
			return soap_in__trt__AddAudioEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveVideoSourceConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__RemoveVideoSourceConfigurationResponse;
			return soap_in__trt__RemoveVideoSourceConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveVideoSourceConfiguration"))
		{	*type = SOAP_TYPE__trt__RemoveVideoSourceConfiguration;
			return soap_in__trt__RemoveVideoSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddVideoSourceConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__AddVideoSourceConfigurationResponse;
			return soap_in__trt__AddVideoSourceConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddVideoSourceConfiguration"))
		{	*type = SOAP_TYPE__trt__AddVideoSourceConfiguration;
			return soap_in__trt__AddVideoSourceConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveVideoEncoderConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__RemoveVideoEncoderConfigurationResponse;
			return soap_in__trt__RemoveVideoEncoderConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:RemoveVideoEncoderConfiguration"))
		{	*type = SOAP_TYPE__trt__RemoveVideoEncoderConfiguration;
			return soap_in__trt__RemoveVideoEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddVideoEncoderConfigurationResponse"))
		{	*type = SOAP_TYPE__trt__AddVideoEncoderConfigurationResponse;
			return soap_in__trt__AddVideoEncoderConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:AddVideoEncoderConfiguration"))
		{	*type = SOAP_TYPE__trt__AddVideoEncoderConfiguration;
			return soap_in__trt__AddVideoEncoderConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetProfilesResponse"))
		{	*type = SOAP_TYPE__trt__GetProfilesResponse;
			return soap_in__trt__GetProfilesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetProfiles"))
		{	*type = SOAP_TYPE__trt__GetProfiles;
			return soap_in__trt__GetProfiles(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetProfileResponse"))
		{	*type = SOAP_TYPE__trt__GetProfileResponse;
			return soap_in__trt__GetProfileResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetProfile"))
		{	*type = SOAP_TYPE__trt__GetProfile;
			return soap_in__trt__GetProfile(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:CreateProfileResponse"))
		{	*type = SOAP_TYPE__trt__CreateProfileResponse;
			return soap_in__trt__CreateProfileResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:CreateProfile"))
		{	*type = SOAP_TYPE__trt__CreateProfile;
			return soap_in__trt__CreateProfile(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioSourcesResponse"))
		{	*type = SOAP_TYPE__trt__GetAudioSourcesResponse;
			return soap_in__trt__GetAudioSourcesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetAudioSources"))
		{	*type = SOAP_TYPE__trt__GetAudioSources;
			return soap_in__trt__GetAudioSources(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoSourcesResponse"))
		{	*type = SOAP_TYPE__trt__GetVideoSourcesResponse;
			return soap_in__trt__GetVideoSourcesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetVideoSources"))
		{	*type = SOAP_TYPE__trt__GetVideoSources;
			return soap_in__trt__GetVideoSources(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetServiceCapabilitiesResponse"))
		{	*type = SOAP_TYPE__trt__GetServiceCapabilitiesResponse;
			return soap_in__trt__GetServiceCapabilitiesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "trt:GetServiceCapabilities"))
		{	*type = SOAP_TYPE__trt__GetServiceCapabilities;
			return soap_in__trt__GetServiceCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsaw:Anonymous"))
		{	*type = SOAP_TYPE__wsaw__Anonymous;
			return soap_in__wsaw__Anonymous(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsaw:UsingAddressing"))
		{	*type = SOAP_TYPE__wsaw__UsingAddressing;
			return soap_in__wsaw__UsingAddressing(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tev:GetEventPropertiesResponse"))
		{	*type = SOAP_TYPE__tev__GetEventPropertiesResponse;
			return soap_in__tev__GetEventPropertiesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tev:GetEventProperties"))
		{	*type = SOAP_TYPE__tev__GetEventProperties;
			return soap_in__tev__GetEventProperties(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tev:SetSynchronizationPointResponse"))
		{	*type = SOAP_TYPE__tev__SetSynchronizationPointResponse;
			return soap_in__tev__SetSynchronizationPointResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tev:SetSynchronizationPoint"))
		{	*type = SOAP_TYPE__tev__SetSynchronizationPoint;
			return soap_in__tev__SetSynchronizationPoint(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tev:PullMessagesFaultResponse"))
		{	*type = SOAP_TYPE__tev__PullMessagesFaultResponse;
			return soap_in__tev__PullMessagesFaultResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tev:PullMessagesResponse"))
		{	*type = SOAP_TYPE__tev__PullMessagesResponse;
			return soap_in__tev__PullMessagesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tev:PullMessages"))
		{	*type = SOAP_TYPE__tev__PullMessages;
			return soap_in__tev__PullMessages(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tev:CreatePullPointSubscriptionResponse"))
		{	*type = SOAP_TYPE__tev__CreatePullPointSubscriptionResponse;
			return soap_in__tev__CreatePullPointSubscriptionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tev:CreatePullPointSubscription"))
		{	*type = SOAP_TYPE__tev__CreatePullPointSubscription;
			return soap_in__tev__CreatePullPointSubscription(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetRelayOutputStateResponse"))
		{	*type = SOAP_TYPE__tds__SetRelayOutputStateResponse;
			return soap_in__tds__SetRelayOutputStateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetRelayOutputState"))
		{	*type = SOAP_TYPE__tds__SetRelayOutputState;
			return soap_in__tds__SetRelayOutputState(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetRelayOutputSettingsResponse"))
		{	*type = SOAP_TYPE__tds__SetRelayOutputSettingsResponse;
			return soap_in__tds__SetRelayOutputSettingsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetRelayOutputSettings"))
		{	*type = SOAP_TYPE__tds__SetRelayOutputSettings;
			return soap_in__tds__SetRelayOutputSettings(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetRelayOutputsResponse"))
		{	*type = SOAP_TYPE__tds__GetRelayOutputsResponse;
			return soap_in__tds__GetRelayOutputsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetRelayOutputs"))
		{	*type = SOAP_TYPE__tds__GetRelayOutputs;
			return soap_in__tds__GetRelayOutputs(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetZeroConfigurationResponse"))
		{	*type = SOAP_TYPE__tds__SetZeroConfigurationResponse;
			return soap_in__tds__SetZeroConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetZeroConfiguration"))
		{	*type = SOAP_TYPE__tds__SetZeroConfiguration;
			return soap_in__tds__SetZeroConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetZeroConfigurationResponse"))
		{	*type = SOAP_TYPE__tds__GetZeroConfigurationResponse;
			return soap_in__tds__GetZeroConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetZeroConfiguration"))
		{	*type = SOAP_TYPE__tds__GetZeroConfiguration;
			return soap_in__tds__GetZeroConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetNetworkDefaultGatewayResponse"))
		{	*type = SOAP_TYPE__tds__SetNetworkDefaultGatewayResponse;
			return soap_in__tds__SetNetworkDefaultGatewayResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetNetworkDefaultGateway"))
		{	*type = SOAP_TYPE__tds__SetNetworkDefaultGateway;
			return soap_in__tds__SetNetworkDefaultGateway(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetNetworkDefaultGatewayResponse"))
		{	*type = SOAP_TYPE__tds__GetNetworkDefaultGatewayResponse;
			return soap_in__tds__GetNetworkDefaultGatewayResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetNetworkDefaultGateway"))
		{	*type = SOAP_TYPE__tds__GetNetworkDefaultGateway;
			return soap_in__tds__GetNetworkDefaultGateway(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetNetworkProtocolsResponse"))
		{	*type = SOAP_TYPE__tds__SetNetworkProtocolsResponse;
			return soap_in__tds__SetNetworkProtocolsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetNetworkProtocols"))
		{	*type = SOAP_TYPE__tds__SetNetworkProtocols;
			return soap_in__tds__SetNetworkProtocols(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetNetworkProtocolsResponse"))
		{	*type = SOAP_TYPE__tds__GetNetworkProtocolsResponse;
			return soap_in__tds__GetNetworkProtocolsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetNetworkProtocols"))
		{	*type = SOAP_TYPE__tds__GetNetworkProtocols;
			return soap_in__tds__GetNetworkProtocols(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetNetworkInterfacesResponse"))
		{	*type = SOAP_TYPE__tds__SetNetworkInterfacesResponse;
			return soap_in__tds__SetNetworkInterfacesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetNetworkInterfaces"))
		{	*type = SOAP_TYPE__tds__SetNetworkInterfaces;
			return soap_in__tds__SetNetworkInterfaces(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetNetworkInterfacesResponse"))
		{	*type = SOAP_TYPE__tds__GetNetworkInterfacesResponse;
			return soap_in__tds__GetNetworkInterfacesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetNetworkInterfaces"))
		{	*type = SOAP_TYPE__tds__GetNetworkInterfaces;
			return soap_in__tds__GetNetworkInterfaces(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetDynamicDNSResponse"))
		{	*type = SOAP_TYPE__tds__SetDynamicDNSResponse;
			return soap_in__tds__SetDynamicDNSResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetDynamicDNS"))
		{	*type = SOAP_TYPE__tds__SetDynamicDNS;
			return soap_in__tds__SetDynamicDNS(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetDynamicDNSResponse"))
		{	*type = SOAP_TYPE__tds__GetDynamicDNSResponse;
			return soap_in__tds__GetDynamicDNSResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetDynamicDNS"))
		{	*type = SOAP_TYPE__tds__GetDynamicDNS;
			return soap_in__tds__GetDynamicDNS(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetNTPResponse"))
		{	*type = SOAP_TYPE__tds__SetNTPResponse;
			return soap_in__tds__SetNTPResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetNTP"))
		{	*type = SOAP_TYPE__tds__SetNTP;
			return soap_in__tds__SetNTP(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetNTPResponse"))
		{	*type = SOAP_TYPE__tds__GetNTPResponse;
			return soap_in__tds__GetNTPResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetNTP"))
		{	*type = SOAP_TYPE__tds__GetNTP;
			return soap_in__tds__GetNTP(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetDNSResponse"))
		{	*type = SOAP_TYPE__tds__SetDNSResponse;
			return soap_in__tds__SetDNSResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetDNS"))
		{	*type = SOAP_TYPE__tds__SetDNS;
			return soap_in__tds__SetDNS(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetDNSResponse"))
		{	*type = SOAP_TYPE__tds__GetDNSResponse;
			return soap_in__tds__GetDNSResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetDNS"))
		{	*type = SOAP_TYPE__tds__GetDNS;
			return soap_in__tds__GetDNS(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetHostnameResponse"))
		{	*type = SOAP_TYPE__tds__SetHostnameResponse;
			return soap_in__tds__SetHostnameResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetHostname"))
		{	*type = SOAP_TYPE__tds__SetHostname;
			return soap_in__tds__SetHostname(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetHostnameResponse"))
		{	*type = SOAP_TYPE__tds__GetHostnameResponse;
			return soap_in__tds__GetHostnameResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetHostname"))
		{	*type = SOAP_TYPE__tds__GetHostname;
			return soap_in__tds__GetHostname(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetCapabilitiesResponse"))
		{	*type = SOAP_TYPE__tds__GetCapabilitiesResponse;
			return soap_in__tds__GetCapabilitiesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetCapabilities"))
		{	*type = SOAP_TYPE__tds__GetCapabilities;
			return soap_in__tds__GetCapabilities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetWsdlUrlResponse"))
		{	*type = SOAP_TYPE__tds__GetWsdlUrlResponse;
			return soap_in__tds__GetWsdlUrlResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetWsdlUrl"))
		{	*type = SOAP_TYPE__tds__GetWsdlUrl;
			return soap_in__tds__GetWsdlUrl(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetUserResponse"))
		{	*type = SOAP_TYPE__tds__SetUserResponse;
			return soap_in__tds__SetUserResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetUser"))
		{	*type = SOAP_TYPE__tds__SetUser;
			return soap_in__tds__SetUser(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:DeleteUsersResponse"))
		{	*type = SOAP_TYPE__tds__DeleteUsersResponse;
			return soap_in__tds__DeleteUsersResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:DeleteUsers"))
		{	*type = SOAP_TYPE__tds__DeleteUsers;
			return soap_in__tds__DeleteUsers(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:CreateUsersResponse"))
		{	*type = SOAP_TYPE__tds__CreateUsersResponse;
			return soap_in__tds__CreateUsersResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:CreateUsers"))
		{	*type = SOAP_TYPE__tds__CreateUsers;
			return soap_in__tds__CreateUsers(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetUsersResponse"))
		{	*type = SOAP_TYPE__tds__GetUsersResponse;
			return soap_in__tds__GetUsersResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetUsers"))
		{	*type = SOAP_TYPE__tds__GetUsers;
			return soap_in__tds__GetUsers(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetDiscoveryModeResponse"))
		{	*type = SOAP_TYPE__tds__SetDiscoveryModeResponse;
			return soap_in__tds__SetDiscoveryModeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetDiscoveryMode"))
		{	*type = SOAP_TYPE__tds__SetDiscoveryMode;
			return soap_in__tds__SetDiscoveryMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetDiscoveryModeResponse"))
		{	*type = SOAP_TYPE__tds__GetDiscoveryModeResponse;
			return soap_in__tds__GetDiscoveryModeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetDiscoveryMode"))
		{	*type = SOAP_TYPE__tds__GetDiscoveryMode;
			return soap_in__tds__GetDiscoveryMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:RemoveScopesResponse"))
		{	*type = SOAP_TYPE__tds__RemoveScopesResponse;
			return soap_in__tds__RemoveScopesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:RemoveScopes"))
		{	*type = SOAP_TYPE__tds__RemoveScopes;
			return soap_in__tds__RemoveScopes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:AddScopesResponse"))
		{	*type = SOAP_TYPE__tds__AddScopesResponse;
			return soap_in__tds__AddScopesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:AddScopes"))
		{	*type = SOAP_TYPE__tds__AddScopes;
			return soap_in__tds__AddScopes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetScopesResponse"))
		{	*type = SOAP_TYPE__tds__SetScopesResponse;
			return soap_in__tds__SetScopesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetScopes"))
		{	*type = SOAP_TYPE__tds__SetScopes;
			return soap_in__tds__SetScopes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetScopesResponse"))
		{	*type = SOAP_TYPE__tds__GetScopesResponse;
			return soap_in__tds__GetScopesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetScopes"))
		{	*type = SOAP_TYPE__tds__GetScopes;
			return soap_in__tds__GetScopes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetSystemLogResponse"))
		{	*type = SOAP_TYPE__tds__GetSystemLogResponse;
			return soap_in__tds__GetSystemLogResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetSystemLog"))
		{	*type = SOAP_TYPE__tds__GetSystemLog;
			return soap_in__tds__GetSystemLog(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SystemRebootResponse"))
		{	*type = SOAP_TYPE__tds__SystemRebootResponse;
			return soap_in__tds__SystemRebootResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SystemReboot"))
		{	*type = SOAP_TYPE__tds__SystemReboot;
			return soap_in__tds__SystemReboot(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetSystemFactoryDefaultResponse"))
		{	*type = SOAP_TYPE__tds__SetSystemFactoryDefaultResponse;
			return soap_in__tds__SetSystemFactoryDefaultResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetSystemFactoryDefault"))
		{	*type = SOAP_TYPE__tds__SetSystemFactoryDefault;
			return soap_in__tds__SetSystemFactoryDefault(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetSystemDateAndTimeResponse"))
		{	*type = SOAP_TYPE__tds__GetSystemDateAndTimeResponse;
			return soap_in__tds__GetSystemDateAndTimeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetSystemDateAndTime"))
		{	*type = SOAP_TYPE__tds__GetSystemDateAndTime;
			return soap_in__tds__GetSystemDateAndTime(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetSystemDateAndTimeResponse"))
		{	*type = SOAP_TYPE__tds__SetSystemDateAndTimeResponse;
			return soap_in__tds__SetSystemDateAndTimeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:SetSystemDateAndTime"))
		{	*type = SOAP_TYPE__tds__SetSystemDateAndTime;
			return soap_in__tds__SetSystemDateAndTime(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetDeviceInformationResponse"))
		{	*type = SOAP_TYPE__tds__GetDeviceInformationResponse;
			return soap_in__tds__GetDeviceInformationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tds:GetDeviceInformation"))
		{	*type = SOAP_TYPE__tds__GetDeviceInformation;
			return soap_in__tds__GetDeviceInformation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "tt:Message"))
		{	*type = SOAP_TYPE__tt__Message;
			return soap_in__tt__Message(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:UnsubscribeResponse"))
		{	*type = SOAP_TYPE__wsnt__UnsubscribeResponse;
			return soap_in__wsnt__UnsubscribeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:Unsubscribe"))
		{	*type = SOAP_TYPE__wsnt__Unsubscribe;
			return soap_in__wsnt__Unsubscribe(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:RenewResponse"))
		{	*type = SOAP_TYPE__wsnt__RenewResponse;
			return soap_in__wsnt__RenewResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:Renew"))
		{	*type = SOAP_TYPE__wsnt__Renew;
			return soap_in__wsnt__Renew(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:SubscribeResponse"))
		{	*type = SOAP_TYPE__wsnt__SubscribeResponse;
			return soap_in__wsnt__SubscribeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:Subscribe"))
		{	*type = SOAP_TYPE__wsnt__Subscribe;
			return soap_in__wsnt__Subscribe(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsnt:Notify"))
		{	*type = SOAP_TYPE__wsnt__Notify;
			return soap_in__wsnt__Notify(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsu:Created"))
		{	char **s;
			*type = SOAP_TYPE__wsu__Created;
			s = soap_in__wsu__Created(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsu:Id"))
		{	char **s;
			*type = SOAP_TYPE__wsu__Id;
			s = soap_in__wsu__Id(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "d:XAddrs"))
		{	char **s;
			*type = SOAP_TYPE__d__XAddrs;
			s = soap_in__d__XAddrs(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "d:Types"))
		{	char **s;
			*type = SOAP_TYPE__d__Types;
			s = soap_in__d__Types(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsaw:Action"))
		{	char **s;
			*type = SOAP_TYPE__wsaw__Action;
			s = soap_in__wsaw__Action(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsnt:TopicExpressionDialect"))
		{	char **s;
			*type = SOAP_TYPE__wsnt__TopicExpressionDialect;
			s = soap_in__wsnt__TopicExpressionDialect(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "tptz:SetHomePositionResponse"))
		{	char **s;
			*type = SOAP_TYPE__tptz__SetHomePositionResponse;
			s = soap_in__tptz__SetHomePositionResponse(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xml:lang"))
		{	char **s;
			*type = SOAP_TYPE__xml__lang;
			s = soap_in__xml__lang(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_tt__IANA_IfTypes:
		return soap_out_tt__IANA_IfTypes(soap, tag, id, (const int *)ptr, "tt:IANA-IfTypes");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_float:
		return soap_out_float(soap, tag, id, (const float *)ptr, "xsd:float");
	case SOAP_TYPE__d__MetadataVersion:
		return soap_out__d__MetadataVersion(soap, "d:MetadataVersion", id, (const unsigned int *)ptr, NULL);
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE__wsnt__TerminationTime:
		return soap_out__wsnt__TerminationTime(soap, "wsnt:TerminationTime", id, (const time_t *)ptr, NULL);
	case SOAP_TYPE__wsnt__CurrentTime:
		return soap_out__wsnt__CurrentTime(soap, "wsnt:CurrentTime", id, (const time_t *)ptr, NULL);
	case SOAP_TYPE_time:
		return soap_out_time(soap, tag, id, (const time_t *)ptr, "xsd:dateTime");
	case SOAP_TYPE__wstop__topic:
		return soap_out__wstop__topic(soap, "wstop:topic", id, (const enum xsd__boolean *)ptr, NULL);
	case SOAP_TYPE__wsnt__FixedTopicSet:
		return soap_out__wsnt__FixedTopicSet(soap, "wsnt:FixedTopicSet", id, (const enum xsd__boolean *)ptr, NULL);
	case SOAP_TYPE_wsu__tTimestampFault:
		return soap_out_wsu__tTimestampFault(soap, tag, id, (const enum wsu__tTimestampFault *)ptr, "wsu:tTimestampFault");
	case SOAP_TYPE_wsse__FaultcodeEnum:
		return soap_out_wsse__FaultcodeEnum(soap, tag, id, (const enum wsse__FaultcodeEnum *)ptr, "wsse:FaultcodeEnum");
	case SOAP_TYPE_d__FaultCodeType:
		return soap_out_d__FaultCodeType(soap, tag, id, (const enum d__FaultCodeType *)ptr, "d:FaultCodeType");
	case SOAP_TYPE_wsaw__AnonymousType:
		return soap_out_wsaw__AnonymousType(soap, tag, id, (const enum wsaw__AnonymousType *)ptr, "wsaw:AnonymousType");
	case SOAP_TYPE_tt__IrCutFilterMode:
		return soap_out_tt__IrCutFilterMode(soap, tag, id, (const enum tt__IrCutFilterMode *)ptr, "tt:IrCutFilterMode");
	case SOAP_TYPE_tt__WhiteBalanceMode:
		return soap_out_tt__WhiteBalanceMode(soap, tag, id, (const enum tt__WhiteBalanceMode *)ptr, "tt:WhiteBalanceMode");
	case SOAP_TYPE_tt__Enabled:
		return soap_out_tt__Enabled(soap, tag, id, (const enum tt__Enabled *)ptr, "tt:Enabled");
	case SOAP_TYPE_tt__ExposureMode:
		return soap_out_tt__ExposureMode(soap, tag, id, (const enum tt__ExposureMode *)ptr, "tt:ExposureMode");
	case SOAP_TYPE_tt__ExposurePriority:
		return soap_out_tt__ExposurePriority(soap, tag, id, (const enum tt__ExposurePriority *)ptr, "tt:ExposurePriority");
	case SOAP_TYPE_tt__BacklightCompensationMode:
		return soap_out_tt__BacklightCompensationMode(soap, tag, id, (const enum tt__BacklightCompensationMode *)ptr, "tt:BacklightCompensationMode");
	case SOAP_TYPE_tt__WideDynamicMode:
		return soap_out_tt__WideDynamicMode(soap, tag, id, (const enum tt__WideDynamicMode *)ptr, "tt:WideDynamicMode");
	case SOAP_TYPE_tt__AutoFocusMode:
		return soap_out_tt__AutoFocusMode(soap, tag, id, (const enum tt__AutoFocusMode *)ptr, "tt:AutoFocusMode");
	case SOAP_TYPE_tt__MoveStatus:
		return soap_out_tt__MoveStatus(soap, tag, id, (const enum tt__MoveStatus *)ptr, "tt:MoveStatus");
	case SOAP_TYPE_tt__RelayMode:
		return soap_out_tt__RelayMode(soap, tag, id, (const enum tt__RelayMode *)ptr, "tt:RelayMode");
	case SOAP_TYPE_tt__RelayIdleState:
		return soap_out_tt__RelayIdleState(soap, tag, id, (const enum tt__RelayIdleState *)ptr, "tt:RelayIdleState");
	case SOAP_TYPE_tt__RelayLogicalState:
		return soap_out_tt__RelayLogicalState(soap, tag, id, (const enum tt__RelayLogicalState *)ptr, "tt:RelayLogicalState");
	case SOAP_TYPE_tt__UserLevel:
		return soap_out_tt__UserLevel(soap, tag, id, (const enum tt__UserLevel *)ptr, "tt:UserLevel");
	case SOAP_TYPE_tt__SetDateTimeType:
		return soap_out_tt__SetDateTimeType(soap, tag, id, (const enum tt__SetDateTimeType *)ptr, "tt:SetDateTimeType");
	case SOAP_TYPE_tt__FactoryDefaultType:
		return soap_out_tt__FactoryDefaultType(soap, tag, id, (const enum tt__FactoryDefaultType *)ptr, "tt:FactoryDefaultType");
	case SOAP_TYPE_tt__SystemLogType:
		return soap_out_tt__SystemLogType(soap, tag, id, (const enum tt__SystemLogType *)ptr, "tt:SystemLogType");
	case SOAP_TYPE_tt__CapabilityCategory:
		return soap_out_tt__CapabilityCategory(soap, tag, id, (const enum tt__CapabilityCategory *)ptr, "tt:CapabilityCategory");
	case SOAP_TYPE_tt__DynamicDNSType:
		return soap_out_tt__DynamicDNSType(soap, tag, id, (const enum tt__DynamicDNSType *)ptr, "tt:DynamicDNSType");
	case SOAP_TYPE_tt__IPType:
		return soap_out_tt__IPType(soap, tag, id, (const enum tt__IPType *)ptr, "tt:IPType");
	case SOAP_TYPE_tt__NetworkHostType:
		return soap_out_tt__NetworkHostType(soap, tag, id, (const enum tt__NetworkHostType *)ptr, "tt:NetworkHostType");
	case SOAP_TYPE_tt__NetworkProtocolType:
		return soap_out_tt__NetworkProtocolType(soap, tag, id, (const enum tt__NetworkProtocolType *)ptr, "tt:NetworkProtocolType");
	case SOAP_TYPE_tt__Duplex:
		return soap_out_tt__Duplex(soap, tag, id, (const enum tt__Duplex *)ptr, "tt:Duplex");
	case SOAP_TYPE_tt__DiscoveryMode:
		return soap_out_tt__DiscoveryMode(soap, tag, id, (const enum tt__DiscoveryMode *)ptr, "tt:DiscoveryMode");
	case SOAP_TYPE_tt__ScopeDefinition:
		return soap_out_tt__ScopeDefinition(soap, tag, id, (const enum tt__ScopeDefinition *)ptr, "tt:ScopeDefinition");
	case SOAP_TYPE_tt__TransportProtocol:
		return soap_out_tt__TransportProtocol(soap, tag, id, (const enum tt__TransportProtocol *)ptr, "tt:TransportProtocol");
	case SOAP_TYPE_tt__StreamType:
		return soap_out_tt__StreamType(soap, tag, id, (const enum tt__StreamType *)ptr, "tt:StreamType");
	case SOAP_TYPE_tt__AudioEncoding:
		return soap_out_tt__AudioEncoding(soap, tag, id, (const enum tt__AudioEncoding *)ptr, "tt:AudioEncoding");
	case SOAP_TYPE_tt__H264Profile:
		return soap_out_tt__H264Profile(soap, tag, id, (const enum tt__H264Profile *)ptr, "tt:H264Profile");
	case SOAP_TYPE_tt__Mpeg4Profile:
		return soap_out_tt__Mpeg4Profile(soap, tag, id, (const enum tt__Mpeg4Profile *)ptr, "tt:Mpeg4Profile");
	case SOAP_TYPE_tt__VideoEncoding:
		return soap_out_tt__VideoEncoding(soap, tag, id, (const enum tt__VideoEncoding *)ptr, "tt:VideoEncoding");
	case SOAP_TYPE_wsa__RelationshipType:
		return soap_out_wsa__RelationshipType(soap, tag, id, (const enum wsa__RelationshipType *)ptr, "wsa:RelationshipType");
	case SOAP_TYPE_xsd__boolean:
		return soap_out_xsd__boolean(soap, tag, id, (const enum xsd__boolean *)ptr, "xsd:boolean");
	case SOAP_TYPE__wsu__Timestamp:
		return soap_out__wsu__Timestamp(soap, "wsu:Timestamp", id, (const struct wsu__TimestampType *)ptr, NULL);
	case SOAP_TYPE__wsse__Password:
		return soap_out__wsse__Password(soap, "wsse:Password", id, (const struct wsse__PasswordString *)ptr, NULL);
	case SOAP_TYPE__wsse__Security:
		return soap_out__wsse__Security(soap, "wsse:Security", id, (const struct wsse__SecurityHeaderType *)ptr, NULL);
	case SOAP_TYPE__wsse__UsernameToken:
		return soap_out__wsse__UsernameToken(soap, "wsse:UsernameToken", id, (const struct wsse__UsernameTokenType *)ptr, NULL);
	case SOAP_TYPE__d__AppSequence:
		return soap_out__d__AppSequence(soap, "d:AppSequence", id, (const struct d__AppSequenceType *)ptr, NULL);
	case SOAP_TYPE__d__Scopes:
		return soap_out__d__Scopes(soap, "d:Scopes", id, (const struct d__ScopesType *)ptr, NULL);
	case SOAP_TYPE__d__Resolve:
		return soap_out__d__Resolve(soap, "d:Resolve", id, (const struct d__ResolveType *)ptr, NULL);
	case SOAP_TYPE__d__ByeResponse:
		return soap_out__d__ByeResponse(soap, "d:ByeResponse", id, (const struct d__ResolveType *)ptr, NULL);
	case SOAP_TYPE__d__Bye:
		return soap_out__d__Bye(soap, "d:Bye", id, (const struct d__ByeType *)ptr, NULL);
	case SOAP_TYPE__d__ProbeMatches:
		return soap_out__d__ProbeMatches(soap, "d:ProbeMatches", id, (const struct d__ProbeMatchesType *)ptr, NULL);
	case SOAP_TYPE__d__Probe:
		return soap_out__d__Probe(soap, "d:Probe", id, (const struct d__ProbeType *)ptr, NULL);
	case SOAP_TYPE__d__HelloResponse:
		return soap_out__d__HelloResponse(soap, "d:HelloResponse", id, (const struct d__ResolveType *)ptr, NULL);
	case SOAP_TYPE__d__Hello:
		return soap_out__d__Hello(soap, "d:Hello", id, (const struct d__HelloType *)ptr, NULL);
	case SOAP_TYPE__trt__Capabilities:
		return soap_out__trt__Capabilities(soap, "trt:Capabilities", id, (const struct trt__Capabilities *)ptr, NULL);
	case SOAP_TYPE__wsaw__InterfaceName:
		return soap_out__wsaw__InterfaceName(soap, "wsaw:InterfaceName", id, (const struct wsaw__AttributedQNameType *)ptr, NULL);
	case SOAP_TYPE__wsaw__ServiceName:
		return soap_out__wsaw__ServiceName(soap, "wsaw:ServiceName", id, (const struct wsaw__ServiceNameType *)ptr, NULL);
	case SOAP_TYPE__tt__MetadataConfiguration:
		return soap_out__tt__MetadataConfiguration(soap, "tt:MetadataConfiguration", id, (const struct tt__MetadataConfiguration *)ptr, NULL);
	case SOAP_TYPE__tt__PTZConfiguration:
		return soap_out__tt__PTZConfiguration(soap, "tt:PTZConfiguration", id, (const struct tt__PTZConfiguration *)ptr, NULL);
	case SOAP_TYPE__tt__AudioEncoderConfiguration:
		return soap_out__tt__AudioEncoderConfiguration(soap, "tt:AudioEncoderConfiguration", id, (const struct tt__AudioEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__tt__VideoEncoderConfiguration:
		return soap_out__tt__VideoEncoderConfiguration(soap, "tt:VideoEncoderConfiguration", id, (const struct tt__VideoEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__tt__AudioSourceConfiguration:
		return soap_out__tt__AudioSourceConfiguration(soap, "tt:AudioSourceConfiguration", id, (const struct tt__AudioSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__tt__VideoSourceConfiguration:
		return soap_out__tt__VideoSourceConfiguration(soap, "tt:VideoSourceConfiguration", id, (const struct tt__VideoSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__wsr__ResourceUnknownFault:
		return soap_out__wsr__ResourceUnknownFault(soap, "wsr:ResourceUnknownFault", id, (const struct wsr__ResourceUnknownFaultType *)ptr, NULL);
	case SOAP_TYPE__wstop__TopicSet:
		return soap_out__wstop__TopicSet(soap, "wstop:TopicSet", id, (const struct wstop__TopicSetType *)ptr, NULL);
	case SOAP_TYPE__wsa__Action:
		return soap_out__wsa__Action(soap, "wsa:Action", id, (const struct wsa__AttributedURIType *)ptr, NULL);
	case SOAP_TYPE__wsa__To:
		return soap_out__wsa__To(soap, "wsa:To", id, (const struct wsa__AttributedURIType *)ptr, NULL);
	case SOAP_TYPE__wsa__FaultTo:
		return soap_out__wsa__FaultTo(soap, "wsa:FaultTo", id, (const struct wsa__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsa__From:
		return soap_out__wsa__From(soap, "wsa:From", id, (const struct wsa__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsa__ReplyTo:
		return soap_out__wsa__ReplyTo(soap, "wsa:ReplyTo", id, (const struct wsa__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsa__RelatesTo:
		return soap_out__wsa__RelatesTo(soap, "wsa:RelatesTo", id, (const struct wsa__RelatesToType *)ptr, NULL);
	case SOAP_TYPE__wsa__MessageID:
		return soap_out__wsa__MessageID(soap, "wsa:MessageID", id, (const struct wsa__AttributedURIType *)ptr, NULL);
	case SOAP_TYPE__wsa__Metadata:
		return soap_out__wsa__Metadata(soap, "wsa:Metadata", id, (const struct wsa__MetadataType *)ptr, NULL);
	case SOAP_TYPE__wsa__EndpointReference:
		return soap_out__wsa__EndpointReference(soap, "wsa:EndpointReference", id, (const struct wsa__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsbf__BaseFault:
		return soap_out__wsbf__BaseFault(soap, "wsbf:BaseFault", id, (const struct wsbf__BaseFaultType *)ptr, NULL);
	case SOAP_TYPE__wsnt__UnableToDestroySubscriptionFault:
		return soap_out__wsnt__UnableToDestroySubscriptionFault(soap, "wsnt:UnableToDestroySubscriptionFault", id, (const struct wsnt__UnableToDestroySubscriptionFaultType *)ptr, NULL);
	case SOAP_TYPE__wsnt__MessageContent:
		return soap_out__wsnt__MessageContent(soap, "wsnt:MessageContent", id, (const struct wsnt__QueryExpressionType *)ptr, NULL);
	case SOAP_TYPE__wsnt__NotificationMessage:
		return soap_out__wsnt__NotificationMessage(soap, "wsnt:NotificationMessage", id, (const struct wsnt__NotificationMessageHolderType *)ptr, NULL);
	case SOAP_TYPE__wsnt__ProducerReference:
		return soap_out__wsnt__ProducerReference(soap, "wsnt:ProducerReference", id, (const struct wsa__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsnt__Topic:
		return soap_out__wsnt__Topic(soap, "wsnt:Topic", id, (const struct wsnt__TopicExpressionType *)ptr, NULL);
	case SOAP_TYPE__wsnt__SubscriptionReference:
		return soap_out__wsnt__SubscriptionReference(soap, "wsnt:SubscriptionReference", id, (const struct wsa__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsnt__TopicExpression:
		return soap_out__wsnt__TopicExpression(soap, "wsnt:TopicExpression", id, (const struct wsnt__TopicExpressionType *)ptr, NULL);
	case SOAP_TYPE__wsadis__FaultTo:
		return soap_out__wsadis__FaultTo(soap, "wsadis:FaultTo", id, (const struct wsadis__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsadis__ReplyTo:
		return soap_out__wsadis__ReplyTo(soap, "wsadis:ReplyTo", id, (const struct wsadis__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsadis__From:
		return soap_out__wsadis__From(soap, "wsadis:From", id, (const struct wsadis__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsadis__Action:
		return soap_out__wsadis__Action(soap, "wsadis:Action", id, (const struct wsadis__AttributedURI *)ptr, NULL);
	case SOAP_TYPE__wsadis__To:
		return soap_out__wsadis__To(soap, "wsadis:To", id, (const struct wsadis__AttributedURI *)ptr, NULL);
	case SOAP_TYPE__wsadis__RelatesTo:
		return soap_out__wsadis__RelatesTo(soap, "wsadis:RelatesTo", id, (const struct wsadis__Relationship *)ptr, NULL);
	case SOAP_TYPE__wsadis__MessageID:
		return soap_out__wsadis__MessageID(soap, "wsadis:MessageID", id, (const struct wsadis__AttributedURI *)ptr, NULL);
	case SOAP_TYPE__wsadis__EndpointReference:
		return soap_out__wsadis__EndpointReference(soap, "wsadis:EndpointReference", id, (const struct wsadis__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsbf__ResourceUnknownFaultType_FaultCause:
		return soap_out__wsbf__ResourceUnknownFaultType_FaultCause(soap, "wsbf:ResourceUnknownFaultType-FaultCause", id, (const struct _wsbf__ResourceUnknownFaultType_FaultCause *)ptr, NULL);
	case SOAP_TYPE__wsbf__ResourceUnknownFaultType_Description:
		return soap_out__wsbf__ResourceUnknownFaultType_Description(soap, "wsbf:ResourceUnknownFaultType-Description", id, (const struct _wsbf__ResourceUnknownFaultType_Description *)ptr, NULL);
	case SOAP_TYPE__wsbf__ResourceUnknownFaultType_ErrorCode:
		return soap_out__wsbf__ResourceUnknownFaultType_ErrorCode(soap, "wsbf:ResourceUnknownFaultType-ErrorCode", id, (const struct _wsbf__ResourceUnknownFaultType_ErrorCode *)ptr, NULL);
	case SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_FaultCause:
		return soap_out__wsbf__UnableToDestroySubscriptionFaultType_FaultCause(soap, "wsbf:UnableToDestroySubscriptionFaultType-FaultCause", id, (const struct _wsbf__UnableToDestroySubscriptionFaultType_FaultCause *)ptr, NULL);
	case SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_Description:
		return soap_out__wsbf__UnableToDestroySubscriptionFaultType_Description(soap, "wsbf:UnableToDestroySubscriptionFaultType-Description", id, (const struct _wsbf__UnableToDestroySubscriptionFaultType_Description *)ptr, NULL);
	case SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode:
		return soap_out__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode(soap, "wsbf:UnableToDestroySubscriptionFaultType-ErrorCode", id, (const struct _wsbf__UnableToDestroySubscriptionFaultType_ErrorCode *)ptr, NULL);
	case SOAP_TYPE__tt__ItemListDescription_SimpleItemDescription:
		return soap_out__tt__ItemListDescription_SimpleItemDescription(soap, "tt:ItemListDescription-SimpleItemDescription", id, (const struct _tt__ItemListDescription_SimpleItemDescription *)ptr, NULL);
	case SOAP_TYPE__tt__ItemList_SimpleItem:
		return soap_out__tt__ItemList_SimpleItem(soap, "tt:ItemList-SimpleItem", id, (const struct _tt__ItemList_SimpleItem *)ptr, NULL);
	case SOAP_TYPE__wsbf__BaseFaultType_FaultCause:
		return soap_out__wsbf__BaseFaultType_FaultCause(soap, "wsbf:BaseFaultType-FaultCause", id, (const struct _wsbf__BaseFaultType_FaultCause *)ptr, NULL);
	case SOAP_TYPE__wsbf__BaseFaultType_Description:
		return soap_out__wsbf__BaseFaultType_Description(soap, "wsbf:BaseFaultType-Description", id, (const struct _wsbf__BaseFaultType_Description *)ptr, NULL);
	case SOAP_TYPE__wsbf__BaseFaultType_ErrorCode:
		return soap_out__wsbf__BaseFaultType_ErrorCode(soap, "wsbf:BaseFaultType-ErrorCode", id, (const struct _wsbf__BaseFaultType_ErrorCode *)ptr, NULL);
	case SOAP_TYPE__wsnt__NotificationMessageHolderType_Message:
		return soap_out__wsnt__NotificationMessageHolderType_Message(soap, "wsnt:NotificationMessageHolderType-Message", id, (const struct _wsnt__NotificationMessageHolderType_Message *)ptr, NULL);
	case SOAP_TYPE_wsu__TimestampType:
		return soap_out_wsu__TimestampType(soap, tag, id, (const struct wsu__TimestampType *)ptr, "wsu:TimestampType");
	case SOAP_TYPE_wsse__SecurityHeaderType:
		return soap_out_wsse__SecurityHeaderType(soap, tag, id, (const struct wsse__SecurityHeaderType *)ptr, "wsse:SecurityHeaderType");
	case SOAP_TYPE_wsse__UsernameTokenType:
		return soap_out_wsse__UsernameTokenType(soap, tag, id, (const struct wsse__UsernameTokenType *)ptr, "wsse:UsernameTokenType");
	case SOAP_TYPE_wsse__PasswordString:
		return soap_out_wsse__PasswordString(soap, tag, id, (const struct wsse__PasswordString *)ptr, "wsse:PasswordString");
	case SOAP_TYPE_d__AppSequenceType:
		return soap_out_d__AppSequenceType(soap, tag, id, (const struct d__AppSequenceType *)ptr, "d:AppSequenceType");
	case SOAP_TYPE_d__ScopesType:
		return soap_out_d__ScopesType(soap, tag, id, (const struct d__ScopesType *)ptr, "d:ScopesType");
	case SOAP_TYPE_d__ResolveType:
		return soap_out_d__ResolveType(soap, tag, id, (const struct d__ResolveType *)ptr, "d:ResolveType");
	case SOAP_TYPE_d__ProbeMatchType:
		return soap_out_d__ProbeMatchType(soap, tag, id, (const struct d__ProbeMatchType *)ptr, "d:ProbeMatchType");
	case SOAP_TYPE_d__ProbeMatchesType:
		return soap_out_d__ProbeMatchesType(soap, tag, id, (const struct d__ProbeMatchesType *)ptr, "d:ProbeMatchesType");
	case SOAP_TYPE_d__ProbeType:
		return soap_out_d__ProbeType(soap, tag, id, (const struct d__ProbeType *)ptr, "d:ProbeType");
	case SOAP_TYPE_d__ByeType:
		return soap_out_d__ByeType(soap, tag, id, (const struct d__ByeType *)ptr, "d:ByeType");
	case SOAP_TYPE_d__HelloType:
		return soap_out_d__HelloType(soap, tag, id, (const struct d__HelloType *)ptr, "d:HelloType");
	case SOAP_TYPE__tptz__StopResponse:
		return soap_out__tptz__StopResponse(soap, "tptz:StopResponse", id, (const struct _tptz__StopResponse *)ptr, NULL);
	case SOAP_TYPE__tptz__Stop:
		return soap_out__tptz__Stop(soap, "tptz:Stop", id, (const struct _tptz__Stop *)ptr, NULL);
	case SOAP_TYPE__tptz__AbsoluteMoveResponse:
		return soap_out__tptz__AbsoluteMoveResponse(soap, "tptz:AbsoluteMoveResponse", id, (const struct _tptz__AbsoluteMoveResponse *)ptr, NULL);
	case SOAP_TYPE__tptz__AbsoluteMove:
		return soap_out__tptz__AbsoluteMove(soap, "tptz:AbsoluteMove", id, (const struct _tptz__AbsoluteMove *)ptr, NULL);
	case SOAP_TYPE__tptz__ContinuousMoveResponse:
		return soap_out__tptz__ContinuousMoveResponse(soap, "tptz:ContinuousMoveResponse", id, (const struct _tptz__ContinuousMoveResponse *)ptr, NULL);
	case SOAP_TYPE__tptz__ContinuousMove:
		return soap_out__tptz__ContinuousMove(soap, "tptz:ContinuousMove", id, (const struct _tptz__ContinuousMove *)ptr, NULL);
	case SOAP_TYPE__tptz__SetHomePosition:
		return soap_out__tptz__SetHomePosition(soap, "tptz:SetHomePosition", id, (const struct _tptz__SetHomePosition *)ptr, NULL);
	case SOAP_TYPE__tptz__GotoHomePositionResponse:
		return soap_out__tptz__GotoHomePositionResponse(soap, "tptz:GotoHomePositionResponse", id, (const struct _tptz__GotoHomePositionResponse *)ptr, NULL);
	case SOAP_TYPE__tptz__GotoHomePosition:
		return soap_out__tptz__GotoHomePosition(soap, "tptz:GotoHomePosition", id, (const struct _tptz__GotoHomePosition *)ptr, NULL);
	case SOAP_TYPE__tptz__GetStatusResponse:
		return soap_out__tptz__GetStatusResponse(soap, "tptz:GetStatusResponse", id, (const struct _tptz__GetStatusResponse *)ptr, NULL);
	case SOAP_TYPE__tptz__GetStatus:
		return soap_out__tptz__GetStatus(soap, "tptz:GetStatus", id, (const struct _tptz__GetStatus *)ptr, NULL);
	case SOAP_TYPE__tptz__GetPresetResponse:
		return soap_out__tptz__GetPresetResponse(soap, "tptz:GetPresetResponse", id, (const struct _tptz__GetPresetResponse *)ptr, NULL);
	case SOAP_TYPE__tptz__GetPreset:
		return soap_out__tptz__GetPreset(soap, "tptz:GetPreset", id, (const struct _tptz__GetPreset *)ptr, NULL);
	case SOAP_TYPE__tptz__GotoPresetResponse:
		return soap_out__tptz__GotoPresetResponse(soap, "tptz:GotoPresetResponse", id, (const struct _tptz__GotoPresetResponse *)ptr, NULL);
	case SOAP_TYPE__tptz__GotoPreset:
		return soap_out__tptz__GotoPreset(soap, "tptz:GotoPreset", id, (const struct _tptz__GotoPreset *)ptr, NULL);
	case SOAP_TYPE__tptz__RemovePresetResponse:
		return soap_out__tptz__RemovePresetResponse(soap, "tptz:RemovePresetResponse", id, (const struct _tptz__RemovePresetResponse *)ptr, NULL);
	case SOAP_TYPE__tptz__RemovePreset:
		return soap_out__tptz__RemovePreset(soap, "tptz:RemovePreset", id, (const struct _tptz__RemovePreset *)ptr, NULL);
	case SOAP_TYPE__tptz__SetPresetResponse:
		return soap_out__tptz__SetPresetResponse(soap, "tptz:SetPresetResponse", id, (const struct _tptz__SetPresetResponse *)ptr, NULL);
	case SOAP_TYPE__tptz__SetPreset:
		return soap_out__tptz__SetPreset(soap, "tptz:SetPreset", id, (const struct _tptz__SetPreset *)ptr, NULL);
	case SOAP_TYPE__tptz__GetPresetsResponse:
		return soap_out__tptz__GetPresetsResponse(soap, "tptz:GetPresetsResponse", id, (const struct _tptz__GetPresetsResponse *)ptr, NULL);
	case SOAP_TYPE__tptz__GetPresets:
		return soap_out__tptz__GetPresets(soap, "tptz:GetPresets", id, (const struct _tptz__GetPresets *)ptr, NULL);
	case SOAP_TYPE__tptz__GetConfigurationOptionsResponse:
		return soap_out__tptz__GetConfigurationOptionsResponse(soap, "tptz:GetConfigurationOptionsResponse", id, (const struct _tptz__GetConfigurationOptionsResponse *)ptr, NULL);
	case SOAP_TYPE__tptz__GetConfigurationOptions:
		return soap_out__tptz__GetConfigurationOptions(soap, "tptz:GetConfigurationOptions", id, (const struct _tptz__GetConfigurationOptions *)ptr, NULL);
	case SOAP_TYPE__tptz__SetConfigurationResponse:
		return soap_out__tptz__SetConfigurationResponse(soap, "tptz:SetConfigurationResponse", id, (const struct _tptz__SetConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__tptz__SetConfiguration:
		return soap_out__tptz__SetConfiguration(soap, "tptz:SetConfiguration", id, (const struct _tptz__SetConfiguration *)ptr, NULL);
	case SOAP_TYPE__tptz__GetConfigurationResponse:
		return soap_out__tptz__GetConfigurationResponse(soap, "tptz:GetConfigurationResponse", id, (const struct _tptz__GetConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__tptz__GetConfiguration:
		return soap_out__tptz__GetConfiguration(soap, "tptz:GetConfiguration", id, (const struct _tptz__GetConfiguration *)ptr, NULL);
	case SOAP_TYPE__tptz__GetConfigurationsResponse:
		return soap_out__tptz__GetConfigurationsResponse(soap, "tptz:GetConfigurationsResponse", id, (const struct _tptz__GetConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__tptz__GetConfigurations:
		return soap_out__tptz__GetConfigurations(soap, "tptz:GetConfigurations", id, (const struct _tptz__GetConfigurations *)ptr, NULL);
	case SOAP_TYPE__tptz__GetNodeResponse:
		return soap_out__tptz__GetNodeResponse(soap, "tptz:GetNodeResponse", id, (const struct _tptz__GetNodeResponse *)ptr, NULL);
	case SOAP_TYPE__tptz__GetNode:
		return soap_out__tptz__GetNode(soap, "tptz:GetNode", id, (const struct _tptz__GetNode *)ptr, NULL);
	case SOAP_TYPE__tptz__GetNodesResponse:
		return soap_out__tptz__GetNodesResponse(soap, "tptz:GetNodesResponse", id, (const struct _tptz__GetNodesResponse *)ptr, NULL);
	case SOAP_TYPE__tptz__GetNodes:
		return soap_out__tptz__GetNodes(soap, "tptz:GetNodes", id, (const struct _tptz__GetNodes *)ptr, NULL);
	case SOAP_TYPE__trt__GetSnapshotUriResponse:
		return soap_out__trt__GetSnapshotUriResponse(soap, "trt:GetSnapshotUriResponse", id, (const struct _trt__GetSnapshotUriResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetSnapshotUri:
		return soap_out__trt__GetSnapshotUri(soap, "trt:GetSnapshotUri", id, (const struct _trt__GetSnapshotUri *)ptr, NULL);
	case SOAP_TYPE__trt__SetSynchronizationPointResponse:
		return soap_out__trt__SetSynchronizationPointResponse(soap, "trt:SetSynchronizationPointResponse", id, (const struct _trt__SetSynchronizationPointResponse *)ptr, NULL);
	case SOAP_TYPE__trt__SetSynchronizationPoint:
		return soap_out__trt__SetSynchronizationPoint(soap, "trt:SetSynchronizationPoint", id, (const struct _trt__SetSynchronizationPoint *)ptr, NULL);
	case SOAP_TYPE__trt__GetStreamUriResponse:
		return soap_out__trt__GetStreamUriResponse(soap, "trt:GetStreamUriResponse", id, (const struct _trt__GetStreamUriResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetStreamUri:
		return soap_out__trt__GetStreamUri(soap, "trt:GetStreamUri", id, (const struct _trt__GetStreamUri *)ptr, NULL);
	case SOAP_TYPE__trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse:
		return soap_out__trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse(soap, "trt:GetGuaranteedNumberOfVideoEncoderInstancesResponse", id, (const struct _trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetGuaranteedNumberOfVideoEncoderInstances:
		return soap_out__trt__GetGuaranteedNumberOfVideoEncoderInstances(soap, "trt:GetGuaranteedNumberOfVideoEncoderInstances", id, (const struct _trt__GetGuaranteedNumberOfVideoEncoderInstances *)ptr, NULL);
	case SOAP_TYPE__trt__GetMetadataConfigurationOptionsResponse:
		return soap_out__trt__GetMetadataConfigurationOptionsResponse(soap, "trt:GetMetadataConfigurationOptionsResponse", id, (const struct _trt__GetMetadataConfigurationOptionsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetMetadataConfigurationOptions:
		return soap_out__trt__GetMetadataConfigurationOptions(soap, "trt:GetMetadataConfigurationOptions", id, (const struct _trt__GetMetadataConfigurationOptions *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioEncoderConfigurationOptionsResponse:
		return soap_out__trt__GetAudioEncoderConfigurationOptionsResponse(soap, "trt:GetAudioEncoderConfigurationOptionsResponse", id, (const struct _trt__GetAudioEncoderConfigurationOptionsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioEncoderConfigurationOptions:
		return soap_out__trt__GetAudioEncoderConfigurationOptions(soap, "trt:GetAudioEncoderConfigurationOptions", id, (const struct _trt__GetAudioEncoderConfigurationOptions *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioSourceConfigurationOptionsResponse:
		return soap_out__trt__GetAudioSourceConfigurationOptionsResponse(soap, "trt:GetAudioSourceConfigurationOptionsResponse", id, (const struct _trt__GetAudioSourceConfigurationOptionsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioSourceConfigurationOptions:
		return soap_out__trt__GetAudioSourceConfigurationOptions(soap, "trt:GetAudioSourceConfigurationOptions", id, (const struct _trt__GetAudioSourceConfigurationOptions *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoEncoderConfigurationOptionsResponse:
		return soap_out__trt__GetVideoEncoderConfigurationOptionsResponse(soap, "trt:GetVideoEncoderConfigurationOptionsResponse", id, (const struct _trt__GetVideoEncoderConfigurationOptionsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoEncoderConfigurationOptions:
		return soap_out__trt__GetVideoEncoderConfigurationOptions(soap, "trt:GetVideoEncoderConfigurationOptions", id, (const struct _trt__GetVideoEncoderConfigurationOptions *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoSourceConfigurationOptionsResponse:
		return soap_out__trt__GetVideoSourceConfigurationOptionsResponse(soap, "trt:GetVideoSourceConfigurationOptionsResponse", id, (const struct _trt__GetVideoSourceConfigurationOptionsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoSourceConfigurationOptions:
		return soap_out__trt__GetVideoSourceConfigurationOptions(soap, "trt:GetVideoSourceConfigurationOptions", id, (const struct _trt__GetVideoSourceConfigurationOptions *)ptr, NULL);
	case SOAP_TYPE__trt__SetMetadataConfigurationResponse:
		return soap_out__trt__SetMetadataConfigurationResponse(soap, "trt:SetMetadataConfigurationResponse", id, (const struct _trt__SetMetadataConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__SetMetadataConfiguration:
		return soap_out__trt__SetMetadataConfiguration(soap, "trt:SetMetadataConfiguration", id, (const struct _trt__SetMetadataConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__SetAudioSourceConfigurationResponse:
		return soap_out__trt__SetAudioSourceConfigurationResponse(soap, "trt:SetAudioSourceConfigurationResponse", id, (const struct _trt__SetAudioSourceConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__SetAudioSourceConfiguration:
		return soap_out__trt__SetAudioSourceConfiguration(soap, "trt:SetAudioSourceConfiguration", id, (const struct _trt__SetAudioSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__SetAudioEncoderConfigurationResponse:
		return soap_out__trt__SetAudioEncoderConfigurationResponse(soap, "trt:SetAudioEncoderConfigurationResponse", id, (const struct _trt__SetAudioEncoderConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__SetAudioEncoderConfiguration:
		return soap_out__trt__SetAudioEncoderConfiguration(soap, "trt:SetAudioEncoderConfiguration", id, (const struct _trt__SetAudioEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__SetVideoSourceConfigurationResponse:
		return soap_out__trt__SetVideoSourceConfigurationResponse(soap, "trt:SetVideoSourceConfigurationResponse", id, (const struct _trt__SetVideoSourceConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__SetVideoSourceConfiguration:
		return soap_out__trt__SetVideoSourceConfiguration(soap, "trt:SetVideoSourceConfiguration", id, (const struct _trt__SetVideoSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__SetVideoEncoderConfigurationResponse:
		return soap_out__trt__SetVideoEncoderConfigurationResponse(soap, "trt:SetVideoEncoderConfigurationResponse", id, (const struct _trt__SetVideoEncoderConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__SetVideoEncoderConfiguration:
		return soap_out__trt__SetVideoEncoderConfiguration(soap, "trt:SetVideoEncoderConfiguration", id, (const struct _trt__SetVideoEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleMetadataConfigurationsResponse:
		return soap_out__trt__GetCompatibleMetadataConfigurationsResponse(soap, "trt:GetCompatibleMetadataConfigurationsResponse", id, (const struct _trt__GetCompatibleMetadataConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleMetadataConfigurations:
		return soap_out__trt__GetCompatibleMetadataConfigurations(soap, "trt:GetCompatibleMetadataConfigurations", id, (const struct _trt__GetCompatibleMetadataConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurationsResponse:
		return soap_out__trt__GetCompatibleAudioSourceConfigurationsResponse(soap, "trt:GetCompatibleAudioSourceConfigurationsResponse", id, (const struct _trt__GetCompatibleAudioSourceConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurations:
		return soap_out__trt__GetCompatibleAudioSourceConfigurations(soap, "trt:GetCompatibleAudioSourceConfigurations", id, (const struct _trt__GetCompatibleAudioSourceConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurationsResponse:
		return soap_out__trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, "trt:GetCompatibleAudioEncoderConfigurationsResponse", id, (const struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurations:
		return soap_out__trt__GetCompatibleAudioEncoderConfigurations(soap, "trt:GetCompatibleAudioEncoderConfigurations", id, (const struct _trt__GetCompatibleAudioEncoderConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurationsResponse:
		return soap_out__trt__GetCompatibleVideoSourceConfigurationsResponse(soap, "trt:GetCompatibleVideoSourceConfigurationsResponse", id, (const struct _trt__GetCompatibleVideoSourceConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurations:
		return soap_out__trt__GetCompatibleVideoSourceConfigurations(soap, "trt:GetCompatibleVideoSourceConfigurations", id, (const struct _trt__GetCompatibleVideoSourceConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurationsResponse:
		return soap_out__trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, "trt:GetCompatibleVideoEncoderConfigurationsResponse", id, (const struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurations:
		return soap_out__trt__GetCompatibleVideoEncoderConfigurations(soap, "trt:GetCompatibleVideoEncoderConfigurations", id, (const struct _trt__GetCompatibleVideoEncoderConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__GetMetadataConfigurationResponse:
		return soap_out__trt__GetMetadataConfigurationResponse(soap, "trt:GetMetadataConfigurationResponse", id, (const struct _trt__GetMetadataConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetMetadataConfiguration:
		return soap_out__trt__GetMetadataConfiguration(soap, "trt:GetMetadataConfiguration", id, (const struct _trt__GetMetadataConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioEncoderConfigurationResponse:
		return soap_out__trt__GetAudioEncoderConfigurationResponse(soap, "trt:GetAudioEncoderConfigurationResponse", id, (const struct _trt__GetAudioEncoderConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioEncoderConfiguration:
		return soap_out__trt__GetAudioEncoderConfiguration(soap, "trt:GetAudioEncoderConfiguration", id, (const struct _trt__GetAudioEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioSourceConfigurationResponse:
		return soap_out__trt__GetAudioSourceConfigurationResponse(soap, "trt:GetAudioSourceConfigurationResponse", id, (const struct _trt__GetAudioSourceConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioSourceConfiguration:
		return soap_out__trt__GetAudioSourceConfiguration(soap, "trt:GetAudioSourceConfiguration", id, (const struct _trt__GetAudioSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoEncoderConfigurationResponse:
		return soap_out__trt__GetVideoEncoderConfigurationResponse(soap, "trt:GetVideoEncoderConfigurationResponse", id, (const struct _trt__GetVideoEncoderConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoEncoderConfiguration:
		return soap_out__trt__GetVideoEncoderConfiguration(soap, "trt:GetVideoEncoderConfiguration", id, (const struct _trt__GetVideoEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoSourceConfigurationResponse:
		return soap_out__trt__GetVideoSourceConfigurationResponse(soap, "trt:GetVideoSourceConfigurationResponse", id, (const struct _trt__GetVideoSourceConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoSourceConfiguration:
		return soap_out__trt__GetVideoSourceConfiguration(soap, "trt:GetVideoSourceConfiguration", id, (const struct _trt__GetVideoSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__GetMetadataConfigurationsResponse:
		return soap_out__trt__GetMetadataConfigurationsResponse(soap, "trt:GetMetadataConfigurationsResponse", id, (const struct _trt__GetMetadataConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetMetadataConfigurations:
		return soap_out__trt__GetMetadataConfigurations(soap, "trt:GetMetadataConfigurations", id, (const struct _trt__GetMetadataConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioSourceConfigurationsResponse:
		return soap_out__trt__GetAudioSourceConfigurationsResponse(soap, "trt:GetAudioSourceConfigurationsResponse", id, (const struct _trt__GetAudioSourceConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioSourceConfigurations:
		return soap_out__trt__GetAudioSourceConfigurations(soap, "trt:GetAudioSourceConfigurations", id, (const struct _trt__GetAudioSourceConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioEncoderConfigurationsResponse:
		return soap_out__trt__GetAudioEncoderConfigurationsResponse(soap, "trt:GetAudioEncoderConfigurationsResponse", id, (const struct _trt__GetAudioEncoderConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioEncoderConfigurations:
		return soap_out__trt__GetAudioEncoderConfigurations(soap, "trt:GetAudioEncoderConfigurations", id, (const struct _trt__GetAudioEncoderConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoSourceConfigurationsResponse:
		return soap_out__trt__GetVideoSourceConfigurationsResponse(soap, "trt:GetVideoSourceConfigurationsResponse", id, (const struct _trt__GetVideoSourceConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoSourceConfigurations:
		return soap_out__trt__GetVideoSourceConfigurations(soap, "trt:GetVideoSourceConfigurations", id, (const struct _trt__GetVideoSourceConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoEncoderConfigurationsResponse:
		return soap_out__trt__GetVideoEncoderConfigurationsResponse(soap, "trt:GetVideoEncoderConfigurationsResponse", id, (const struct _trt__GetVideoEncoderConfigurationsResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoEncoderConfigurations:
		return soap_out__trt__GetVideoEncoderConfigurations(soap, "trt:GetVideoEncoderConfigurations", id, (const struct _trt__GetVideoEncoderConfigurations *)ptr, NULL);
	case SOAP_TYPE__trt__DeleteProfileResponse:
		return soap_out__trt__DeleteProfileResponse(soap, "trt:DeleteProfileResponse", id, (const struct _trt__DeleteProfileResponse *)ptr, NULL);
	case SOAP_TYPE__trt__DeleteProfile:
		return soap_out__trt__DeleteProfile(soap, "trt:DeleteProfile", id, (const struct _trt__DeleteProfile *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveMetadataConfigurationResponse:
		return soap_out__trt__RemoveMetadataConfigurationResponse(soap, "trt:RemoveMetadataConfigurationResponse", id, (const struct _trt__RemoveMetadataConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveMetadataConfiguration:
		return soap_out__trt__RemoveMetadataConfiguration(soap, "trt:RemoveMetadataConfiguration", id, (const struct _trt__RemoveMetadataConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__AddMetadataConfigurationResponse:
		return soap_out__trt__AddMetadataConfigurationResponse(soap, "trt:AddMetadataConfigurationResponse", id, (const struct _trt__AddMetadataConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__AddMetadataConfiguration:
		return soap_out__trt__AddMetadataConfiguration(soap, "trt:AddMetadataConfiguration", id, (const struct _trt__AddMetadataConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__RemovePTZConfigurationResponse:
		return soap_out__trt__RemovePTZConfigurationResponse(soap, "trt:RemovePTZConfigurationResponse", id, (const struct _trt__RemovePTZConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__RemovePTZConfiguration:
		return soap_out__trt__RemovePTZConfiguration(soap, "trt:RemovePTZConfiguration", id, (const struct _trt__RemovePTZConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__AddPTZConfigurationResponse:
		return soap_out__trt__AddPTZConfigurationResponse(soap, "trt:AddPTZConfigurationResponse", id, (const struct _trt__AddPTZConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__AddPTZConfiguration:
		return soap_out__trt__AddPTZConfiguration(soap, "trt:AddPTZConfiguration", id, (const struct _trt__AddPTZConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveAudioSourceConfigurationResponse:
		return soap_out__trt__RemoveAudioSourceConfigurationResponse(soap, "trt:RemoveAudioSourceConfigurationResponse", id, (const struct _trt__RemoveAudioSourceConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveAudioSourceConfiguration:
		return soap_out__trt__RemoveAudioSourceConfiguration(soap, "trt:RemoveAudioSourceConfiguration", id, (const struct _trt__RemoveAudioSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__AddAudioSourceConfigurationResponse:
		return soap_out__trt__AddAudioSourceConfigurationResponse(soap, "trt:AddAudioSourceConfigurationResponse", id, (const struct _trt__AddAudioSourceConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__AddAudioSourceConfiguration:
		return soap_out__trt__AddAudioSourceConfiguration(soap, "trt:AddAudioSourceConfiguration", id, (const struct _trt__AddAudioSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveAudioEncoderConfigurationResponse:
		return soap_out__trt__RemoveAudioEncoderConfigurationResponse(soap, "trt:RemoveAudioEncoderConfigurationResponse", id, (const struct _trt__RemoveAudioEncoderConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveAudioEncoderConfiguration:
		return soap_out__trt__RemoveAudioEncoderConfiguration(soap, "trt:RemoveAudioEncoderConfiguration", id, (const struct _trt__RemoveAudioEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__AddAudioEncoderConfigurationResponse:
		return soap_out__trt__AddAudioEncoderConfigurationResponse(soap, "trt:AddAudioEncoderConfigurationResponse", id, (const struct _trt__AddAudioEncoderConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__AddAudioEncoderConfiguration:
		return soap_out__trt__AddAudioEncoderConfiguration(soap, "trt:AddAudioEncoderConfiguration", id, (const struct _trt__AddAudioEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveVideoSourceConfigurationResponse:
		return soap_out__trt__RemoveVideoSourceConfigurationResponse(soap, "trt:RemoveVideoSourceConfigurationResponse", id, (const struct _trt__RemoveVideoSourceConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveVideoSourceConfiguration:
		return soap_out__trt__RemoveVideoSourceConfiguration(soap, "trt:RemoveVideoSourceConfiguration", id, (const struct _trt__RemoveVideoSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__AddVideoSourceConfigurationResponse:
		return soap_out__trt__AddVideoSourceConfigurationResponse(soap, "trt:AddVideoSourceConfigurationResponse", id, (const struct _trt__AddVideoSourceConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__AddVideoSourceConfiguration:
		return soap_out__trt__AddVideoSourceConfiguration(soap, "trt:AddVideoSourceConfiguration", id, (const struct _trt__AddVideoSourceConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveVideoEncoderConfigurationResponse:
		return soap_out__trt__RemoveVideoEncoderConfigurationResponse(soap, "trt:RemoveVideoEncoderConfigurationResponse", id, (const struct _trt__RemoveVideoEncoderConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__RemoveVideoEncoderConfiguration:
		return soap_out__trt__RemoveVideoEncoderConfiguration(soap, "trt:RemoveVideoEncoderConfiguration", id, (const struct _trt__RemoveVideoEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__AddVideoEncoderConfigurationResponse:
		return soap_out__trt__AddVideoEncoderConfigurationResponse(soap, "trt:AddVideoEncoderConfigurationResponse", id, (const struct _trt__AddVideoEncoderConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__trt__AddVideoEncoderConfiguration:
		return soap_out__trt__AddVideoEncoderConfiguration(soap, "trt:AddVideoEncoderConfiguration", id, (const struct _trt__AddVideoEncoderConfiguration *)ptr, NULL);
	case SOAP_TYPE__trt__GetProfilesResponse:
		return soap_out__trt__GetProfilesResponse(soap, "trt:GetProfilesResponse", id, (const struct _trt__GetProfilesResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetProfiles:
		return soap_out__trt__GetProfiles(soap, "trt:GetProfiles", id, (const struct _trt__GetProfiles *)ptr, NULL);
	case SOAP_TYPE__trt__GetProfileResponse:
		return soap_out__trt__GetProfileResponse(soap, "trt:GetProfileResponse", id, (const struct _trt__GetProfileResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetProfile:
		return soap_out__trt__GetProfile(soap, "trt:GetProfile", id, (const struct _trt__GetProfile *)ptr, NULL);
	case SOAP_TYPE__trt__CreateProfileResponse:
		return soap_out__trt__CreateProfileResponse(soap, "trt:CreateProfileResponse", id, (const struct _trt__CreateProfileResponse *)ptr, NULL);
	case SOAP_TYPE__trt__CreateProfile:
		return soap_out__trt__CreateProfile(soap, "trt:CreateProfile", id, (const struct _trt__CreateProfile *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioSourcesResponse:
		return soap_out__trt__GetAudioSourcesResponse(soap, "trt:GetAudioSourcesResponse", id, (const struct _trt__GetAudioSourcesResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetAudioSources:
		return soap_out__trt__GetAudioSources(soap, "trt:GetAudioSources", id, (const struct _trt__GetAudioSources *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoSourcesResponse:
		return soap_out__trt__GetVideoSourcesResponse(soap, "trt:GetVideoSourcesResponse", id, (const struct _trt__GetVideoSourcesResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetVideoSources:
		return soap_out__trt__GetVideoSources(soap, "trt:GetVideoSources", id, (const struct _trt__GetVideoSources *)ptr, NULL);
	case SOAP_TYPE__trt__GetServiceCapabilitiesResponse:
		return soap_out__trt__GetServiceCapabilitiesResponse(soap, "trt:GetServiceCapabilitiesResponse", id, (const struct _trt__GetServiceCapabilitiesResponse *)ptr, NULL);
	case SOAP_TYPE__trt__GetServiceCapabilities:
		return soap_out__trt__GetServiceCapabilities(soap, "trt:GetServiceCapabilities", id, (const struct _trt__GetServiceCapabilities *)ptr, NULL);
	case SOAP_TYPE_trt__StreamingCapabilities:
		return soap_out_trt__StreamingCapabilities(soap, tag, id, (const struct trt__StreamingCapabilities *)ptr, "trt:StreamingCapabilities");
	case SOAP_TYPE_trt__ProfileCapabilities:
		return soap_out_trt__ProfileCapabilities(soap, tag, id, (const struct trt__ProfileCapabilities *)ptr, "trt:ProfileCapabilities");
	case SOAP_TYPE_trt__Capabilities:
		return soap_out_trt__Capabilities(soap, tag, id, (const struct trt__Capabilities *)ptr, "trt:Capabilities");
	case SOAP_TYPE__wsaw__Anonymous:
		return soap_out__wsaw__Anonymous(soap, "wsaw:Anonymous", id, (const struct _wsaw__Anonymous *)ptr, NULL);
	case SOAP_TYPE__wsaw__UsingAddressing:
		return soap_out__wsaw__UsingAddressing(soap, "wsaw:UsingAddressing", id, (const struct _wsaw__UsingAddressing *)ptr, NULL);
	case SOAP_TYPE_wsaw__AttributedQNameType:
		return soap_out_wsaw__AttributedQNameType(soap, tag, id, (const struct wsaw__AttributedQNameType *)ptr, "wsaw:AttributedQNameType");
	case SOAP_TYPE_wsaw__ServiceNameType:
		return soap_out_wsaw__ServiceNameType(soap, tag, id, (const struct wsaw__ServiceNameType *)ptr, "wsaw:ServiceNameType");
	case SOAP_TYPE__tev__GetEventPropertiesResponse:
		return soap_out__tev__GetEventPropertiesResponse(soap, "tev:GetEventPropertiesResponse", id, (const struct _tev__GetEventPropertiesResponse *)ptr, NULL);
	case SOAP_TYPE__tev__GetEventProperties:
		return soap_out__tev__GetEventProperties(soap, "tev:GetEventProperties", id, (const struct _tev__GetEventProperties *)ptr, NULL);
	case SOAP_TYPE__tev__SetSynchronizationPointResponse:
		return soap_out__tev__SetSynchronizationPointResponse(soap, "tev:SetSynchronizationPointResponse", id, (const struct _tev__SetSynchronizationPointResponse *)ptr, NULL);
	case SOAP_TYPE__tev__SetSynchronizationPoint:
		return soap_out__tev__SetSynchronizationPoint(soap, "tev:SetSynchronizationPoint", id, (const struct _tev__SetSynchronizationPoint *)ptr, NULL);
	case SOAP_TYPE__tev__PullMessagesFaultResponse:
		return soap_out__tev__PullMessagesFaultResponse(soap, "tev:PullMessagesFaultResponse", id, (const struct _tev__PullMessagesFaultResponse *)ptr, NULL);
	case SOAP_TYPE__tev__PullMessagesResponse:
		return soap_out__tev__PullMessagesResponse(soap, "tev:PullMessagesResponse", id, (const struct _tev__PullMessagesResponse *)ptr, NULL);
	case SOAP_TYPE__tev__PullMessages:
		return soap_out__tev__PullMessages(soap, "tev:PullMessages", id, (const struct _tev__PullMessages *)ptr, NULL);
	case SOAP_TYPE__tev__CreatePullPointSubscriptionResponse:
		return soap_out__tev__CreatePullPointSubscriptionResponse(soap, "tev:CreatePullPointSubscriptionResponse", id, (const struct _tev__CreatePullPointSubscriptionResponse *)ptr, NULL);
	case SOAP_TYPE__tev__CreatePullPointSubscription:
		return soap_out__tev__CreatePullPointSubscription(soap, "tev:CreatePullPointSubscription", id, (const struct _tev__CreatePullPointSubscription *)ptr, NULL);
	case SOAP_TYPE__tds__SetRelayOutputStateResponse:
		return soap_out__tds__SetRelayOutputStateResponse(soap, "tds:SetRelayOutputStateResponse", id, (const struct _tds__SetRelayOutputStateResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetRelayOutputState:
		return soap_out__tds__SetRelayOutputState(soap, "tds:SetRelayOutputState", id, (const struct _tds__SetRelayOutputState *)ptr, NULL);
	case SOAP_TYPE__tds__SetRelayOutputSettingsResponse:
		return soap_out__tds__SetRelayOutputSettingsResponse(soap, "tds:SetRelayOutputSettingsResponse", id, (const struct _tds__SetRelayOutputSettingsResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetRelayOutputSettings:
		return soap_out__tds__SetRelayOutputSettings(soap, "tds:SetRelayOutputSettings", id, (const struct _tds__SetRelayOutputSettings *)ptr, NULL);
	case SOAP_TYPE__tds__GetRelayOutputsResponse:
		return soap_out__tds__GetRelayOutputsResponse(soap, "tds:GetRelayOutputsResponse", id, (const struct _tds__GetRelayOutputsResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetRelayOutputs:
		return soap_out__tds__GetRelayOutputs(soap, "tds:GetRelayOutputs", id, (const struct _tds__GetRelayOutputs *)ptr, NULL);
	case SOAP_TYPE__tds__SetZeroConfigurationResponse:
		return soap_out__tds__SetZeroConfigurationResponse(soap, "tds:SetZeroConfigurationResponse", id, (const struct _tds__SetZeroConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetZeroConfiguration:
		return soap_out__tds__SetZeroConfiguration(soap, "tds:SetZeroConfiguration", id, (const struct _tds__SetZeroConfiguration *)ptr, NULL);
	case SOAP_TYPE__tds__GetZeroConfigurationResponse:
		return soap_out__tds__GetZeroConfigurationResponse(soap, "tds:GetZeroConfigurationResponse", id, (const struct _tds__GetZeroConfigurationResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetZeroConfiguration:
		return soap_out__tds__GetZeroConfiguration(soap, "tds:GetZeroConfiguration", id, (const struct _tds__GetZeroConfiguration *)ptr, NULL);
	case SOAP_TYPE__tds__SetNetworkDefaultGatewayResponse:
		return soap_out__tds__SetNetworkDefaultGatewayResponse(soap, "tds:SetNetworkDefaultGatewayResponse", id, (const struct _tds__SetNetworkDefaultGatewayResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetNetworkDefaultGateway:
		return soap_out__tds__SetNetworkDefaultGateway(soap, "tds:SetNetworkDefaultGateway", id, (const struct _tds__SetNetworkDefaultGateway *)ptr, NULL);
	case SOAP_TYPE__tds__GetNetworkDefaultGatewayResponse:
		return soap_out__tds__GetNetworkDefaultGatewayResponse(soap, "tds:GetNetworkDefaultGatewayResponse", id, (const struct _tds__GetNetworkDefaultGatewayResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetNetworkDefaultGateway:
		return soap_out__tds__GetNetworkDefaultGateway(soap, "tds:GetNetworkDefaultGateway", id, (const struct _tds__GetNetworkDefaultGateway *)ptr, NULL);
	case SOAP_TYPE__tds__SetNetworkProtocolsResponse:
		return soap_out__tds__SetNetworkProtocolsResponse(soap, "tds:SetNetworkProtocolsResponse", id, (const struct _tds__SetNetworkProtocolsResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetNetworkProtocols:
		return soap_out__tds__SetNetworkProtocols(soap, "tds:SetNetworkProtocols", id, (const struct _tds__SetNetworkProtocols *)ptr, NULL);
	case SOAP_TYPE__tds__GetNetworkProtocolsResponse:
		return soap_out__tds__GetNetworkProtocolsResponse(soap, "tds:GetNetworkProtocolsResponse", id, (const struct _tds__GetNetworkProtocolsResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetNetworkProtocols:
		return soap_out__tds__GetNetworkProtocols(soap, "tds:GetNetworkProtocols", id, (const struct _tds__GetNetworkProtocols *)ptr, NULL);
	case SOAP_TYPE__tds__SetNetworkInterfacesResponse:
		return soap_out__tds__SetNetworkInterfacesResponse(soap, "tds:SetNetworkInterfacesResponse", id, (const struct _tds__SetNetworkInterfacesResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetNetworkInterfaces:
		return soap_out__tds__SetNetworkInterfaces(soap, "tds:SetNetworkInterfaces", id, (const struct _tds__SetNetworkInterfaces *)ptr, NULL);
	case SOAP_TYPE__tds__GetNetworkInterfacesResponse:
		return soap_out__tds__GetNetworkInterfacesResponse(soap, "tds:GetNetworkInterfacesResponse", id, (const struct _tds__GetNetworkInterfacesResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetNetworkInterfaces:
		return soap_out__tds__GetNetworkInterfaces(soap, "tds:GetNetworkInterfaces", id, (const struct _tds__GetNetworkInterfaces *)ptr, NULL);
	case SOAP_TYPE__tds__SetDynamicDNSResponse:
		return soap_out__tds__SetDynamicDNSResponse(soap, "tds:SetDynamicDNSResponse", id, (const struct _tds__SetDynamicDNSResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetDynamicDNS:
		return soap_out__tds__SetDynamicDNS(soap, "tds:SetDynamicDNS", id, (const struct _tds__SetDynamicDNS *)ptr, NULL);
	case SOAP_TYPE__tds__GetDynamicDNSResponse:
		return soap_out__tds__GetDynamicDNSResponse(soap, "tds:GetDynamicDNSResponse", id, (const struct _tds__GetDynamicDNSResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetDynamicDNS:
		return soap_out__tds__GetDynamicDNS(soap, "tds:GetDynamicDNS", id, (const struct _tds__GetDynamicDNS *)ptr, NULL);
	case SOAP_TYPE__tds__SetNTPResponse:
		return soap_out__tds__SetNTPResponse(soap, "tds:SetNTPResponse", id, (const struct _tds__SetNTPResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetNTP:
		return soap_out__tds__SetNTP(soap, "tds:SetNTP", id, (const struct _tds__SetNTP *)ptr, NULL);
	case SOAP_TYPE__tds__GetNTPResponse:
		return soap_out__tds__GetNTPResponse(soap, "tds:GetNTPResponse", id, (const struct _tds__GetNTPResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetNTP:
		return soap_out__tds__GetNTP(soap, "tds:GetNTP", id, (const struct _tds__GetNTP *)ptr, NULL);
	case SOAP_TYPE__tds__SetDNSResponse:
		return soap_out__tds__SetDNSResponse(soap, "tds:SetDNSResponse", id, (const struct _tds__SetDNSResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetDNS:
		return soap_out__tds__SetDNS(soap, "tds:SetDNS", id, (const struct _tds__SetDNS *)ptr, NULL);
	case SOAP_TYPE__tds__GetDNSResponse:
		return soap_out__tds__GetDNSResponse(soap, "tds:GetDNSResponse", id, (const struct _tds__GetDNSResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetDNS:
		return soap_out__tds__GetDNS(soap, "tds:GetDNS", id, (const struct _tds__GetDNS *)ptr, NULL);
	case SOAP_TYPE__tds__SetHostnameResponse:
		return soap_out__tds__SetHostnameResponse(soap, "tds:SetHostnameResponse", id, (const struct _tds__SetHostnameResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetHostname:
		return soap_out__tds__SetHostname(soap, "tds:SetHostname", id, (const struct _tds__SetHostname *)ptr, NULL);
	case SOAP_TYPE__tds__GetHostnameResponse:
		return soap_out__tds__GetHostnameResponse(soap, "tds:GetHostnameResponse", id, (const struct _tds__GetHostnameResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetHostname:
		return soap_out__tds__GetHostname(soap, "tds:GetHostname", id, (const struct _tds__GetHostname *)ptr, NULL);
	case SOAP_TYPE__tds__GetCapabilitiesResponse:
		return soap_out__tds__GetCapabilitiesResponse(soap, "tds:GetCapabilitiesResponse", id, (const struct _tds__GetCapabilitiesResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetCapabilities:
		return soap_out__tds__GetCapabilities(soap, "tds:GetCapabilities", id, (const struct _tds__GetCapabilities *)ptr, NULL);
	case SOAP_TYPE__tds__GetWsdlUrlResponse:
		return soap_out__tds__GetWsdlUrlResponse(soap, "tds:GetWsdlUrlResponse", id, (const struct _tds__GetWsdlUrlResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetWsdlUrl:
		return soap_out__tds__GetWsdlUrl(soap, "tds:GetWsdlUrl", id, (const struct _tds__GetWsdlUrl *)ptr, NULL);
	case SOAP_TYPE__tds__SetUserResponse:
		return soap_out__tds__SetUserResponse(soap, "tds:SetUserResponse", id, (const struct _tds__SetUserResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetUser:
		return soap_out__tds__SetUser(soap, "tds:SetUser", id, (const struct _tds__SetUser *)ptr, NULL);
	case SOAP_TYPE__tds__DeleteUsersResponse:
		return soap_out__tds__DeleteUsersResponse(soap, "tds:DeleteUsersResponse", id, (const struct _tds__DeleteUsersResponse *)ptr, NULL);
	case SOAP_TYPE__tds__DeleteUsers:
		return soap_out__tds__DeleteUsers(soap, "tds:DeleteUsers", id, (const struct _tds__DeleteUsers *)ptr, NULL);
	case SOAP_TYPE__tds__CreateUsersResponse:
		return soap_out__tds__CreateUsersResponse(soap, "tds:CreateUsersResponse", id, (const struct _tds__CreateUsersResponse *)ptr, NULL);
	case SOAP_TYPE__tds__CreateUsers:
		return soap_out__tds__CreateUsers(soap, "tds:CreateUsers", id, (const struct _tds__CreateUsers *)ptr, NULL);
	case SOAP_TYPE__tds__GetUsersResponse:
		return soap_out__tds__GetUsersResponse(soap, "tds:GetUsersResponse", id, (const struct _tds__GetUsersResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetUsers:
		return soap_out__tds__GetUsers(soap, "tds:GetUsers", id, (const struct _tds__GetUsers *)ptr, NULL);
	case SOAP_TYPE__tds__SetDiscoveryModeResponse:
		return soap_out__tds__SetDiscoveryModeResponse(soap, "tds:SetDiscoveryModeResponse", id, (const struct _tds__SetDiscoveryModeResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetDiscoveryMode:
		return soap_out__tds__SetDiscoveryMode(soap, "tds:SetDiscoveryMode", id, (const struct _tds__SetDiscoveryMode *)ptr, NULL);
	case SOAP_TYPE__tds__GetDiscoveryModeResponse:
		return soap_out__tds__GetDiscoveryModeResponse(soap, "tds:GetDiscoveryModeResponse", id, (const struct _tds__GetDiscoveryModeResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetDiscoveryMode:
		return soap_out__tds__GetDiscoveryMode(soap, "tds:GetDiscoveryMode", id, (const struct _tds__GetDiscoveryMode *)ptr, NULL);
	case SOAP_TYPE__tds__RemoveScopesResponse:
		return soap_out__tds__RemoveScopesResponse(soap, "tds:RemoveScopesResponse", id, (const struct _tds__RemoveScopesResponse *)ptr, NULL);
	case SOAP_TYPE__tds__RemoveScopes:
		return soap_out__tds__RemoveScopes(soap, "tds:RemoveScopes", id, (const struct _tds__RemoveScopes *)ptr, NULL);
	case SOAP_TYPE__tds__AddScopesResponse:
		return soap_out__tds__AddScopesResponse(soap, "tds:AddScopesResponse", id, (const struct _tds__AddScopesResponse *)ptr, NULL);
	case SOAP_TYPE__tds__AddScopes:
		return soap_out__tds__AddScopes(soap, "tds:AddScopes", id, (const struct _tds__AddScopes *)ptr, NULL);
	case SOAP_TYPE__tds__SetScopesResponse:
		return soap_out__tds__SetScopesResponse(soap, "tds:SetScopesResponse", id, (const struct _tds__SetScopesResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetScopes:
		return soap_out__tds__SetScopes(soap, "tds:SetScopes", id, (const struct _tds__SetScopes *)ptr, NULL);
	case SOAP_TYPE__tds__GetScopesResponse:
		return soap_out__tds__GetScopesResponse(soap, "tds:GetScopesResponse", id, (const struct _tds__GetScopesResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetScopes:
		return soap_out__tds__GetScopes(soap, "tds:GetScopes", id, (const struct _tds__GetScopes *)ptr, NULL);
	case SOAP_TYPE__tds__GetSystemLogResponse:
		return soap_out__tds__GetSystemLogResponse(soap, "tds:GetSystemLogResponse", id, (const struct _tds__GetSystemLogResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetSystemLog:
		return soap_out__tds__GetSystemLog(soap, "tds:GetSystemLog", id, (const struct _tds__GetSystemLog *)ptr, NULL);
	case SOAP_TYPE__tds__SystemRebootResponse:
		return soap_out__tds__SystemRebootResponse(soap, "tds:SystemRebootResponse", id, (const struct _tds__SystemRebootResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SystemReboot:
		return soap_out__tds__SystemReboot(soap, "tds:SystemReboot", id, (const struct _tds__SystemReboot *)ptr, NULL);
	case SOAP_TYPE__tds__SetSystemFactoryDefaultResponse:
		return soap_out__tds__SetSystemFactoryDefaultResponse(soap, "tds:SetSystemFactoryDefaultResponse", id, (const struct _tds__SetSystemFactoryDefaultResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetSystemFactoryDefault:
		return soap_out__tds__SetSystemFactoryDefault(soap, "tds:SetSystemFactoryDefault", id, (const struct _tds__SetSystemFactoryDefault *)ptr, NULL);
	case SOAP_TYPE__tds__GetSystemDateAndTimeResponse:
		return soap_out__tds__GetSystemDateAndTimeResponse(soap, "tds:GetSystemDateAndTimeResponse", id, (const struct _tds__GetSystemDateAndTimeResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetSystemDateAndTime:
		return soap_out__tds__GetSystemDateAndTime(soap, "tds:GetSystemDateAndTime", id, (const struct _tds__GetSystemDateAndTime *)ptr, NULL);
	case SOAP_TYPE__tds__SetSystemDateAndTimeResponse:
		return soap_out__tds__SetSystemDateAndTimeResponse(soap, "tds:SetSystemDateAndTimeResponse", id, (const struct _tds__SetSystemDateAndTimeResponse *)ptr, NULL);
	case SOAP_TYPE__tds__SetSystemDateAndTime:
		return soap_out__tds__SetSystemDateAndTime(soap, "tds:SetSystemDateAndTime", id, (const struct _tds__SetSystemDateAndTime *)ptr, NULL);
	case SOAP_TYPE__tds__GetDeviceInformationResponse:
		return soap_out__tds__GetDeviceInformationResponse(soap, "tds:GetDeviceInformationResponse", id, (const struct _tds__GetDeviceInformationResponse *)ptr, NULL);
	case SOAP_TYPE__tds__GetDeviceInformation:
		return soap_out__tds__GetDeviceInformation(soap, "tds:GetDeviceInformation", id, (const struct _tds__GetDeviceInformation *)ptr, NULL);
	case SOAP_TYPE_tnsacti__IO:
		return soap_out_tnsacti__IO(soap, tag, id, (const struct tnsacti__IO *)ptr, "tnsacti:IO");
	case SOAP_TYPE_tnsacti__MotionDetection:
		return soap_out_tnsacti__MotionDetection(soap, tag, id, (const struct tnsacti__MotionDetection *)ptr, "tnsacti:MotionDetection");
	case SOAP_TYPE_tnsacti__VirtualPort:
		return soap_out_tnsacti__VirtualPort(soap, tag, id, (const struct tnsacti__VirtualPort *)ptr, "tnsacti:VirtualPort");
	case SOAP_TYPE_tns1__Device:
		return soap_out_tns1__Device(soap, tag, id, (const struct tns1__Device *)ptr, "tns1:Device");
	case SOAP_TYPE_tns1__VideoAnalytics:
		return soap_out_tns1__VideoAnalytics(soap, tag, id, (const struct tns1__VideoAnalytics *)ptr, "tns1:VideoAnalytics");
	case SOAP_TYPE__tt__Message:
		return soap_out__tt__Message(soap, "tt:Message", id, (const struct _tt__Message *)ptr, NULL);
	case SOAP_TYPE_tt__EventStream:
		return soap_out_tt__EventStream(soap, tag, id, (const struct tt__EventStream *)ptr, "tt:EventStream");
	case SOAP_TYPE_tt__Rectangle:
		return soap_out_tt__Rectangle(soap, tag, id, (const struct tt__Rectangle *)ptr, "tt:Rectangle");
	case SOAP_TYPE_tt__ItemListDescription:
		return soap_out_tt__ItemListDescription(soap, tag, id, (const struct tt__ItemListDescription *)ptr, "tt:ItemListDescription");
	case SOAP_TYPE_tt__MessageDescription:
		return soap_out_tt__MessageDescription(soap, tag, id, (const struct tt__MessageDescription *)ptr, "tt:MessageDescription");
	case SOAP_TYPE_tt__ItemList:
		return soap_out_tt__ItemList(soap, tag, id, (const struct tt__ItemList *)ptr, "tt:ItemList");
	case SOAP_TYPE_tt__WhiteBalance:
		return soap_out_tt__WhiteBalance(soap, tag, id, (const struct tt__WhiteBalance *)ptr, "tt:WhiteBalance");
	case SOAP_TYPE_tt__WhiteBalanceOptions:
		return soap_out_tt__WhiteBalanceOptions(soap, tag, id, (const struct tt__WhiteBalanceOptions *)ptr, "tt:WhiteBalanceOptions");
	case SOAP_TYPE_tt__ExposureOptions:
		return soap_out_tt__ExposureOptions(soap, tag, id, (const struct tt__ExposureOptions *)ptr, "tt:ExposureOptions");
	case SOAP_TYPE_tt__FocusOptions:
		return soap_out_tt__FocusOptions(soap, tag, id, (const struct tt__FocusOptions *)ptr, "tt:FocusOptions");
	case SOAP_TYPE_tt__BacklightCompensationOptions:
		return soap_out_tt__BacklightCompensationOptions(soap, tag, id, (const struct tt__BacklightCompensationOptions *)ptr, "tt:BacklightCompensationOptions");
	case SOAP_TYPE_tt__WideDynamicRangeOptions:
		return soap_out_tt__WideDynamicRangeOptions(soap, tag, id, (const struct tt__WideDynamicRangeOptions *)ptr, "tt:WideDynamicRangeOptions");
	case SOAP_TYPE_tt__ImagingOptions:
		return soap_out_tt__ImagingOptions(soap, tag, id, (const struct tt__ImagingOptions *)ptr, "tt:ImagingOptions");
	case SOAP_TYPE_tt__BacklightCompensation:
		return soap_out_tt__BacklightCompensation(soap, tag, id, (const struct tt__BacklightCompensation *)ptr, "tt:BacklightCompensation");
	case SOAP_TYPE_tt__WideDynamicRange:
		return soap_out_tt__WideDynamicRange(soap, tag, id, (const struct tt__WideDynamicRange *)ptr, "tt:WideDynamicRange");
	case SOAP_TYPE_tt__Exposure:
		return soap_out_tt__Exposure(soap, tag, id, (const struct tt__Exposure *)ptr, "tt:Exposure");
	case SOAP_TYPE_tt__ImagingSettings:
		return soap_out_tt__ImagingSettings(soap, tag, id, (const struct tt__ImagingSettings *)ptr, "tt:ImagingSettings");
	case SOAP_TYPE_tt__FocusConfiguration:
		return soap_out_tt__FocusConfiguration(soap, tag, id, (const struct tt__FocusConfiguration *)ptr, "tt:FocusConfiguration");
	case SOAP_TYPE_tt__PTZMoveStatus:
		return soap_out_tt__PTZMoveStatus(soap, tag, id, (const struct tt__PTZMoveStatus *)ptr, "tt:PTZMoveStatus");
	case SOAP_TYPE_tt__PTZPreset:
		return soap_out_tt__PTZPreset(soap, tag, id, (const struct tt__PTZPreset *)ptr, "tt:PTZPreset");
	case SOAP_TYPE_tt__Preset:
		return soap_out_tt__Preset(soap, tag, id, (const struct tt__Preset *)ptr, "tt:Preset");
	case SOAP_TYPE_tt__PTZStatus:
		return soap_out_tt__PTZStatus(soap, tag, id, (const struct tt__PTZStatus *)ptr, "tt:PTZStatus");
	case SOAP_TYPE_tt__PTZSpeed:
		return soap_out_tt__PTZSpeed(soap, tag, id, (const struct tt__PTZSpeed *)ptr, "tt:PTZSpeed");
	case SOAP_TYPE_tt__PTZVector:
		return soap_out_tt__PTZVector(soap, tag, id, (const struct tt__PTZVector *)ptr, "tt:PTZVector");
	case SOAP_TYPE_tt__Vector1D:
		return soap_out_tt__Vector1D(soap, tag, id, (const struct tt__Vector1D *)ptr, "tt:Vector1D");
	case SOAP_TYPE_tt__Vector2D:
		return soap_out_tt__Vector2D(soap, tag, id, (const struct tt__Vector2D *)ptr, "tt:Vector2D");
	case SOAP_TYPE_tt__Space1DDescription:
		return soap_out_tt__Space1DDescription(soap, tag, id, (const struct tt__Space1DDescription *)ptr, "tt:Space1DDescription");
	case SOAP_TYPE_tt__Space2DDescription:
		return soap_out_tt__Space2DDescription(soap, tag, id, (const struct tt__Space2DDescription *)ptr, "tt:Space2DDescription");
	case SOAP_TYPE_tt__PTZSpaces:
		return soap_out_tt__PTZSpaces(soap, tag, id, (const struct tt__PTZSpaces *)ptr, "tt:PTZSpaces");
	case SOAP_TYPE_tt__ZoomLimits:
		return soap_out_tt__ZoomLimits(soap, tag, id, (const struct tt__ZoomLimits *)ptr, "tt:ZoomLimits");
	case SOAP_TYPE_tt__PanTiltLimits:
		return soap_out_tt__PanTiltLimits(soap, tag, id, (const struct tt__PanTiltLimits *)ptr, "tt:PanTiltLimits");
	case SOAP_TYPE_tt__PTZConfigurationOptions:
		return soap_out_tt__PTZConfigurationOptions(soap, tag, id, (const struct tt__PTZConfigurationOptions *)ptr, "tt:PTZConfigurationOptions");
	case SOAP_TYPE_tt__PTZConfiguration:
		return soap_out_tt__PTZConfiguration(soap, tag, id, (const struct tt__PTZConfiguration *)ptr, "tt:PTZConfiguration");
	case SOAP_TYPE_tt__PTZNode:
		return soap_out_tt__PTZNode(soap, tag, id, (const struct tt__PTZNode *)ptr, "tt:PTZNode");
	case SOAP_TYPE_tt__RelayOutput:
		return soap_out_tt__RelayOutput(soap, tag, id, (const struct tt__RelayOutput *)ptr, "tt:RelayOutput");
	case SOAP_TYPE_tt__RelayOutputSettings:
		return soap_out_tt__RelayOutputSettings(soap, tag, id, (const struct tt__RelayOutputSettings *)ptr, "tt:RelayOutputSettings");
	case SOAP_TYPE_tt__User:
		return soap_out_tt__User(soap, tag, id, (const struct tt__User *)ptr, "tt:User");
	case SOAP_TYPE_tt__TimeZone:
		return soap_out_tt__TimeZone(soap, tag, id, (const struct tt__TimeZone *)ptr, "tt:TimeZone");
	case SOAP_TYPE_tt__Time:
		return soap_out_tt__Time(soap, tag, id, (const struct tt__Time *)ptr, "tt:Time");
	case SOAP_TYPE_tt__Date:
		return soap_out_tt__Date(soap, tag, id, (const struct tt__Date *)ptr, "tt:Date");
	case SOAP_TYPE_tt__DateTime:
		return soap_out_tt__DateTime(soap, tag, id, (const struct tt__DateTime *)ptr, "tt:DateTime");
	case SOAP_TYPE_tt__SystemDateTime:
		return soap_out_tt__SystemDateTime(soap, tag, id, (const struct tt__SystemDateTime *)ptr, "tt:SystemDateTime");
	case SOAP_TYPE_tt__SystemLog:
		return soap_out_tt__SystemLog(soap, tag, id, (const struct tt__SystemLog *)ptr, "tt:SystemLog");
	case SOAP_TYPE_tt__AnalyticsDeviceCapabilities:
		return soap_out_tt__AnalyticsDeviceCapabilities(soap, tag, id, (const struct tt__AnalyticsDeviceCapabilities *)ptr, "tt:AnalyticsDeviceCapabilities");
	case SOAP_TYPE_tt__ReceiverCapabilities:
		return soap_out_tt__ReceiverCapabilities(soap, tag, id, (const struct tt__ReceiverCapabilities *)ptr, "tt:ReceiverCapabilities");
	case SOAP_TYPE_tt__ReplayCapabilities:
		return soap_out_tt__ReplayCapabilities(soap, tag, id, (const struct tt__ReplayCapabilities *)ptr, "tt:ReplayCapabilities");
	case SOAP_TYPE_tt__SearchCapabilities:
		return soap_out_tt__SearchCapabilities(soap, tag, id, (const struct tt__SearchCapabilities *)ptr, "tt:SearchCapabilities");
	case SOAP_TYPE_tt__RecordingCapabilities:
		return soap_out_tt__RecordingCapabilities(soap, tag, id, (const struct tt__RecordingCapabilities *)ptr, "tt:RecordingCapabilities");
	case SOAP_TYPE_tt__DisplayCapabilities:
		return soap_out_tt__DisplayCapabilities(soap, tag, id, (const struct tt__DisplayCapabilities *)ptr, "tt:DisplayCapabilities");
	case SOAP_TYPE_tt__DeviceIOCapabilities:
		return soap_out_tt__DeviceIOCapabilities(soap, tag, id, (const struct tt__DeviceIOCapabilities *)ptr, "tt:DeviceIOCapabilities");
	case SOAP_TYPE_tt__PTZCapabilities:
		return soap_out_tt__PTZCapabilities(soap, tag, id, (const struct tt__PTZCapabilities *)ptr, "tt:PTZCapabilities");
	case SOAP_TYPE_tt__ImagingCapabilities:
		return soap_out_tt__ImagingCapabilities(soap, tag, id, (const struct tt__ImagingCapabilities *)ptr, "tt:ImagingCapabilities");
	case SOAP_TYPE_tt__OnvifVersion:
		return soap_out_tt__OnvifVersion(soap, tag, id, (const struct tt__OnvifVersion *)ptr, "tt:OnvifVersion");
	case SOAP_TYPE_tt__SystemCapabilities:
		return soap_out_tt__SystemCapabilities(soap, tag, id, (const struct tt__SystemCapabilities *)ptr, "tt:SystemCapabilities");
	case SOAP_TYPE_tt__SecurityCapabilities:
		return soap_out_tt__SecurityCapabilities(soap, tag, id, (const struct tt__SecurityCapabilities *)ptr, "tt:SecurityCapabilities");
	case SOAP_TYPE_tt__NetworkCapabilities:
		return soap_out_tt__NetworkCapabilities(soap, tag, id, (const struct tt__NetworkCapabilities *)ptr, "tt:NetworkCapabilities");
	case SOAP_TYPE_tt__ProfileCapabilities:
		return soap_out_tt__ProfileCapabilities(soap, tag, id, (const struct tt__ProfileCapabilities *)ptr, "tt:ProfileCapabilities");
	case SOAP_TYPE_tt__RealTimeStreamingCapabilities:
		return soap_out_tt__RealTimeStreamingCapabilities(soap, tag, id, (const struct tt__RealTimeStreamingCapabilities *)ptr, "tt:RealTimeStreamingCapabilities");
	case SOAP_TYPE_tt__MediaCapabilities:
		return soap_out_tt__MediaCapabilities(soap, tag, id, (const struct tt__MediaCapabilities *)ptr, "tt:MediaCapabilities");
	case SOAP_TYPE_tt__IOCapabilities:
		return soap_out_tt__IOCapabilities(soap, tag, id, (const struct tt__IOCapabilities *)ptr, "tt:IOCapabilities");
	case SOAP_TYPE_tt__EventCapabilities:
		return soap_out_tt__EventCapabilities(soap, tag, id, (const struct tt__EventCapabilities *)ptr, "tt:EventCapabilities");
	case SOAP_TYPE_tt__DeviceCapabilities:
		return soap_out_tt__DeviceCapabilities(soap, tag, id, (const struct tt__DeviceCapabilities *)ptr, "tt:DeviceCapabilities");
	case SOAP_TYPE_tt__AnalyticsCapabilities:
		return soap_out_tt__AnalyticsCapabilities(soap, tag, id, (const struct tt__AnalyticsCapabilities *)ptr, "tt:AnalyticsCapabilities");
	case SOAP_TYPE_tt__CapabilitiesExtension:
		return soap_out_tt__CapabilitiesExtension(soap, tag, id, (const struct tt__CapabilitiesExtension *)ptr, "tt:CapabilitiesExtension");
	case SOAP_TYPE_tt__Capabilities:
		return soap_out_tt__Capabilities(soap, tag, id, (const struct tt__Capabilities *)ptr, "tt:Capabilities");
	case SOAP_TYPE_tt__NetworkZeroConfiguration:
		return soap_out_tt__NetworkZeroConfiguration(soap, tag, id, (const struct tt__NetworkZeroConfiguration *)ptr, "tt:NetworkZeroConfiguration");
	case SOAP_TYPE_tt__NetworkGateway:
		return soap_out_tt__NetworkGateway(soap, tag, id, (const struct tt__NetworkGateway *)ptr, "tt:NetworkGateway");
	case SOAP_TYPE_tt__IPv4NetworkInterfaceSetConfiguration:
		return soap_out_tt__IPv4NetworkInterfaceSetConfiguration(soap, tag, id, (const struct tt__IPv4NetworkInterfaceSetConfiguration *)ptr, "tt:IPv4NetworkInterfaceSetConfiguration");
	case SOAP_TYPE_tt__NetworkInterfaceSetConfigurationExtension:
		return soap_out_tt__NetworkInterfaceSetConfigurationExtension(soap, tag, id, (const struct tt__NetworkInterfaceSetConfigurationExtension *)ptr, "tt:NetworkInterfaceSetConfigurationExtension");
	case SOAP_TYPE_tt__NetworkInterfaceSetConfiguration:
		return soap_out_tt__NetworkInterfaceSetConfiguration(soap, tag, id, (const struct tt__NetworkInterfaceSetConfiguration *)ptr, "tt:NetworkInterfaceSetConfiguration");
	case SOAP_TYPE_tt__DynamicDNSInformation:
		return soap_out_tt__DynamicDNSInformation(soap, tag, id, (const struct tt__DynamicDNSInformation *)ptr, "tt:DynamicDNSInformation");
	case SOAP_TYPE_tt__NTPInformation:
		return soap_out_tt__NTPInformation(soap, tag, id, (const struct tt__NTPInformation *)ptr, "tt:NTPInformation");
	case SOAP_TYPE_tt__DNSInformation:
		return soap_out_tt__DNSInformation(soap, tag, id, (const struct tt__DNSInformation *)ptr, "tt:DNSInformation");
	case SOAP_TYPE_tt__HostnameInformation:
		return soap_out_tt__HostnameInformation(soap, tag, id, (const struct tt__HostnameInformation *)ptr, "tt:HostnameInformation");
	case SOAP_TYPE_tt__PrefixedIPv4Address:
		return soap_out_tt__PrefixedIPv4Address(soap, tag, id, (const struct tt__PrefixedIPv4Address *)ptr, "tt:PrefixedIPv4Address");
	case SOAP_TYPE_tt__IPAddress:
		return soap_out_tt__IPAddress(soap, tag, id, (const struct tt__IPAddress *)ptr, "tt:IPAddress");
	case SOAP_TYPE_tt__NetworkHost:
		return soap_out_tt__NetworkHost(soap, tag, id, (const struct tt__NetworkHost *)ptr, "tt:NetworkHost");
	case SOAP_TYPE_tt__NetworkProtocol:
		return soap_out_tt__NetworkProtocol(soap, tag, id, (const struct tt__NetworkProtocol *)ptr, "tt:NetworkProtocol");
	case SOAP_TYPE_tt__IPv4Configuration:
		return soap_out_tt__IPv4Configuration(soap, tag, id, (const struct tt__IPv4Configuration *)ptr, "tt:IPv4Configuration");
	case SOAP_TYPE_tt__IPv4NetworkInterface:
		return soap_out_tt__IPv4NetworkInterface(soap, tag, id, (const struct tt__IPv4NetworkInterface *)ptr, "tt:IPv4NetworkInterface");
	case SOAP_TYPE_tt__NetworkInterfaceInfo:
		return soap_out_tt__NetworkInterfaceInfo(soap, tag, id, (const struct tt__NetworkInterfaceInfo *)ptr, "tt:NetworkInterfaceInfo");
	case SOAP_TYPE_tt__NetworkInterfaceConnectionSetting:
		return soap_out_tt__NetworkInterfaceConnectionSetting(soap, tag, id, (const struct tt__NetworkInterfaceConnectionSetting *)ptr, "tt:NetworkInterfaceConnectionSetting");
	case SOAP_TYPE_tt__NetworkInterfaceLink:
		return soap_out_tt__NetworkInterfaceLink(soap, tag, id, (const struct tt__NetworkInterfaceLink *)ptr, "tt:NetworkInterfaceLink");
	case SOAP_TYPE_tt__NetworkInterfaceExtension2:
		return soap_out_tt__NetworkInterfaceExtension2(soap, tag, id, (const struct tt__NetworkInterfaceExtension2 *)ptr, "tt:NetworkInterfaceExtension2");
	case SOAP_TYPE_tt__Dot3Configuration:
		return soap_out_tt__Dot3Configuration(soap, tag, id, (const struct tt__Dot3Configuration *)ptr, "tt:Dot3Configuration");
	case SOAP_TYPE_tt__NetworkInterfaceExtension:
		return soap_out_tt__NetworkInterfaceExtension(soap, tag, id, (const struct tt__NetworkInterfaceExtension *)ptr, "tt:NetworkInterfaceExtension");
	case SOAP_TYPE_tt__NetworkInterface:
		return soap_out_tt__NetworkInterface(soap, tag, id, (const struct tt__NetworkInterface *)ptr, "tt:NetworkInterface");
	case SOAP_TYPE_tt__Scope:
		return soap_out_tt__Scope(soap, tag, id, (const struct tt__Scope *)ptr, "tt:Scope");
	case SOAP_TYPE_tt__MediaUri:
		return soap_out_tt__MediaUri(soap, tag, id, (const struct tt__MediaUri *)ptr, "tt:MediaUri");
	case SOAP_TYPE_tt__Transport:
		return soap_out_tt__Transport(soap, tag, id, (const struct tt__Transport *)ptr, "tt:Transport");
	case SOAP_TYPE_tt__StreamSetup:
		return soap_out_tt__StreamSetup(soap, tag, id, (const struct tt__StreamSetup *)ptr, "tt:StreamSetup");
	case SOAP_TYPE_tt__MulticastConfiguration:
		return soap_out_tt__MulticastConfiguration(soap, tag, id, (const struct tt__MulticastConfiguration *)ptr, "tt:MulticastConfiguration");
	case SOAP_TYPE_tt__PTZStatusFilterOptions:
		return soap_out_tt__PTZStatusFilterOptions(soap, tag, id, (const struct tt__PTZStatusFilterOptions *)ptr, "tt:PTZStatusFilterOptions");
	case SOAP_TYPE_tt__MetadataConfigurationOptions:
		return soap_out_tt__MetadataConfigurationOptions(soap, tag, id, (const struct tt__MetadataConfigurationOptions *)ptr, "tt:MetadataConfigurationOptions");
	case SOAP_TYPE_tt__EventSubscription:
		return soap_out_tt__EventSubscription(soap, tag, id, (const struct tt__EventSubscription *)ptr, "tt:EventSubscription");
	case SOAP_TYPE_tt__MetadataConfiguration:
		return soap_out_tt__MetadataConfiguration(soap, tag, id, (const struct tt__MetadataConfiguration *)ptr, "tt:MetadataConfiguration");
	case SOAP_TYPE_tt__AudioEncoderConfigurationOption:
		return soap_out_tt__AudioEncoderConfigurationOption(soap, tag, id, (const struct tt__AudioEncoderConfigurationOption *)ptr, "tt:AudioEncoderConfigurationOption");
	case SOAP_TYPE_tt__AudioEncoderConfigurationOptions:
		return soap_out_tt__AudioEncoderConfigurationOptions(soap, tag, id, (const struct tt__AudioEncoderConfigurationOptions *)ptr, "tt:AudioEncoderConfigurationOptions");
	case SOAP_TYPE_tt__AudioEncoderConfiguration:
		return soap_out_tt__AudioEncoderConfiguration(soap, tag, id, (const struct tt__AudioEncoderConfiguration *)ptr, "tt:AudioEncoderConfiguration");
	case SOAP_TYPE_tt__AudioSourceConfigurationOptions:
		return soap_out_tt__AudioSourceConfigurationOptions(soap, tag, id, (const struct tt__AudioSourceConfigurationOptions *)ptr, "tt:AudioSourceConfigurationOptions");
	case SOAP_TYPE_tt__AudioSourceConfiguration:
		return soap_out_tt__AudioSourceConfiguration(soap, tag, id, (const struct tt__AudioSourceConfiguration *)ptr, "tt:AudioSourceConfiguration");
	case SOAP_TYPE_tt__H264Options:
		return soap_out_tt__H264Options(soap, tag, id, (const struct tt__H264Options *)ptr, "tt:H264Options");
	case SOAP_TYPE_tt__Mpeg4Options:
		return soap_out_tt__Mpeg4Options(soap, tag, id, (const struct tt__Mpeg4Options *)ptr, "tt:Mpeg4Options");
	case SOAP_TYPE_tt__JpegOptions:
		return soap_out_tt__JpegOptions(soap, tag, id, (const struct tt__JpegOptions *)ptr, "tt:JpegOptions");
	case SOAP_TYPE_tt__VideoEncoderConfigurationOptions:
		return soap_out_tt__VideoEncoderConfigurationOptions(soap, tag, id, (const struct tt__VideoEncoderConfigurationOptions *)ptr, "tt:VideoEncoderConfigurationOptions");
	case SOAP_TYPE_tt__H264Configuration:
		return soap_out_tt__H264Configuration(soap, tag, id, (const struct tt__H264Configuration *)ptr, "tt:H264Configuration");
	case SOAP_TYPE_tt__Mpeg4Configuration:
		return soap_out_tt__Mpeg4Configuration(soap, tag, id, (const struct tt__Mpeg4Configuration *)ptr, "tt:Mpeg4Configuration");
	case SOAP_TYPE_tt__VideoRateControl:
		return soap_out_tt__VideoRateControl(soap, tag, id, (const struct tt__VideoRateControl *)ptr, "tt:VideoRateControl");
	case SOAP_TYPE_tt__VideoResolution:
		return soap_out_tt__VideoResolution(soap, tag, id, (const struct tt__VideoResolution *)ptr, "tt:VideoResolution");
	case SOAP_TYPE_tt__VideoEncoderConfiguration:
		return soap_out_tt__VideoEncoderConfiguration(soap, tag, id, (const struct tt__VideoEncoderConfiguration *)ptr, "tt:VideoEncoderConfiguration");
	case SOAP_TYPE_tt__VideoSourceConfigurationOptions:
		return soap_out_tt__VideoSourceConfigurationOptions(soap, tag, id, (const struct tt__VideoSourceConfigurationOptions *)ptr, "tt:VideoSourceConfigurationOptions");
	case SOAP_TYPE_tt__VideoSourceConfiguration:
		return soap_out_tt__VideoSourceConfiguration(soap, tag, id, (const struct tt__VideoSourceConfiguration *)ptr, "tt:VideoSourceConfiguration");
	case SOAP_TYPE_tt__ConfigurationEntity:
		return soap_out_tt__ConfigurationEntity(soap, tag, id, (const struct tt__ConfigurationEntity *)ptr, "tt:ConfigurationEntity");
	case SOAP_TYPE_tt__Profile:
		return soap_out_tt__Profile(soap, tag, id, (const struct tt__Profile *)ptr, "tt:Profile");
	case SOAP_TYPE_tt__AudioSource:
		return soap_out_tt__AudioSource(soap, tag, id, (const struct tt__AudioSource *)ptr, "tt:AudioSource");
	case SOAP_TYPE_tt__VideoSource:
		return soap_out_tt__VideoSource(soap, tag, id, (const struct tt__VideoSource *)ptr, "tt:VideoSource");
	case SOAP_TYPE_tt__IntList:
		return soap_out_tt__IntList(soap, tag, id, (const struct tt__IntList *)ptr, "tt:IntList");
	case SOAP_TYPE_tt__DurationRange:
		return soap_out_tt__DurationRange(soap, tag, id, (const struct tt__DurationRange *)ptr, "tt:DurationRange");
	case SOAP_TYPE_tt__FloatRange:
		return soap_out_tt__FloatRange(soap, tag, id, (const struct tt__FloatRange *)ptr, "tt:FloatRange");
	case SOAP_TYPE_tt__IntRange:
		return soap_out_tt__IntRange(soap, tag, id, (const struct tt__IntRange *)ptr, "tt:IntRange");
	case SOAP_TYPE_tt__IntRectangleRange:
		return soap_out_tt__IntRectangleRange(soap, tag, id, (const struct tt__IntRectangleRange *)ptr, "tt:IntRectangleRange");
	case SOAP_TYPE_tt__IntRectangle:
		return soap_out_tt__IntRectangle(soap, tag, id, (const struct tt__IntRectangle *)ptr, "tt:IntRectangle");
	case SOAP_TYPE_tt__DeviceEntity:
		return soap_out_tt__DeviceEntity(soap, tag, id, (const struct tt__DeviceEntity *)ptr, "tt:DeviceEntity");
	case SOAP_TYPE_wsr__ResourceUnknownFaultType:
		return soap_out_wsr__ResourceUnknownFaultType(soap, tag, id, (const struct wsr__ResourceUnknownFaultType *)ptr, "wsr:ResourceUnknownFaultType");
	case SOAP_TYPE_wstop__TopicSetType:
		return soap_out_wstop__TopicSetType(soap, tag, id, (const struct wstop__TopicSetType *)ptr, "wstop:TopicSetType");
	case SOAP_TYPE_wstop__QueryExpressionType:
		return soap_out_wstop__QueryExpressionType(soap, tag, id, (const struct wstop__QueryExpressionType *)ptr, "wstop:QueryExpressionType");
	case SOAP_TYPE_wstop__ExtensibleDocumented:
		return soap_out_wstop__ExtensibleDocumented(soap, tag, id, (const struct wstop__ExtensibleDocumented *)ptr, "wstop:ExtensibleDocumented");
	case SOAP_TYPE_wstop__Documentation:
		return soap_out_wstop__Documentation(soap, tag, id, (const struct wstop__Documentation *)ptr, "wstop:Documentation");
	case SOAP_TYPE_wsa__AttributedURIType:
		return soap_out_wsa__AttributedURIType(soap, tag, id, (const struct wsa__AttributedURIType *)ptr, "wsa:AttributedURIType");
	case SOAP_TYPE_wsa__RelatesToType:
		return soap_out_wsa__RelatesToType(soap, tag, id, (const struct wsa__RelatesToType *)ptr, "wsa:RelatesToType");
	case SOAP_TYPE_wsa__MetadataType:
		return soap_out_wsa__MetadataType(soap, tag, id, (const struct wsa__MetadataType *)ptr, "wsa:MetadataType");
	case SOAP_TYPE_wsa__ReferenceParametersType:
		return soap_out_wsa__ReferenceParametersType(soap, tag, id, (const struct wsa__ReferenceParametersType *)ptr, "wsa:ReferenceParametersType");
	case SOAP_TYPE_wsa__EndpointReferenceType:
		return soap_out_wsa__EndpointReferenceType(soap, tag, id, (const struct wsa__EndpointReferenceType *)ptr, "wsa:EndpointReferenceType");
	case SOAP_TYPE_wsbf__BaseFaultType:
		return soap_out_wsbf__BaseFaultType(soap, tag, id, (const struct wsbf__BaseFaultType *)ptr, "wsbf:BaseFaultType");
	case SOAP_TYPE__wsnt__UnsubscribeResponse:
		return soap_out__wsnt__UnsubscribeResponse(soap, "wsnt:UnsubscribeResponse", id, (const struct _wsnt__UnsubscribeResponse *)ptr, NULL);
	case SOAP_TYPE__wsnt__Unsubscribe:
		return soap_out__wsnt__Unsubscribe(soap, "wsnt:Unsubscribe", id, (const struct _wsnt__Unsubscribe *)ptr, NULL);
	case SOAP_TYPE__wsnt__RenewResponse:
		return soap_out__wsnt__RenewResponse(soap, "wsnt:RenewResponse", id, (const struct _wsnt__RenewResponse *)ptr, NULL);
	case SOAP_TYPE__wsnt__Renew:
		return soap_out__wsnt__Renew(soap, "wsnt:Renew", id, (const struct _wsnt__Renew *)ptr, NULL);
	case SOAP_TYPE__wsnt__SubscribeResponse:
		return soap_out__wsnt__SubscribeResponse(soap, "wsnt:SubscribeResponse", id, (const struct _wsnt__SubscribeResponse *)ptr, NULL);
	case SOAP_TYPE__wsnt__Subscribe:
		return soap_out__wsnt__Subscribe(soap, "wsnt:Subscribe", id, (const struct _wsnt__Subscribe *)ptr, NULL);
	case SOAP_TYPE__wsnt__Notify:
		return soap_out__wsnt__Notify(soap, "wsnt:Notify", id, (const struct _wsnt__Notify *)ptr, NULL);
	case SOAP_TYPE_wsnt__UnableToDestroySubscriptionFaultType:
		return soap_out_wsnt__UnableToDestroySubscriptionFaultType(soap, tag, id, (const struct wsnt__UnableToDestroySubscriptionFaultType *)ptr, "wsnt:UnableToDestroySubscriptionFaultType");
	case SOAP_TYPE_wsnt__NotificationMessageHolderType:
		return soap_out_wsnt__NotificationMessageHolderType(soap, tag, id, (const struct wsnt__NotificationMessageHolderType *)ptr, "wsnt:NotificationMessageHolderType");
	case SOAP_TYPE_wsnt__FilterType:
		return soap_out_wsnt__FilterType(soap, tag, id, (const struct wsnt__FilterType *)ptr, "wsnt:FilterType");
	case SOAP_TYPE_wsnt__TopicExpressionType:
		return soap_out_wsnt__TopicExpressionType(soap, tag, id, (const struct wsnt__TopicExpressionType *)ptr, "wsnt:TopicExpressionType");
	case SOAP_TYPE_wsnt__QueryExpressionType:
		return soap_out_wsnt__QueryExpressionType(soap, tag, id, (const struct wsnt__QueryExpressionType *)ptr, "wsnt:QueryExpressionType");
	case SOAP_TYPE_wsadis__AttributedURI:
		return soap_out_wsadis__AttributedURI(soap, tag, id, (const struct wsadis__AttributedURI *)ptr, "wsadis:AttributedURI");
	case SOAP_TYPE_wsadis__AttributedQName:
		return soap_out_wsadis__AttributedQName(soap, tag, id, (const struct wsadis__AttributedQName *)ptr, "wsadis:AttributedQName");
	case SOAP_TYPE_wsadis__Relationship:
		return soap_out_wsadis__Relationship(soap, tag, id, (const struct wsadis__Relationship *)ptr, "wsadis:Relationship");
	case SOAP_TYPE_wsadis__ServiceNameType:
		return soap_out_wsadis__ServiceNameType(soap, tag, id, (const struct wsadis__ServiceNameType *)ptr, "wsadis:ServiceNameType");
	case SOAP_TYPE_wsadis__ReferenceParametersType:
		return soap_out_wsadis__ReferenceParametersType(soap, tag, id, (const struct wsadis__ReferenceParametersType *)ptr, "wsadis:ReferenceParametersType");
	case SOAP_TYPE_wsadis__ReferencePropertiesType:
		return soap_out_wsadis__ReferencePropertiesType(soap, tag, id, (const struct wsadis__ReferencePropertiesType *)ptr, "wsadis:ReferencePropertiesType");
	case SOAP_TYPE_wsadis__EndpointReferenceType:
		return soap_out_wsadis__EndpointReferenceType(soap, tag, id, (const struct wsadis__EndpointReferenceType *)ptr, "wsadis:EndpointReferenceType");
	case SOAP_TYPE_PointerTo_wsse__Security:
		return soap_out_PointerTo_wsse__Security(soap, tag, id, (struct wsse__SecurityHeaderType *const*)ptr, "wsse:Security");
	case SOAP_TYPE_PointerTo_d__AppSequence:
		return soap_out_PointerTo_d__AppSequence(soap, tag, id, (struct d__AppSequenceType *const*)ptr, "d:AppSequence");
	case SOAP_TYPE_PointerTo_wsa__FaultTo:
		return soap_out_PointerTo_wsa__FaultTo(soap, tag, id, (struct wsa__EndpointReferenceType *const*)ptr, "wsa:FaultTo");
	case SOAP_TYPE_PointerTo_wsa__ReplyTo:
		return soap_out_PointerTo_wsa__ReplyTo(soap, tag, id, (struct wsa__EndpointReferenceType *const*)ptr, "wsa:ReplyTo");
	case SOAP_TYPE_PointerTo_wsa__From:
		return soap_out_PointerTo_wsa__From(soap, tag, id, (struct wsa__EndpointReferenceType *const*)ptr, "wsa:From");
	case SOAP_TYPE_PointerTo_wsa__RelatesTo:
		return soap_out_PointerTo_wsa__RelatesTo(soap, tag, id, (struct wsa__RelatesToType *const*)ptr, "wsa:RelatesTo");
	case SOAP_TYPE_PointerTo_trt__GetSnapshotUriResponse:
		return soap_out_PointerTo_trt__GetSnapshotUriResponse(soap, tag, id, (struct _trt__GetSnapshotUriResponse *const*)ptr, "trt:GetSnapshotUriResponse");
	case SOAP_TYPE_PointerTo_trt__GetSnapshotUri:
		return soap_out_PointerTo_trt__GetSnapshotUri(soap, tag, id, (struct _trt__GetSnapshotUri *const*)ptr, "trt:GetSnapshotUri");
	case SOAP_TYPE_PointerTo_trt__SetSynchronizationPointResponse:
		return soap_out_PointerTo_trt__SetSynchronizationPointResponse(soap, tag, id, (struct _trt__SetSynchronizationPointResponse *const*)ptr, "trt:SetSynchronizationPointResponse");
	case SOAP_TYPE_PointerTo_trt__SetSynchronizationPoint:
		return soap_out_PointerTo_trt__SetSynchronizationPoint(soap, tag, id, (struct _trt__SetSynchronizationPoint *const*)ptr, "trt:SetSynchronizationPoint");
	case SOAP_TYPE_PointerTo_trt__GetStreamUriResponse:
		return soap_out_PointerTo_trt__GetStreamUriResponse(soap, tag, id, (struct _trt__GetStreamUriResponse *const*)ptr, "trt:GetStreamUriResponse");
	case SOAP_TYPE_PointerTo_trt__GetStreamUri:
		return soap_out_PointerTo_trt__GetStreamUri(soap, tag, id, (struct _trt__GetStreamUri *const*)ptr, "trt:GetStreamUri");
	case SOAP_TYPE_PointerTo_trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse:
		return soap_out_PointerTo_trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse(soap, tag, id, (struct _trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse *const*)ptr, "trt:GetGuaranteedNumberOfVideoEncoderInstancesResponse");
	case SOAP_TYPE_PointerTo_trt__GetGuaranteedNumberOfVideoEncoderInstances:
		return soap_out_PointerTo_trt__GetGuaranteedNumberOfVideoEncoderInstances(soap, tag, id, (struct _trt__GetGuaranteedNumberOfVideoEncoderInstances *const*)ptr, "trt:GetGuaranteedNumberOfVideoEncoderInstances");
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfigurationOptionsResponse:
		return soap_out_PointerTo_trt__GetMetadataConfigurationOptionsResponse(soap, tag, id, (struct _trt__GetMetadataConfigurationOptionsResponse *const*)ptr, "trt:GetMetadataConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfigurationOptions:
		return soap_out_PointerTo_trt__GetMetadataConfigurationOptions(soap, tag, id, (struct _trt__GetMetadataConfigurationOptions *const*)ptr, "trt:GetMetadataConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationOptionsResponse:
		return soap_out_PointerTo_trt__GetAudioEncoderConfigurationOptionsResponse(soap, tag, id, (struct _trt__GetAudioEncoderConfigurationOptionsResponse *const*)ptr, "trt:GetAudioEncoderConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationOptions:
		return soap_out_PointerTo_trt__GetAudioEncoderConfigurationOptions(soap, tag, id, (struct _trt__GetAudioEncoderConfigurationOptions *const*)ptr, "trt:GetAudioEncoderConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationOptionsResponse:
		return soap_out_PointerTo_trt__GetAudioSourceConfigurationOptionsResponse(soap, tag, id, (struct _trt__GetAudioSourceConfigurationOptionsResponse *const*)ptr, "trt:GetAudioSourceConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationOptions:
		return soap_out_PointerTo_trt__GetAudioSourceConfigurationOptions(soap, tag, id, (struct _trt__GetAudioSourceConfigurationOptions *const*)ptr, "trt:GetAudioSourceConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationOptionsResponse:
		return soap_out_PointerTo_trt__GetVideoEncoderConfigurationOptionsResponse(soap, tag, id, (struct _trt__GetVideoEncoderConfigurationOptionsResponse *const*)ptr, "trt:GetVideoEncoderConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationOptions:
		return soap_out_PointerTo_trt__GetVideoEncoderConfigurationOptions(soap, tag, id, (struct _trt__GetVideoEncoderConfigurationOptions *const*)ptr, "trt:GetVideoEncoderConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationOptionsResponse:
		return soap_out_PointerTo_trt__GetVideoSourceConfigurationOptionsResponse(soap, tag, id, (struct _trt__GetVideoSourceConfigurationOptionsResponse *const*)ptr, "trt:GetVideoSourceConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationOptions:
		return soap_out_PointerTo_trt__GetVideoSourceConfigurationOptions(soap, tag, id, (struct _trt__GetVideoSourceConfigurationOptions *const*)ptr, "trt:GetVideoSourceConfigurationOptions");
	case SOAP_TYPE_PointerTo_trt__SetMetadataConfigurationResponse:
		return soap_out_PointerTo_trt__SetMetadataConfigurationResponse(soap, tag, id, (struct _trt__SetMetadataConfigurationResponse *const*)ptr, "trt:SetMetadataConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetMetadataConfiguration:
		return soap_out_PointerTo_trt__SetMetadataConfiguration(soap, tag, id, (struct _trt__SetMetadataConfiguration *const*)ptr, "trt:SetMetadataConfiguration");
	case SOAP_TYPE_PointerTo_trt__SetAudioEncoderConfigurationResponse:
		return soap_out_PointerTo_trt__SetAudioEncoderConfigurationResponse(soap, tag, id, (struct _trt__SetAudioEncoderConfigurationResponse *const*)ptr, "trt:SetAudioEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetAudioEncoderConfiguration:
		return soap_out_PointerTo_trt__SetAudioEncoderConfiguration(soap, tag, id, (struct _trt__SetAudioEncoderConfiguration *const*)ptr, "trt:SetAudioEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__SetAudioSourceConfigurationResponse:
		return soap_out_PointerTo_trt__SetAudioSourceConfigurationResponse(soap, tag, id, (struct _trt__SetAudioSourceConfigurationResponse *const*)ptr, "trt:SetAudioSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetAudioSourceConfiguration:
		return soap_out_PointerTo_trt__SetAudioSourceConfiguration(soap, tag, id, (struct _trt__SetAudioSourceConfiguration *const*)ptr, "trt:SetAudioSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__SetVideoEncoderConfigurationResponse:
		return soap_out_PointerTo_trt__SetVideoEncoderConfigurationResponse(soap, tag, id, (struct _trt__SetVideoEncoderConfigurationResponse *const*)ptr, "trt:SetVideoEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetVideoEncoderConfiguration:
		return soap_out_PointerTo_trt__SetVideoEncoderConfiguration(soap, tag, id, (struct _trt__SetVideoEncoderConfiguration *const*)ptr, "trt:SetVideoEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__SetVideoSourceConfigurationResponse:
		return soap_out_PointerTo_trt__SetVideoSourceConfigurationResponse(soap, tag, id, (struct _trt__SetVideoSourceConfigurationResponse *const*)ptr, "trt:SetVideoSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__SetVideoSourceConfiguration:
		return soap_out_PointerTo_trt__SetVideoSourceConfiguration(soap, tag, id, (struct _trt__SetVideoSourceConfiguration *const*)ptr, "trt:SetVideoSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleMetadataConfigurationsResponse:
		return soap_out_PointerTo_trt__GetCompatibleMetadataConfigurationsResponse(soap, tag, id, (struct _trt__GetCompatibleMetadataConfigurationsResponse *const*)ptr, "trt:GetCompatibleMetadataConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleMetadataConfigurations:
		return soap_out_PointerTo_trt__GetCompatibleMetadataConfigurations(soap, tag, id, (struct _trt__GetCompatibleMetadataConfigurations *const*)ptr, "trt:GetCompatibleMetadataConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioSourceConfigurationsResponse:
		return soap_out_PointerTo_trt__GetCompatibleAudioSourceConfigurationsResponse(soap, tag, id, (struct _trt__GetCompatibleAudioSourceConfigurationsResponse *const*)ptr, "trt:GetCompatibleAudioSourceConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioSourceConfigurations:
		return soap_out_PointerTo_trt__GetCompatibleAudioSourceConfigurations(soap, tag, id, (struct _trt__GetCompatibleAudioSourceConfigurations *const*)ptr, "trt:GetCompatibleAudioSourceConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioEncoderConfigurationsResponse:
		return soap_out_PointerTo_trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, tag, id, (struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *const*)ptr, "trt:GetCompatibleAudioEncoderConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioEncoderConfigurations:
		return soap_out_PointerTo_trt__GetCompatibleAudioEncoderConfigurations(soap, tag, id, (struct _trt__GetCompatibleAudioEncoderConfigurations *const*)ptr, "trt:GetCompatibleAudioEncoderConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoSourceConfigurationsResponse:
		return soap_out_PointerTo_trt__GetCompatibleVideoSourceConfigurationsResponse(soap, tag, id, (struct _trt__GetCompatibleVideoSourceConfigurationsResponse *const*)ptr, "trt:GetCompatibleVideoSourceConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoSourceConfigurations:
		return soap_out_PointerTo_trt__GetCompatibleVideoSourceConfigurations(soap, tag, id, (struct _trt__GetCompatibleVideoSourceConfigurations *const*)ptr, "trt:GetCompatibleVideoSourceConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoEncoderConfigurationsResponse:
		return soap_out_PointerTo_trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, tag, id, (struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *const*)ptr, "trt:GetCompatibleVideoEncoderConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoEncoderConfigurations:
		return soap_out_PointerTo_trt__GetCompatibleVideoEncoderConfigurations(soap, tag, id, (struct _trt__GetCompatibleVideoEncoderConfigurations *const*)ptr, "trt:GetCompatibleVideoEncoderConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfigurationResponse:
		return soap_out_PointerTo_trt__GetMetadataConfigurationResponse(soap, tag, id, (struct _trt__GetMetadataConfigurationResponse *const*)ptr, "trt:GetMetadataConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfiguration:
		return soap_out_PointerTo_trt__GetMetadataConfiguration(soap, tag, id, (struct _trt__GetMetadataConfiguration *const*)ptr, "trt:GetMetadataConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationResponse:
		return soap_out_PointerTo_trt__GetAudioEncoderConfigurationResponse(soap, tag, id, (struct _trt__GetAudioEncoderConfigurationResponse *const*)ptr, "trt:GetAudioEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfiguration:
		return soap_out_PointerTo_trt__GetAudioEncoderConfiguration(soap, tag, id, (struct _trt__GetAudioEncoderConfiguration *const*)ptr, "trt:GetAudioEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationResponse:
		return soap_out_PointerTo_trt__GetAudioSourceConfigurationResponse(soap, tag, id, (struct _trt__GetAudioSourceConfigurationResponse *const*)ptr, "trt:GetAudioSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfiguration:
		return soap_out_PointerTo_trt__GetAudioSourceConfiguration(soap, tag, id, (struct _trt__GetAudioSourceConfiguration *const*)ptr, "trt:GetAudioSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationResponse:
		return soap_out_PointerTo_trt__GetVideoEncoderConfigurationResponse(soap, tag, id, (struct _trt__GetVideoEncoderConfigurationResponse *const*)ptr, "trt:GetVideoEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfiguration:
		return soap_out_PointerTo_trt__GetVideoEncoderConfiguration(soap, tag, id, (struct _trt__GetVideoEncoderConfiguration *const*)ptr, "trt:GetVideoEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationResponse:
		return soap_out_PointerTo_trt__GetVideoSourceConfigurationResponse(soap, tag, id, (struct _trt__GetVideoSourceConfigurationResponse *const*)ptr, "trt:GetVideoSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfiguration:
		return soap_out_PointerTo_trt__GetVideoSourceConfiguration(soap, tag, id, (struct _trt__GetVideoSourceConfiguration *const*)ptr, "trt:GetVideoSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfigurationsResponse:
		return soap_out_PointerTo_trt__GetMetadataConfigurationsResponse(soap, tag, id, (struct _trt__GetMetadataConfigurationsResponse *const*)ptr, "trt:GetMetadataConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfigurations:
		return soap_out_PointerTo_trt__GetMetadataConfigurations(soap, tag, id, (struct _trt__GetMetadataConfigurations *const*)ptr, "trt:GetMetadataConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationsResponse:
		return soap_out_PointerTo_trt__GetAudioEncoderConfigurationsResponse(soap, tag, id, (struct _trt__GetAudioEncoderConfigurationsResponse *const*)ptr, "trt:GetAudioEncoderConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurations:
		return soap_out_PointerTo_trt__GetAudioEncoderConfigurations(soap, tag, id, (struct _trt__GetAudioEncoderConfigurations *const*)ptr, "trt:GetAudioEncoderConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationsResponse:
		return soap_out_PointerTo_trt__GetAudioSourceConfigurationsResponse(soap, tag, id, (struct _trt__GetAudioSourceConfigurationsResponse *const*)ptr, "trt:GetAudioSourceConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurations:
		return soap_out_PointerTo_trt__GetAudioSourceConfigurations(soap, tag, id, (struct _trt__GetAudioSourceConfigurations *const*)ptr, "trt:GetAudioSourceConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationsResponse:
		return soap_out_PointerTo_trt__GetVideoEncoderConfigurationsResponse(soap, tag, id, (struct _trt__GetVideoEncoderConfigurationsResponse *const*)ptr, "trt:GetVideoEncoderConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurations:
		return soap_out_PointerTo_trt__GetVideoEncoderConfigurations(soap, tag, id, (struct _trt__GetVideoEncoderConfigurations *const*)ptr, "trt:GetVideoEncoderConfigurations");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationsResponse:
		return soap_out_PointerTo_trt__GetVideoSourceConfigurationsResponse(soap, tag, id, (struct _trt__GetVideoSourceConfigurationsResponse *const*)ptr, "trt:GetVideoSourceConfigurationsResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurations:
		return soap_out_PointerTo_trt__GetVideoSourceConfigurations(soap, tag, id, (struct _trt__GetVideoSourceConfigurations *const*)ptr, "trt:GetVideoSourceConfigurations");
	case SOAP_TYPE_PointerTo_trt__DeleteProfileResponse:
		return soap_out_PointerTo_trt__DeleteProfileResponse(soap, tag, id, (struct _trt__DeleteProfileResponse *const*)ptr, "trt:DeleteProfileResponse");
	case SOAP_TYPE_PointerTo_trt__DeleteProfile:
		return soap_out_PointerTo_trt__DeleteProfile(soap, tag, id, (struct _trt__DeleteProfile *const*)ptr, "trt:DeleteProfile");
	case SOAP_TYPE_PointerTo_trt__RemoveMetadataConfigurationResponse:
		return soap_out_PointerTo_trt__RemoveMetadataConfigurationResponse(soap, tag, id, (struct _trt__RemoveMetadataConfigurationResponse *const*)ptr, "trt:RemoveMetadataConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveMetadataConfiguration:
		return soap_out_PointerTo_trt__RemoveMetadataConfiguration(soap, tag, id, (struct _trt__RemoveMetadataConfiguration *const*)ptr, "trt:RemoveMetadataConfiguration");
	case SOAP_TYPE_PointerTo_trt__RemovePTZConfigurationResponse:
		return soap_out_PointerTo_trt__RemovePTZConfigurationResponse(soap, tag, id, (struct _trt__RemovePTZConfigurationResponse *const*)ptr, "trt:RemovePTZConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemovePTZConfiguration:
		return soap_out_PointerTo_trt__RemovePTZConfiguration(soap, tag, id, (struct _trt__RemovePTZConfiguration *const*)ptr, "trt:RemovePTZConfiguration");
	case SOAP_TYPE_PointerTo_trt__RemoveAudioSourceConfigurationResponse:
		return soap_out_PointerTo_trt__RemoveAudioSourceConfigurationResponse(soap, tag, id, (struct _trt__RemoveAudioSourceConfigurationResponse *const*)ptr, "trt:RemoveAudioSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveAudioSourceConfiguration:
		return soap_out_PointerTo_trt__RemoveAudioSourceConfiguration(soap, tag, id, (struct _trt__RemoveAudioSourceConfiguration *const*)ptr, "trt:RemoveAudioSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__RemoveAudioEncoderConfigurationResponse:
		return soap_out_PointerTo_trt__RemoveAudioEncoderConfigurationResponse(soap, tag, id, (struct _trt__RemoveAudioEncoderConfigurationResponse *const*)ptr, "trt:RemoveAudioEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveAudioEncoderConfiguration:
		return soap_out_PointerTo_trt__RemoveAudioEncoderConfiguration(soap, tag, id, (struct _trt__RemoveAudioEncoderConfiguration *const*)ptr, "trt:RemoveAudioEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__RemoveVideoSourceConfigurationResponse:
		return soap_out_PointerTo_trt__RemoveVideoSourceConfigurationResponse(soap, tag, id, (struct _trt__RemoveVideoSourceConfigurationResponse *const*)ptr, "trt:RemoveVideoSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveVideoSourceConfiguration:
		return soap_out_PointerTo_trt__RemoveVideoSourceConfiguration(soap, tag, id, (struct _trt__RemoveVideoSourceConfiguration *const*)ptr, "trt:RemoveVideoSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__RemoveVideoEncoderConfigurationResponse:
		return soap_out_PointerTo_trt__RemoveVideoEncoderConfigurationResponse(soap, tag, id, (struct _trt__RemoveVideoEncoderConfigurationResponse *const*)ptr, "trt:RemoveVideoEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__RemoveVideoEncoderConfiguration:
		return soap_out_PointerTo_trt__RemoveVideoEncoderConfiguration(soap, tag, id, (struct _trt__RemoveVideoEncoderConfiguration *const*)ptr, "trt:RemoveVideoEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddMetadataConfigurationResponse:
		return soap_out_PointerTo_trt__AddMetadataConfigurationResponse(soap, tag, id, (struct _trt__AddMetadataConfigurationResponse *const*)ptr, "trt:AddMetadataConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddMetadataConfiguration:
		return soap_out_PointerTo_trt__AddMetadataConfiguration(soap, tag, id, (struct _trt__AddMetadataConfiguration *const*)ptr, "trt:AddMetadataConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddPTZConfigurationResponse:
		return soap_out_PointerTo_trt__AddPTZConfigurationResponse(soap, tag, id, (struct _trt__AddPTZConfigurationResponse *const*)ptr, "trt:AddPTZConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddPTZConfiguration:
		return soap_out_PointerTo_trt__AddPTZConfiguration(soap, tag, id, (struct _trt__AddPTZConfiguration *const*)ptr, "trt:AddPTZConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddAudioSourceConfigurationResponse:
		return soap_out_PointerTo_trt__AddAudioSourceConfigurationResponse(soap, tag, id, (struct _trt__AddAudioSourceConfigurationResponse *const*)ptr, "trt:AddAudioSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddAudioSourceConfiguration:
		return soap_out_PointerTo_trt__AddAudioSourceConfiguration(soap, tag, id, (struct _trt__AddAudioSourceConfiguration *const*)ptr, "trt:AddAudioSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddAudioEncoderConfigurationResponse:
		return soap_out_PointerTo_trt__AddAudioEncoderConfigurationResponse(soap, tag, id, (struct _trt__AddAudioEncoderConfigurationResponse *const*)ptr, "trt:AddAudioEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddAudioEncoderConfiguration:
		return soap_out_PointerTo_trt__AddAudioEncoderConfiguration(soap, tag, id, (struct _trt__AddAudioEncoderConfiguration *const*)ptr, "trt:AddAudioEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddVideoSourceConfigurationResponse:
		return soap_out_PointerTo_trt__AddVideoSourceConfigurationResponse(soap, tag, id, (struct _trt__AddVideoSourceConfigurationResponse *const*)ptr, "trt:AddVideoSourceConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddVideoSourceConfiguration:
		return soap_out_PointerTo_trt__AddVideoSourceConfiguration(soap, tag, id, (struct _trt__AddVideoSourceConfiguration *const*)ptr, "trt:AddVideoSourceConfiguration");
	case SOAP_TYPE_PointerTo_trt__AddVideoEncoderConfigurationResponse:
		return soap_out_PointerTo_trt__AddVideoEncoderConfigurationResponse(soap, tag, id, (struct _trt__AddVideoEncoderConfigurationResponse *const*)ptr, "trt:AddVideoEncoderConfigurationResponse");
	case SOAP_TYPE_PointerTo_trt__AddVideoEncoderConfiguration:
		return soap_out_PointerTo_trt__AddVideoEncoderConfiguration(soap, tag, id, (struct _trt__AddVideoEncoderConfiguration *const*)ptr, "trt:AddVideoEncoderConfiguration");
	case SOAP_TYPE_PointerTo_trt__GetProfilesResponse:
		return soap_out_PointerTo_trt__GetProfilesResponse(soap, tag, id, (struct _trt__GetProfilesResponse *const*)ptr, "trt:GetProfilesResponse");
	case SOAP_TYPE_PointerTo_trt__GetProfiles:
		return soap_out_PointerTo_trt__GetProfiles(soap, tag, id, (struct _trt__GetProfiles *const*)ptr, "trt:GetProfiles");
	case SOAP_TYPE_PointerTo_trt__GetProfileResponse:
		return soap_out_PointerTo_trt__GetProfileResponse(soap, tag, id, (struct _trt__GetProfileResponse *const*)ptr, "trt:GetProfileResponse");
	case SOAP_TYPE_PointerTo_trt__GetProfile:
		return soap_out_PointerTo_trt__GetProfile(soap, tag, id, (struct _trt__GetProfile *const*)ptr, "trt:GetProfile");
	case SOAP_TYPE_PointerTo_trt__CreateProfileResponse:
		return soap_out_PointerTo_trt__CreateProfileResponse(soap, tag, id, (struct _trt__CreateProfileResponse *const*)ptr, "trt:CreateProfileResponse");
	case SOAP_TYPE_PointerTo_trt__CreateProfile:
		return soap_out_PointerTo_trt__CreateProfile(soap, tag, id, (struct _trt__CreateProfile *const*)ptr, "trt:CreateProfile");
	case SOAP_TYPE_PointerTo_trt__GetAudioSourcesResponse:
		return soap_out_PointerTo_trt__GetAudioSourcesResponse(soap, tag, id, (struct _trt__GetAudioSourcesResponse *const*)ptr, "trt:GetAudioSourcesResponse");
	case SOAP_TYPE_PointerTo_trt__GetAudioSources:
		return soap_out_PointerTo_trt__GetAudioSources(soap, tag, id, (struct _trt__GetAudioSources *const*)ptr, "trt:GetAudioSources");
	case SOAP_TYPE_PointerTo_trt__GetVideoSourcesResponse:
		return soap_out_PointerTo_trt__GetVideoSourcesResponse(soap, tag, id, (struct _trt__GetVideoSourcesResponse *const*)ptr, "trt:GetVideoSourcesResponse");
	case SOAP_TYPE_PointerTo_trt__GetVideoSources:
		return soap_out_PointerTo_trt__GetVideoSources(soap, tag, id, (struct _trt__GetVideoSources *const*)ptr, "trt:GetVideoSources");
	case SOAP_TYPE_PointerTo_tptz__StopResponse:
		return soap_out_PointerTo_tptz__StopResponse(soap, tag, id, (struct _tptz__StopResponse *const*)ptr, "tptz:StopResponse");
	case SOAP_TYPE_PointerTo_tptz__Stop:
		return soap_out_PointerTo_tptz__Stop(soap, tag, id, (struct _tptz__Stop *const*)ptr, "tptz:Stop");
	case SOAP_TYPE_PointerTo_tptz__AbsoluteMoveResponse:
		return soap_out_PointerTo_tptz__AbsoluteMoveResponse(soap, tag, id, (struct _tptz__AbsoluteMoveResponse *const*)ptr, "tptz:AbsoluteMoveResponse");
	case SOAP_TYPE_PointerTo_tptz__AbsoluteMove:
		return soap_out_PointerTo_tptz__AbsoluteMove(soap, tag, id, (struct _tptz__AbsoluteMove *const*)ptr, "tptz:AbsoluteMove");
	case SOAP_TYPE_PointerTo_tptz__ContinuousMoveResponse:
		return soap_out_PointerTo_tptz__ContinuousMoveResponse(soap, tag, id, (struct _tptz__ContinuousMoveResponse *const*)ptr, "tptz:ContinuousMoveResponse");
	case SOAP_TYPE_PointerTo_tptz__ContinuousMove:
		return soap_out_PointerTo_tptz__ContinuousMove(soap, tag, id, (struct _tptz__ContinuousMove *const*)ptr, "tptz:ContinuousMove");
	case SOAP_TYPE_PointerTo_tptz__SetHomePositionResponse:
		return soap_out_PointerTo_tptz__SetHomePositionResponse(soap, tag, id, (char **const*)ptr, "tptz:SetHomePositionResponse");
	case SOAP_TYPE_PointerTo_tptz__SetHomePosition:
		return soap_out_PointerTo_tptz__SetHomePosition(soap, tag, id, (struct _tptz__SetHomePosition *const*)ptr, "tptz:SetHomePosition");
	case SOAP_TYPE_PointerTo_tptz__GotoHomePositionResponse:
		return soap_out_PointerTo_tptz__GotoHomePositionResponse(soap, tag, id, (struct _tptz__GotoHomePositionResponse *const*)ptr, "tptz:GotoHomePositionResponse");
	case SOAP_TYPE_PointerTo_tptz__GotoHomePosition:
		return soap_out_PointerTo_tptz__GotoHomePosition(soap, tag, id, (struct _tptz__GotoHomePosition *const*)ptr, "tptz:GotoHomePosition");
	case SOAP_TYPE_PointerTo_tptz__GetConfigurationOptionsResponse:
		return soap_out_PointerTo_tptz__GetConfigurationOptionsResponse(soap, tag, id, (struct _tptz__GetConfigurationOptionsResponse *const*)ptr, "tptz:GetConfigurationOptionsResponse");
	case SOAP_TYPE_PointerTo_tptz__GetConfigurationOptions:
		return soap_out_PointerTo_tptz__GetConfigurationOptions(soap, tag, id, (struct _tptz__GetConfigurationOptions *const*)ptr, "tptz:GetConfigurationOptions");
	case SOAP_TYPE_PointerTo_tptz__SetConfigurationResponse:
		return soap_out_PointerTo_tptz__SetConfigurationResponse(soap, tag, id, (struct _tptz__SetConfigurationResponse *const*)ptr, "tptz:SetConfigurationResponse");
	case SOAP_TYPE_PointerTo_tptz__SetConfiguration:
		return soap_out_PointerTo_tptz__SetConfiguration(soap, tag, id, (struct _tptz__SetConfiguration *const*)ptr, "tptz:SetConfiguration");
	case SOAP_TYPE_PointerTo_tptz__GetNodeResponse:
		return soap_out_PointerTo_tptz__GetNodeResponse(soap, tag, id, (struct _tptz__GetNodeResponse *const*)ptr, "tptz:GetNodeResponse");
	case SOAP_TYPE_PointerTo_tptz__GetNode:
		return soap_out_PointerTo_tptz__GetNode(soap, tag, id, (struct _tptz__GetNode *const*)ptr, "tptz:GetNode");
	case SOAP_TYPE_PointerTo_tptz__GetNodesResponse:
		return soap_out_PointerTo_tptz__GetNodesResponse(soap, tag, id, (struct _tptz__GetNodesResponse *const*)ptr, "tptz:GetNodesResponse");
	case SOAP_TYPE_PointerTo_tptz__GetNodes:
		return soap_out_PointerTo_tptz__GetNodes(soap, tag, id, (struct _tptz__GetNodes *const*)ptr, "tptz:GetNodes");
	case SOAP_TYPE_PointerTo_tptz__GetConfigurationResponse:
		return soap_out_PointerTo_tptz__GetConfigurationResponse(soap, tag, id, (struct _tptz__GetConfigurationResponse *const*)ptr, "tptz:GetConfigurationResponse");
	case SOAP_TYPE_PointerTo_tptz__GetConfiguration:
		return soap_out_PointerTo_tptz__GetConfiguration(soap, tag, id, (struct _tptz__GetConfiguration *const*)ptr, "tptz:GetConfiguration");
	case SOAP_TYPE_PointerTo_tptz__GetStatusResponse:
		return soap_out_PointerTo_tptz__GetStatusResponse(soap, tag, id, (struct _tptz__GetStatusResponse *const*)ptr, "tptz:GetStatusResponse");
	case SOAP_TYPE_PointerTo_tptz__GetStatus:
		return soap_out_PointerTo_tptz__GetStatus(soap, tag, id, (struct _tptz__GetStatus *const*)ptr, "tptz:GetStatus");
	case SOAP_TYPE_PointerTo_tptz__GotoPresetResponse:
		return soap_out_PointerTo_tptz__GotoPresetResponse(soap, tag, id, (struct _tptz__GotoPresetResponse *const*)ptr, "tptz:GotoPresetResponse");
	case SOAP_TYPE_PointerTo_tptz__GotoPreset:
		return soap_out_PointerTo_tptz__GotoPreset(soap, tag, id, (struct _tptz__GotoPreset *const*)ptr, "tptz:GotoPreset");
	case SOAP_TYPE_PointerTo_tptz__RemovePresetResponse:
		return soap_out_PointerTo_tptz__RemovePresetResponse(soap, tag, id, (struct _tptz__RemovePresetResponse *const*)ptr, "tptz:RemovePresetResponse");
	case SOAP_TYPE_PointerTo_tptz__RemovePreset:
		return soap_out_PointerTo_tptz__RemovePreset(soap, tag, id, (struct _tptz__RemovePreset *const*)ptr, "tptz:RemovePreset");
	case SOAP_TYPE_PointerTo_tptz__SetPresetResponse:
		return soap_out_PointerTo_tptz__SetPresetResponse(soap, tag, id, (struct _tptz__SetPresetResponse *const*)ptr, "tptz:SetPresetResponse");
	case SOAP_TYPE_PointerTo_tptz__SetPreset:
		return soap_out_PointerTo_tptz__SetPreset(soap, tag, id, (struct _tptz__SetPreset *const*)ptr, "tptz:SetPreset");
	case SOAP_TYPE_PointerTo_tptz__GetPresetsResponse:
		return soap_out_PointerTo_tptz__GetPresetsResponse(soap, tag, id, (struct _tptz__GetPresetsResponse *const*)ptr, "tptz:GetPresetsResponse");
	case SOAP_TYPE_PointerTo_tptz__GetPresets:
		return soap_out_PointerTo_tptz__GetPresets(soap, tag, id, (struct _tptz__GetPresets *const*)ptr, "tptz:GetPresets");
	case SOAP_TYPE_PointerTo_tptz__GetConfigurationsResponse:
		return soap_out_PointerTo_tptz__GetConfigurationsResponse(soap, tag, id, (struct _tptz__GetConfigurationsResponse *const*)ptr, "tptz:GetConfigurationsResponse");
	case SOAP_TYPE_PointerTo_tptz__GetConfigurations:
		return soap_out_PointerTo_tptz__GetConfigurations(soap, tag, id, (struct _tptz__GetConfigurations *const*)ptr, "tptz:GetConfigurations");
	case SOAP_TYPE_PointerTo_tds__SetRelayOutputStateResponse:
		return soap_out_PointerTo_tds__SetRelayOutputStateResponse(soap, tag, id, (struct _tds__SetRelayOutputStateResponse *const*)ptr, "tds:SetRelayOutputStateResponse");
	case SOAP_TYPE_PointerTo_tds__SetRelayOutputState:
		return soap_out_PointerTo_tds__SetRelayOutputState(soap, tag, id, (struct _tds__SetRelayOutputState *const*)ptr, "tds:SetRelayOutputState");
	case SOAP_TYPE_PointerTo_tds__SetRelayOutputSettingsResponse:
		return soap_out_PointerTo_tds__SetRelayOutputSettingsResponse(soap, tag, id, (struct _tds__SetRelayOutputSettingsResponse *const*)ptr, "tds:SetRelayOutputSettingsResponse");
	case SOAP_TYPE_PointerTo_tds__SetRelayOutputSettings:
		return soap_out_PointerTo_tds__SetRelayOutputSettings(soap, tag, id, (struct _tds__SetRelayOutputSettings *const*)ptr, "tds:SetRelayOutputSettings");
	case SOAP_TYPE_PointerTo_tds__GetRelayOutputsResponse:
		return soap_out_PointerTo_tds__GetRelayOutputsResponse(soap, tag, id, (struct _tds__GetRelayOutputsResponse *const*)ptr, "tds:GetRelayOutputsResponse");
	case SOAP_TYPE_PointerTo_tds__GetRelayOutputs:
		return soap_out_PointerTo_tds__GetRelayOutputs(soap, tag, id, (struct _tds__GetRelayOutputs *const*)ptr, "tds:GetRelayOutputs");
	case SOAP_TYPE_PointerTo_tds__SetZeroConfigurationResponse:
		return soap_out_PointerTo_tds__SetZeroConfigurationResponse(soap, tag, id, (struct _tds__SetZeroConfigurationResponse *const*)ptr, "tds:SetZeroConfigurationResponse");
	case SOAP_TYPE_PointerTo_tds__SetZeroConfiguration:
		return soap_out_PointerTo_tds__SetZeroConfiguration(soap, tag, id, (struct _tds__SetZeroConfiguration *const*)ptr, "tds:SetZeroConfiguration");
	case SOAP_TYPE_PointerTo_tds__GetZeroConfigurationResponse:
		return soap_out_PointerTo_tds__GetZeroConfigurationResponse(soap, tag, id, (struct _tds__GetZeroConfigurationResponse *const*)ptr, "tds:GetZeroConfigurationResponse");
	case SOAP_TYPE_PointerTo_tds__GetZeroConfiguration:
		return soap_out_PointerTo_tds__GetZeroConfiguration(soap, tag, id, (struct _tds__GetZeroConfiguration *const*)ptr, "tds:GetZeroConfiguration");
	case SOAP_TYPE_PointerTo_tds__SetNetworkDefaultGatewayResponse:
		return soap_out_PointerTo_tds__SetNetworkDefaultGatewayResponse(soap, tag, id, (struct _tds__SetNetworkDefaultGatewayResponse *const*)ptr, "tds:SetNetworkDefaultGatewayResponse");
	case SOAP_TYPE_PointerTo_tds__SetNetworkDefaultGateway:
		return soap_out_PointerTo_tds__SetNetworkDefaultGateway(soap, tag, id, (struct _tds__SetNetworkDefaultGateway *const*)ptr, "tds:SetNetworkDefaultGateway");
	case SOAP_TYPE_PointerTo_tds__GetNetworkDefaultGatewayResponse:
		return soap_out_PointerTo_tds__GetNetworkDefaultGatewayResponse(soap, tag, id, (struct _tds__GetNetworkDefaultGatewayResponse *const*)ptr, "tds:GetNetworkDefaultGatewayResponse");
	case SOAP_TYPE_PointerTo_tds__GetNetworkDefaultGateway:
		return soap_out_PointerTo_tds__GetNetworkDefaultGateway(soap, tag, id, (struct _tds__GetNetworkDefaultGateway *const*)ptr, "tds:GetNetworkDefaultGateway");
	case SOAP_TYPE_PointerTo_tds__SetNetworkProtocolsResponse:
		return soap_out_PointerTo_tds__SetNetworkProtocolsResponse(soap, tag, id, (struct _tds__SetNetworkProtocolsResponse *const*)ptr, "tds:SetNetworkProtocolsResponse");
	case SOAP_TYPE_PointerTo_tds__SetNetworkProtocols:
		return soap_out_PointerTo_tds__SetNetworkProtocols(soap, tag, id, (struct _tds__SetNetworkProtocols *const*)ptr, "tds:SetNetworkProtocols");
	case SOAP_TYPE_PointerTo_tds__GetNetworkProtocolsResponse:
		return soap_out_PointerTo_tds__GetNetworkProtocolsResponse(soap, tag, id, (struct _tds__GetNetworkProtocolsResponse *const*)ptr, "tds:GetNetworkProtocolsResponse");
	case SOAP_TYPE_PointerTo_tds__GetNetworkProtocols:
		return soap_out_PointerTo_tds__GetNetworkProtocols(soap, tag, id, (struct _tds__GetNetworkProtocols *const*)ptr, "tds:GetNetworkProtocols");
	case SOAP_TYPE_PointerTo_tds__SetNetworkInterfacesResponse:
		return soap_out_PointerTo_tds__SetNetworkInterfacesResponse(soap, tag, id, (struct _tds__SetNetworkInterfacesResponse *const*)ptr, "tds:SetNetworkInterfacesResponse");
	case SOAP_TYPE_PointerTo_tds__SetNetworkInterfaces:
		return soap_out_PointerTo_tds__SetNetworkInterfaces(soap, tag, id, (struct _tds__SetNetworkInterfaces *const*)ptr, "tds:SetNetworkInterfaces");
	case SOAP_TYPE_PointerTo_tds__GetNetworkInterfacesResponse:
		return soap_out_PointerTo_tds__GetNetworkInterfacesResponse(soap, tag, id, (struct _tds__GetNetworkInterfacesResponse *const*)ptr, "tds:GetNetworkInterfacesResponse");
	case SOAP_TYPE_PointerTo_tds__GetNetworkInterfaces:
		return soap_out_PointerTo_tds__GetNetworkInterfaces(soap, tag, id, (struct _tds__GetNetworkInterfaces *const*)ptr, "tds:GetNetworkInterfaces");
	case SOAP_TYPE_PointerTo_tds__SetDynamicDNSResponse:
		return soap_out_PointerTo_tds__SetDynamicDNSResponse(soap, tag, id, (struct _tds__SetDynamicDNSResponse *const*)ptr, "tds:SetDynamicDNSResponse");
	case SOAP_TYPE_PointerTo_tds__SetDynamicDNS:
		return soap_out_PointerTo_tds__SetDynamicDNS(soap, tag, id, (struct _tds__SetDynamicDNS *const*)ptr, "tds:SetDynamicDNS");
	case SOAP_TYPE_PointerTo_tds__GetDynamicDNSResponse:
		return soap_out_PointerTo_tds__GetDynamicDNSResponse(soap, tag, id, (struct _tds__GetDynamicDNSResponse *const*)ptr, "tds:GetDynamicDNSResponse");
	case SOAP_TYPE_PointerTo_tds__GetDynamicDNS:
		return soap_out_PointerTo_tds__GetDynamicDNS(soap, tag, id, (struct _tds__GetDynamicDNS *const*)ptr, "tds:GetDynamicDNS");
	case SOAP_TYPE_PointerTo_tds__SetNTPResponse:
		return soap_out_PointerTo_tds__SetNTPResponse(soap, tag, id, (struct _tds__SetNTPResponse *const*)ptr, "tds:SetNTPResponse");
	case SOAP_TYPE_PointerTo_tds__SetNTP:
		return soap_out_PointerTo_tds__SetNTP(soap, tag, id, (struct _tds__SetNTP *const*)ptr, "tds:SetNTP");
	case SOAP_TYPE_PointerTo_tds__GetNTPResponse:
		return soap_out_PointerTo_tds__GetNTPResponse(soap, tag, id, (struct _tds__GetNTPResponse *const*)ptr, "tds:GetNTPResponse");
	case SOAP_TYPE_PointerTo_tds__GetNTP:
		return soap_out_PointerTo_tds__GetNTP(soap, tag, id, (struct _tds__GetNTP *const*)ptr, "tds:GetNTP");
	case SOAP_TYPE_PointerTo_tds__SetDNSResponse:
		return soap_out_PointerTo_tds__SetDNSResponse(soap, tag, id, (struct _tds__SetDNSResponse *const*)ptr, "tds:SetDNSResponse");
	case SOAP_TYPE_PointerTo_tds__SetDNS:
		return soap_out_PointerTo_tds__SetDNS(soap, tag, id, (struct _tds__SetDNS *const*)ptr, "tds:SetDNS");
	case SOAP_TYPE_PointerTo_tds__GetDNSResponse:
		return soap_out_PointerTo_tds__GetDNSResponse(soap, tag, id, (struct _tds__GetDNSResponse *const*)ptr, "tds:GetDNSResponse");
	case SOAP_TYPE_PointerTo_tds__GetDNS:
		return soap_out_PointerTo_tds__GetDNS(soap, tag, id, (struct _tds__GetDNS *const*)ptr, "tds:GetDNS");
	case SOAP_TYPE_PointerTo_tds__SetHostnameResponse:
		return soap_out_PointerTo_tds__SetHostnameResponse(soap, tag, id, (struct _tds__SetHostnameResponse *const*)ptr, "tds:SetHostnameResponse");
	case SOAP_TYPE_PointerTo_tds__SetHostname:
		return soap_out_PointerTo_tds__SetHostname(soap, tag, id, (struct _tds__SetHostname *const*)ptr, "tds:SetHostname");
	case SOAP_TYPE_PointerTo_tds__GetHostnameResponse:
		return soap_out_PointerTo_tds__GetHostnameResponse(soap, tag, id, (struct _tds__GetHostnameResponse *const*)ptr, "tds:GetHostnameResponse");
	case SOAP_TYPE_PointerTo_tds__GetHostname:
		return soap_out_PointerTo_tds__GetHostname(soap, tag, id, (struct _tds__GetHostname *const*)ptr, "tds:GetHostname");
	case SOAP_TYPE_PointerTo_tds__GetCapabilitiesResponse:
		return soap_out_PointerTo_tds__GetCapabilitiesResponse(soap, tag, id, (struct _tds__GetCapabilitiesResponse *const*)ptr, "tds:GetCapabilitiesResponse");
	case SOAP_TYPE_PointerTo_tds__GetCapabilities:
		return soap_out_PointerTo_tds__GetCapabilities(soap, tag, id, (struct _tds__GetCapabilities *const*)ptr, "tds:GetCapabilities");
	case SOAP_TYPE_PointerTo_tds__GetWsdlUrlResponse:
		return soap_out_PointerTo_tds__GetWsdlUrlResponse(soap, tag, id, (struct _tds__GetWsdlUrlResponse *const*)ptr, "tds:GetWsdlUrlResponse");
	case SOAP_TYPE_PointerTo_tds__GetWsdlUrl:
		return soap_out_PointerTo_tds__GetWsdlUrl(soap, tag, id, (struct _tds__GetWsdlUrl *const*)ptr, "tds:GetWsdlUrl");
	case SOAP_TYPE_PointerTo_tds__SetUserResponse:
		return soap_out_PointerTo_tds__SetUserResponse(soap, tag, id, (struct _tds__SetUserResponse *const*)ptr, "tds:SetUserResponse");
	case SOAP_TYPE_PointerTo_tds__SetUser:
		return soap_out_PointerTo_tds__SetUser(soap, tag, id, (struct _tds__SetUser *const*)ptr, "tds:SetUser");
	case SOAP_TYPE_PointerTo_tds__DeleteUsersResponse:
		return soap_out_PointerTo_tds__DeleteUsersResponse(soap, tag, id, (struct _tds__DeleteUsersResponse *const*)ptr, "tds:DeleteUsersResponse");
	case SOAP_TYPE_PointerTo_tds__DeleteUsers:
		return soap_out_PointerTo_tds__DeleteUsers(soap, tag, id, (struct _tds__DeleteUsers *const*)ptr, "tds:DeleteUsers");
	case SOAP_TYPE_PointerTo_tds__CreateUsersResponse:
		return soap_out_PointerTo_tds__CreateUsersResponse(soap, tag, id, (struct _tds__CreateUsersResponse *const*)ptr, "tds:CreateUsersResponse");
	case SOAP_TYPE_PointerTo_tds__CreateUsers:
		return soap_out_PointerTo_tds__CreateUsers(soap, tag, id, (struct _tds__CreateUsers *const*)ptr, "tds:CreateUsers");
	case SOAP_TYPE_PointerTo_tds__GetUsersResponse:
		return soap_out_PointerTo_tds__GetUsersResponse(soap, tag, id, (struct _tds__GetUsersResponse *const*)ptr, "tds:GetUsersResponse");
	case SOAP_TYPE_PointerTo_tds__GetUsers:
		return soap_out_PointerTo_tds__GetUsers(soap, tag, id, (struct _tds__GetUsers *const*)ptr, "tds:GetUsers");
	case SOAP_TYPE_PointerTo_tds__SetDiscoveryModeResponse:
		return soap_out_PointerTo_tds__SetDiscoveryModeResponse(soap, tag, id, (struct _tds__SetDiscoveryModeResponse *const*)ptr, "tds:SetDiscoveryModeResponse");
	case SOAP_TYPE_PointerTo_tds__SetDiscoveryMode:
		return soap_out_PointerTo_tds__SetDiscoveryMode(soap, tag, id, (struct _tds__SetDiscoveryMode *const*)ptr, "tds:SetDiscoveryMode");
	case SOAP_TYPE_PointerTo_tds__GetDiscoveryModeResponse:
		return soap_out_PointerTo_tds__GetDiscoveryModeResponse(soap, tag, id, (struct _tds__GetDiscoveryModeResponse *const*)ptr, "tds:GetDiscoveryModeResponse");
	case SOAP_TYPE_PointerTo_tds__GetDiscoveryMode:
		return soap_out_PointerTo_tds__GetDiscoveryMode(soap, tag, id, (struct _tds__GetDiscoveryMode *const*)ptr, "tds:GetDiscoveryMode");
	case SOAP_TYPE_PointerTo_tds__RemoveScopesResponse:
		return soap_out_PointerTo_tds__RemoveScopesResponse(soap, tag, id, (struct _tds__RemoveScopesResponse *const*)ptr, "tds:RemoveScopesResponse");
	case SOAP_TYPE_PointerTo_tds__RemoveScopes:
		return soap_out_PointerTo_tds__RemoveScopes(soap, tag, id, (struct _tds__RemoveScopes *const*)ptr, "tds:RemoveScopes");
	case SOAP_TYPE_PointerTo_tds__AddScopesResponse:
		return soap_out_PointerTo_tds__AddScopesResponse(soap, tag, id, (struct _tds__AddScopesResponse *const*)ptr, "tds:AddScopesResponse");
	case SOAP_TYPE_PointerTo_tds__AddScopes:
		return soap_out_PointerTo_tds__AddScopes(soap, tag, id, (struct _tds__AddScopes *const*)ptr, "tds:AddScopes");
	case SOAP_TYPE_PointerTo_tds__SetScopesResponse:
		return soap_out_PointerTo_tds__SetScopesResponse(soap, tag, id, (struct _tds__SetScopesResponse *const*)ptr, "tds:SetScopesResponse");
	case SOAP_TYPE_PointerTo_tds__SetScopes:
		return soap_out_PointerTo_tds__SetScopes(soap, tag, id, (struct _tds__SetScopes *const*)ptr, "tds:SetScopes");
	case SOAP_TYPE_PointerTo_tds__GetScopesResponse:
		return soap_out_PointerTo_tds__GetScopesResponse(soap, tag, id, (struct _tds__GetScopesResponse *const*)ptr, "tds:GetScopesResponse");
	case SOAP_TYPE_PointerTo_tds__GetScopes:
		return soap_out_PointerTo_tds__GetScopes(soap, tag, id, (struct _tds__GetScopes *const*)ptr, "tds:GetScopes");
	case SOAP_TYPE_PointerTo_tds__GetSystemLogResponse:
		return soap_out_PointerTo_tds__GetSystemLogResponse(soap, tag, id, (struct _tds__GetSystemLogResponse *const*)ptr, "tds:GetSystemLogResponse");
	case SOAP_TYPE_PointerTo_tds__GetSystemLog:
		return soap_out_PointerTo_tds__GetSystemLog(soap, tag, id, (struct _tds__GetSystemLog *const*)ptr, "tds:GetSystemLog");
	case SOAP_TYPE_PointerTo_tds__SystemRebootResponse:
		return soap_out_PointerTo_tds__SystemRebootResponse(soap, tag, id, (struct _tds__SystemRebootResponse *const*)ptr, "tds:SystemRebootResponse");
	case SOAP_TYPE_PointerTo_tds__SystemReboot:
		return soap_out_PointerTo_tds__SystemReboot(soap, tag, id, (struct _tds__SystemReboot *const*)ptr, "tds:SystemReboot");
	case SOAP_TYPE_PointerTo_tds__SetSystemFactoryDefaultResponse:
		return soap_out_PointerTo_tds__SetSystemFactoryDefaultResponse(soap, tag, id, (struct _tds__SetSystemFactoryDefaultResponse *const*)ptr, "tds:SetSystemFactoryDefaultResponse");
	case SOAP_TYPE_PointerTo_tds__SetSystemFactoryDefault:
		return soap_out_PointerTo_tds__SetSystemFactoryDefault(soap, tag, id, (struct _tds__SetSystemFactoryDefault *const*)ptr, "tds:SetSystemFactoryDefault");
	case SOAP_TYPE_PointerTo_tds__GetSystemDateAndTimeResponse:
		return soap_out_PointerTo_tds__GetSystemDateAndTimeResponse(soap, tag, id, (struct _tds__GetSystemDateAndTimeResponse *const*)ptr, "tds:GetSystemDateAndTimeResponse");
	case SOAP_TYPE_PointerTo_tds__GetSystemDateAndTime:
		return soap_out_PointerTo_tds__GetSystemDateAndTime(soap, tag, id, (struct _tds__GetSystemDateAndTime *const*)ptr, "tds:GetSystemDateAndTime");
	case SOAP_TYPE_PointerTo_tds__SetSystemDateAndTimeResponse:
		return soap_out_PointerTo_tds__SetSystemDateAndTimeResponse(soap, tag, id, (struct _tds__SetSystemDateAndTimeResponse *const*)ptr, "tds:SetSystemDateAndTimeResponse");
	case SOAP_TYPE_PointerTo_tds__SetSystemDateAndTime:
		return soap_out_PointerTo_tds__SetSystemDateAndTime(soap, tag, id, (struct _tds__SetSystemDateAndTime *const*)ptr, "tds:SetSystemDateAndTime");
	case SOAP_TYPE_PointerTo_tds__GetDeviceInformationResponse:
		return soap_out_PointerTo_tds__GetDeviceInformationResponse(soap, tag, id, (struct _tds__GetDeviceInformationResponse *const*)ptr, "tds:GetDeviceInformationResponse");
	case SOAP_TYPE_PointerTo_tds__GetDeviceInformation:
		return soap_out_PointerTo_tds__GetDeviceInformation(soap, tag, id, (struct _tds__GetDeviceInformation *const*)ptr, "tds:GetDeviceInformation");
	case SOAP_TYPE_PointerTo_wsnt__Notify:
		return soap_out_PointerTo_wsnt__Notify(soap, tag, id, (struct _wsnt__Notify *const*)ptr, "wsnt:Notify");
	case SOAP_TYPE_PointerTo_wsnt__SubscribeResponse:
		return soap_out_PointerTo_wsnt__SubscribeResponse(soap, tag, id, (struct _wsnt__SubscribeResponse *const*)ptr, "wsnt:SubscribeResponse");
	case SOAP_TYPE_PointerTo_wsnt__Subscribe:
		return soap_out_PointerTo_wsnt__Subscribe(soap, tag, id, (struct _wsnt__Subscribe *const*)ptr, "wsnt:Subscribe");
	case SOAP_TYPE_PointerTo_wsnt__UnsubscribeResponse:
		return soap_out_PointerTo_wsnt__UnsubscribeResponse(soap, tag, id, (struct _wsnt__UnsubscribeResponse *const*)ptr, "wsnt:UnsubscribeResponse");
	case SOAP_TYPE_PointerTo_wsnt__Unsubscribe:
		return soap_out_PointerTo_wsnt__Unsubscribe(soap, tag, id, (struct _wsnt__Unsubscribe *const*)ptr, "wsnt:Unsubscribe");
	case SOAP_TYPE_PointerTo_wsnt__RenewResponse:
		return soap_out_PointerTo_wsnt__RenewResponse(soap, tag, id, (struct _wsnt__RenewResponse *const*)ptr, "wsnt:RenewResponse");
	case SOAP_TYPE_PointerTo_wsnt__Renew:
		return soap_out_PointerTo_wsnt__Renew(soap, tag, id, (struct _wsnt__Renew *const*)ptr, "wsnt:Renew");
	case SOAP_TYPE_PointerTo_tev__GetEventPropertiesResponse:
		return soap_out_PointerTo_tev__GetEventPropertiesResponse(soap, tag, id, (struct _tev__GetEventPropertiesResponse *const*)ptr, "tev:GetEventPropertiesResponse");
	case SOAP_TYPE_PointerTo_tev__GetEventProperties:
		return soap_out_PointerTo_tev__GetEventProperties(soap, tag, id, (struct _tev__GetEventProperties *const*)ptr, "tev:GetEventProperties");
	case SOAP_TYPE_PointerTo_tev__CreatePullPointSubscriptionResponse:
		return soap_out_PointerTo_tev__CreatePullPointSubscriptionResponse(soap, tag, id, (struct _tev__CreatePullPointSubscriptionResponse *const*)ptr, "tev:CreatePullPointSubscriptionResponse");
	case SOAP_TYPE_PointerTo_tev__CreatePullPointSubscription:
		return soap_out_PointerTo_tev__CreatePullPointSubscription(soap, tag, id, (struct _tev__CreatePullPointSubscription *const*)ptr, "tev:CreatePullPointSubscription");
	case SOAP_TYPE_PointerTo_tev__SetSynchronizationPointResponse:
		return soap_out_PointerTo_tev__SetSynchronizationPointResponse(soap, tag, id, (struct _tev__SetSynchronizationPointResponse *const*)ptr, "tev:SetSynchronizationPointResponse");
	case SOAP_TYPE_PointerTo_tev__SetSynchronizationPoint:
		return soap_out_PointerTo_tev__SetSynchronizationPoint(soap, tag, id, (struct _tev__SetSynchronizationPoint *const*)ptr, "tev:SetSynchronizationPoint");
	case SOAP_TYPE_PointerTo_tev__PullMessagesResponse:
		return soap_out_PointerTo_tev__PullMessagesResponse(soap, tag, id, (struct _tev__PullMessagesResponse *const*)ptr, "tev:PullMessagesResponse");
	case SOAP_TYPE_PointerTo_tev__PullMessages:
		return soap_out_PointerTo_tev__PullMessages(soap, tag, id, (struct _tev__PullMessages *const*)ptr, "tev:PullMessages");
	case SOAP_TYPE_PointerTod__ProbeMatchesType:
		return soap_out_PointerTod__ProbeMatchesType(soap, tag, id, (struct d__ProbeMatchesType *const*)ptr, "d:ProbeMatchesType");
	case SOAP_TYPE_PointerTod__ProbeType:
		return soap_out_PointerTod__ProbeType(soap, tag, id, (struct d__ProbeType *const*)ptr, "d:ProbeType");
	case SOAP_TYPE_PointerTod__ByeType:
		return soap_out_PointerTod__ByeType(soap, tag, id, (struct d__ByeType *const*)ptr, "d:ByeType");
	case SOAP_TYPE_PointerTod__ResolveType:
		return soap_out_PointerTod__ResolveType(soap, tag, id, (struct d__ResolveType *const*)ptr, "d:ResolveType");
	case SOAP_TYPE_PointerTod__HelloType:
		return soap_out_PointerTod__HelloType(soap, tag, id, (struct d__HelloType *const*)ptr, "d:HelloType");
	case SOAP_TYPE_PointerTo_tev__PullMessagesFaultResponse:
		return soap_out_PointerTo_tev__PullMessagesFaultResponse(soap, tag, id, (struct _tev__PullMessagesFaultResponse *const*)ptr, "tev:PullMessagesFaultResponse");
	case SOAP_TYPE__wsu__Created:
		return soap_out_string(soap, "wsu:Created", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__wsu__Id:
		return soap_out_string(soap, "wsu:Id", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__d__XAddrs:
		return soap_out_string(soap, "d:XAddrs", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__d__Types:
		return soap_out_string(soap, "d:Types", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__wsaw__Action:
		return soap_out_string(soap, "wsaw:Action", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__wsnt__TopicExpressionDialect:
		return soap_out_string(soap, "wsnt:TopicExpressionDialect", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE_PointerTott__ZoomLimits:
		return soap_out_PointerTott__ZoomLimits(soap, tag, id, (struct tt__ZoomLimits *const*)ptr, "tt:ZoomLimits");
	case SOAP_TYPE_PointerTott__PanTiltLimits:
		return soap_out_PointerTott__PanTiltLimits(soap, tag, id, (struct tt__PanTiltLimits *const*)ptr, "tt:PanTiltLimits");
	case SOAP_TYPE_PointerTott__NetworkInterfaceExtension:
		return soap_out_PointerTott__NetworkInterfaceExtension(soap, tag, id, (struct tt__NetworkInterfaceExtension *const*)ptr, "tt:NetworkInterfaceExtension");
	case SOAP_TYPE_PointerTott__IPv4NetworkInterface:
		return soap_out_PointerTott__IPv4NetworkInterface(soap, tag, id, (struct tt__IPv4NetworkInterface *const*)ptr, "tt:IPv4NetworkInterface");
	case SOAP_TYPE_PointerTott__NetworkInterfaceLink:
		return soap_out_PointerTott__NetworkInterfaceLink(soap, tag, id, (struct tt__NetworkInterfaceLink *const*)ptr, "tt:NetworkInterfaceLink");
	case SOAP_TYPE_PointerTott__NetworkInterfaceInfo:
		return soap_out_PointerTott__NetworkInterfaceInfo(soap, tag, id, (struct tt__NetworkInterfaceInfo *const*)ptr, "tt:NetworkInterfaceInfo");
	case SOAP_TYPE_PointerTott__EventSubscription:
		return soap_out_PointerTott__EventSubscription(soap, tag, id, (struct tt__EventSubscription *const*)ptr, "tt:EventSubscription");
	case SOAP_TYPE_PointerTott__MulticastConfiguration:
		return soap_out_PointerTott__MulticastConfiguration(soap, tag, id, (struct tt__MulticastConfiguration *const*)ptr, "tt:MulticastConfiguration");
	case SOAP_TYPE_PointerTott__H264Configuration:
		return soap_out_PointerTott__H264Configuration(soap, tag, id, (struct tt__H264Configuration *const*)ptr, "tt:H264Configuration");
	case SOAP_TYPE_PointerTott__Mpeg4Configuration:
		return soap_out_PointerTott__Mpeg4Configuration(soap, tag, id, (struct tt__Mpeg4Configuration *const*)ptr, "tt:Mpeg4Configuration");
	case SOAP_TYPE_PointerTott__VideoRateControl:
		return soap_out_PointerTott__VideoRateControl(soap, tag, id, (struct tt__VideoRateControl *const*)ptr, "tt:VideoRateControl");
	case SOAP_TYPE_PointerTott__IntRectangle:
		return soap_out_PointerTott__IntRectangle(soap, tag, id, (struct tt__IntRectangle *const*)ptr, "tt:IntRectangle");
	case SOAP_TYPE_PointerTott__ImagingSettings:
		return soap_out_PointerTott__ImagingSettings(soap, tag, id, (struct tt__ImagingSettings *const*)ptr, "tt:ImagingSettings");
	case SOAP_TYPE_PointerTo_wsbf__ResourceUnknownFaultType_FaultCause:
		return soap_out_PointerTo_wsbf__ResourceUnknownFaultType_FaultCause(soap, tag, id, (struct _wsbf__ResourceUnknownFaultType_FaultCause *const*)ptr, "wsbf:ResourceUnknownFaultType-FaultCause");
	case SOAP_TYPE_PointerTo_wsbf__ResourceUnknownFaultType_Description:
		return soap_out_PointerTo_wsbf__ResourceUnknownFaultType_Description(soap, tag, id, (struct _wsbf__ResourceUnknownFaultType_Description *const*)ptr, "wsbf:ResourceUnknownFaultType-Description");
	case SOAP_TYPE_PointerTo_wsbf__ResourceUnknownFaultType_ErrorCode:
		return soap_out_PointerTo_wsbf__ResourceUnknownFaultType_ErrorCode(soap, tag, id, (struct _wsbf__ResourceUnknownFaultType_ErrorCode *const*)ptr, "wsbf:ResourceUnknownFaultType-ErrorCode");
	case SOAP_TYPE_PointerTotns1__Device:
		return soap_out_PointerTotns1__Device(soap, tag, id, (struct tns1__Device *const*)ptr, "tns1:Device");
	case SOAP_TYPE_PointerTotns1__VideoAnalytics:
		return soap_out_PointerTotns1__VideoAnalytics(soap, tag, id, (struct tns1__VideoAnalytics *const*)ptr, "tns1:VideoAnalytics");
	case SOAP_TYPE_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_FaultCause:
		return soap_out_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_FaultCause(soap, tag, id, (struct _wsbf__UnableToDestroySubscriptionFaultType_FaultCause *const*)ptr, "wsbf:UnableToDestroySubscriptionFaultType-FaultCause");
	case SOAP_TYPE_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_Description:
		return soap_out_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_Description(soap, tag, id, (struct _wsbf__UnableToDestroySubscriptionFaultType_Description *const*)ptr, "wsbf:UnableToDestroySubscriptionFaultType-Description");
	case SOAP_TYPE_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_ErrorCode:
		return soap_out_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_ErrorCode(soap, tag, id, (struct _wsbf__UnableToDestroySubscriptionFaultType_ErrorCode *const*)ptr, "wsbf:UnableToDestroySubscriptionFaultType-ErrorCode");
	case SOAP_TYPE_PointerTowsse__UsernameTokenType:
		return soap_out_PointerTowsse__UsernameTokenType(soap, tag, id, (struct wsse__UsernameTokenType *const*)ptr, "wsse:UsernameTokenType");
	case SOAP_TYPE_PointerTowsu__TimestampType:
		return soap_out_PointerTowsu__TimestampType(soap, tag, id, (struct wsu__TimestampType *const*)ptr, "wsu:TimestampType");
	case SOAP_TYPE_PointerTowsse__PasswordString:
		return soap_out_PointerTowsse__PasswordString(soap, tag, id, (struct wsse__PasswordString *const*)ptr, "wsse:PasswordString");
	case SOAP_TYPE_PointerTowsadis__EndpointReferenceType:
		return soap_out_PointerTowsadis__EndpointReferenceType(soap, tag, id, (struct wsadis__EndpointReferenceType *const*)ptr, "wsadis:EndpointReferenceType");
	case SOAP_TYPE_PointerTod__ProbeMatchType:
		return soap_out_PointerTod__ProbeMatchType(soap, tag, id, (struct d__ProbeMatchType *const*)ptr, "d:ProbeMatchType");
	case SOAP_TYPE_PointerTounsignedInt:
		return soap_out_PointerTounsignedInt(soap, tag, id, (unsigned int *const*)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_PointerTod__ScopesType:
		return soap_out_PointerTod__ScopesType(soap, tag, id, (struct d__ScopesType *const*)ptr, "d:ScopesType");
	case SOAP_TYPE_PointerTott__PTZStatus:
		return soap_out_PointerTott__PTZStatus(soap, tag, id, (struct tt__PTZStatus *const*)ptr, "tt:PTZStatus");
	case SOAP_TYPE_PointerTott__PTZPreset:
		return soap_out_PointerTott__PTZPreset(soap, tag, id, (struct tt__PTZPreset *const*)ptr, "tt:PTZPreset");
	case SOAP_TYPE_PointerTott__PTZSpeed:
		return soap_out_PointerTott__PTZSpeed(soap, tag, id, (struct tt__PTZSpeed *const*)ptr, "tt:PTZSpeed");
	case SOAP_TYPE_PointerTott__Preset:
		return soap_out_PointerTott__Preset(soap, tag, id, (struct tt__Preset *const*)ptr, "tt:Preset");
	case SOAP_TYPE_PointerTott__PTZConfigurationOptions:
		return soap_out_PointerTott__PTZConfigurationOptions(soap, tag, id, (struct tt__PTZConfigurationOptions *const*)ptr, "tt:PTZConfigurationOptions");
	case SOAP_TYPE_PointerTott__PTZNode:
		return soap_out_PointerTott__PTZNode(soap, tag, id, (struct tt__PTZNode *const*)ptr, "tt:PTZNode");
	case SOAP_TYPE_PointerTott__MediaUri:
		return soap_out_PointerTott__MediaUri(soap, tag, id, (struct tt__MediaUri *const*)ptr, "tt:MediaUri");
	case SOAP_TYPE_PointerTott__StreamSetup:
		return soap_out_PointerTott__StreamSetup(soap, tag, id, (struct tt__StreamSetup *const*)ptr, "tt:StreamSetup");
	case SOAP_TYPE_PointerTott__MetadataConfigurationOptions:
		return soap_out_PointerTott__MetadataConfigurationOptions(soap, tag, id, (struct tt__MetadataConfigurationOptions *const*)ptr, "tt:MetadataConfigurationOptions");
	case SOAP_TYPE_PointerTott__AudioEncoderConfigurationOptions:
		return soap_out_PointerTott__AudioEncoderConfigurationOptions(soap, tag, id, (struct tt__AudioEncoderConfigurationOptions *const*)ptr, "tt:AudioEncoderConfigurationOptions");
	case SOAP_TYPE_PointerTott__AudioSourceConfigurationOptions:
		return soap_out_PointerTott__AudioSourceConfigurationOptions(soap, tag, id, (struct tt__AudioSourceConfigurationOptions *const*)ptr, "tt:AudioSourceConfigurationOptions");
	case SOAP_TYPE_PointerTott__VideoEncoderConfigurationOptions:
		return soap_out_PointerTott__VideoEncoderConfigurationOptions(soap, tag, id, (struct tt__VideoEncoderConfigurationOptions *const*)ptr, "tt:VideoEncoderConfigurationOptions");
	case SOAP_TYPE_PointerTott__VideoSourceConfigurationOptions:
		return soap_out_PointerTott__VideoSourceConfigurationOptions(soap, tag, id, (struct tt__VideoSourceConfigurationOptions *const*)ptr, "tt:VideoSourceConfigurationOptions");
	case SOAP_TYPE_PointerTott__Profile:
		return soap_out_PointerTott__Profile(soap, tag, id, (struct tt__Profile *const*)ptr, "tt:Profile");
	case SOAP_TYPE_PointerTott__AudioSource:
		return soap_out_PointerTott__AudioSource(soap, tag, id, (struct tt__AudioSource *const*)ptr, "tt:AudioSource");
	case SOAP_TYPE_PointerTott__VideoSource:
		return soap_out_PointerTott__VideoSource(soap, tag, id, (struct tt__VideoSource *const*)ptr, "tt:VideoSource");
	case SOAP_TYPE_PointerTotrt__Capabilities:
		return soap_out_PointerTotrt__Capabilities(soap, tag, id, (struct trt__Capabilities *const*)ptr, "trt:Capabilities");
	case SOAP_TYPE_PointerTotrt__StreamingCapabilities:
		return soap_out_PointerTotrt__StreamingCapabilities(soap, tag, id, (struct trt__StreamingCapabilities *const*)ptr, "trt:StreamingCapabilities");
	case SOAP_TYPE_PointerTotrt__ProfileCapabilities:
		return soap_out_PointerTotrt__ProfileCapabilities(soap, tag, id, (struct trt__ProfileCapabilities *const*)ptr, "trt:ProfileCapabilities");
	case SOAP_TYPE_PointerTowstop__TopicSetType:
		return soap_out_PointerTowstop__TopicSetType(soap, tag, id, (struct wstop__TopicSetType *const*)ptr, "wstop:TopicSetType");
	case SOAP_TYPE_PointerTott__RelayOutputSettings:
		return soap_out_PointerTott__RelayOutputSettings(soap, tag, id, (struct tt__RelayOutputSettings *const*)ptr, "tt:RelayOutputSettings");
	case SOAP_TYPE_PointerTott__RelayOutput:
		return soap_out_PointerTott__RelayOutput(soap, tag, id, (struct tt__RelayOutput *const*)ptr, "tt:RelayOutput");
	case SOAP_TYPE_PointerTott__NetworkZeroConfiguration:
		return soap_out_PointerTott__NetworkZeroConfiguration(soap, tag, id, (struct tt__NetworkZeroConfiguration *const*)ptr, "tt:NetworkZeroConfiguration");
	case SOAP_TYPE_PointerTott__NetworkGateway:
		return soap_out_PointerTott__NetworkGateway(soap, tag, id, (struct tt__NetworkGateway *const*)ptr, "tt:NetworkGateway");
	case SOAP_TYPE_PointerTott__NetworkProtocol:
		return soap_out_PointerTott__NetworkProtocol(soap, tag, id, (struct tt__NetworkProtocol *const*)ptr, "tt:NetworkProtocol");
	case SOAP_TYPE_PointerTott__NetworkInterfaceSetConfiguration:
		return soap_out_PointerTott__NetworkInterfaceSetConfiguration(soap, tag, id, (struct tt__NetworkInterfaceSetConfiguration *const*)ptr, "tt:NetworkInterfaceSetConfiguration");
	case SOAP_TYPE_PointerTott__NetworkInterface:
		return soap_out_PointerTott__NetworkInterface(soap, tag, id, (struct tt__NetworkInterface *const*)ptr, "tt:NetworkInterface");
	case SOAP_TYPE_PointerTott__DynamicDNSInformation:
		return soap_out_PointerTott__DynamicDNSInformation(soap, tag, id, (struct tt__DynamicDNSInformation *const*)ptr, "tt:DynamicDNSInformation");
	case SOAP_TYPE_PointerTott__NTPInformation:
		return soap_out_PointerTott__NTPInformation(soap, tag, id, (struct tt__NTPInformation *const*)ptr, "tt:NTPInformation");
	case SOAP_TYPE_PointerTott__DNSInformation:
		return soap_out_PointerTott__DNSInformation(soap, tag, id, (struct tt__DNSInformation *const*)ptr, "tt:DNSInformation");
	case SOAP_TYPE_PointerTott__HostnameInformation:
		return soap_out_PointerTott__HostnameInformation(soap, tag, id, (struct tt__HostnameInformation *const*)ptr, "tt:HostnameInformation");
	case SOAP_TYPE_PointerTott__Capabilities:
		return soap_out_PointerTott__Capabilities(soap, tag, id, (struct tt__Capabilities *const*)ptr, "tt:Capabilities");
	case SOAP_TYPE_PointerTott__CapabilityCategory:
		return soap_out_PointerTott__CapabilityCategory(soap, tag, id, (enum tt__CapabilityCategory *const*)ptr, "tt:CapabilityCategory");
	case SOAP_TYPE_PointerTostring:
		return soap_out_PointerTostring(soap, tag, id, (char **const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerTott__User:
		return soap_out_PointerTott__User(soap, tag, id, (struct tt__User *const*)ptr, "tt:User");
	case SOAP_TYPE_PointerToxsd__anyURI:
		return soap_out_PointerToxsd__anyURI(soap, tag, id, (char **const*)ptr, "xsd:anyURI");
	case SOAP_TYPE_PointerTott__Scope:
		return soap_out_PointerTott__Scope(soap, tag, id, (struct tt__Scope *const*)ptr, "tt:Scope");
	case SOAP_TYPE_PointerTott__SystemLog:
		return soap_out_PointerTott__SystemLog(soap, tag, id, (struct tt__SystemLog *const*)ptr, "tt:SystemLog");
	case SOAP_TYPE_PointerTott__SystemDateTime:
		return soap_out_PointerTott__SystemDateTime(soap, tag, id, (struct tt__SystemDateTime *const*)ptr, "tt:SystemDateTime");
	case SOAP_TYPE_PointerTotnsacti__VirtualPort:
		return soap_out_PointerTotnsacti__VirtualPort(soap, tag, id, (struct tnsacti__VirtualPort *const*)ptr, "tnsacti:VirtualPort");
	case SOAP_TYPE_PointerTott__MessageDescription:
		return soap_out_PointerTott__MessageDescription(soap, tag, id, (struct tt__MessageDescription *const*)ptr, "tt:MessageDescription");
	case SOAP_TYPE_PointerTotnsacti__IO:
		return soap_out_PointerTotnsacti__IO(soap, tag, id, (struct tnsacti__IO *const*)ptr, "tnsacti:IO");
	case SOAP_TYPE_PointerTotnsacti__MotionDetection:
		return soap_out_PointerTotnsacti__MotionDetection(soap, tag, id, (struct tnsacti__MotionDetection *const*)ptr, "tnsacti:MotionDetection");
	case SOAP_TYPE_PointerTott__ItemList:
		return soap_out_PointerTott__ItemList(soap, tag, id, (struct tt__ItemList *const*)ptr, "tt:ItemList");
	case SOAP_TYPE_PointerTo_tt__ItemListDescription_SimpleItemDescription:
		return soap_out_PointerTo_tt__ItemListDescription_SimpleItemDescription(soap, tag, id, (struct _tt__ItemListDescription_SimpleItemDescription *const*)ptr, "tt:ItemListDescription-SimpleItemDescription");
	case SOAP_TYPE_PointerTott__ItemListDescription:
		return soap_out_PointerTott__ItemListDescription(soap, tag, id, (struct tt__ItemListDescription *const*)ptr, "tt:ItemListDescription");
	case SOAP_TYPE_PointerTo_tt__ItemList_SimpleItem:
		return soap_out_PointerTo_tt__ItemList_SimpleItem(soap, tag, id, (struct _tt__ItemList_SimpleItem *const*)ptr, "tt:ItemList-SimpleItem");
	case SOAP_TYPE_PointerTott__WhiteBalanceMode:
		return soap_out_PointerTott__WhiteBalanceMode(soap, tag, id, (enum tt__WhiteBalanceMode *const*)ptr, "tt:WhiteBalanceMode");
	case SOAP_TYPE_PointerTott__ExposurePriority:
		return soap_out_PointerTott__ExposurePriority(soap, tag, id, (enum tt__ExposurePriority *const*)ptr, "tt:ExposurePriority");
	case SOAP_TYPE_PointerTott__ExposureMode:
		return soap_out_PointerTott__ExposureMode(soap, tag, id, (enum tt__ExposureMode *const*)ptr, "tt:ExposureMode");
	case SOAP_TYPE_PointerTott__AutoFocusMode:
		return soap_out_PointerTott__AutoFocusMode(soap, tag, id, (enum tt__AutoFocusMode *const*)ptr, "tt:AutoFocusMode");
	case SOAP_TYPE_PointerTott__WideDynamicMode:
		return soap_out_PointerTott__WideDynamicMode(soap, tag, id, (enum tt__WideDynamicMode *const*)ptr, "tt:WideDynamicMode");
	case SOAP_TYPE_PointerTott__WhiteBalanceOptions:
		return soap_out_PointerTott__WhiteBalanceOptions(soap, tag, id, (struct tt__WhiteBalanceOptions *const*)ptr, "tt:WhiteBalanceOptions");
	case SOAP_TYPE_PointerTott__WideDynamicRangeOptions:
		return soap_out_PointerTott__WideDynamicRangeOptions(soap, tag, id, (struct tt__WideDynamicRangeOptions *const*)ptr, "tt:WideDynamicRangeOptions");
	case SOAP_TYPE_PointerTott__FocusOptions:
		return soap_out_PointerTott__FocusOptions(soap, tag, id, (struct tt__FocusOptions *const*)ptr, "tt:FocusOptions");
	case SOAP_TYPE_PointerTott__ExposureOptions:
		return soap_out_PointerTott__ExposureOptions(soap, tag, id, (struct tt__ExposureOptions *const*)ptr, "tt:ExposureOptions");
	case SOAP_TYPE_PointerTott__BacklightCompensationOptions:
		return soap_out_PointerTott__BacklightCompensationOptions(soap, tag, id, (struct tt__BacklightCompensationOptions *const*)ptr, "tt:BacklightCompensationOptions");
	case SOAP_TYPE_PointerTott__Rectangle:
		return soap_out_PointerTott__Rectangle(soap, tag, id, (struct tt__Rectangle *const*)ptr, "tt:Rectangle");
	case SOAP_TYPE_PointerTott__WhiteBalance:
		return soap_out_PointerTott__WhiteBalance(soap, tag, id, (struct tt__WhiteBalance *const*)ptr, "tt:WhiteBalance");
	case SOAP_TYPE_PointerTott__WideDynamicRange:
		return soap_out_PointerTott__WideDynamicRange(soap, tag, id, (struct tt__WideDynamicRange *const*)ptr, "tt:WideDynamicRange");
	case SOAP_TYPE_PointerTott__IrCutFilterMode:
		return soap_out_PointerTott__IrCutFilterMode(soap, tag, id, (enum tt__IrCutFilterMode *const*)ptr, "tt:IrCutFilterMode");
	case SOAP_TYPE_PointerTott__FocusConfiguration:
		return soap_out_PointerTott__FocusConfiguration(soap, tag, id, (struct tt__FocusConfiguration *const*)ptr, "tt:FocusConfiguration");
	case SOAP_TYPE_PointerTott__Exposure:
		return soap_out_PointerTott__Exposure(soap, tag, id, (struct tt__Exposure *const*)ptr, "tt:Exposure");
	case SOAP_TYPE_PointerTofloat:
		return soap_out_PointerTofloat(soap, tag, id, (float *const*)ptr, "xsd:float");
	case SOAP_TYPE_PointerTott__BacklightCompensation:
		return soap_out_PointerTott__BacklightCompensation(soap, tag, id, (struct tt__BacklightCompensation *const*)ptr, "tt:BacklightCompensation");
	case SOAP_TYPE_PointerTott__MoveStatus:
		return soap_out_PointerTott__MoveStatus(soap, tag, id, (enum tt__MoveStatus *const*)ptr, "tt:MoveStatus");
	case SOAP_TYPE_PointerTott__PTZMoveStatus:
		return soap_out_PointerTott__PTZMoveStatus(soap, tag, id, (struct tt__PTZMoveStatus *const*)ptr, "tt:PTZMoveStatus");
	case SOAP_TYPE_PointerTott__PTZVector:
		return soap_out_PointerTott__PTZVector(soap, tag, id, (struct tt__PTZVector *const*)ptr, "tt:PTZVector");
	case SOAP_TYPE_PointerTott__Vector1D:
		return soap_out_PointerTott__Vector1D(soap, tag, id, (struct tt__Vector1D *const*)ptr, "tt:Vector1D");
	case SOAP_TYPE_PointerTott__Vector2D:
		return soap_out_PointerTott__Vector2D(soap, tag, id, (struct tt__Vector2D *const*)ptr, "tt:Vector2D");
	case SOAP_TYPE_PointerTott__FloatRange:
		return soap_out_PointerTott__FloatRange(soap, tag, id, (struct tt__FloatRange *const*)ptr, "tt:FloatRange");
	case SOAP_TYPE_PointerTott__Space1DDescription:
		return soap_out_PointerTott__Space1DDescription(soap, tag, id, (struct tt__Space1DDescription *const*)ptr, "tt:Space1DDescription");
	case SOAP_TYPE_PointerTott__Space2DDescription:
		return soap_out_PointerTott__Space2DDescription(soap, tag, id, (struct tt__Space2DDescription *const*)ptr, "tt:Space2DDescription");
	case SOAP_TYPE_PointerTott__DurationRange:
		return soap_out_PointerTott__DurationRange(soap, tag, id, (struct tt__DurationRange *const*)ptr, "tt:DurationRange");
	case SOAP_TYPE_PointerTott__PTZSpaces:
		return soap_out_PointerTott__PTZSpaces(soap, tag, id, (struct tt__PTZSpaces *const*)ptr, "tt:PTZSpaces");
	case SOAP_TYPE_PointerTott__Date:
		return soap_out_PointerTott__Date(soap, tag, id, (struct tt__Date *const*)ptr, "tt:Date");
	case SOAP_TYPE_PointerTott__Time:
		return soap_out_PointerTott__Time(soap, tag, id, (struct tt__Time *const*)ptr, "tt:Time");
	case SOAP_TYPE_PointerTott__DateTime:
		return soap_out_PointerTott__DateTime(soap, tag, id, (struct tt__DateTime *const*)ptr, "tt:DateTime");
	case SOAP_TYPE_PointerTott__TimeZone:
		return soap_out_PointerTott__TimeZone(soap, tag, id, (struct tt__TimeZone *const*)ptr, "tt:TimeZone");
	case SOAP_TYPE_PointerTott__OnvifVersion:
		return soap_out_PointerTott__OnvifVersion(soap, tag, id, (struct tt__OnvifVersion *const*)ptr, "tt:OnvifVersion");
	case SOAP_TYPE_PointerTott__RealTimeStreamingCapabilities:
		return soap_out_PointerTott__RealTimeStreamingCapabilities(soap, tag, id, (struct tt__RealTimeStreamingCapabilities *const*)ptr, "tt:RealTimeStreamingCapabilities");
	case SOAP_TYPE_PointerTott__SecurityCapabilities:
		return soap_out_PointerTott__SecurityCapabilities(soap, tag, id, (struct tt__SecurityCapabilities *const*)ptr, "tt:SecurityCapabilities");
	case SOAP_TYPE_PointerTott__IOCapabilities:
		return soap_out_PointerTott__IOCapabilities(soap, tag, id, (struct tt__IOCapabilities *const*)ptr, "tt:IOCapabilities");
	case SOAP_TYPE_PointerTott__SystemCapabilities:
		return soap_out_PointerTott__SystemCapabilities(soap, tag, id, (struct tt__SystemCapabilities *const*)ptr, "tt:SystemCapabilities");
	case SOAP_TYPE_PointerTott__NetworkCapabilities:
		return soap_out_PointerTott__NetworkCapabilities(soap, tag, id, (struct tt__NetworkCapabilities *const*)ptr, "tt:NetworkCapabilities");
	case SOAP_TYPE_PointerTott__AnalyticsDeviceCapabilities:
		return soap_out_PointerTott__AnalyticsDeviceCapabilities(soap, tag, id, (struct tt__AnalyticsDeviceCapabilities *const*)ptr, "tt:AnalyticsDeviceCapabilities");
	case SOAP_TYPE_PointerTott__ReceiverCapabilities:
		return soap_out_PointerTott__ReceiverCapabilities(soap, tag, id, (struct tt__ReceiverCapabilities *const*)ptr, "tt:ReceiverCapabilities");
	case SOAP_TYPE_PointerTott__ReplayCapabilities:
		return soap_out_PointerTott__ReplayCapabilities(soap, tag, id, (struct tt__ReplayCapabilities *const*)ptr, "tt:ReplayCapabilities");
	case SOAP_TYPE_PointerTott__SearchCapabilities:
		return soap_out_PointerTott__SearchCapabilities(soap, tag, id, (struct tt__SearchCapabilities *const*)ptr, "tt:SearchCapabilities");
	case SOAP_TYPE_PointerTott__RecordingCapabilities:
		return soap_out_PointerTott__RecordingCapabilities(soap, tag, id, (struct tt__RecordingCapabilities *const*)ptr, "tt:RecordingCapabilities");
	case SOAP_TYPE_PointerTott__DisplayCapabilities:
		return soap_out_PointerTott__DisplayCapabilities(soap, tag, id, (struct tt__DisplayCapabilities *const*)ptr, "tt:DisplayCapabilities");
	case SOAP_TYPE_PointerTott__DeviceIOCapabilities:
		return soap_out_PointerTott__DeviceIOCapabilities(soap, tag, id, (struct tt__DeviceIOCapabilities *const*)ptr, "tt:DeviceIOCapabilities");
	case SOAP_TYPE_PointerTott__CapabilitiesExtension:
		return soap_out_PointerTott__CapabilitiesExtension(soap, tag, id, (struct tt__CapabilitiesExtension *const*)ptr, "tt:CapabilitiesExtension");
	case SOAP_TYPE_PointerTott__PTZCapabilities:
		return soap_out_PointerTott__PTZCapabilities(soap, tag, id, (struct tt__PTZCapabilities *const*)ptr, "tt:PTZCapabilities");
	case SOAP_TYPE_PointerTott__MediaCapabilities:
		return soap_out_PointerTott__MediaCapabilities(soap, tag, id, (struct tt__MediaCapabilities *const*)ptr, "tt:MediaCapabilities");
	case SOAP_TYPE_PointerTott__ImagingCapabilities:
		return soap_out_PointerTott__ImagingCapabilities(soap, tag, id, (struct tt__ImagingCapabilities *const*)ptr, "tt:ImagingCapabilities");
	case SOAP_TYPE_PointerTott__EventCapabilities:
		return soap_out_PointerTott__EventCapabilities(soap, tag, id, (struct tt__EventCapabilities *const*)ptr, "tt:EventCapabilities");
	case SOAP_TYPE_PointerTott__DeviceCapabilities:
		return soap_out_PointerTott__DeviceCapabilities(soap, tag, id, (struct tt__DeviceCapabilities *const*)ptr, "tt:DeviceCapabilities");
	case SOAP_TYPE_PointerTott__AnalyticsCapabilities:
		return soap_out_PointerTott__AnalyticsCapabilities(soap, tag, id, (struct tt__AnalyticsCapabilities *const*)ptr, "tt:AnalyticsCapabilities");
	case SOAP_TYPE_PointerTott__NetworkInterfaceSetConfigurationExtension:
		return soap_out_PointerTott__NetworkInterfaceSetConfigurationExtension(soap, tag, id, (struct tt__NetworkInterfaceSetConfigurationExtension *const*)ptr, "tt:NetworkInterfaceSetConfigurationExtension");
	case SOAP_TYPE_PointerTott__IPv4NetworkInterfaceSetConfiguration:
		return soap_out_PointerTott__IPv4NetworkInterfaceSetConfiguration(soap, tag, id, (struct tt__IPv4NetworkInterfaceSetConfiguration *const*)ptr, "tt:IPv4NetworkInterfaceSetConfiguration");
	case SOAP_TYPE_PointerTott__NetworkHost:
		return soap_out_PointerTott__NetworkHost(soap, tag, id, (struct tt__NetworkHost *const*)ptr, "tt:NetworkHost");
	case SOAP_TYPE_PointerToxsd__token:
		return soap_out_PointerToxsd__token(soap, tag, id, (char **const*)ptr, "xsd:token");
	case SOAP_TYPE_PointerTott__DNSName:
		return soap_out_PointerTott__DNSName(soap, tag, id, (char **const*)ptr, "tt:DNSName");
	case SOAP_TYPE_PointerTott__IPv4Address:
		return soap_out_PointerTott__IPv4Address(soap, tag, id, (char **const*)ptr, "tt:IPv4Address");
	case SOAP_TYPE_PointerTott__PrefixedIPv4Address:
		return soap_out_PointerTott__PrefixedIPv4Address(soap, tag, id, (struct tt__PrefixedIPv4Address *const*)ptr, "tt:PrefixedIPv4Address");
	case SOAP_TYPE_PointerTott__IPv4Configuration:
		return soap_out_PointerTott__IPv4Configuration(soap, tag, id, (struct tt__IPv4Configuration *const*)ptr, "tt:IPv4Configuration");
	case SOAP_TYPE_PointerTott__NetworkInterfaceConnectionSetting:
		return soap_out_PointerTott__NetworkInterfaceConnectionSetting(soap, tag, id, (struct tt__NetworkInterfaceConnectionSetting *const*)ptr, "tt:NetworkInterfaceConnectionSetting");
	case SOAP_TYPE_PointerTott__NetworkInterfaceExtension2:
		return soap_out_PointerTott__NetworkInterfaceExtension2(soap, tag, id, (struct tt__NetworkInterfaceExtension2 *const*)ptr, "tt:NetworkInterfaceExtension2");
	case SOAP_TYPE_PointerTott__Dot3Configuration:
		return soap_out_PointerTott__Dot3Configuration(soap, tag, id, (struct tt__Dot3Configuration *const*)ptr, "tt:Dot3Configuration");
	case SOAP_TYPE_PointerTott__Transport:
		return soap_out_PointerTott__Transport(soap, tag, id, (struct tt__Transport *const*)ptr, "tt:Transport");
	case SOAP_TYPE_PointerTott__IPAddress:
		return soap_out_PointerTott__IPAddress(soap, tag, id, (struct tt__IPAddress *const*)ptr, "tt:IPAddress");
	case SOAP_TYPE_PointerTott__PTZStatusFilterOptions:
		return soap_out_PointerTott__PTZStatusFilterOptions(soap, tag, id, (struct tt__PTZStatusFilterOptions *const*)ptr, "tt:PTZStatusFilterOptions");
	case SOAP_TYPE_PointerTott__IntList:
		return soap_out_PointerTott__IntList(soap, tag, id, (struct tt__IntList *const*)ptr, "tt:IntList");
	case SOAP_TYPE_PointerTott__AudioEncoderConfigurationOption:
		return soap_out_PointerTott__AudioEncoderConfigurationOption(soap, tag, id, (struct tt__AudioEncoderConfigurationOption *const*)ptr, "tt:AudioEncoderConfigurationOption");
	case SOAP_TYPE_PointerTott__H264Profile:
		return soap_out_PointerTott__H264Profile(soap, tag, id, (enum tt__H264Profile *const*)ptr, "tt:H264Profile");
	case SOAP_TYPE_PointerTott__Mpeg4Profile:
		return soap_out_PointerTott__Mpeg4Profile(soap, tag, id, (enum tt__Mpeg4Profile *const*)ptr, "tt:Mpeg4Profile");
	case SOAP_TYPE_PointerTott__VideoResolution:
		return soap_out_PointerTott__VideoResolution(soap, tag, id, (struct tt__VideoResolution *const*)ptr, "tt:VideoResolution");
	case SOAP_TYPE_PointerTott__H264Options:
		return soap_out_PointerTott__H264Options(soap, tag, id, (struct tt__H264Options *const*)ptr, "tt:H264Options");
	case SOAP_TYPE_PointerTott__Mpeg4Options:
		return soap_out_PointerTott__Mpeg4Options(soap, tag, id, (struct tt__Mpeg4Options *const*)ptr, "tt:Mpeg4Options");
	case SOAP_TYPE_PointerTott__JpegOptions:
		return soap_out_PointerTott__JpegOptions(soap, tag, id, (struct tt__JpegOptions *const*)ptr, "tt:JpegOptions");
	case SOAP_TYPE_PointerTott__ReferenceToken:
		return soap_out_PointerTott__ReferenceToken(soap, tag, id, (char **const*)ptr, "tt:ReferenceToken");
	case SOAP_TYPE_PointerTott__IntRectangleRange:
		return soap_out_PointerTott__IntRectangleRange(soap, tag, id, (struct tt__IntRectangleRange *const*)ptr, "tt:IntRectangleRange");
	case SOAP_TYPE_PointerToxsd__boolean:
		return soap_out_PointerToxsd__boolean(soap, tag, id, (enum xsd__boolean *const*)ptr, "xsd:boolean");
	case SOAP_TYPE_PointerTott__MetadataConfiguration:
		return soap_out_PointerTott__MetadataConfiguration(soap, tag, id, (struct tt__MetadataConfiguration *const*)ptr, "tt:MetadataConfiguration");
	case SOAP_TYPE_PointerTott__PTZConfiguration:
		return soap_out_PointerTott__PTZConfiguration(soap, tag, id, (struct tt__PTZConfiguration *const*)ptr, "tt:PTZConfiguration");
	case SOAP_TYPE_PointerTott__AudioEncoderConfiguration:
		return soap_out_PointerTott__AudioEncoderConfiguration(soap, tag, id, (struct tt__AudioEncoderConfiguration *const*)ptr, "tt:AudioEncoderConfiguration");
	case SOAP_TYPE_PointerTott__VideoEncoderConfiguration:
		return soap_out_PointerTott__VideoEncoderConfiguration(soap, tag, id, (struct tt__VideoEncoderConfiguration *const*)ptr, "tt:VideoEncoderConfiguration");
	case SOAP_TYPE_PointerTott__AudioSourceConfiguration:
		return soap_out_PointerTott__AudioSourceConfiguration(soap, tag, id, (struct tt__AudioSourceConfiguration *const*)ptr, "tt:AudioSourceConfiguration");
	case SOAP_TYPE_PointerTott__VideoSourceConfiguration:
		return soap_out_PointerTott__VideoSourceConfiguration(soap, tag, id, (struct tt__VideoSourceConfiguration *const*)ptr, "tt:VideoSourceConfiguration");
	case SOAP_TYPE_PointerToint:
		return soap_out_PointerToint(soap, tag, id, (int *const*)ptr, "xsd:int");
	case SOAP_TYPE_PointerTott__IntRange:
		return soap_out_PointerTott__IntRange(soap, tag, id, (struct tt__IntRange *const*)ptr, "tt:IntRange");
	case SOAP_TYPE_PointerTowstop__Documentation:
		return soap_out_PointerTowstop__Documentation(soap, tag, id, (struct wstop__Documentation *const*)ptr, "wstop:Documentation");
	case SOAP_TYPE_PointerTowsa__MetadataType:
		return soap_out_PointerTowsa__MetadataType(soap, tag, id, (struct wsa__MetadataType *const*)ptr, "wsa:MetadataType");
	case SOAP_TYPE_PointerTowsa__ReferenceParametersType:
		return soap_out_PointerTowsa__ReferenceParametersType(soap, tag, id, (struct wsa__ReferenceParametersType *const*)ptr, "wsa:ReferenceParametersType");
	case SOAP_TYPE_PointerTowsa__AttributedURIType:
		return soap_out_PointerTowsa__AttributedURIType(soap, tag, id, (struct wsa__AttributedURIType *const*)ptr, "wsa:AttributedURIType");
	case SOAP_TYPE_PointerTo_wsbf__BaseFaultType_FaultCause:
		return soap_out_PointerTo_wsbf__BaseFaultType_FaultCause(soap, tag, id, (struct _wsbf__BaseFaultType_FaultCause *const*)ptr, "wsbf:BaseFaultType-FaultCause");
	case SOAP_TYPE_PointerTo_wsbf__BaseFaultType_Description:
		return soap_out_PointerTo_wsbf__BaseFaultType_Description(soap, tag, id, (struct _wsbf__BaseFaultType_Description *const*)ptr, "wsbf:BaseFaultType-Description");
	case SOAP_TYPE_PointerTo_wsbf__BaseFaultType_ErrorCode:
		return soap_out_PointerTo_wsbf__BaseFaultType_ErrorCode(soap, tag, id, (struct _wsbf__BaseFaultType_ErrorCode *const*)ptr, "wsbf:BaseFaultType-ErrorCode");
	case SOAP_TYPE_PointerTotime:
		return soap_out_PointerTotime(soap, tag, id, (time_t *const*)ptr, "xsd:dateTime");
	case SOAP_TYPE_PointerTowsnt__FilterType:
		return soap_out_PointerTowsnt__FilterType(soap, tag, id, (struct wsnt__FilterType *const*)ptr, "wsnt:FilterType");
	case SOAP_TYPE_PointerTowsnt__NotificationMessageHolderType:
		return soap_out_PointerTowsnt__NotificationMessageHolderType(soap, tag, id, (struct wsnt__NotificationMessageHolderType *const*)ptr, "wsnt:NotificationMessageHolderType");
	case SOAP_TYPE_PointerTo_tt__Message:
		return soap_out_PointerTo_tt__Message(soap, tag, id, (struct _tt__Message *const*)ptr, "tt:Message");
	case SOAP_TYPE_PointerTowsa__EndpointReferenceType:
		return soap_out_PointerTowsa__EndpointReferenceType(soap, tag, id, (struct wsa__EndpointReferenceType *const*)ptr, "wsa:EndpointReferenceType");
	case SOAP_TYPE_PointerTowsnt__QueryExpressionType:
		return soap_out_PointerTowsnt__QueryExpressionType(soap, tag, id, (struct wsnt__QueryExpressionType *const*)ptr, "wsnt:QueryExpressionType");
	case SOAP_TYPE_PointerTowsnt__TopicExpressionType:
		return soap_out_PointerTowsnt__TopicExpressionType(soap, tag, id, (struct wsnt__TopicExpressionType *const*)ptr, "wsnt:TopicExpressionType");
	case SOAP_TYPE_PointerTowsadis__ServiceNameType:
		return soap_out_PointerTowsadis__ServiceNameType(soap, tag, id, (struct wsadis__ServiceNameType *const*)ptr, "wsadis:ServiceNameType");
	case SOAP_TYPE_PointerTowsadis__AttributedQName:
		return soap_out_PointerTowsadis__AttributedQName(soap, tag, id, (struct wsadis__AttributedQName *const*)ptr, "wsadis:AttributedQName");
	case SOAP_TYPE_PointerTowsadis__ReferenceParametersType:
		return soap_out_PointerTowsadis__ReferenceParametersType(soap, tag, id, (struct wsadis__ReferenceParametersType *const*)ptr, "wsadis:ReferenceParametersType");
	case SOAP_TYPE_PointerTowsadis__ReferencePropertiesType:
		return soap_out_PointerTowsadis__ReferencePropertiesType(soap, tag, id, (struct wsadis__ReferencePropertiesType *const*)ptr, "wsadis:ReferencePropertiesType");
	case SOAP_TYPE_PointerTowsadis__AttributedURI:
		return soap_out_PointerTowsadis__AttributedURI(soap, tag, id, (struct wsadis__AttributedURI *const*)ptr, "wsadis:AttributedURI");
	case SOAP_TYPE_tt__Domain:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "tt:Domain");
	case SOAP_TYPE_tt__DNSName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "tt:DNSName");
	case SOAP_TYPE_tt__HwAddress:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "tt:HwAddress");
	case SOAP_TYPE_tt__IPv4Address:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "tt:IPv4Address");
	case SOAP_TYPE_tt__Name:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "tt:Name");
	case SOAP_TYPE_tt__ReferenceToken:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "tt:ReferenceToken");
	case SOAP_TYPE_d__UriListType:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "d:UriListType");
	case SOAP_TYPE_d__QNameListType:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "d:QNameListType");
	case SOAP_TYPE_wsa__RelationshipTypeOpenEnum:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "wsa:RelationshipTypeOpenEnum");
	case SOAP_TYPE_wsnt__AbsoluteOrRelativeTimeType:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "wsnt:AbsoluteOrRelativeTimeType");
	case SOAP_TYPE__tptz__SetHomePositionResponse:
		return soap_out_string(soap, "tptz:SetHomePositionResponse", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__xml__lang:
		return soap_out_string(soap, "xml:lang", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE_xsd__token:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:token");
	case SOAP_TYPE_xsd__duration:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:duration");
	case SOAP_TYPE_xsd__anyURI:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:anyURI");
	case SOAP_TYPE_xsd__anySimpleType:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:anySimpleType");
	case SOAP_TYPE_xsd__Name:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:Name");
	case SOAP_TYPE_xsd__NCName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:NCName");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE___trt__GetSnapshotUri:
		soap_serialize___trt__GetSnapshotUri(soap, (const struct __trt__GetSnapshotUri *)ptr);
		break;
	case SOAP_TYPE___trt__SetSynchronizationPoint:
		soap_serialize___trt__SetSynchronizationPoint(soap, (const struct __trt__SetSynchronizationPoint *)ptr);
		break;
	case SOAP_TYPE___trt__GetStreamUri:
		soap_serialize___trt__GetStreamUri(soap, (const struct __trt__GetStreamUri *)ptr);
		break;
	case SOAP_TYPE___trt__GetGuaranteedNumberOfVideoEncoderInstances:
		soap_serialize___trt__GetGuaranteedNumberOfVideoEncoderInstances(soap, (const struct __trt__GetGuaranteedNumberOfVideoEncoderInstances *)ptr);
		break;
	case SOAP_TYPE___trt__GetMetadataConfigurationOptions:
		soap_serialize___trt__GetMetadataConfigurationOptions(soap, (const struct __trt__GetMetadataConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE___trt__GetAudioEncoderConfigurationOptions:
		soap_serialize___trt__GetAudioEncoderConfigurationOptions(soap, (const struct __trt__GetAudioEncoderConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE___trt__GetAudioSourceConfigurationOptions:
		soap_serialize___trt__GetAudioSourceConfigurationOptions(soap, (const struct __trt__GetAudioSourceConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE___trt__GetVideoEncoderConfigurationOptions:
		soap_serialize___trt__GetVideoEncoderConfigurationOptions(soap, (const struct __trt__GetVideoEncoderConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE___trt__GetVideoSourceConfigurationOptions:
		soap_serialize___trt__GetVideoSourceConfigurationOptions(soap, (const struct __trt__GetVideoSourceConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE___trt__SetMetadataConfiguration:
		soap_serialize___trt__SetMetadataConfiguration(soap, (const struct __trt__SetMetadataConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__SetAudioEncoderConfiguration:
		soap_serialize___trt__SetAudioEncoderConfiguration(soap, (const struct __trt__SetAudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__SetAudioSourceConfiguration:
		soap_serialize___trt__SetAudioSourceConfiguration(soap, (const struct __trt__SetAudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__SetVideoEncoderConfiguration:
		soap_serialize___trt__SetVideoEncoderConfiguration(soap, (const struct __trt__SetVideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__SetVideoSourceConfiguration:
		soap_serialize___trt__SetVideoSourceConfiguration(soap, (const struct __trt__SetVideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__GetCompatibleMetadataConfigurations:
		soap_serialize___trt__GetCompatibleMetadataConfigurations(soap, (const struct __trt__GetCompatibleMetadataConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__GetCompatibleAudioSourceConfigurations:
		soap_serialize___trt__GetCompatibleAudioSourceConfigurations(soap, (const struct __trt__GetCompatibleAudioSourceConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__GetCompatibleAudioEncoderConfigurations:
		soap_serialize___trt__GetCompatibleAudioEncoderConfigurations(soap, (const struct __trt__GetCompatibleAudioEncoderConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__GetCompatibleVideoSourceConfigurations:
		soap_serialize___trt__GetCompatibleVideoSourceConfigurations(soap, (const struct __trt__GetCompatibleVideoSourceConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__GetCompatibleVideoEncoderConfigurations:
		soap_serialize___trt__GetCompatibleVideoEncoderConfigurations(soap, (const struct __trt__GetCompatibleVideoEncoderConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__GetMetadataConfiguration:
		soap_serialize___trt__GetMetadataConfiguration(soap, (const struct __trt__GetMetadataConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__GetAudioEncoderConfiguration:
		soap_serialize___trt__GetAudioEncoderConfiguration(soap, (const struct __trt__GetAudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__GetAudioSourceConfiguration:
		soap_serialize___trt__GetAudioSourceConfiguration(soap, (const struct __trt__GetAudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__GetVideoEncoderConfiguration:
		soap_serialize___trt__GetVideoEncoderConfiguration(soap, (const struct __trt__GetVideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__GetVideoSourceConfiguration:
		soap_serialize___trt__GetVideoSourceConfiguration(soap, (const struct __trt__GetVideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__GetMetadataConfigurations:
		soap_serialize___trt__GetMetadataConfigurations(soap, (const struct __trt__GetMetadataConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__GetAudioEncoderConfigurations:
		soap_serialize___trt__GetAudioEncoderConfigurations(soap, (const struct __trt__GetAudioEncoderConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__GetAudioSourceConfigurations:
		soap_serialize___trt__GetAudioSourceConfigurations(soap, (const struct __trt__GetAudioSourceConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__GetVideoEncoderConfigurations:
		soap_serialize___trt__GetVideoEncoderConfigurations(soap, (const struct __trt__GetVideoEncoderConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__GetVideoSourceConfigurations:
		soap_serialize___trt__GetVideoSourceConfigurations(soap, (const struct __trt__GetVideoSourceConfigurations *)ptr);
		break;
	case SOAP_TYPE___trt__DeleteProfile:
		soap_serialize___trt__DeleteProfile(soap, (const struct __trt__DeleteProfile *)ptr);
		break;
	case SOAP_TYPE___trt__RemoveMetadataConfiguration:
		soap_serialize___trt__RemoveMetadataConfiguration(soap, (const struct __trt__RemoveMetadataConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__RemovePTZConfiguration:
		soap_serialize___trt__RemovePTZConfiguration(soap, (const struct __trt__RemovePTZConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__RemoveAudioSourceConfiguration:
		soap_serialize___trt__RemoveAudioSourceConfiguration(soap, (const struct __trt__RemoveAudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__RemoveAudioEncoderConfiguration:
		soap_serialize___trt__RemoveAudioEncoderConfiguration(soap, (const struct __trt__RemoveAudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__RemoveVideoSourceConfiguration:
		soap_serialize___trt__RemoveVideoSourceConfiguration(soap, (const struct __trt__RemoveVideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__RemoveVideoEncoderConfiguration:
		soap_serialize___trt__RemoveVideoEncoderConfiguration(soap, (const struct __trt__RemoveVideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__AddMetadataConfiguration:
		soap_serialize___trt__AddMetadataConfiguration(soap, (const struct __trt__AddMetadataConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__AddPTZConfiguration:
		soap_serialize___trt__AddPTZConfiguration(soap, (const struct __trt__AddPTZConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__AddAudioSourceConfiguration:
		soap_serialize___trt__AddAudioSourceConfiguration(soap, (const struct __trt__AddAudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__AddAudioEncoderConfiguration:
		soap_serialize___trt__AddAudioEncoderConfiguration(soap, (const struct __trt__AddAudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__AddVideoSourceConfiguration:
		soap_serialize___trt__AddVideoSourceConfiguration(soap, (const struct __trt__AddVideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__AddVideoEncoderConfiguration:
		soap_serialize___trt__AddVideoEncoderConfiguration(soap, (const struct __trt__AddVideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE___trt__GetProfiles:
		soap_serialize___trt__GetProfiles(soap, (const struct __trt__GetProfiles *)ptr);
		break;
	case SOAP_TYPE___trt__GetProfile:
		soap_serialize___trt__GetProfile(soap, (const struct __trt__GetProfile *)ptr);
		break;
	case SOAP_TYPE___trt__CreateProfile:
		soap_serialize___trt__CreateProfile(soap, (const struct __trt__CreateProfile *)ptr);
		break;
	case SOAP_TYPE___trt__GetAudioSources:
		soap_serialize___trt__GetAudioSources(soap, (const struct __trt__GetAudioSources *)ptr);
		break;
	case SOAP_TYPE___trt__GetVideoSources:
		soap_serialize___trt__GetVideoSources(soap, (const struct __trt__GetVideoSources *)ptr);
		break;
	case SOAP_TYPE___tptz__Stop_:
		soap_serialize___tptz__Stop_(soap, (const struct __tptz__Stop_ *)ptr);
		break;
	case SOAP_TYPE___tptz__AbsoluteMove_:
		soap_serialize___tptz__AbsoluteMove_(soap, (const struct __tptz__AbsoluteMove_ *)ptr);
		break;
	case SOAP_TYPE___tptz__ContinuousMove_:
		soap_serialize___tptz__ContinuousMove_(soap, (const struct __tptz__ContinuousMove_ *)ptr);
		break;
	case SOAP_TYPE___tptz__SetHomePosition_:
		soap_serialize___tptz__SetHomePosition_(soap, (const struct __tptz__SetHomePosition_ *)ptr);
		break;
	case SOAP_TYPE___tptz__SetHomePosition_Response:
		soap_serialize___tptz__SetHomePosition_Response(soap, (const struct __tptz__SetHomePosition_Response *)ptr);
		break;
	case SOAP_TYPE___tptz__GotoHomePosition_:
		soap_serialize___tptz__GotoHomePosition_(soap, (const struct __tptz__GotoHomePosition_ *)ptr);
		break;
	case SOAP_TYPE___tptz__GetConfigurationOptions_:
		soap_serialize___tptz__GetConfigurationOptions_(soap, (const struct __tptz__GetConfigurationOptions_ *)ptr);
		break;
	case SOAP_TYPE___tptz__SetConfiguration_:
		soap_serialize___tptz__SetConfiguration_(soap, (const struct __tptz__SetConfiguration_ *)ptr);
		break;
	case SOAP_TYPE___tptz__GetNode_:
		soap_serialize___tptz__GetNode_(soap, (const struct __tptz__GetNode_ *)ptr);
		break;
	case SOAP_TYPE___tptz__GetNodes_:
		soap_serialize___tptz__GetNodes_(soap, (const struct __tptz__GetNodes_ *)ptr);
		break;
	case SOAP_TYPE___tptz__GetConfiguration_:
		soap_serialize___tptz__GetConfiguration_(soap, (const struct __tptz__GetConfiguration_ *)ptr);
		break;
	case SOAP_TYPE___tptz__GetStatus_:
		soap_serialize___tptz__GetStatus_(soap, (const struct __tptz__GetStatus_ *)ptr);
		break;
	case SOAP_TYPE___tptz__GotoPreset_:
		soap_serialize___tptz__GotoPreset_(soap, (const struct __tptz__GotoPreset_ *)ptr);
		break;
	case SOAP_TYPE___tptz__RemovePreset_:
		soap_serialize___tptz__RemovePreset_(soap, (const struct __tptz__RemovePreset_ *)ptr);
		break;
	case SOAP_TYPE___tptz__SetPreset_:
		soap_serialize___tptz__SetPreset_(soap, (const struct __tptz__SetPreset_ *)ptr);
		break;
	case SOAP_TYPE___tptz__GetPresets_:
		soap_serialize___tptz__GetPresets_(soap, (const struct __tptz__GetPresets_ *)ptr);
		break;
	case SOAP_TYPE___tptz__GetConfigurations_:
		soap_serialize___tptz__GetConfigurations_(soap, (const struct __tptz__GetConfigurations_ *)ptr);
		break;
	case SOAP_TYPE___tptz__Stop:
		soap_serialize___tptz__Stop(soap, (const struct __tptz__Stop *)ptr);
		break;
	case SOAP_TYPE___tptz__AbsoluteMove:
		soap_serialize___tptz__AbsoluteMove(soap, (const struct __tptz__AbsoluteMove *)ptr);
		break;
	case SOAP_TYPE___tptz__ContinuousMove:
		soap_serialize___tptz__ContinuousMove(soap, (const struct __tptz__ContinuousMove *)ptr);
		break;
	case SOAP_TYPE___tptz__SetHomePosition:
		soap_serialize___tptz__SetHomePosition(soap, (const struct __tptz__SetHomePosition *)ptr);
		break;
	case SOAP_TYPE___tptz__SetHomePositionResponse:
		soap_serialize___tptz__SetHomePositionResponse(soap, (const struct __tptz__SetHomePositionResponse *)ptr);
		break;
	case SOAP_TYPE___tptz__GotoHomePosition:
		soap_serialize___tptz__GotoHomePosition(soap, (const struct __tptz__GotoHomePosition *)ptr);
		break;
	case SOAP_TYPE___tptz__GetConfigurationOptions:
		soap_serialize___tptz__GetConfigurationOptions(soap, (const struct __tptz__GetConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE___tptz__SetConfiguration:
		soap_serialize___tptz__SetConfiguration(soap, (const struct __tptz__SetConfiguration *)ptr);
		break;
	case SOAP_TYPE___tptz__GetNode:
		soap_serialize___tptz__GetNode(soap, (const struct __tptz__GetNode *)ptr);
		break;
	case SOAP_TYPE___tptz__GetNodes:
		soap_serialize___tptz__GetNodes(soap, (const struct __tptz__GetNodes *)ptr);
		break;
	case SOAP_TYPE___tptz__GetConfiguration:
		soap_serialize___tptz__GetConfiguration(soap, (const struct __tptz__GetConfiguration *)ptr);
		break;
	case SOAP_TYPE___tptz__GetStatus:
		soap_serialize___tptz__GetStatus(soap, (const struct __tptz__GetStatus *)ptr);
		break;
	case SOAP_TYPE___tptz__GotoPreset:
		soap_serialize___tptz__GotoPreset(soap, (const struct __tptz__GotoPreset *)ptr);
		break;
	case SOAP_TYPE___tptz__RemovePreset:
		soap_serialize___tptz__RemovePreset(soap, (const struct __tptz__RemovePreset *)ptr);
		break;
	case SOAP_TYPE___tptz__SetPreset:
		soap_serialize___tptz__SetPreset(soap, (const struct __tptz__SetPreset *)ptr);
		break;
	case SOAP_TYPE___tptz__GetPresets:
		soap_serialize___tptz__GetPresets(soap, (const struct __tptz__GetPresets *)ptr);
		break;
	case SOAP_TYPE___tptz__GetConfigurations:
		soap_serialize___tptz__GetConfigurations(soap, (const struct __tptz__GetConfigurations *)ptr);
		break;
	case SOAP_TYPE___tds__SetRelayOutputState:
		soap_serialize___tds__SetRelayOutputState(soap, (const struct __tds__SetRelayOutputState *)ptr);
		break;
	case SOAP_TYPE___tds__SetRelayOutputSettings:
		soap_serialize___tds__SetRelayOutputSettings(soap, (const struct __tds__SetRelayOutputSettings *)ptr);
		break;
	case SOAP_TYPE___tds__GetRelayOutputs:
		soap_serialize___tds__GetRelayOutputs(soap, (const struct __tds__GetRelayOutputs *)ptr);
		break;
	case SOAP_TYPE___tds__SetZeroConfiguration:
		soap_serialize___tds__SetZeroConfiguration(soap, (const struct __tds__SetZeroConfiguration *)ptr);
		break;
	case SOAP_TYPE___tds__GetZeroConfiguration:
		soap_serialize___tds__GetZeroConfiguration(soap, (const struct __tds__GetZeroConfiguration *)ptr);
		break;
	case SOAP_TYPE___tds__SetNetworkDefaultGateway:
		soap_serialize___tds__SetNetworkDefaultGateway(soap, (const struct __tds__SetNetworkDefaultGateway *)ptr);
		break;
	case SOAP_TYPE___tds__GetNetworkDefaultGateway:
		soap_serialize___tds__GetNetworkDefaultGateway(soap, (const struct __tds__GetNetworkDefaultGateway *)ptr);
		break;
	case SOAP_TYPE___tds__SetNetworkProtocols:
		soap_serialize___tds__SetNetworkProtocols(soap, (const struct __tds__SetNetworkProtocols *)ptr);
		break;
	case SOAP_TYPE___tds__GetNetworkProtocols:
		soap_serialize___tds__GetNetworkProtocols(soap, (const struct __tds__GetNetworkProtocols *)ptr);
		break;
	case SOAP_TYPE___tds__SetNetworkInterfaces:
		soap_serialize___tds__SetNetworkInterfaces(soap, (const struct __tds__SetNetworkInterfaces *)ptr);
		break;
	case SOAP_TYPE___tds__GetNetworkInterfaces:
		soap_serialize___tds__GetNetworkInterfaces(soap, (const struct __tds__GetNetworkInterfaces *)ptr);
		break;
	case SOAP_TYPE___tds__SetDynamicDNS:
		soap_serialize___tds__SetDynamicDNS(soap, (const struct __tds__SetDynamicDNS *)ptr);
		break;
	case SOAP_TYPE___tds__GetDynamicDNS:
		soap_serialize___tds__GetDynamicDNS(soap, (const struct __tds__GetDynamicDNS *)ptr);
		break;
	case SOAP_TYPE___tds__SetNTP:
		soap_serialize___tds__SetNTP(soap, (const struct __tds__SetNTP *)ptr);
		break;
	case SOAP_TYPE___tds__GetNTP:
		soap_serialize___tds__GetNTP(soap, (const struct __tds__GetNTP *)ptr);
		break;
	case SOAP_TYPE___tds__SetDNS:
		soap_serialize___tds__SetDNS(soap, (const struct __tds__SetDNS *)ptr);
		break;
	case SOAP_TYPE___tds__GetDNS:
		soap_serialize___tds__GetDNS(soap, (const struct __tds__GetDNS *)ptr);
		break;
	case SOAP_TYPE___tds__SetHostname:
		soap_serialize___tds__SetHostname(soap, (const struct __tds__SetHostname *)ptr);
		break;
	case SOAP_TYPE___tds__GetHostname:
		soap_serialize___tds__GetHostname(soap, (const struct __tds__GetHostname *)ptr);
		break;
	case SOAP_TYPE___tds__GetCapabilities:
		soap_serialize___tds__GetCapabilities(soap, (const struct __tds__GetCapabilities *)ptr);
		break;
	case SOAP_TYPE___tds__GetWsdlUrl:
		soap_serialize___tds__GetWsdlUrl(soap, (const struct __tds__GetWsdlUrl *)ptr);
		break;
	case SOAP_TYPE___tds__SetUser:
		soap_serialize___tds__SetUser(soap, (const struct __tds__SetUser *)ptr);
		break;
	case SOAP_TYPE___tds__DeleteUsers:
		soap_serialize___tds__DeleteUsers(soap, (const struct __tds__DeleteUsers *)ptr);
		break;
	case SOAP_TYPE___tds__CreateUsers:
		soap_serialize___tds__CreateUsers(soap, (const struct __tds__CreateUsers *)ptr);
		break;
	case SOAP_TYPE___tds__GetUsers:
		soap_serialize___tds__GetUsers(soap, (const struct __tds__GetUsers *)ptr);
		break;
	case SOAP_TYPE___tds__SetDiscoveryMode:
		soap_serialize___tds__SetDiscoveryMode(soap, (const struct __tds__SetDiscoveryMode *)ptr);
		break;
	case SOAP_TYPE___tds__GetDiscoveryMode:
		soap_serialize___tds__GetDiscoveryMode(soap, (const struct __tds__GetDiscoveryMode *)ptr);
		break;
	case SOAP_TYPE___tds__RemoveScopes:
		soap_serialize___tds__RemoveScopes(soap, (const struct __tds__RemoveScopes *)ptr);
		break;
	case SOAP_TYPE___tds__AddScopes:
		soap_serialize___tds__AddScopes(soap, (const struct __tds__AddScopes *)ptr);
		break;
	case SOAP_TYPE___tds__SetScopes:
		soap_serialize___tds__SetScopes(soap, (const struct __tds__SetScopes *)ptr);
		break;
	case SOAP_TYPE___tds__GetScopes:
		soap_serialize___tds__GetScopes(soap, (const struct __tds__GetScopes *)ptr);
		break;
	case SOAP_TYPE___tds__GetSystemLog:
		soap_serialize___tds__GetSystemLog(soap, (const struct __tds__GetSystemLog *)ptr);
		break;
	case SOAP_TYPE___tds__SystemReboot:
		soap_serialize___tds__SystemReboot(soap, (const struct __tds__SystemReboot *)ptr);
		break;
	case SOAP_TYPE___tds__SetSystemFactoryDefault:
		soap_serialize___tds__SetSystemFactoryDefault(soap, (const struct __tds__SetSystemFactoryDefault *)ptr);
		break;
	case SOAP_TYPE___tds__GetSystemDateAndTime:
		soap_serialize___tds__GetSystemDateAndTime(soap, (const struct __tds__GetSystemDateAndTime *)ptr);
		break;
	case SOAP_TYPE___tds__SetSystemDateAndTime:
		soap_serialize___tds__SetSystemDateAndTime(soap, (const struct __tds__SetSystemDateAndTime *)ptr);
		break;
	case SOAP_TYPE___tds__GetDeviceInformation:
		soap_serialize___tds__GetDeviceInformation(soap, (const struct __tds__GetDeviceInformation *)ptr);
		break;
	case SOAP_TYPE___ns7__Notify:
		soap_serialize___ns7__Notify(soap, (const struct __ns7__Notify *)ptr);
		break;
	case SOAP_TYPE___ns6__Subscribe:
		soap_serialize___ns6__Subscribe(soap, (const struct __ns6__Subscribe *)ptr);
		break;
	case SOAP_TYPE___ns5__Unsubscribe:
		soap_serialize___ns5__Unsubscribe(soap, (const struct __ns5__Unsubscribe *)ptr);
		break;
	case SOAP_TYPE___ns5__Renew:
		soap_serialize___ns5__Renew(soap, (const struct __ns5__Renew *)ptr);
		break;
	case SOAP_TYPE___ns4__GetEventProperties:
		soap_serialize___ns4__GetEventProperties(soap, (const struct __ns4__GetEventProperties *)ptr);
		break;
	case SOAP_TYPE___ns4__CreatePullPointSubscription:
		soap_serialize___ns4__CreatePullPointSubscription(soap, (const struct __ns4__CreatePullPointSubscription *)ptr);
		break;
	case SOAP_TYPE___ns3__SetSynchronizationPoint:
		soap_serialize___ns3__SetSynchronizationPoint(soap, (const struct __ns3__SetSynchronizationPoint *)ptr);
		break;
	case SOAP_TYPE___ns3__PullMessages:
		soap_serialize___ns3__PullMessages(soap, (const struct __ns3__PullMessages *)ptr);
		break;
	case SOAP_TYPE___d__Probe:
		soap_serialize___d__Probe(soap, (const struct __d__Probe *)ptr);
		break;
	case SOAP_TYPE___d__Bye:
		soap_serialize___d__Bye(soap, (const struct __d__Bye *)ptr);
		break;
	case SOAP_TYPE___d__Hello:
		soap_serialize___d__Hello(soap, (const struct __d__Hello *)ptr);
		break;
	case SOAP_TYPE__wsu__Timestamp:
		soap_serialize__wsu__Timestamp(soap, (const struct wsu__TimestampType *)ptr);
		break;
	case SOAP_TYPE__wsse__Password:
		soap_serialize__wsse__Password(soap, (const struct wsse__PasswordString *)ptr);
		break;
	case SOAP_TYPE__wsse__Security:
		soap_serialize__wsse__Security(soap, (const struct wsse__SecurityHeaderType *)ptr);
		break;
	case SOAP_TYPE__wsse__UsernameToken:
		soap_serialize__wsse__UsernameToken(soap, (const struct wsse__UsernameTokenType *)ptr);
		break;
	case SOAP_TYPE__d__AppSequence:
		soap_serialize__d__AppSequence(soap, (const struct d__AppSequenceType *)ptr);
		break;
	case SOAP_TYPE__d__Scopes:
		soap_serialize__d__Scopes(soap, (const struct d__ScopesType *)ptr);
		break;
	case SOAP_TYPE__d__Resolve:
		soap_serialize__d__Resolve(soap, (const struct d__ResolveType *)ptr);
		break;
	case SOAP_TYPE__d__ByeResponse:
		soap_serialize__d__ByeResponse(soap, (const struct d__ResolveType *)ptr);
		break;
	case SOAP_TYPE__d__Bye:
		soap_serialize__d__Bye(soap, (const struct d__ByeType *)ptr);
		break;
	case SOAP_TYPE__d__ProbeMatches:
		soap_serialize__d__ProbeMatches(soap, (const struct d__ProbeMatchesType *)ptr);
		break;
	case SOAP_TYPE__d__Probe:
		soap_serialize__d__Probe(soap, (const struct d__ProbeType *)ptr);
		break;
	case SOAP_TYPE__d__HelloResponse:
		soap_serialize__d__HelloResponse(soap, (const struct d__ResolveType *)ptr);
		break;
	case SOAP_TYPE__d__Hello:
		soap_serialize__d__Hello(soap, (const struct d__HelloType *)ptr);
		break;
	case SOAP_TYPE__trt__Capabilities:
		soap_serialize__trt__Capabilities(soap, (const struct trt__Capabilities *)ptr);
		break;
	case SOAP_TYPE__wsaw__InterfaceName:
		soap_serialize__wsaw__InterfaceName(soap, (const struct wsaw__AttributedQNameType *)ptr);
		break;
	case SOAP_TYPE__wsaw__ServiceName:
		soap_serialize__wsaw__ServiceName(soap, (const struct wsaw__ServiceNameType *)ptr);
		break;
	case SOAP_TYPE__tt__MetadataConfiguration:
		soap_serialize__tt__MetadataConfiguration(soap, (const struct tt__MetadataConfiguration *)ptr);
		break;
	case SOAP_TYPE__tt__PTZConfiguration:
		soap_serialize__tt__PTZConfiguration(soap, (const struct tt__PTZConfiguration *)ptr);
		break;
	case SOAP_TYPE__tt__AudioEncoderConfiguration:
		soap_serialize__tt__AudioEncoderConfiguration(soap, (const struct tt__AudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__tt__VideoEncoderConfiguration:
		soap_serialize__tt__VideoEncoderConfiguration(soap, (const struct tt__VideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__tt__AudioSourceConfiguration:
		soap_serialize__tt__AudioSourceConfiguration(soap, (const struct tt__AudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__tt__VideoSourceConfiguration:
		soap_serialize__tt__VideoSourceConfiguration(soap, (const struct tt__VideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__wsr__ResourceUnknownFault:
		soap_serialize__wsr__ResourceUnknownFault(soap, (const struct wsr__ResourceUnknownFaultType *)ptr);
		break;
	case SOAP_TYPE__wstop__TopicSet:
		soap_serialize__wstop__TopicSet(soap, (const struct wstop__TopicSetType *)ptr);
		break;
	case SOAP_TYPE__wsa__Action:
		soap_serialize__wsa__Action(soap, (const struct wsa__AttributedURIType *)ptr);
		break;
	case SOAP_TYPE__wsa__To:
		soap_serialize__wsa__To(soap, (const struct wsa__AttributedURIType *)ptr);
		break;
	case SOAP_TYPE__wsa__FaultTo:
		soap_serialize__wsa__FaultTo(soap, (const struct wsa__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsa__From:
		soap_serialize__wsa__From(soap, (const struct wsa__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsa__ReplyTo:
		soap_serialize__wsa__ReplyTo(soap, (const struct wsa__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsa__RelatesTo:
		soap_serialize__wsa__RelatesTo(soap, (const struct wsa__RelatesToType *)ptr);
		break;
	case SOAP_TYPE__wsa__MessageID:
		soap_serialize__wsa__MessageID(soap, (const struct wsa__AttributedURIType *)ptr);
		break;
	case SOAP_TYPE__wsa__Metadata:
		soap_serialize__wsa__Metadata(soap, (const struct wsa__MetadataType *)ptr);
		break;
	case SOAP_TYPE__wsa__EndpointReference:
		soap_serialize__wsa__EndpointReference(soap, (const struct wsa__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsbf__BaseFault:
		soap_serialize__wsbf__BaseFault(soap, (const struct wsbf__BaseFaultType *)ptr);
		break;
	case SOAP_TYPE__wsnt__UnableToDestroySubscriptionFault:
		soap_serialize__wsnt__UnableToDestroySubscriptionFault(soap, (const struct wsnt__UnableToDestroySubscriptionFaultType *)ptr);
		break;
	case SOAP_TYPE__wsnt__MessageContent:
		soap_serialize__wsnt__MessageContent(soap, (const struct wsnt__QueryExpressionType *)ptr);
		break;
	case SOAP_TYPE__wsnt__NotificationMessage:
		soap_serialize__wsnt__NotificationMessage(soap, (const struct wsnt__NotificationMessageHolderType *)ptr);
		break;
	case SOAP_TYPE__wsnt__ProducerReference:
		soap_serialize__wsnt__ProducerReference(soap, (const struct wsa__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsnt__Topic:
		soap_serialize__wsnt__Topic(soap, (const struct wsnt__TopicExpressionType *)ptr);
		break;
	case SOAP_TYPE__wsnt__SubscriptionReference:
		soap_serialize__wsnt__SubscriptionReference(soap, (const struct wsa__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsnt__TopicExpression:
		soap_serialize__wsnt__TopicExpression(soap, (const struct wsnt__TopicExpressionType *)ptr);
		break;
	case SOAP_TYPE__wsadis__FaultTo:
		soap_serialize__wsadis__FaultTo(soap, (const struct wsadis__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsadis__ReplyTo:
		soap_serialize__wsadis__ReplyTo(soap, (const struct wsadis__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsadis__From:
		soap_serialize__wsadis__From(soap, (const struct wsadis__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsadis__Action:
		soap_serialize__wsadis__Action(soap, (const struct wsadis__AttributedURI *)ptr);
		break;
	case SOAP_TYPE__wsadis__To:
		soap_serialize__wsadis__To(soap, (const struct wsadis__AttributedURI *)ptr);
		break;
	case SOAP_TYPE__wsadis__RelatesTo:
		soap_serialize__wsadis__RelatesTo(soap, (const struct wsadis__Relationship *)ptr);
		break;
	case SOAP_TYPE__wsadis__MessageID:
		soap_serialize__wsadis__MessageID(soap, (const struct wsadis__AttributedURI *)ptr);
		break;
	case SOAP_TYPE__wsadis__EndpointReference:
		soap_serialize__wsadis__EndpointReference(soap, (const struct wsadis__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsbf__ResourceUnknownFaultType_FaultCause:
		soap_serialize__wsbf__ResourceUnknownFaultType_FaultCause(soap, (const struct _wsbf__ResourceUnknownFaultType_FaultCause *)ptr);
		break;
	case SOAP_TYPE__wsbf__ResourceUnknownFaultType_Description:
		soap_serialize__wsbf__ResourceUnknownFaultType_Description(soap, (const struct _wsbf__ResourceUnknownFaultType_Description *)ptr);
		break;
	case SOAP_TYPE__wsbf__ResourceUnknownFaultType_ErrorCode:
		soap_serialize__wsbf__ResourceUnknownFaultType_ErrorCode(soap, (const struct _wsbf__ResourceUnknownFaultType_ErrorCode *)ptr);
		break;
	case SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_FaultCause:
		soap_serialize__wsbf__UnableToDestroySubscriptionFaultType_FaultCause(soap, (const struct _wsbf__UnableToDestroySubscriptionFaultType_FaultCause *)ptr);
		break;
	case SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_Description:
		soap_serialize__wsbf__UnableToDestroySubscriptionFaultType_Description(soap, (const struct _wsbf__UnableToDestroySubscriptionFaultType_Description *)ptr);
		break;
	case SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode:
		soap_serialize__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode(soap, (const struct _wsbf__UnableToDestroySubscriptionFaultType_ErrorCode *)ptr);
		break;
	case SOAP_TYPE___tptz__SetConfigurationResponse_sequence:
		soap_serialize___tptz__SetConfigurationResponse_sequence(soap, (const struct __tptz__SetConfigurationResponse_sequence *)ptr);
		break;
	case SOAP_TYPE___tt__union_EventStream:
		soap_serialize___tt__union_EventStream(soap, (const struct __tt__union_EventStream *)ptr);
		break;
	case SOAP_TYPE__tt__ItemListDescription_SimpleItemDescription:
		soap_serialize__tt__ItemListDescription_SimpleItemDescription(soap, (const struct _tt__ItemListDescription_SimpleItemDescription *)ptr);
		break;
	case SOAP_TYPE__tt__ItemList_SimpleItem:
		soap_serialize__tt__ItemList_SimpleItem(soap, (const struct _tt__ItemList_SimpleItem *)ptr);
		break;
	case SOAP_TYPE__wsbf__BaseFaultType_FaultCause:
		soap_serialize__wsbf__BaseFaultType_FaultCause(soap, (const struct _wsbf__BaseFaultType_FaultCause *)ptr);
		break;
	case SOAP_TYPE__wsbf__BaseFaultType_Description:
		soap_serialize__wsbf__BaseFaultType_Description(soap, (const struct _wsbf__BaseFaultType_Description *)ptr);
		break;
	case SOAP_TYPE__wsbf__BaseFaultType_ErrorCode:
		soap_serialize__wsbf__BaseFaultType_ErrorCode(soap, (const struct _wsbf__BaseFaultType_ErrorCode *)ptr);
		break;
	case SOAP_TYPE__wsnt__NotificationMessageHolderType_Message:
		soap_serialize__wsnt__NotificationMessageHolderType_Message(soap, (const struct _wsnt__NotificationMessageHolderType_Message *)ptr);
		break;
	case SOAP_TYPE_wsu__TimestampType:
		soap_serialize_wsu__TimestampType(soap, (const struct wsu__TimestampType *)ptr);
		break;
	case SOAP_TYPE_wsse__SecurityHeaderType:
		soap_serialize_wsse__SecurityHeaderType(soap, (const struct wsse__SecurityHeaderType *)ptr);
		break;
	case SOAP_TYPE_wsse__UsernameTokenType:
		soap_serialize_wsse__UsernameTokenType(soap, (const struct wsse__UsernameTokenType *)ptr);
		break;
	case SOAP_TYPE_wsse__PasswordString:
		soap_serialize_wsse__PasswordString(soap, (const struct wsse__PasswordString *)ptr);
		break;
	case SOAP_TYPE_d__AppSequenceType:
		soap_serialize_d__AppSequenceType(soap, (const struct d__AppSequenceType *)ptr);
		break;
	case SOAP_TYPE_d__ScopesType:
		soap_serialize_d__ScopesType(soap, (const struct d__ScopesType *)ptr);
		break;
	case SOAP_TYPE_d__ResolveType:
		soap_serialize_d__ResolveType(soap, (const struct d__ResolveType *)ptr);
		break;
	case SOAP_TYPE_d__ProbeMatchType:
		soap_serialize_d__ProbeMatchType(soap, (const struct d__ProbeMatchType *)ptr);
		break;
	case SOAP_TYPE_d__ProbeMatchesType:
		soap_serialize_d__ProbeMatchesType(soap, (const struct d__ProbeMatchesType *)ptr);
		break;
	case SOAP_TYPE_d__ProbeType:
		soap_serialize_d__ProbeType(soap, (const struct d__ProbeType *)ptr);
		break;
	case SOAP_TYPE_d__ByeType:
		soap_serialize_d__ByeType(soap, (const struct d__ByeType *)ptr);
		break;
	case SOAP_TYPE_d__HelloType:
		soap_serialize_d__HelloType(soap, (const struct d__HelloType *)ptr);
		break;
	case SOAP_TYPE__tptz__StopResponse:
		soap_serialize__tptz__StopResponse(soap, (const struct _tptz__StopResponse *)ptr);
		break;
	case SOAP_TYPE__tptz__Stop:
		soap_serialize__tptz__Stop(soap, (const struct _tptz__Stop *)ptr);
		break;
	case SOAP_TYPE__tptz__AbsoluteMoveResponse:
		soap_serialize__tptz__AbsoluteMoveResponse(soap, (const struct _tptz__AbsoluteMoveResponse *)ptr);
		break;
	case SOAP_TYPE__tptz__AbsoluteMove:
		soap_serialize__tptz__AbsoluteMove(soap, (const struct _tptz__AbsoluteMove *)ptr);
		break;
	case SOAP_TYPE__tptz__ContinuousMoveResponse:
		soap_serialize__tptz__ContinuousMoveResponse(soap, (const struct _tptz__ContinuousMoveResponse *)ptr);
		break;
	case SOAP_TYPE__tptz__ContinuousMove:
		soap_serialize__tptz__ContinuousMove(soap, (const struct _tptz__ContinuousMove *)ptr);
		break;
	case SOAP_TYPE__tptz__SetHomePosition:
		soap_serialize__tptz__SetHomePosition(soap, (const struct _tptz__SetHomePosition *)ptr);
		break;
	case SOAP_TYPE__tptz__GotoHomePositionResponse:
		soap_serialize__tptz__GotoHomePositionResponse(soap, (const struct _tptz__GotoHomePositionResponse *)ptr);
		break;
	case SOAP_TYPE__tptz__GotoHomePosition:
		soap_serialize__tptz__GotoHomePosition(soap, (const struct _tptz__GotoHomePosition *)ptr);
		break;
	case SOAP_TYPE__tptz__GetStatusResponse:
		soap_serialize__tptz__GetStatusResponse(soap, (const struct _tptz__GetStatusResponse *)ptr);
		break;
	case SOAP_TYPE__tptz__GetStatus:
		soap_serialize__tptz__GetStatus(soap, (const struct _tptz__GetStatus *)ptr);
		break;
	case SOAP_TYPE__tptz__GetPresetResponse:
		soap_serialize__tptz__GetPresetResponse(soap, (const struct _tptz__GetPresetResponse *)ptr);
		break;
	case SOAP_TYPE__tptz__GetPreset:
		soap_serialize__tptz__GetPreset(soap, (const struct _tptz__GetPreset *)ptr);
		break;
	case SOAP_TYPE__tptz__GotoPresetResponse:
		soap_serialize__tptz__GotoPresetResponse(soap, (const struct _tptz__GotoPresetResponse *)ptr);
		break;
	case SOAP_TYPE__tptz__GotoPreset:
		soap_serialize__tptz__GotoPreset(soap, (const struct _tptz__GotoPreset *)ptr);
		break;
	case SOAP_TYPE__tptz__RemovePresetResponse:
		soap_serialize__tptz__RemovePresetResponse(soap, (const struct _tptz__RemovePresetResponse *)ptr);
		break;
	case SOAP_TYPE__tptz__RemovePreset:
		soap_serialize__tptz__RemovePreset(soap, (const struct _tptz__RemovePreset *)ptr);
		break;
	case SOAP_TYPE__tptz__SetPresetResponse:
		soap_serialize__tptz__SetPresetResponse(soap, (const struct _tptz__SetPresetResponse *)ptr);
		break;
	case SOAP_TYPE__tptz__SetPreset:
		soap_serialize__tptz__SetPreset(soap, (const struct _tptz__SetPreset *)ptr);
		break;
	case SOAP_TYPE__tptz__GetPresetsResponse:
		soap_serialize__tptz__GetPresetsResponse(soap, (const struct _tptz__GetPresetsResponse *)ptr);
		break;
	case SOAP_TYPE__tptz__GetPresets:
		soap_serialize__tptz__GetPresets(soap, (const struct _tptz__GetPresets *)ptr);
		break;
	case SOAP_TYPE__tptz__GetConfigurationOptionsResponse:
		soap_serialize__tptz__GetConfigurationOptionsResponse(soap, (const struct _tptz__GetConfigurationOptionsResponse *)ptr);
		break;
	case SOAP_TYPE__tptz__GetConfigurationOptions:
		soap_serialize__tptz__GetConfigurationOptions(soap, (const struct _tptz__GetConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE__tptz__SetConfigurationResponse:
		soap_serialize__tptz__SetConfigurationResponse(soap, (const struct _tptz__SetConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__tptz__SetConfiguration:
		soap_serialize__tptz__SetConfiguration(soap, (const struct _tptz__SetConfiguration *)ptr);
		break;
	case SOAP_TYPE__tptz__GetConfigurationResponse:
		soap_serialize__tptz__GetConfigurationResponse(soap, (const struct _tptz__GetConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__tptz__GetConfiguration:
		soap_serialize__tptz__GetConfiguration(soap, (const struct _tptz__GetConfiguration *)ptr);
		break;
	case SOAP_TYPE__tptz__GetConfigurationsResponse:
		soap_serialize__tptz__GetConfigurationsResponse(soap, (const struct _tptz__GetConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__tptz__GetConfigurations:
		soap_serialize__tptz__GetConfigurations(soap, (const struct _tptz__GetConfigurations *)ptr);
		break;
	case SOAP_TYPE__tptz__GetNodeResponse:
		soap_serialize__tptz__GetNodeResponse(soap, (const struct _tptz__GetNodeResponse *)ptr);
		break;
	case SOAP_TYPE__tptz__GetNode:
		soap_serialize__tptz__GetNode(soap, (const struct _tptz__GetNode *)ptr);
		break;
	case SOAP_TYPE__tptz__GetNodesResponse:
		soap_serialize__tptz__GetNodesResponse(soap, (const struct _tptz__GetNodesResponse *)ptr);
		break;
	case SOAP_TYPE__tptz__GetNodes:
		soap_serialize__tptz__GetNodes(soap, (const struct _tptz__GetNodes *)ptr);
		break;
	case SOAP_TYPE__trt__GetSnapshotUriResponse:
		soap_serialize__trt__GetSnapshotUriResponse(soap, (const struct _trt__GetSnapshotUriResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetSnapshotUri:
		soap_serialize__trt__GetSnapshotUri(soap, (const struct _trt__GetSnapshotUri *)ptr);
		break;
	case SOAP_TYPE__trt__SetSynchronizationPointResponse:
		soap_serialize__trt__SetSynchronizationPointResponse(soap, (const struct _trt__SetSynchronizationPointResponse *)ptr);
		break;
	case SOAP_TYPE__trt__SetSynchronizationPoint:
		soap_serialize__trt__SetSynchronizationPoint(soap, (const struct _trt__SetSynchronizationPoint *)ptr);
		break;
	case SOAP_TYPE__trt__GetStreamUriResponse:
		soap_serialize__trt__GetStreamUriResponse(soap, (const struct _trt__GetStreamUriResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetStreamUri:
		soap_serialize__trt__GetStreamUri(soap, (const struct _trt__GetStreamUri *)ptr);
		break;
	case SOAP_TYPE__trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse:
		soap_serialize__trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse(soap, (const struct _trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetGuaranteedNumberOfVideoEncoderInstances:
		soap_serialize__trt__GetGuaranteedNumberOfVideoEncoderInstances(soap, (const struct _trt__GetGuaranteedNumberOfVideoEncoderInstances *)ptr);
		break;
	case SOAP_TYPE__trt__GetMetadataConfigurationOptionsResponse:
		soap_serialize__trt__GetMetadataConfigurationOptionsResponse(soap, (const struct _trt__GetMetadataConfigurationOptionsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetMetadataConfigurationOptions:
		soap_serialize__trt__GetMetadataConfigurationOptions(soap, (const struct _trt__GetMetadataConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioEncoderConfigurationOptionsResponse:
		soap_serialize__trt__GetAudioEncoderConfigurationOptionsResponse(soap, (const struct _trt__GetAudioEncoderConfigurationOptionsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioEncoderConfigurationOptions:
		soap_serialize__trt__GetAudioEncoderConfigurationOptions(soap, (const struct _trt__GetAudioEncoderConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioSourceConfigurationOptionsResponse:
		soap_serialize__trt__GetAudioSourceConfigurationOptionsResponse(soap, (const struct _trt__GetAudioSourceConfigurationOptionsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioSourceConfigurationOptions:
		soap_serialize__trt__GetAudioSourceConfigurationOptions(soap, (const struct _trt__GetAudioSourceConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoEncoderConfigurationOptionsResponse:
		soap_serialize__trt__GetVideoEncoderConfigurationOptionsResponse(soap, (const struct _trt__GetVideoEncoderConfigurationOptionsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoEncoderConfigurationOptions:
		soap_serialize__trt__GetVideoEncoderConfigurationOptions(soap, (const struct _trt__GetVideoEncoderConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoSourceConfigurationOptionsResponse:
		soap_serialize__trt__GetVideoSourceConfigurationOptionsResponse(soap, (const struct _trt__GetVideoSourceConfigurationOptionsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoSourceConfigurationOptions:
		soap_serialize__trt__GetVideoSourceConfigurationOptions(soap, (const struct _trt__GetVideoSourceConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE__trt__SetMetadataConfigurationResponse:
		soap_serialize__trt__SetMetadataConfigurationResponse(soap, (const struct _trt__SetMetadataConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__SetMetadataConfiguration:
		soap_serialize__trt__SetMetadataConfiguration(soap, (const struct _trt__SetMetadataConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__SetAudioSourceConfigurationResponse:
		soap_serialize__trt__SetAudioSourceConfigurationResponse(soap, (const struct _trt__SetAudioSourceConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__SetAudioSourceConfiguration:
		soap_serialize__trt__SetAudioSourceConfiguration(soap, (const struct _trt__SetAudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__SetAudioEncoderConfigurationResponse:
		soap_serialize__trt__SetAudioEncoderConfigurationResponse(soap, (const struct _trt__SetAudioEncoderConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__SetAudioEncoderConfiguration:
		soap_serialize__trt__SetAudioEncoderConfiguration(soap, (const struct _trt__SetAudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__SetVideoSourceConfigurationResponse:
		soap_serialize__trt__SetVideoSourceConfigurationResponse(soap, (const struct _trt__SetVideoSourceConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__SetVideoSourceConfiguration:
		soap_serialize__trt__SetVideoSourceConfiguration(soap, (const struct _trt__SetVideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__SetVideoEncoderConfigurationResponse:
		soap_serialize__trt__SetVideoEncoderConfigurationResponse(soap, (const struct _trt__SetVideoEncoderConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__SetVideoEncoderConfiguration:
		soap_serialize__trt__SetVideoEncoderConfiguration(soap, (const struct _trt__SetVideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleMetadataConfigurationsResponse:
		soap_serialize__trt__GetCompatibleMetadataConfigurationsResponse(soap, (const struct _trt__GetCompatibleMetadataConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleMetadataConfigurations:
		soap_serialize__trt__GetCompatibleMetadataConfigurations(soap, (const struct _trt__GetCompatibleMetadataConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurationsResponse:
		soap_serialize__trt__GetCompatibleAudioSourceConfigurationsResponse(soap, (const struct _trt__GetCompatibleAudioSourceConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleAudioSourceConfigurations:
		soap_serialize__trt__GetCompatibleAudioSourceConfigurations(soap, (const struct _trt__GetCompatibleAudioSourceConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurationsResponse:
		soap_serialize__trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, (const struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleAudioEncoderConfigurations:
		soap_serialize__trt__GetCompatibleAudioEncoderConfigurations(soap, (const struct _trt__GetCompatibleAudioEncoderConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurationsResponse:
		soap_serialize__trt__GetCompatibleVideoSourceConfigurationsResponse(soap, (const struct _trt__GetCompatibleVideoSourceConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleVideoSourceConfigurations:
		soap_serialize__trt__GetCompatibleVideoSourceConfigurations(soap, (const struct _trt__GetCompatibleVideoSourceConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurationsResponse:
		soap_serialize__trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, (const struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetCompatibleVideoEncoderConfigurations:
		soap_serialize__trt__GetCompatibleVideoEncoderConfigurations(soap, (const struct _trt__GetCompatibleVideoEncoderConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__GetMetadataConfigurationResponse:
		soap_serialize__trt__GetMetadataConfigurationResponse(soap, (const struct _trt__GetMetadataConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetMetadataConfiguration:
		soap_serialize__trt__GetMetadataConfiguration(soap, (const struct _trt__GetMetadataConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioEncoderConfigurationResponse:
		soap_serialize__trt__GetAudioEncoderConfigurationResponse(soap, (const struct _trt__GetAudioEncoderConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioEncoderConfiguration:
		soap_serialize__trt__GetAudioEncoderConfiguration(soap, (const struct _trt__GetAudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioSourceConfigurationResponse:
		soap_serialize__trt__GetAudioSourceConfigurationResponse(soap, (const struct _trt__GetAudioSourceConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioSourceConfiguration:
		soap_serialize__trt__GetAudioSourceConfiguration(soap, (const struct _trt__GetAudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoEncoderConfigurationResponse:
		soap_serialize__trt__GetVideoEncoderConfigurationResponse(soap, (const struct _trt__GetVideoEncoderConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoEncoderConfiguration:
		soap_serialize__trt__GetVideoEncoderConfiguration(soap, (const struct _trt__GetVideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoSourceConfigurationResponse:
		soap_serialize__trt__GetVideoSourceConfigurationResponse(soap, (const struct _trt__GetVideoSourceConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoSourceConfiguration:
		soap_serialize__trt__GetVideoSourceConfiguration(soap, (const struct _trt__GetVideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__GetMetadataConfigurationsResponse:
		soap_serialize__trt__GetMetadataConfigurationsResponse(soap, (const struct _trt__GetMetadataConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetMetadataConfigurations:
		soap_serialize__trt__GetMetadataConfigurations(soap, (const struct _trt__GetMetadataConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioSourceConfigurationsResponse:
		soap_serialize__trt__GetAudioSourceConfigurationsResponse(soap, (const struct _trt__GetAudioSourceConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioSourceConfigurations:
		soap_serialize__trt__GetAudioSourceConfigurations(soap, (const struct _trt__GetAudioSourceConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioEncoderConfigurationsResponse:
		soap_serialize__trt__GetAudioEncoderConfigurationsResponse(soap, (const struct _trt__GetAudioEncoderConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioEncoderConfigurations:
		soap_serialize__trt__GetAudioEncoderConfigurations(soap, (const struct _trt__GetAudioEncoderConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoSourceConfigurationsResponse:
		soap_serialize__trt__GetVideoSourceConfigurationsResponse(soap, (const struct _trt__GetVideoSourceConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoSourceConfigurations:
		soap_serialize__trt__GetVideoSourceConfigurations(soap, (const struct _trt__GetVideoSourceConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoEncoderConfigurationsResponse:
		soap_serialize__trt__GetVideoEncoderConfigurationsResponse(soap, (const struct _trt__GetVideoEncoderConfigurationsResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoEncoderConfigurations:
		soap_serialize__trt__GetVideoEncoderConfigurations(soap, (const struct _trt__GetVideoEncoderConfigurations *)ptr);
		break;
	case SOAP_TYPE__trt__DeleteProfileResponse:
		soap_serialize__trt__DeleteProfileResponse(soap, (const struct _trt__DeleteProfileResponse *)ptr);
		break;
	case SOAP_TYPE__trt__DeleteProfile:
		soap_serialize__trt__DeleteProfile(soap, (const struct _trt__DeleteProfile *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveMetadataConfigurationResponse:
		soap_serialize__trt__RemoveMetadataConfigurationResponse(soap, (const struct _trt__RemoveMetadataConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveMetadataConfiguration:
		soap_serialize__trt__RemoveMetadataConfiguration(soap, (const struct _trt__RemoveMetadataConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__AddMetadataConfigurationResponse:
		soap_serialize__trt__AddMetadataConfigurationResponse(soap, (const struct _trt__AddMetadataConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__AddMetadataConfiguration:
		soap_serialize__trt__AddMetadataConfiguration(soap, (const struct _trt__AddMetadataConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__RemovePTZConfigurationResponse:
		soap_serialize__trt__RemovePTZConfigurationResponse(soap, (const struct _trt__RemovePTZConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__RemovePTZConfiguration:
		soap_serialize__trt__RemovePTZConfiguration(soap, (const struct _trt__RemovePTZConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__AddPTZConfigurationResponse:
		soap_serialize__trt__AddPTZConfigurationResponse(soap, (const struct _trt__AddPTZConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__AddPTZConfiguration:
		soap_serialize__trt__AddPTZConfiguration(soap, (const struct _trt__AddPTZConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveAudioSourceConfigurationResponse:
		soap_serialize__trt__RemoveAudioSourceConfigurationResponse(soap, (const struct _trt__RemoveAudioSourceConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveAudioSourceConfiguration:
		soap_serialize__trt__RemoveAudioSourceConfiguration(soap, (const struct _trt__RemoveAudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__AddAudioSourceConfigurationResponse:
		soap_serialize__trt__AddAudioSourceConfigurationResponse(soap, (const struct _trt__AddAudioSourceConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__AddAudioSourceConfiguration:
		soap_serialize__trt__AddAudioSourceConfiguration(soap, (const struct _trt__AddAudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveAudioEncoderConfigurationResponse:
		soap_serialize__trt__RemoveAudioEncoderConfigurationResponse(soap, (const struct _trt__RemoveAudioEncoderConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveAudioEncoderConfiguration:
		soap_serialize__trt__RemoveAudioEncoderConfiguration(soap, (const struct _trt__RemoveAudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__AddAudioEncoderConfigurationResponse:
		soap_serialize__trt__AddAudioEncoderConfigurationResponse(soap, (const struct _trt__AddAudioEncoderConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__AddAudioEncoderConfiguration:
		soap_serialize__trt__AddAudioEncoderConfiguration(soap, (const struct _trt__AddAudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveVideoSourceConfigurationResponse:
		soap_serialize__trt__RemoveVideoSourceConfigurationResponse(soap, (const struct _trt__RemoveVideoSourceConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveVideoSourceConfiguration:
		soap_serialize__trt__RemoveVideoSourceConfiguration(soap, (const struct _trt__RemoveVideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__AddVideoSourceConfigurationResponse:
		soap_serialize__trt__AddVideoSourceConfigurationResponse(soap, (const struct _trt__AddVideoSourceConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__AddVideoSourceConfiguration:
		soap_serialize__trt__AddVideoSourceConfiguration(soap, (const struct _trt__AddVideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveVideoEncoderConfigurationResponse:
		soap_serialize__trt__RemoveVideoEncoderConfigurationResponse(soap, (const struct _trt__RemoveVideoEncoderConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__RemoveVideoEncoderConfiguration:
		soap_serialize__trt__RemoveVideoEncoderConfiguration(soap, (const struct _trt__RemoveVideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__AddVideoEncoderConfigurationResponse:
		soap_serialize__trt__AddVideoEncoderConfigurationResponse(soap, (const struct _trt__AddVideoEncoderConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__trt__AddVideoEncoderConfiguration:
		soap_serialize__trt__AddVideoEncoderConfiguration(soap, (const struct _trt__AddVideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE__trt__GetProfilesResponse:
		soap_serialize__trt__GetProfilesResponse(soap, (const struct _trt__GetProfilesResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetProfiles:
		soap_serialize__trt__GetProfiles(soap, (const struct _trt__GetProfiles *)ptr);
		break;
	case SOAP_TYPE__trt__GetProfileResponse:
		soap_serialize__trt__GetProfileResponse(soap, (const struct _trt__GetProfileResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetProfile:
		soap_serialize__trt__GetProfile(soap, (const struct _trt__GetProfile *)ptr);
		break;
	case SOAP_TYPE__trt__CreateProfileResponse:
		soap_serialize__trt__CreateProfileResponse(soap, (const struct _trt__CreateProfileResponse *)ptr);
		break;
	case SOAP_TYPE__trt__CreateProfile:
		soap_serialize__trt__CreateProfile(soap, (const struct _trt__CreateProfile *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioSourcesResponse:
		soap_serialize__trt__GetAudioSourcesResponse(soap, (const struct _trt__GetAudioSourcesResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetAudioSources:
		soap_serialize__trt__GetAudioSources(soap, (const struct _trt__GetAudioSources *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoSourcesResponse:
		soap_serialize__trt__GetVideoSourcesResponse(soap, (const struct _trt__GetVideoSourcesResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetVideoSources:
		soap_serialize__trt__GetVideoSources(soap, (const struct _trt__GetVideoSources *)ptr);
		break;
	case SOAP_TYPE__trt__GetServiceCapabilitiesResponse:
		soap_serialize__trt__GetServiceCapabilitiesResponse(soap, (const struct _trt__GetServiceCapabilitiesResponse *)ptr);
		break;
	case SOAP_TYPE__trt__GetServiceCapabilities:
		soap_serialize__trt__GetServiceCapabilities(soap, (const struct _trt__GetServiceCapabilities *)ptr);
		break;
	case SOAP_TYPE_trt__StreamingCapabilities:
		soap_serialize_trt__StreamingCapabilities(soap, (const struct trt__StreamingCapabilities *)ptr);
		break;
	case SOAP_TYPE_trt__ProfileCapabilities:
		soap_serialize_trt__ProfileCapabilities(soap, (const struct trt__ProfileCapabilities *)ptr);
		break;
	case SOAP_TYPE_trt__Capabilities:
		soap_serialize_trt__Capabilities(soap, (const struct trt__Capabilities *)ptr);
		break;
	case SOAP_TYPE__wsaw__Anonymous:
		soap_serialize__wsaw__Anonymous(soap, (const struct _wsaw__Anonymous *)ptr);
		break;
	case SOAP_TYPE__wsaw__UsingAddressing:
		soap_serialize__wsaw__UsingAddressing(soap, (const struct _wsaw__UsingAddressing *)ptr);
		break;
	case SOAP_TYPE_wsaw__AttributedQNameType:
		soap_serialize_wsaw__AttributedQNameType(soap, (const struct wsaw__AttributedQNameType *)ptr);
		break;
	case SOAP_TYPE_wsaw__ServiceNameType:
		soap_serialize_wsaw__ServiceNameType(soap, (const struct wsaw__ServiceNameType *)ptr);
		break;
	case SOAP_TYPE__tev__GetEventPropertiesResponse:
		soap_serialize__tev__GetEventPropertiesResponse(soap, (const struct _tev__GetEventPropertiesResponse *)ptr);
		break;
	case SOAP_TYPE__tev__GetEventProperties:
		soap_serialize__tev__GetEventProperties(soap, (const struct _tev__GetEventProperties *)ptr);
		break;
	case SOAP_TYPE__tev__SetSynchronizationPointResponse:
		soap_serialize__tev__SetSynchronizationPointResponse(soap, (const struct _tev__SetSynchronizationPointResponse *)ptr);
		break;
	case SOAP_TYPE__tev__SetSynchronizationPoint:
		soap_serialize__tev__SetSynchronizationPoint(soap, (const struct _tev__SetSynchronizationPoint *)ptr);
		break;
	case SOAP_TYPE__tev__PullMessagesFaultResponse:
		soap_serialize__tev__PullMessagesFaultResponse(soap, (const struct _tev__PullMessagesFaultResponse *)ptr);
		break;
	case SOAP_TYPE__tev__PullMessagesResponse:
		soap_serialize__tev__PullMessagesResponse(soap, (const struct _tev__PullMessagesResponse *)ptr);
		break;
	case SOAP_TYPE__tev__PullMessages:
		soap_serialize__tev__PullMessages(soap, (const struct _tev__PullMessages *)ptr);
		break;
	case SOAP_TYPE__tev__CreatePullPointSubscriptionResponse:
		soap_serialize__tev__CreatePullPointSubscriptionResponse(soap, (const struct _tev__CreatePullPointSubscriptionResponse *)ptr);
		break;
	case SOAP_TYPE__tev__CreatePullPointSubscription:
		soap_serialize__tev__CreatePullPointSubscription(soap, (const struct _tev__CreatePullPointSubscription *)ptr);
		break;
	case SOAP_TYPE__tds__SetRelayOutputStateResponse:
		soap_serialize__tds__SetRelayOutputStateResponse(soap, (const struct _tds__SetRelayOutputStateResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetRelayOutputState:
		soap_serialize__tds__SetRelayOutputState(soap, (const struct _tds__SetRelayOutputState *)ptr);
		break;
	case SOAP_TYPE__tds__SetRelayOutputSettingsResponse:
		soap_serialize__tds__SetRelayOutputSettingsResponse(soap, (const struct _tds__SetRelayOutputSettingsResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetRelayOutputSettings:
		soap_serialize__tds__SetRelayOutputSettings(soap, (const struct _tds__SetRelayOutputSettings *)ptr);
		break;
	case SOAP_TYPE__tds__GetRelayOutputsResponse:
		soap_serialize__tds__GetRelayOutputsResponse(soap, (const struct _tds__GetRelayOutputsResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetRelayOutputs:
		soap_serialize__tds__GetRelayOutputs(soap, (const struct _tds__GetRelayOutputs *)ptr);
		break;
	case SOAP_TYPE__tds__SetZeroConfigurationResponse:
		soap_serialize__tds__SetZeroConfigurationResponse(soap, (const struct _tds__SetZeroConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetZeroConfiguration:
		soap_serialize__tds__SetZeroConfiguration(soap, (const struct _tds__SetZeroConfiguration *)ptr);
		break;
	case SOAP_TYPE__tds__GetZeroConfigurationResponse:
		soap_serialize__tds__GetZeroConfigurationResponse(soap, (const struct _tds__GetZeroConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetZeroConfiguration:
		soap_serialize__tds__GetZeroConfiguration(soap, (const struct _tds__GetZeroConfiguration *)ptr);
		break;
	case SOAP_TYPE__tds__SetNetworkDefaultGatewayResponse:
		soap_serialize__tds__SetNetworkDefaultGatewayResponse(soap, (const struct _tds__SetNetworkDefaultGatewayResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetNetworkDefaultGateway:
		soap_serialize__tds__SetNetworkDefaultGateway(soap, (const struct _tds__SetNetworkDefaultGateway *)ptr);
		break;
	case SOAP_TYPE__tds__GetNetworkDefaultGatewayResponse:
		soap_serialize__tds__GetNetworkDefaultGatewayResponse(soap, (const struct _tds__GetNetworkDefaultGatewayResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetNetworkDefaultGateway:
		soap_serialize__tds__GetNetworkDefaultGateway(soap, (const struct _tds__GetNetworkDefaultGateway *)ptr);
		break;
	case SOAP_TYPE__tds__SetNetworkProtocolsResponse:
		soap_serialize__tds__SetNetworkProtocolsResponse(soap, (const struct _tds__SetNetworkProtocolsResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetNetworkProtocols:
		soap_serialize__tds__SetNetworkProtocols(soap, (const struct _tds__SetNetworkProtocols *)ptr);
		break;
	case SOAP_TYPE__tds__GetNetworkProtocolsResponse:
		soap_serialize__tds__GetNetworkProtocolsResponse(soap, (const struct _tds__GetNetworkProtocolsResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetNetworkProtocols:
		soap_serialize__tds__GetNetworkProtocols(soap, (const struct _tds__GetNetworkProtocols *)ptr);
		break;
	case SOAP_TYPE__tds__SetNetworkInterfacesResponse:
		soap_serialize__tds__SetNetworkInterfacesResponse(soap, (const struct _tds__SetNetworkInterfacesResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetNetworkInterfaces:
		soap_serialize__tds__SetNetworkInterfaces(soap, (const struct _tds__SetNetworkInterfaces *)ptr);
		break;
	case SOAP_TYPE__tds__GetNetworkInterfacesResponse:
		soap_serialize__tds__GetNetworkInterfacesResponse(soap, (const struct _tds__GetNetworkInterfacesResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetNetworkInterfaces:
		soap_serialize__tds__GetNetworkInterfaces(soap, (const struct _tds__GetNetworkInterfaces *)ptr);
		break;
	case SOAP_TYPE__tds__SetDynamicDNSResponse:
		soap_serialize__tds__SetDynamicDNSResponse(soap, (const struct _tds__SetDynamicDNSResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetDynamicDNS:
		soap_serialize__tds__SetDynamicDNS(soap, (const struct _tds__SetDynamicDNS *)ptr);
		break;
	case SOAP_TYPE__tds__GetDynamicDNSResponse:
		soap_serialize__tds__GetDynamicDNSResponse(soap, (const struct _tds__GetDynamicDNSResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetDynamicDNS:
		soap_serialize__tds__GetDynamicDNS(soap, (const struct _tds__GetDynamicDNS *)ptr);
		break;
	case SOAP_TYPE__tds__SetNTPResponse:
		soap_serialize__tds__SetNTPResponse(soap, (const struct _tds__SetNTPResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetNTP:
		soap_serialize__tds__SetNTP(soap, (const struct _tds__SetNTP *)ptr);
		break;
	case SOAP_TYPE__tds__GetNTPResponse:
		soap_serialize__tds__GetNTPResponse(soap, (const struct _tds__GetNTPResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetNTP:
		soap_serialize__tds__GetNTP(soap, (const struct _tds__GetNTP *)ptr);
		break;
	case SOAP_TYPE__tds__SetDNSResponse:
		soap_serialize__tds__SetDNSResponse(soap, (const struct _tds__SetDNSResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetDNS:
		soap_serialize__tds__SetDNS(soap, (const struct _tds__SetDNS *)ptr);
		break;
	case SOAP_TYPE__tds__GetDNSResponse:
		soap_serialize__tds__GetDNSResponse(soap, (const struct _tds__GetDNSResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetDNS:
		soap_serialize__tds__GetDNS(soap, (const struct _tds__GetDNS *)ptr);
		break;
	case SOAP_TYPE__tds__SetHostnameResponse:
		soap_serialize__tds__SetHostnameResponse(soap, (const struct _tds__SetHostnameResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetHostname:
		soap_serialize__tds__SetHostname(soap, (const struct _tds__SetHostname *)ptr);
		break;
	case SOAP_TYPE__tds__GetHostnameResponse:
		soap_serialize__tds__GetHostnameResponse(soap, (const struct _tds__GetHostnameResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetHostname:
		soap_serialize__tds__GetHostname(soap, (const struct _tds__GetHostname *)ptr);
		break;
	case SOAP_TYPE__tds__GetCapabilitiesResponse:
		soap_serialize__tds__GetCapabilitiesResponse(soap, (const struct _tds__GetCapabilitiesResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetCapabilities:
		soap_serialize__tds__GetCapabilities(soap, (const struct _tds__GetCapabilities *)ptr);
		break;
	case SOAP_TYPE__tds__GetWsdlUrlResponse:
		soap_serialize__tds__GetWsdlUrlResponse(soap, (const struct _tds__GetWsdlUrlResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetWsdlUrl:
		soap_serialize__tds__GetWsdlUrl(soap, (const struct _tds__GetWsdlUrl *)ptr);
		break;
	case SOAP_TYPE__tds__SetUserResponse:
		soap_serialize__tds__SetUserResponse(soap, (const struct _tds__SetUserResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetUser:
		soap_serialize__tds__SetUser(soap, (const struct _tds__SetUser *)ptr);
		break;
	case SOAP_TYPE__tds__DeleteUsersResponse:
		soap_serialize__tds__DeleteUsersResponse(soap, (const struct _tds__DeleteUsersResponse *)ptr);
		break;
	case SOAP_TYPE__tds__DeleteUsers:
		soap_serialize__tds__DeleteUsers(soap, (const struct _tds__DeleteUsers *)ptr);
		break;
	case SOAP_TYPE__tds__CreateUsersResponse:
		soap_serialize__tds__CreateUsersResponse(soap, (const struct _tds__CreateUsersResponse *)ptr);
		break;
	case SOAP_TYPE__tds__CreateUsers:
		soap_serialize__tds__CreateUsers(soap, (const struct _tds__CreateUsers *)ptr);
		break;
	case SOAP_TYPE__tds__GetUsersResponse:
		soap_serialize__tds__GetUsersResponse(soap, (const struct _tds__GetUsersResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetUsers:
		soap_serialize__tds__GetUsers(soap, (const struct _tds__GetUsers *)ptr);
		break;
	case SOAP_TYPE__tds__SetDiscoveryModeResponse:
		soap_serialize__tds__SetDiscoveryModeResponse(soap, (const struct _tds__SetDiscoveryModeResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetDiscoveryMode:
		soap_serialize__tds__SetDiscoveryMode(soap, (const struct _tds__SetDiscoveryMode *)ptr);
		break;
	case SOAP_TYPE__tds__GetDiscoveryModeResponse:
		soap_serialize__tds__GetDiscoveryModeResponse(soap, (const struct _tds__GetDiscoveryModeResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetDiscoveryMode:
		soap_serialize__tds__GetDiscoveryMode(soap, (const struct _tds__GetDiscoveryMode *)ptr);
		break;
	case SOAP_TYPE__tds__RemoveScopesResponse:
		soap_serialize__tds__RemoveScopesResponse(soap, (const struct _tds__RemoveScopesResponse *)ptr);
		break;
	case SOAP_TYPE__tds__RemoveScopes:
		soap_serialize__tds__RemoveScopes(soap, (const struct _tds__RemoveScopes *)ptr);
		break;
	case SOAP_TYPE__tds__AddScopesResponse:
		soap_serialize__tds__AddScopesResponse(soap, (const struct _tds__AddScopesResponse *)ptr);
		break;
	case SOAP_TYPE__tds__AddScopes:
		soap_serialize__tds__AddScopes(soap, (const struct _tds__AddScopes *)ptr);
		break;
	case SOAP_TYPE__tds__SetScopesResponse:
		soap_serialize__tds__SetScopesResponse(soap, (const struct _tds__SetScopesResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetScopes:
		soap_serialize__tds__SetScopes(soap, (const struct _tds__SetScopes *)ptr);
		break;
	case SOAP_TYPE__tds__GetScopesResponse:
		soap_serialize__tds__GetScopesResponse(soap, (const struct _tds__GetScopesResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetScopes:
		soap_serialize__tds__GetScopes(soap, (const struct _tds__GetScopes *)ptr);
		break;
	case SOAP_TYPE__tds__GetSystemLogResponse:
		soap_serialize__tds__GetSystemLogResponse(soap, (const struct _tds__GetSystemLogResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetSystemLog:
		soap_serialize__tds__GetSystemLog(soap, (const struct _tds__GetSystemLog *)ptr);
		break;
	case SOAP_TYPE__tds__SystemRebootResponse:
		soap_serialize__tds__SystemRebootResponse(soap, (const struct _tds__SystemRebootResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SystemReboot:
		soap_serialize__tds__SystemReboot(soap, (const struct _tds__SystemReboot *)ptr);
		break;
	case SOAP_TYPE__tds__SetSystemFactoryDefaultResponse:
		soap_serialize__tds__SetSystemFactoryDefaultResponse(soap, (const struct _tds__SetSystemFactoryDefaultResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetSystemFactoryDefault:
		soap_serialize__tds__SetSystemFactoryDefault(soap, (const struct _tds__SetSystemFactoryDefault *)ptr);
		break;
	case SOAP_TYPE__tds__GetSystemDateAndTimeResponse:
		soap_serialize__tds__GetSystemDateAndTimeResponse(soap, (const struct _tds__GetSystemDateAndTimeResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetSystemDateAndTime:
		soap_serialize__tds__GetSystemDateAndTime(soap, (const struct _tds__GetSystemDateAndTime *)ptr);
		break;
	case SOAP_TYPE__tds__SetSystemDateAndTimeResponse:
		soap_serialize__tds__SetSystemDateAndTimeResponse(soap, (const struct _tds__SetSystemDateAndTimeResponse *)ptr);
		break;
	case SOAP_TYPE__tds__SetSystemDateAndTime:
		soap_serialize__tds__SetSystemDateAndTime(soap, (const struct _tds__SetSystemDateAndTime *)ptr);
		break;
	case SOAP_TYPE__tds__GetDeviceInformationResponse:
		soap_serialize__tds__GetDeviceInformationResponse(soap, (const struct _tds__GetDeviceInformationResponse *)ptr);
		break;
	case SOAP_TYPE__tds__GetDeviceInformation:
		soap_serialize__tds__GetDeviceInformation(soap, (const struct _tds__GetDeviceInformation *)ptr);
		break;
	case SOAP_TYPE_tnsacti__IO:
		soap_serialize_tnsacti__IO(soap, (const struct tnsacti__IO *)ptr);
		break;
	case SOAP_TYPE_tnsacti__MotionDetection:
		soap_serialize_tnsacti__MotionDetection(soap, (const struct tnsacti__MotionDetection *)ptr);
		break;
	case SOAP_TYPE_tnsacti__VirtualPort:
		soap_serialize_tnsacti__VirtualPort(soap, (const struct tnsacti__VirtualPort *)ptr);
		break;
	case SOAP_TYPE_tns1__Device:
		soap_serialize_tns1__Device(soap, (const struct tns1__Device *)ptr);
		break;
	case SOAP_TYPE_tns1__VideoAnalytics:
		soap_serialize_tns1__VideoAnalytics(soap, (const struct tns1__VideoAnalytics *)ptr);
		break;
	case SOAP_TYPE__tt__Message:
		soap_serialize__tt__Message(soap, (const struct _tt__Message *)ptr);
		break;
	case SOAP_TYPE_tt__EventStream:
		soap_serialize_tt__EventStream(soap, (const struct tt__EventStream *)ptr);
		break;
	case SOAP_TYPE_tt__Rectangle:
		soap_serialize_tt__Rectangle(soap, (const struct tt__Rectangle *)ptr);
		break;
	case SOAP_TYPE_tt__ItemListDescription:
		soap_serialize_tt__ItemListDescription(soap, (const struct tt__ItemListDescription *)ptr);
		break;
	case SOAP_TYPE_tt__MessageDescription:
		soap_serialize_tt__MessageDescription(soap, (const struct tt__MessageDescription *)ptr);
		break;
	case SOAP_TYPE_tt__ItemList:
		soap_serialize_tt__ItemList(soap, (const struct tt__ItemList *)ptr);
		break;
	case SOAP_TYPE_tt__WhiteBalance:
		soap_serialize_tt__WhiteBalance(soap, (const struct tt__WhiteBalance *)ptr);
		break;
	case SOAP_TYPE_tt__WhiteBalanceOptions:
		soap_serialize_tt__WhiteBalanceOptions(soap, (const struct tt__WhiteBalanceOptions *)ptr);
		break;
	case SOAP_TYPE_tt__ExposureOptions:
		soap_serialize_tt__ExposureOptions(soap, (const struct tt__ExposureOptions *)ptr);
		break;
	case SOAP_TYPE_tt__FocusOptions:
		soap_serialize_tt__FocusOptions(soap, (const struct tt__FocusOptions *)ptr);
		break;
	case SOAP_TYPE_tt__BacklightCompensationOptions:
		soap_serialize_tt__BacklightCompensationOptions(soap, (const struct tt__BacklightCompensationOptions *)ptr);
		break;
	case SOAP_TYPE_tt__WideDynamicRangeOptions:
		soap_serialize_tt__WideDynamicRangeOptions(soap, (const struct tt__WideDynamicRangeOptions *)ptr);
		break;
	case SOAP_TYPE_tt__ImagingOptions:
		soap_serialize_tt__ImagingOptions(soap, (const struct tt__ImagingOptions *)ptr);
		break;
	case SOAP_TYPE_tt__BacklightCompensation:
		soap_serialize_tt__BacklightCompensation(soap, (const struct tt__BacklightCompensation *)ptr);
		break;
	case SOAP_TYPE_tt__WideDynamicRange:
		soap_serialize_tt__WideDynamicRange(soap, (const struct tt__WideDynamicRange *)ptr);
		break;
	case SOAP_TYPE_tt__Exposure:
		soap_serialize_tt__Exposure(soap, (const struct tt__Exposure *)ptr);
		break;
	case SOAP_TYPE_tt__ImagingSettings:
		soap_serialize_tt__ImagingSettings(soap, (const struct tt__ImagingSettings *)ptr);
		break;
	case SOAP_TYPE_tt__FocusConfiguration:
		soap_serialize_tt__FocusConfiguration(soap, (const struct tt__FocusConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__PTZMoveStatus:
		soap_serialize_tt__PTZMoveStatus(soap, (const struct tt__PTZMoveStatus *)ptr);
		break;
	case SOAP_TYPE_tt__PTZPreset:
		soap_serialize_tt__PTZPreset(soap, (const struct tt__PTZPreset *)ptr);
		break;
	case SOAP_TYPE_tt__Preset:
		soap_serialize_tt__Preset(soap, (const struct tt__Preset *)ptr);
		break;
	case SOAP_TYPE_tt__PTZStatus:
		soap_serialize_tt__PTZStatus(soap, (const struct tt__PTZStatus *)ptr);
		break;
	case SOAP_TYPE_tt__PTZSpeed:
		soap_serialize_tt__PTZSpeed(soap, (const struct tt__PTZSpeed *)ptr);
		break;
	case SOAP_TYPE_tt__PTZVector:
		soap_serialize_tt__PTZVector(soap, (const struct tt__PTZVector *)ptr);
		break;
	case SOAP_TYPE_tt__Vector1D:
		soap_serialize_tt__Vector1D(soap, (const struct tt__Vector1D *)ptr);
		break;
	case SOAP_TYPE_tt__Vector2D:
		soap_serialize_tt__Vector2D(soap, (const struct tt__Vector2D *)ptr);
		break;
	case SOAP_TYPE_tt__Space1DDescription:
		soap_serialize_tt__Space1DDescription(soap, (const struct tt__Space1DDescription *)ptr);
		break;
	case SOAP_TYPE_tt__Space2DDescription:
		soap_serialize_tt__Space2DDescription(soap, (const struct tt__Space2DDescription *)ptr);
		break;
	case SOAP_TYPE_tt__PTZSpaces:
		soap_serialize_tt__PTZSpaces(soap, (const struct tt__PTZSpaces *)ptr);
		break;
	case SOAP_TYPE_tt__ZoomLimits:
		soap_serialize_tt__ZoomLimits(soap, (const struct tt__ZoomLimits *)ptr);
		break;
	case SOAP_TYPE_tt__PanTiltLimits:
		soap_serialize_tt__PanTiltLimits(soap, (const struct tt__PanTiltLimits *)ptr);
		break;
	case SOAP_TYPE_tt__PTZConfigurationOptions:
		soap_serialize_tt__PTZConfigurationOptions(soap, (const struct tt__PTZConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE_tt__PTZConfiguration:
		soap_serialize_tt__PTZConfiguration(soap, (const struct tt__PTZConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__PTZNode:
		soap_serialize_tt__PTZNode(soap, (const struct tt__PTZNode *)ptr);
		break;
	case SOAP_TYPE_tt__RelayOutput:
		soap_serialize_tt__RelayOutput(soap, (const struct tt__RelayOutput *)ptr);
		break;
	case SOAP_TYPE_tt__RelayOutputSettings:
		soap_serialize_tt__RelayOutputSettings(soap, (const struct tt__RelayOutputSettings *)ptr);
		break;
	case SOAP_TYPE_tt__User:
		soap_serialize_tt__User(soap, (const struct tt__User *)ptr);
		break;
	case SOAP_TYPE_tt__TimeZone:
		soap_serialize_tt__TimeZone(soap, (const struct tt__TimeZone *)ptr);
		break;
	case SOAP_TYPE_tt__Time:
		soap_serialize_tt__Time(soap, (const struct tt__Time *)ptr);
		break;
	case SOAP_TYPE_tt__Date:
		soap_serialize_tt__Date(soap, (const struct tt__Date *)ptr);
		break;
	case SOAP_TYPE_tt__DateTime:
		soap_serialize_tt__DateTime(soap, (const struct tt__DateTime *)ptr);
		break;
	case SOAP_TYPE_tt__SystemDateTime:
		soap_serialize_tt__SystemDateTime(soap, (const struct tt__SystemDateTime *)ptr);
		break;
	case SOAP_TYPE_tt__SystemLog:
		soap_serialize_tt__SystemLog(soap, (const struct tt__SystemLog *)ptr);
		break;
	case SOAP_TYPE_tt__AnalyticsDeviceCapabilities:
		soap_serialize_tt__AnalyticsDeviceCapabilities(soap, (const struct tt__AnalyticsDeviceCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__ReceiverCapabilities:
		soap_serialize_tt__ReceiverCapabilities(soap, (const struct tt__ReceiverCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__ReplayCapabilities:
		soap_serialize_tt__ReplayCapabilities(soap, (const struct tt__ReplayCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__SearchCapabilities:
		soap_serialize_tt__SearchCapabilities(soap, (const struct tt__SearchCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__RecordingCapabilities:
		soap_serialize_tt__RecordingCapabilities(soap, (const struct tt__RecordingCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__DisplayCapabilities:
		soap_serialize_tt__DisplayCapabilities(soap, (const struct tt__DisplayCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__DeviceIOCapabilities:
		soap_serialize_tt__DeviceIOCapabilities(soap, (const struct tt__DeviceIOCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__PTZCapabilities:
		soap_serialize_tt__PTZCapabilities(soap, (const struct tt__PTZCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__ImagingCapabilities:
		soap_serialize_tt__ImagingCapabilities(soap, (const struct tt__ImagingCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__OnvifVersion:
		soap_serialize_tt__OnvifVersion(soap, (const struct tt__OnvifVersion *)ptr);
		break;
	case SOAP_TYPE_tt__SystemCapabilities:
		soap_serialize_tt__SystemCapabilities(soap, (const struct tt__SystemCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__SecurityCapabilities:
		soap_serialize_tt__SecurityCapabilities(soap, (const struct tt__SecurityCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkCapabilities:
		soap_serialize_tt__NetworkCapabilities(soap, (const struct tt__NetworkCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__ProfileCapabilities:
		soap_serialize_tt__ProfileCapabilities(soap, (const struct tt__ProfileCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__RealTimeStreamingCapabilities:
		soap_serialize_tt__RealTimeStreamingCapabilities(soap, (const struct tt__RealTimeStreamingCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__MediaCapabilities:
		soap_serialize_tt__MediaCapabilities(soap, (const struct tt__MediaCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__IOCapabilities:
		soap_serialize_tt__IOCapabilities(soap, (const struct tt__IOCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__EventCapabilities:
		soap_serialize_tt__EventCapabilities(soap, (const struct tt__EventCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__DeviceCapabilities:
		soap_serialize_tt__DeviceCapabilities(soap, (const struct tt__DeviceCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__AnalyticsCapabilities:
		soap_serialize_tt__AnalyticsCapabilities(soap, (const struct tt__AnalyticsCapabilities *)ptr);
		break;
	case SOAP_TYPE_tt__CapabilitiesExtension:
		soap_serialize_tt__CapabilitiesExtension(soap, (const struct tt__CapabilitiesExtension *)ptr);
		break;
	case SOAP_TYPE_tt__Capabilities:
		soap_serialize_tt__Capabilities(soap, (const struct tt__Capabilities *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkZeroConfiguration:
		soap_serialize_tt__NetworkZeroConfiguration(soap, (const struct tt__NetworkZeroConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkGateway:
		soap_serialize_tt__NetworkGateway(soap, (const struct tt__NetworkGateway *)ptr);
		break;
	case SOAP_TYPE_tt__IPv4NetworkInterfaceSetConfiguration:
		soap_serialize_tt__IPv4NetworkInterfaceSetConfiguration(soap, (const struct tt__IPv4NetworkInterfaceSetConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkInterfaceSetConfigurationExtension:
		soap_serialize_tt__NetworkInterfaceSetConfigurationExtension(soap, (const struct tt__NetworkInterfaceSetConfigurationExtension *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkInterfaceSetConfiguration:
		soap_serialize_tt__NetworkInterfaceSetConfiguration(soap, (const struct tt__NetworkInterfaceSetConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__DynamicDNSInformation:
		soap_serialize_tt__DynamicDNSInformation(soap, (const struct tt__DynamicDNSInformation *)ptr);
		break;
	case SOAP_TYPE_tt__NTPInformation:
		soap_serialize_tt__NTPInformation(soap, (const struct tt__NTPInformation *)ptr);
		break;
	case SOAP_TYPE_tt__DNSInformation:
		soap_serialize_tt__DNSInformation(soap, (const struct tt__DNSInformation *)ptr);
		break;
	case SOAP_TYPE_tt__HostnameInformation:
		soap_serialize_tt__HostnameInformation(soap, (const struct tt__HostnameInformation *)ptr);
		break;
	case SOAP_TYPE_tt__PrefixedIPv4Address:
		soap_serialize_tt__PrefixedIPv4Address(soap, (const struct tt__PrefixedIPv4Address *)ptr);
		break;
	case SOAP_TYPE_tt__IPAddress:
		soap_serialize_tt__IPAddress(soap, (const struct tt__IPAddress *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkHost:
		soap_serialize_tt__NetworkHost(soap, (const struct tt__NetworkHost *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkProtocol:
		soap_serialize_tt__NetworkProtocol(soap, (const struct tt__NetworkProtocol *)ptr);
		break;
	case SOAP_TYPE_tt__IPv4Configuration:
		soap_serialize_tt__IPv4Configuration(soap, (const struct tt__IPv4Configuration *)ptr);
		break;
	case SOAP_TYPE_tt__IPv4NetworkInterface:
		soap_serialize_tt__IPv4NetworkInterface(soap, (const struct tt__IPv4NetworkInterface *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkInterfaceInfo:
		soap_serialize_tt__NetworkInterfaceInfo(soap, (const struct tt__NetworkInterfaceInfo *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkInterfaceConnectionSetting:
		soap_serialize_tt__NetworkInterfaceConnectionSetting(soap, (const struct tt__NetworkInterfaceConnectionSetting *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkInterfaceLink:
		soap_serialize_tt__NetworkInterfaceLink(soap, (const struct tt__NetworkInterfaceLink *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkInterfaceExtension2:
		soap_serialize_tt__NetworkInterfaceExtension2(soap, (const struct tt__NetworkInterfaceExtension2 *)ptr);
		break;
	case SOAP_TYPE_tt__Dot3Configuration:
		soap_serialize_tt__Dot3Configuration(soap, (const struct tt__Dot3Configuration *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkInterfaceExtension:
		soap_serialize_tt__NetworkInterfaceExtension(soap, (const struct tt__NetworkInterfaceExtension *)ptr);
		break;
	case SOAP_TYPE_tt__NetworkInterface:
		soap_serialize_tt__NetworkInterface(soap, (const struct tt__NetworkInterface *)ptr);
		break;
	case SOAP_TYPE_tt__Scope:
		soap_serialize_tt__Scope(soap, (const struct tt__Scope *)ptr);
		break;
	case SOAP_TYPE_tt__MediaUri:
		soap_serialize_tt__MediaUri(soap, (const struct tt__MediaUri *)ptr);
		break;
	case SOAP_TYPE_tt__Transport:
		soap_serialize_tt__Transport(soap, (const struct tt__Transport *)ptr);
		break;
	case SOAP_TYPE_tt__StreamSetup:
		soap_serialize_tt__StreamSetup(soap, (const struct tt__StreamSetup *)ptr);
		break;
	case SOAP_TYPE_tt__MulticastConfiguration:
		soap_serialize_tt__MulticastConfiguration(soap, (const struct tt__MulticastConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__PTZStatusFilterOptions:
		soap_serialize_tt__PTZStatusFilterOptions(soap, (const struct tt__PTZStatusFilterOptions *)ptr);
		break;
	case SOAP_TYPE_tt__MetadataConfigurationOptions:
		soap_serialize_tt__MetadataConfigurationOptions(soap, (const struct tt__MetadataConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE_tt__EventSubscription:
		soap_serialize_tt__EventSubscription(soap, (const struct tt__EventSubscription *)ptr);
		break;
	case SOAP_TYPE_tt__MetadataConfiguration:
		soap_serialize_tt__MetadataConfiguration(soap, (const struct tt__MetadataConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__AudioEncoderConfigurationOption:
		soap_serialize_tt__AudioEncoderConfigurationOption(soap, (const struct tt__AudioEncoderConfigurationOption *)ptr);
		break;
	case SOAP_TYPE_tt__AudioEncoderConfigurationOptions:
		soap_serialize_tt__AudioEncoderConfigurationOptions(soap, (const struct tt__AudioEncoderConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE_tt__AudioEncoderConfiguration:
		soap_serialize_tt__AudioEncoderConfiguration(soap, (const struct tt__AudioEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__AudioSourceConfigurationOptions:
		soap_serialize_tt__AudioSourceConfigurationOptions(soap, (const struct tt__AudioSourceConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE_tt__AudioSourceConfiguration:
		soap_serialize_tt__AudioSourceConfiguration(soap, (const struct tt__AudioSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__H264Options:
		soap_serialize_tt__H264Options(soap, (const struct tt__H264Options *)ptr);
		break;
	case SOAP_TYPE_tt__Mpeg4Options:
		soap_serialize_tt__Mpeg4Options(soap, (const struct tt__Mpeg4Options *)ptr);
		break;
	case SOAP_TYPE_tt__JpegOptions:
		soap_serialize_tt__JpegOptions(soap, (const struct tt__JpegOptions *)ptr);
		break;
	case SOAP_TYPE_tt__VideoEncoderConfigurationOptions:
		soap_serialize_tt__VideoEncoderConfigurationOptions(soap, (const struct tt__VideoEncoderConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE_tt__H264Configuration:
		soap_serialize_tt__H264Configuration(soap, (const struct tt__H264Configuration *)ptr);
		break;
	case SOAP_TYPE_tt__Mpeg4Configuration:
		soap_serialize_tt__Mpeg4Configuration(soap, (const struct tt__Mpeg4Configuration *)ptr);
		break;
	case SOAP_TYPE_tt__VideoRateControl:
		soap_serialize_tt__VideoRateControl(soap, (const struct tt__VideoRateControl *)ptr);
		break;
	case SOAP_TYPE_tt__VideoResolution:
		soap_serialize_tt__VideoResolution(soap, (const struct tt__VideoResolution *)ptr);
		break;
	case SOAP_TYPE_tt__VideoEncoderConfiguration:
		soap_serialize_tt__VideoEncoderConfiguration(soap, (const struct tt__VideoEncoderConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__VideoSourceConfigurationOptions:
		soap_serialize_tt__VideoSourceConfigurationOptions(soap, (const struct tt__VideoSourceConfigurationOptions *)ptr);
		break;
	case SOAP_TYPE_tt__VideoSourceConfiguration:
		soap_serialize_tt__VideoSourceConfiguration(soap, (const struct tt__VideoSourceConfiguration *)ptr);
		break;
	case SOAP_TYPE_tt__ConfigurationEntity:
		soap_serialize_tt__ConfigurationEntity(soap, (const struct tt__ConfigurationEntity *)ptr);
		break;
	case SOAP_TYPE_tt__Profile:
		soap_serialize_tt__Profile(soap, (const struct tt__Profile *)ptr);
		break;
	case SOAP_TYPE_tt__AudioSource:
		soap_serialize_tt__AudioSource(soap, (const struct tt__AudioSource *)ptr);
		break;
	case SOAP_TYPE_tt__VideoSource:
		soap_serialize_tt__VideoSource(soap, (const struct tt__VideoSource *)ptr);
		break;
	case SOAP_TYPE_tt__IntList:
		soap_serialize_tt__IntList(soap, (const struct tt__IntList *)ptr);
		break;
	case SOAP_TYPE_tt__DurationRange:
		soap_serialize_tt__DurationRange(soap, (const struct tt__DurationRange *)ptr);
		break;
	case SOAP_TYPE_tt__FloatRange:
		soap_serialize_tt__FloatRange(soap, (const struct tt__FloatRange *)ptr);
		break;
	case SOAP_TYPE_tt__IntRange:
		soap_serialize_tt__IntRange(soap, (const struct tt__IntRange *)ptr);
		break;
	case SOAP_TYPE_tt__IntRectangleRange:
		soap_serialize_tt__IntRectangleRange(soap, (const struct tt__IntRectangleRange *)ptr);
		break;
	case SOAP_TYPE_tt__IntRectangle:
		soap_serialize_tt__IntRectangle(soap, (const struct tt__IntRectangle *)ptr);
		break;
	case SOAP_TYPE_tt__DeviceEntity:
		soap_serialize_tt__DeviceEntity(soap, (const struct tt__DeviceEntity *)ptr);
		break;
	case SOAP_TYPE_wsr__ResourceUnknownFaultType:
		soap_serialize_wsr__ResourceUnknownFaultType(soap, (const struct wsr__ResourceUnknownFaultType *)ptr);
		break;
	case SOAP_TYPE_wstop__TopicSetType:
		soap_serialize_wstop__TopicSetType(soap, (const struct wstop__TopicSetType *)ptr);
		break;
	case SOAP_TYPE_wstop__QueryExpressionType:
		soap_serialize_wstop__QueryExpressionType(soap, (const struct wstop__QueryExpressionType *)ptr);
		break;
	case SOAP_TYPE_wstop__ExtensibleDocumented:
		soap_serialize_wstop__ExtensibleDocumented(soap, (const struct wstop__ExtensibleDocumented *)ptr);
		break;
	case SOAP_TYPE_wstop__Documentation:
		soap_serialize_wstop__Documentation(soap, (const struct wstop__Documentation *)ptr);
		break;
	case SOAP_TYPE_wsa__AttributedURIType:
		soap_serialize_wsa__AttributedURIType(soap, (const struct wsa__AttributedURIType *)ptr);
		break;
	case SOAP_TYPE_wsa__RelatesToType:
		soap_serialize_wsa__RelatesToType(soap, (const struct wsa__RelatesToType *)ptr);
		break;
	case SOAP_TYPE_wsa__MetadataType:
		soap_serialize_wsa__MetadataType(soap, (const struct wsa__MetadataType *)ptr);
		break;
	case SOAP_TYPE_wsa__ReferenceParametersType:
		soap_serialize_wsa__ReferenceParametersType(soap, (const struct wsa__ReferenceParametersType *)ptr);
		break;
	case SOAP_TYPE_wsa__EndpointReferenceType:
		soap_serialize_wsa__EndpointReferenceType(soap, (const struct wsa__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE_wsbf__BaseFaultType:
		soap_serialize_wsbf__BaseFaultType(soap, (const struct wsbf__BaseFaultType *)ptr);
		break;
	case SOAP_TYPE__wsnt__UnsubscribeResponse:
		soap_serialize__wsnt__UnsubscribeResponse(soap, (const struct _wsnt__UnsubscribeResponse *)ptr);
		break;
	case SOAP_TYPE__wsnt__Unsubscribe:
		soap_serialize__wsnt__Unsubscribe(soap, (const struct _wsnt__Unsubscribe *)ptr);
		break;
	case SOAP_TYPE__wsnt__RenewResponse:
		soap_serialize__wsnt__RenewResponse(soap, (const struct _wsnt__RenewResponse *)ptr);
		break;
	case SOAP_TYPE__wsnt__Renew:
		soap_serialize__wsnt__Renew(soap, (const struct _wsnt__Renew *)ptr);
		break;
	case SOAP_TYPE__wsnt__SubscribeResponse:
		soap_serialize__wsnt__SubscribeResponse(soap, (const struct _wsnt__SubscribeResponse *)ptr);
		break;
	case SOAP_TYPE__wsnt__Subscribe:
		soap_serialize__wsnt__Subscribe(soap, (const struct _wsnt__Subscribe *)ptr);
		break;
	case SOAP_TYPE__wsnt__Notify:
		soap_serialize__wsnt__Notify(soap, (const struct _wsnt__Notify *)ptr);
		break;
	case SOAP_TYPE_wsnt__UnableToDestroySubscriptionFaultType:
		soap_serialize_wsnt__UnableToDestroySubscriptionFaultType(soap, (const struct wsnt__UnableToDestroySubscriptionFaultType *)ptr);
		break;
	case SOAP_TYPE_wsnt__NotificationMessageHolderType:
		soap_serialize_wsnt__NotificationMessageHolderType(soap, (const struct wsnt__NotificationMessageHolderType *)ptr);
		break;
	case SOAP_TYPE_wsnt__FilterType:
		soap_serialize_wsnt__FilterType(soap, (const struct wsnt__FilterType *)ptr);
		break;
	case SOAP_TYPE_wsnt__TopicExpressionType:
		soap_serialize_wsnt__TopicExpressionType(soap, (const struct wsnt__TopicExpressionType *)ptr);
		break;
	case SOAP_TYPE_wsnt__QueryExpressionType:
		soap_serialize_wsnt__QueryExpressionType(soap, (const struct wsnt__QueryExpressionType *)ptr);
		break;
	case SOAP_TYPE_wsadis__AttributedURI:
		soap_serialize_wsadis__AttributedURI(soap, (const struct wsadis__AttributedURI *)ptr);
		break;
	case SOAP_TYPE_wsadis__AttributedQName:
		soap_serialize_wsadis__AttributedQName(soap, (const struct wsadis__AttributedQName *)ptr);
		break;
	case SOAP_TYPE_wsadis__Relationship:
		soap_serialize_wsadis__Relationship(soap, (const struct wsadis__Relationship *)ptr);
		break;
	case SOAP_TYPE_wsadis__ServiceNameType:
		soap_serialize_wsadis__ServiceNameType(soap, (const struct wsadis__ServiceNameType *)ptr);
		break;
	case SOAP_TYPE_wsadis__ReferenceParametersType:
		soap_serialize_wsadis__ReferenceParametersType(soap, (const struct wsadis__ReferenceParametersType *)ptr);
		break;
	case SOAP_TYPE_wsadis__ReferencePropertiesType:
		soap_serialize_wsadis__ReferencePropertiesType(soap, (const struct wsadis__ReferencePropertiesType *)ptr);
		break;
	case SOAP_TYPE_wsadis__EndpointReferenceType:
		soap_serialize_wsadis__EndpointReferenceType(soap, (const struct wsadis__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsse__Security:
		soap_serialize_PointerTo_wsse__Security(soap, (struct wsse__SecurityHeaderType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_d__AppSequence:
		soap_serialize_PointerTo_d__AppSequence(soap, (struct d__AppSequenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa__FaultTo:
		soap_serialize_PointerTo_wsa__FaultTo(soap, (struct wsa__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa__ReplyTo:
		soap_serialize_PointerTo_wsa__ReplyTo(soap, (struct wsa__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa__From:
		soap_serialize_PointerTo_wsa__From(soap, (struct wsa__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa__RelatesTo:
		soap_serialize_PointerTo_wsa__RelatesTo(soap, (struct wsa__RelatesToType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetSnapshotUriResponse:
		soap_serialize_PointerTo_trt__GetSnapshotUriResponse(soap, (struct _trt__GetSnapshotUriResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetSnapshotUri:
		soap_serialize_PointerTo_trt__GetSnapshotUri(soap, (struct _trt__GetSnapshotUri *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetSynchronizationPointResponse:
		soap_serialize_PointerTo_trt__SetSynchronizationPointResponse(soap, (struct _trt__SetSynchronizationPointResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetSynchronizationPoint:
		soap_serialize_PointerTo_trt__SetSynchronizationPoint(soap, (struct _trt__SetSynchronizationPoint *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetStreamUriResponse:
		soap_serialize_PointerTo_trt__GetStreamUriResponse(soap, (struct _trt__GetStreamUriResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetStreamUri:
		soap_serialize_PointerTo_trt__GetStreamUri(soap, (struct _trt__GetStreamUri *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse:
		soap_serialize_PointerTo_trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse(soap, (struct _trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetGuaranteedNumberOfVideoEncoderInstances:
		soap_serialize_PointerTo_trt__GetGuaranteedNumberOfVideoEncoderInstances(soap, (struct _trt__GetGuaranteedNumberOfVideoEncoderInstances *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfigurationOptionsResponse:
		soap_serialize_PointerTo_trt__GetMetadataConfigurationOptionsResponse(soap, (struct _trt__GetMetadataConfigurationOptionsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfigurationOptions:
		soap_serialize_PointerTo_trt__GetMetadataConfigurationOptions(soap, (struct _trt__GetMetadataConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationOptionsResponse:
		soap_serialize_PointerTo_trt__GetAudioEncoderConfigurationOptionsResponse(soap, (struct _trt__GetAudioEncoderConfigurationOptionsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationOptions:
		soap_serialize_PointerTo_trt__GetAudioEncoderConfigurationOptions(soap, (struct _trt__GetAudioEncoderConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationOptionsResponse:
		soap_serialize_PointerTo_trt__GetAudioSourceConfigurationOptionsResponse(soap, (struct _trt__GetAudioSourceConfigurationOptionsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationOptions:
		soap_serialize_PointerTo_trt__GetAudioSourceConfigurationOptions(soap, (struct _trt__GetAudioSourceConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationOptionsResponse:
		soap_serialize_PointerTo_trt__GetVideoEncoderConfigurationOptionsResponse(soap, (struct _trt__GetVideoEncoderConfigurationOptionsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationOptions:
		soap_serialize_PointerTo_trt__GetVideoEncoderConfigurationOptions(soap, (struct _trt__GetVideoEncoderConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationOptionsResponse:
		soap_serialize_PointerTo_trt__GetVideoSourceConfigurationOptionsResponse(soap, (struct _trt__GetVideoSourceConfigurationOptionsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationOptions:
		soap_serialize_PointerTo_trt__GetVideoSourceConfigurationOptions(soap, (struct _trt__GetVideoSourceConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetMetadataConfigurationResponse:
		soap_serialize_PointerTo_trt__SetMetadataConfigurationResponse(soap, (struct _trt__SetMetadataConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetMetadataConfiguration:
		soap_serialize_PointerTo_trt__SetMetadataConfiguration(soap, (struct _trt__SetMetadataConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetAudioEncoderConfigurationResponse:
		soap_serialize_PointerTo_trt__SetAudioEncoderConfigurationResponse(soap, (struct _trt__SetAudioEncoderConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetAudioEncoderConfiguration:
		soap_serialize_PointerTo_trt__SetAudioEncoderConfiguration(soap, (struct _trt__SetAudioEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetAudioSourceConfigurationResponse:
		soap_serialize_PointerTo_trt__SetAudioSourceConfigurationResponse(soap, (struct _trt__SetAudioSourceConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetAudioSourceConfiguration:
		soap_serialize_PointerTo_trt__SetAudioSourceConfiguration(soap, (struct _trt__SetAudioSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetVideoEncoderConfigurationResponse:
		soap_serialize_PointerTo_trt__SetVideoEncoderConfigurationResponse(soap, (struct _trt__SetVideoEncoderConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetVideoEncoderConfiguration:
		soap_serialize_PointerTo_trt__SetVideoEncoderConfiguration(soap, (struct _trt__SetVideoEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetVideoSourceConfigurationResponse:
		soap_serialize_PointerTo_trt__SetVideoSourceConfigurationResponse(soap, (struct _trt__SetVideoSourceConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__SetVideoSourceConfiguration:
		soap_serialize_PointerTo_trt__SetVideoSourceConfiguration(soap, (struct _trt__SetVideoSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleMetadataConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetCompatibleMetadataConfigurationsResponse(soap, (struct _trt__GetCompatibleMetadataConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleMetadataConfigurations:
		soap_serialize_PointerTo_trt__GetCompatibleMetadataConfigurations(soap, (struct _trt__GetCompatibleMetadataConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioSourceConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetCompatibleAudioSourceConfigurationsResponse(soap, (struct _trt__GetCompatibleAudioSourceConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioSourceConfigurations:
		soap_serialize_PointerTo_trt__GetCompatibleAudioSourceConfigurations(soap, (struct _trt__GetCompatibleAudioSourceConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioEncoderConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, (struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleAudioEncoderConfigurations:
		soap_serialize_PointerTo_trt__GetCompatibleAudioEncoderConfigurations(soap, (struct _trt__GetCompatibleAudioEncoderConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoSourceConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetCompatibleVideoSourceConfigurationsResponse(soap, (struct _trt__GetCompatibleVideoSourceConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoSourceConfigurations:
		soap_serialize_PointerTo_trt__GetCompatibleVideoSourceConfigurations(soap, (struct _trt__GetCompatibleVideoSourceConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoEncoderConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, (struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetCompatibleVideoEncoderConfigurations:
		soap_serialize_PointerTo_trt__GetCompatibleVideoEncoderConfigurations(soap, (struct _trt__GetCompatibleVideoEncoderConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfigurationResponse:
		soap_serialize_PointerTo_trt__GetMetadataConfigurationResponse(soap, (struct _trt__GetMetadataConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfiguration:
		soap_serialize_PointerTo_trt__GetMetadataConfiguration(soap, (struct _trt__GetMetadataConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationResponse:
		soap_serialize_PointerTo_trt__GetAudioEncoderConfigurationResponse(soap, (struct _trt__GetAudioEncoderConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfiguration:
		soap_serialize_PointerTo_trt__GetAudioEncoderConfiguration(soap, (struct _trt__GetAudioEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationResponse:
		soap_serialize_PointerTo_trt__GetAudioSourceConfigurationResponse(soap, (struct _trt__GetAudioSourceConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfiguration:
		soap_serialize_PointerTo_trt__GetAudioSourceConfiguration(soap, (struct _trt__GetAudioSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationResponse:
		soap_serialize_PointerTo_trt__GetVideoEncoderConfigurationResponse(soap, (struct _trt__GetVideoEncoderConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfiguration:
		soap_serialize_PointerTo_trt__GetVideoEncoderConfiguration(soap, (struct _trt__GetVideoEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationResponse:
		soap_serialize_PointerTo_trt__GetVideoSourceConfigurationResponse(soap, (struct _trt__GetVideoSourceConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfiguration:
		soap_serialize_PointerTo_trt__GetVideoSourceConfiguration(soap, (struct _trt__GetVideoSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetMetadataConfigurationsResponse(soap, (struct _trt__GetMetadataConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetMetadataConfigurations:
		soap_serialize_PointerTo_trt__GetMetadataConfigurations(soap, (struct _trt__GetMetadataConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetAudioEncoderConfigurationsResponse(soap, (struct _trt__GetAudioEncoderConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioEncoderConfigurations:
		soap_serialize_PointerTo_trt__GetAudioEncoderConfigurations(soap, (struct _trt__GetAudioEncoderConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetAudioSourceConfigurationsResponse(soap, (struct _trt__GetAudioSourceConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioSourceConfigurations:
		soap_serialize_PointerTo_trt__GetAudioSourceConfigurations(soap, (struct _trt__GetAudioSourceConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetVideoEncoderConfigurationsResponse(soap, (struct _trt__GetVideoEncoderConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoEncoderConfigurations:
		soap_serialize_PointerTo_trt__GetVideoEncoderConfigurations(soap, (struct _trt__GetVideoEncoderConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurationsResponse:
		soap_serialize_PointerTo_trt__GetVideoSourceConfigurationsResponse(soap, (struct _trt__GetVideoSourceConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoSourceConfigurations:
		soap_serialize_PointerTo_trt__GetVideoSourceConfigurations(soap, (struct _trt__GetVideoSourceConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__DeleteProfileResponse:
		soap_serialize_PointerTo_trt__DeleteProfileResponse(soap, (struct _trt__DeleteProfileResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__DeleteProfile:
		soap_serialize_PointerTo_trt__DeleteProfile(soap, (struct _trt__DeleteProfile *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveMetadataConfigurationResponse:
		soap_serialize_PointerTo_trt__RemoveMetadataConfigurationResponse(soap, (struct _trt__RemoveMetadataConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveMetadataConfiguration:
		soap_serialize_PointerTo_trt__RemoveMetadataConfiguration(soap, (struct _trt__RemoveMetadataConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemovePTZConfigurationResponse:
		soap_serialize_PointerTo_trt__RemovePTZConfigurationResponse(soap, (struct _trt__RemovePTZConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemovePTZConfiguration:
		soap_serialize_PointerTo_trt__RemovePTZConfiguration(soap, (struct _trt__RemovePTZConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveAudioSourceConfigurationResponse:
		soap_serialize_PointerTo_trt__RemoveAudioSourceConfigurationResponse(soap, (struct _trt__RemoveAudioSourceConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveAudioSourceConfiguration:
		soap_serialize_PointerTo_trt__RemoveAudioSourceConfiguration(soap, (struct _trt__RemoveAudioSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveAudioEncoderConfigurationResponse:
		soap_serialize_PointerTo_trt__RemoveAudioEncoderConfigurationResponse(soap, (struct _trt__RemoveAudioEncoderConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveAudioEncoderConfiguration:
		soap_serialize_PointerTo_trt__RemoveAudioEncoderConfiguration(soap, (struct _trt__RemoveAudioEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveVideoSourceConfigurationResponse:
		soap_serialize_PointerTo_trt__RemoveVideoSourceConfigurationResponse(soap, (struct _trt__RemoveVideoSourceConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveVideoSourceConfiguration:
		soap_serialize_PointerTo_trt__RemoveVideoSourceConfiguration(soap, (struct _trt__RemoveVideoSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveVideoEncoderConfigurationResponse:
		soap_serialize_PointerTo_trt__RemoveVideoEncoderConfigurationResponse(soap, (struct _trt__RemoveVideoEncoderConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__RemoveVideoEncoderConfiguration:
		soap_serialize_PointerTo_trt__RemoveVideoEncoderConfiguration(soap, (struct _trt__RemoveVideoEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddMetadataConfigurationResponse:
		soap_serialize_PointerTo_trt__AddMetadataConfigurationResponse(soap, (struct _trt__AddMetadataConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddMetadataConfiguration:
		soap_serialize_PointerTo_trt__AddMetadataConfiguration(soap, (struct _trt__AddMetadataConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddPTZConfigurationResponse:
		soap_serialize_PointerTo_trt__AddPTZConfigurationResponse(soap, (struct _trt__AddPTZConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddPTZConfiguration:
		soap_serialize_PointerTo_trt__AddPTZConfiguration(soap, (struct _trt__AddPTZConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddAudioSourceConfigurationResponse:
		soap_serialize_PointerTo_trt__AddAudioSourceConfigurationResponse(soap, (struct _trt__AddAudioSourceConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddAudioSourceConfiguration:
		soap_serialize_PointerTo_trt__AddAudioSourceConfiguration(soap, (struct _trt__AddAudioSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddAudioEncoderConfigurationResponse:
		soap_serialize_PointerTo_trt__AddAudioEncoderConfigurationResponse(soap, (struct _trt__AddAudioEncoderConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddAudioEncoderConfiguration:
		soap_serialize_PointerTo_trt__AddAudioEncoderConfiguration(soap, (struct _trt__AddAudioEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddVideoSourceConfigurationResponse:
		soap_serialize_PointerTo_trt__AddVideoSourceConfigurationResponse(soap, (struct _trt__AddVideoSourceConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddVideoSourceConfiguration:
		soap_serialize_PointerTo_trt__AddVideoSourceConfiguration(soap, (struct _trt__AddVideoSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddVideoEncoderConfigurationResponse:
		soap_serialize_PointerTo_trt__AddVideoEncoderConfigurationResponse(soap, (struct _trt__AddVideoEncoderConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__AddVideoEncoderConfiguration:
		soap_serialize_PointerTo_trt__AddVideoEncoderConfiguration(soap, (struct _trt__AddVideoEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetProfilesResponse:
		soap_serialize_PointerTo_trt__GetProfilesResponse(soap, (struct _trt__GetProfilesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetProfiles:
		soap_serialize_PointerTo_trt__GetProfiles(soap, (struct _trt__GetProfiles *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetProfileResponse:
		soap_serialize_PointerTo_trt__GetProfileResponse(soap, (struct _trt__GetProfileResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetProfile:
		soap_serialize_PointerTo_trt__GetProfile(soap, (struct _trt__GetProfile *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__CreateProfileResponse:
		soap_serialize_PointerTo_trt__CreateProfileResponse(soap, (struct _trt__CreateProfileResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__CreateProfile:
		soap_serialize_PointerTo_trt__CreateProfile(soap, (struct _trt__CreateProfile *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioSourcesResponse:
		soap_serialize_PointerTo_trt__GetAudioSourcesResponse(soap, (struct _trt__GetAudioSourcesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetAudioSources:
		soap_serialize_PointerTo_trt__GetAudioSources(soap, (struct _trt__GetAudioSources *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoSourcesResponse:
		soap_serialize_PointerTo_trt__GetVideoSourcesResponse(soap, (struct _trt__GetVideoSourcesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_trt__GetVideoSources:
		soap_serialize_PointerTo_trt__GetVideoSources(soap, (struct _trt__GetVideoSources *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__StopResponse:
		soap_serialize_PointerTo_tptz__StopResponse(soap, (struct _tptz__StopResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__Stop:
		soap_serialize_PointerTo_tptz__Stop(soap, (struct _tptz__Stop *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__AbsoluteMoveResponse:
		soap_serialize_PointerTo_tptz__AbsoluteMoveResponse(soap, (struct _tptz__AbsoluteMoveResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__AbsoluteMove:
		soap_serialize_PointerTo_tptz__AbsoluteMove(soap, (struct _tptz__AbsoluteMove *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__ContinuousMoveResponse:
		soap_serialize_PointerTo_tptz__ContinuousMoveResponse(soap, (struct _tptz__ContinuousMoveResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__ContinuousMove:
		soap_serialize_PointerTo_tptz__ContinuousMove(soap, (struct _tptz__ContinuousMove *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__SetHomePositionResponse:
		soap_serialize_PointerTo_tptz__SetHomePositionResponse(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__SetHomePosition:
		soap_serialize_PointerTo_tptz__SetHomePosition(soap, (struct _tptz__SetHomePosition *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GotoHomePositionResponse:
		soap_serialize_PointerTo_tptz__GotoHomePositionResponse(soap, (struct _tptz__GotoHomePositionResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GotoHomePosition:
		soap_serialize_PointerTo_tptz__GotoHomePosition(soap, (struct _tptz__GotoHomePosition *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GetConfigurationOptionsResponse:
		soap_serialize_PointerTo_tptz__GetConfigurationOptionsResponse(soap, (struct _tptz__GetConfigurationOptionsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GetConfigurationOptions:
		soap_serialize_PointerTo_tptz__GetConfigurationOptions(soap, (struct _tptz__GetConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__SetConfigurationResponse:
		soap_serialize_PointerTo_tptz__SetConfigurationResponse(soap, (struct _tptz__SetConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__SetConfiguration:
		soap_serialize_PointerTo_tptz__SetConfiguration(soap, (struct _tptz__SetConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GetNodeResponse:
		soap_serialize_PointerTo_tptz__GetNodeResponse(soap, (struct _tptz__GetNodeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GetNode:
		soap_serialize_PointerTo_tptz__GetNode(soap, (struct _tptz__GetNode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GetNodesResponse:
		soap_serialize_PointerTo_tptz__GetNodesResponse(soap, (struct _tptz__GetNodesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GetNodes:
		soap_serialize_PointerTo_tptz__GetNodes(soap, (struct _tptz__GetNodes *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GetConfigurationResponse:
		soap_serialize_PointerTo_tptz__GetConfigurationResponse(soap, (struct _tptz__GetConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GetConfiguration:
		soap_serialize_PointerTo_tptz__GetConfiguration(soap, (struct _tptz__GetConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GetStatusResponse:
		soap_serialize_PointerTo_tptz__GetStatusResponse(soap, (struct _tptz__GetStatusResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GetStatus:
		soap_serialize_PointerTo_tptz__GetStatus(soap, (struct _tptz__GetStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GotoPresetResponse:
		soap_serialize_PointerTo_tptz__GotoPresetResponse(soap, (struct _tptz__GotoPresetResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GotoPreset:
		soap_serialize_PointerTo_tptz__GotoPreset(soap, (struct _tptz__GotoPreset *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__RemovePresetResponse:
		soap_serialize_PointerTo_tptz__RemovePresetResponse(soap, (struct _tptz__RemovePresetResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__RemovePreset:
		soap_serialize_PointerTo_tptz__RemovePreset(soap, (struct _tptz__RemovePreset *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__SetPresetResponse:
		soap_serialize_PointerTo_tptz__SetPresetResponse(soap, (struct _tptz__SetPresetResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__SetPreset:
		soap_serialize_PointerTo_tptz__SetPreset(soap, (struct _tptz__SetPreset *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GetPresetsResponse:
		soap_serialize_PointerTo_tptz__GetPresetsResponse(soap, (struct _tptz__GetPresetsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GetPresets:
		soap_serialize_PointerTo_tptz__GetPresets(soap, (struct _tptz__GetPresets *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GetConfigurationsResponse:
		soap_serialize_PointerTo_tptz__GetConfigurationsResponse(soap, (struct _tptz__GetConfigurationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tptz__GetConfigurations:
		soap_serialize_PointerTo_tptz__GetConfigurations(soap, (struct _tptz__GetConfigurations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetRelayOutputStateResponse:
		soap_serialize_PointerTo_tds__SetRelayOutputStateResponse(soap, (struct _tds__SetRelayOutputStateResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetRelayOutputState:
		soap_serialize_PointerTo_tds__SetRelayOutputState(soap, (struct _tds__SetRelayOutputState *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetRelayOutputSettingsResponse:
		soap_serialize_PointerTo_tds__SetRelayOutputSettingsResponse(soap, (struct _tds__SetRelayOutputSettingsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetRelayOutputSettings:
		soap_serialize_PointerTo_tds__SetRelayOutputSettings(soap, (struct _tds__SetRelayOutputSettings *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetRelayOutputsResponse:
		soap_serialize_PointerTo_tds__GetRelayOutputsResponse(soap, (struct _tds__GetRelayOutputsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetRelayOutputs:
		soap_serialize_PointerTo_tds__GetRelayOutputs(soap, (struct _tds__GetRelayOutputs *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetZeroConfigurationResponse:
		soap_serialize_PointerTo_tds__SetZeroConfigurationResponse(soap, (struct _tds__SetZeroConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetZeroConfiguration:
		soap_serialize_PointerTo_tds__SetZeroConfiguration(soap, (struct _tds__SetZeroConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetZeroConfigurationResponse:
		soap_serialize_PointerTo_tds__GetZeroConfigurationResponse(soap, (struct _tds__GetZeroConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetZeroConfiguration:
		soap_serialize_PointerTo_tds__GetZeroConfiguration(soap, (struct _tds__GetZeroConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetNetworkDefaultGatewayResponse:
		soap_serialize_PointerTo_tds__SetNetworkDefaultGatewayResponse(soap, (struct _tds__SetNetworkDefaultGatewayResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetNetworkDefaultGateway:
		soap_serialize_PointerTo_tds__SetNetworkDefaultGateway(soap, (struct _tds__SetNetworkDefaultGateway *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetNetworkDefaultGatewayResponse:
		soap_serialize_PointerTo_tds__GetNetworkDefaultGatewayResponse(soap, (struct _tds__GetNetworkDefaultGatewayResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetNetworkDefaultGateway:
		soap_serialize_PointerTo_tds__GetNetworkDefaultGateway(soap, (struct _tds__GetNetworkDefaultGateway *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetNetworkProtocolsResponse:
		soap_serialize_PointerTo_tds__SetNetworkProtocolsResponse(soap, (struct _tds__SetNetworkProtocolsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetNetworkProtocols:
		soap_serialize_PointerTo_tds__SetNetworkProtocols(soap, (struct _tds__SetNetworkProtocols *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetNetworkProtocolsResponse:
		soap_serialize_PointerTo_tds__GetNetworkProtocolsResponse(soap, (struct _tds__GetNetworkProtocolsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetNetworkProtocols:
		soap_serialize_PointerTo_tds__GetNetworkProtocols(soap, (struct _tds__GetNetworkProtocols *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetNetworkInterfacesResponse:
		soap_serialize_PointerTo_tds__SetNetworkInterfacesResponse(soap, (struct _tds__SetNetworkInterfacesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetNetworkInterfaces:
		soap_serialize_PointerTo_tds__SetNetworkInterfaces(soap, (struct _tds__SetNetworkInterfaces *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetNetworkInterfacesResponse:
		soap_serialize_PointerTo_tds__GetNetworkInterfacesResponse(soap, (struct _tds__GetNetworkInterfacesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetNetworkInterfaces:
		soap_serialize_PointerTo_tds__GetNetworkInterfaces(soap, (struct _tds__GetNetworkInterfaces *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetDynamicDNSResponse:
		soap_serialize_PointerTo_tds__SetDynamicDNSResponse(soap, (struct _tds__SetDynamicDNSResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetDynamicDNS:
		soap_serialize_PointerTo_tds__SetDynamicDNS(soap, (struct _tds__SetDynamicDNS *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetDynamicDNSResponse:
		soap_serialize_PointerTo_tds__GetDynamicDNSResponse(soap, (struct _tds__GetDynamicDNSResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetDynamicDNS:
		soap_serialize_PointerTo_tds__GetDynamicDNS(soap, (struct _tds__GetDynamicDNS *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetNTPResponse:
		soap_serialize_PointerTo_tds__SetNTPResponse(soap, (struct _tds__SetNTPResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetNTP:
		soap_serialize_PointerTo_tds__SetNTP(soap, (struct _tds__SetNTP *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetNTPResponse:
		soap_serialize_PointerTo_tds__GetNTPResponse(soap, (struct _tds__GetNTPResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetNTP:
		soap_serialize_PointerTo_tds__GetNTP(soap, (struct _tds__GetNTP *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetDNSResponse:
		soap_serialize_PointerTo_tds__SetDNSResponse(soap, (struct _tds__SetDNSResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetDNS:
		soap_serialize_PointerTo_tds__SetDNS(soap, (struct _tds__SetDNS *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetDNSResponse:
		soap_serialize_PointerTo_tds__GetDNSResponse(soap, (struct _tds__GetDNSResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetDNS:
		soap_serialize_PointerTo_tds__GetDNS(soap, (struct _tds__GetDNS *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetHostnameResponse:
		soap_serialize_PointerTo_tds__SetHostnameResponse(soap, (struct _tds__SetHostnameResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetHostname:
		soap_serialize_PointerTo_tds__SetHostname(soap, (struct _tds__SetHostname *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetHostnameResponse:
		soap_serialize_PointerTo_tds__GetHostnameResponse(soap, (struct _tds__GetHostnameResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetHostname:
		soap_serialize_PointerTo_tds__GetHostname(soap, (struct _tds__GetHostname *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetCapabilitiesResponse:
		soap_serialize_PointerTo_tds__GetCapabilitiesResponse(soap, (struct _tds__GetCapabilitiesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetCapabilities:
		soap_serialize_PointerTo_tds__GetCapabilities(soap, (struct _tds__GetCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetWsdlUrlResponse:
		soap_serialize_PointerTo_tds__GetWsdlUrlResponse(soap, (struct _tds__GetWsdlUrlResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetWsdlUrl:
		soap_serialize_PointerTo_tds__GetWsdlUrl(soap, (struct _tds__GetWsdlUrl *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetUserResponse:
		soap_serialize_PointerTo_tds__SetUserResponse(soap, (struct _tds__SetUserResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetUser:
		soap_serialize_PointerTo_tds__SetUser(soap, (struct _tds__SetUser *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__DeleteUsersResponse:
		soap_serialize_PointerTo_tds__DeleteUsersResponse(soap, (struct _tds__DeleteUsersResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__DeleteUsers:
		soap_serialize_PointerTo_tds__DeleteUsers(soap, (struct _tds__DeleteUsers *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__CreateUsersResponse:
		soap_serialize_PointerTo_tds__CreateUsersResponse(soap, (struct _tds__CreateUsersResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__CreateUsers:
		soap_serialize_PointerTo_tds__CreateUsers(soap, (struct _tds__CreateUsers *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetUsersResponse:
		soap_serialize_PointerTo_tds__GetUsersResponse(soap, (struct _tds__GetUsersResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetUsers:
		soap_serialize_PointerTo_tds__GetUsers(soap, (struct _tds__GetUsers *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetDiscoveryModeResponse:
		soap_serialize_PointerTo_tds__SetDiscoveryModeResponse(soap, (struct _tds__SetDiscoveryModeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetDiscoveryMode:
		soap_serialize_PointerTo_tds__SetDiscoveryMode(soap, (struct _tds__SetDiscoveryMode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetDiscoveryModeResponse:
		soap_serialize_PointerTo_tds__GetDiscoveryModeResponse(soap, (struct _tds__GetDiscoveryModeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetDiscoveryMode:
		soap_serialize_PointerTo_tds__GetDiscoveryMode(soap, (struct _tds__GetDiscoveryMode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__RemoveScopesResponse:
		soap_serialize_PointerTo_tds__RemoveScopesResponse(soap, (struct _tds__RemoveScopesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__RemoveScopes:
		soap_serialize_PointerTo_tds__RemoveScopes(soap, (struct _tds__RemoveScopes *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__AddScopesResponse:
		soap_serialize_PointerTo_tds__AddScopesResponse(soap, (struct _tds__AddScopesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__AddScopes:
		soap_serialize_PointerTo_tds__AddScopes(soap, (struct _tds__AddScopes *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetScopesResponse:
		soap_serialize_PointerTo_tds__SetScopesResponse(soap, (struct _tds__SetScopesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetScopes:
		soap_serialize_PointerTo_tds__SetScopes(soap, (struct _tds__SetScopes *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetScopesResponse:
		soap_serialize_PointerTo_tds__GetScopesResponse(soap, (struct _tds__GetScopesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetScopes:
		soap_serialize_PointerTo_tds__GetScopes(soap, (struct _tds__GetScopes *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetSystemLogResponse:
		soap_serialize_PointerTo_tds__GetSystemLogResponse(soap, (struct _tds__GetSystemLogResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetSystemLog:
		soap_serialize_PointerTo_tds__GetSystemLog(soap, (struct _tds__GetSystemLog *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SystemRebootResponse:
		soap_serialize_PointerTo_tds__SystemRebootResponse(soap, (struct _tds__SystemRebootResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SystemReboot:
		soap_serialize_PointerTo_tds__SystemReboot(soap, (struct _tds__SystemReboot *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetSystemFactoryDefaultResponse:
		soap_serialize_PointerTo_tds__SetSystemFactoryDefaultResponse(soap, (struct _tds__SetSystemFactoryDefaultResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetSystemFactoryDefault:
		soap_serialize_PointerTo_tds__SetSystemFactoryDefault(soap, (struct _tds__SetSystemFactoryDefault *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetSystemDateAndTimeResponse:
		soap_serialize_PointerTo_tds__GetSystemDateAndTimeResponse(soap, (struct _tds__GetSystemDateAndTimeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetSystemDateAndTime:
		soap_serialize_PointerTo_tds__GetSystemDateAndTime(soap, (struct _tds__GetSystemDateAndTime *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetSystemDateAndTimeResponse:
		soap_serialize_PointerTo_tds__SetSystemDateAndTimeResponse(soap, (struct _tds__SetSystemDateAndTimeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__SetSystemDateAndTime:
		soap_serialize_PointerTo_tds__SetSystemDateAndTime(soap, (struct _tds__SetSystemDateAndTime *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetDeviceInformationResponse:
		soap_serialize_PointerTo_tds__GetDeviceInformationResponse(soap, (struct _tds__GetDeviceInformationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tds__GetDeviceInformation:
		soap_serialize_PointerTo_tds__GetDeviceInformation(soap, (struct _tds__GetDeviceInformation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsnt__Notify:
		soap_serialize_PointerTo_wsnt__Notify(soap, (struct _wsnt__Notify *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsnt__SubscribeResponse:
		soap_serialize_PointerTo_wsnt__SubscribeResponse(soap, (struct _wsnt__SubscribeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsnt__Subscribe:
		soap_serialize_PointerTo_wsnt__Subscribe(soap, (struct _wsnt__Subscribe *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsnt__UnsubscribeResponse:
		soap_serialize_PointerTo_wsnt__UnsubscribeResponse(soap, (struct _wsnt__UnsubscribeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsnt__Unsubscribe:
		soap_serialize_PointerTo_wsnt__Unsubscribe(soap, (struct _wsnt__Unsubscribe *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsnt__RenewResponse:
		soap_serialize_PointerTo_wsnt__RenewResponse(soap, (struct _wsnt__RenewResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsnt__Renew:
		soap_serialize_PointerTo_wsnt__Renew(soap, (struct _wsnt__Renew *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tev__GetEventPropertiesResponse:
		soap_serialize_PointerTo_tev__GetEventPropertiesResponse(soap, (struct _tev__GetEventPropertiesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tev__GetEventProperties:
		soap_serialize_PointerTo_tev__GetEventProperties(soap, (struct _tev__GetEventProperties *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tev__CreatePullPointSubscriptionResponse:
		soap_serialize_PointerTo_tev__CreatePullPointSubscriptionResponse(soap, (struct _tev__CreatePullPointSubscriptionResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tev__CreatePullPointSubscription:
		soap_serialize_PointerTo_tev__CreatePullPointSubscription(soap, (struct _tev__CreatePullPointSubscription *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tev__SetSynchronizationPointResponse:
		soap_serialize_PointerTo_tev__SetSynchronizationPointResponse(soap, (struct _tev__SetSynchronizationPointResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tev__SetSynchronizationPoint:
		soap_serialize_PointerTo_tev__SetSynchronizationPoint(soap, (struct _tev__SetSynchronizationPoint *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tev__PullMessagesResponse:
		soap_serialize_PointerTo_tev__PullMessagesResponse(soap, (struct _tev__PullMessagesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tev__PullMessages:
		soap_serialize_PointerTo_tev__PullMessages(soap, (struct _tev__PullMessages *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ProbeMatchesType:
		soap_serialize_PointerTod__ProbeMatchesType(soap, (struct d__ProbeMatchesType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ProbeType:
		soap_serialize_PointerTod__ProbeType(soap, (struct d__ProbeType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ByeType:
		soap_serialize_PointerTod__ByeType(soap, (struct d__ByeType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ResolveType:
		soap_serialize_PointerTod__ResolveType(soap, (struct d__ResolveType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__HelloType:
		soap_serialize_PointerTod__HelloType(soap, (struct d__HelloType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tev__PullMessagesFaultResponse:
		soap_serialize_PointerTo_tev__PullMessagesFaultResponse(soap, (struct _tev__PullMessagesFaultResponse *const*)ptr);
		break;
	case SOAP_TYPE__wsu__Created:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__wsu__Id:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__d__XAddrs:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__d__Types:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__wsaw__Action:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__wsnt__TopicExpressionDialect:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_PointerTott__ZoomLimits:
		soap_serialize_PointerTott__ZoomLimits(soap, (struct tt__ZoomLimits *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__PanTiltLimits:
		soap_serialize_PointerTott__PanTiltLimits(soap, (struct tt__PanTiltLimits *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkInterfaceExtension:
		soap_serialize_PointerTott__NetworkInterfaceExtension(soap, (struct tt__NetworkInterfaceExtension *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IPv4NetworkInterface:
		soap_serialize_PointerTott__IPv4NetworkInterface(soap, (struct tt__IPv4NetworkInterface *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkInterfaceLink:
		soap_serialize_PointerTott__NetworkInterfaceLink(soap, (struct tt__NetworkInterfaceLink *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkInterfaceInfo:
		soap_serialize_PointerTott__NetworkInterfaceInfo(soap, (struct tt__NetworkInterfaceInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__EventSubscription:
		soap_serialize_PointerTott__EventSubscription(soap, (struct tt__EventSubscription *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__MulticastConfiguration:
		soap_serialize_PointerTott__MulticastConfiguration(soap, (struct tt__MulticastConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__H264Configuration:
		soap_serialize_PointerTott__H264Configuration(soap, (struct tt__H264Configuration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Mpeg4Configuration:
		soap_serialize_PointerTott__Mpeg4Configuration(soap, (struct tt__Mpeg4Configuration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__VideoRateControl:
		soap_serialize_PointerTott__VideoRateControl(soap, (struct tt__VideoRateControl *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IntRectangle:
		soap_serialize_PointerTott__IntRectangle(soap, (struct tt__IntRectangle *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ImagingSettings:
		soap_serialize_PointerTott__ImagingSettings(soap, (struct tt__ImagingSettings *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsbf__ResourceUnknownFaultType_FaultCause:
		soap_serialize_PointerTo_wsbf__ResourceUnknownFaultType_FaultCause(soap, (struct _wsbf__ResourceUnknownFaultType_FaultCause *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsbf__ResourceUnknownFaultType_Description:
		soap_serialize_PointerTo_wsbf__ResourceUnknownFaultType_Description(soap, (struct _wsbf__ResourceUnknownFaultType_Description *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsbf__ResourceUnknownFaultType_ErrorCode:
		soap_serialize_PointerTo_wsbf__ResourceUnknownFaultType_ErrorCode(soap, (struct _wsbf__ResourceUnknownFaultType_ErrorCode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTotns1__Device:
		soap_serialize_PointerTotns1__Device(soap, (struct tns1__Device *const*)ptr);
		break;
	case SOAP_TYPE_PointerTotns1__VideoAnalytics:
		soap_serialize_PointerTotns1__VideoAnalytics(soap, (struct tns1__VideoAnalytics *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_FaultCause:
		soap_serialize_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_FaultCause(soap, (struct _wsbf__UnableToDestroySubscriptionFaultType_FaultCause *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_Description:
		soap_serialize_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_Description(soap, (struct _wsbf__UnableToDestroySubscriptionFaultType_Description *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_ErrorCode:
		soap_serialize_PointerTo_wsbf__UnableToDestroySubscriptionFaultType_ErrorCode(soap, (struct _wsbf__UnableToDestroySubscriptionFaultType_ErrorCode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsse__UsernameTokenType:
		soap_serialize_PointerTowsse__UsernameTokenType(soap, (struct wsse__UsernameTokenType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsu__TimestampType:
		soap_serialize_PointerTowsu__TimestampType(soap, (struct wsu__TimestampType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsse__PasswordString:
		soap_serialize_PointerTowsse__PasswordString(soap, (struct wsse__PasswordString *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsadis__EndpointReferenceType:
		soap_serialize_PointerTowsadis__EndpointReferenceType(soap, (struct wsadis__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ProbeMatchType:
		soap_serialize_PointerTod__ProbeMatchType(soap, (struct d__ProbeMatchType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTounsignedInt:
		soap_serialize_PointerTounsignedInt(soap, (unsigned int *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ScopesType:
		soap_serialize_PointerTod__ScopesType(soap, (struct d__ScopesType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__PTZStatus:
		soap_serialize_PointerTott__PTZStatus(soap, (struct tt__PTZStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__PTZPreset:
		soap_serialize_PointerTott__PTZPreset(soap, (struct tt__PTZPreset *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__PTZSpeed:
		soap_serialize_PointerTott__PTZSpeed(soap, (struct tt__PTZSpeed *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Preset:
		soap_serialize_PointerTott__Preset(soap, (struct tt__Preset *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__PTZConfigurationOptions:
		soap_serialize_PointerTott__PTZConfigurationOptions(soap, (struct tt__PTZConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo__tptz__SetConfigurationResponse_sequence:
		soap_serialize_PointerTo__tptz__SetConfigurationResponse_sequence(soap, (struct __tptz__SetConfigurationResponse_sequence *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__PTZNode:
		soap_serialize_PointerTott__PTZNode(soap, (struct tt__PTZNode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__MediaUri:
		soap_serialize_PointerTott__MediaUri(soap, (struct tt__MediaUri *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__StreamSetup:
		soap_serialize_PointerTott__StreamSetup(soap, (struct tt__StreamSetup *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__MetadataConfigurationOptions:
		soap_serialize_PointerTott__MetadataConfigurationOptions(soap, (struct tt__MetadataConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AudioEncoderConfigurationOptions:
		soap_serialize_PointerTott__AudioEncoderConfigurationOptions(soap, (struct tt__AudioEncoderConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AudioSourceConfigurationOptions:
		soap_serialize_PointerTott__AudioSourceConfigurationOptions(soap, (struct tt__AudioSourceConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__VideoEncoderConfigurationOptions:
		soap_serialize_PointerTott__VideoEncoderConfigurationOptions(soap, (struct tt__VideoEncoderConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__VideoSourceConfigurationOptions:
		soap_serialize_PointerTott__VideoSourceConfigurationOptions(soap, (struct tt__VideoSourceConfigurationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Profile:
		soap_serialize_PointerTott__Profile(soap, (struct tt__Profile *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AudioSource:
		soap_serialize_PointerTott__AudioSource(soap, (struct tt__AudioSource *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__VideoSource:
		soap_serialize_PointerTott__VideoSource(soap, (struct tt__VideoSource *const*)ptr);
		break;
	case SOAP_TYPE_PointerTotrt__Capabilities:
		soap_serialize_PointerTotrt__Capabilities(soap, (struct trt__Capabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTotrt__StreamingCapabilities:
		soap_serialize_PointerTotrt__StreamingCapabilities(soap, (struct trt__StreamingCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTotrt__ProfileCapabilities:
		soap_serialize_PointerTotrt__ProfileCapabilities(soap, (struct trt__ProfileCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowstop__TopicSetType:
		soap_serialize_PointerTowstop__TopicSetType(soap, (struct wstop__TopicSetType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__RelayOutputSettings:
		soap_serialize_PointerTott__RelayOutputSettings(soap, (struct tt__RelayOutputSettings *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__RelayOutput:
		soap_serialize_PointerTott__RelayOutput(soap, (struct tt__RelayOutput *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkZeroConfiguration:
		soap_serialize_PointerTott__NetworkZeroConfiguration(soap, (struct tt__NetworkZeroConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkGateway:
		soap_serialize_PointerTott__NetworkGateway(soap, (struct tt__NetworkGateway *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkProtocol:
		soap_serialize_PointerTott__NetworkProtocol(soap, (struct tt__NetworkProtocol *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkInterfaceSetConfiguration:
		soap_serialize_PointerTott__NetworkInterfaceSetConfiguration(soap, (struct tt__NetworkInterfaceSetConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkInterface:
		soap_serialize_PointerTott__NetworkInterface(soap, (struct tt__NetworkInterface *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__DynamicDNSInformation:
		soap_serialize_PointerTott__DynamicDNSInformation(soap, (struct tt__DynamicDNSInformation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NTPInformation:
		soap_serialize_PointerTott__NTPInformation(soap, (struct tt__NTPInformation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__DNSInformation:
		soap_serialize_PointerTott__DNSInformation(soap, (struct tt__DNSInformation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__HostnameInformation:
		soap_serialize_PointerTott__HostnameInformation(soap, (struct tt__HostnameInformation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Capabilities:
		soap_serialize_PointerTott__Capabilities(soap, (struct tt__Capabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__CapabilityCategory:
		soap_serialize_PointerTott__CapabilityCategory(soap, (enum tt__CapabilityCategory *const*)ptr);
		break;
	case SOAP_TYPE_PointerTostring:
		soap_serialize_PointerTostring(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__User:
		soap_serialize_PointerTott__User(soap, (struct tt__User *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__anyURI:
		soap_serialize_PointerToxsd__anyURI(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Scope:
		soap_serialize_PointerTott__Scope(soap, (struct tt__Scope *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__SystemLog:
		soap_serialize_PointerTott__SystemLog(soap, (struct tt__SystemLog *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__SystemDateTime:
		soap_serialize_PointerTott__SystemDateTime(soap, (struct tt__SystemDateTime *const*)ptr);
		break;
	case SOAP_TYPE_PointerTotnsacti__VirtualPort:
		soap_serialize_PointerTotnsacti__VirtualPort(soap, (struct tnsacti__VirtualPort *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__MessageDescription:
		soap_serialize_PointerTott__MessageDescription(soap, (struct tt__MessageDescription *const*)ptr);
		break;
	case SOAP_TYPE_PointerTotnsacti__IO:
		soap_serialize_PointerTotnsacti__IO(soap, (struct tnsacti__IO *const*)ptr);
		break;
	case SOAP_TYPE_PointerTotnsacti__MotionDetection:
		soap_serialize_PointerTotnsacti__MotionDetection(soap, (struct tnsacti__MotionDetection *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ItemList:
		soap_serialize_PointerTott__ItemList(soap, (struct tt__ItemList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo__tt__union_EventStream:
		soap_serialize_PointerTo__tt__union_EventStream(soap, (struct __tt__union_EventStream *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tt__ItemListDescription_SimpleItemDescription:
		soap_serialize_PointerTo_tt__ItemListDescription_SimpleItemDescription(soap, (struct _tt__ItemListDescription_SimpleItemDescription *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ItemListDescription:
		soap_serialize_PointerTott__ItemListDescription(soap, (struct tt__ItemListDescription *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tt__ItemList_SimpleItem:
		soap_serialize_PointerTo_tt__ItemList_SimpleItem(soap, (struct _tt__ItemList_SimpleItem *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__WhiteBalanceMode:
		soap_serialize_PointerTott__WhiteBalanceMode(soap, (enum tt__WhiteBalanceMode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ExposurePriority:
		soap_serialize_PointerTott__ExposurePriority(soap, (enum tt__ExposurePriority *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ExposureMode:
		soap_serialize_PointerTott__ExposureMode(soap, (enum tt__ExposureMode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AutoFocusMode:
		soap_serialize_PointerTott__AutoFocusMode(soap, (enum tt__AutoFocusMode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__WideDynamicMode:
		soap_serialize_PointerTott__WideDynamicMode(soap, (enum tt__WideDynamicMode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__WhiteBalanceOptions:
		soap_serialize_PointerTott__WhiteBalanceOptions(soap, (struct tt__WhiteBalanceOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__WideDynamicRangeOptions:
		soap_serialize_PointerTott__WideDynamicRangeOptions(soap, (struct tt__WideDynamicRangeOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__FocusOptions:
		soap_serialize_PointerTott__FocusOptions(soap, (struct tt__FocusOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ExposureOptions:
		soap_serialize_PointerTott__ExposureOptions(soap, (struct tt__ExposureOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__BacklightCompensationOptions:
		soap_serialize_PointerTott__BacklightCompensationOptions(soap, (struct tt__BacklightCompensationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Rectangle:
		soap_serialize_PointerTott__Rectangle(soap, (struct tt__Rectangle *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__WhiteBalance:
		soap_serialize_PointerTott__WhiteBalance(soap, (struct tt__WhiteBalance *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__WideDynamicRange:
		soap_serialize_PointerTott__WideDynamicRange(soap, (struct tt__WideDynamicRange *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IrCutFilterMode:
		soap_serialize_PointerTott__IrCutFilterMode(soap, (enum tt__IrCutFilterMode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__FocusConfiguration:
		soap_serialize_PointerTott__FocusConfiguration(soap, (struct tt__FocusConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Exposure:
		soap_serialize_PointerTott__Exposure(soap, (struct tt__Exposure *const*)ptr);
		break;
	case SOAP_TYPE_PointerTofloat:
		soap_serialize_PointerTofloat(soap, (float *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__BacklightCompensation:
		soap_serialize_PointerTott__BacklightCompensation(soap, (struct tt__BacklightCompensation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__MoveStatus:
		soap_serialize_PointerTott__MoveStatus(soap, (enum tt__MoveStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__PTZMoveStatus:
		soap_serialize_PointerTott__PTZMoveStatus(soap, (struct tt__PTZMoveStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__PTZVector:
		soap_serialize_PointerTott__PTZVector(soap, (struct tt__PTZVector *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Vector1D:
		soap_serialize_PointerTott__Vector1D(soap, (struct tt__Vector1D *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Vector2D:
		soap_serialize_PointerTott__Vector2D(soap, (struct tt__Vector2D *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__FloatRange:
		soap_serialize_PointerTott__FloatRange(soap, (struct tt__FloatRange *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Space1DDescription:
		soap_serialize_PointerTott__Space1DDescription(soap, (struct tt__Space1DDescription *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Space2DDescription:
		soap_serialize_PointerTott__Space2DDescription(soap, (struct tt__Space2DDescription *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__DurationRange:
		soap_serialize_PointerTott__DurationRange(soap, (struct tt__DurationRange *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__PTZSpaces:
		soap_serialize_PointerTott__PTZSpaces(soap, (struct tt__PTZSpaces *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Date:
		soap_serialize_PointerTott__Date(soap, (struct tt__Date *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Time:
		soap_serialize_PointerTott__Time(soap, (struct tt__Time *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__DateTime:
		soap_serialize_PointerTott__DateTime(soap, (struct tt__DateTime *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__TimeZone:
		soap_serialize_PointerTott__TimeZone(soap, (struct tt__TimeZone *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__OnvifVersion:
		soap_serialize_PointerTott__OnvifVersion(soap, (struct tt__OnvifVersion *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__RealTimeStreamingCapabilities:
		soap_serialize_PointerTott__RealTimeStreamingCapabilities(soap, (struct tt__RealTimeStreamingCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__SecurityCapabilities:
		soap_serialize_PointerTott__SecurityCapabilities(soap, (struct tt__SecurityCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IOCapabilities:
		soap_serialize_PointerTott__IOCapabilities(soap, (struct tt__IOCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__SystemCapabilities:
		soap_serialize_PointerTott__SystemCapabilities(soap, (struct tt__SystemCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkCapabilities:
		soap_serialize_PointerTott__NetworkCapabilities(soap, (struct tt__NetworkCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AnalyticsDeviceCapabilities:
		soap_serialize_PointerTott__AnalyticsDeviceCapabilities(soap, (struct tt__AnalyticsDeviceCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ReceiverCapabilities:
		soap_serialize_PointerTott__ReceiverCapabilities(soap, (struct tt__ReceiverCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ReplayCapabilities:
		soap_serialize_PointerTott__ReplayCapabilities(soap, (struct tt__ReplayCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__SearchCapabilities:
		soap_serialize_PointerTott__SearchCapabilities(soap, (struct tt__SearchCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__RecordingCapabilities:
		soap_serialize_PointerTott__RecordingCapabilities(soap, (struct tt__RecordingCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__DisplayCapabilities:
		soap_serialize_PointerTott__DisplayCapabilities(soap, (struct tt__DisplayCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__DeviceIOCapabilities:
		soap_serialize_PointerTott__DeviceIOCapabilities(soap, (struct tt__DeviceIOCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__CapabilitiesExtension:
		soap_serialize_PointerTott__CapabilitiesExtension(soap, (struct tt__CapabilitiesExtension *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__PTZCapabilities:
		soap_serialize_PointerTott__PTZCapabilities(soap, (struct tt__PTZCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__MediaCapabilities:
		soap_serialize_PointerTott__MediaCapabilities(soap, (struct tt__MediaCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ImagingCapabilities:
		soap_serialize_PointerTott__ImagingCapabilities(soap, (struct tt__ImagingCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__EventCapabilities:
		soap_serialize_PointerTott__EventCapabilities(soap, (struct tt__EventCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__DeviceCapabilities:
		soap_serialize_PointerTott__DeviceCapabilities(soap, (struct tt__DeviceCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AnalyticsCapabilities:
		soap_serialize_PointerTott__AnalyticsCapabilities(soap, (struct tt__AnalyticsCapabilities *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkInterfaceSetConfigurationExtension:
		soap_serialize_PointerTott__NetworkInterfaceSetConfigurationExtension(soap, (struct tt__NetworkInterfaceSetConfigurationExtension *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IPv4NetworkInterfaceSetConfiguration:
		soap_serialize_PointerTott__IPv4NetworkInterfaceSetConfiguration(soap, (struct tt__IPv4NetworkInterfaceSetConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkHost:
		soap_serialize_PointerTott__NetworkHost(soap, (struct tt__NetworkHost *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__token:
		soap_serialize_PointerToxsd__token(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__DNSName:
		soap_serialize_PointerTott__DNSName(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IPv4Address:
		soap_serialize_PointerTott__IPv4Address(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__PrefixedIPv4Address:
		soap_serialize_PointerTott__PrefixedIPv4Address(soap, (struct tt__PrefixedIPv4Address *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IPv4Configuration:
		soap_serialize_PointerTott__IPv4Configuration(soap, (struct tt__IPv4Configuration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkInterfaceConnectionSetting:
		soap_serialize_PointerTott__NetworkInterfaceConnectionSetting(soap, (struct tt__NetworkInterfaceConnectionSetting *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__NetworkInterfaceExtension2:
		soap_serialize_PointerTott__NetworkInterfaceExtension2(soap, (struct tt__NetworkInterfaceExtension2 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Dot3Configuration:
		soap_serialize_PointerTott__Dot3Configuration(soap, (struct tt__Dot3Configuration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Transport:
		soap_serialize_PointerTott__Transport(soap, (struct tt__Transport *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IPAddress:
		soap_serialize_PointerTott__IPAddress(soap, (struct tt__IPAddress *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__PTZStatusFilterOptions:
		soap_serialize_PointerTott__PTZStatusFilterOptions(soap, (struct tt__PTZStatusFilterOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IntList:
		soap_serialize_PointerTott__IntList(soap, (struct tt__IntList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AudioEncoderConfigurationOption:
		soap_serialize_PointerTott__AudioEncoderConfigurationOption(soap, (struct tt__AudioEncoderConfigurationOption *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__H264Profile:
		soap_serialize_PointerTott__H264Profile(soap, (enum tt__H264Profile *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Mpeg4Profile:
		soap_serialize_PointerTott__Mpeg4Profile(soap, (enum tt__Mpeg4Profile *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__VideoResolution:
		soap_serialize_PointerTott__VideoResolution(soap, (struct tt__VideoResolution *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__H264Options:
		soap_serialize_PointerTott__H264Options(soap, (struct tt__H264Options *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__Mpeg4Options:
		soap_serialize_PointerTott__Mpeg4Options(soap, (struct tt__Mpeg4Options *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__JpegOptions:
		soap_serialize_PointerTott__JpegOptions(soap, (struct tt__JpegOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__ReferenceToken:
		soap_serialize_PointerTott__ReferenceToken(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IntRectangleRange:
		soap_serialize_PointerTott__IntRectangleRange(soap, (struct tt__IntRectangleRange *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__boolean:
		soap_serialize_PointerToxsd__boolean(soap, (enum xsd__boolean *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__MetadataConfiguration:
		soap_serialize_PointerTott__MetadataConfiguration(soap, (struct tt__MetadataConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__PTZConfiguration:
		soap_serialize_PointerTott__PTZConfiguration(soap, (struct tt__PTZConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AudioEncoderConfiguration:
		soap_serialize_PointerTott__AudioEncoderConfiguration(soap, (struct tt__AudioEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__VideoEncoderConfiguration:
		soap_serialize_PointerTott__VideoEncoderConfiguration(soap, (struct tt__VideoEncoderConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__AudioSourceConfiguration:
		soap_serialize_PointerTott__AudioSourceConfiguration(soap, (struct tt__AudioSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__VideoSourceConfiguration:
		soap_serialize_PointerTott__VideoSourceConfiguration(soap, (struct tt__VideoSourceConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerToint:
		soap_serialize_PointerToint(soap, (int *const*)ptr);
		break;
	case SOAP_TYPE_PointerTott__IntRange:
		soap_serialize_PointerTott__IntRange(soap, (struct tt__IntRange *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowstop__Documentation:
		soap_serialize_PointerTowstop__Documentation(soap, (struct wstop__Documentation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsa__MetadataType:
		soap_serialize_PointerTowsa__MetadataType(soap, (struct wsa__MetadataType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsa__ReferenceParametersType:
		soap_serialize_PointerTowsa__ReferenceParametersType(soap, (struct wsa__ReferenceParametersType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsa__AttributedURIType:
		soap_serialize_PointerTowsa__AttributedURIType(soap, (struct wsa__AttributedURIType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsbf__BaseFaultType_FaultCause:
		soap_serialize_PointerTo_wsbf__BaseFaultType_FaultCause(soap, (struct _wsbf__BaseFaultType_FaultCause *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsbf__BaseFaultType_Description:
		soap_serialize_PointerTo_wsbf__BaseFaultType_Description(soap, (struct _wsbf__BaseFaultType_Description *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsbf__BaseFaultType_ErrorCode:
		soap_serialize_PointerTo_wsbf__BaseFaultType_ErrorCode(soap, (struct _wsbf__BaseFaultType_ErrorCode *const*)ptr);
		break;
	case SOAP_TYPE_PointerTotime:
		soap_serialize_PointerTotime(soap, (time_t *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsnt__FilterType:
		soap_serialize_PointerTowsnt__FilterType(soap, (struct wsnt__FilterType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsnt__NotificationMessageHolderType:
		soap_serialize_PointerTowsnt__NotificationMessageHolderType(soap, (struct wsnt__NotificationMessageHolderType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_tt__Message:
		soap_serialize_PointerTo_tt__Message(soap, (struct _tt__Message *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsa__EndpointReferenceType:
		soap_serialize_PointerTowsa__EndpointReferenceType(soap, (struct wsa__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsnt__QueryExpressionType:
		soap_serialize_PointerTowsnt__QueryExpressionType(soap, (struct wsnt__QueryExpressionType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsnt__TopicExpressionType:
		soap_serialize_PointerTowsnt__TopicExpressionType(soap, (struct wsnt__TopicExpressionType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsadis__ServiceNameType:
		soap_serialize_PointerTowsadis__ServiceNameType(soap, (struct wsadis__ServiceNameType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsadis__AttributedQName:
		soap_serialize_PointerTowsadis__AttributedQName(soap, (struct wsadis__AttributedQName *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsadis__ReferenceParametersType:
		soap_serialize_PointerTowsadis__ReferenceParametersType(soap, (struct wsadis__ReferenceParametersType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsadis__ReferencePropertiesType:
		soap_serialize_PointerTowsadis__ReferencePropertiesType(soap, (struct wsadis__ReferencePropertiesType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsadis__AttributedURI:
		soap_serialize_PointerTowsadis__AttributedURI(soap, (struct wsadis__AttributedURI *const*)ptr);
		break;
	case SOAP_TYPE_tt__Domain:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_tt__DNSName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_tt__HwAddress:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_tt__IPv4Address:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_tt__Name:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_tt__ReferenceToken:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_d__UriListType:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_d__QNameListType:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_wsa__RelationshipTypeOpenEnum:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_wsnt__AbsoluteOrRelativeTimeType:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__tptz__SetHomePositionResponse:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__xml__lang:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__token:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__duration:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__anyURI:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__anySimpleType:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__Name:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__NCName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{	char *p;
	p = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__IANA_IfTypes(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_tt__IANA_IfTypes);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_tt__IANA_IfTypes(struct soap *soap, const char *tag, int *a, const char *type)
{	int *p;
	p = soap_inint(soap, tag, a, type, SOAP_TYPE_tt__IANA_IfTypes);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__IANA_IfTypes(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__IANA_IfTypes);
	if (soap_out_tt__IANA_IfTypes(soap, tag?tag:"tt:IANA-IfTypes", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_tt__IANA_IfTypes(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__IANA_IfTypes(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{	int *p;
	p = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag?tag:"int", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_float(struct soap *soap, float *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_float
	*a = SOAP_DEFAULT_float;
#else
	*a = (float)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_float(struct soap *soap, const char *tag, int id, const float *a, const char *type)
{
	return soap_outfloat(soap, tag, id, a, type, SOAP_TYPE_float);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_in_float(struct soap *soap, const char *tag, float *a, const char *type)
{	float *p;
	p = soap_infloat(soap, tag, a, type, SOAP_TYPE_float);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_float(struct soap *soap, const float *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_float);
	if (soap_out_float(soap, tag?tag:"float", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_get_float(struct soap *soap, float *p, const char *tag, const char *type)
{
	if ((p = soap_in_float(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{	unsigned int *p;
	p = soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag?tag:"unsignedInt", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_time(struct soap *soap, time_t *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_time
	*a = SOAP_DEFAULT_time;
#else
	*a = (time_t)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_time(struct soap *soap, const char *tag, int id, const time_t *a, const char *type)
{
	return soap_outdateTime(soap, tag, id, a, type, SOAP_TYPE_time);
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_in_time(struct soap *soap, const char *tag, time_t *a, const char *type)
{	time_t *p;
	p = soap_indateTime(soap, tag, a, type, SOAP_TYPE_time);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_time(struct soap *soap, const time_t *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_time);
	if (soap_out_time(soap, tag?tag:"dateTime", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_get_time(struct soap *soap, time_t *p, const char *tag, const char *type)
{
	if ((p = soap_in_time(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsu__tTimestampFault(struct soap *soap, enum wsu__tTimestampFault *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsu__tTimestampFault
	*a = SOAP_DEFAULT_wsu__tTimestampFault;
#else
	*a = (enum wsu__tTimestampFault)0;
#endif
}

static const struct soap_code_map soap_codes_wsu__tTimestampFault[] =
{	{ (long)wsu__MessageExpired, "wsu:MessageExpired" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsu__tTimestampFault2s(struct soap *soap, enum wsu__tTimestampFault n)
{	const char *s = soap_code_str(soap_codes_wsu__tTimestampFault, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsu__tTimestampFault(struct soap *soap, const char *tag, int id, const enum wsu__tTimestampFault *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsu__tTimestampFault), type) || soap_send(soap, soap_wsu__tTimestampFault2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsu__tTimestampFault(struct soap *soap, const char *s, enum wsu__tTimestampFault *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, -1, -1);
	map = soap_code(soap_codes_wsu__tTimestampFault, t);
	if (map)
		*a = (enum wsu__tTimestampFault)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsu__tTimestampFault)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsu__tTimestampFault * SOAP_FMAC4 soap_in_wsu__tTimestampFault(struct soap *soap, const char *tag, enum wsu__tTimestampFault *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsu__tTimestampFault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsu__tTimestampFault, sizeof(enum wsu__tTimestampFault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsu__tTimestampFault(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsu__tTimestampFault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsu__tTimestampFault, 0, sizeof(enum wsu__tTimestampFault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsu__tTimestampFault(struct soap *soap, const enum wsu__tTimestampFault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsu__tTimestampFault);
	if (soap_out_wsu__tTimestampFault(soap, tag?tag:"wsu:tTimestampFault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsu__tTimestampFault * SOAP_FMAC4 soap_get_wsu__tTimestampFault(struct soap *soap, enum wsu__tTimestampFault *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsu__tTimestampFault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsse__FaultcodeEnum(struct soap *soap, enum wsse__FaultcodeEnum *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsse__FaultcodeEnum
	*a = SOAP_DEFAULT_wsse__FaultcodeEnum;
#else
	*a = (enum wsse__FaultcodeEnum)0;
#endif
}

static const struct soap_code_map soap_codes_wsse__FaultcodeEnum[] =
{	{ (long)wsse__UnsupportedSecurityToken, "wsse:UnsupportedSecurityToken" },
	{ (long)wsse__UnsupportedAlgorithm, "wsse:UnsupportedAlgorithm" },
	{ (long)wsse__InvalidSecurity, "wsse:InvalidSecurity" },
	{ (long)wsse__InvalidSecurityToken, "wsse:InvalidSecurityToken" },
	{ (long)wsse__FailedAuthentication, "wsse:FailedAuthentication" },
	{ (long)wsse__FailedCheck, "wsse:FailedCheck" },
	{ (long)wsse__SecurityTokenUnavailable, "wsse:SecurityTokenUnavailable" },
	{ (long)wsse__NonceIsMissing, "wsse:NonceIsMissing" },
	{ (long)wsse__CreatedIsMissing, "wsse:CreatedIsMissing" },
	{ (long)wsse__PasswordTypeIsMissing, "wsse:PasswordTypeIsMissing" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsse__FaultcodeEnum2s(struct soap *soap, enum wsse__FaultcodeEnum n)
{	const char *s = soap_code_str(soap_codes_wsse__FaultcodeEnum, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsse__FaultcodeEnum(struct soap *soap, const char *tag, int id, const enum wsse__FaultcodeEnum *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsse__FaultcodeEnum), type) || soap_send(soap, soap_wsse__FaultcodeEnum2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsse__FaultcodeEnum(struct soap *soap, const char *s, enum wsse__FaultcodeEnum *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, -1, -1);
	map = soap_code(soap_codes_wsse__FaultcodeEnum, t);
	if (map)
		*a = (enum wsse__FaultcodeEnum)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 9)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsse__FaultcodeEnum)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsse__FaultcodeEnum * SOAP_FMAC4 soap_in_wsse__FaultcodeEnum(struct soap *soap, const char *tag, enum wsse__FaultcodeEnum *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsse__FaultcodeEnum *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsse__FaultcodeEnum, sizeof(enum wsse__FaultcodeEnum), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsse__FaultcodeEnum(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsse__FaultcodeEnum *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsse__FaultcodeEnum, 0, sizeof(enum wsse__FaultcodeEnum), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsse__FaultcodeEnum(struct soap *soap, const enum wsse__FaultcodeEnum *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsse__FaultcodeEnum);
	if (soap_out_wsse__FaultcodeEnum(soap, tag?tag:"wsse:FaultcodeEnum", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsse__FaultcodeEnum * SOAP_FMAC4 soap_get_wsse__FaultcodeEnum(struct soap *soap, enum wsse__FaultcodeEnum *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsse__FaultcodeEnum(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__FaultCodeType(struct soap *soap, enum d__FaultCodeType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_d__FaultCodeType
	*a = SOAP_DEFAULT_d__FaultCodeType;
#else
	*a = (enum d__FaultCodeType)0;
#endif
}

static const struct soap_code_map soap_codes_d__FaultCodeType[] =
{	{ (long)d__MatchingRuleNotSupported, "d:MatchingRuleNotSupported" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_d__FaultCodeType2s(struct soap *soap, enum d__FaultCodeType n)
{	const char *s = soap_code_str(soap_codes_d__FaultCodeType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__FaultCodeType(struct soap *soap, const char *tag, int id, const enum d__FaultCodeType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__FaultCodeType), type) || soap_send(soap, soap_d__FaultCodeType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2d__FaultCodeType(struct soap *soap, const char *s, enum d__FaultCodeType *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, -1, -1);
	map = soap_code(soap_codes_d__FaultCodeType, t);
	if (map)
		*a = (enum d__FaultCodeType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum d__FaultCodeType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum d__FaultCodeType * SOAP_FMAC4 soap_in_d__FaultCodeType(struct soap *soap, const char *tag, enum d__FaultCodeType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum d__FaultCodeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__FaultCodeType, sizeof(enum d__FaultCodeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2d__FaultCodeType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum d__FaultCodeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__FaultCodeType, 0, sizeof(enum d__FaultCodeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__FaultCodeType(struct soap *soap, const enum d__FaultCodeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__FaultCodeType);
	if (soap_out_d__FaultCodeType(soap, tag?tag:"d:FaultCodeType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum d__FaultCodeType * SOAP_FMAC4 soap_get_d__FaultCodeType(struct soap *soap, enum d__FaultCodeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__FaultCodeType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsaw__AnonymousType(struct soap *soap, enum wsaw__AnonymousType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsaw__AnonymousType
	*a = SOAP_DEFAULT_wsaw__AnonymousType;
#else
	*a = (enum wsaw__AnonymousType)0;
#endif
}

static const struct soap_code_map soap_codes_wsaw__AnonymousType[] =
{	{ (long)optional, "optional" },
	{ (long)required, "required" },
	{ (long)prohibited, "prohibited" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsaw__AnonymousType2s(struct soap *soap, enum wsaw__AnonymousType n)
{	const char *s = soap_code_str(soap_codes_wsaw__AnonymousType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsaw__AnonymousType(struct soap *soap, const char *tag, int id, const enum wsaw__AnonymousType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsaw__AnonymousType), type) || soap_send(soap, soap_wsaw__AnonymousType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsaw__AnonymousType(struct soap *soap, const char *s, enum wsaw__AnonymousType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_wsaw__AnonymousType, s);
	if (map)
		*a = (enum wsaw__AnonymousType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsaw__AnonymousType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsaw__AnonymousType * SOAP_FMAC4 soap_in_wsaw__AnonymousType(struct soap *soap, const char *tag, enum wsaw__AnonymousType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsaw__AnonymousType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsaw__AnonymousType, sizeof(enum wsaw__AnonymousType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsaw__AnonymousType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsaw__AnonymousType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsaw__AnonymousType, 0, sizeof(enum wsaw__AnonymousType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsaw__AnonymousType(struct soap *soap, const enum wsaw__AnonymousType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsaw__AnonymousType);
	if (soap_out_wsaw__AnonymousType(soap, tag?tag:"wsaw:AnonymousType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsaw__AnonymousType * SOAP_FMAC4 soap_get_wsaw__AnonymousType(struct soap *soap, enum wsaw__AnonymousType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsaw__AnonymousType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__IrCutFilterMode(struct soap *soap, enum tt__IrCutFilterMode *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__IrCutFilterMode
	*a = SOAP_DEFAULT_tt__IrCutFilterMode;
#else
	*a = (enum tt__IrCutFilterMode)0;
#endif
}

static const struct soap_code_map soap_codes_tt__IrCutFilterMode[] =
{	{ (long)ON__, "ON" },
	{ (long)OFF__, "OFF" },
	{ (long)AUTO___, "AUTO" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__IrCutFilterMode2s(struct soap *soap, enum tt__IrCutFilterMode n)
{	const char *s = soap_code_str(soap_codes_tt__IrCutFilterMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__IrCutFilterMode(struct soap *soap, const char *tag, int id, const enum tt__IrCutFilterMode *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__IrCutFilterMode), type) || soap_send(soap, soap_tt__IrCutFilterMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__IrCutFilterMode(struct soap *soap, const char *s, enum tt__IrCutFilterMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__IrCutFilterMode, s);
	if (map)
		*a = (enum tt__IrCutFilterMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__IrCutFilterMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__IrCutFilterMode * SOAP_FMAC4 soap_in_tt__IrCutFilterMode(struct soap *soap, const char *tag, enum tt__IrCutFilterMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__IrCutFilterMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__IrCutFilterMode, sizeof(enum tt__IrCutFilterMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__IrCutFilterMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__IrCutFilterMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__IrCutFilterMode, 0, sizeof(enum tt__IrCutFilterMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__IrCutFilterMode(struct soap *soap, const enum tt__IrCutFilterMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__IrCutFilterMode);
	if (soap_out_tt__IrCutFilterMode(soap, tag?tag:"tt:IrCutFilterMode", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__IrCutFilterMode * SOAP_FMAC4 soap_get_tt__IrCutFilterMode(struct soap *soap, enum tt__IrCutFilterMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__IrCutFilterMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__WhiteBalanceMode(struct soap *soap, enum tt__WhiteBalanceMode *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__WhiteBalanceMode
	*a = SOAP_DEFAULT_tt__WhiteBalanceMode;
#else
	*a = (enum tt__WhiteBalanceMode)0;
#endif
}

static const struct soap_code_map soap_codes_tt__WhiteBalanceMode[] =
{	{ (long)AUTO__, "AUTO" },
	{ (long)MANUAL__, "MANUAL" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__WhiteBalanceMode2s(struct soap *soap, enum tt__WhiteBalanceMode n)
{	const char *s = soap_code_str(soap_codes_tt__WhiteBalanceMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__WhiteBalanceMode(struct soap *soap, const char *tag, int id, const enum tt__WhiteBalanceMode *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__WhiteBalanceMode), type) || soap_send(soap, soap_tt__WhiteBalanceMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__WhiteBalanceMode(struct soap *soap, const char *s, enum tt__WhiteBalanceMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__WhiteBalanceMode, s);
	if (map)
		*a = (enum tt__WhiteBalanceMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__WhiteBalanceMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__WhiteBalanceMode * SOAP_FMAC4 soap_in_tt__WhiteBalanceMode(struct soap *soap, const char *tag, enum tt__WhiteBalanceMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__WhiteBalanceMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__WhiteBalanceMode, sizeof(enum tt__WhiteBalanceMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__WhiteBalanceMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__WhiteBalanceMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__WhiteBalanceMode, 0, sizeof(enum tt__WhiteBalanceMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__WhiteBalanceMode(struct soap *soap, const enum tt__WhiteBalanceMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__WhiteBalanceMode);
	if (soap_out_tt__WhiteBalanceMode(soap, tag?tag:"tt:WhiteBalanceMode", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__WhiteBalanceMode * SOAP_FMAC4 soap_get_tt__WhiteBalanceMode(struct soap *soap, enum tt__WhiteBalanceMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__WhiteBalanceMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__Enabled(struct soap *soap, enum tt__Enabled *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__Enabled
	*a = SOAP_DEFAULT_tt__Enabled;
#else
	*a = (enum tt__Enabled)0;
#endif
}

static const struct soap_code_map soap_codes_tt__Enabled[] =
{	{ (long)ENABLED, "ENABLED" },
	{ (long)DISABLED, "DISABLED" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__Enabled2s(struct soap *soap, enum tt__Enabled n)
{	const char *s = soap_code_str(soap_codes_tt__Enabled, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__Enabled(struct soap *soap, const char *tag, int id, const enum tt__Enabled *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__Enabled), type) || soap_send(soap, soap_tt__Enabled2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__Enabled(struct soap *soap, const char *s, enum tt__Enabled *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__Enabled, s);
	if (map)
		*a = (enum tt__Enabled)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__Enabled)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__Enabled * SOAP_FMAC4 soap_in_tt__Enabled(struct soap *soap, const char *tag, enum tt__Enabled *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__Enabled *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__Enabled, sizeof(enum tt__Enabled), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__Enabled(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__Enabled *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__Enabled, 0, sizeof(enum tt__Enabled), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__Enabled(struct soap *soap, const enum tt__Enabled *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__Enabled);
	if (soap_out_tt__Enabled(soap, tag?tag:"tt:Enabled", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__Enabled * SOAP_FMAC4 soap_get_tt__Enabled(struct soap *soap, enum tt__Enabled *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__Enabled(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__ExposureMode(struct soap *soap, enum tt__ExposureMode *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__ExposureMode
	*a = SOAP_DEFAULT_tt__ExposureMode;
#else
	*a = (enum tt__ExposureMode)0;
#endif
}

static const struct soap_code_map soap_codes_tt__ExposureMode[] =
{	{ (long)AUTO_, "AUTO" },
	{ (long)MANUAL_, "MANUAL" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__ExposureMode2s(struct soap *soap, enum tt__ExposureMode n)
{	const char *s = soap_code_str(soap_codes_tt__ExposureMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__ExposureMode(struct soap *soap, const char *tag, int id, const enum tt__ExposureMode *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__ExposureMode), type) || soap_send(soap, soap_tt__ExposureMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__ExposureMode(struct soap *soap, const char *s, enum tt__ExposureMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__ExposureMode, s);
	if (map)
		*a = (enum tt__ExposureMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__ExposureMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__ExposureMode * SOAP_FMAC4 soap_in_tt__ExposureMode(struct soap *soap, const char *tag, enum tt__ExposureMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__ExposureMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__ExposureMode, sizeof(enum tt__ExposureMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__ExposureMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__ExposureMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__ExposureMode, 0, sizeof(enum tt__ExposureMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__ExposureMode(struct soap *soap, const enum tt__ExposureMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__ExposureMode);
	if (soap_out_tt__ExposureMode(soap, tag?tag:"tt:ExposureMode", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__ExposureMode * SOAP_FMAC4 soap_get_tt__ExposureMode(struct soap *soap, enum tt__ExposureMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__ExposureMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__ExposurePriority(struct soap *soap, enum tt__ExposurePriority *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__ExposurePriority
	*a = SOAP_DEFAULT_tt__ExposurePriority;
#else
	*a = (enum tt__ExposurePriority)0;
#endif
}

static const struct soap_code_map soap_codes_tt__ExposurePriority[] =
{	{ (long)LowNoise, "LowNoise" },
	{ (long)FrameRate, "FrameRate" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__ExposurePriority2s(struct soap *soap, enum tt__ExposurePriority n)
{	const char *s = soap_code_str(soap_codes_tt__ExposurePriority, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__ExposurePriority(struct soap *soap, const char *tag, int id, const enum tt__ExposurePriority *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__ExposurePriority), type) || soap_send(soap, soap_tt__ExposurePriority2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__ExposurePriority(struct soap *soap, const char *s, enum tt__ExposurePriority *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__ExposurePriority, s);
	if (map)
		*a = (enum tt__ExposurePriority)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__ExposurePriority)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__ExposurePriority * SOAP_FMAC4 soap_in_tt__ExposurePriority(struct soap *soap, const char *tag, enum tt__ExposurePriority *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__ExposurePriority *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__ExposurePriority, sizeof(enum tt__ExposurePriority), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__ExposurePriority(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__ExposurePriority *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__ExposurePriority, 0, sizeof(enum tt__ExposurePriority), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__ExposurePriority(struct soap *soap, const enum tt__ExposurePriority *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__ExposurePriority);
	if (soap_out_tt__ExposurePriority(soap, tag?tag:"tt:ExposurePriority", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__ExposurePriority * SOAP_FMAC4 soap_get_tt__ExposurePriority(struct soap *soap, enum tt__ExposurePriority *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__ExposurePriority(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__BacklightCompensationMode(struct soap *soap, enum tt__BacklightCompensationMode *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__BacklightCompensationMode
	*a = SOAP_DEFAULT_tt__BacklightCompensationMode;
#else
	*a = (enum tt__BacklightCompensationMode)0;
#endif
}

static const struct soap_code_map soap_codes_tt__BacklightCompensationMode[] =
{	{ (long)OFF_, "OFF" },
	{ (long)ON_, "ON" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__BacklightCompensationMode2s(struct soap *soap, enum tt__BacklightCompensationMode n)
{	const char *s = soap_code_str(soap_codes_tt__BacklightCompensationMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__BacklightCompensationMode(struct soap *soap, const char *tag, int id, const enum tt__BacklightCompensationMode *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__BacklightCompensationMode), type) || soap_send(soap, soap_tt__BacklightCompensationMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__BacklightCompensationMode(struct soap *soap, const char *s, enum tt__BacklightCompensationMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__BacklightCompensationMode, s);
	if (map)
		*a = (enum tt__BacklightCompensationMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__BacklightCompensationMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__BacklightCompensationMode * SOAP_FMAC4 soap_in_tt__BacklightCompensationMode(struct soap *soap, const char *tag, enum tt__BacklightCompensationMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__BacklightCompensationMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__BacklightCompensationMode, sizeof(enum tt__BacklightCompensationMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__BacklightCompensationMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__BacklightCompensationMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__BacklightCompensationMode, 0, sizeof(enum tt__BacklightCompensationMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__BacklightCompensationMode(struct soap *soap, const enum tt__BacklightCompensationMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__BacklightCompensationMode);
	if (soap_out_tt__BacklightCompensationMode(soap, tag?tag:"tt:BacklightCompensationMode", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__BacklightCompensationMode * SOAP_FMAC4 soap_get_tt__BacklightCompensationMode(struct soap *soap, enum tt__BacklightCompensationMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__BacklightCompensationMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__WideDynamicMode(struct soap *soap, enum tt__WideDynamicMode *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__WideDynamicMode
	*a = SOAP_DEFAULT_tt__WideDynamicMode;
#else
	*a = (enum tt__WideDynamicMode)0;
#endif
}

static const struct soap_code_map soap_codes_tt__WideDynamicMode[] =
{	{ (long)OFF, "OFF" },
	{ (long)ON, "ON" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__WideDynamicMode2s(struct soap *soap, enum tt__WideDynamicMode n)
{	const char *s = soap_code_str(soap_codes_tt__WideDynamicMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__WideDynamicMode(struct soap *soap, const char *tag, int id, const enum tt__WideDynamicMode *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__WideDynamicMode), type) || soap_send(soap, soap_tt__WideDynamicMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__WideDynamicMode(struct soap *soap, const char *s, enum tt__WideDynamicMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__WideDynamicMode, s);
	if (map)
		*a = (enum tt__WideDynamicMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__WideDynamicMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__WideDynamicMode * SOAP_FMAC4 soap_in_tt__WideDynamicMode(struct soap *soap, const char *tag, enum tt__WideDynamicMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__WideDynamicMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__WideDynamicMode, sizeof(enum tt__WideDynamicMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__WideDynamicMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__WideDynamicMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__WideDynamicMode, 0, sizeof(enum tt__WideDynamicMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__WideDynamicMode(struct soap *soap, const enum tt__WideDynamicMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__WideDynamicMode);
	if (soap_out_tt__WideDynamicMode(soap, tag?tag:"tt:WideDynamicMode", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__WideDynamicMode * SOAP_FMAC4 soap_get_tt__WideDynamicMode(struct soap *soap, enum tt__WideDynamicMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__WideDynamicMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__AutoFocusMode(struct soap *soap, enum tt__AutoFocusMode *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__AutoFocusMode
	*a = SOAP_DEFAULT_tt__AutoFocusMode;
#else
	*a = (enum tt__AutoFocusMode)0;
#endif
}

static const struct soap_code_map soap_codes_tt__AutoFocusMode[] =
{	{ (long)_AUTO_, "AUTO" },
	{ (long)_MANUAL_, "MANUAL" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__AutoFocusMode2s(struct soap *soap, enum tt__AutoFocusMode n)
{	const char *s = soap_code_str(soap_codes_tt__AutoFocusMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__AutoFocusMode(struct soap *soap, const char *tag, int id, const enum tt__AutoFocusMode *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__AutoFocusMode), type) || soap_send(soap, soap_tt__AutoFocusMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__AutoFocusMode(struct soap *soap, const char *s, enum tt__AutoFocusMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__AutoFocusMode, s);
	if (map)
		*a = (enum tt__AutoFocusMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__AutoFocusMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__AutoFocusMode * SOAP_FMAC4 soap_in_tt__AutoFocusMode(struct soap *soap, const char *tag, enum tt__AutoFocusMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__AutoFocusMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__AutoFocusMode, sizeof(enum tt__AutoFocusMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__AutoFocusMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__AutoFocusMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__AutoFocusMode, 0, sizeof(enum tt__AutoFocusMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__AutoFocusMode(struct soap *soap, const enum tt__AutoFocusMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__AutoFocusMode);
	if (soap_out_tt__AutoFocusMode(soap, tag?tag:"tt:AutoFocusMode", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__AutoFocusMode * SOAP_FMAC4 soap_get_tt__AutoFocusMode(struct soap *soap, enum tt__AutoFocusMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__AutoFocusMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__MoveStatus(struct soap *soap, enum tt__MoveStatus *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__MoveStatus
	*a = SOAP_DEFAULT_tt__MoveStatus;
#else
	*a = (enum tt__MoveStatus)0;
#endif
}

static const struct soap_code_map soap_codes_tt__MoveStatus[] =
{	{ (long)_IDLE_, "IDLE" },
	{ (long)_MOVING_, "MOVING" },
	{ (long)_UNKNOWN_, "UNKNOWN" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__MoveStatus2s(struct soap *soap, enum tt__MoveStatus n)
{	const char *s = soap_code_str(soap_codes_tt__MoveStatus, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__MoveStatus(struct soap *soap, const char *tag, int id, const enum tt__MoveStatus *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__MoveStatus), type) || soap_send(soap, soap_tt__MoveStatus2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__MoveStatus(struct soap *soap, const char *s, enum tt__MoveStatus *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__MoveStatus, s);
	if (map)
		*a = (enum tt__MoveStatus)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__MoveStatus)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__MoveStatus * SOAP_FMAC4 soap_in_tt__MoveStatus(struct soap *soap, const char *tag, enum tt__MoveStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__MoveStatus *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__MoveStatus, sizeof(enum tt__MoveStatus), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__MoveStatus(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__MoveStatus *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__MoveStatus, 0, sizeof(enum tt__MoveStatus), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__MoveStatus(struct soap *soap, const enum tt__MoveStatus *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__MoveStatus);
	if (soap_out_tt__MoveStatus(soap, tag?tag:"tt:MoveStatus", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__MoveStatus * SOAP_FMAC4 soap_get_tt__MoveStatus(struct soap *soap, enum tt__MoveStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__MoveStatus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__RelayMode(struct soap *soap, enum tt__RelayMode *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__RelayMode
	*a = SOAP_DEFAULT_tt__RelayMode;
#else
	*a = (enum tt__RelayMode)0;
#endif
}

static const struct soap_code_map soap_codes_tt__RelayMode[] =
{	{ (long)Monostable, "Monostable" },
	{ (long)Bistable, "Bistable" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__RelayMode2s(struct soap *soap, enum tt__RelayMode n)
{	const char *s = soap_code_str(soap_codes_tt__RelayMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__RelayMode(struct soap *soap, const char *tag, int id, const enum tt__RelayMode *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__RelayMode), type) || soap_send(soap, soap_tt__RelayMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__RelayMode(struct soap *soap, const char *s, enum tt__RelayMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__RelayMode, s);
	if (map)
		*a = (enum tt__RelayMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__RelayMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__RelayMode * SOAP_FMAC4 soap_in_tt__RelayMode(struct soap *soap, const char *tag, enum tt__RelayMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__RelayMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__RelayMode, sizeof(enum tt__RelayMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__RelayMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__RelayMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__RelayMode, 0, sizeof(enum tt__RelayMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__RelayMode(struct soap *soap, const enum tt__RelayMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__RelayMode);
	if (soap_out_tt__RelayMode(soap, tag?tag:"tt:RelayMode", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__RelayMode * SOAP_FMAC4 soap_get_tt__RelayMode(struct soap *soap, enum tt__RelayMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__RelayMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__RelayIdleState(struct soap *soap, enum tt__RelayIdleState *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__RelayIdleState
	*a = SOAP_DEFAULT_tt__RelayIdleState;
#else
	*a = (enum tt__RelayIdleState)0;
#endif
}

static const struct soap_code_map soap_codes_tt__RelayIdleState[] =
{	{ (long)_closed_, "closed" },
	{ (long)_open_, "open" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__RelayIdleState2s(struct soap *soap, enum tt__RelayIdleState n)
{	const char *s = soap_code_str(soap_codes_tt__RelayIdleState, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__RelayIdleState(struct soap *soap, const char *tag, int id, const enum tt__RelayIdleState *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__RelayIdleState), type) || soap_send(soap, soap_tt__RelayIdleState2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__RelayIdleState(struct soap *soap, const char *s, enum tt__RelayIdleState *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__RelayIdleState, s);
	if (map)
		*a = (enum tt__RelayIdleState)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__RelayIdleState)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__RelayIdleState * SOAP_FMAC4 soap_in_tt__RelayIdleState(struct soap *soap, const char *tag, enum tt__RelayIdleState *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__RelayIdleState *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__RelayIdleState, sizeof(enum tt__RelayIdleState), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__RelayIdleState(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__RelayIdleState *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__RelayIdleState, 0, sizeof(enum tt__RelayIdleState), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__RelayIdleState(struct soap *soap, const enum tt__RelayIdleState *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__RelayIdleState);
	if (soap_out_tt__RelayIdleState(soap, tag?tag:"tt:RelayIdleState", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__RelayIdleState * SOAP_FMAC4 soap_get_tt__RelayIdleState(struct soap *soap, enum tt__RelayIdleState *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__RelayIdleState(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__RelayLogicalState(struct soap *soap, enum tt__RelayLogicalState *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__RelayLogicalState
	*a = SOAP_DEFAULT_tt__RelayLogicalState;
#else
	*a = (enum tt__RelayLogicalState)0;
#endif
}

static const struct soap_code_map soap_codes_tt__RelayLogicalState[] =
{	{ (long)active, "active" },
	{ (long)inactive, "inactive" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__RelayLogicalState2s(struct soap *soap, enum tt__RelayLogicalState n)
{	const char *s = soap_code_str(soap_codes_tt__RelayLogicalState, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__RelayLogicalState(struct soap *soap, const char *tag, int id, const enum tt__RelayLogicalState *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__RelayLogicalState), type) || soap_send(soap, soap_tt__RelayLogicalState2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__RelayLogicalState(struct soap *soap, const char *s, enum tt__RelayLogicalState *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__RelayLogicalState, s);
	if (map)
		*a = (enum tt__RelayLogicalState)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__RelayLogicalState)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__RelayLogicalState * SOAP_FMAC4 soap_in_tt__RelayLogicalState(struct soap *soap, const char *tag, enum tt__RelayLogicalState *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__RelayLogicalState *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__RelayLogicalState, sizeof(enum tt__RelayLogicalState), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__RelayLogicalState(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__RelayLogicalState *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__RelayLogicalState, 0, sizeof(enum tt__RelayLogicalState), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__RelayLogicalState(struct soap *soap, const enum tt__RelayLogicalState *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__RelayLogicalState);
	if (soap_out_tt__RelayLogicalState(soap, tag?tag:"tt:RelayLogicalState", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__RelayLogicalState * SOAP_FMAC4 soap_get_tt__RelayLogicalState(struct soap *soap, enum tt__RelayLogicalState *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__RelayLogicalState(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__UserLevel(struct soap *soap, enum tt__UserLevel *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__UserLevel
	*a = SOAP_DEFAULT_tt__UserLevel;
#else
	*a = (enum tt__UserLevel)0;
#endif
}

static const struct soap_code_map soap_codes_tt__UserLevel[] =
{	{ (long)Administrator, "Administrator" },
	{ (long)Operator, "Operator" },
	{ (long)User, "User" },
	{ (long)Anonymous, "Anonymous" },
	{ (long)Extended_, "Extended" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__UserLevel2s(struct soap *soap, enum tt__UserLevel n)
{	const char *s = soap_code_str(soap_codes_tt__UserLevel, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__UserLevel(struct soap *soap, const char *tag, int id, const enum tt__UserLevel *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__UserLevel), type) || soap_send(soap, soap_tt__UserLevel2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__UserLevel(struct soap *soap, const char *s, enum tt__UserLevel *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__UserLevel, s);
	if (map)
		*a = (enum tt__UserLevel)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 4)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__UserLevel)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__UserLevel * SOAP_FMAC4 soap_in_tt__UserLevel(struct soap *soap, const char *tag, enum tt__UserLevel *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__UserLevel *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__UserLevel, sizeof(enum tt__UserLevel), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__UserLevel(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__UserLevel *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__UserLevel, 0, sizeof(enum tt__UserLevel), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__UserLevel(struct soap *soap, const enum tt__UserLevel *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__UserLevel);
	if (soap_out_tt__UserLevel(soap, tag?tag:"tt:UserLevel", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__UserLevel * SOAP_FMAC4 soap_get_tt__UserLevel(struct soap *soap, enum tt__UserLevel *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__UserLevel(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__SetDateTimeType(struct soap *soap, enum tt__SetDateTimeType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__SetDateTimeType
	*a = SOAP_DEFAULT_tt__SetDateTimeType;
#else
	*a = (enum tt__SetDateTimeType)0;
#endif
}

static const struct soap_code_map soap_codes_tt__SetDateTimeType[] =
{	{ (long)Manual, "Manual" },
	{ (long)NTP, "NTP" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__SetDateTimeType2s(struct soap *soap, enum tt__SetDateTimeType n)
{	const char *s = soap_code_str(soap_codes_tt__SetDateTimeType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__SetDateTimeType(struct soap *soap, const char *tag, int id, const enum tt__SetDateTimeType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__SetDateTimeType), type) || soap_send(soap, soap_tt__SetDateTimeType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__SetDateTimeType(struct soap *soap, const char *s, enum tt__SetDateTimeType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__SetDateTimeType, s);
	if (map)
		*a = (enum tt__SetDateTimeType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__SetDateTimeType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__SetDateTimeType * SOAP_FMAC4 soap_in_tt__SetDateTimeType(struct soap *soap, const char *tag, enum tt__SetDateTimeType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__SetDateTimeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__SetDateTimeType, sizeof(enum tt__SetDateTimeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__SetDateTimeType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__SetDateTimeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__SetDateTimeType, 0, sizeof(enum tt__SetDateTimeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__SetDateTimeType(struct soap *soap, const enum tt__SetDateTimeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__SetDateTimeType);
	if (soap_out_tt__SetDateTimeType(soap, tag?tag:"tt:SetDateTimeType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__SetDateTimeType * SOAP_FMAC4 soap_get_tt__SetDateTimeType(struct soap *soap, enum tt__SetDateTimeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__SetDateTimeType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__FactoryDefaultType(struct soap *soap, enum tt__FactoryDefaultType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__FactoryDefaultType
	*a = SOAP_DEFAULT_tt__FactoryDefaultType;
#else
	*a = (enum tt__FactoryDefaultType)0;
#endif
}

static const struct soap_code_map soap_codes_tt__FactoryDefaultType[] =
{	{ (long)Hard, "Hard" },
	{ (long)Soft, "Soft" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__FactoryDefaultType2s(struct soap *soap, enum tt__FactoryDefaultType n)
{	const char *s = soap_code_str(soap_codes_tt__FactoryDefaultType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__FactoryDefaultType(struct soap *soap, const char *tag, int id, const enum tt__FactoryDefaultType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__FactoryDefaultType), type) || soap_send(soap, soap_tt__FactoryDefaultType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__FactoryDefaultType(struct soap *soap, const char *s, enum tt__FactoryDefaultType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__FactoryDefaultType, s);
	if (map)
		*a = (enum tt__FactoryDefaultType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__FactoryDefaultType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__FactoryDefaultType * SOAP_FMAC4 soap_in_tt__FactoryDefaultType(struct soap *soap, const char *tag, enum tt__FactoryDefaultType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__FactoryDefaultType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__FactoryDefaultType, sizeof(enum tt__FactoryDefaultType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__FactoryDefaultType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__FactoryDefaultType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__FactoryDefaultType, 0, sizeof(enum tt__FactoryDefaultType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__FactoryDefaultType(struct soap *soap, const enum tt__FactoryDefaultType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__FactoryDefaultType);
	if (soap_out_tt__FactoryDefaultType(soap, tag?tag:"tt:FactoryDefaultType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__FactoryDefaultType * SOAP_FMAC4 soap_get_tt__FactoryDefaultType(struct soap *soap, enum tt__FactoryDefaultType *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__FactoryDefaultType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__SystemLogType(struct soap *soap, enum tt__SystemLogType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__SystemLogType
	*a = SOAP_DEFAULT_tt__SystemLogType;
#else
	*a = (enum tt__SystemLogType)0;
#endif
}

static const struct soap_code_map soap_codes_tt__SystemLogType[] =
{	{ (long)System, "System" },
	{ (long)Access, "Access" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__SystemLogType2s(struct soap *soap, enum tt__SystemLogType n)
{	const char *s = soap_code_str(soap_codes_tt__SystemLogType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__SystemLogType(struct soap *soap, const char *tag, int id, const enum tt__SystemLogType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__SystemLogType), type) || soap_send(soap, soap_tt__SystemLogType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__SystemLogType(struct soap *soap, const char *s, enum tt__SystemLogType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__SystemLogType, s);
	if (map)
		*a = (enum tt__SystemLogType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__SystemLogType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__SystemLogType * SOAP_FMAC4 soap_in_tt__SystemLogType(struct soap *soap, const char *tag, enum tt__SystemLogType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__SystemLogType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__SystemLogType, sizeof(enum tt__SystemLogType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__SystemLogType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__SystemLogType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__SystemLogType, 0, sizeof(enum tt__SystemLogType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__SystemLogType(struct soap *soap, const enum tt__SystemLogType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__SystemLogType);
	if (soap_out_tt__SystemLogType(soap, tag?tag:"tt:SystemLogType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__SystemLogType * SOAP_FMAC4 soap_get_tt__SystemLogType(struct soap *soap, enum tt__SystemLogType *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__SystemLogType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__CapabilityCategory(struct soap *soap, enum tt__CapabilityCategory *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__CapabilityCategory
	*a = SOAP_DEFAULT_tt__CapabilityCategory;
#else
	*a = (enum tt__CapabilityCategory)0;
#endif
}

static const struct soap_code_map soap_codes_tt__CapabilityCategory[] =
{	{ (long)All, "All" },
	{ (long)Analytics, "Analytics" },
	{ (long)Device, "Device" },
	{ (long)Events, "Events" },
	{ (long)Imaging, "Imaging" },
	{ (long)Media, "Media" },
	{ (long)PTZ, "PTZ" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__CapabilityCategory2s(struct soap *soap, enum tt__CapabilityCategory n)
{	const char *s = soap_code_str(soap_codes_tt__CapabilityCategory, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__CapabilityCategory(struct soap *soap, const char *tag, int id, const enum tt__CapabilityCategory *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__CapabilityCategory), type) || soap_send(soap, soap_tt__CapabilityCategory2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__CapabilityCategory(struct soap *soap, const char *s, enum tt__CapabilityCategory *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__CapabilityCategory, s);
	if (map)
		*a = (enum tt__CapabilityCategory)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 6)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__CapabilityCategory)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__CapabilityCategory * SOAP_FMAC4 soap_in_tt__CapabilityCategory(struct soap *soap, const char *tag, enum tt__CapabilityCategory *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__CapabilityCategory *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__CapabilityCategory, sizeof(enum tt__CapabilityCategory), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__CapabilityCategory(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__CapabilityCategory *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__CapabilityCategory, 0, sizeof(enum tt__CapabilityCategory), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__CapabilityCategory(struct soap *soap, const enum tt__CapabilityCategory *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__CapabilityCategory);
	if (soap_out_tt__CapabilityCategory(soap, tag?tag:"tt:CapabilityCategory", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__CapabilityCategory * SOAP_FMAC4 soap_get_tt__CapabilityCategory(struct soap *soap, enum tt__CapabilityCategory *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__CapabilityCategory(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__DynamicDNSType(struct soap *soap, enum tt__DynamicDNSType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__DynamicDNSType
	*a = SOAP_DEFAULT_tt__DynamicDNSType;
#else
	*a = (enum tt__DynamicDNSType)0;
#endif
}

static const struct soap_code_map soap_codes_tt__DynamicDNSType[] =
{	{ (long)NoUpdate, "NoUpdate" },
	{ (long)ClientUpdates, "ClientUpdates" },
	{ (long)ServerUpdates, "ServerUpdates" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__DynamicDNSType2s(struct soap *soap, enum tt__DynamicDNSType n)
{	const char *s = soap_code_str(soap_codes_tt__DynamicDNSType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__DynamicDNSType(struct soap *soap, const char *tag, int id, const enum tt__DynamicDNSType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__DynamicDNSType), type) || soap_send(soap, soap_tt__DynamicDNSType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__DynamicDNSType(struct soap *soap, const char *s, enum tt__DynamicDNSType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__DynamicDNSType, s);
	if (map)
		*a = (enum tt__DynamicDNSType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__DynamicDNSType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__DynamicDNSType * SOAP_FMAC4 soap_in_tt__DynamicDNSType(struct soap *soap, const char *tag, enum tt__DynamicDNSType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__DynamicDNSType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__DynamicDNSType, sizeof(enum tt__DynamicDNSType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__DynamicDNSType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__DynamicDNSType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__DynamicDNSType, 0, sizeof(enum tt__DynamicDNSType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__DynamicDNSType(struct soap *soap, const enum tt__DynamicDNSType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__DynamicDNSType);
	if (soap_out_tt__DynamicDNSType(soap, tag?tag:"tt:DynamicDNSType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__DynamicDNSType * SOAP_FMAC4 soap_get_tt__DynamicDNSType(struct soap *soap, enum tt__DynamicDNSType *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__DynamicDNSType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__IPType(struct soap *soap, enum tt__IPType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__IPType
	*a = SOAP_DEFAULT_tt__IPType;
#else
	*a = (enum tt__IPType)0;
#endif
}

static const struct soap_code_map soap_codes_tt__IPType[] =
{	{ (long)IPv4_, "IPv4" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__IPType2s(struct soap *soap, enum tt__IPType n)
{	const char *s = soap_code_str(soap_codes_tt__IPType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__IPType(struct soap *soap, const char *tag, int id, const enum tt__IPType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__IPType), type) || soap_send(soap, soap_tt__IPType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__IPType(struct soap *soap, const char *s, enum tt__IPType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__IPType, s);
	if (map)
		*a = (enum tt__IPType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__IPType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__IPType * SOAP_FMAC4 soap_in_tt__IPType(struct soap *soap, const char *tag, enum tt__IPType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__IPType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__IPType, sizeof(enum tt__IPType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__IPType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__IPType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__IPType, 0, sizeof(enum tt__IPType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__IPType(struct soap *soap, const enum tt__IPType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__IPType);
	if (soap_out_tt__IPType(soap, tag?tag:"tt:IPType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__IPType * SOAP_FMAC4 soap_get_tt__IPType(struct soap *soap, enum tt__IPType *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__IPType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__NetworkHostType(struct soap *soap, enum tt__NetworkHostType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__NetworkHostType
	*a = SOAP_DEFAULT_tt__NetworkHostType;
#else
	*a = (enum tt__NetworkHostType)0;
#endif
}

static const struct soap_code_map soap_codes_tt__NetworkHostType[] =
{	{ (long)IPv4, "IPv4" },
	{ (long)DNS, "DNS" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__NetworkHostType2s(struct soap *soap, enum tt__NetworkHostType n)
{	const char *s = soap_code_str(soap_codes_tt__NetworkHostType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__NetworkHostType(struct soap *soap, const char *tag, int id, const enum tt__NetworkHostType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__NetworkHostType), type) || soap_send(soap, soap_tt__NetworkHostType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__NetworkHostType(struct soap *soap, const char *s, enum tt__NetworkHostType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__NetworkHostType, s);
	if (map)
		*a = (enum tt__NetworkHostType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__NetworkHostType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__NetworkHostType * SOAP_FMAC4 soap_in_tt__NetworkHostType(struct soap *soap, const char *tag, enum tt__NetworkHostType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__NetworkHostType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__NetworkHostType, sizeof(enum tt__NetworkHostType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__NetworkHostType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__NetworkHostType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__NetworkHostType, 0, sizeof(enum tt__NetworkHostType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__NetworkHostType(struct soap *soap, const enum tt__NetworkHostType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__NetworkHostType);
	if (soap_out_tt__NetworkHostType(soap, tag?tag:"tt:NetworkHostType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__NetworkHostType * SOAP_FMAC4 soap_get_tt__NetworkHostType(struct soap *soap, enum tt__NetworkHostType *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__NetworkHostType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__NetworkProtocolType(struct soap *soap, enum tt__NetworkProtocolType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__NetworkProtocolType
	*a = SOAP_DEFAULT_tt__NetworkProtocolType;
#else
	*a = (enum tt__NetworkProtocolType)0;
#endif
}

static const struct soap_code_map soap_codes_tt__NetworkProtocolType[] =
{	{ (long)HTTP_, "HTTP" },
	{ (long)HTTPS, "HTTPS" },
	{ (long)RTSP_, "RTSP" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__NetworkProtocolType2s(struct soap *soap, enum tt__NetworkProtocolType n)
{	const char *s = soap_code_str(soap_codes_tt__NetworkProtocolType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__NetworkProtocolType(struct soap *soap, const char *tag, int id, const enum tt__NetworkProtocolType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__NetworkProtocolType), type) || soap_send(soap, soap_tt__NetworkProtocolType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__NetworkProtocolType(struct soap *soap, const char *s, enum tt__NetworkProtocolType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__NetworkProtocolType, s);
	if (map)
		*a = (enum tt__NetworkProtocolType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__NetworkProtocolType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__NetworkProtocolType * SOAP_FMAC4 soap_in_tt__NetworkProtocolType(struct soap *soap, const char *tag, enum tt__NetworkProtocolType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__NetworkProtocolType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__NetworkProtocolType, sizeof(enum tt__NetworkProtocolType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__NetworkProtocolType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__NetworkProtocolType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__NetworkProtocolType, 0, sizeof(enum tt__NetworkProtocolType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__NetworkProtocolType(struct soap *soap, const enum tt__NetworkProtocolType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__NetworkProtocolType);
	if (soap_out_tt__NetworkProtocolType(soap, tag?tag:"tt:NetworkProtocolType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__NetworkProtocolType * SOAP_FMAC4 soap_get_tt__NetworkProtocolType(struct soap *soap, enum tt__NetworkProtocolType *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__NetworkProtocolType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__Duplex(struct soap *soap, enum tt__Duplex *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__Duplex
	*a = SOAP_DEFAULT_tt__Duplex;
#else
	*a = (enum tt__Duplex)0;
#endif
}

static const struct soap_code_map soap_codes_tt__Duplex[] =
{	{ (long)Full, "Full" },
	{ (long)Half, "Half" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__Duplex2s(struct soap *soap, enum tt__Duplex n)
{	const char *s = soap_code_str(soap_codes_tt__Duplex, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__Duplex(struct soap *soap, const char *tag, int id, const enum tt__Duplex *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__Duplex), type) || soap_send(soap, soap_tt__Duplex2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__Duplex(struct soap *soap, const char *s, enum tt__Duplex *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__Duplex, s);
	if (map)
		*a = (enum tt__Duplex)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__Duplex)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__Duplex * SOAP_FMAC4 soap_in_tt__Duplex(struct soap *soap, const char *tag, enum tt__Duplex *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__Duplex *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__Duplex, sizeof(enum tt__Duplex), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__Duplex(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__Duplex *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__Duplex, 0, sizeof(enum tt__Duplex), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__Duplex(struct soap *soap, const enum tt__Duplex *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__Duplex);
	if (soap_out_tt__Duplex(soap, tag?tag:"tt:Duplex", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__Duplex * SOAP_FMAC4 soap_get_tt__Duplex(struct soap *soap, enum tt__Duplex *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__Duplex(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__DiscoveryMode(struct soap *soap, enum tt__DiscoveryMode *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__DiscoveryMode
	*a = SOAP_DEFAULT_tt__DiscoveryMode;
#else
	*a = (enum tt__DiscoveryMode)0;
#endif
}

static const struct soap_code_map soap_codes_tt__DiscoveryMode[] =
{	{ (long)Discoverable, "Discoverable" },
	{ (long)NonDiscoverable, "NonDiscoverable" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__DiscoveryMode2s(struct soap *soap, enum tt__DiscoveryMode n)
{	const char *s = soap_code_str(soap_codes_tt__DiscoveryMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__DiscoveryMode(struct soap *soap, const char *tag, int id, const enum tt__DiscoveryMode *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__DiscoveryMode), type) || soap_send(soap, soap_tt__DiscoveryMode2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__DiscoveryMode(struct soap *soap, const char *s, enum tt__DiscoveryMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__DiscoveryMode, s);
	if (map)
		*a = (enum tt__DiscoveryMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__DiscoveryMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__DiscoveryMode * SOAP_FMAC4 soap_in_tt__DiscoveryMode(struct soap *soap, const char *tag, enum tt__DiscoveryMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__DiscoveryMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__DiscoveryMode, sizeof(enum tt__DiscoveryMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__DiscoveryMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__DiscoveryMode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__DiscoveryMode, 0, sizeof(enum tt__DiscoveryMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__DiscoveryMode(struct soap *soap, const enum tt__DiscoveryMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__DiscoveryMode);
	if (soap_out_tt__DiscoveryMode(soap, tag?tag:"tt:DiscoveryMode", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__DiscoveryMode * SOAP_FMAC4 soap_get_tt__DiscoveryMode(struct soap *soap, enum tt__DiscoveryMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__DiscoveryMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__ScopeDefinition(struct soap *soap, enum tt__ScopeDefinition *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__ScopeDefinition
	*a = SOAP_DEFAULT_tt__ScopeDefinition;
#else
	*a = (enum tt__ScopeDefinition)0;
#endif
}

static const struct soap_code_map soap_codes_tt__ScopeDefinition[] =
{	{ (long)Fixed, "Fixed" },
	{ (long)Configurable, "Configurable" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__ScopeDefinition2s(struct soap *soap, enum tt__ScopeDefinition n)
{	const char *s = soap_code_str(soap_codes_tt__ScopeDefinition, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__ScopeDefinition(struct soap *soap, const char *tag, int id, const enum tt__ScopeDefinition *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__ScopeDefinition), type) || soap_send(soap, soap_tt__ScopeDefinition2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__ScopeDefinition(struct soap *soap, const char *s, enum tt__ScopeDefinition *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__ScopeDefinition, s);
	if (map)
		*a = (enum tt__ScopeDefinition)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__ScopeDefinition)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__ScopeDefinition * SOAP_FMAC4 soap_in_tt__ScopeDefinition(struct soap *soap, const char *tag, enum tt__ScopeDefinition *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__ScopeDefinition *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__ScopeDefinition, sizeof(enum tt__ScopeDefinition), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__ScopeDefinition(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__ScopeDefinition *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__ScopeDefinition, 0, sizeof(enum tt__ScopeDefinition), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__ScopeDefinition(struct soap *soap, const enum tt__ScopeDefinition *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__ScopeDefinition);
	if (soap_out_tt__ScopeDefinition(soap, tag?tag:"tt:ScopeDefinition", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__ScopeDefinition * SOAP_FMAC4 soap_get_tt__ScopeDefinition(struct soap *soap, enum tt__ScopeDefinition *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__ScopeDefinition(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__TransportProtocol(struct soap *soap, enum tt__TransportProtocol *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__TransportProtocol
	*a = SOAP_DEFAULT_tt__TransportProtocol;
#else
	*a = (enum tt__TransportProtocol)0;
#endif
}

static const struct soap_code_map soap_codes_tt__TransportProtocol[] =
{	{ (long)UDP, "UDP" },
	{ (long)TCP, "TCP" },
	{ (long)RTSP, "RTSP" },
	{ (long)HTTP, "HTTP" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__TransportProtocol2s(struct soap *soap, enum tt__TransportProtocol n)
{	const char *s = soap_code_str(soap_codes_tt__TransportProtocol, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__TransportProtocol(struct soap *soap, const char *tag, int id, const enum tt__TransportProtocol *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__TransportProtocol), type) || soap_send(soap, soap_tt__TransportProtocol2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__TransportProtocol(struct soap *soap, const char *s, enum tt__TransportProtocol *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__TransportProtocol, s);
	if (map)
		*a = (enum tt__TransportProtocol)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 3)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__TransportProtocol)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__TransportProtocol * SOAP_FMAC4 soap_in_tt__TransportProtocol(struct soap *soap, const char *tag, enum tt__TransportProtocol *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__TransportProtocol *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__TransportProtocol, sizeof(enum tt__TransportProtocol), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__TransportProtocol(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__TransportProtocol *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__TransportProtocol, 0, sizeof(enum tt__TransportProtocol), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__TransportProtocol(struct soap *soap, const enum tt__TransportProtocol *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__TransportProtocol);
	if (soap_out_tt__TransportProtocol(soap, tag?tag:"tt:TransportProtocol", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__TransportProtocol * SOAP_FMAC4 soap_get_tt__TransportProtocol(struct soap *soap, enum tt__TransportProtocol *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__TransportProtocol(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__StreamType(struct soap *soap, enum tt__StreamType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__StreamType
	*a = SOAP_DEFAULT_tt__StreamType;
#else
	*a = (enum tt__StreamType)0;
#endif
}

static const struct soap_code_map soap_codes_tt__StreamType[] =
{	{ (long)RTP_Unicast, "RTP-Unicast" },
	{ (long)RTP_Multicast, "RTP-Multicast" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__StreamType2s(struct soap *soap, enum tt__StreamType n)
{	const char *s = soap_code_str(soap_codes_tt__StreamType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__StreamType(struct soap *soap, const char *tag, int id, const enum tt__StreamType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__StreamType), type) || soap_send(soap, soap_tt__StreamType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__StreamType(struct soap *soap, const char *s, enum tt__StreamType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__StreamType, s);
	if (map)
		*a = (enum tt__StreamType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__StreamType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__StreamType * SOAP_FMAC4 soap_in_tt__StreamType(struct soap *soap, const char *tag, enum tt__StreamType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__StreamType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__StreamType, sizeof(enum tt__StreamType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__StreamType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__StreamType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__StreamType, 0, sizeof(enum tt__StreamType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__StreamType(struct soap *soap, const enum tt__StreamType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__StreamType);
	if (soap_out_tt__StreamType(soap, tag?tag:"tt:StreamType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__StreamType * SOAP_FMAC4 soap_get_tt__StreamType(struct soap *soap, enum tt__StreamType *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__StreamType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__AudioEncoding(struct soap *soap, enum tt__AudioEncoding *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__AudioEncoding
	*a = SOAP_DEFAULT_tt__AudioEncoding;
#else
	*a = (enum tt__AudioEncoding)0;
#endif
}

static const struct soap_code_map soap_codes_tt__AudioEncoding[] =
{	{ (long)G711, "G711" },
	{ (long)G726, "G726" },
	{ (long)AAC, "AAC" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__AudioEncoding2s(struct soap *soap, enum tt__AudioEncoding n)
{	const char *s = soap_code_str(soap_codes_tt__AudioEncoding, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__AudioEncoding(struct soap *soap, const char *tag, int id, const enum tt__AudioEncoding *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__AudioEncoding), type) || soap_send(soap, soap_tt__AudioEncoding2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__AudioEncoding(struct soap *soap, const char *s, enum tt__AudioEncoding *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__AudioEncoding, s);
	if (map)
		*a = (enum tt__AudioEncoding)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__AudioEncoding)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__AudioEncoding * SOAP_FMAC4 soap_in_tt__AudioEncoding(struct soap *soap, const char *tag, enum tt__AudioEncoding *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__AudioEncoding *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__AudioEncoding, sizeof(enum tt__AudioEncoding), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__AudioEncoding(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__AudioEncoding *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__AudioEncoding, 0, sizeof(enum tt__AudioEncoding), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__AudioEncoding(struct soap *soap, const enum tt__AudioEncoding *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__AudioEncoding);
	if (soap_out_tt__AudioEncoding(soap, tag?tag:"tt:AudioEncoding", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__AudioEncoding * SOAP_FMAC4 soap_get_tt__AudioEncoding(struct soap *soap, enum tt__AudioEncoding *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__AudioEncoding(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__H264Profile(struct soap *soap, enum tt__H264Profile *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__H264Profile
	*a = SOAP_DEFAULT_tt__H264Profile;
#else
	*a = (enum tt__H264Profile)0;
#endif
}

static const struct soap_code_map soap_codes_tt__H264Profile[] =
{	{ (long)Baseline, "Baseline" },
	{ (long)Main, "Main" },
	{ (long)Extended, "Extended" },
	{ (long)High, "High" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__H264Profile2s(struct soap *soap, enum tt__H264Profile n)
{	const char *s = soap_code_str(soap_codes_tt__H264Profile, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__H264Profile(struct soap *soap, const char *tag, int id, const enum tt__H264Profile *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__H264Profile), type) || soap_send(soap, soap_tt__H264Profile2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__H264Profile(struct soap *soap, const char *s, enum tt__H264Profile *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__H264Profile, s);
	if (map)
		*a = (enum tt__H264Profile)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 3)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__H264Profile)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__H264Profile * SOAP_FMAC4 soap_in_tt__H264Profile(struct soap *soap, const char *tag, enum tt__H264Profile *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__H264Profile *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__H264Profile, sizeof(enum tt__H264Profile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__H264Profile(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__H264Profile *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__H264Profile, 0, sizeof(enum tt__H264Profile), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__H264Profile(struct soap *soap, const enum tt__H264Profile *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__H264Profile);
	if (soap_out_tt__H264Profile(soap, tag?tag:"tt:H264Profile", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__H264Profile * SOAP_FMAC4 soap_get_tt__H264Profile(struct soap *soap, enum tt__H264Profile *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__H264Profile(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__Mpeg4Profile(struct soap *soap, enum tt__Mpeg4Profile *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__Mpeg4Profile
	*a = SOAP_DEFAULT_tt__Mpeg4Profile;
#else
	*a = (enum tt__Mpeg4Profile)0;
#endif
}

static const struct soap_code_map soap_codes_tt__Mpeg4Profile[] =
{	{ (long)SP, "SP" },
	{ (long)ASP, "ASP" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__Mpeg4Profile2s(struct soap *soap, enum tt__Mpeg4Profile n)
{	const char *s = soap_code_str(soap_codes_tt__Mpeg4Profile, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__Mpeg4Profile(struct soap *soap, const char *tag, int id, const enum tt__Mpeg4Profile *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__Mpeg4Profile), type) || soap_send(soap, soap_tt__Mpeg4Profile2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__Mpeg4Profile(struct soap *soap, const char *s, enum tt__Mpeg4Profile *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__Mpeg4Profile, s);
	if (map)
		*a = (enum tt__Mpeg4Profile)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__Mpeg4Profile)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__Mpeg4Profile * SOAP_FMAC4 soap_in_tt__Mpeg4Profile(struct soap *soap, const char *tag, enum tt__Mpeg4Profile *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__Mpeg4Profile *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__Mpeg4Profile, sizeof(enum tt__Mpeg4Profile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__Mpeg4Profile(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__Mpeg4Profile *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__Mpeg4Profile, 0, sizeof(enum tt__Mpeg4Profile), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__Mpeg4Profile(struct soap *soap, const enum tt__Mpeg4Profile *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__Mpeg4Profile);
	if (soap_out_tt__Mpeg4Profile(soap, tag?tag:"tt:Mpeg4Profile", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__Mpeg4Profile * SOAP_FMAC4 soap_get_tt__Mpeg4Profile(struct soap *soap, enum tt__Mpeg4Profile *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__Mpeg4Profile(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_tt__VideoEncoding(struct soap *soap, enum tt__VideoEncoding *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_tt__VideoEncoding
	*a = SOAP_DEFAULT_tt__VideoEncoding;
#else
	*a = (enum tt__VideoEncoding)0;
#endif
}

static const struct soap_code_map soap_codes_tt__VideoEncoding[] =
{	{ (long)JPEG, "JPEG" },
	{ (long)MPEG4, "MPEG4" },
	{ (long)H264, "H264" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_tt__VideoEncoding2s(struct soap *soap, enum tt__VideoEncoding n)
{	const char *s = soap_code_str(soap_codes_tt__VideoEncoding, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_tt__VideoEncoding(struct soap *soap, const char *tag, int id, const enum tt__VideoEncoding *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_tt__VideoEncoding), type) || soap_send(soap, soap_tt__VideoEncoding2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2tt__VideoEncoding(struct soap *soap, const char *s, enum tt__VideoEncoding *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_tt__VideoEncoding, s);
	if (map)
		*a = (enum tt__VideoEncoding)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum tt__VideoEncoding)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum tt__VideoEncoding * SOAP_FMAC4 soap_in_tt__VideoEncoding(struct soap *soap, const char *tag, enum tt__VideoEncoding *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum tt__VideoEncoding *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_tt__VideoEncoding, sizeof(enum tt__VideoEncoding), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2tt__VideoEncoding(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum tt__VideoEncoding *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_tt__VideoEncoding, 0, sizeof(enum tt__VideoEncoding), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_tt__VideoEncoding(struct soap *soap, const enum tt__VideoEncoding *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_tt__VideoEncoding);
	if (soap_out_tt__VideoEncoding(soap, tag?tag:"tt:VideoEncoding", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum tt__VideoEncoding * SOAP_FMAC4 soap_get_tt__VideoEncoding(struct soap *soap, enum tt__VideoEncoding *p, const char *tag, const char *type)
{
	if ((p = soap_in_tt__VideoEncoding(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__RelationshipType(struct soap *soap, enum wsa__RelationshipType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsa__RelationshipType
	*a = SOAP_DEFAULT_wsa__RelationshipType;
#else
	*a = (enum wsa__RelationshipType)0;
#endif
}

static const struct soap_code_map soap_codes_wsa__RelationshipType[] =
{	{ (long)http___x002f_x002fwww_x002ew3_x002eorg_x002f2005_x002f08_x002faddressing_x002freply, "http://www.w3.org/2005/08/addressing/reply" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsa__RelationshipType2s(struct soap *soap, enum wsa__RelationshipType n)
{	const char *s = soap_code_str(soap_codes_wsa__RelationshipType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__RelationshipType(struct soap *soap, const char *tag, int id, const enum wsa__RelationshipType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa__RelationshipType), type) || soap_send(soap, soap_wsa__RelationshipType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsa__RelationshipType(struct soap *soap, const char *s, enum wsa__RelationshipType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_wsa__RelationshipType, s);
	if (map)
		*a = (enum wsa__RelationshipType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsa__RelationshipType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsa__RelationshipType * SOAP_FMAC4 soap_in_wsa__RelationshipType(struct soap *soap, const char *tag, enum wsa__RelationshipType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsa__RelationshipType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__RelationshipType, sizeof(enum wsa__RelationshipType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsa__RelationshipType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsa__RelationshipType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa__RelationshipType, 0, sizeof(enum wsa__RelationshipType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__RelationshipType(struct soap *soap, const enum wsa__RelationshipType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__RelationshipType);
	if (soap_out_wsa__RelationshipType(soap, tag?tag:"wsa:RelationshipType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsa__RelationshipType * SOAP_FMAC4 soap_get_wsa__RelationshipType(struct soap *soap, enum wsa__RelationshipType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__RelationshipType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__boolean(struct soap *soap, enum xsd__boolean *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_xsd__boolean
	*a = SOAP_DEFAULT_xsd__boolean;
#else
	*a = (enum xsd__boolean)0;
#endif
}

static const struct soap_code_map soap_codes_xsd__boolean[] =
{	{ (long)false_, "false" },
	{ (long)true_, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_xsd__boolean2s(struct soap *soap, enum xsd__boolean n)
{
	(void)soap; /* appease -Wall -Werror */
return soap_code_str(soap_codes_xsd__boolean, n!=0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__boolean(struct soap *soap, const char *tag, int id, const enum xsd__boolean *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xsd__boolean), type) || soap_send(soap, soap_xsd__boolean2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2xsd__boolean(struct soap *soap, const char *s, enum xsd__boolean *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_xsd__boolean, s);
	if (map)
		*a = (enum xsd__boolean)(map->code != 0);
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum xsd__boolean)(n != 0);
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum xsd__boolean * SOAP_FMAC4 soap_in_xsd__boolean(struct soap *soap, const char *tag, enum xsd__boolean *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum xsd__boolean *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__boolean, sizeof(enum xsd__boolean), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2xsd__boolean(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum xsd__boolean *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xsd__boolean, 0, sizeof(enum xsd__boolean), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__boolean(struct soap *soap, const enum xsd__boolean *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__boolean);
	if (soap_out_xsd__boolean(soap, tag?tag:"xsd:boolean", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum xsd__boolean * SOAP_FMAC4 soap_get_xsd__boolean(struct soap *soap, enum xsd__boolean *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__boolean(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	size_t soap_flag_faultcode = 1;
	size_t soap_flag_faultstring = 1;
	size_t soap_flag_faultactor = 1;
	size_t soap_flag_detail = 1;
	size_t soap_flag_SOAP_ENV__Code = 1;
	size_t soap_flag_SOAP_ENV__Reason = 1;
	size_t soap_flag_SOAP_ENV__Node = 1;
	size_t soap_flag_SOAP_ENV__Role = 1;
	size_t soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag?tag:"SOAP-ENV:Fault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap->lang)
		soap_set_attr(soap, "xml:lang", soap->lang);
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Value = 1;
	size_t soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__wsa__MessageID(soap, &a->wsa__MessageID);
	a->wsa__RelatesTo = NULL;
	a->wsa__From = NULL;
	a->wsa__ReplyTo = NULL;
	a->wsa__FaultTo = NULL;
	soap_default__wsa__To(soap, &a->wsa__To);
	soap_default__wsa__Action(soap, &a->wsa__Action);
	a->d__AppSequence = NULL;
	a->wsse__Security = NULL;
	soap_default_int(soap, &a->SubscriptionId);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__wsa__MessageID(soap, &a->wsa__MessageID);
	soap_serialize_PointerTo_wsa__RelatesTo(soap, &a->wsa__RelatesTo);
	soap_serialize_PointerTo_wsa__From(soap, &a->wsa__From);
	soap_serialize_PointerTo_wsa__ReplyTo(soap, &a->wsa__ReplyTo);
	soap_serialize_PointerTo_wsa__FaultTo(soap, &a->wsa__FaultTo);
	soap_serialize__wsa__To(soap, &a->wsa__To);
	soap_serialize__wsa__Action(soap, &a->wsa__Action);
	soap_serialize_PointerTo_d__AppSequence(soap, &a->d__AppSequence);
	soap_serialize_PointerTo_wsse__Security(soap, &a->wsse__Security);
	soap_embedded(soap, &a->SubscriptionId, SOAP_TYPE_int);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	if (soap_out__wsa__MessageID(soap, "wsa:MessageID", -1, &a->wsa__MessageID, ""))
		return soap->error;
	if (soap_out_PointerTo_wsa__RelatesTo(soap, "wsa:RelatesTo", -1, &a->wsa__RelatesTo, ""))
		return soap->error;
	if (soap_out_PointerTo_wsa__From(soap, "wsa:From", -1, &a->wsa__From, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out_PointerTo_wsa__ReplyTo(soap, "wsa:ReplyTo", -1, &a->wsa__ReplyTo, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out_PointerTo_wsa__FaultTo(soap, "wsa:FaultTo", -1, &a->wsa__FaultTo, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out__wsa__To(soap, "wsa:To", -1, &a->wsa__To, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out__wsa__Action(soap, "wsa:Action", -1, &a->wsa__Action, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out_PointerTo_d__AppSequence(soap, "d:AppSequence", -1, &a->d__AppSequence, ""))
		return soap->error;
	soap->mustUnderstand = 0;
	if (soap_out_PointerTo_wsse__Security(soap, "wsse:Security", -1, &a->wsse__Security, ""))
		return soap->error;
	if (soap_out_int(soap, "SubscriptionId", -1, &a->SubscriptionId, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	size_t soap_flag_wsa__MessageID = 1;
	size_t soap_flag_wsa__RelatesTo = 1;
	size_t soap_flag_wsa__From = 1;
	size_t soap_flag_wsa__ReplyTo = 1;
	size_t soap_flag_wsa__FaultTo = 1;
	size_t soap_flag_wsa__To = 1;
	size_t soap_flag_wsa__Action = 1;
	size_t soap_flag_d__AppSequence = 1;
	size_t soap_flag_wsse__Security = 1;
	size_t soap_flag_SubscriptionId = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__MessageID && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in__wsa__MessageID(soap, "wsa:MessageID", &a->wsa__MessageID, ""))
				{	soap_flag_wsa__MessageID--;
					continue;
				}
			if (soap_flag_wsa__RelatesTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa__RelatesTo(soap, "wsa:RelatesTo", &a->wsa__RelatesTo, ""))
				{	soap_flag_wsa__RelatesTo--;
					continue;
				}
			if (soap_flag_wsa__From && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa__From(soap, "wsa:From", &a->wsa__From, ""))
				{	soap_flag_wsa__From--;
					continue;
				}
			if (soap_flag_wsa__ReplyTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa__ReplyTo(soap, "wsa:ReplyTo", &a->wsa__ReplyTo, ""))
				{	soap_flag_wsa__ReplyTo--;
					continue;
				}
			if (soap_flag_wsa__FaultTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa__FaultTo(soap, "wsa:FaultTo", &a->wsa__FaultTo, ""))
				{	soap_flag_wsa__FaultTo--;
					continue;
				}
			if (soap_flag_wsa__To && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in__wsa__To(soap, "wsa:To", &a->wsa__To, ""))
				{	soap_flag_wsa__To--;
					continue;
				}
			if (soap_flag_wsa__Action && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in__wsa__Action(soap, "wsa:Action", &a->wsa__Action, ""))
				{	soap_flag_wsa__Action--;
					continue;
				}
			if (soap_flag_d__AppSequence && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_d__AppSequence(soap, "d:AppSequence", &a->d__AppSequence, ""))
				{	soap_flag_d__AppSequence--;
					continue;
				}
			if (soap_flag_wsse__Security && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsse__Security(soap, "wsse:Security", &a->wsse__Security, ""))
				{	soap_flag_wsse__Security--;
					continue;
				}
			if (soap_flag_SubscriptionId && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "SubscriptionId", &a->SubscriptionId, "xsd:int"))
				{	soap_flag_SubscriptionId--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag?tag:"SOAP-ENV:Header", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetSnapshotUri(struct soap *soap, struct __trt__GetSnapshotUri *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetSnapshotUri = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetSnapshotUri(struct soap *soap, const struct __trt__GetSnapshotUri *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetSnapshotUri(soap, &a->trt__GetSnapshotUri);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetSnapshotUri(struct soap *soap, const char *tag, int id, const struct __trt__GetSnapshotUri *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetSnapshotUri(soap, "trt:GetSnapshotUri", -1, &a->trt__GetSnapshotUri, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetSnapshotUri * SOAP_FMAC4 soap_in___trt__GetSnapshotUri(struct soap *soap, const char *tag, struct __trt__GetSnapshotUri *a, const char *type)
{
	size_t soap_flag_trt__GetSnapshotUri = 1;
	short soap_flag;
	a = (struct __trt__GetSnapshotUri *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetSnapshotUri, sizeof(struct __trt__GetSnapshotUri), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetSnapshotUri(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetSnapshotUri && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetSnapshotUri(soap, "trt:GetSnapshotUri", &a->trt__GetSnapshotUri, ""))
				{	soap_flag_trt__GetSnapshotUri--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetSnapshotUri(struct soap *soap, const struct __trt__GetSnapshotUri *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetSnapshotUri(soap, tag?tag:"-trt:GetSnapshotUri", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetSnapshotUri * SOAP_FMAC4 soap_get___trt__GetSnapshotUri(struct soap *soap, struct __trt__GetSnapshotUri *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetSnapshotUri(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__SetSynchronizationPoint(struct soap *soap, struct __trt__SetSynchronizationPoint *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__SetSynchronizationPoint = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__SetSynchronizationPoint(struct soap *soap, const struct __trt__SetSynchronizationPoint *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__SetSynchronizationPoint(soap, &a->trt__SetSynchronizationPoint);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__SetSynchronizationPoint(struct soap *soap, const char *tag, int id, const struct __trt__SetSynchronizationPoint *a, const char *type)
{
	if (soap_out_PointerTo_trt__SetSynchronizationPoint(soap, "trt:SetSynchronizationPoint", -1, &a->trt__SetSynchronizationPoint, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetSynchronizationPoint * SOAP_FMAC4 soap_in___trt__SetSynchronizationPoint(struct soap *soap, const char *tag, struct __trt__SetSynchronizationPoint *a, const char *type)
{
	size_t soap_flag_trt__SetSynchronizationPoint = 1;
	short soap_flag;
	a = (struct __trt__SetSynchronizationPoint *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__SetSynchronizationPoint, sizeof(struct __trt__SetSynchronizationPoint), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__SetSynchronizationPoint(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__SetSynchronizationPoint && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__SetSynchronizationPoint(soap, "trt:SetSynchronizationPoint", &a->trt__SetSynchronizationPoint, ""))
				{	soap_flag_trt__SetSynchronizationPoint--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__SetSynchronizationPoint(struct soap *soap, const struct __trt__SetSynchronizationPoint *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__SetSynchronizationPoint(soap, tag?tag:"-trt:SetSynchronizationPoint", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetSynchronizationPoint * SOAP_FMAC4 soap_get___trt__SetSynchronizationPoint(struct soap *soap, struct __trt__SetSynchronizationPoint *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__SetSynchronizationPoint(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetStreamUri(struct soap *soap, struct __trt__GetStreamUri *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetStreamUri = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetStreamUri(struct soap *soap, const struct __trt__GetStreamUri *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetStreamUri(soap, &a->trt__GetStreamUri);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetStreamUri(struct soap *soap, const char *tag, int id, const struct __trt__GetStreamUri *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetStreamUri(soap, "trt:GetStreamUri", -1, &a->trt__GetStreamUri, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetStreamUri * SOAP_FMAC4 soap_in___trt__GetStreamUri(struct soap *soap, const char *tag, struct __trt__GetStreamUri *a, const char *type)
{
	size_t soap_flag_trt__GetStreamUri = 1;
	short soap_flag;
	a = (struct __trt__GetStreamUri *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetStreamUri, sizeof(struct __trt__GetStreamUri), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetStreamUri(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetStreamUri && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetStreamUri(soap, "trt:GetStreamUri", &a->trt__GetStreamUri, ""))
				{	soap_flag_trt__GetStreamUri--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetStreamUri(struct soap *soap, const struct __trt__GetStreamUri *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetStreamUri(soap, tag?tag:"-trt:GetStreamUri", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetStreamUri * SOAP_FMAC4 soap_get___trt__GetStreamUri(struct soap *soap, struct __trt__GetStreamUri *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetStreamUri(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetGuaranteedNumberOfVideoEncoderInstances(struct soap *soap, struct __trt__GetGuaranteedNumberOfVideoEncoderInstances *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetGuaranteedNumberOfVideoEncoderInstances = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetGuaranteedNumberOfVideoEncoderInstances(struct soap *soap, const struct __trt__GetGuaranteedNumberOfVideoEncoderInstances *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetGuaranteedNumberOfVideoEncoderInstances(soap, &a->trt__GetGuaranteedNumberOfVideoEncoderInstances);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetGuaranteedNumberOfVideoEncoderInstances(struct soap *soap, const char *tag, int id, const struct __trt__GetGuaranteedNumberOfVideoEncoderInstances *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetGuaranteedNumberOfVideoEncoderInstances(soap, "trt:GetGuaranteedNumberOfVideoEncoderInstances", -1, &a->trt__GetGuaranteedNumberOfVideoEncoderInstances, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetGuaranteedNumberOfVideoEncoderInstances * SOAP_FMAC4 soap_in___trt__GetGuaranteedNumberOfVideoEncoderInstances(struct soap *soap, const char *tag, struct __trt__GetGuaranteedNumberOfVideoEncoderInstances *a, const char *type)
{
	size_t soap_flag_trt__GetGuaranteedNumberOfVideoEncoderInstances = 1;
	short soap_flag;
	a = (struct __trt__GetGuaranteedNumberOfVideoEncoderInstances *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetGuaranteedNumberOfVideoEncoderInstances, sizeof(struct __trt__GetGuaranteedNumberOfVideoEncoderInstances), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetGuaranteedNumberOfVideoEncoderInstances(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetGuaranteedNumberOfVideoEncoderInstances && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetGuaranteedNumberOfVideoEncoderInstances(soap, "trt:GetGuaranteedNumberOfVideoEncoderInstances", &a->trt__GetGuaranteedNumberOfVideoEncoderInstances, ""))
				{	soap_flag_trt__GetGuaranteedNumberOfVideoEncoderInstances--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetGuaranteedNumberOfVideoEncoderInstances(struct soap *soap, const struct __trt__GetGuaranteedNumberOfVideoEncoderInstances *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetGuaranteedNumberOfVideoEncoderInstances(soap, tag?tag:"-trt:GetGuaranteedNumberOfVideoEncoderInstances", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetGuaranteedNumberOfVideoEncoderInstances * SOAP_FMAC4 soap_get___trt__GetGuaranteedNumberOfVideoEncoderInstances(struct soap *soap, struct __trt__GetGuaranteedNumberOfVideoEncoderInstances *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetGuaranteedNumberOfVideoEncoderInstances(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetMetadataConfigurationOptions(struct soap *soap, struct __trt__GetMetadataConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetMetadataConfigurationOptions = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetMetadataConfigurationOptions(struct soap *soap, const struct __trt__GetMetadataConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetMetadataConfigurationOptions(soap, &a->trt__GetMetadataConfigurationOptions);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetMetadataConfigurationOptions(struct soap *soap, const char *tag, int id, const struct __trt__GetMetadataConfigurationOptions *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetMetadataConfigurationOptions(soap, "trt:GetMetadataConfigurationOptions", -1, &a->trt__GetMetadataConfigurationOptions, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetMetadataConfigurationOptions * SOAP_FMAC4 soap_in___trt__GetMetadataConfigurationOptions(struct soap *soap, const char *tag, struct __trt__GetMetadataConfigurationOptions *a, const char *type)
{
	size_t soap_flag_trt__GetMetadataConfigurationOptions = 1;
	short soap_flag;
	a = (struct __trt__GetMetadataConfigurationOptions *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetMetadataConfigurationOptions, sizeof(struct __trt__GetMetadataConfigurationOptions), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetMetadataConfigurationOptions(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetMetadataConfigurationOptions && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetMetadataConfigurationOptions(soap, "trt:GetMetadataConfigurationOptions", &a->trt__GetMetadataConfigurationOptions, ""))
				{	soap_flag_trt__GetMetadataConfigurationOptions--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetMetadataConfigurationOptions(struct soap *soap, const struct __trt__GetMetadataConfigurationOptions *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetMetadataConfigurationOptions(soap, tag?tag:"-trt:GetMetadataConfigurationOptions", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetMetadataConfigurationOptions * SOAP_FMAC4 soap_get___trt__GetMetadataConfigurationOptions(struct soap *soap, struct __trt__GetMetadataConfigurationOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetMetadataConfigurationOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetAudioEncoderConfigurationOptions(struct soap *soap, struct __trt__GetAudioEncoderConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetAudioEncoderConfigurationOptions = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetAudioEncoderConfigurationOptions(struct soap *soap, const struct __trt__GetAudioEncoderConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetAudioEncoderConfigurationOptions(soap, &a->trt__GetAudioEncoderConfigurationOptions);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetAudioEncoderConfigurationOptions(struct soap *soap, const char *tag, int id, const struct __trt__GetAudioEncoderConfigurationOptions *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetAudioEncoderConfigurationOptions(soap, "trt:GetAudioEncoderConfigurationOptions", -1, &a->trt__GetAudioEncoderConfigurationOptions, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioEncoderConfigurationOptions * SOAP_FMAC4 soap_in___trt__GetAudioEncoderConfigurationOptions(struct soap *soap, const char *tag, struct __trt__GetAudioEncoderConfigurationOptions *a, const char *type)
{
	size_t soap_flag_trt__GetAudioEncoderConfigurationOptions = 1;
	short soap_flag;
	a = (struct __trt__GetAudioEncoderConfigurationOptions *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetAudioEncoderConfigurationOptions, sizeof(struct __trt__GetAudioEncoderConfigurationOptions), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetAudioEncoderConfigurationOptions(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetAudioEncoderConfigurationOptions && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetAudioEncoderConfigurationOptions(soap, "trt:GetAudioEncoderConfigurationOptions", &a->trt__GetAudioEncoderConfigurationOptions, ""))
				{	soap_flag_trt__GetAudioEncoderConfigurationOptions--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetAudioEncoderConfigurationOptions(struct soap *soap, const struct __trt__GetAudioEncoderConfigurationOptions *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetAudioEncoderConfigurationOptions(soap, tag?tag:"-trt:GetAudioEncoderConfigurationOptions", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioEncoderConfigurationOptions * SOAP_FMAC4 soap_get___trt__GetAudioEncoderConfigurationOptions(struct soap *soap, struct __trt__GetAudioEncoderConfigurationOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetAudioEncoderConfigurationOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetAudioSourceConfigurationOptions(struct soap *soap, struct __trt__GetAudioSourceConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetAudioSourceConfigurationOptions = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetAudioSourceConfigurationOptions(struct soap *soap, const struct __trt__GetAudioSourceConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetAudioSourceConfigurationOptions(soap, &a->trt__GetAudioSourceConfigurationOptions);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetAudioSourceConfigurationOptions(struct soap *soap, const char *tag, int id, const struct __trt__GetAudioSourceConfigurationOptions *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetAudioSourceConfigurationOptions(soap, "trt:GetAudioSourceConfigurationOptions", -1, &a->trt__GetAudioSourceConfigurationOptions, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioSourceConfigurationOptions * SOAP_FMAC4 soap_in___trt__GetAudioSourceConfigurationOptions(struct soap *soap, const char *tag, struct __trt__GetAudioSourceConfigurationOptions *a, const char *type)
{
	size_t soap_flag_trt__GetAudioSourceConfigurationOptions = 1;
	short soap_flag;
	a = (struct __trt__GetAudioSourceConfigurationOptions *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetAudioSourceConfigurationOptions, sizeof(struct __trt__GetAudioSourceConfigurationOptions), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetAudioSourceConfigurationOptions(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetAudioSourceConfigurationOptions && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetAudioSourceConfigurationOptions(soap, "trt:GetAudioSourceConfigurationOptions", &a->trt__GetAudioSourceConfigurationOptions, ""))
				{	soap_flag_trt__GetAudioSourceConfigurationOptions--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetAudioSourceConfigurationOptions(struct soap *soap, const struct __trt__GetAudioSourceConfigurationOptions *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetAudioSourceConfigurationOptions(soap, tag?tag:"-trt:GetAudioSourceConfigurationOptions", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioSourceConfigurationOptions * SOAP_FMAC4 soap_get___trt__GetAudioSourceConfigurationOptions(struct soap *soap, struct __trt__GetAudioSourceConfigurationOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetAudioSourceConfigurationOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetVideoEncoderConfigurationOptions(struct soap *soap, struct __trt__GetVideoEncoderConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetVideoEncoderConfigurationOptions = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetVideoEncoderConfigurationOptions(struct soap *soap, const struct __trt__GetVideoEncoderConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetVideoEncoderConfigurationOptions(soap, &a->trt__GetVideoEncoderConfigurationOptions);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetVideoEncoderConfigurationOptions(struct soap *soap, const char *tag, int id, const struct __trt__GetVideoEncoderConfigurationOptions *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetVideoEncoderConfigurationOptions(soap, "trt:GetVideoEncoderConfigurationOptions", -1, &a->trt__GetVideoEncoderConfigurationOptions, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoEncoderConfigurationOptions * SOAP_FMAC4 soap_in___trt__GetVideoEncoderConfigurationOptions(struct soap *soap, const char *tag, struct __trt__GetVideoEncoderConfigurationOptions *a, const char *type)
{
	size_t soap_flag_trt__GetVideoEncoderConfigurationOptions = 1;
	short soap_flag;
	a = (struct __trt__GetVideoEncoderConfigurationOptions *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetVideoEncoderConfigurationOptions, sizeof(struct __trt__GetVideoEncoderConfigurationOptions), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetVideoEncoderConfigurationOptions(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetVideoEncoderConfigurationOptions && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetVideoEncoderConfigurationOptions(soap, "trt:GetVideoEncoderConfigurationOptions", &a->trt__GetVideoEncoderConfigurationOptions, ""))
				{	soap_flag_trt__GetVideoEncoderConfigurationOptions--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetVideoEncoderConfigurationOptions(struct soap *soap, const struct __trt__GetVideoEncoderConfigurationOptions *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetVideoEncoderConfigurationOptions(soap, tag?tag:"-trt:GetVideoEncoderConfigurationOptions", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoEncoderConfigurationOptions * SOAP_FMAC4 soap_get___trt__GetVideoEncoderConfigurationOptions(struct soap *soap, struct __trt__GetVideoEncoderConfigurationOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetVideoEncoderConfigurationOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetVideoSourceConfigurationOptions(struct soap *soap, struct __trt__GetVideoSourceConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetVideoSourceConfigurationOptions = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetVideoSourceConfigurationOptions(struct soap *soap, const struct __trt__GetVideoSourceConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetVideoSourceConfigurationOptions(soap, &a->trt__GetVideoSourceConfigurationOptions);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetVideoSourceConfigurationOptions(struct soap *soap, const char *tag, int id, const struct __trt__GetVideoSourceConfigurationOptions *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetVideoSourceConfigurationOptions(soap, "trt:GetVideoSourceConfigurationOptions", -1, &a->trt__GetVideoSourceConfigurationOptions, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoSourceConfigurationOptions * SOAP_FMAC4 soap_in___trt__GetVideoSourceConfigurationOptions(struct soap *soap, const char *tag, struct __trt__GetVideoSourceConfigurationOptions *a, const char *type)
{
	size_t soap_flag_trt__GetVideoSourceConfigurationOptions = 1;
	short soap_flag;
	a = (struct __trt__GetVideoSourceConfigurationOptions *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetVideoSourceConfigurationOptions, sizeof(struct __trt__GetVideoSourceConfigurationOptions), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetVideoSourceConfigurationOptions(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetVideoSourceConfigurationOptions && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetVideoSourceConfigurationOptions(soap, "trt:GetVideoSourceConfigurationOptions", &a->trt__GetVideoSourceConfigurationOptions, ""))
				{	soap_flag_trt__GetVideoSourceConfigurationOptions--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetVideoSourceConfigurationOptions(struct soap *soap, const struct __trt__GetVideoSourceConfigurationOptions *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetVideoSourceConfigurationOptions(soap, tag?tag:"-trt:GetVideoSourceConfigurationOptions", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoSourceConfigurationOptions * SOAP_FMAC4 soap_get___trt__GetVideoSourceConfigurationOptions(struct soap *soap, struct __trt__GetVideoSourceConfigurationOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetVideoSourceConfigurationOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__SetMetadataConfiguration(struct soap *soap, struct __trt__SetMetadataConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__SetMetadataConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__SetMetadataConfiguration(struct soap *soap, const struct __trt__SetMetadataConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__SetMetadataConfiguration(soap, &a->trt__SetMetadataConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__SetMetadataConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__SetMetadataConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__SetMetadataConfiguration(soap, "trt:SetMetadataConfiguration", -1, &a->trt__SetMetadataConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetMetadataConfiguration * SOAP_FMAC4 soap_in___trt__SetMetadataConfiguration(struct soap *soap, const char *tag, struct __trt__SetMetadataConfiguration *a, const char *type)
{
	size_t soap_flag_trt__SetMetadataConfiguration = 1;
	short soap_flag;
	a = (struct __trt__SetMetadataConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__SetMetadataConfiguration, sizeof(struct __trt__SetMetadataConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__SetMetadataConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__SetMetadataConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__SetMetadataConfiguration(soap, "trt:SetMetadataConfiguration", &a->trt__SetMetadataConfiguration, ""))
				{	soap_flag_trt__SetMetadataConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__SetMetadataConfiguration(struct soap *soap, const struct __trt__SetMetadataConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__SetMetadataConfiguration(soap, tag?tag:"-trt:SetMetadataConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetMetadataConfiguration * SOAP_FMAC4 soap_get___trt__SetMetadataConfiguration(struct soap *soap, struct __trt__SetMetadataConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__SetMetadataConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__SetAudioEncoderConfiguration(struct soap *soap, struct __trt__SetAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__SetAudioEncoderConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__SetAudioEncoderConfiguration(struct soap *soap, const struct __trt__SetAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__SetAudioEncoderConfiguration(soap, &a->trt__SetAudioEncoderConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__SetAudioEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__SetAudioEncoderConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__SetAudioEncoderConfiguration(soap, "trt:SetAudioEncoderConfiguration", -1, &a->trt__SetAudioEncoderConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetAudioEncoderConfiguration * SOAP_FMAC4 soap_in___trt__SetAudioEncoderConfiguration(struct soap *soap, const char *tag, struct __trt__SetAudioEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_trt__SetAudioEncoderConfiguration = 1;
	short soap_flag;
	a = (struct __trt__SetAudioEncoderConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__SetAudioEncoderConfiguration, sizeof(struct __trt__SetAudioEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__SetAudioEncoderConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__SetAudioEncoderConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__SetAudioEncoderConfiguration(soap, "trt:SetAudioEncoderConfiguration", &a->trt__SetAudioEncoderConfiguration, ""))
				{	soap_flag_trt__SetAudioEncoderConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__SetAudioEncoderConfiguration(struct soap *soap, const struct __trt__SetAudioEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__SetAudioEncoderConfiguration(soap, tag?tag:"-trt:SetAudioEncoderConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetAudioEncoderConfiguration * SOAP_FMAC4 soap_get___trt__SetAudioEncoderConfiguration(struct soap *soap, struct __trt__SetAudioEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__SetAudioEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__SetAudioSourceConfiguration(struct soap *soap, struct __trt__SetAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__SetAudioSourceConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__SetAudioSourceConfiguration(struct soap *soap, const struct __trt__SetAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__SetAudioSourceConfiguration(soap, &a->trt__SetAudioSourceConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__SetAudioSourceConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__SetAudioSourceConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__SetAudioSourceConfiguration(soap, "trt:SetAudioSourceConfiguration", -1, &a->trt__SetAudioSourceConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetAudioSourceConfiguration * SOAP_FMAC4 soap_in___trt__SetAudioSourceConfiguration(struct soap *soap, const char *tag, struct __trt__SetAudioSourceConfiguration *a, const char *type)
{
	size_t soap_flag_trt__SetAudioSourceConfiguration = 1;
	short soap_flag;
	a = (struct __trt__SetAudioSourceConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__SetAudioSourceConfiguration, sizeof(struct __trt__SetAudioSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__SetAudioSourceConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__SetAudioSourceConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__SetAudioSourceConfiguration(soap, "trt:SetAudioSourceConfiguration", &a->trt__SetAudioSourceConfiguration, ""))
				{	soap_flag_trt__SetAudioSourceConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__SetAudioSourceConfiguration(struct soap *soap, const struct __trt__SetAudioSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__SetAudioSourceConfiguration(soap, tag?tag:"-trt:SetAudioSourceConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetAudioSourceConfiguration * SOAP_FMAC4 soap_get___trt__SetAudioSourceConfiguration(struct soap *soap, struct __trt__SetAudioSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__SetAudioSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__SetVideoEncoderConfiguration(struct soap *soap, struct __trt__SetVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__SetVideoEncoderConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__SetVideoEncoderConfiguration(struct soap *soap, const struct __trt__SetVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__SetVideoEncoderConfiguration(soap, &a->trt__SetVideoEncoderConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__SetVideoEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__SetVideoEncoderConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__SetVideoEncoderConfiguration(soap, "trt:SetVideoEncoderConfiguration", -1, &a->trt__SetVideoEncoderConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetVideoEncoderConfiguration * SOAP_FMAC4 soap_in___trt__SetVideoEncoderConfiguration(struct soap *soap, const char *tag, struct __trt__SetVideoEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_trt__SetVideoEncoderConfiguration = 1;
	short soap_flag;
	a = (struct __trt__SetVideoEncoderConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__SetVideoEncoderConfiguration, sizeof(struct __trt__SetVideoEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__SetVideoEncoderConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__SetVideoEncoderConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__SetVideoEncoderConfiguration(soap, "trt:SetVideoEncoderConfiguration", &a->trt__SetVideoEncoderConfiguration, ""))
				{	soap_flag_trt__SetVideoEncoderConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__SetVideoEncoderConfiguration(struct soap *soap, const struct __trt__SetVideoEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__SetVideoEncoderConfiguration(soap, tag?tag:"-trt:SetVideoEncoderConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetVideoEncoderConfiguration * SOAP_FMAC4 soap_get___trt__SetVideoEncoderConfiguration(struct soap *soap, struct __trt__SetVideoEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__SetVideoEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__SetVideoSourceConfiguration(struct soap *soap, struct __trt__SetVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__SetVideoSourceConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__SetVideoSourceConfiguration(struct soap *soap, const struct __trt__SetVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__SetVideoSourceConfiguration(soap, &a->trt__SetVideoSourceConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__SetVideoSourceConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__SetVideoSourceConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__SetVideoSourceConfiguration(soap, "trt:SetVideoSourceConfiguration", -1, &a->trt__SetVideoSourceConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetVideoSourceConfiguration * SOAP_FMAC4 soap_in___trt__SetVideoSourceConfiguration(struct soap *soap, const char *tag, struct __trt__SetVideoSourceConfiguration *a, const char *type)
{
	size_t soap_flag_trt__SetVideoSourceConfiguration = 1;
	short soap_flag;
	a = (struct __trt__SetVideoSourceConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__SetVideoSourceConfiguration, sizeof(struct __trt__SetVideoSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__SetVideoSourceConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__SetVideoSourceConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__SetVideoSourceConfiguration(soap, "trt:SetVideoSourceConfiguration", &a->trt__SetVideoSourceConfiguration, ""))
				{	soap_flag_trt__SetVideoSourceConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__SetVideoSourceConfiguration(struct soap *soap, const struct __trt__SetVideoSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__SetVideoSourceConfiguration(soap, tag?tag:"-trt:SetVideoSourceConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__SetVideoSourceConfiguration * SOAP_FMAC4 soap_get___trt__SetVideoSourceConfiguration(struct soap *soap, struct __trt__SetVideoSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__SetVideoSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetCompatibleMetadataConfigurations(struct soap *soap, struct __trt__GetCompatibleMetadataConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetCompatibleMetadataConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetCompatibleMetadataConfigurations(struct soap *soap, const struct __trt__GetCompatibleMetadataConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetCompatibleMetadataConfigurations(soap, &a->trt__GetCompatibleMetadataConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetCompatibleMetadataConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetCompatibleMetadataConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetCompatibleMetadataConfigurations(soap, "trt:GetCompatibleMetadataConfigurations", -1, &a->trt__GetCompatibleMetadataConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleMetadataConfigurations * SOAP_FMAC4 soap_in___trt__GetCompatibleMetadataConfigurations(struct soap *soap, const char *tag, struct __trt__GetCompatibleMetadataConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetCompatibleMetadataConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetCompatibleMetadataConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetCompatibleMetadataConfigurations, sizeof(struct __trt__GetCompatibleMetadataConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetCompatibleMetadataConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetCompatibleMetadataConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetCompatibleMetadataConfigurations(soap, "trt:GetCompatibleMetadataConfigurations", &a->trt__GetCompatibleMetadataConfigurations, ""))
				{	soap_flag_trt__GetCompatibleMetadataConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetCompatibleMetadataConfigurations(struct soap *soap, const struct __trt__GetCompatibleMetadataConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetCompatibleMetadataConfigurations(soap, tag?tag:"-trt:GetCompatibleMetadataConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleMetadataConfigurations * SOAP_FMAC4 soap_get___trt__GetCompatibleMetadataConfigurations(struct soap *soap, struct __trt__GetCompatibleMetadataConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetCompatibleMetadataConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, struct __trt__GetCompatibleAudioSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetCompatibleAudioSourceConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, const struct __trt__GetCompatibleAudioSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetCompatibleAudioSourceConfigurations(soap, &a->trt__GetCompatibleAudioSourceConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetCompatibleAudioSourceConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetCompatibleAudioSourceConfigurations(soap, "trt:GetCompatibleAudioSourceConfigurations", -1, &a->trt__GetCompatibleAudioSourceConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleAudioSourceConfigurations * SOAP_FMAC4 soap_in___trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, const char *tag, struct __trt__GetCompatibleAudioSourceConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetCompatibleAudioSourceConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetCompatibleAudioSourceConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetCompatibleAudioSourceConfigurations, sizeof(struct __trt__GetCompatibleAudioSourceConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetCompatibleAudioSourceConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetCompatibleAudioSourceConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetCompatibleAudioSourceConfigurations(soap, "trt:GetCompatibleAudioSourceConfigurations", &a->trt__GetCompatibleAudioSourceConfigurations, ""))
				{	soap_flag_trt__GetCompatibleAudioSourceConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, const struct __trt__GetCompatibleAudioSourceConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetCompatibleAudioSourceConfigurations(soap, tag?tag:"-trt:GetCompatibleAudioSourceConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleAudioSourceConfigurations * SOAP_FMAC4 soap_get___trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, struct __trt__GetCompatibleAudioSourceConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetCompatibleAudioSourceConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, struct __trt__GetCompatibleAudioEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetCompatibleAudioEncoderConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, const struct __trt__GetCompatibleAudioEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetCompatibleAudioEncoderConfigurations(soap, &a->trt__GetCompatibleAudioEncoderConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetCompatibleAudioEncoderConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetCompatibleAudioEncoderConfigurations(soap, "trt:GetCompatibleAudioEncoderConfigurations", -1, &a->trt__GetCompatibleAudioEncoderConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleAudioEncoderConfigurations * SOAP_FMAC4 soap_in___trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, const char *tag, struct __trt__GetCompatibleAudioEncoderConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetCompatibleAudioEncoderConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetCompatibleAudioEncoderConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetCompatibleAudioEncoderConfigurations, sizeof(struct __trt__GetCompatibleAudioEncoderConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetCompatibleAudioEncoderConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetCompatibleAudioEncoderConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetCompatibleAudioEncoderConfigurations(soap, "trt:GetCompatibleAudioEncoderConfigurations", &a->trt__GetCompatibleAudioEncoderConfigurations, ""))
				{	soap_flag_trt__GetCompatibleAudioEncoderConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, const struct __trt__GetCompatibleAudioEncoderConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetCompatibleAudioEncoderConfigurations(soap, tag?tag:"-trt:GetCompatibleAudioEncoderConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleAudioEncoderConfigurations * SOAP_FMAC4 soap_get___trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, struct __trt__GetCompatibleAudioEncoderConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetCompatibleAudioEncoderConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, struct __trt__GetCompatibleVideoSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetCompatibleVideoSourceConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, const struct __trt__GetCompatibleVideoSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetCompatibleVideoSourceConfigurations(soap, &a->trt__GetCompatibleVideoSourceConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetCompatibleVideoSourceConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetCompatibleVideoSourceConfigurations(soap, "trt:GetCompatibleVideoSourceConfigurations", -1, &a->trt__GetCompatibleVideoSourceConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleVideoSourceConfigurations * SOAP_FMAC4 soap_in___trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, const char *tag, struct __trt__GetCompatibleVideoSourceConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetCompatibleVideoSourceConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetCompatibleVideoSourceConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetCompatibleVideoSourceConfigurations, sizeof(struct __trt__GetCompatibleVideoSourceConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetCompatibleVideoSourceConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetCompatibleVideoSourceConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetCompatibleVideoSourceConfigurations(soap, "trt:GetCompatibleVideoSourceConfigurations", &a->trt__GetCompatibleVideoSourceConfigurations, ""))
				{	soap_flag_trt__GetCompatibleVideoSourceConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, const struct __trt__GetCompatibleVideoSourceConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetCompatibleVideoSourceConfigurations(soap, tag?tag:"-trt:GetCompatibleVideoSourceConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleVideoSourceConfigurations * SOAP_FMAC4 soap_get___trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, struct __trt__GetCompatibleVideoSourceConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetCompatibleVideoSourceConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, struct __trt__GetCompatibleVideoEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetCompatibleVideoEncoderConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, const struct __trt__GetCompatibleVideoEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetCompatibleVideoEncoderConfigurations(soap, &a->trt__GetCompatibleVideoEncoderConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetCompatibleVideoEncoderConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetCompatibleVideoEncoderConfigurations(soap, "trt:GetCompatibleVideoEncoderConfigurations", -1, &a->trt__GetCompatibleVideoEncoderConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleVideoEncoderConfigurations * SOAP_FMAC4 soap_in___trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, const char *tag, struct __trt__GetCompatibleVideoEncoderConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetCompatibleVideoEncoderConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetCompatibleVideoEncoderConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetCompatibleVideoEncoderConfigurations, sizeof(struct __trt__GetCompatibleVideoEncoderConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetCompatibleVideoEncoderConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetCompatibleVideoEncoderConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetCompatibleVideoEncoderConfigurations(soap, "trt:GetCompatibleVideoEncoderConfigurations", &a->trt__GetCompatibleVideoEncoderConfigurations, ""))
				{	soap_flag_trt__GetCompatibleVideoEncoderConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, const struct __trt__GetCompatibleVideoEncoderConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetCompatibleVideoEncoderConfigurations(soap, tag?tag:"-trt:GetCompatibleVideoEncoderConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetCompatibleVideoEncoderConfigurations * SOAP_FMAC4 soap_get___trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, struct __trt__GetCompatibleVideoEncoderConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetCompatibleVideoEncoderConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetMetadataConfiguration(struct soap *soap, struct __trt__GetMetadataConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetMetadataConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetMetadataConfiguration(struct soap *soap, const struct __trt__GetMetadataConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetMetadataConfiguration(soap, &a->trt__GetMetadataConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetMetadataConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__GetMetadataConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetMetadataConfiguration(soap, "trt:GetMetadataConfiguration", -1, &a->trt__GetMetadataConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetMetadataConfiguration * SOAP_FMAC4 soap_in___trt__GetMetadataConfiguration(struct soap *soap, const char *tag, struct __trt__GetMetadataConfiguration *a, const char *type)
{
	size_t soap_flag_trt__GetMetadataConfiguration = 1;
	short soap_flag;
	a = (struct __trt__GetMetadataConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetMetadataConfiguration, sizeof(struct __trt__GetMetadataConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetMetadataConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetMetadataConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetMetadataConfiguration(soap, "trt:GetMetadataConfiguration", &a->trt__GetMetadataConfiguration, ""))
				{	soap_flag_trt__GetMetadataConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetMetadataConfiguration(struct soap *soap, const struct __trt__GetMetadataConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetMetadataConfiguration(soap, tag?tag:"-trt:GetMetadataConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetMetadataConfiguration * SOAP_FMAC4 soap_get___trt__GetMetadataConfiguration(struct soap *soap, struct __trt__GetMetadataConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetMetadataConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetAudioEncoderConfiguration(struct soap *soap, struct __trt__GetAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetAudioEncoderConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetAudioEncoderConfiguration(struct soap *soap, const struct __trt__GetAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetAudioEncoderConfiguration(soap, &a->trt__GetAudioEncoderConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetAudioEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__GetAudioEncoderConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetAudioEncoderConfiguration(soap, "trt:GetAudioEncoderConfiguration", -1, &a->trt__GetAudioEncoderConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioEncoderConfiguration * SOAP_FMAC4 soap_in___trt__GetAudioEncoderConfiguration(struct soap *soap, const char *tag, struct __trt__GetAudioEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_trt__GetAudioEncoderConfiguration = 1;
	short soap_flag;
	a = (struct __trt__GetAudioEncoderConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetAudioEncoderConfiguration, sizeof(struct __trt__GetAudioEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetAudioEncoderConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetAudioEncoderConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetAudioEncoderConfiguration(soap, "trt:GetAudioEncoderConfiguration", &a->trt__GetAudioEncoderConfiguration, ""))
				{	soap_flag_trt__GetAudioEncoderConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetAudioEncoderConfiguration(struct soap *soap, const struct __trt__GetAudioEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetAudioEncoderConfiguration(soap, tag?tag:"-trt:GetAudioEncoderConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioEncoderConfiguration * SOAP_FMAC4 soap_get___trt__GetAudioEncoderConfiguration(struct soap *soap, struct __trt__GetAudioEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetAudioEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetAudioSourceConfiguration(struct soap *soap, struct __trt__GetAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetAudioSourceConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetAudioSourceConfiguration(struct soap *soap, const struct __trt__GetAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetAudioSourceConfiguration(soap, &a->trt__GetAudioSourceConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetAudioSourceConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__GetAudioSourceConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetAudioSourceConfiguration(soap, "trt:GetAudioSourceConfiguration", -1, &a->trt__GetAudioSourceConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioSourceConfiguration * SOAP_FMAC4 soap_in___trt__GetAudioSourceConfiguration(struct soap *soap, const char *tag, struct __trt__GetAudioSourceConfiguration *a, const char *type)
{
	size_t soap_flag_trt__GetAudioSourceConfiguration = 1;
	short soap_flag;
	a = (struct __trt__GetAudioSourceConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetAudioSourceConfiguration, sizeof(struct __trt__GetAudioSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetAudioSourceConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetAudioSourceConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetAudioSourceConfiguration(soap, "trt:GetAudioSourceConfiguration", &a->trt__GetAudioSourceConfiguration, ""))
				{	soap_flag_trt__GetAudioSourceConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetAudioSourceConfiguration(struct soap *soap, const struct __trt__GetAudioSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetAudioSourceConfiguration(soap, tag?tag:"-trt:GetAudioSourceConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioSourceConfiguration * SOAP_FMAC4 soap_get___trt__GetAudioSourceConfiguration(struct soap *soap, struct __trt__GetAudioSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetAudioSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetVideoEncoderConfiguration(struct soap *soap, struct __trt__GetVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetVideoEncoderConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetVideoEncoderConfiguration(struct soap *soap, const struct __trt__GetVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetVideoEncoderConfiguration(soap, &a->trt__GetVideoEncoderConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetVideoEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__GetVideoEncoderConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetVideoEncoderConfiguration(soap, "trt:GetVideoEncoderConfiguration", -1, &a->trt__GetVideoEncoderConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoEncoderConfiguration * SOAP_FMAC4 soap_in___trt__GetVideoEncoderConfiguration(struct soap *soap, const char *tag, struct __trt__GetVideoEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_trt__GetVideoEncoderConfiguration = 1;
	short soap_flag;
	a = (struct __trt__GetVideoEncoderConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetVideoEncoderConfiguration, sizeof(struct __trt__GetVideoEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetVideoEncoderConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetVideoEncoderConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetVideoEncoderConfiguration(soap, "trt:GetVideoEncoderConfiguration", &a->trt__GetVideoEncoderConfiguration, ""))
				{	soap_flag_trt__GetVideoEncoderConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetVideoEncoderConfiguration(struct soap *soap, const struct __trt__GetVideoEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetVideoEncoderConfiguration(soap, tag?tag:"-trt:GetVideoEncoderConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoEncoderConfiguration * SOAP_FMAC4 soap_get___trt__GetVideoEncoderConfiguration(struct soap *soap, struct __trt__GetVideoEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetVideoEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetVideoSourceConfiguration(struct soap *soap, struct __trt__GetVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetVideoSourceConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetVideoSourceConfiguration(struct soap *soap, const struct __trt__GetVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetVideoSourceConfiguration(soap, &a->trt__GetVideoSourceConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetVideoSourceConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__GetVideoSourceConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetVideoSourceConfiguration(soap, "trt:GetVideoSourceConfiguration", -1, &a->trt__GetVideoSourceConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoSourceConfiguration * SOAP_FMAC4 soap_in___trt__GetVideoSourceConfiguration(struct soap *soap, const char *tag, struct __trt__GetVideoSourceConfiguration *a, const char *type)
{
	size_t soap_flag_trt__GetVideoSourceConfiguration = 1;
	short soap_flag;
	a = (struct __trt__GetVideoSourceConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetVideoSourceConfiguration, sizeof(struct __trt__GetVideoSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetVideoSourceConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetVideoSourceConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetVideoSourceConfiguration(soap, "trt:GetVideoSourceConfiguration", &a->trt__GetVideoSourceConfiguration, ""))
				{	soap_flag_trt__GetVideoSourceConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetVideoSourceConfiguration(struct soap *soap, const struct __trt__GetVideoSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetVideoSourceConfiguration(soap, tag?tag:"-trt:GetVideoSourceConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoSourceConfiguration * SOAP_FMAC4 soap_get___trt__GetVideoSourceConfiguration(struct soap *soap, struct __trt__GetVideoSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetVideoSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetMetadataConfigurations(struct soap *soap, struct __trt__GetMetadataConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetMetadataConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetMetadataConfigurations(struct soap *soap, const struct __trt__GetMetadataConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetMetadataConfigurations(soap, &a->trt__GetMetadataConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetMetadataConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetMetadataConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetMetadataConfigurations(soap, "trt:GetMetadataConfigurations", -1, &a->trt__GetMetadataConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetMetadataConfigurations * SOAP_FMAC4 soap_in___trt__GetMetadataConfigurations(struct soap *soap, const char *tag, struct __trt__GetMetadataConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetMetadataConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetMetadataConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetMetadataConfigurations, sizeof(struct __trt__GetMetadataConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetMetadataConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetMetadataConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetMetadataConfigurations(soap, "trt:GetMetadataConfigurations", &a->trt__GetMetadataConfigurations, ""))
				{	soap_flag_trt__GetMetadataConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetMetadataConfigurations(struct soap *soap, const struct __trt__GetMetadataConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetMetadataConfigurations(soap, tag?tag:"-trt:GetMetadataConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetMetadataConfigurations * SOAP_FMAC4 soap_get___trt__GetMetadataConfigurations(struct soap *soap, struct __trt__GetMetadataConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetMetadataConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetAudioEncoderConfigurations(struct soap *soap, struct __trt__GetAudioEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetAudioEncoderConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetAudioEncoderConfigurations(struct soap *soap, const struct __trt__GetAudioEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetAudioEncoderConfigurations(soap, &a->trt__GetAudioEncoderConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetAudioEncoderConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetAudioEncoderConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetAudioEncoderConfigurations(soap, "trt:GetAudioEncoderConfigurations", -1, &a->trt__GetAudioEncoderConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioEncoderConfigurations * SOAP_FMAC4 soap_in___trt__GetAudioEncoderConfigurations(struct soap *soap, const char *tag, struct __trt__GetAudioEncoderConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetAudioEncoderConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetAudioEncoderConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetAudioEncoderConfigurations, sizeof(struct __trt__GetAudioEncoderConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetAudioEncoderConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetAudioEncoderConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetAudioEncoderConfigurations(soap, "trt:GetAudioEncoderConfigurations", &a->trt__GetAudioEncoderConfigurations, ""))
				{	soap_flag_trt__GetAudioEncoderConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetAudioEncoderConfigurations(struct soap *soap, const struct __trt__GetAudioEncoderConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetAudioEncoderConfigurations(soap, tag?tag:"-trt:GetAudioEncoderConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioEncoderConfigurations * SOAP_FMAC4 soap_get___trt__GetAudioEncoderConfigurations(struct soap *soap, struct __trt__GetAudioEncoderConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetAudioEncoderConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetAudioSourceConfigurations(struct soap *soap, struct __trt__GetAudioSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetAudioSourceConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetAudioSourceConfigurations(struct soap *soap, const struct __trt__GetAudioSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetAudioSourceConfigurations(soap, &a->trt__GetAudioSourceConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetAudioSourceConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetAudioSourceConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetAudioSourceConfigurations(soap, "trt:GetAudioSourceConfigurations", -1, &a->trt__GetAudioSourceConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioSourceConfigurations * SOAP_FMAC4 soap_in___trt__GetAudioSourceConfigurations(struct soap *soap, const char *tag, struct __trt__GetAudioSourceConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetAudioSourceConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetAudioSourceConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetAudioSourceConfigurations, sizeof(struct __trt__GetAudioSourceConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetAudioSourceConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetAudioSourceConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetAudioSourceConfigurations(soap, "trt:GetAudioSourceConfigurations", &a->trt__GetAudioSourceConfigurations, ""))
				{	soap_flag_trt__GetAudioSourceConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetAudioSourceConfigurations(struct soap *soap, const struct __trt__GetAudioSourceConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetAudioSourceConfigurations(soap, tag?tag:"-trt:GetAudioSourceConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioSourceConfigurations * SOAP_FMAC4 soap_get___trt__GetAudioSourceConfigurations(struct soap *soap, struct __trt__GetAudioSourceConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetAudioSourceConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetVideoEncoderConfigurations(struct soap *soap, struct __trt__GetVideoEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetVideoEncoderConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetVideoEncoderConfigurations(struct soap *soap, const struct __trt__GetVideoEncoderConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetVideoEncoderConfigurations(soap, &a->trt__GetVideoEncoderConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetVideoEncoderConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetVideoEncoderConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetVideoEncoderConfigurations(soap, "trt:GetVideoEncoderConfigurations", -1, &a->trt__GetVideoEncoderConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoEncoderConfigurations * SOAP_FMAC4 soap_in___trt__GetVideoEncoderConfigurations(struct soap *soap, const char *tag, struct __trt__GetVideoEncoderConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetVideoEncoderConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetVideoEncoderConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetVideoEncoderConfigurations, sizeof(struct __trt__GetVideoEncoderConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetVideoEncoderConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetVideoEncoderConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetVideoEncoderConfigurations(soap, "trt:GetVideoEncoderConfigurations", &a->trt__GetVideoEncoderConfigurations, ""))
				{	soap_flag_trt__GetVideoEncoderConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetVideoEncoderConfigurations(struct soap *soap, const struct __trt__GetVideoEncoderConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetVideoEncoderConfigurations(soap, tag?tag:"-trt:GetVideoEncoderConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoEncoderConfigurations * SOAP_FMAC4 soap_get___trt__GetVideoEncoderConfigurations(struct soap *soap, struct __trt__GetVideoEncoderConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetVideoEncoderConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetVideoSourceConfigurations(struct soap *soap, struct __trt__GetVideoSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetVideoSourceConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetVideoSourceConfigurations(struct soap *soap, const struct __trt__GetVideoSourceConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetVideoSourceConfigurations(soap, &a->trt__GetVideoSourceConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetVideoSourceConfigurations(struct soap *soap, const char *tag, int id, const struct __trt__GetVideoSourceConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetVideoSourceConfigurations(soap, "trt:GetVideoSourceConfigurations", -1, &a->trt__GetVideoSourceConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoSourceConfigurations * SOAP_FMAC4 soap_in___trt__GetVideoSourceConfigurations(struct soap *soap, const char *tag, struct __trt__GetVideoSourceConfigurations *a, const char *type)
{
	size_t soap_flag_trt__GetVideoSourceConfigurations = 1;
	short soap_flag;
	a = (struct __trt__GetVideoSourceConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetVideoSourceConfigurations, sizeof(struct __trt__GetVideoSourceConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetVideoSourceConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetVideoSourceConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetVideoSourceConfigurations(soap, "trt:GetVideoSourceConfigurations", &a->trt__GetVideoSourceConfigurations, ""))
				{	soap_flag_trt__GetVideoSourceConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetVideoSourceConfigurations(struct soap *soap, const struct __trt__GetVideoSourceConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetVideoSourceConfigurations(soap, tag?tag:"-trt:GetVideoSourceConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoSourceConfigurations * SOAP_FMAC4 soap_get___trt__GetVideoSourceConfigurations(struct soap *soap, struct __trt__GetVideoSourceConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetVideoSourceConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__DeleteProfile(struct soap *soap, struct __trt__DeleteProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__DeleteProfile = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__DeleteProfile(struct soap *soap, const struct __trt__DeleteProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__DeleteProfile(soap, &a->trt__DeleteProfile);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__DeleteProfile(struct soap *soap, const char *tag, int id, const struct __trt__DeleteProfile *a, const char *type)
{
	if (soap_out_PointerTo_trt__DeleteProfile(soap, "trt:DeleteProfile", -1, &a->trt__DeleteProfile, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__DeleteProfile * SOAP_FMAC4 soap_in___trt__DeleteProfile(struct soap *soap, const char *tag, struct __trt__DeleteProfile *a, const char *type)
{
	size_t soap_flag_trt__DeleteProfile = 1;
	short soap_flag;
	a = (struct __trt__DeleteProfile *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__DeleteProfile, sizeof(struct __trt__DeleteProfile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__DeleteProfile(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__DeleteProfile && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__DeleteProfile(soap, "trt:DeleteProfile", &a->trt__DeleteProfile, ""))
				{	soap_flag_trt__DeleteProfile--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__DeleteProfile(struct soap *soap, const struct __trt__DeleteProfile *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__DeleteProfile(soap, tag?tag:"-trt:DeleteProfile", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__DeleteProfile * SOAP_FMAC4 soap_get___trt__DeleteProfile(struct soap *soap, struct __trt__DeleteProfile *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__DeleteProfile(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__RemoveMetadataConfiguration(struct soap *soap, struct __trt__RemoveMetadataConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__RemoveMetadataConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__RemoveMetadataConfiguration(struct soap *soap, const struct __trt__RemoveMetadataConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__RemoveMetadataConfiguration(soap, &a->trt__RemoveMetadataConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__RemoveMetadataConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__RemoveMetadataConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__RemoveMetadataConfiguration(soap, "trt:RemoveMetadataConfiguration", -1, &a->trt__RemoveMetadataConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveMetadataConfiguration * SOAP_FMAC4 soap_in___trt__RemoveMetadataConfiguration(struct soap *soap, const char *tag, struct __trt__RemoveMetadataConfiguration *a, const char *type)
{
	size_t soap_flag_trt__RemoveMetadataConfiguration = 1;
	short soap_flag;
	a = (struct __trt__RemoveMetadataConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__RemoveMetadataConfiguration, sizeof(struct __trt__RemoveMetadataConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__RemoveMetadataConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__RemoveMetadataConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__RemoveMetadataConfiguration(soap, "trt:RemoveMetadataConfiguration", &a->trt__RemoveMetadataConfiguration, ""))
				{	soap_flag_trt__RemoveMetadataConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__RemoveMetadataConfiguration(struct soap *soap, const struct __trt__RemoveMetadataConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__RemoveMetadataConfiguration(soap, tag?tag:"-trt:RemoveMetadataConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveMetadataConfiguration * SOAP_FMAC4 soap_get___trt__RemoveMetadataConfiguration(struct soap *soap, struct __trt__RemoveMetadataConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__RemoveMetadataConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__RemovePTZConfiguration(struct soap *soap, struct __trt__RemovePTZConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__RemovePTZConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__RemovePTZConfiguration(struct soap *soap, const struct __trt__RemovePTZConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__RemovePTZConfiguration(soap, &a->trt__RemovePTZConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__RemovePTZConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__RemovePTZConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__RemovePTZConfiguration(soap, "trt:RemovePTZConfiguration", -1, &a->trt__RemovePTZConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemovePTZConfiguration * SOAP_FMAC4 soap_in___trt__RemovePTZConfiguration(struct soap *soap, const char *tag, struct __trt__RemovePTZConfiguration *a, const char *type)
{
	size_t soap_flag_trt__RemovePTZConfiguration = 1;
	short soap_flag;
	a = (struct __trt__RemovePTZConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__RemovePTZConfiguration, sizeof(struct __trt__RemovePTZConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__RemovePTZConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__RemovePTZConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__RemovePTZConfiguration(soap, "trt:RemovePTZConfiguration", &a->trt__RemovePTZConfiguration, ""))
				{	soap_flag_trt__RemovePTZConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__RemovePTZConfiguration(struct soap *soap, const struct __trt__RemovePTZConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__RemovePTZConfiguration(soap, tag?tag:"-trt:RemovePTZConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemovePTZConfiguration * SOAP_FMAC4 soap_get___trt__RemovePTZConfiguration(struct soap *soap, struct __trt__RemovePTZConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__RemovePTZConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__RemoveAudioSourceConfiguration(struct soap *soap, struct __trt__RemoveAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__RemoveAudioSourceConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__RemoveAudioSourceConfiguration(struct soap *soap, const struct __trt__RemoveAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__RemoveAudioSourceConfiguration(soap, &a->trt__RemoveAudioSourceConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__RemoveAudioSourceConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__RemoveAudioSourceConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__RemoveAudioSourceConfiguration(soap, "trt:RemoveAudioSourceConfiguration", -1, &a->trt__RemoveAudioSourceConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveAudioSourceConfiguration * SOAP_FMAC4 soap_in___trt__RemoveAudioSourceConfiguration(struct soap *soap, const char *tag, struct __trt__RemoveAudioSourceConfiguration *a, const char *type)
{
	size_t soap_flag_trt__RemoveAudioSourceConfiguration = 1;
	short soap_flag;
	a = (struct __trt__RemoveAudioSourceConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__RemoveAudioSourceConfiguration, sizeof(struct __trt__RemoveAudioSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__RemoveAudioSourceConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__RemoveAudioSourceConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__RemoveAudioSourceConfiguration(soap, "trt:RemoveAudioSourceConfiguration", &a->trt__RemoveAudioSourceConfiguration, ""))
				{	soap_flag_trt__RemoveAudioSourceConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__RemoveAudioSourceConfiguration(struct soap *soap, const struct __trt__RemoveAudioSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__RemoveAudioSourceConfiguration(soap, tag?tag:"-trt:RemoveAudioSourceConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveAudioSourceConfiguration * SOAP_FMAC4 soap_get___trt__RemoveAudioSourceConfiguration(struct soap *soap, struct __trt__RemoveAudioSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__RemoveAudioSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__RemoveAudioEncoderConfiguration(struct soap *soap, struct __trt__RemoveAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__RemoveAudioEncoderConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__RemoveAudioEncoderConfiguration(struct soap *soap, const struct __trt__RemoveAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__RemoveAudioEncoderConfiguration(soap, &a->trt__RemoveAudioEncoderConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__RemoveAudioEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__RemoveAudioEncoderConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__RemoveAudioEncoderConfiguration(soap, "trt:RemoveAudioEncoderConfiguration", -1, &a->trt__RemoveAudioEncoderConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveAudioEncoderConfiguration * SOAP_FMAC4 soap_in___trt__RemoveAudioEncoderConfiguration(struct soap *soap, const char *tag, struct __trt__RemoveAudioEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_trt__RemoveAudioEncoderConfiguration = 1;
	short soap_flag;
	a = (struct __trt__RemoveAudioEncoderConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__RemoveAudioEncoderConfiguration, sizeof(struct __trt__RemoveAudioEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__RemoveAudioEncoderConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__RemoveAudioEncoderConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__RemoveAudioEncoderConfiguration(soap, "trt:RemoveAudioEncoderConfiguration", &a->trt__RemoveAudioEncoderConfiguration, ""))
				{	soap_flag_trt__RemoveAudioEncoderConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__RemoveAudioEncoderConfiguration(struct soap *soap, const struct __trt__RemoveAudioEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__RemoveAudioEncoderConfiguration(soap, tag?tag:"-trt:RemoveAudioEncoderConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveAudioEncoderConfiguration * SOAP_FMAC4 soap_get___trt__RemoveAudioEncoderConfiguration(struct soap *soap, struct __trt__RemoveAudioEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__RemoveAudioEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__RemoveVideoSourceConfiguration(struct soap *soap, struct __trt__RemoveVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__RemoveVideoSourceConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__RemoveVideoSourceConfiguration(struct soap *soap, const struct __trt__RemoveVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__RemoveVideoSourceConfiguration(soap, &a->trt__RemoveVideoSourceConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__RemoveVideoSourceConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__RemoveVideoSourceConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__RemoveVideoSourceConfiguration(soap, "trt:RemoveVideoSourceConfiguration", -1, &a->trt__RemoveVideoSourceConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveVideoSourceConfiguration * SOAP_FMAC4 soap_in___trt__RemoveVideoSourceConfiguration(struct soap *soap, const char *tag, struct __trt__RemoveVideoSourceConfiguration *a, const char *type)
{
	size_t soap_flag_trt__RemoveVideoSourceConfiguration = 1;
	short soap_flag;
	a = (struct __trt__RemoveVideoSourceConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__RemoveVideoSourceConfiguration, sizeof(struct __trt__RemoveVideoSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__RemoveVideoSourceConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__RemoveVideoSourceConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__RemoveVideoSourceConfiguration(soap, "trt:RemoveVideoSourceConfiguration", &a->trt__RemoveVideoSourceConfiguration, ""))
				{	soap_flag_trt__RemoveVideoSourceConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__RemoveVideoSourceConfiguration(struct soap *soap, const struct __trt__RemoveVideoSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__RemoveVideoSourceConfiguration(soap, tag?tag:"-trt:RemoveVideoSourceConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveVideoSourceConfiguration * SOAP_FMAC4 soap_get___trt__RemoveVideoSourceConfiguration(struct soap *soap, struct __trt__RemoveVideoSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__RemoveVideoSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__RemoveVideoEncoderConfiguration(struct soap *soap, struct __trt__RemoveVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__RemoveVideoEncoderConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__RemoveVideoEncoderConfiguration(struct soap *soap, const struct __trt__RemoveVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__RemoveVideoEncoderConfiguration(soap, &a->trt__RemoveVideoEncoderConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__RemoveVideoEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__RemoveVideoEncoderConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__RemoveVideoEncoderConfiguration(soap, "trt:RemoveVideoEncoderConfiguration", -1, &a->trt__RemoveVideoEncoderConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveVideoEncoderConfiguration * SOAP_FMAC4 soap_in___trt__RemoveVideoEncoderConfiguration(struct soap *soap, const char *tag, struct __trt__RemoveVideoEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_trt__RemoveVideoEncoderConfiguration = 1;
	short soap_flag;
	a = (struct __trt__RemoveVideoEncoderConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__RemoveVideoEncoderConfiguration, sizeof(struct __trt__RemoveVideoEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__RemoveVideoEncoderConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__RemoveVideoEncoderConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__RemoveVideoEncoderConfiguration(soap, "trt:RemoveVideoEncoderConfiguration", &a->trt__RemoveVideoEncoderConfiguration, ""))
				{	soap_flag_trt__RemoveVideoEncoderConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__RemoveVideoEncoderConfiguration(struct soap *soap, const struct __trt__RemoveVideoEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__RemoveVideoEncoderConfiguration(soap, tag?tag:"-trt:RemoveVideoEncoderConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__RemoveVideoEncoderConfiguration * SOAP_FMAC4 soap_get___trt__RemoveVideoEncoderConfiguration(struct soap *soap, struct __trt__RemoveVideoEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__RemoveVideoEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__AddMetadataConfiguration(struct soap *soap, struct __trt__AddMetadataConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__AddMetadataConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__AddMetadataConfiguration(struct soap *soap, const struct __trt__AddMetadataConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__AddMetadataConfiguration(soap, &a->trt__AddMetadataConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__AddMetadataConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__AddMetadataConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__AddMetadataConfiguration(soap, "trt:AddMetadataConfiguration", -1, &a->trt__AddMetadataConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddMetadataConfiguration * SOAP_FMAC4 soap_in___trt__AddMetadataConfiguration(struct soap *soap, const char *tag, struct __trt__AddMetadataConfiguration *a, const char *type)
{
	size_t soap_flag_trt__AddMetadataConfiguration = 1;
	short soap_flag;
	a = (struct __trt__AddMetadataConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__AddMetadataConfiguration, sizeof(struct __trt__AddMetadataConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__AddMetadataConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__AddMetadataConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__AddMetadataConfiguration(soap, "trt:AddMetadataConfiguration", &a->trt__AddMetadataConfiguration, ""))
				{	soap_flag_trt__AddMetadataConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__AddMetadataConfiguration(struct soap *soap, const struct __trt__AddMetadataConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__AddMetadataConfiguration(soap, tag?tag:"-trt:AddMetadataConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddMetadataConfiguration * SOAP_FMAC4 soap_get___trt__AddMetadataConfiguration(struct soap *soap, struct __trt__AddMetadataConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__AddMetadataConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__AddPTZConfiguration(struct soap *soap, struct __trt__AddPTZConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__AddPTZConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__AddPTZConfiguration(struct soap *soap, const struct __trt__AddPTZConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__AddPTZConfiguration(soap, &a->trt__AddPTZConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__AddPTZConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__AddPTZConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__AddPTZConfiguration(soap, "trt:AddPTZConfiguration", -1, &a->trt__AddPTZConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddPTZConfiguration * SOAP_FMAC4 soap_in___trt__AddPTZConfiguration(struct soap *soap, const char *tag, struct __trt__AddPTZConfiguration *a, const char *type)
{
	size_t soap_flag_trt__AddPTZConfiguration = 1;
	short soap_flag;
	a = (struct __trt__AddPTZConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__AddPTZConfiguration, sizeof(struct __trt__AddPTZConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__AddPTZConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__AddPTZConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__AddPTZConfiguration(soap, "trt:AddPTZConfiguration", &a->trt__AddPTZConfiguration, ""))
				{	soap_flag_trt__AddPTZConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__AddPTZConfiguration(struct soap *soap, const struct __trt__AddPTZConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__AddPTZConfiguration(soap, tag?tag:"-trt:AddPTZConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddPTZConfiguration * SOAP_FMAC4 soap_get___trt__AddPTZConfiguration(struct soap *soap, struct __trt__AddPTZConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__AddPTZConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__AddAudioSourceConfiguration(struct soap *soap, struct __trt__AddAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__AddAudioSourceConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__AddAudioSourceConfiguration(struct soap *soap, const struct __trt__AddAudioSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__AddAudioSourceConfiguration(soap, &a->trt__AddAudioSourceConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__AddAudioSourceConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__AddAudioSourceConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__AddAudioSourceConfiguration(soap, "trt:AddAudioSourceConfiguration", -1, &a->trt__AddAudioSourceConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddAudioSourceConfiguration * SOAP_FMAC4 soap_in___trt__AddAudioSourceConfiguration(struct soap *soap, const char *tag, struct __trt__AddAudioSourceConfiguration *a, const char *type)
{
	size_t soap_flag_trt__AddAudioSourceConfiguration = 1;
	short soap_flag;
	a = (struct __trt__AddAudioSourceConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__AddAudioSourceConfiguration, sizeof(struct __trt__AddAudioSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__AddAudioSourceConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__AddAudioSourceConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__AddAudioSourceConfiguration(soap, "trt:AddAudioSourceConfiguration", &a->trt__AddAudioSourceConfiguration, ""))
				{	soap_flag_trt__AddAudioSourceConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__AddAudioSourceConfiguration(struct soap *soap, const struct __trt__AddAudioSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__AddAudioSourceConfiguration(soap, tag?tag:"-trt:AddAudioSourceConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddAudioSourceConfiguration * SOAP_FMAC4 soap_get___trt__AddAudioSourceConfiguration(struct soap *soap, struct __trt__AddAudioSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__AddAudioSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__AddAudioEncoderConfiguration(struct soap *soap, struct __trt__AddAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__AddAudioEncoderConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__AddAudioEncoderConfiguration(struct soap *soap, const struct __trt__AddAudioEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__AddAudioEncoderConfiguration(soap, &a->trt__AddAudioEncoderConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__AddAudioEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__AddAudioEncoderConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__AddAudioEncoderConfiguration(soap, "trt:AddAudioEncoderConfiguration", -1, &a->trt__AddAudioEncoderConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddAudioEncoderConfiguration * SOAP_FMAC4 soap_in___trt__AddAudioEncoderConfiguration(struct soap *soap, const char *tag, struct __trt__AddAudioEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_trt__AddAudioEncoderConfiguration = 1;
	short soap_flag;
	a = (struct __trt__AddAudioEncoderConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__AddAudioEncoderConfiguration, sizeof(struct __trt__AddAudioEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__AddAudioEncoderConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__AddAudioEncoderConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__AddAudioEncoderConfiguration(soap, "trt:AddAudioEncoderConfiguration", &a->trt__AddAudioEncoderConfiguration, ""))
				{	soap_flag_trt__AddAudioEncoderConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__AddAudioEncoderConfiguration(struct soap *soap, const struct __trt__AddAudioEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__AddAudioEncoderConfiguration(soap, tag?tag:"-trt:AddAudioEncoderConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddAudioEncoderConfiguration * SOAP_FMAC4 soap_get___trt__AddAudioEncoderConfiguration(struct soap *soap, struct __trt__AddAudioEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__AddAudioEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__AddVideoSourceConfiguration(struct soap *soap, struct __trt__AddVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__AddVideoSourceConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__AddVideoSourceConfiguration(struct soap *soap, const struct __trt__AddVideoSourceConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__AddVideoSourceConfiguration(soap, &a->trt__AddVideoSourceConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__AddVideoSourceConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__AddVideoSourceConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__AddVideoSourceConfiguration(soap, "trt:AddVideoSourceConfiguration", -1, &a->trt__AddVideoSourceConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddVideoSourceConfiguration * SOAP_FMAC4 soap_in___trt__AddVideoSourceConfiguration(struct soap *soap, const char *tag, struct __trt__AddVideoSourceConfiguration *a, const char *type)
{
	size_t soap_flag_trt__AddVideoSourceConfiguration = 1;
	short soap_flag;
	a = (struct __trt__AddVideoSourceConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__AddVideoSourceConfiguration, sizeof(struct __trt__AddVideoSourceConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__AddVideoSourceConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__AddVideoSourceConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__AddVideoSourceConfiguration(soap, "trt:AddVideoSourceConfiguration", &a->trt__AddVideoSourceConfiguration, ""))
				{	soap_flag_trt__AddVideoSourceConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__AddVideoSourceConfiguration(struct soap *soap, const struct __trt__AddVideoSourceConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__AddVideoSourceConfiguration(soap, tag?tag:"-trt:AddVideoSourceConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddVideoSourceConfiguration * SOAP_FMAC4 soap_get___trt__AddVideoSourceConfiguration(struct soap *soap, struct __trt__AddVideoSourceConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__AddVideoSourceConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__AddVideoEncoderConfiguration(struct soap *soap, struct __trt__AddVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__AddVideoEncoderConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__AddVideoEncoderConfiguration(struct soap *soap, const struct __trt__AddVideoEncoderConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__AddVideoEncoderConfiguration(soap, &a->trt__AddVideoEncoderConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__AddVideoEncoderConfiguration(struct soap *soap, const char *tag, int id, const struct __trt__AddVideoEncoderConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_trt__AddVideoEncoderConfiguration(soap, "trt:AddVideoEncoderConfiguration", -1, &a->trt__AddVideoEncoderConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddVideoEncoderConfiguration * SOAP_FMAC4 soap_in___trt__AddVideoEncoderConfiguration(struct soap *soap, const char *tag, struct __trt__AddVideoEncoderConfiguration *a, const char *type)
{
	size_t soap_flag_trt__AddVideoEncoderConfiguration = 1;
	short soap_flag;
	a = (struct __trt__AddVideoEncoderConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__AddVideoEncoderConfiguration, sizeof(struct __trt__AddVideoEncoderConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__AddVideoEncoderConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__AddVideoEncoderConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__AddVideoEncoderConfiguration(soap, "trt:AddVideoEncoderConfiguration", &a->trt__AddVideoEncoderConfiguration, ""))
				{	soap_flag_trt__AddVideoEncoderConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__AddVideoEncoderConfiguration(struct soap *soap, const struct __trt__AddVideoEncoderConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__AddVideoEncoderConfiguration(soap, tag?tag:"-trt:AddVideoEncoderConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__AddVideoEncoderConfiguration * SOAP_FMAC4 soap_get___trt__AddVideoEncoderConfiguration(struct soap *soap, struct __trt__AddVideoEncoderConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__AddVideoEncoderConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetProfiles(struct soap *soap, struct __trt__GetProfiles *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetProfiles = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetProfiles(struct soap *soap, const struct __trt__GetProfiles *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetProfiles(soap, &a->trt__GetProfiles);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetProfiles(struct soap *soap, const char *tag, int id, const struct __trt__GetProfiles *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetProfiles(soap, "trt:GetProfiles", -1, &a->trt__GetProfiles, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetProfiles * SOAP_FMAC4 soap_in___trt__GetProfiles(struct soap *soap, const char *tag, struct __trt__GetProfiles *a, const char *type)
{
	size_t soap_flag_trt__GetProfiles = 1;
	short soap_flag;
	a = (struct __trt__GetProfiles *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetProfiles, sizeof(struct __trt__GetProfiles), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetProfiles(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetProfiles && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetProfiles(soap, "trt:GetProfiles", &a->trt__GetProfiles, ""))
				{	soap_flag_trt__GetProfiles--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetProfiles(struct soap *soap, const struct __trt__GetProfiles *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetProfiles(soap, tag?tag:"-trt:GetProfiles", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetProfiles * SOAP_FMAC4 soap_get___trt__GetProfiles(struct soap *soap, struct __trt__GetProfiles *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetProfiles(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetProfile(struct soap *soap, struct __trt__GetProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetProfile = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetProfile(struct soap *soap, const struct __trt__GetProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetProfile(soap, &a->trt__GetProfile);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetProfile(struct soap *soap, const char *tag, int id, const struct __trt__GetProfile *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetProfile(soap, "trt:GetProfile", -1, &a->trt__GetProfile, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetProfile * SOAP_FMAC4 soap_in___trt__GetProfile(struct soap *soap, const char *tag, struct __trt__GetProfile *a, const char *type)
{
	size_t soap_flag_trt__GetProfile = 1;
	short soap_flag;
	a = (struct __trt__GetProfile *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetProfile, sizeof(struct __trt__GetProfile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetProfile(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetProfile && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetProfile(soap, "trt:GetProfile", &a->trt__GetProfile, ""))
				{	soap_flag_trt__GetProfile--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetProfile(struct soap *soap, const struct __trt__GetProfile *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetProfile(soap, tag?tag:"-trt:GetProfile", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetProfile * SOAP_FMAC4 soap_get___trt__GetProfile(struct soap *soap, struct __trt__GetProfile *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetProfile(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__CreateProfile(struct soap *soap, struct __trt__CreateProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__CreateProfile = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__CreateProfile(struct soap *soap, const struct __trt__CreateProfile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__CreateProfile(soap, &a->trt__CreateProfile);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__CreateProfile(struct soap *soap, const char *tag, int id, const struct __trt__CreateProfile *a, const char *type)
{
	if (soap_out_PointerTo_trt__CreateProfile(soap, "trt:CreateProfile", -1, &a->trt__CreateProfile, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__CreateProfile * SOAP_FMAC4 soap_in___trt__CreateProfile(struct soap *soap, const char *tag, struct __trt__CreateProfile *a, const char *type)
{
	size_t soap_flag_trt__CreateProfile = 1;
	short soap_flag;
	a = (struct __trt__CreateProfile *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__CreateProfile, sizeof(struct __trt__CreateProfile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__CreateProfile(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__CreateProfile && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__CreateProfile(soap, "trt:CreateProfile", &a->trt__CreateProfile, ""))
				{	soap_flag_trt__CreateProfile--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__CreateProfile(struct soap *soap, const struct __trt__CreateProfile *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__CreateProfile(soap, tag?tag:"-trt:CreateProfile", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__CreateProfile * SOAP_FMAC4 soap_get___trt__CreateProfile(struct soap *soap, struct __trt__CreateProfile *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__CreateProfile(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetAudioSources(struct soap *soap, struct __trt__GetAudioSources *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetAudioSources = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetAudioSources(struct soap *soap, const struct __trt__GetAudioSources *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetAudioSources(soap, &a->trt__GetAudioSources);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetAudioSources(struct soap *soap, const char *tag, int id, const struct __trt__GetAudioSources *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetAudioSources(soap, "trt:GetAudioSources", -1, &a->trt__GetAudioSources, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioSources * SOAP_FMAC4 soap_in___trt__GetAudioSources(struct soap *soap, const char *tag, struct __trt__GetAudioSources *a, const char *type)
{
	size_t soap_flag_trt__GetAudioSources = 1;
	short soap_flag;
	a = (struct __trt__GetAudioSources *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetAudioSources, sizeof(struct __trt__GetAudioSources), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetAudioSources(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetAudioSources && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetAudioSources(soap, "trt:GetAudioSources", &a->trt__GetAudioSources, ""))
				{	soap_flag_trt__GetAudioSources--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetAudioSources(struct soap *soap, const struct __trt__GetAudioSources *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetAudioSources(soap, tag?tag:"-trt:GetAudioSources", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetAudioSources * SOAP_FMAC4 soap_get___trt__GetAudioSources(struct soap *soap, struct __trt__GetAudioSources *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetAudioSources(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___trt__GetVideoSources(struct soap *soap, struct __trt__GetVideoSources *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->trt__GetVideoSources = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___trt__GetVideoSources(struct soap *soap, const struct __trt__GetVideoSources *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_trt__GetVideoSources(soap, &a->trt__GetVideoSources);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___trt__GetVideoSources(struct soap *soap, const char *tag, int id, const struct __trt__GetVideoSources *a, const char *type)
{
	if (soap_out_PointerTo_trt__GetVideoSources(soap, "trt:GetVideoSources", -1, &a->trt__GetVideoSources, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoSources * SOAP_FMAC4 soap_in___trt__GetVideoSources(struct soap *soap, const char *tag, struct __trt__GetVideoSources *a, const char *type)
{
	size_t soap_flag_trt__GetVideoSources = 1;
	short soap_flag;
	a = (struct __trt__GetVideoSources *)soap_id_enter(soap, "", a, SOAP_TYPE___trt__GetVideoSources, sizeof(struct __trt__GetVideoSources), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___trt__GetVideoSources(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_trt__GetVideoSources && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_trt__GetVideoSources(soap, "trt:GetVideoSources", &a->trt__GetVideoSources, ""))
				{	soap_flag_trt__GetVideoSources--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___trt__GetVideoSources(struct soap *soap, const struct __trt__GetVideoSources *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___trt__GetVideoSources(soap, tag?tag:"-trt:GetVideoSources", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __trt__GetVideoSources * SOAP_FMAC4 soap_get___trt__GetVideoSources(struct soap *soap, struct __trt__GetVideoSources *p, const char *tag, const char *type)
{
	if ((p = soap_in___trt__GetVideoSources(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__Stop_(struct soap *soap, struct __tptz__Stop_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__Stop = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__Stop_(struct soap *soap, const struct __tptz__Stop_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__Stop(soap, &a->tptz__Stop);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__Stop_(struct soap *soap, const char *tag, int id, const struct __tptz__Stop_ *a, const char *type)
{
	if (soap_out_PointerTo_tptz__Stop(soap, "tptz:Stop", -1, &a->tptz__Stop, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__Stop_ * SOAP_FMAC4 soap_in___tptz__Stop_(struct soap *soap, const char *tag, struct __tptz__Stop_ *a, const char *type)
{
	size_t soap_flag_tptz__Stop = 1;
	short soap_flag;
	a = (struct __tptz__Stop_ *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__Stop_, sizeof(struct __tptz__Stop_), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__Stop_(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__Stop && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__Stop(soap, "tptz:Stop", &a->tptz__Stop, ""))
				{	soap_flag_tptz__Stop--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__Stop_(struct soap *soap, const struct __tptz__Stop_ *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__Stop_(soap, tag?tag:"-tptz:Stop", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__Stop_ * SOAP_FMAC4 soap_get___tptz__Stop_(struct soap *soap, struct __tptz__Stop_ *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__Stop_(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__AbsoluteMove_(struct soap *soap, struct __tptz__AbsoluteMove_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__AbsoluteMove = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__AbsoluteMove_(struct soap *soap, const struct __tptz__AbsoluteMove_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__AbsoluteMove(soap, &a->tptz__AbsoluteMove);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__AbsoluteMove_(struct soap *soap, const char *tag, int id, const struct __tptz__AbsoluteMove_ *a, const char *type)
{
	if (soap_out_PointerTo_tptz__AbsoluteMove(soap, "tptz:AbsoluteMove", -1, &a->tptz__AbsoluteMove, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__AbsoluteMove_ * SOAP_FMAC4 soap_in___tptz__AbsoluteMove_(struct soap *soap, const char *tag, struct __tptz__AbsoluteMove_ *a, const char *type)
{
	size_t soap_flag_tptz__AbsoluteMove = 1;
	short soap_flag;
	a = (struct __tptz__AbsoluteMove_ *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__AbsoluteMove_, sizeof(struct __tptz__AbsoluteMove_), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__AbsoluteMove_(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__AbsoluteMove && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__AbsoluteMove(soap, "tptz:AbsoluteMove", &a->tptz__AbsoluteMove, ""))
				{	soap_flag_tptz__AbsoluteMove--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__AbsoluteMove_(struct soap *soap, const struct __tptz__AbsoluteMove_ *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__AbsoluteMove_(soap, tag?tag:"-tptz:AbsoluteMove", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__AbsoluteMove_ * SOAP_FMAC4 soap_get___tptz__AbsoluteMove_(struct soap *soap, struct __tptz__AbsoluteMove_ *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__AbsoluteMove_(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__ContinuousMove_(struct soap *soap, struct __tptz__ContinuousMove_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__ContinuousMove = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__ContinuousMove_(struct soap *soap, const struct __tptz__ContinuousMove_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__ContinuousMove(soap, &a->tptz__ContinuousMove);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__ContinuousMove_(struct soap *soap, const char *tag, int id, const struct __tptz__ContinuousMove_ *a, const char *type)
{
	if (soap_out_PointerTo_tptz__ContinuousMove(soap, "tptz:ContinuousMove", -1, &a->tptz__ContinuousMove, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__ContinuousMove_ * SOAP_FMAC4 soap_in___tptz__ContinuousMove_(struct soap *soap, const char *tag, struct __tptz__ContinuousMove_ *a, const char *type)
{
	size_t soap_flag_tptz__ContinuousMove = 1;
	short soap_flag;
	a = (struct __tptz__ContinuousMove_ *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__ContinuousMove_, sizeof(struct __tptz__ContinuousMove_), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__ContinuousMove_(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__ContinuousMove && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__ContinuousMove(soap, "tptz:ContinuousMove", &a->tptz__ContinuousMove, ""))
				{	soap_flag_tptz__ContinuousMove--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__ContinuousMove_(struct soap *soap, const struct __tptz__ContinuousMove_ *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__ContinuousMove_(soap, tag?tag:"-tptz:ContinuousMove", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__ContinuousMove_ * SOAP_FMAC4 soap_get___tptz__ContinuousMove_(struct soap *soap, struct __tptz__ContinuousMove_ *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__ContinuousMove_(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__SetHomePosition_(struct soap *soap, struct __tptz__SetHomePosition_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__SetHomePosition = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__SetHomePosition_(struct soap *soap, const struct __tptz__SetHomePosition_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__SetHomePosition(soap, &a->tptz__SetHomePosition);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__SetHomePosition_(struct soap *soap, const char *tag, int id, const struct __tptz__SetHomePosition_ *a, const char *type)
{
	if (soap_out_PointerTo_tptz__SetHomePosition(soap, "tptz:SetHomePosition", -1, &a->tptz__SetHomePosition, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__SetHomePosition_ * SOAP_FMAC4 soap_in___tptz__SetHomePosition_(struct soap *soap, const char *tag, struct __tptz__SetHomePosition_ *a, const char *type)
{
	size_t soap_flag_tptz__SetHomePosition = 1;
	short soap_flag;
	a = (struct __tptz__SetHomePosition_ *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__SetHomePosition_, sizeof(struct __tptz__SetHomePosition_), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__SetHomePosition_(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__SetHomePosition && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__SetHomePosition(soap, "tptz:SetHomePosition", &a->tptz__SetHomePosition, ""))
				{	soap_flag_tptz__SetHomePosition--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__SetHomePosition_(struct soap *soap, const struct __tptz__SetHomePosition_ *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__SetHomePosition_(soap, tag?tag:"-tptz:SetHomePosition", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__SetHomePosition_ * SOAP_FMAC4 soap_get___tptz__SetHomePosition_(struct soap *soap, struct __tptz__SetHomePosition_ *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__SetHomePosition_(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__SetHomePosition_Response(struct soap *soap, struct __tptz__SetHomePosition_Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__SetHomePositionResponse = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__SetHomePosition_Response(struct soap *soap, const struct __tptz__SetHomePosition_Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__SetHomePositionResponse(soap, &a->tptz__SetHomePositionResponse);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__SetHomePosition_Response(struct soap *soap, const char *tag, int id, const struct __tptz__SetHomePosition_Response *a, const char *type)
{
	if (a->tptz__SetHomePositionResponse)
		soap_element_result(soap, "tptz:SetHomePositionResponse");
	if (soap_out_PointerTo_tptz__SetHomePositionResponse(soap, "tptz:SetHomePositionResponse", -1, &a->tptz__SetHomePositionResponse, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__SetHomePosition_Response * SOAP_FMAC4 soap_in___tptz__SetHomePosition_Response(struct soap *soap, const char *tag, struct __tptz__SetHomePosition_Response *a, const char *type)
{
	size_t soap_flag_tptz__SetHomePositionResponse = 1;
	short soap_flag;
	a = (struct __tptz__SetHomePosition_Response *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__SetHomePosition_Response, sizeof(struct __tptz__SetHomePosition_Response), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__SetHomePosition_Response(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__SetHomePositionResponse && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__SetHomePositionResponse(soap, "tptz:SetHomePositionResponse", &a->tptz__SetHomePositionResponse, ""))
				{	soap_flag_tptz__SetHomePositionResponse--;
					continue;
				}
			soap_check_result(soap, "tptz:SetHomePositionResponse");
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__SetHomePosition_Response(struct soap *soap, const struct __tptz__SetHomePosition_Response *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__SetHomePosition_Response(soap, tag?tag:"-tptz:SetHomePosition-Response", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__SetHomePosition_Response * SOAP_FMAC4 soap_get___tptz__SetHomePosition_Response(struct soap *soap, struct __tptz__SetHomePosition_Response *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__SetHomePosition_Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GotoHomePosition_(struct soap *soap, struct __tptz__GotoHomePosition_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GotoHomePosition = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GotoHomePosition_(struct soap *soap, const struct __tptz__GotoHomePosition_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GotoHomePosition(soap, &a->tptz__GotoHomePosition);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GotoHomePosition_(struct soap *soap, const char *tag, int id, const struct __tptz__GotoHomePosition_ *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GotoHomePosition(soap, "tptz:GotoHomePosition", -1, &a->tptz__GotoHomePosition, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GotoHomePosition_ * SOAP_FMAC4 soap_in___tptz__GotoHomePosition_(struct soap *soap, const char *tag, struct __tptz__GotoHomePosition_ *a, const char *type)
{
	size_t soap_flag_tptz__GotoHomePosition = 1;
	short soap_flag;
	a = (struct __tptz__GotoHomePosition_ *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GotoHomePosition_, sizeof(struct __tptz__GotoHomePosition_), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GotoHomePosition_(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GotoHomePosition && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GotoHomePosition(soap, "tptz:GotoHomePosition", &a->tptz__GotoHomePosition, ""))
				{	soap_flag_tptz__GotoHomePosition--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GotoHomePosition_(struct soap *soap, const struct __tptz__GotoHomePosition_ *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GotoHomePosition_(soap, tag?tag:"-tptz:GotoHomePosition", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GotoHomePosition_ * SOAP_FMAC4 soap_get___tptz__GotoHomePosition_(struct soap *soap, struct __tptz__GotoHomePosition_ *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GotoHomePosition_(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GetConfigurationOptions_(struct soap *soap, struct __tptz__GetConfigurationOptions_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GetConfigurationOptions = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GetConfigurationOptions_(struct soap *soap, const struct __tptz__GetConfigurationOptions_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GetConfigurationOptions(soap, &a->tptz__GetConfigurationOptions);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GetConfigurationOptions_(struct soap *soap, const char *tag, int id, const struct __tptz__GetConfigurationOptions_ *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GetConfigurationOptions(soap, "tptz:GetConfigurationOptions", -1, &a->tptz__GetConfigurationOptions, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetConfigurationOptions_ * SOAP_FMAC4 soap_in___tptz__GetConfigurationOptions_(struct soap *soap, const char *tag, struct __tptz__GetConfigurationOptions_ *a, const char *type)
{
	size_t soap_flag_tptz__GetConfigurationOptions = 1;
	short soap_flag;
	a = (struct __tptz__GetConfigurationOptions_ *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GetConfigurationOptions_, sizeof(struct __tptz__GetConfigurationOptions_), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GetConfigurationOptions_(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GetConfigurationOptions && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GetConfigurationOptions(soap, "tptz:GetConfigurationOptions", &a->tptz__GetConfigurationOptions, ""))
				{	soap_flag_tptz__GetConfigurationOptions--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GetConfigurationOptions_(struct soap *soap, const struct __tptz__GetConfigurationOptions_ *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GetConfigurationOptions_(soap, tag?tag:"-tptz:GetConfigurationOptions", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetConfigurationOptions_ * SOAP_FMAC4 soap_get___tptz__GetConfigurationOptions_(struct soap *soap, struct __tptz__GetConfigurationOptions_ *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GetConfigurationOptions_(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__SetConfiguration_(struct soap *soap, struct __tptz__SetConfiguration_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__SetConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__SetConfiguration_(struct soap *soap, const struct __tptz__SetConfiguration_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__SetConfiguration(soap, &a->tptz__SetConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__SetConfiguration_(struct soap *soap, const char *tag, int id, const struct __tptz__SetConfiguration_ *a, const char *type)
{
	if (soap_out_PointerTo_tptz__SetConfiguration(soap, "tptz:SetConfiguration", -1, &a->tptz__SetConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__SetConfiguration_ * SOAP_FMAC4 soap_in___tptz__SetConfiguration_(struct soap *soap, const char *tag, struct __tptz__SetConfiguration_ *a, const char *type)
{
	size_t soap_flag_tptz__SetConfiguration = 1;
	short soap_flag;
	a = (struct __tptz__SetConfiguration_ *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__SetConfiguration_, sizeof(struct __tptz__SetConfiguration_), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__SetConfiguration_(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__SetConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__SetConfiguration(soap, "tptz:SetConfiguration", &a->tptz__SetConfiguration, ""))
				{	soap_flag_tptz__SetConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__SetConfiguration_(struct soap *soap, const struct __tptz__SetConfiguration_ *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__SetConfiguration_(soap, tag?tag:"-tptz:SetConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__SetConfiguration_ * SOAP_FMAC4 soap_get___tptz__SetConfiguration_(struct soap *soap, struct __tptz__SetConfiguration_ *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__SetConfiguration_(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GetNode_(struct soap *soap, struct __tptz__GetNode_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GetNode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GetNode_(struct soap *soap, const struct __tptz__GetNode_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GetNode(soap, &a->tptz__GetNode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GetNode_(struct soap *soap, const char *tag, int id, const struct __tptz__GetNode_ *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GetNode(soap, "tptz:GetNode", -1, &a->tptz__GetNode, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetNode_ * SOAP_FMAC4 soap_in___tptz__GetNode_(struct soap *soap, const char *tag, struct __tptz__GetNode_ *a, const char *type)
{
	size_t soap_flag_tptz__GetNode = 1;
	short soap_flag;
	a = (struct __tptz__GetNode_ *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GetNode_, sizeof(struct __tptz__GetNode_), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GetNode_(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GetNode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GetNode(soap, "tptz:GetNode", &a->tptz__GetNode, ""))
				{	soap_flag_tptz__GetNode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GetNode_(struct soap *soap, const struct __tptz__GetNode_ *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GetNode_(soap, tag?tag:"-tptz:GetNode", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetNode_ * SOAP_FMAC4 soap_get___tptz__GetNode_(struct soap *soap, struct __tptz__GetNode_ *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GetNode_(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GetNodes_(struct soap *soap, struct __tptz__GetNodes_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GetNodes = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GetNodes_(struct soap *soap, const struct __tptz__GetNodes_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GetNodes(soap, &a->tptz__GetNodes);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GetNodes_(struct soap *soap, const char *tag, int id, const struct __tptz__GetNodes_ *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GetNodes(soap, "tptz:GetNodes", -1, &a->tptz__GetNodes, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetNodes_ * SOAP_FMAC4 soap_in___tptz__GetNodes_(struct soap *soap, const char *tag, struct __tptz__GetNodes_ *a, const char *type)
{
	size_t soap_flag_tptz__GetNodes = 1;
	short soap_flag;
	a = (struct __tptz__GetNodes_ *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GetNodes_, sizeof(struct __tptz__GetNodes_), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GetNodes_(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GetNodes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GetNodes(soap, "tptz:GetNodes", &a->tptz__GetNodes, ""))
				{	soap_flag_tptz__GetNodes--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GetNodes_(struct soap *soap, const struct __tptz__GetNodes_ *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GetNodes_(soap, tag?tag:"-tptz:GetNodes", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetNodes_ * SOAP_FMAC4 soap_get___tptz__GetNodes_(struct soap *soap, struct __tptz__GetNodes_ *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GetNodes_(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GetConfiguration_(struct soap *soap, struct __tptz__GetConfiguration_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GetConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GetConfiguration_(struct soap *soap, const struct __tptz__GetConfiguration_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GetConfiguration(soap, &a->tptz__GetConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GetConfiguration_(struct soap *soap, const char *tag, int id, const struct __tptz__GetConfiguration_ *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GetConfiguration(soap, "tptz:GetConfiguration", -1, &a->tptz__GetConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetConfiguration_ * SOAP_FMAC4 soap_in___tptz__GetConfiguration_(struct soap *soap, const char *tag, struct __tptz__GetConfiguration_ *a, const char *type)
{
	size_t soap_flag_tptz__GetConfiguration = 1;
	short soap_flag;
	a = (struct __tptz__GetConfiguration_ *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GetConfiguration_, sizeof(struct __tptz__GetConfiguration_), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GetConfiguration_(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GetConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GetConfiguration(soap, "tptz:GetConfiguration", &a->tptz__GetConfiguration, ""))
				{	soap_flag_tptz__GetConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GetConfiguration_(struct soap *soap, const struct __tptz__GetConfiguration_ *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GetConfiguration_(soap, tag?tag:"-tptz:GetConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetConfiguration_ * SOAP_FMAC4 soap_get___tptz__GetConfiguration_(struct soap *soap, struct __tptz__GetConfiguration_ *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GetConfiguration_(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GetStatus_(struct soap *soap, struct __tptz__GetStatus_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GetStatus = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GetStatus_(struct soap *soap, const struct __tptz__GetStatus_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GetStatus(soap, &a->tptz__GetStatus);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GetStatus_(struct soap *soap, const char *tag, int id, const struct __tptz__GetStatus_ *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GetStatus(soap, "tptz:GetStatus", -1, &a->tptz__GetStatus, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetStatus_ * SOAP_FMAC4 soap_in___tptz__GetStatus_(struct soap *soap, const char *tag, struct __tptz__GetStatus_ *a, const char *type)
{
	size_t soap_flag_tptz__GetStatus = 1;
	short soap_flag;
	a = (struct __tptz__GetStatus_ *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GetStatus_, sizeof(struct __tptz__GetStatus_), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GetStatus_(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GetStatus && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GetStatus(soap, "tptz:GetStatus", &a->tptz__GetStatus, ""))
				{	soap_flag_tptz__GetStatus--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GetStatus_(struct soap *soap, const struct __tptz__GetStatus_ *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GetStatus_(soap, tag?tag:"-tptz:GetStatus", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetStatus_ * SOAP_FMAC4 soap_get___tptz__GetStatus_(struct soap *soap, struct __tptz__GetStatus_ *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GetStatus_(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GotoPreset_(struct soap *soap, struct __tptz__GotoPreset_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GotoPreset = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GotoPreset_(struct soap *soap, const struct __tptz__GotoPreset_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GotoPreset(soap, &a->tptz__GotoPreset);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GotoPreset_(struct soap *soap, const char *tag, int id, const struct __tptz__GotoPreset_ *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GotoPreset(soap, "tptz:GotoPreset", -1, &a->tptz__GotoPreset, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GotoPreset_ * SOAP_FMAC4 soap_in___tptz__GotoPreset_(struct soap *soap, const char *tag, struct __tptz__GotoPreset_ *a, const char *type)
{
	size_t soap_flag_tptz__GotoPreset = 1;
	short soap_flag;
	a = (struct __tptz__GotoPreset_ *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GotoPreset_, sizeof(struct __tptz__GotoPreset_), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GotoPreset_(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GotoPreset && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GotoPreset(soap, "tptz:GotoPreset", &a->tptz__GotoPreset, ""))
				{	soap_flag_tptz__GotoPreset--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GotoPreset_(struct soap *soap, const struct __tptz__GotoPreset_ *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GotoPreset_(soap, tag?tag:"-tptz:GotoPreset", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GotoPreset_ * SOAP_FMAC4 soap_get___tptz__GotoPreset_(struct soap *soap, struct __tptz__GotoPreset_ *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GotoPreset_(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__RemovePreset_(struct soap *soap, struct __tptz__RemovePreset_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__RemovePreset = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__RemovePreset_(struct soap *soap, const struct __tptz__RemovePreset_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__RemovePreset(soap, &a->tptz__RemovePreset);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__RemovePreset_(struct soap *soap, const char *tag, int id, const struct __tptz__RemovePreset_ *a, const char *type)
{
	if (soap_out_PointerTo_tptz__RemovePreset(soap, "tptz:RemovePreset", -1, &a->tptz__RemovePreset, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__RemovePreset_ * SOAP_FMAC4 soap_in___tptz__RemovePreset_(struct soap *soap, const char *tag, struct __tptz__RemovePreset_ *a, const char *type)
{
	size_t soap_flag_tptz__RemovePreset = 1;
	short soap_flag;
	a = (struct __tptz__RemovePreset_ *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__RemovePreset_, sizeof(struct __tptz__RemovePreset_), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__RemovePreset_(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__RemovePreset && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__RemovePreset(soap, "tptz:RemovePreset", &a->tptz__RemovePreset, ""))
				{	soap_flag_tptz__RemovePreset--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__RemovePreset_(struct soap *soap, const struct __tptz__RemovePreset_ *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__RemovePreset_(soap, tag?tag:"-tptz:RemovePreset", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__RemovePreset_ * SOAP_FMAC4 soap_get___tptz__RemovePreset_(struct soap *soap, struct __tptz__RemovePreset_ *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__RemovePreset_(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__SetPreset_(struct soap *soap, struct __tptz__SetPreset_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__SetPreset = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__SetPreset_(struct soap *soap, const struct __tptz__SetPreset_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__SetPreset(soap, &a->tptz__SetPreset);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__SetPreset_(struct soap *soap, const char *tag, int id, const struct __tptz__SetPreset_ *a, const char *type)
{
	if (soap_out_PointerTo_tptz__SetPreset(soap, "tptz:SetPreset", -1, &a->tptz__SetPreset, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__SetPreset_ * SOAP_FMAC4 soap_in___tptz__SetPreset_(struct soap *soap, const char *tag, struct __tptz__SetPreset_ *a, const char *type)
{
	size_t soap_flag_tptz__SetPreset = 1;
	short soap_flag;
	a = (struct __tptz__SetPreset_ *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__SetPreset_, sizeof(struct __tptz__SetPreset_), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__SetPreset_(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__SetPreset && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__SetPreset(soap, "tptz:SetPreset", &a->tptz__SetPreset, ""))
				{	soap_flag_tptz__SetPreset--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__SetPreset_(struct soap *soap, const struct __tptz__SetPreset_ *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__SetPreset_(soap, tag?tag:"-tptz:SetPreset", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__SetPreset_ * SOAP_FMAC4 soap_get___tptz__SetPreset_(struct soap *soap, struct __tptz__SetPreset_ *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__SetPreset_(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GetPresets_(struct soap *soap, struct __tptz__GetPresets_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GetPresets = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GetPresets_(struct soap *soap, const struct __tptz__GetPresets_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GetPresets(soap, &a->tptz__GetPresets);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GetPresets_(struct soap *soap, const char *tag, int id, const struct __tptz__GetPresets_ *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GetPresets(soap, "tptz:GetPresets", -1, &a->tptz__GetPresets, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetPresets_ * SOAP_FMAC4 soap_in___tptz__GetPresets_(struct soap *soap, const char *tag, struct __tptz__GetPresets_ *a, const char *type)
{
	size_t soap_flag_tptz__GetPresets = 1;
	short soap_flag;
	a = (struct __tptz__GetPresets_ *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GetPresets_, sizeof(struct __tptz__GetPresets_), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GetPresets_(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GetPresets && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GetPresets(soap, "tptz:GetPresets", &a->tptz__GetPresets, ""))
				{	soap_flag_tptz__GetPresets--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GetPresets_(struct soap *soap, const struct __tptz__GetPresets_ *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GetPresets_(soap, tag?tag:"-tptz:GetPresets", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetPresets_ * SOAP_FMAC4 soap_get___tptz__GetPresets_(struct soap *soap, struct __tptz__GetPresets_ *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GetPresets_(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GetConfigurations_(struct soap *soap, struct __tptz__GetConfigurations_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GetConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GetConfigurations_(struct soap *soap, const struct __tptz__GetConfigurations_ *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GetConfigurations(soap, &a->tptz__GetConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GetConfigurations_(struct soap *soap, const char *tag, int id, const struct __tptz__GetConfigurations_ *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GetConfigurations(soap, "tptz:GetConfigurations", -1, &a->tptz__GetConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetConfigurations_ * SOAP_FMAC4 soap_in___tptz__GetConfigurations_(struct soap *soap, const char *tag, struct __tptz__GetConfigurations_ *a, const char *type)
{
	size_t soap_flag_tptz__GetConfigurations = 1;
	short soap_flag;
	a = (struct __tptz__GetConfigurations_ *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GetConfigurations_, sizeof(struct __tptz__GetConfigurations_), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GetConfigurations_(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GetConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GetConfigurations(soap, "tptz:GetConfigurations", &a->tptz__GetConfigurations, ""))
				{	soap_flag_tptz__GetConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GetConfigurations_(struct soap *soap, const struct __tptz__GetConfigurations_ *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GetConfigurations_(soap, tag?tag:"-tptz:GetConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetConfigurations_ * SOAP_FMAC4 soap_get___tptz__GetConfigurations_(struct soap *soap, struct __tptz__GetConfigurations_ *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GetConfigurations_(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__Stop(struct soap *soap, struct __tptz__Stop *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__Stop = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__Stop(struct soap *soap, const struct __tptz__Stop *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__Stop(soap, &a->tptz__Stop);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__Stop(struct soap *soap, const char *tag, int id, const struct __tptz__Stop *a, const char *type)
{
	if (soap_out_PointerTo_tptz__Stop(soap, "tptz:Stop", -1, &a->tptz__Stop, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__Stop * SOAP_FMAC4 soap_in___tptz__Stop(struct soap *soap, const char *tag, struct __tptz__Stop *a, const char *type)
{
	size_t soap_flag_tptz__Stop = 1;
	short soap_flag;
	a = (struct __tptz__Stop *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__Stop, sizeof(struct __tptz__Stop), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__Stop(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__Stop && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__Stop(soap, "tptz:Stop", &a->tptz__Stop, ""))
				{	soap_flag_tptz__Stop--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__Stop(struct soap *soap, const struct __tptz__Stop *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__Stop(soap, tag?tag:"-tptz:Stop", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__Stop * SOAP_FMAC4 soap_get___tptz__Stop(struct soap *soap, struct __tptz__Stop *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__Stop(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__AbsoluteMove(struct soap *soap, struct __tptz__AbsoluteMove *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__AbsoluteMove = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__AbsoluteMove(struct soap *soap, const struct __tptz__AbsoluteMove *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__AbsoluteMove(soap, &a->tptz__AbsoluteMove);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__AbsoluteMove(struct soap *soap, const char *tag, int id, const struct __tptz__AbsoluteMove *a, const char *type)
{
	if (soap_out_PointerTo_tptz__AbsoluteMove(soap, "tptz:AbsoluteMove", -1, &a->tptz__AbsoluteMove, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__AbsoluteMove * SOAP_FMAC4 soap_in___tptz__AbsoluteMove(struct soap *soap, const char *tag, struct __tptz__AbsoluteMove *a, const char *type)
{
	size_t soap_flag_tptz__AbsoluteMove = 1;
	short soap_flag;
	a = (struct __tptz__AbsoluteMove *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__AbsoluteMove, sizeof(struct __tptz__AbsoluteMove), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__AbsoluteMove(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__AbsoluteMove && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__AbsoluteMove(soap, "tptz:AbsoluteMove", &a->tptz__AbsoluteMove, ""))
				{	soap_flag_tptz__AbsoluteMove--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__AbsoluteMove(struct soap *soap, const struct __tptz__AbsoluteMove *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__AbsoluteMove(soap, tag?tag:"-tptz:AbsoluteMove", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__AbsoluteMove * SOAP_FMAC4 soap_get___tptz__AbsoluteMove(struct soap *soap, struct __tptz__AbsoluteMove *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__AbsoluteMove(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__ContinuousMove(struct soap *soap, struct __tptz__ContinuousMove *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__ContinuousMove = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__ContinuousMove(struct soap *soap, const struct __tptz__ContinuousMove *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__ContinuousMove(soap, &a->tptz__ContinuousMove);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__ContinuousMove(struct soap *soap, const char *tag, int id, const struct __tptz__ContinuousMove *a, const char *type)
{
	if (soap_out_PointerTo_tptz__ContinuousMove(soap, "tptz:ContinuousMove", -1, &a->tptz__ContinuousMove, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__ContinuousMove * SOAP_FMAC4 soap_in___tptz__ContinuousMove(struct soap *soap, const char *tag, struct __tptz__ContinuousMove *a, const char *type)
{
	size_t soap_flag_tptz__ContinuousMove = 1;
	short soap_flag;
	a = (struct __tptz__ContinuousMove *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__ContinuousMove, sizeof(struct __tptz__ContinuousMove), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__ContinuousMove(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__ContinuousMove && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__ContinuousMove(soap, "tptz:ContinuousMove", &a->tptz__ContinuousMove, ""))
				{	soap_flag_tptz__ContinuousMove--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__ContinuousMove(struct soap *soap, const struct __tptz__ContinuousMove *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__ContinuousMove(soap, tag?tag:"-tptz:ContinuousMove", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__ContinuousMove * SOAP_FMAC4 soap_get___tptz__ContinuousMove(struct soap *soap, struct __tptz__ContinuousMove *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__ContinuousMove(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__SetHomePosition(struct soap *soap, struct __tptz__SetHomePosition *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__SetHomePosition = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__SetHomePosition(struct soap *soap, const struct __tptz__SetHomePosition *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__SetHomePosition(soap, &a->tptz__SetHomePosition);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__SetHomePosition(struct soap *soap, const char *tag, int id, const struct __tptz__SetHomePosition *a, const char *type)
{
	if (soap_out_PointerTo_tptz__SetHomePosition(soap, "tptz:SetHomePosition", -1, &a->tptz__SetHomePosition, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__SetHomePosition * SOAP_FMAC4 soap_in___tptz__SetHomePosition(struct soap *soap, const char *tag, struct __tptz__SetHomePosition *a, const char *type)
{
	size_t soap_flag_tptz__SetHomePosition = 1;
	short soap_flag;
	a = (struct __tptz__SetHomePosition *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__SetHomePosition, sizeof(struct __tptz__SetHomePosition), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__SetHomePosition(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__SetHomePosition && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__SetHomePosition(soap, "tptz:SetHomePosition", &a->tptz__SetHomePosition, ""))
				{	soap_flag_tptz__SetHomePosition--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__SetHomePosition(struct soap *soap, const struct __tptz__SetHomePosition *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__SetHomePosition(soap, tag?tag:"-tptz:SetHomePosition", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__SetHomePosition * SOAP_FMAC4 soap_get___tptz__SetHomePosition(struct soap *soap, struct __tptz__SetHomePosition *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__SetHomePosition(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__SetHomePositionResponse(struct soap *soap, struct __tptz__SetHomePositionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__SetHomePositionResponse = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__SetHomePositionResponse(struct soap *soap, const struct __tptz__SetHomePositionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__SetHomePositionResponse(soap, &a->tptz__SetHomePositionResponse);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__SetHomePositionResponse(struct soap *soap, const char *tag, int id, const struct __tptz__SetHomePositionResponse *a, const char *type)
{
	if (a->tptz__SetHomePositionResponse)
		soap_element_result(soap, "tptz:SetHomePositionResponse");
	if (soap_out_PointerTo_tptz__SetHomePositionResponse(soap, "tptz:SetHomePositionResponse", -1, &a->tptz__SetHomePositionResponse, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__SetHomePositionResponse * SOAP_FMAC4 soap_in___tptz__SetHomePositionResponse(struct soap *soap, const char *tag, struct __tptz__SetHomePositionResponse *a, const char *type)
{
	size_t soap_flag_tptz__SetHomePositionResponse = 1;
	short soap_flag;
	a = (struct __tptz__SetHomePositionResponse *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__SetHomePositionResponse, sizeof(struct __tptz__SetHomePositionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__SetHomePositionResponse(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__SetHomePositionResponse && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__SetHomePositionResponse(soap, "tptz:SetHomePositionResponse", &a->tptz__SetHomePositionResponse, ""))
				{	soap_flag_tptz__SetHomePositionResponse--;
					continue;
				}
			soap_check_result(soap, "tptz:SetHomePositionResponse");
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__SetHomePositionResponse(struct soap *soap, const struct __tptz__SetHomePositionResponse *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__SetHomePositionResponse(soap, tag?tag:"-tptz:SetHomePositionResponse", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__SetHomePositionResponse * SOAP_FMAC4 soap_get___tptz__SetHomePositionResponse(struct soap *soap, struct __tptz__SetHomePositionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__SetHomePositionResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GotoHomePosition(struct soap *soap, struct __tptz__GotoHomePosition *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GotoHomePosition = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GotoHomePosition(struct soap *soap, const struct __tptz__GotoHomePosition *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GotoHomePosition(soap, &a->tptz__GotoHomePosition);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GotoHomePosition(struct soap *soap, const char *tag, int id, const struct __tptz__GotoHomePosition *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GotoHomePosition(soap, "tptz:GotoHomePosition", -1, &a->tptz__GotoHomePosition, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GotoHomePosition * SOAP_FMAC4 soap_in___tptz__GotoHomePosition(struct soap *soap, const char *tag, struct __tptz__GotoHomePosition *a, const char *type)
{
	size_t soap_flag_tptz__GotoHomePosition = 1;
	short soap_flag;
	a = (struct __tptz__GotoHomePosition *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GotoHomePosition, sizeof(struct __tptz__GotoHomePosition), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GotoHomePosition(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GotoHomePosition && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GotoHomePosition(soap, "tptz:GotoHomePosition", &a->tptz__GotoHomePosition, ""))
				{	soap_flag_tptz__GotoHomePosition--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GotoHomePosition(struct soap *soap, const struct __tptz__GotoHomePosition *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GotoHomePosition(soap, tag?tag:"-tptz:GotoHomePosition", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GotoHomePosition * SOAP_FMAC4 soap_get___tptz__GotoHomePosition(struct soap *soap, struct __tptz__GotoHomePosition *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GotoHomePosition(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GetConfigurationOptions(struct soap *soap, struct __tptz__GetConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GetConfigurationOptions = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GetConfigurationOptions(struct soap *soap, const struct __tptz__GetConfigurationOptions *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GetConfigurationOptions(soap, &a->tptz__GetConfigurationOptions);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GetConfigurationOptions(struct soap *soap, const char *tag, int id, const struct __tptz__GetConfigurationOptions *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GetConfigurationOptions(soap, "tptz:GetConfigurationOptions", -1, &a->tptz__GetConfigurationOptions, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetConfigurationOptions * SOAP_FMAC4 soap_in___tptz__GetConfigurationOptions(struct soap *soap, const char *tag, struct __tptz__GetConfigurationOptions *a, const char *type)
{
	size_t soap_flag_tptz__GetConfigurationOptions = 1;
	short soap_flag;
	a = (struct __tptz__GetConfigurationOptions *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GetConfigurationOptions, sizeof(struct __tptz__GetConfigurationOptions), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GetConfigurationOptions(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GetConfigurationOptions && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GetConfigurationOptions(soap, "tptz:GetConfigurationOptions", &a->tptz__GetConfigurationOptions, ""))
				{	soap_flag_tptz__GetConfigurationOptions--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GetConfigurationOptions(struct soap *soap, const struct __tptz__GetConfigurationOptions *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GetConfigurationOptions(soap, tag?tag:"-tptz:GetConfigurationOptions", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetConfigurationOptions * SOAP_FMAC4 soap_get___tptz__GetConfigurationOptions(struct soap *soap, struct __tptz__GetConfigurationOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GetConfigurationOptions(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__SetConfiguration(struct soap *soap, struct __tptz__SetConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__SetConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__SetConfiguration(struct soap *soap, const struct __tptz__SetConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__SetConfiguration(soap, &a->tptz__SetConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__SetConfiguration(struct soap *soap, const char *tag, int id, const struct __tptz__SetConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_tptz__SetConfiguration(soap, "tptz:SetConfiguration", -1, &a->tptz__SetConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__SetConfiguration * SOAP_FMAC4 soap_in___tptz__SetConfiguration(struct soap *soap, const char *tag, struct __tptz__SetConfiguration *a, const char *type)
{
	size_t soap_flag_tptz__SetConfiguration = 1;
	short soap_flag;
	a = (struct __tptz__SetConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__SetConfiguration, sizeof(struct __tptz__SetConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__SetConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__SetConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__SetConfiguration(soap, "tptz:SetConfiguration", &a->tptz__SetConfiguration, ""))
				{	soap_flag_tptz__SetConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__SetConfiguration(struct soap *soap, const struct __tptz__SetConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__SetConfiguration(soap, tag?tag:"-tptz:SetConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__SetConfiguration * SOAP_FMAC4 soap_get___tptz__SetConfiguration(struct soap *soap, struct __tptz__SetConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__SetConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GetNode(struct soap *soap, struct __tptz__GetNode *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GetNode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GetNode(struct soap *soap, const struct __tptz__GetNode *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GetNode(soap, &a->tptz__GetNode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GetNode(struct soap *soap, const char *tag, int id, const struct __tptz__GetNode *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GetNode(soap, "tptz:GetNode", -1, &a->tptz__GetNode, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetNode * SOAP_FMAC4 soap_in___tptz__GetNode(struct soap *soap, const char *tag, struct __tptz__GetNode *a, const char *type)
{
	size_t soap_flag_tptz__GetNode = 1;
	short soap_flag;
	a = (struct __tptz__GetNode *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GetNode, sizeof(struct __tptz__GetNode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GetNode(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GetNode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GetNode(soap, "tptz:GetNode", &a->tptz__GetNode, ""))
				{	soap_flag_tptz__GetNode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GetNode(struct soap *soap, const struct __tptz__GetNode *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GetNode(soap, tag?tag:"-tptz:GetNode", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetNode * SOAP_FMAC4 soap_get___tptz__GetNode(struct soap *soap, struct __tptz__GetNode *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GetNode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GetNodes(struct soap *soap, struct __tptz__GetNodes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GetNodes = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GetNodes(struct soap *soap, const struct __tptz__GetNodes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GetNodes(soap, &a->tptz__GetNodes);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GetNodes(struct soap *soap, const char *tag, int id, const struct __tptz__GetNodes *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GetNodes(soap, "tptz:GetNodes", -1, &a->tptz__GetNodes, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetNodes * SOAP_FMAC4 soap_in___tptz__GetNodes(struct soap *soap, const char *tag, struct __tptz__GetNodes *a, const char *type)
{
	size_t soap_flag_tptz__GetNodes = 1;
	short soap_flag;
	a = (struct __tptz__GetNodes *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GetNodes, sizeof(struct __tptz__GetNodes), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GetNodes(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GetNodes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GetNodes(soap, "tptz:GetNodes", &a->tptz__GetNodes, ""))
				{	soap_flag_tptz__GetNodes--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GetNodes(struct soap *soap, const struct __tptz__GetNodes *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GetNodes(soap, tag?tag:"-tptz:GetNodes", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetNodes * SOAP_FMAC4 soap_get___tptz__GetNodes(struct soap *soap, struct __tptz__GetNodes *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GetNodes(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GetConfiguration(struct soap *soap, struct __tptz__GetConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GetConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GetConfiguration(struct soap *soap, const struct __tptz__GetConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GetConfiguration(soap, &a->tptz__GetConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GetConfiguration(struct soap *soap, const char *tag, int id, const struct __tptz__GetConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GetConfiguration(soap, "tptz:GetConfiguration", -1, &a->tptz__GetConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetConfiguration * SOAP_FMAC4 soap_in___tptz__GetConfiguration(struct soap *soap, const char *tag, struct __tptz__GetConfiguration *a, const char *type)
{
	size_t soap_flag_tptz__GetConfiguration = 1;
	short soap_flag;
	a = (struct __tptz__GetConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GetConfiguration, sizeof(struct __tptz__GetConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GetConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GetConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GetConfiguration(soap, "tptz:GetConfiguration", &a->tptz__GetConfiguration, ""))
				{	soap_flag_tptz__GetConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GetConfiguration(struct soap *soap, const struct __tptz__GetConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GetConfiguration(soap, tag?tag:"-tptz:GetConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetConfiguration * SOAP_FMAC4 soap_get___tptz__GetConfiguration(struct soap *soap, struct __tptz__GetConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GetConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GetStatus(struct soap *soap, struct __tptz__GetStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GetStatus = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GetStatus(struct soap *soap, const struct __tptz__GetStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GetStatus(soap, &a->tptz__GetStatus);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GetStatus(struct soap *soap, const char *tag, int id, const struct __tptz__GetStatus *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GetStatus(soap, "tptz:GetStatus", -1, &a->tptz__GetStatus, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetStatus * SOAP_FMAC4 soap_in___tptz__GetStatus(struct soap *soap, const char *tag, struct __tptz__GetStatus *a, const char *type)
{
	size_t soap_flag_tptz__GetStatus = 1;
	short soap_flag;
	a = (struct __tptz__GetStatus *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GetStatus, sizeof(struct __tptz__GetStatus), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GetStatus(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GetStatus && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GetStatus(soap, "tptz:GetStatus", &a->tptz__GetStatus, ""))
				{	soap_flag_tptz__GetStatus--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GetStatus(struct soap *soap, const struct __tptz__GetStatus *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GetStatus(soap, tag?tag:"-tptz:GetStatus", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetStatus * SOAP_FMAC4 soap_get___tptz__GetStatus(struct soap *soap, struct __tptz__GetStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GetStatus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GotoPreset(struct soap *soap, struct __tptz__GotoPreset *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GotoPreset = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GotoPreset(struct soap *soap, const struct __tptz__GotoPreset *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GotoPreset(soap, &a->tptz__GotoPreset);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GotoPreset(struct soap *soap, const char *tag, int id, const struct __tptz__GotoPreset *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GotoPreset(soap, "tptz:GotoPreset", -1, &a->tptz__GotoPreset, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GotoPreset * SOAP_FMAC4 soap_in___tptz__GotoPreset(struct soap *soap, const char *tag, struct __tptz__GotoPreset *a, const char *type)
{
	size_t soap_flag_tptz__GotoPreset = 1;
	short soap_flag;
	a = (struct __tptz__GotoPreset *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GotoPreset, sizeof(struct __tptz__GotoPreset), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GotoPreset(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GotoPreset && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GotoPreset(soap, "tptz:GotoPreset", &a->tptz__GotoPreset, ""))
				{	soap_flag_tptz__GotoPreset--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GotoPreset(struct soap *soap, const struct __tptz__GotoPreset *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GotoPreset(soap, tag?tag:"-tptz:GotoPreset", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GotoPreset * SOAP_FMAC4 soap_get___tptz__GotoPreset(struct soap *soap, struct __tptz__GotoPreset *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GotoPreset(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__RemovePreset(struct soap *soap, struct __tptz__RemovePreset *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__RemovePreset = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__RemovePreset(struct soap *soap, const struct __tptz__RemovePreset *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__RemovePreset(soap, &a->tptz__RemovePreset);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__RemovePreset(struct soap *soap, const char *tag, int id, const struct __tptz__RemovePreset *a, const char *type)
{
	if (soap_out_PointerTo_tptz__RemovePreset(soap, "tptz:RemovePreset", -1, &a->tptz__RemovePreset, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__RemovePreset * SOAP_FMAC4 soap_in___tptz__RemovePreset(struct soap *soap, const char *tag, struct __tptz__RemovePreset *a, const char *type)
{
	size_t soap_flag_tptz__RemovePreset = 1;
	short soap_flag;
	a = (struct __tptz__RemovePreset *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__RemovePreset, sizeof(struct __tptz__RemovePreset), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__RemovePreset(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__RemovePreset && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__RemovePreset(soap, "tptz:RemovePreset", &a->tptz__RemovePreset, ""))
				{	soap_flag_tptz__RemovePreset--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__RemovePreset(struct soap *soap, const struct __tptz__RemovePreset *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__RemovePreset(soap, tag?tag:"-tptz:RemovePreset", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__RemovePreset * SOAP_FMAC4 soap_get___tptz__RemovePreset(struct soap *soap, struct __tptz__RemovePreset *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__RemovePreset(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__SetPreset(struct soap *soap, struct __tptz__SetPreset *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__SetPreset = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__SetPreset(struct soap *soap, const struct __tptz__SetPreset *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__SetPreset(soap, &a->tptz__SetPreset);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__SetPreset(struct soap *soap, const char *tag, int id, const struct __tptz__SetPreset *a, const char *type)
{
	if (soap_out_PointerTo_tptz__SetPreset(soap, "tptz:SetPreset", -1, &a->tptz__SetPreset, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__SetPreset * SOAP_FMAC4 soap_in___tptz__SetPreset(struct soap *soap, const char *tag, struct __tptz__SetPreset *a, const char *type)
{
	size_t soap_flag_tptz__SetPreset = 1;
	short soap_flag;
	a = (struct __tptz__SetPreset *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__SetPreset, sizeof(struct __tptz__SetPreset), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__SetPreset(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__SetPreset && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__SetPreset(soap, "tptz:SetPreset", &a->tptz__SetPreset, ""))
				{	soap_flag_tptz__SetPreset--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__SetPreset(struct soap *soap, const struct __tptz__SetPreset *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__SetPreset(soap, tag?tag:"-tptz:SetPreset", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__SetPreset * SOAP_FMAC4 soap_get___tptz__SetPreset(struct soap *soap, struct __tptz__SetPreset *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__SetPreset(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GetPresets(struct soap *soap, struct __tptz__GetPresets *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GetPresets = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GetPresets(struct soap *soap, const struct __tptz__GetPresets *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GetPresets(soap, &a->tptz__GetPresets);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GetPresets(struct soap *soap, const char *tag, int id, const struct __tptz__GetPresets *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GetPresets(soap, "tptz:GetPresets", -1, &a->tptz__GetPresets, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetPresets * SOAP_FMAC4 soap_in___tptz__GetPresets(struct soap *soap, const char *tag, struct __tptz__GetPresets *a, const char *type)
{
	size_t soap_flag_tptz__GetPresets = 1;
	short soap_flag;
	a = (struct __tptz__GetPresets *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GetPresets, sizeof(struct __tptz__GetPresets), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GetPresets(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GetPresets && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GetPresets(soap, "tptz:GetPresets", &a->tptz__GetPresets, ""))
				{	soap_flag_tptz__GetPresets--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GetPresets(struct soap *soap, const struct __tptz__GetPresets *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GetPresets(soap, tag?tag:"-tptz:GetPresets", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetPresets * SOAP_FMAC4 soap_get___tptz__GetPresets(struct soap *soap, struct __tptz__GetPresets *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GetPresets(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__GetConfigurations(struct soap *soap, struct __tptz__GetConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tptz__GetConfigurations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__GetConfigurations(struct soap *soap, const struct __tptz__GetConfigurations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tptz__GetConfigurations(soap, &a->tptz__GetConfigurations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__GetConfigurations(struct soap *soap, const char *tag, int id, const struct __tptz__GetConfigurations *a, const char *type)
{
	if (soap_out_PointerTo_tptz__GetConfigurations(soap, "tptz:GetConfigurations", -1, &a->tptz__GetConfigurations, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetConfigurations * SOAP_FMAC4 soap_in___tptz__GetConfigurations(struct soap *soap, const char *tag, struct __tptz__GetConfigurations *a, const char *type)
{
	size_t soap_flag_tptz__GetConfigurations = 1;
	short soap_flag;
	a = (struct __tptz__GetConfigurations *)soap_id_enter(soap, "", a, SOAP_TYPE___tptz__GetConfigurations, sizeof(struct __tptz__GetConfigurations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tptz__GetConfigurations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tptz__GetConfigurations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tptz__GetConfigurations(soap, "tptz:GetConfigurations", &a->tptz__GetConfigurations, ""))
				{	soap_flag_tptz__GetConfigurations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tptz__GetConfigurations(struct soap *soap, const struct __tptz__GetConfigurations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tptz__GetConfigurations(soap, tag?tag:"-tptz:GetConfigurations", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__GetConfigurations * SOAP_FMAC4 soap_get___tptz__GetConfigurations(struct soap *soap, struct __tptz__GetConfigurations *p, const char *tag, const char *type)
{
	if ((p = soap_in___tptz__GetConfigurations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetRelayOutputState(struct soap *soap, struct __tds__SetRelayOutputState *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetRelayOutputState = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetRelayOutputState(struct soap *soap, const struct __tds__SetRelayOutputState *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetRelayOutputState(soap, &a->tds__SetRelayOutputState);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetRelayOutputState(struct soap *soap, const char *tag, int id, const struct __tds__SetRelayOutputState *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetRelayOutputState(soap, "tds:SetRelayOutputState", -1, &a->tds__SetRelayOutputState, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetRelayOutputState * SOAP_FMAC4 soap_in___tds__SetRelayOutputState(struct soap *soap, const char *tag, struct __tds__SetRelayOutputState *a, const char *type)
{
	size_t soap_flag_tds__SetRelayOutputState = 1;
	short soap_flag;
	a = (struct __tds__SetRelayOutputState *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetRelayOutputState, sizeof(struct __tds__SetRelayOutputState), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetRelayOutputState(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetRelayOutputState && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetRelayOutputState(soap, "tds:SetRelayOutputState", &a->tds__SetRelayOutputState, ""))
				{	soap_flag_tds__SetRelayOutputState--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetRelayOutputState(struct soap *soap, const struct __tds__SetRelayOutputState *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetRelayOutputState(soap, tag?tag:"-tds:SetRelayOutputState", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetRelayOutputState * SOAP_FMAC4 soap_get___tds__SetRelayOutputState(struct soap *soap, struct __tds__SetRelayOutputState *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetRelayOutputState(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetRelayOutputSettings(struct soap *soap, struct __tds__SetRelayOutputSettings *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetRelayOutputSettings = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetRelayOutputSettings(struct soap *soap, const struct __tds__SetRelayOutputSettings *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetRelayOutputSettings(soap, &a->tds__SetRelayOutputSettings);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetRelayOutputSettings(struct soap *soap, const char *tag, int id, const struct __tds__SetRelayOutputSettings *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetRelayOutputSettings(soap, "tds:SetRelayOutputSettings", -1, &a->tds__SetRelayOutputSettings, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetRelayOutputSettings * SOAP_FMAC4 soap_in___tds__SetRelayOutputSettings(struct soap *soap, const char *tag, struct __tds__SetRelayOutputSettings *a, const char *type)
{
	size_t soap_flag_tds__SetRelayOutputSettings = 1;
	short soap_flag;
	a = (struct __tds__SetRelayOutputSettings *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetRelayOutputSettings, sizeof(struct __tds__SetRelayOutputSettings), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetRelayOutputSettings(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetRelayOutputSettings && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetRelayOutputSettings(soap, "tds:SetRelayOutputSettings", &a->tds__SetRelayOutputSettings, ""))
				{	soap_flag_tds__SetRelayOutputSettings--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetRelayOutputSettings(struct soap *soap, const struct __tds__SetRelayOutputSettings *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetRelayOutputSettings(soap, tag?tag:"-tds:SetRelayOutputSettings", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetRelayOutputSettings * SOAP_FMAC4 soap_get___tds__SetRelayOutputSettings(struct soap *soap, struct __tds__SetRelayOutputSettings *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetRelayOutputSettings(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetRelayOutputs(struct soap *soap, struct __tds__GetRelayOutputs *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetRelayOutputs = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetRelayOutputs(struct soap *soap, const struct __tds__GetRelayOutputs *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetRelayOutputs(soap, &a->tds__GetRelayOutputs);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetRelayOutputs(struct soap *soap, const char *tag, int id, const struct __tds__GetRelayOutputs *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetRelayOutputs(soap, "tds:GetRelayOutputs", -1, &a->tds__GetRelayOutputs, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetRelayOutputs * SOAP_FMAC4 soap_in___tds__GetRelayOutputs(struct soap *soap, const char *tag, struct __tds__GetRelayOutputs *a, const char *type)
{
	size_t soap_flag_tds__GetRelayOutputs = 1;
	short soap_flag;
	a = (struct __tds__GetRelayOutputs *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetRelayOutputs, sizeof(struct __tds__GetRelayOutputs), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetRelayOutputs(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetRelayOutputs && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetRelayOutputs(soap, "tds:GetRelayOutputs", &a->tds__GetRelayOutputs, ""))
				{	soap_flag_tds__GetRelayOutputs--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetRelayOutputs(struct soap *soap, const struct __tds__GetRelayOutputs *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetRelayOutputs(soap, tag?tag:"-tds:GetRelayOutputs", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetRelayOutputs * SOAP_FMAC4 soap_get___tds__GetRelayOutputs(struct soap *soap, struct __tds__GetRelayOutputs *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetRelayOutputs(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetZeroConfiguration(struct soap *soap, struct __tds__SetZeroConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetZeroConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetZeroConfiguration(struct soap *soap, const struct __tds__SetZeroConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetZeroConfiguration(soap, &a->tds__SetZeroConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetZeroConfiguration(struct soap *soap, const char *tag, int id, const struct __tds__SetZeroConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetZeroConfiguration(soap, "tds:SetZeroConfiguration", -1, &a->tds__SetZeroConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetZeroConfiguration * SOAP_FMAC4 soap_in___tds__SetZeroConfiguration(struct soap *soap, const char *tag, struct __tds__SetZeroConfiguration *a, const char *type)
{
	size_t soap_flag_tds__SetZeroConfiguration = 1;
	short soap_flag;
	a = (struct __tds__SetZeroConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetZeroConfiguration, sizeof(struct __tds__SetZeroConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetZeroConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetZeroConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetZeroConfiguration(soap, "tds:SetZeroConfiguration", &a->tds__SetZeroConfiguration, ""))
				{	soap_flag_tds__SetZeroConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetZeroConfiguration(struct soap *soap, const struct __tds__SetZeroConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetZeroConfiguration(soap, tag?tag:"-tds:SetZeroConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetZeroConfiguration * SOAP_FMAC4 soap_get___tds__SetZeroConfiguration(struct soap *soap, struct __tds__SetZeroConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetZeroConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetZeroConfiguration(struct soap *soap, struct __tds__GetZeroConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetZeroConfiguration = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetZeroConfiguration(struct soap *soap, const struct __tds__GetZeroConfiguration *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetZeroConfiguration(soap, &a->tds__GetZeroConfiguration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetZeroConfiguration(struct soap *soap, const char *tag, int id, const struct __tds__GetZeroConfiguration *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetZeroConfiguration(soap, "tds:GetZeroConfiguration", -1, &a->tds__GetZeroConfiguration, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetZeroConfiguration * SOAP_FMAC4 soap_in___tds__GetZeroConfiguration(struct soap *soap, const char *tag, struct __tds__GetZeroConfiguration *a, const char *type)
{
	size_t soap_flag_tds__GetZeroConfiguration = 1;
	short soap_flag;
	a = (struct __tds__GetZeroConfiguration *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetZeroConfiguration, sizeof(struct __tds__GetZeroConfiguration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetZeroConfiguration(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetZeroConfiguration && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetZeroConfiguration(soap, "tds:GetZeroConfiguration", &a->tds__GetZeroConfiguration, ""))
				{	soap_flag_tds__GetZeroConfiguration--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetZeroConfiguration(struct soap *soap, const struct __tds__GetZeroConfiguration *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetZeroConfiguration(soap, tag?tag:"-tds:GetZeroConfiguration", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetZeroConfiguration * SOAP_FMAC4 soap_get___tds__GetZeroConfiguration(struct soap *soap, struct __tds__GetZeroConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetZeroConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetNetworkDefaultGateway(struct soap *soap, struct __tds__SetNetworkDefaultGateway *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetNetworkDefaultGateway = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetNetworkDefaultGateway(struct soap *soap, const struct __tds__SetNetworkDefaultGateway *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetNetworkDefaultGateway(soap, &a->tds__SetNetworkDefaultGateway);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetNetworkDefaultGateway(struct soap *soap, const char *tag, int id, const struct __tds__SetNetworkDefaultGateway *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetNetworkDefaultGateway(soap, "tds:SetNetworkDefaultGateway", -1, &a->tds__SetNetworkDefaultGateway, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetNetworkDefaultGateway * SOAP_FMAC4 soap_in___tds__SetNetworkDefaultGateway(struct soap *soap, const char *tag, struct __tds__SetNetworkDefaultGateway *a, const char *type)
{
	size_t soap_flag_tds__SetNetworkDefaultGateway = 1;
	short soap_flag;
	a = (struct __tds__SetNetworkDefaultGateway *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetNetworkDefaultGateway, sizeof(struct __tds__SetNetworkDefaultGateway), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetNetworkDefaultGateway(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetNetworkDefaultGateway && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetNetworkDefaultGateway(soap, "tds:SetNetworkDefaultGateway", &a->tds__SetNetworkDefaultGateway, ""))
				{	soap_flag_tds__SetNetworkDefaultGateway--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetNetworkDefaultGateway(struct soap *soap, const struct __tds__SetNetworkDefaultGateway *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetNetworkDefaultGateway(soap, tag?tag:"-tds:SetNetworkDefaultGateway", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetNetworkDefaultGateway * SOAP_FMAC4 soap_get___tds__SetNetworkDefaultGateway(struct soap *soap, struct __tds__SetNetworkDefaultGateway *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetNetworkDefaultGateway(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetNetworkDefaultGateway(struct soap *soap, struct __tds__GetNetworkDefaultGateway *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetNetworkDefaultGateway = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetNetworkDefaultGateway(struct soap *soap, const struct __tds__GetNetworkDefaultGateway *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetNetworkDefaultGateway(soap, &a->tds__GetNetworkDefaultGateway);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetNetworkDefaultGateway(struct soap *soap, const char *tag, int id, const struct __tds__GetNetworkDefaultGateway *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetNetworkDefaultGateway(soap, "tds:GetNetworkDefaultGateway", -1, &a->tds__GetNetworkDefaultGateway, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetNetworkDefaultGateway * SOAP_FMAC4 soap_in___tds__GetNetworkDefaultGateway(struct soap *soap, const char *tag, struct __tds__GetNetworkDefaultGateway *a, const char *type)
{
	size_t soap_flag_tds__GetNetworkDefaultGateway = 1;
	short soap_flag;
	a = (struct __tds__GetNetworkDefaultGateway *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetNetworkDefaultGateway, sizeof(struct __tds__GetNetworkDefaultGateway), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetNetworkDefaultGateway(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetNetworkDefaultGateway && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetNetworkDefaultGateway(soap, "tds:GetNetworkDefaultGateway", &a->tds__GetNetworkDefaultGateway, ""))
				{	soap_flag_tds__GetNetworkDefaultGateway--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetNetworkDefaultGateway(struct soap *soap, const struct __tds__GetNetworkDefaultGateway *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetNetworkDefaultGateway(soap, tag?tag:"-tds:GetNetworkDefaultGateway", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetNetworkDefaultGateway * SOAP_FMAC4 soap_get___tds__GetNetworkDefaultGateway(struct soap *soap, struct __tds__GetNetworkDefaultGateway *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetNetworkDefaultGateway(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetNetworkProtocols(struct soap *soap, struct __tds__SetNetworkProtocols *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetNetworkProtocols = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetNetworkProtocols(struct soap *soap, const struct __tds__SetNetworkProtocols *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetNetworkProtocols(soap, &a->tds__SetNetworkProtocols);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetNetworkProtocols(struct soap *soap, const char *tag, int id, const struct __tds__SetNetworkProtocols *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetNetworkProtocols(soap, "tds:SetNetworkProtocols", -1, &a->tds__SetNetworkProtocols, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetNetworkProtocols * SOAP_FMAC4 soap_in___tds__SetNetworkProtocols(struct soap *soap, const char *tag, struct __tds__SetNetworkProtocols *a, const char *type)
{
	size_t soap_flag_tds__SetNetworkProtocols = 1;
	short soap_flag;
	a = (struct __tds__SetNetworkProtocols *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetNetworkProtocols, sizeof(struct __tds__SetNetworkProtocols), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetNetworkProtocols(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetNetworkProtocols && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetNetworkProtocols(soap, "tds:SetNetworkProtocols", &a->tds__SetNetworkProtocols, ""))
				{	soap_flag_tds__SetNetworkProtocols--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetNetworkProtocols(struct soap *soap, const struct __tds__SetNetworkProtocols *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetNetworkProtocols(soap, tag?tag:"-tds:SetNetworkProtocols", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetNetworkProtocols * SOAP_FMAC4 soap_get___tds__SetNetworkProtocols(struct soap *soap, struct __tds__SetNetworkProtocols *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetNetworkProtocols(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetNetworkProtocols(struct soap *soap, struct __tds__GetNetworkProtocols *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetNetworkProtocols = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetNetworkProtocols(struct soap *soap, const struct __tds__GetNetworkProtocols *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetNetworkProtocols(soap, &a->tds__GetNetworkProtocols);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetNetworkProtocols(struct soap *soap, const char *tag, int id, const struct __tds__GetNetworkProtocols *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetNetworkProtocols(soap, "tds:GetNetworkProtocols", -1, &a->tds__GetNetworkProtocols, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetNetworkProtocols * SOAP_FMAC4 soap_in___tds__GetNetworkProtocols(struct soap *soap, const char *tag, struct __tds__GetNetworkProtocols *a, const char *type)
{
	size_t soap_flag_tds__GetNetworkProtocols = 1;
	short soap_flag;
	a = (struct __tds__GetNetworkProtocols *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetNetworkProtocols, sizeof(struct __tds__GetNetworkProtocols), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetNetworkProtocols(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetNetworkProtocols && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetNetworkProtocols(soap, "tds:GetNetworkProtocols", &a->tds__GetNetworkProtocols, ""))
				{	soap_flag_tds__GetNetworkProtocols--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetNetworkProtocols(struct soap *soap, const struct __tds__GetNetworkProtocols *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetNetworkProtocols(soap, tag?tag:"-tds:GetNetworkProtocols", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetNetworkProtocols * SOAP_FMAC4 soap_get___tds__GetNetworkProtocols(struct soap *soap, struct __tds__GetNetworkProtocols *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetNetworkProtocols(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetNetworkInterfaces(struct soap *soap, struct __tds__SetNetworkInterfaces *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetNetworkInterfaces = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetNetworkInterfaces(struct soap *soap, const struct __tds__SetNetworkInterfaces *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetNetworkInterfaces(soap, &a->tds__SetNetworkInterfaces);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetNetworkInterfaces(struct soap *soap, const char *tag, int id, const struct __tds__SetNetworkInterfaces *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetNetworkInterfaces(soap, "tds:SetNetworkInterfaces", -1, &a->tds__SetNetworkInterfaces, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetNetworkInterfaces * SOAP_FMAC4 soap_in___tds__SetNetworkInterfaces(struct soap *soap, const char *tag, struct __tds__SetNetworkInterfaces *a, const char *type)
{
	size_t soap_flag_tds__SetNetworkInterfaces = 1;
	short soap_flag;
	a = (struct __tds__SetNetworkInterfaces *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetNetworkInterfaces, sizeof(struct __tds__SetNetworkInterfaces), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetNetworkInterfaces(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetNetworkInterfaces && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetNetworkInterfaces(soap, "tds:SetNetworkInterfaces", &a->tds__SetNetworkInterfaces, ""))
				{	soap_flag_tds__SetNetworkInterfaces--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetNetworkInterfaces(struct soap *soap, const struct __tds__SetNetworkInterfaces *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetNetworkInterfaces(soap, tag?tag:"-tds:SetNetworkInterfaces", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetNetworkInterfaces * SOAP_FMAC4 soap_get___tds__SetNetworkInterfaces(struct soap *soap, struct __tds__SetNetworkInterfaces *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetNetworkInterfaces(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetNetworkInterfaces(struct soap *soap, struct __tds__GetNetworkInterfaces *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetNetworkInterfaces = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetNetworkInterfaces(struct soap *soap, const struct __tds__GetNetworkInterfaces *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetNetworkInterfaces(soap, &a->tds__GetNetworkInterfaces);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetNetworkInterfaces(struct soap *soap, const char *tag, int id, const struct __tds__GetNetworkInterfaces *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetNetworkInterfaces(soap, "tds:GetNetworkInterfaces", -1, &a->tds__GetNetworkInterfaces, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetNetworkInterfaces * SOAP_FMAC4 soap_in___tds__GetNetworkInterfaces(struct soap *soap, const char *tag, struct __tds__GetNetworkInterfaces *a, const char *type)
{
	size_t soap_flag_tds__GetNetworkInterfaces = 1;
	short soap_flag;
	a = (struct __tds__GetNetworkInterfaces *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetNetworkInterfaces, sizeof(struct __tds__GetNetworkInterfaces), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetNetworkInterfaces(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetNetworkInterfaces && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetNetworkInterfaces(soap, "tds:GetNetworkInterfaces", &a->tds__GetNetworkInterfaces, ""))
				{	soap_flag_tds__GetNetworkInterfaces--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetNetworkInterfaces(struct soap *soap, const struct __tds__GetNetworkInterfaces *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetNetworkInterfaces(soap, tag?tag:"-tds:GetNetworkInterfaces", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetNetworkInterfaces * SOAP_FMAC4 soap_get___tds__GetNetworkInterfaces(struct soap *soap, struct __tds__GetNetworkInterfaces *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetNetworkInterfaces(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetDynamicDNS(struct soap *soap, struct __tds__SetDynamicDNS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetDynamicDNS = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetDynamicDNS(struct soap *soap, const struct __tds__SetDynamicDNS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetDynamicDNS(soap, &a->tds__SetDynamicDNS);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetDynamicDNS(struct soap *soap, const char *tag, int id, const struct __tds__SetDynamicDNS *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetDynamicDNS(soap, "tds:SetDynamicDNS", -1, &a->tds__SetDynamicDNS, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetDynamicDNS * SOAP_FMAC4 soap_in___tds__SetDynamicDNS(struct soap *soap, const char *tag, struct __tds__SetDynamicDNS *a, const char *type)
{
	size_t soap_flag_tds__SetDynamicDNS = 1;
	short soap_flag;
	a = (struct __tds__SetDynamicDNS *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetDynamicDNS, sizeof(struct __tds__SetDynamicDNS), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetDynamicDNS(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetDynamicDNS && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetDynamicDNS(soap, "tds:SetDynamicDNS", &a->tds__SetDynamicDNS, ""))
				{	soap_flag_tds__SetDynamicDNS--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetDynamicDNS(struct soap *soap, const struct __tds__SetDynamicDNS *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetDynamicDNS(soap, tag?tag:"-tds:SetDynamicDNS", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetDynamicDNS * SOAP_FMAC4 soap_get___tds__SetDynamicDNS(struct soap *soap, struct __tds__SetDynamicDNS *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetDynamicDNS(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetDynamicDNS(struct soap *soap, struct __tds__GetDynamicDNS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetDynamicDNS = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetDynamicDNS(struct soap *soap, const struct __tds__GetDynamicDNS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetDynamicDNS(soap, &a->tds__GetDynamicDNS);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetDynamicDNS(struct soap *soap, const char *tag, int id, const struct __tds__GetDynamicDNS *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetDynamicDNS(soap, "tds:GetDynamicDNS", -1, &a->tds__GetDynamicDNS, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetDynamicDNS * SOAP_FMAC4 soap_in___tds__GetDynamicDNS(struct soap *soap, const char *tag, struct __tds__GetDynamicDNS *a, const char *type)
{
	size_t soap_flag_tds__GetDynamicDNS = 1;
	short soap_flag;
	a = (struct __tds__GetDynamicDNS *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetDynamicDNS, sizeof(struct __tds__GetDynamicDNS), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetDynamicDNS(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetDynamicDNS && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetDynamicDNS(soap, "tds:GetDynamicDNS", &a->tds__GetDynamicDNS, ""))
				{	soap_flag_tds__GetDynamicDNS--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetDynamicDNS(struct soap *soap, const struct __tds__GetDynamicDNS *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetDynamicDNS(soap, tag?tag:"-tds:GetDynamicDNS", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetDynamicDNS * SOAP_FMAC4 soap_get___tds__GetDynamicDNS(struct soap *soap, struct __tds__GetDynamicDNS *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetDynamicDNS(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetNTP(struct soap *soap, struct __tds__SetNTP *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetNTP = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetNTP(struct soap *soap, const struct __tds__SetNTP *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetNTP(soap, &a->tds__SetNTP);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetNTP(struct soap *soap, const char *tag, int id, const struct __tds__SetNTP *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetNTP(soap, "tds:SetNTP", -1, &a->tds__SetNTP, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetNTP * SOAP_FMAC4 soap_in___tds__SetNTP(struct soap *soap, const char *tag, struct __tds__SetNTP *a, const char *type)
{
	size_t soap_flag_tds__SetNTP = 1;
	short soap_flag;
	a = (struct __tds__SetNTP *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetNTP, sizeof(struct __tds__SetNTP), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetNTP(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetNTP && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetNTP(soap, "tds:SetNTP", &a->tds__SetNTP, ""))
				{	soap_flag_tds__SetNTP--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetNTP(struct soap *soap, const struct __tds__SetNTP *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetNTP(soap, tag?tag:"-tds:SetNTP", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetNTP * SOAP_FMAC4 soap_get___tds__SetNTP(struct soap *soap, struct __tds__SetNTP *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetNTP(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetNTP(struct soap *soap, struct __tds__GetNTP *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetNTP = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetNTP(struct soap *soap, const struct __tds__GetNTP *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetNTP(soap, &a->tds__GetNTP);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetNTP(struct soap *soap, const char *tag, int id, const struct __tds__GetNTP *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetNTP(soap, "tds:GetNTP", -1, &a->tds__GetNTP, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetNTP * SOAP_FMAC4 soap_in___tds__GetNTP(struct soap *soap, const char *tag, struct __tds__GetNTP *a, const char *type)
{
	size_t soap_flag_tds__GetNTP = 1;
	short soap_flag;
	a = (struct __tds__GetNTP *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetNTP, sizeof(struct __tds__GetNTP), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetNTP(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetNTP && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetNTP(soap, "tds:GetNTP", &a->tds__GetNTP, ""))
				{	soap_flag_tds__GetNTP--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetNTP(struct soap *soap, const struct __tds__GetNTP *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetNTP(soap, tag?tag:"-tds:GetNTP", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetNTP * SOAP_FMAC4 soap_get___tds__GetNTP(struct soap *soap, struct __tds__GetNTP *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetNTP(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetDNS(struct soap *soap, struct __tds__SetDNS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetDNS = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetDNS(struct soap *soap, const struct __tds__SetDNS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetDNS(soap, &a->tds__SetDNS);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetDNS(struct soap *soap, const char *tag, int id, const struct __tds__SetDNS *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetDNS(soap, "tds:SetDNS", -1, &a->tds__SetDNS, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetDNS * SOAP_FMAC4 soap_in___tds__SetDNS(struct soap *soap, const char *tag, struct __tds__SetDNS *a, const char *type)
{
	size_t soap_flag_tds__SetDNS = 1;
	short soap_flag;
	a = (struct __tds__SetDNS *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetDNS, sizeof(struct __tds__SetDNS), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetDNS(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetDNS && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetDNS(soap, "tds:SetDNS", &a->tds__SetDNS, ""))
				{	soap_flag_tds__SetDNS--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetDNS(struct soap *soap, const struct __tds__SetDNS *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetDNS(soap, tag?tag:"-tds:SetDNS", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetDNS * SOAP_FMAC4 soap_get___tds__SetDNS(struct soap *soap, struct __tds__SetDNS *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetDNS(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetDNS(struct soap *soap, struct __tds__GetDNS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetDNS = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetDNS(struct soap *soap, const struct __tds__GetDNS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetDNS(soap, &a->tds__GetDNS);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetDNS(struct soap *soap, const char *tag, int id, const struct __tds__GetDNS *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetDNS(soap, "tds:GetDNS", -1, &a->tds__GetDNS, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetDNS * SOAP_FMAC4 soap_in___tds__GetDNS(struct soap *soap, const char *tag, struct __tds__GetDNS *a, const char *type)
{
	size_t soap_flag_tds__GetDNS = 1;
	short soap_flag;
	a = (struct __tds__GetDNS *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetDNS, sizeof(struct __tds__GetDNS), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetDNS(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetDNS && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetDNS(soap, "tds:GetDNS", &a->tds__GetDNS, ""))
				{	soap_flag_tds__GetDNS--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetDNS(struct soap *soap, const struct __tds__GetDNS *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetDNS(soap, tag?tag:"-tds:GetDNS", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetDNS * SOAP_FMAC4 soap_get___tds__GetDNS(struct soap *soap, struct __tds__GetDNS *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetDNS(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetHostname(struct soap *soap, struct __tds__SetHostname *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetHostname = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetHostname(struct soap *soap, const struct __tds__SetHostname *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetHostname(soap, &a->tds__SetHostname);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetHostname(struct soap *soap, const char *tag, int id, const struct __tds__SetHostname *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetHostname(soap, "tds:SetHostname", -1, &a->tds__SetHostname, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetHostname * SOAP_FMAC4 soap_in___tds__SetHostname(struct soap *soap, const char *tag, struct __tds__SetHostname *a, const char *type)
{
	size_t soap_flag_tds__SetHostname = 1;
	short soap_flag;
	a = (struct __tds__SetHostname *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetHostname, sizeof(struct __tds__SetHostname), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetHostname(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetHostname && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetHostname(soap, "tds:SetHostname", &a->tds__SetHostname, ""))
				{	soap_flag_tds__SetHostname--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetHostname(struct soap *soap, const struct __tds__SetHostname *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetHostname(soap, tag?tag:"-tds:SetHostname", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetHostname * SOAP_FMAC4 soap_get___tds__SetHostname(struct soap *soap, struct __tds__SetHostname *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetHostname(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetHostname(struct soap *soap, struct __tds__GetHostname *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetHostname = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetHostname(struct soap *soap, const struct __tds__GetHostname *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetHostname(soap, &a->tds__GetHostname);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetHostname(struct soap *soap, const char *tag, int id, const struct __tds__GetHostname *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetHostname(soap, "tds:GetHostname", -1, &a->tds__GetHostname, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetHostname * SOAP_FMAC4 soap_in___tds__GetHostname(struct soap *soap, const char *tag, struct __tds__GetHostname *a, const char *type)
{
	size_t soap_flag_tds__GetHostname = 1;
	short soap_flag;
	a = (struct __tds__GetHostname *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetHostname, sizeof(struct __tds__GetHostname), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetHostname(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetHostname && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetHostname(soap, "tds:GetHostname", &a->tds__GetHostname, ""))
				{	soap_flag_tds__GetHostname--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetHostname(struct soap *soap, const struct __tds__GetHostname *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetHostname(soap, tag?tag:"-tds:GetHostname", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetHostname * SOAP_FMAC4 soap_get___tds__GetHostname(struct soap *soap, struct __tds__GetHostname *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetHostname(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetCapabilities(struct soap *soap, struct __tds__GetCapabilities *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetCapabilities = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetCapabilities(struct soap *soap, const struct __tds__GetCapabilities *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetCapabilities(soap, &a->tds__GetCapabilities);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetCapabilities(struct soap *soap, const char *tag, int id, const struct __tds__GetCapabilities *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetCapabilities(soap, "tds:GetCapabilities", -1, &a->tds__GetCapabilities, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetCapabilities * SOAP_FMAC4 soap_in___tds__GetCapabilities(struct soap *soap, const char *tag, struct __tds__GetCapabilities *a, const char *type)
{
	size_t soap_flag_tds__GetCapabilities = 1;
	short soap_flag;
	a = (struct __tds__GetCapabilities *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetCapabilities, sizeof(struct __tds__GetCapabilities), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetCapabilities(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetCapabilities && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetCapabilities(soap, "tds:GetCapabilities", &a->tds__GetCapabilities, ""))
				{	soap_flag_tds__GetCapabilities--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetCapabilities(struct soap *soap, const struct __tds__GetCapabilities *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetCapabilities(soap, tag?tag:"-tds:GetCapabilities", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetCapabilities * SOAP_FMAC4 soap_get___tds__GetCapabilities(struct soap *soap, struct __tds__GetCapabilities *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetCapabilities(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetWsdlUrl(struct soap *soap, struct __tds__GetWsdlUrl *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetWsdlUrl = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetWsdlUrl(struct soap *soap, const struct __tds__GetWsdlUrl *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetWsdlUrl(soap, &a->tds__GetWsdlUrl);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetWsdlUrl(struct soap *soap, const char *tag, int id, const struct __tds__GetWsdlUrl *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetWsdlUrl(soap, "tds:GetWsdlUrl", -1, &a->tds__GetWsdlUrl, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetWsdlUrl * SOAP_FMAC4 soap_in___tds__GetWsdlUrl(struct soap *soap, const char *tag, struct __tds__GetWsdlUrl *a, const char *type)
{
	size_t soap_flag_tds__GetWsdlUrl = 1;
	short soap_flag;
	a = (struct __tds__GetWsdlUrl *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetWsdlUrl, sizeof(struct __tds__GetWsdlUrl), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetWsdlUrl(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetWsdlUrl && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetWsdlUrl(soap, "tds:GetWsdlUrl", &a->tds__GetWsdlUrl, ""))
				{	soap_flag_tds__GetWsdlUrl--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetWsdlUrl(struct soap *soap, const struct __tds__GetWsdlUrl *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetWsdlUrl(soap, tag?tag:"-tds:GetWsdlUrl", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetWsdlUrl * SOAP_FMAC4 soap_get___tds__GetWsdlUrl(struct soap *soap, struct __tds__GetWsdlUrl *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetWsdlUrl(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetUser(struct soap *soap, struct __tds__SetUser *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetUser = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetUser(struct soap *soap, const struct __tds__SetUser *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetUser(soap, &a->tds__SetUser);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetUser(struct soap *soap, const char *tag, int id, const struct __tds__SetUser *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetUser(soap, "tds:SetUser", -1, &a->tds__SetUser, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetUser * SOAP_FMAC4 soap_in___tds__SetUser(struct soap *soap, const char *tag, struct __tds__SetUser *a, const char *type)
{
	size_t soap_flag_tds__SetUser = 1;
	short soap_flag;
	a = (struct __tds__SetUser *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetUser, sizeof(struct __tds__SetUser), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetUser(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetUser && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetUser(soap, "tds:SetUser", &a->tds__SetUser, ""))
				{	soap_flag_tds__SetUser--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetUser(struct soap *soap, const struct __tds__SetUser *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetUser(soap, tag?tag:"-tds:SetUser", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetUser * SOAP_FMAC4 soap_get___tds__SetUser(struct soap *soap, struct __tds__SetUser *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetUser(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__DeleteUsers(struct soap *soap, struct __tds__DeleteUsers *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__DeleteUsers = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__DeleteUsers(struct soap *soap, const struct __tds__DeleteUsers *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__DeleteUsers(soap, &a->tds__DeleteUsers);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__DeleteUsers(struct soap *soap, const char *tag, int id, const struct __tds__DeleteUsers *a, const char *type)
{
	if (soap_out_PointerTo_tds__DeleteUsers(soap, "tds:DeleteUsers", -1, &a->tds__DeleteUsers, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__DeleteUsers * SOAP_FMAC4 soap_in___tds__DeleteUsers(struct soap *soap, const char *tag, struct __tds__DeleteUsers *a, const char *type)
{
	size_t soap_flag_tds__DeleteUsers = 1;
	short soap_flag;
	a = (struct __tds__DeleteUsers *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__DeleteUsers, sizeof(struct __tds__DeleteUsers), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__DeleteUsers(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__DeleteUsers && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__DeleteUsers(soap, "tds:DeleteUsers", &a->tds__DeleteUsers, ""))
				{	soap_flag_tds__DeleteUsers--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__DeleteUsers(struct soap *soap, const struct __tds__DeleteUsers *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__DeleteUsers(soap, tag?tag:"-tds:DeleteUsers", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__DeleteUsers * SOAP_FMAC4 soap_get___tds__DeleteUsers(struct soap *soap, struct __tds__DeleteUsers *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__DeleteUsers(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__CreateUsers(struct soap *soap, struct __tds__CreateUsers *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__CreateUsers = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__CreateUsers(struct soap *soap, const struct __tds__CreateUsers *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__CreateUsers(soap, &a->tds__CreateUsers);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__CreateUsers(struct soap *soap, const char *tag, int id, const struct __tds__CreateUsers *a, const char *type)
{
	if (soap_out_PointerTo_tds__CreateUsers(soap, "tds:CreateUsers", -1, &a->tds__CreateUsers, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__CreateUsers * SOAP_FMAC4 soap_in___tds__CreateUsers(struct soap *soap, const char *tag, struct __tds__CreateUsers *a, const char *type)
{
	size_t soap_flag_tds__CreateUsers = 1;
	short soap_flag;
	a = (struct __tds__CreateUsers *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__CreateUsers, sizeof(struct __tds__CreateUsers), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__CreateUsers(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__CreateUsers && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__CreateUsers(soap, "tds:CreateUsers", &a->tds__CreateUsers, ""))
				{	soap_flag_tds__CreateUsers--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__CreateUsers(struct soap *soap, const struct __tds__CreateUsers *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__CreateUsers(soap, tag?tag:"-tds:CreateUsers", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__CreateUsers * SOAP_FMAC4 soap_get___tds__CreateUsers(struct soap *soap, struct __tds__CreateUsers *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__CreateUsers(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetUsers(struct soap *soap, struct __tds__GetUsers *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetUsers = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetUsers(struct soap *soap, const struct __tds__GetUsers *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetUsers(soap, &a->tds__GetUsers);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetUsers(struct soap *soap, const char *tag, int id, const struct __tds__GetUsers *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetUsers(soap, "tds:GetUsers", -1, &a->tds__GetUsers, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetUsers * SOAP_FMAC4 soap_in___tds__GetUsers(struct soap *soap, const char *tag, struct __tds__GetUsers *a, const char *type)
{
	size_t soap_flag_tds__GetUsers = 1;
	short soap_flag;
	a = (struct __tds__GetUsers *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetUsers, sizeof(struct __tds__GetUsers), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetUsers(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetUsers && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetUsers(soap, "tds:GetUsers", &a->tds__GetUsers, ""))
				{	soap_flag_tds__GetUsers--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetUsers(struct soap *soap, const struct __tds__GetUsers *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetUsers(soap, tag?tag:"-tds:GetUsers", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetUsers * SOAP_FMAC4 soap_get___tds__GetUsers(struct soap *soap, struct __tds__GetUsers *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetUsers(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetDiscoveryMode(struct soap *soap, struct __tds__SetDiscoveryMode *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetDiscoveryMode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetDiscoveryMode(struct soap *soap, const struct __tds__SetDiscoveryMode *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetDiscoveryMode(soap, &a->tds__SetDiscoveryMode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetDiscoveryMode(struct soap *soap, const char *tag, int id, const struct __tds__SetDiscoveryMode *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetDiscoveryMode(soap, "tds:SetDiscoveryMode", -1, &a->tds__SetDiscoveryMode, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetDiscoveryMode * SOAP_FMAC4 soap_in___tds__SetDiscoveryMode(struct soap *soap, const char *tag, struct __tds__SetDiscoveryMode *a, const char *type)
{
	size_t soap_flag_tds__SetDiscoveryMode = 1;
	short soap_flag;
	a = (struct __tds__SetDiscoveryMode *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetDiscoveryMode, sizeof(struct __tds__SetDiscoveryMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetDiscoveryMode(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetDiscoveryMode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetDiscoveryMode(soap, "tds:SetDiscoveryMode", &a->tds__SetDiscoveryMode, ""))
				{	soap_flag_tds__SetDiscoveryMode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetDiscoveryMode(struct soap *soap, const struct __tds__SetDiscoveryMode *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetDiscoveryMode(soap, tag?tag:"-tds:SetDiscoveryMode", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetDiscoveryMode * SOAP_FMAC4 soap_get___tds__SetDiscoveryMode(struct soap *soap, struct __tds__SetDiscoveryMode *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetDiscoveryMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetDiscoveryMode(struct soap *soap, struct __tds__GetDiscoveryMode *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetDiscoveryMode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetDiscoveryMode(struct soap *soap, const struct __tds__GetDiscoveryMode *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetDiscoveryMode(soap, &a->tds__GetDiscoveryMode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetDiscoveryMode(struct soap *soap, const char *tag, int id, const struct __tds__GetDiscoveryMode *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetDiscoveryMode(soap, "tds:GetDiscoveryMode", -1, &a->tds__GetDiscoveryMode, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetDiscoveryMode * SOAP_FMAC4 soap_in___tds__GetDiscoveryMode(struct soap *soap, const char *tag, struct __tds__GetDiscoveryMode *a, const char *type)
{
	size_t soap_flag_tds__GetDiscoveryMode = 1;
	short soap_flag;
	a = (struct __tds__GetDiscoveryMode *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetDiscoveryMode, sizeof(struct __tds__GetDiscoveryMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetDiscoveryMode(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetDiscoveryMode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetDiscoveryMode(soap, "tds:GetDiscoveryMode", &a->tds__GetDiscoveryMode, ""))
				{	soap_flag_tds__GetDiscoveryMode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetDiscoveryMode(struct soap *soap, const struct __tds__GetDiscoveryMode *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetDiscoveryMode(soap, tag?tag:"-tds:GetDiscoveryMode", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetDiscoveryMode * SOAP_FMAC4 soap_get___tds__GetDiscoveryMode(struct soap *soap, struct __tds__GetDiscoveryMode *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetDiscoveryMode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__RemoveScopes(struct soap *soap, struct __tds__RemoveScopes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__RemoveScopes = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__RemoveScopes(struct soap *soap, const struct __tds__RemoveScopes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__RemoveScopes(soap, &a->tds__RemoveScopes);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__RemoveScopes(struct soap *soap, const char *tag, int id, const struct __tds__RemoveScopes *a, const char *type)
{
	if (soap_out_PointerTo_tds__RemoveScopes(soap, "tds:RemoveScopes", -1, &a->tds__RemoveScopes, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__RemoveScopes * SOAP_FMAC4 soap_in___tds__RemoveScopes(struct soap *soap, const char *tag, struct __tds__RemoveScopes *a, const char *type)
{
	size_t soap_flag_tds__RemoveScopes = 1;
	short soap_flag;
	a = (struct __tds__RemoveScopes *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__RemoveScopes, sizeof(struct __tds__RemoveScopes), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__RemoveScopes(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__RemoveScopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__RemoveScopes(soap, "tds:RemoveScopes", &a->tds__RemoveScopes, ""))
				{	soap_flag_tds__RemoveScopes--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__RemoveScopes(struct soap *soap, const struct __tds__RemoveScopes *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__RemoveScopes(soap, tag?tag:"-tds:RemoveScopes", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__RemoveScopes * SOAP_FMAC4 soap_get___tds__RemoveScopes(struct soap *soap, struct __tds__RemoveScopes *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__RemoveScopes(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__AddScopes(struct soap *soap, struct __tds__AddScopes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__AddScopes = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__AddScopes(struct soap *soap, const struct __tds__AddScopes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__AddScopes(soap, &a->tds__AddScopes);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__AddScopes(struct soap *soap, const char *tag, int id, const struct __tds__AddScopes *a, const char *type)
{
	if (soap_out_PointerTo_tds__AddScopes(soap, "tds:AddScopes", -1, &a->tds__AddScopes, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__AddScopes * SOAP_FMAC4 soap_in___tds__AddScopes(struct soap *soap, const char *tag, struct __tds__AddScopes *a, const char *type)
{
	size_t soap_flag_tds__AddScopes = 1;
	short soap_flag;
	a = (struct __tds__AddScopes *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__AddScopes, sizeof(struct __tds__AddScopes), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__AddScopes(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__AddScopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__AddScopes(soap, "tds:AddScopes", &a->tds__AddScopes, ""))
				{	soap_flag_tds__AddScopes--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__AddScopes(struct soap *soap, const struct __tds__AddScopes *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__AddScopes(soap, tag?tag:"-tds:AddScopes", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__AddScopes * SOAP_FMAC4 soap_get___tds__AddScopes(struct soap *soap, struct __tds__AddScopes *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__AddScopes(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetScopes(struct soap *soap, struct __tds__SetScopes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetScopes = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetScopes(struct soap *soap, const struct __tds__SetScopes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetScopes(soap, &a->tds__SetScopes);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetScopes(struct soap *soap, const char *tag, int id, const struct __tds__SetScopes *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetScopes(soap, "tds:SetScopes", -1, &a->tds__SetScopes, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetScopes * SOAP_FMAC4 soap_in___tds__SetScopes(struct soap *soap, const char *tag, struct __tds__SetScopes *a, const char *type)
{
	size_t soap_flag_tds__SetScopes = 1;
	short soap_flag;
	a = (struct __tds__SetScopes *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetScopes, sizeof(struct __tds__SetScopes), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetScopes(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetScopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetScopes(soap, "tds:SetScopes", &a->tds__SetScopes, ""))
				{	soap_flag_tds__SetScopes--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetScopes(struct soap *soap, const struct __tds__SetScopes *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetScopes(soap, tag?tag:"-tds:SetScopes", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetScopes * SOAP_FMAC4 soap_get___tds__SetScopes(struct soap *soap, struct __tds__SetScopes *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetScopes(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetScopes(struct soap *soap, struct __tds__GetScopes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetScopes = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetScopes(struct soap *soap, const struct __tds__GetScopes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetScopes(soap, &a->tds__GetScopes);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetScopes(struct soap *soap, const char *tag, int id, const struct __tds__GetScopes *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetScopes(soap, "tds:GetScopes", -1, &a->tds__GetScopes, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetScopes * SOAP_FMAC4 soap_in___tds__GetScopes(struct soap *soap, const char *tag, struct __tds__GetScopes *a, const char *type)
{
	size_t soap_flag_tds__GetScopes = 1;
	short soap_flag;
	a = (struct __tds__GetScopes *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetScopes, sizeof(struct __tds__GetScopes), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetScopes(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetScopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetScopes(soap, "tds:GetScopes", &a->tds__GetScopes, ""))
				{	soap_flag_tds__GetScopes--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetScopes(struct soap *soap, const struct __tds__GetScopes *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetScopes(soap, tag?tag:"-tds:GetScopes", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetScopes * SOAP_FMAC4 soap_get___tds__GetScopes(struct soap *soap, struct __tds__GetScopes *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetScopes(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetSystemLog(struct soap *soap, struct __tds__GetSystemLog *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetSystemLog = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetSystemLog(struct soap *soap, const struct __tds__GetSystemLog *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetSystemLog(soap, &a->tds__GetSystemLog);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetSystemLog(struct soap *soap, const char *tag, int id, const struct __tds__GetSystemLog *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetSystemLog(soap, "tds:GetSystemLog", -1, &a->tds__GetSystemLog, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetSystemLog * SOAP_FMAC4 soap_in___tds__GetSystemLog(struct soap *soap, const char *tag, struct __tds__GetSystemLog *a, const char *type)
{
	size_t soap_flag_tds__GetSystemLog = 1;
	short soap_flag;
	a = (struct __tds__GetSystemLog *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetSystemLog, sizeof(struct __tds__GetSystemLog), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetSystemLog(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetSystemLog && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetSystemLog(soap, "tds:GetSystemLog", &a->tds__GetSystemLog, ""))
				{	soap_flag_tds__GetSystemLog--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetSystemLog(struct soap *soap, const struct __tds__GetSystemLog *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetSystemLog(soap, tag?tag:"-tds:GetSystemLog", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetSystemLog * SOAP_FMAC4 soap_get___tds__GetSystemLog(struct soap *soap, struct __tds__GetSystemLog *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetSystemLog(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SystemReboot(struct soap *soap, struct __tds__SystemReboot *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SystemReboot = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SystemReboot(struct soap *soap, const struct __tds__SystemReboot *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SystemReboot(soap, &a->tds__SystemReboot);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SystemReboot(struct soap *soap, const char *tag, int id, const struct __tds__SystemReboot *a, const char *type)
{
	if (soap_out_PointerTo_tds__SystemReboot(soap, "tds:SystemReboot", -1, &a->tds__SystemReboot, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SystemReboot * SOAP_FMAC4 soap_in___tds__SystemReboot(struct soap *soap, const char *tag, struct __tds__SystemReboot *a, const char *type)
{
	size_t soap_flag_tds__SystemReboot = 1;
	short soap_flag;
	a = (struct __tds__SystemReboot *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SystemReboot, sizeof(struct __tds__SystemReboot), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SystemReboot(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SystemReboot && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SystemReboot(soap, "tds:SystemReboot", &a->tds__SystemReboot, ""))
				{	soap_flag_tds__SystemReboot--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SystemReboot(struct soap *soap, const struct __tds__SystemReboot *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SystemReboot(soap, tag?tag:"-tds:SystemReboot", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SystemReboot * SOAP_FMAC4 soap_get___tds__SystemReboot(struct soap *soap, struct __tds__SystemReboot *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SystemReboot(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetSystemFactoryDefault(struct soap *soap, struct __tds__SetSystemFactoryDefault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetSystemFactoryDefault = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetSystemFactoryDefault(struct soap *soap, const struct __tds__SetSystemFactoryDefault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetSystemFactoryDefault(soap, &a->tds__SetSystemFactoryDefault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetSystemFactoryDefault(struct soap *soap, const char *tag, int id, const struct __tds__SetSystemFactoryDefault *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetSystemFactoryDefault(soap, "tds:SetSystemFactoryDefault", -1, &a->tds__SetSystemFactoryDefault, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetSystemFactoryDefault * SOAP_FMAC4 soap_in___tds__SetSystemFactoryDefault(struct soap *soap, const char *tag, struct __tds__SetSystemFactoryDefault *a, const char *type)
{
	size_t soap_flag_tds__SetSystemFactoryDefault = 1;
	short soap_flag;
	a = (struct __tds__SetSystemFactoryDefault *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetSystemFactoryDefault, sizeof(struct __tds__SetSystemFactoryDefault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetSystemFactoryDefault(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetSystemFactoryDefault && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetSystemFactoryDefault(soap, "tds:SetSystemFactoryDefault", &a->tds__SetSystemFactoryDefault, ""))
				{	soap_flag_tds__SetSystemFactoryDefault--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetSystemFactoryDefault(struct soap *soap, const struct __tds__SetSystemFactoryDefault *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetSystemFactoryDefault(soap, tag?tag:"-tds:SetSystemFactoryDefault", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetSystemFactoryDefault * SOAP_FMAC4 soap_get___tds__SetSystemFactoryDefault(struct soap *soap, struct __tds__SetSystemFactoryDefault *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetSystemFactoryDefault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetSystemDateAndTime(struct soap *soap, struct __tds__GetSystemDateAndTime *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetSystemDateAndTime = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetSystemDateAndTime(struct soap *soap, const struct __tds__GetSystemDateAndTime *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetSystemDateAndTime(soap, &a->tds__GetSystemDateAndTime);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetSystemDateAndTime(struct soap *soap, const char *tag, int id, const struct __tds__GetSystemDateAndTime *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetSystemDateAndTime(soap, "tds:GetSystemDateAndTime", -1, &a->tds__GetSystemDateAndTime, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetSystemDateAndTime * SOAP_FMAC4 soap_in___tds__GetSystemDateAndTime(struct soap *soap, const char *tag, struct __tds__GetSystemDateAndTime *a, const char *type)
{
	size_t soap_flag_tds__GetSystemDateAndTime = 1;
	short soap_flag;
	a = (struct __tds__GetSystemDateAndTime *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetSystemDateAndTime, sizeof(struct __tds__GetSystemDateAndTime), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetSystemDateAndTime(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetSystemDateAndTime && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetSystemDateAndTime(soap, "tds:GetSystemDateAndTime", &a->tds__GetSystemDateAndTime, ""))
				{	soap_flag_tds__GetSystemDateAndTime--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetSystemDateAndTime(struct soap *soap, const struct __tds__GetSystemDateAndTime *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetSystemDateAndTime(soap, tag?tag:"-tds:GetSystemDateAndTime", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetSystemDateAndTime * SOAP_FMAC4 soap_get___tds__GetSystemDateAndTime(struct soap *soap, struct __tds__GetSystemDateAndTime *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetSystemDateAndTime(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__SetSystemDateAndTime(struct soap *soap, struct __tds__SetSystemDateAndTime *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__SetSystemDateAndTime = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__SetSystemDateAndTime(struct soap *soap, const struct __tds__SetSystemDateAndTime *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__SetSystemDateAndTime(soap, &a->tds__SetSystemDateAndTime);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__SetSystemDateAndTime(struct soap *soap, const char *tag, int id, const struct __tds__SetSystemDateAndTime *a, const char *type)
{
	if (soap_out_PointerTo_tds__SetSystemDateAndTime(soap, "tds:SetSystemDateAndTime", -1, &a->tds__SetSystemDateAndTime, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetSystemDateAndTime * SOAP_FMAC4 soap_in___tds__SetSystemDateAndTime(struct soap *soap, const char *tag, struct __tds__SetSystemDateAndTime *a, const char *type)
{
	size_t soap_flag_tds__SetSystemDateAndTime = 1;
	short soap_flag;
	a = (struct __tds__SetSystemDateAndTime *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__SetSystemDateAndTime, sizeof(struct __tds__SetSystemDateAndTime), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__SetSystemDateAndTime(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__SetSystemDateAndTime && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__SetSystemDateAndTime(soap, "tds:SetSystemDateAndTime", &a->tds__SetSystemDateAndTime, ""))
				{	soap_flag_tds__SetSystemDateAndTime--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__SetSystemDateAndTime(struct soap *soap, const struct __tds__SetSystemDateAndTime *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__SetSystemDateAndTime(soap, tag?tag:"-tds:SetSystemDateAndTime", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__SetSystemDateAndTime * SOAP_FMAC4 soap_get___tds__SetSystemDateAndTime(struct soap *soap, struct __tds__SetSystemDateAndTime *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__SetSystemDateAndTime(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tds__GetDeviceInformation(struct soap *soap, struct __tds__GetDeviceInformation *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tds__GetDeviceInformation = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tds__GetDeviceInformation(struct soap *soap, const struct __tds__GetDeviceInformation *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tds__GetDeviceInformation(soap, &a->tds__GetDeviceInformation);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tds__GetDeviceInformation(struct soap *soap, const char *tag, int id, const struct __tds__GetDeviceInformation *a, const char *type)
{
	if (soap_out_PointerTo_tds__GetDeviceInformation(soap, "tds:GetDeviceInformation", -1, &a->tds__GetDeviceInformation, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetDeviceInformation * SOAP_FMAC4 soap_in___tds__GetDeviceInformation(struct soap *soap, const char *tag, struct __tds__GetDeviceInformation *a, const char *type)
{
	size_t soap_flag_tds__GetDeviceInformation = 1;
	short soap_flag;
	a = (struct __tds__GetDeviceInformation *)soap_id_enter(soap, "", a, SOAP_TYPE___tds__GetDeviceInformation, sizeof(struct __tds__GetDeviceInformation), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tds__GetDeviceInformation(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tds__GetDeviceInformation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tds__GetDeviceInformation(soap, "tds:GetDeviceInformation", &a->tds__GetDeviceInformation, ""))
				{	soap_flag_tds__GetDeviceInformation--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tds__GetDeviceInformation(struct soap *soap, const struct __tds__GetDeviceInformation *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tds__GetDeviceInformation(soap, tag?tag:"-tds:GetDeviceInformation", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tds__GetDeviceInformation * SOAP_FMAC4 soap_get___tds__GetDeviceInformation(struct soap *soap, struct __tds__GetDeviceInformation *p, const char *tag, const char *type)
{
	if ((p = soap_in___tds__GetDeviceInformation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns7__Notify(struct soap *soap, struct __ns7__Notify *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsnt__Notify = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns7__Notify(struct soap *soap, const struct __ns7__Notify *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_wsnt__Notify(soap, &a->wsnt__Notify);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns7__Notify(struct soap *soap, const char *tag, int id, const struct __ns7__Notify *a, const char *type)
{
	if (soap_out_PointerTo_wsnt__Notify(soap, "wsnt:Notify", -1, &a->wsnt__Notify, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns7__Notify * SOAP_FMAC4 soap_in___ns7__Notify(struct soap *soap, const char *tag, struct __ns7__Notify *a, const char *type)
{
	size_t soap_flag_wsnt__Notify = 1;
	short soap_flag;
	a = (struct __ns7__Notify *)soap_id_enter(soap, "", a, SOAP_TYPE___ns7__Notify, sizeof(struct __ns7__Notify), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns7__Notify(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsnt__Notify && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsnt__Notify(soap, "wsnt:Notify", &a->wsnt__Notify, ""))
				{	soap_flag_wsnt__Notify--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns7__Notify(struct soap *soap, const struct __ns7__Notify *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns7__Notify(soap, tag?tag:"-ns7:Notify", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns7__Notify * SOAP_FMAC4 soap_get___ns7__Notify(struct soap *soap, struct __ns7__Notify *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns7__Notify(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns6__Subscribe(struct soap *soap, struct __ns6__Subscribe *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsnt__Subscribe = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns6__Subscribe(struct soap *soap, const struct __ns6__Subscribe *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_wsnt__Subscribe(soap, &a->wsnt__Subscribe);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns6__Subscribe(struct soap *soap, const char *tag, int id, const struct __ns6__Subscribe *a, const char *type)
{
	if (soap_out_PointerTo_wsnt__Subscribe(soap, "wsnt:Subscribe", -1, &a->wsnt__Subscribe, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns6__Subscribe * SOAP_FMAC4 soap_in___ns6__Subscribe(struct soap *soap, const char *tag, struct __ns6__Subscribe *a, const char *type)
{
	size_t soap_flag_wsnt__Subscribe = 1;
	short soap_flag;
	a = (struct __ns6__Subscribe *)soap_id_enter(soap, "", a, SOAP_TYPE___ns6__Subscribe, sizeof(struct __ns6__Subscribe), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns6__Subscribe(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsnt__Subscribe && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsnt__Subscribe(soap, "wsnt:Subscribe", &a->wsnt__Subscribe, ""))
				{	soap_flag_wsnt__Subscribe--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns6__Subscribe(struct soap *soap, const struct __ns6__Subscribe *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns6__Subscribe(soap, tag?tag:"-ns6:Subscribe", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns6__Subscribe * SOAP_FMAC4 soap_get___ns6__Subscribe(struct soap *soap, struct __ns6__Subscribe *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns6__Subscribe(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns5__Unsubscribe(struct soap *soap, struct __ns5__Unsubscribe *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsnt__Unsubscribe = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns5__Unsubscribe(struct soap *soap, const struct __ns5__Unsubscribe *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_wsnt__Unsubscribe(soap, &a->wsnt__Unsubscribe);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns5__Unsubscribe(struct soap *soap, const char *tag, int id, const struct __ns5__Unsubscribe *a, const char *type)
{
	if (soap_out_PointerTo_wsnt__Unsubscribe(soap, "wsnt:Unsubscribe", -1, &a->wsnt__Unsubscribe, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__Unsubscribe * SOAP_FMAC4 soap_in___ns5__Unsubscribe(struct soap *soap, const char *tag, struct __ns5__Unsubscribe *a, const char *type)
{
	size_t soap_flag_wsnt__Unsubscribe = 1;
	short soap_flag;
	a = (struct __ns5__Unsubscribe *)soap_id_enter(soap, "", a, SOAP_TYPE___ns5__Unsubscribe, sizeof(struct __ns5__Unsubscribe), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns5__Unsubscribe(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsnt__Unsubscribe && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsnt__Unsubscribe(soap, "wsnt:Unsubscribe", &a->wsnt__Unsubscribe, ""))
				{	soap_flag_wsnt__Unsubscribe--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns5__Unsubscribe(struct soap *soap, const struct __ns5__Unsubscribe *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns5__Unsubscribe(soap, tag?tag:"-ns5:Unsubscribe", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__Unsubscribe * SOAP_FMAC4 soap_get___ns5__Unsubscribe(struct soap *soap, struct __ns5__Unsubscribe *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns5__Unsubscribe(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns5__Renew(struct soap *soap, struct __ns5__Renew *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsnt__Renew = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns5__Renew(struct soap *soap, const struct __ns5__Renew *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_wsnt__Renew(soap, &a->wsnt__Renew);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns5__Renew(struct soap *soap, const char *tag, int id, const struct __ns5__Renew *a, const char *type)
{
	if (soap_out_PointerTo_wsnt__Renew(soap, "wsnt:Renew", -1, &a->wsnt__Renew, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__Renew * SOAP_FMAC4 soap_in___ns5__Renew(struct soap *soap, const char *tag, struct __ns5__Renew *a, const char *type)
{
	size_t soap_flag_wsnt__Renew = 1;
	short soap_flag;
	a = (struct __ns5__Renew *)soap_id_enter(soap, "", a, SOAP_TYPE___ns5__Renew, sizeof(struct __ns5__Renew), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns5__Renew(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsnt__Renew && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsnt__Renew(soap, "wsnt:Renew", &a->wsnt__Renew, ""))
				{	soap_flag_wsnt__Renew--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns5__Renew(struct soap *soap, const struct __ns5__Renew *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns5__Renew(soap, tag?tag:"-ns5:Renew", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns5__Renew * SOAP_FMAC4 soap_get___ns5__Renew(struct soap *soap, struct __ns5__Renew *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns5__Renew(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns4__GetEventProperties(struct soap *soap, struct __ns4__GetEventProperties *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tev__GetEventProperties = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns4__GetEventProperties(struct soap *soap, const struct __ns4__GetEventProperties *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tev__GetEventProperties(soap, &a->tev__GetEventProperties);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns4__GetEventProperties(struct soap *soap, const char *tag, int id, const struct __ns4__GetEventProperties *a, const char *type)
{
	if (soap_out_PointerTo_tev__GetEventProperties(soap, "tev:GetEventProperties", -1, &a->tev__GetEventProperties, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__GetEventProperties * SOAP_FMAC4 soap_in___ns4__GetEventProperties(struct soap *soap, const char *tag, struct __ns4__GetEventProperties *a, const char *type)
{
	size_t soap_flag_tev__GetEventProperties = 1;
	short soap_flag;
	a = (struct __ns4__GetEventProperties *)soap_id_enter(soap, "", a, SOAP_TYPE___ns4__GetEventProperties, sizeof(struct __ns4__GetEventProperties), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns4__GetEventProperties(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tev__GetEventProperties && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tev__GetEventProperties(soap, "tev:GetEventProperties", &a->tev__GetEventProperties, ""))
				{	soap_flag_tev__GetEventProperties--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns4__GetEventProperties(struct soap *soap, const struct __ns4__GetEventProperties *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns4__GetEventProperties(soap, tag?tag:"-ns4:GetEventProperties", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__GetEventProperties * SOAP_FMAC4 soap_get___ns4__GetEventProperties(struct soap *soap, struct __ns4__GetEventProperties *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns4__GetEventProperties(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns4__CreatePullPointSubscription(struct soap *soap, struct __ns4__CreatePullPointSubscription *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tev__CreatePullPointSubscription = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns4__CreatePullPointSubscription(struct soap *soap, const struct __ns4__CreatePullPointSubscription *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tev__CreatePullPointSubscription(soap, &a->tev__CreatePullPointSubscription);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns4__CreatePullPointSubscription(struct soap *soap, const char *tag, int id, const struct __ns4__CreatePullPointSubscription *a, const char *type)
{
	if (soap_out_PointerTo_tev__CreatePullPointSubscription(soap, "tev:CreatePullPointSubscription", -1, &a->tev__CreatePullPointSubscription, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__CreatePullPointSubscription * SOAP_FMAC4 soap_in___ns4__CreatePullPointSubscription(struct soap *soap, const char *tag, struct __ns4__CreatePullPointSubscription *a, const char *type)
{
	size_t soap_flag_tev__CreatePullPointSubscription = 1;
	short soap_flag;
	a = (struct __ns4__CreatePullPointSubscription *)soap_id_enter(soap, "", a, SOAP_TYPE___ns4__CreatePullPointSubscription, sizeof(struct __ns4__CreatePullPointSubscription), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns4__CreatePullPointSubscription(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tev__CreatePullPointSubscription && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tev__CreatePullPointSubscription(soap, "tev:CreatePullPointSubscription", &a->tev__CreatePullPointSubscription, ""))
				{	soap_flag_tev__CreatePullPointSubscription--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns4__CreatePullPointSubscription(struct soap *soap, const struct __ns4__CreatePullPointSubscription *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns4__CreatePullPointSubscription(soap, tag?tag:"-ns4:CreatePullPointSubscription", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns4__CreatePullPointSubscription * SOAP_FMAC4 soap_get___ns4__CreatePullPointSubscription(struct soap *soap, struct __ns4__CreatePullPointSubscription *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns4__CreatePullPointSubscription(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns3__SetSynchronizationPoint(struct soap *soap, struct __ns3__SetSynchronizationPoint *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tev__SetSynchronizationPoint = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns3__SetSynchronizationPoint(struct soap *soap, const struct __ns3__SetSynchronizationPoint *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tev__SetSynchronizationPoint(soap, &a->tev__SetSynchronizationPoint);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns3__SetSynchronizationPoint(struct soap *soap, const char *tag, int id, const struct __ns3__SetSynchronizationPoint *a, const char *type)
{
	if (soap_out_PointerTo_tev__SetSynchronizationPoint(soap, "tev:SetSynchronizationPoint", -1, &a->tev__SetSynchronizationPoint, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns3__SetSynchronizationPoint * SOAP_FMAC4 soap_in___ns3__SetSynchronizationPoint(struct soap *soap, const char *tag, struct __ns3__SetSynchronizationPoint *a, const char *type)
{
	size_t soap_flag_tev__SetSynchronizationPoint = 1;
	short soap_flag;
	a = (struct __ns3__SetSynchronizationPoint *)soap_id_enter(soap, "", a, SOAP_TYPE___ns3__SetSynchronizationPoint, sizeof(struct __ns3__SetSynchronizationPoint), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns3__SetSynchronizationPoint(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tev__SetSynchronizationPoint && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tev__SetSynchronizationPoint(soap, "tev:SetSynchronizationPoint", &a->tev__SetSynchronizationPoint, ""))
				{	soap_flag_tev__SetSynchronizationPoint--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns3__SetSynchronizationPoint(struct soap *soap, const struct __ns3__SetSynchronizationPoint *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns3__SetSynchronizationPoint(soap, tag?tag:"-ns3:SetSynchronizationPoint", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns3__SetSynchronizationPoint * SOAP_FMAC4 soap_get___ns3__SetSynchronizationPoint(struct soap *soap, struct __ns3__SetSynchronizationPoint *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns3__SetSynchronizationPoint(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns3__PullMessages(struct soap *soap, struct __ns3__PullMessages *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tev__PullMessages = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns3__PullMessages(struct soap *soap, const struct __ns3__PullMessages *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tev__PullMessages(soap, &a->tev__PullMessages);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns3__PullMessages(struct soap *soap, const char *tag, int id, const struct __ns3__PullMessages *a, const char *type)
{
	if (soap_out_PointerTo_tev__PullMessages(soap, "tev:PullMessages", -1, &a->tev__PullMessages, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns3__PullMessages * SOAP_FMAC4 soap_in___ns3__PullMessages(struct soap *soap, const char *tag, struct __ns3__PullMessages *a, const char *type)
{
	size_t soap_flag_tev__PullMessages = 1;
	short soap_flag;
	a = (struct __ns3__PullMessages *)soap_id_enter(soap, "", a, SOAP_TYPE___ns3__PullMessages, sizeof(struct __ns3__PullMessages), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns3__PullMessages(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tev__PullMessages && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tev__PullMessages(soap, "tev:PullMessages", &a->tev__PullMessages, ""))
				{	soap_flag_tev__PullMessages--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns3__PullMessages(struct soap *soap, const struct __ns3__PullMessages *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns3__PullMessages(soap, tag?tag:"-ns3:PullMessages", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns3__PullMessages * SOAP_FMAC4 soap_get___ns3__PullMessages(struct soap *soap, struct __ns3__PullMessages *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns3__PullMessages(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___d__Probe(struct soap *soap, struct __d__Probe *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->d__Probe = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___d__Probe(struct soap *soap, const struct __d__Probe *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTod__ProbeType(soap, &a->d__Probe);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___d__Probe(struct soap *soap, const char *tag, int id, const struct __d__Probe *a, const char *type)
{
	if (soap_out_PointerTod__ProbeType(soap, "d:Probe", -1, &a->d__Probe, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Probe * SOAP_FMAC4 soap_in___d__Probe(struct soap *soap, const char *tag, struct __d__Probe *a, const char *type)
{
	size_t soap_flag_d__Probe = 1;
	short soap_flag;
	a = (struct __d__Probe *)soap_id_enter(soap, "", a, SOAP_TYPE___d__Probe, sizeof(struct __d__Probe), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___d__Probe(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_d__Probe && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__ProbeType(soap, "d:Probe", &a->d__Probe, "d:ProbeType"))
				{	soap_flag_d__Probe--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___d__Probe(struct soap *soap, const struct __d__Probe *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___d__Probe(soap, tag?tag:"-d:Probe", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Probe * SOAP_FMAC4 soap_get___d__Probe(struct soap *soap, struct __d__Probe *p, const char *tag, const char *type)
{
	if ((p = soap_in___d__Probe(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___d__Bye(struct soap *soap, struct __d__Bye *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->d__Bye = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___d__Bye(struct soap *soap, const struct __d__Bye *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTod__ByeType(soap, &a->d__Bye);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___d__Bye(struct soap *soap, const char *tag, int id, const struct __d__Bye *a, const char *type)
{
	if (soap_out_PointerTod__ByeType(soap, "d:Bye", -1, &a->d__Bye, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Bye * SOAP_FMAC4 soap_in___d__Bye(struct soap *soap, const char *tag, struct __d__Bye *a, const char *type)
{
	size_t soap_flag_d__Bye = 1;
	short soap_flag;
	a = (struct __d__Bye *)soap_id_enter(soap, "", a, SOAP_TYPE___d__Bye, sizeof(struct __d__Bye), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___d__Bye(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_d__Bye && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__ByeType(soap, "d:Bye", &a->d__Bye, "d:ByeType"))
				{	soap_flag_d__Bye--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___d__Bye(struct soap *soap, const struct __d__Bye *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___d__Bye(soap, tag?tag:"-d:Bye", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Bye * SOAP_FMAC4 soap_get___d__Bye(struct soap *soap, struct __d__Bye *p, const char *tag, const char *type)
{
	if ((p = soap_in___d__Bye(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___d__Hello(struct soap *soap, struct __d__Hello *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->d__Hello = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___d__Hello(struct soap *soap, const struct __d__Hello *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTod__HelloType(soap, &a->d__Hello);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___d__Hello(struct soap *soap, const char *tag, int id, const struct __d__Hello *a, const char *type)
{
	if (soap_out_PointerTod__HelloType(soap, "d:Hello", -1, &a->d__Hello, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Hello * SOAP_FMAC4 soap_in___d__Hello(struct soap *soap, const char *tag, struct __d__Hello *a, const char *type)
{
	size_t soap_flag_d__Hello = 1;
	short soap_flag;
	a = (struct __d__Hello *)soap_id_enter(soap, "", a, SOAP_TYPE___d__Hello, sizeof(struct __d__Hello), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___d__Hello(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_d__Hello && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__HelloType(soap, "d:Hello", &a->d__Hello, "d:HelloType"))
				{	soap_flag_d__Hello--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___d__Hello(struct soap *soap, const struct __d__Hello *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___d__Hello(soap, tag?tag:"-d:Hello", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Hello * SOAP_FMAC4 soap_get___d__Hello(struct soap *soap, struct __d__Hello *p, const char *tag, const char *type)
{
	if ((p = soap_in___d__Hello(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->tev__PullMessagesFaultResponse = NULL;
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_tev__PullMessagesFaultResponse(soap, &a->tev__PullMessagesFaultResponse);
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
		return soap->error;
	if (soap_out_PointerTo_tev__PullMessagesFaultResponse(soap, "tev:PullMessagesFaultResponse", -1, &a->tev__PullMessagesFaultResponse, ""))
		return soap->error;
//	if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
//		return soap->error;
//	soap_outliteral(soap, "-any", &a->__any, NULL);
        if (soap->lang)
                soap_set_attr(soap, "xml:lang", soap->lang);
        if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->__any, ""))
                return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	size_t soap_flag_tev__PullMessagesFaultResponse = 1;
	size_t soap_flag_fault = 1;
	size_t soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tev__PullMessagesFaultResponse && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_tev__PullMessagesFaultResponse(soap, "tev:PullMessagesFaultResponse", &a->tev__PullMessagesFaultResponse, ""))
				{	soap_flag_tev__PullMessagesFaultResponse--;
					continue;
				}
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_fault > 1))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsbf__ResourceUnknownFaultType_FaultCause(struct soap *soap, struct _wsbf__ResourceUnknownFaultType_FaultCause *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__any = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsbf__ResourceUnknownFaultType_FaultCause(struct soap *soap, const struct _wsbf__ResourceUnknownFaultType_FaultCause *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsbf__ResourceUnknownFaultType_FaultCause(struct soap *soap, const char *tag, int id, const struct _wsbf__ResourceUnknownFaultType_FaultCause *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsbf__ResourceUnknownFaultType_FaultCause), type))
		return soap->error;
	soap_outliteral(soap, "-any", &a->__any, NULL);
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsbf__ResourceUnknownFaultType_FaultCause * SOAP_FMAC4 soap_in__wsbf__ResourceUnknownFaultType_FaultCause(struct soap *soap, const char *tag, struct _wsbf__ResourceUnknownFaultType_FaultCause *a, const char *type)
{
	size_t soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsbf__ResourceUnknownFaultType_FaultCause *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsbf__ResourceUnknownFaultType_FaultCause, sizeof(struct _wsbf__ResourceUnknownFaultType_FaultCause), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsbf__ResourceUnknownFaultType_FaultCause(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsbf__ResourceUnknownFaultType_FaultCause *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsbf__ResourceUnknownFaultType_FaultCause, 0, sizeof(struct _wsbf__ResourceUnknownFaultType_FaultCause), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsbf__ResourceUnknownFaultType_FaultCause(struct soap *soap, const struct _wsbf__ResourceUnknownFaultType_FaultCause *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsbf__ResourceUnknownFaultType_FaultCause);
	if (soap_out__wsbf__ResourceUnknownFaultType_FaultCause(soap, tag?tag:"wsbf:ResourceUnknownFaultType-FaultCause", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsbf__ResourceUnknownFaultType_FaultCause * SOAP_FMAC4 soap_get__wsbf__ResourceUnknownFaultType_FaultCause(struct soap *soap, struct _wsbf__ResourceUnknownFaultType_FaultCause *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsbf__ResourceUnknownFaultType_FaultCause(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsbf__ResourceUnknownFaultType_Description(struct soap *soap, struct _wsbf__ResourceUnknownFaultType_Description *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->__item);
	soap_default__xml__lang(soap, &a->xml__lang);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsbf__ResourceUnknownFaultType_Description(struct soap *soap, const struct _wsbf__ResourceUnknownFaultType_Description *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->__item);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsbf__ResourceUnknownFaultType_Description(struct soap *soap, const char *tag, int id, const struct _wsbf__ResourceUnknownFaultType_Description *a, const char *type)
{
	if (a->xml__lang)
		soap_set_attr(soap, "xml:lang", a->xml__lang);
	return soap_out_string(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct _wsbf__ResourceUnknownFaultType_Description * SOAP_FMAC4 soap_in__wsbf__ResourceUnknownFaultType_Description(struct soap *soap, const char *tag, struct _wsbf__ResourceUnknownFaultType_Description *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct _wsbf__ResourceUnknownFaultType_Description *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsbf__ResourceUnknownFaultType_Description, sizeof(struct _wsbf__ResourceUnknownFaultType_Description), 0, NULL, NULL, NULL)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default__wsbf__ResourceUnknownFaultType_Description(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "xml:lang", 0), &a->xml__lang, -1, -1))
		return NULL;
	if (!soap_in_string(soap, tag, &a->__item, ""))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsbf__ResourceUnknownFaultType_Description(struct soap *soap, const struct _wsbf__ResourceUnknownFaultType_Description *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsbf__ResourceUnknownFaultType_Description);
	if (soap_out__wsbf__ResourceUnknownFaultType_Description(soap, tag?tag:"wsbf:ResourceUnknownFaultType-Description", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsbf__ResourceUnknownFaultType_Description * SOAP_FMAC4 soap_get__wsbf__ResourceUnknownFaultType_Description(struct soap *soap, struct _wsbf__ResourceUnknownFaultType_Description *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsbf__ResourceUnknownFaultType_Description(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsbf__ResourceUnknownFaultType_ErrorCode(struct soap *soap, struct _wsbf__ResourceUnknownFaultType_ErrorCode *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &a->dialect);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsbf__ResourceUnknownFaultType_ErrorCode(struct soap *soap, const struct _wsbf__ResourceUnknownFaultType_ErrorCode *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsbf__ResourceUnknownFaultType_ErrorCode(struct soap *soap, const char *tag, int id, const struct _wsbf__ResourceUnknownFaultType_ErrorCode *a, const char *type)
{
	if (a->dialect)
		soap_set_attr(soap, "dialect", a->dialect);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsbf__ResourceUnknownFaultType_ErrorCode), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsbf__ResourceUnknownFaultType_ErrorCode * SOAP_FMAC4 soap_in__wsbf__ResourceUnknownFaultType_ErrorCode(struct soap *soap, const char *tag, struct _wsbf__ResourceUnknownFaultType_ErrorCode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsbf__ResourceUnknownFaultType_ErrorCode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsbf__ResourceUnknownFaultType_ErrorCode, sizeof(struct _wsbf__ResourceUnknownFaultType_ErrorCode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsbf__ResourceUnknownFaultType_ErrorCode(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "dialect", 1), &a->dialect, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsbf__ResourceUnknownFaultType_ErrorCode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsbf__ResourceUnknownFaultType_ErrorCode, 0, sizeof(struct _wsbf__ResourceUnknownFaultType_ErrorCode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsbf__ResourceUnknownFaultType_ErrorCode(struct soap *soap, const struct _wsbf__ResourceUnknownFaultType_ErrorCode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsbf__ResourceUnknownFaultType_ErrorCode);
	if (soap_out__wsbf__ResourceUnknownFaultType_ErrorCode(soap, tag?tag:"wsbf:ResourceUnknownFaultType-ErrorCode", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsbf__ResourceUnknownFaultType_ErrorCode * SOAP_FMAC4 soap_get__wsbf__ResourceUnknownFaultType_ErrorCode(struct soap *soap, struct _wsbf__ResourceUnknownFaultType_ErrorCode *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsbf__ResourceUnknownFaultType_ErrorCode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsbf__UnableToDestroySubscriptionFaultType_FaultCause(struct soap *soap, struct _wsbf__UnableToDestroySubscriptionFaultType_FaultCause *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__any = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsbf__UnableToDestroySubscriptionFaultType_FaultCause(struct soap *soap, const struct _wsbf__UnableToDestroySubscriptionFaultType_FaultCause *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsbf__UnableToDestroySubscriptionFaultType_FaultCause(struct soap *soap, const char *tag, int id, const struct _wsbf__UnableToDestroySubscriptionFaultType_FaultCause *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_FaultCause), type))
		return soap->error;
	soap_outliteral(soap, "-any", &a->__any, NULL);
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsbf__UnableToDestroySubscriptionFaultType_FaultCause * SOAP_FMAC4 soap_in__wsbf__UnableToDestroySubscriptionFaultType_FaultCause(struct soap *soap, const char *tag, struct _wsbf__UnableToDestroySubscriptionFaultType_FaultCause *a, const char *type)
{
	size_t soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsbf__UnableToDestroySubscriptionFaultType_FaultCause *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_FaultCause, sizeof(struct _wsbf__UnableToDestroySubscriptionFaultType_FaultCause), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsbf__UnableToDestroySubscriptionFaultType_FaultCause(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsbf__UnableToDestroySubscriptionFaultType_FaultCause *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_FaultCause, 0, sizeof(struct _wsbf__UnableToDestroySubscriptionFaultType_FaultCause), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsbf__UnableToDestroySubscriptionFaultType_FaultCause(struct soap *soap, const struct _wsbf__UnableToDestroySubscriptionFaultType_FaultCause *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_FaultCause);
	if (soap_out__wsbf__UnableToDestroySubscriptionFaultType_FaultCause(soap, tag?tag:"wsbf:UnableToDestroySubscriptionFaultType-FaultCause", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsbf__UnableToDestroySubscriptionFaultType_FaultCause * SOAP_FMAC4 soap_get__wsbf__UnableToDestroySubscriptionFaultType_FaultCause(struct soap *soap, struct _wsbf__UnableToDestroySubscriptionFaultType_FaultCause *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsbf__UnableToDestroySubscriptionFaultType_FaultCause(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsbf__UnableToDestroySubscriptionFaultType_Description(struct soap *soap, struct _wsbf__UnableToDestroySubscriptionFaultType_Description *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->__item);
	soap_default__xml__lang(soap, &a->xml__lang);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsbf__UnableToDestroySubscriptionFaultType_Description(struct soap *soap, const struct _wsbf__UnableToDestroySubscriptionFaultType_Description *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->__item);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsbf__UnableToDestroySubscriptionFaultType_Description(struct soap *soap, const char *tag, int id, const struct _wsbf__UnableToDestroySubscriptionFaultType_Description *a, const char *type)
{
	if (a->xml__lang)
		soap_set_attr(soap, "xml:lang", a->xml__lang);
	return soap_out_string(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct _wsbf__UnableToDestroySubscriptionFaultType_Description * SOAP_FMAC4 soap_in__wsbf__UnableToDestroySubscriptionFaultType_Description(struct soap *soap, const char *tag, struct _wsbf__UnableToDestroySubscriptionFaultType_Description *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct _wsbf__UnableToDestroySubscriptionFaultType_Description *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_Description, sizeof(struct _wsbf__UnableToDestroySubscriptionFaultType_Description), 0, NULL, NULL, NULL)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default__wsbf__UnableToDestroySubscriptionFaultType_Description(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "xml:lang", 0), &a->xml__lang, -1, -1))
		return NULL;
	if (!soap_in_string(soap, tag, &a->__item, ""))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsbf__UnableToDestroySubscriptionFaultType_Description(struct soap *soap, const struct _wsbf__UnableToDestroySubscriptionFaultType_Description *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_Description);
	if (soap_out__wsbf__UnableToDestroySubscriptionFaultType_Description(soap, tag?tag:"wsbf:UnableToDestroySubscriptionFaultType-Description", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsbf__UnableToDestroySubscriptionFaultType_Description * SOAP_FMAC4 soap_get__wsbf__UnableToDestroySubscriptionFaultType_Description(struct soap *soap, struct _wsbf__UnableToDestroySubscriptionFaultType_Description *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsbf__UnableToDestroySubscriptionFaultType_Description(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode(struct soap *soap, struct _wsbf__UnableToDestroySubscriptionFaultType_ErrorCode *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &a->dialect);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode(struct soap *soap, const struct _wsbf__UnableToDestroySubscriptionFaultType_ErrorCode *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode(struct soap *soap, const char *tag, int id, const struct _wsbf__UnableToDestroySubscriptionFaultType_ErrorCode *a, const char *type)
{
	if (a->dialect)
		soap_set_attr(soap, "dialect", a->dialect);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsbf__UnableToDestroySubscriptionFaultType_ErrorCode * SOAP_FMAC4 soap_in__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode(struct soap *soap, const char *tag, struct _wsbf__UnableToDestroySubscriptionFaultType_ErrorCode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsbf__UnableToDestroySubscriptionFaultType_ErrorCode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode, sizeof(struct _wsbf__UnableToDestroySubscriptionFaultType_ErrorCode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "dialect", 1), &a->dialect, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsbf__UnableToDestroySubscriptionFaultType_ErrorCode *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode, 0, sizeof(struct _wsbf__UnableToDestroySubscriptionFaultType_ErrorCode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode(struct soap *soap, const struct _wsbf__UnableToDestroySubscriptionFaultType_ErrorCode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode);
	if (soap_out__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode(soap, tag?tag:"wsbf:UnableToDestroySubscriptionFaultType-ErrorCode", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsbf__UnableToDestroySubscriptionFaultType_ErrorCode * SOAP_FMAC4 soap_get__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode(struct soap *soap, struct _wsbf__UnableToDestroySubscriptionFaultType_ErrorCode *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsbf__UnableToDestroySubscriptionFaultType_ErrorCode(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tptz__SetConfigurationResponse_sequence(struct soap *soap, struct __tptz__SetConfigurationResponse_sequence *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tptz__SetConfigurationResponse_sequence(struct soap *soap, const struct __tptz__SetConfigurationResponse_sequence *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tptz__SetConfigurationResponse_sequence(struct soap *soap, const char *tag, int id, const struct __tptz__SetConfigurationResponse_sequence *a, const char *type)
{
	return SOAP_OK;
}

SOAP_FMAC3 struct __tptz__SetConfigurationResponse_sequence * SOAP_FMAC4 soap_in___tptz__SetConfigurationResponse_sequence(struct soap *soap, const char *tag, struct __tptz__SetConfigurationResponse_sequence *a, const char *type)
{
	a = (struct __tptz__SetConfigurationResponse_sequence *)soap_id_enter(soap, "", a, SOAP_TYPE___tp