/**
 * A client-side 802.1x implementation
 *
 * This code is released under both the GPL version 2 and BSD licenses.
 * Either license may be used.  The respective licenses are found below.
 *
 * Copyright (C) 2002 Bryan D. Payne & Nick L. Petroni Jr.
 * All Rights Reserved
 *
 * --- GPL Version 2 License ---
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * --- BSD License ---
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  - All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *       This product includes software developed by the University of
 *       Maryland at College Park and its contributors.
 *  - Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*******************************************************************
 *
 * File: xsupgui.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _GUI_INTERFACE_H_
#define _GUI_INTERFACE_H_

#include <sys/socket.h>
#include <inttypes.h>
#include <netinet/in.h>

#define AUTH_STATE_STOPPED  1
#define AUTH_STATE_RESTART  2
#define AUTH_STATE_START    3
#define AUTH_STATE_RUNNING  4

#define AUTH_STATE    1  /* Get authentication state (get only!) */
#define PASSWORD      2  /* Set password (set only!) */

#define NOTIFY        6  /* A notification message to be displayed. */
#define TEMPPASSWORD  7  /* A temporary password to be used by the daemon. */
#define TNCENABLE     8  /* Change the state of TNC support to en/disable. */
#define AUTH_CTRL     9  /* Start, stop, or restart authentication. */
#define LOG_MSG      10  /* Recieve a standard log message. */
#define PING         11  /* Send a ping request to the supplicant. */

#define ERROR_MSG   255  /* Return an error message. */

#define ACK           1
#define NACK          0

#define FALSE         0
#define TRUE          1

#define DONT_CLEAR    0
#define CLEAR         1

#define IPC_RESPONSE  0
#define IPC_GET       1
#define IPC_SET       2

#define ERR_NONE       0
#define ERR_CANT_GET  -1
#define ERR_CANT_SET  -2
#define ERR_SOCK      -3
#define ERR_PKT_BAD   -4
#define ERR_BAD_DATA  -5

/* This matches the order of states listed in IEEE 802.1x-2001, pg. 59,
   section 8.5.10. */
#define LOGOFF           0
#define DISCONNECTED     1
#define CONNECTING       2
#define ACQUIRED         3
#define AUTHENTICATING   4
#define HELD             5
#define AUTHENTICATED    6 
#define RESTART          7
#define S_FORCE_AUTH     8
#define S_FORCE_UNAUTH   9

#define IPC_VERSION_NUM  3

struct ipc_cmd {
  uint8_t version;
  uint8_t attribute;
  uint8_t getset;
  uint8_t len;
  /* Value comes after that. */
};

int xsupgui_connect(char *);
int xsupgui_disconnect(int);
int xsupgui_get_packet(int, char *, int *, int);
int xsupgui_send_packet(int, char *, int);
int xsupgui_parse_packet(char *, int *, char *, int *);
int xsupgui_get_state(char *, int *);
int xsupgui_set_password(char *, int *, char *);
int xsupgui_get_tnc_state(char *, int *);
int xsupgui_set_use_tnc(char *, int *, char);
int xsupgui_get_auth_ctrl_state(char *, int *);
int xsupgui_set_auth_ctrl(char *, int *, char);
int xsupgui_is_xsup_running(char *);

#endif
