/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#include <qdir.h>
#include <qregexp.h>
#include <qmessagebox.h>
#include <qfiledialog.h>

void mainWnd::destroy()
{
    config_destroy();
    xsupgui_disconnect(sockfd);
}

void mainWnd::reqState()
{
    char buffer[50];
    int bufptr = 0;

    xsupgui_get_state(buffer, &bufptr);

    if (xsupgui_send_packet(sockfd, buffer, bufptr) != 0)
     {
	QMessageBox::critical(this, QString("Error!"), QString("Error sending packet to Xsupplicant!"),1,0,0);

          return;
     }
}

void mainWnd::setAuthState( char state )
{
    switch (state)
    {
        case LOGOFF:
            authStatelbl->setText(QString("LOGOFF"));
            break;

        case DISCONNECTED:
            authStatelbl->setText(QString("DISCONNECTED"));
            break;

        case CONNECTING:
            authStatelbl->setText(QString("CONNECTING"));
            break;

        case ACQUIRED:
            // No longer used.  But we will put it here anyway.
            authStatelbl->setText(QString("ACQUIRED"));
            break;

        case AUTHENTICATING:
            authStatelbl->setText(QString("AUTHENTICATING"));
            break;

        case HELD:
            authStatelbl->setText(QString("HELD"));
            break;

        case AUTHENTICATED:
            authStatelbl->setText(QString("AUTHENTICATED"));
            break;

        case RESTART:
            authStatelbl->setText(QString("RESTART"));
            break;

        case S_FORCE_AUTH:
            authStatelbl->setText(QString("Forced Authenticated"));
            break;

        case S_FORCE_UNAUTH:
            authStatelbl->setText(QString("Forced UN-Authenticated"));
            break;

        default:
            authStatelbl->setText(QString("UNKNOWN"));
            break;
   }
}

void mainWnd::handleLogMsg(char *buf, int buflen)
{
    int bufptr = 0, cur;
    
    // The first byte is the type of log information that this is.  For now, we ignore it.
    bufptr++;
    cur = bufptr;
  
    // Since QT doesn't know what to do with \n, we need to figure it out for it.
    while (cur < buflen)
    {
	if (buf[cur] == '\n')
	{
	    buf[cur]= 0x00;
	    
	    logdata->insertItem(QString(&buf[bufptr]), -1);
	    logdata->setCurrentItem(logdata->numRows()-1);
	    logdata->ensureCurrentVisible();
	    bufptr = cur+1;
	}
	cur++;
    }

    if ((bufptr < buflen) && (buf[bufptr] != 0x00))
    {
	// We have one that we didn't do yet.
	logdata->insertItem(QString(&buf[bufptr]), -1);
	logdata->setCurrentItem(logdata->numRows()-1);
	logdata->ensureCurrentVisible();
    }
}

void mainWnd::handleNotify(char *data, int len)
{
    QMessageBox::information(this, QString("EAP Notification"), QString(data), 1, 0, 0);
    len = len;   // Shut up compiler.
}

void mainWnd::handlePassword(char *data, int len)
{
    pwdPrompt pwd;
    char *mypwd = NULL;
    char buffer[1500];
    int bufptr = 0;
    
    pwd.setPwd(&mypwd);
    pwd.setDisplay(data, len);
    pwd.exec();
    
    if (mypwd != NULL)
    {
	printf("Sending password.\n");
	xsupgui_set_password(buffer, &bufptr, mypwd);

	if (xsupgui_send_packet(sockfd, buffer, bufptr) != 0)
	{	
	    QMessageBox::critical(this, QString("Error!"), QString("Error sending packet to Xsupplicant!"),1,0,0);

	    return;
	}
    }
}

void mainWnd::dataReceived()
{
    int size = 1500, datalen = 1500, bufptr;
    char buffer[1500], data[1500];

    memset(buffer, 0, 1500);
    if (xsupgui_get_packet(sockfd, (char *)&buffer, &size, FALSE)  != ERR_NONE)
    {
	QMessageBox::critical(this, QString("Communication Error"), 
			      QString("Recieved an event that indicated a message was available, but something went wrong trying to get it."), 1, 0, 0);

	return;
    }
    else
    {
        if (size == 0)
        {
	    if (msgdisplayed != 1)
	    {
		msgdisplayed = 1;
		QMessageBox::warning(this, QString("Xsupplicant terminated"),
				     QString("This instance of Xsupplicant has terminated.  Please select another instance from the drop down box."),1,0,0);
		
		authStatelbl->setText(QString("Not Running"));
	    }
	    return;
        }

        msgdisplayed = 0;
        memset(data, 0, 1500);

        bufptr = 0;

        while (bufptr < size)
        {
            switch (xsupgui_parse_packet(buffer, &bufptr, data, &datalen))
            {
	    case AUTH_STATE:
		setAuthState(data[0]);
		break;
		
	    case LOG_MSG:
		handleLogMsg(data, datalen);
		break;
		
	    case NOTIFY:
		handleNotify(data, datalen);
		break;
		
	    case PASSWORD:
		handlePassword(data, datalen);
		break;
/*
            case TNCENABLE:
                if (data[0] == 0)
                {
                    tncState->setText(QString("DISABLED"));
                }
                else
                {
                    tncState->setText(QString("ENABLED"));
                }*/
	    case ERR_PKT_BAD:
		bufptr = size;
		break;
            }
        }
    }
}

void mainWnd::hookInt()
{
    if (interface != NULL)
    {
	free(interface);
	interface = NULL;
    }
    
    interface = strdup(intList->currentText().ascii());

    if (sockfd > 0)
    {
	// Close out the existing socket.
	xsupgui_disconnect(sockfd);	
    }
    
    sockfd = xsupgui_connect(interface);

    if (sockfd <= 0)
    {
	// Update this to be a message box instead.
	printf("Interface %s appeared to be running Xsupplicant.  However, we were "
	       "unable to obtain a socket to communicate with it.\n", interface);
	exit(1);
    }    
    
    if (sn != NULL)
    {
	delete sn;
    }
    
    // Let us know when there is something to read.
    sn = new QSocketNotifier(  sockfd, QSocketNotifier::Read, this, NULL );

    QObject::connect( sn, SIGNAL(activated(int)), this, SLOT(dataReceived()) );

    // Request initial state.
    reqState();
}

void mainWnd::init()
{
    statBar = statusBar();
     
    findInts();
    
    // So that hookInt() doesn't get confused and think we have something already open.
    sockfd = -1;
    interface = NULL;
    sn = NULL;
    
    hookInt();
    
    conf_file = QString("/etc/xsupplicant.conf");
    
    statBar->message(QString("Using configuration : ") + conf_file);
    statBar->setSizeGripEnabled(false);
    statBar->show();
    
    // Set our log window to disallow selections.
    logdata->setSelectionMode(QListBox::NoSelection);

    // When a message is displayed that is likely to be triggered repeatedly, set this to 1, and use it to block
    // displaying the message over and over again.
    msgdisplayed = 0;
    
    loadConfigAndPopulate();
}

void mainWnd::findInts()
{
    int foundints =0;
    QDir d;
    d.setFilter( QDir::AccessMask);
    d.setSorting( QDir::Size | QDir::Reversed );
    d.setPath(QString("/tmp"));
    d.setNameFilter(QString("xsupplicant.sock.*"));
    
    const QFileInfoList *list = d.entryInfoList();
    QFileInfoListIterator it( *list );
    QFileInfo *fi;
  
    QRegExp q("xsupplicant.sock.(\\w+)");
  
    while ( (fi = it.current()) != 0 ) {
	q.search(fi->fileName());

	// We should only ever catch one thing.  If we get more, or less than that, it isn't valid.
	if (q.numCaptures() == 1)
	{
	    foundints++;
	    intList->insertItem(q.cap(1), -1);
	}
	
	++it;
    }
    
    if (foundints <= 0)
    {
	intList->insertItem(QString("None"), -1);
    }	    
    
    intList->insertItem(QString("Recheck"), intList->count());
}

void mainWnd::intChanged()
{
    QString temp;
    
    if (intList->currentText() == QString("None"))
    {
	return;
    }
    
    if (intList->currentText() == QString("Recheck"))
    {
	// Save the interface we are currently using.
	temp = intList->currentText();
	
	// Do a recheck, and return.
	intList->clear();
	findInts();
	
	// Reset the selected interface to be the one we were originally using.
	if (intList->currentText() != "Recheck")
	{
	    intList->setCurrentText(temp);
	}
	
	return;
    }
    
    // Otherwise, we want to attach to a new interface.
    hookInt();
}

void mainWnd::configLoad_clicked()
{
    QFileDialog qfd;
    QString filename;
    
    qfd.setMode(QFileDialog::ExistingFile);
    qfd.setFilter( "Xsupplicant Configuration (*.conf)" );
    qfd.setCaption(QString("Select Xsupplicant Configuration File"));
    if (qfd.exec() == QDialog::Accepted)
    {
	conf_file = qfd.selectedFile();
	loadConfigAndPopulate();
    }
}


void mainWnd::loadConfigAndPopulate()
{
    // Clean up what was here before.
    config_destroy();
    configedNets->clear();
    
    // Then load the new file.
    if (config_setup((char *)conf_file.ascii()) != 0)
    {
	QMessageBox::critical(this, QString("No configuration found!"),
				     QString("No configuration file was found in the default "
					     "location."),1,0,0);
	return;
    }

    // Otherwise, populate the window.
    populateconfigedNets();
}

void mainWnd::populateconfigedNets()
{
    struct config_network *networks;
    
    networks = config_get_root_network_config();
    if (!networks)
    {
	QMessageBox::critical(this, QString("No networks configured!"),
			      QString("There appear to be no configured networks in your configuration file."), 1, 0, 0);
	return;
    }
    
    // Otherwise, walk the network list, and populate the configuration information.
    while (networks)
    {
	if (networks->name)
	{
	    configedNets->insertItem(QString(networks->name), -1);
	}
	
	networks = networks->next;
    }
}



void mainWnd::fileSave()
{
    int retval;
    
    retval = xsupconfwrite_write_config(config_get_config_info(), (char *)conf_file.ascii());
    
    if (retval != 0)
    {
	QMessageBox::critical(this, QString("Save Configuration Failed"),
				     QString("Unable to save your configuration."),1,0,0);
    }
    else
    {
	QMessageBox::information(this, QString("Saved Configuration"),
				 QString("Your configuration has been saved."), 1, 0, 0);
    }
}


void mainWnd::fileNew()
{
    config_create_new_config();
    configedNets->clear();
    populateconfigedNets();
    
    QMessageBox::information(this, QString("Create new configuration"),
			 QString("A new configuration has been created in memory.\n"
				 "Please remember to save it before quitting."),1,0,0);
}


void mainWnd::globalSettings_clicked()
{
    gSettings gs;
    struct config_globals *globals;
   
    globals = config_get_globals();
    if (!globals)
    {
	QMessageBox::critical(this, QString("No valid globals are defined!"),
			      QString("There is no valid global configuration information available.\nPlease either load a valid configuration, or create a new one to continue."), 1, 0, 0);
	return;
    }
    
    gs.setConfig((config_globals *)globals, (config_network *)config_get_root_network_config());
    gs.exec();
}


void mainWnd::newNetClicked()
{
    netConfig nc;
    
    nc.exec();
}


void mainWnd::editNetClicked()
{
    netConfig nc;
    config_network *net;
    
    // Find the configuration we are looking for.
    net = config_find_network(config_get_root_network_config(),
			      (char *)configedNets->currentText().ascii());
    
    nc.setNetConfig(net);
    nc.exec();
}


void mainWnd::removeNetClicked()
{
    if (configedNets->currentItem() == -1)
    {
	QMessageBox::information(this, tr("No network selected!"),
				 tr("There is no network selected for removal.  Please\n"
				    "select one, and try again."), 1, 0, 0);
	return;
    }

    if (!QMessageBox::question(
	    this,
	    tr("Erase Network?"),
	    tr("Are you sure you want to delete the network '%1'?")
	    .arg( configedNets->currentText() ),
	    tr("&Yes"), tr("&No"),
	    QString::null, 0, 1 ) )
    {
	deleteNet(configedNets->currentText());
	configedNets->clear();
	
	populateconfigedNets();
    } 
}


void mainWnd::checkConfigClicked()
{
    cerrs *mycerrs = NULL;
    confCheckFailed ccf;
    
    xsupconfcheck_init();
    
    if (xsupconfcheck_check_config(config_get_config_info(), &mycerrs) != 0)
    {
	// There was something wrong with our config!
	ccf.setErrors(mycerrs);
	ccf.exec();
    }
    else
    {
	QMessageBox::information(this, QString("Configuration Okay"),
				 QString("Your configuration appears to be okay."), 1, 0, 0);
    }
    xsupconfcheck_deinit(&mycerrs);
}


void mainWnd::fileSaveAs()
{
    QFileDialog qfd;
    QString filename;
    int retval;
    
    qfd.setMode(QFileDialog::AnyFile);
    qfd.setFilter( "Xsupplicant Configuration (*.conf)" );
    qfd.setCaption(QString("Select Xsupplicant Configuration File"));
    if (qfd.exec() == QDialog::Accepted)
    {
	filename = qfd.selectedFile();
  
	if ( QFile::exists( filename ))
	{
	     if (!QMessageBox::question(
		     this,
		     tr("Overwrite File?"),
		     tr("A file called %1 already exists."
			"Do you want to overwrite it?")
		     .arg( filename ),
		     tr("&Yes"), tr("&No"),
		     QString::null, 0, 1 ) )
	    {
		 retval = xsupconfwrite_write_config(config_get_config_info(), 
						     (char *)filename.ascii());    
		 
		 if (retval != 0)
		 {
		     QMessageBox::critical(this, QString("Save Configuration Failed"),
					   QString("Unable to save your configuration."),1,0,0);
		 }
		 else
		 {
		     QMessageBox::information(this, QString("Saved Configuration"),
					      QString("Your configuration has been saved."), 1, 0, 0);
		 }	 
	     }
	 }
	else
	{
	    retval = xsupconfwrite_write_config(config_get_config_info(),
						(char *)filename.ascii());
	    
	    if (retval != 0)
	    {
		QMessageBox::critical(this, QString("Save Configuration Failed"),
				      QString("Unable to save your configuration."),1,0,0);
	    }
	    else
	    {
		QMessageBox::information(this, QString("Saved Configuration"),
					 QString("Your configuration has been saved."), 1, 0, 0);
	    }
	}
    }
}


void mainWnd::deleteNet( QString netToDelete )
{
    config_delete_net((char *)netToDelete.ascii());
}


void mainWnd::loadConfigAdvanced()
{
    configAdvanced ca;
    struct config_globals *globals;
   
    globals = config_get_globals();
    if (!globals)
    {
	QMessageBox::critical(this, QString("No valid globals are defined!"),
			      QString("There is no valid global configuration information available.\nPlease either load a valid configuration, or create a new one to continue."), 1, 0, 0);
	return;
    }
    
    ca.setGlobals((config_globals *)globals);    
    ca.exec();
}
