/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

void configAdvanced::init()
{
}


void configAdvanced::okayAccept()
{
    globaldata->destination = destMacMethod->currentItem();
    // Set destination MAC
    
    if (associationEnabled->currentItem() == 0)
    {
	SET_FLAG(globaldata->flags, CONFIG_GLOBALS_ASSOC_AUTO);
    }
    else
    {
	UNSET_FLAG(globaldata->flags, CONFIG_GLOBALS_ASSOC_AUTO);
    }
    
    globaldata->assoc_timeout = assocTimeout->value();
    
    free(globaldata->ipc_group_name);
    globaldata->ipc_group_name = strdup(ipcGroupNameEdit->text().ascii());
    
    globaldata->auth_period = authPeriodSpin->value();
    
    globaldata->held_period = heldPeriodSpin->value();
    
    globaldata->max_starts = maxStarts->value();
    
    if (allmultiEnabled->currentItem() == 0)
    {
	SET_FLAG(globaldata->flags, CONFIG_GLOBALS_ALLMULTI);
    }
    else
    {
	UNSET_FLAG(globaldata->flags, CONFIG_GLOBALS_ALLMULTI);
    }
    
    if (warningCombo->currentItem() == 0)
    {
	UNSET_FLAG(globaldata->flags, CONFIG_GLOBALS_NO_FRIENDLY_WARNINGS);
    }
    else
    {
	SET_FLAG(globaldata->flags, CONFIG_GLOBALS_NO_FRIENDLY_WARNINGS);
    }
    
    globaldata->stale_key_timeout = staleKeyTimeout->value();
    
    if (eapHints->currentItem() == 0)
    {
	UNSET_FLAG(globaldata->flags, CONFIG_GLOBALS_NO_EAP_HINTS);
    }
    else
    {
	SET_FLAG(globaldata->flags, CONFIG_GLOBALS_NO_EAP_HINTS);
    }
    
    if (roamDecision->currentItem() == 0)
    {
	UNSET_FLAG(globaldata->flags, CONFIG_GLOBALS_FIRMWARE_ROAM);
    }
    else
    {
	SET_FLAG(globaldata->flags, CONFIG_GLOBALS_FIRMWARE_ROAM);
    }

    close();
}


void configAdvanced::updateDestMac()
{
    if (destMacMethod->currentText() == QString("Auto"))
    {
	dstMacTxt->setEnabled(false);
	dstMacEdit->setEnabled(false);
    }
    
    if (destMacMethod->currentText() == QString("Source"))
    {
	dstMacTxt->setEnabled(false);
	dstMacEdit->setEnabled(false);
    }
    
    if (destMacMethod->currentText() == QString("Multicast"))
    {
	dstMacTxt->setEnabled(false);
	dstMacEdit->setEnabled(false);
    }
    
    if (destMacMethod->currentText() == QString("BSSID"))
    {
	dstMacTxt->setEnabled(false);
	dstMacEdit->setEnabled(false);
    }
}


void configAdvanced::updateAssociation()
{
    if (associationEnabled->currentText() == QString("Auto"))
    {
	timeoutTxtLbl->setEnabled(true);
	assocTimeout->setEnabled(true);
    }
  
    if (associationEnabled->currentText() == QString("Manual"))
    {
	timeoutTxtLbl->setEnabled(false);
	assocTimeout->setEnabled(false);
    }
}


void configAdvanced::updateWarnings()
{
    if (warningCombo->currentText() == QString("Yes"))
    {
	keyTimeoutLbl->setEnabled(true);
	staleKeyTimeout->setEnabled(true);
    }
    
    if (warningCombo->currentText() == QString("No"))
    {
	keyTimeoutLbl->setEnabled(false);
	staleKeyTimeout->setEnabled(false);
    }
}


void configAdvanced::setGlobals( config_globals *globals )
{
    globaldata = globals;
    
    destMacMethod->setCurrentItem(globaldata->destination);
    
    // Set destination MAC
    
    if (TEST_FLAG(globaldata->flags, CONFIG_GLOBALS_ASSOC_AUTO))
    {
	associationEnabled->setCurrentItem(0);
    }
    else
    {
	associationEnabled->setCurrentItem(1);
	timeoutTxtLbl->setEnabled(false);
	assocTimeout->setEnabled(false);
    }
    
    assocTimeout->setValue(globaldata->assoc_timeout);
    
    ipcGroupNameEdit->setText(QString(globaldata->ipc_group_name));
    
    authPeriodSpin->setValue(globaldata->auth_period);
    
    heldPeriodSpin->setValue(globaldata->held_period);
    
    maxStarts->setValue(globaldata->max_starts);
    
    if (TEST_FLAG(globaldata->flags, CONFIG_GLOBALS_ALLMULTI))
    {
	allmultiEnabled->setCurrentItem(0);
    }
    else
    {
	allmultiEnabled->setCurrentItem(1);
    }
    
    if (!TEST_FLAG(globaldata->flags, CONFIG_GLOBALS_NO_FRIENDLY_WARNINGS))
    {
	warningCombo->setCurrentItem(0);
    }
    else
    {
	warningCombo->setCurrentItem(1);
	keyTimeoutLbl->setEnabled(false);
	staleKeyTimeout->setEnabled(false);
    }
    
    staleKeyTimeout->setValue(globaldata->stale_key_timeout);
    
    if (!TEST_FLAG(globaldata->flags, CONFIG_GLOBALS_NO_EAP_HINTS))
    {
	eapHints->setCurrentItem(0);
    }
    else
    {
	eapHints->setCurrentItem(1);
    }
    
    if (!TEST_FLAG(globaldata->flags, CONFIG_GLOBALS_FIRMWARE_ROAM))
    {
	roamDecision->setCurrentItem(0);
    }
    else
    {
	roamDecision->setCurrentItem(1);
    }
}
