/*******************************************************************
 *
 * File: xsup_set_pwd.c
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * Authors: Chris.Hessing@utah.edu
 *
 * $Id: xsup_set_pwd.c,v 1.16 2006/05/29 02:25:49 chessing Exp $
 * $Date: 2006/05/29 02:25:49 $
 * $Log: xsup_set_pwd.c,v $
 * Revision 1.16  2006/05/29 02:25:49  chessing
 * Patches from Carsten Grohmann.
 *
 * Revision 1.15  2006/05/17 22:18:09  chessing
 * A couple of small changes to Xsupplicant, and some major changes to the GUI configuration/monitor tool.
 *
 * Revision 1.14  2006/04/25 01:17:42  chessing
 * LOTS of code cleanups, new error checking/debugging code added, and other misc. fixes/changes.
 *
 * Revision 1.13  2005/10/16 04:31:29  chessing
 * Changed gui_interface.c/h to be a library called libxsupgui, and moved it to a new lib directory.
 *
 * Revision 1.12  2005/08/09 01:39:12  chessing
 * Cleaned out old commit notes from the released version.  Added a few small features including the ability to disable the friendly warnings that are spit out.  (Such as the warning that is displayed when keys aren't rotated after 10 minutes.)  We should also be able to start when the interface is down.  Last, but not least, we can handle empty network configs.  (This may be useful for situations where there isn't a good reason to have a default network defined.)
 *
 *
 *******************************************************************/
#include <stdio.h>
#include <unistd.h>
#include <strings.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>


#include "../../../lib/libxsupgui/xsupgui.h"

#define XSSP_DEBUG 1

void usage(char *pname)
{
  printf("Usage: %s -i <interface_name>\n\n\n", pname);
  printf("   The interface specified by <interface_name> should be the "
	 "interface that you wish to set a password for.\n");
}

void dump_packet(char *message, char *packet, int size)
{
  int i;

  printf("%s :\n", message);
  for (i=0;i<size;i++)
    {
      printf("%02X ", packet[i]);
    }
  printf("\n");
}

int main(int argc, char *argv[])
{
  char *theOpts = "i:";
  char *passwd, buffer[1520], result[256];
  char *intname = NULL;
  int bufptr = 0;
  int dlen, op, skfd;

  if (argc<2)
    {
      usage(argv[0]);
      exit(1);
    }


  while ((op = getopt(argc, argv, theOpts)) != EOF)
    {
      switch (op)
	{
	case 'i':
	  intname = optarg;
	  break;
	}
    }

  if (intname == NULL)
    {
      usage(argv[0]);
      exit(1);
    }

  if (xsupgui_is_xsup_running(intname) == FALSE)
    {
      fprintf(stderr, "Error!  XSupplicant must be running to use this " 
              "tool!\n");
      exit(1);
    }

  skfd = xsupgui_connect(intname);
  if (skfd < 1)
    {
      fprintf(stderr, "Error!  Couldn't get a handle to the daemon!\n");
      exit(1);
    }
  
  bzero((char *)&buffer, 1520);
  
  passwd = getpass("Please enter your password : ");
 
  if (passwd == NULL)
    {
      fprintf(stderr, "No password set!\n");
      xsupgui_disconnect(skfd);
      exit(1);
    }

  xsupgui_set_password((char *)&buffer, &bufptr, passwd);

#if XSSP_DEBUG
  dump_packet("Sending", (char *)&buffer, bufptr);
#endif

  switch (xsupgui_send_packet(skfd, (char *)&buffer, bufptr))
    {
    case ERR_PKT_BAD:
      fprintf(stderr, "Error! Packet appears to be bad!\n");
      xsupgui_disconnect(skfd);
      exit(1);
      break;
    case ERR_SOCK:
      fprintf(stderr, "Error! There was a socket error!\n");
      xsupgui_disconnect(skfd);
      exit(1);
      break;
    }

  bzero((char *)&buffer, 1520);
  xsupgui_get_packet(skfd, (char *)&buffer, &bufptr, TRUE);

#if XSSP_DEBUG
  dump_packet("Got", (char *)&buffer, bufptr);
#endif

  bufptr = 2;

  if (xsupgui_parse_packet((char *)&buffer, &bufptr, (char *)&result, 
				 &dlen) == ERR_PKT_BAD)
    {
      fprintf(stderr, "The daemon returned an invalid packet!\n");
    }

  if (result[0] == ACK) 
    {
      printf("Your password has been successfully submitted to the XSupplicant daemon.\n");
    } else {
      fprintf(stderr, "Error!  Password not set!\n");
    }

  xsupgui_disconnect(skfd);
  return 0;
}
