/* soapServer.c
   Generated by gSOAP 2.7.16 from myudp.h
   Copyright(C) 2000-2010, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif
#include "soapH.h"
#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) soapServer.c ver 2.7.16 2010-07-29 02:57:17 GMT")


SOAP_FMAC5 int SOAP_FMAC6 soap_serve(struct soap *soap)
{
#ifndef WITH_FASTCGI
	unsigned int k = soap->max_keep_alive;
#endif

	do
	{
#ifdef WITH_FASTCGI
		if (FCGI_Accept() < 0)
		{
			soap->error = SOAP_EOF;
			return soap_send_fault(soap);
		}
#endif

		soap_begin(soap);

#ifndef WITH_FASTCGI
		if (soap->max_keep_alive > 0 && !--k)
			soap->keep_alive = 0;
#endif

		if (soap_begin_recv(soap))
		{	if (soap->error < SOAP_STOP)
			{
#ifdef WITH_FASTCGI
				soap_send_fault(soap);
#else 
				return soap_send_fault(soap);
#endif
			}
			soap_closesock(soap);

			continue;
		}

		if (soap_envelope_begin_in(soap)
		 || soap_recv_header(soap)
		 || soap_body_begin_in(soap)
		 || soap_serve_request(soap)
		 || (soap->fserveloop && soap->fserveloop(soap)))
		{
#ifdef WITH_FASTCGI
			soap_send_fault(soap);
#else
			return soap_send_fault(soap);
#endif
		}

#ifdef WITH_FASTCGI
		soap_destroy(soap);
		soap_end(soap);
	} while (1);
#else
	} while (soap->keep_alive);
#endif
	return SOAP_OK;
}

#ifndef WITH_NOSERVEREQUEST
SOAP_FMAC5 int SOAP_FMAC6 soap_serve_request(struct soap *soap)
{
	soap_peek_element(soap);
//	if (!soap_match_tag(soap, soap->tag, "d:Hello"))
//		return soap_serve___d__Hello(soap);
//	if (!soap_match_tag(soap, soap->tag, "d:Bye"))
//		return soap_serve___d__Bye(soap);
	if (!soap_match_tag(soap, soap->tag, "d:Probe"))
		return soap_serve___d__Probe(soap);
	return soap->error = SOAP_NO_METHOD;
}
#endif

/*
SOAP_FMAC5 int SOAP_FMAC6 soap_serve___d__Hello(struct soap *soap)
{	struct __d__Hello soap_tmp___d__Hello;
	struct d__ResolveType d__HelloResponse;
	soap_default_d__ResolveType(soap, &d__HelloResponse);
	soap_default___d__Hello(soap, &soap_tmp___d__Hello);
	soap->encodingStyle = NULL;
	if (!soap_get___d__Hello(soap, &soap_tmp___d__Hello, "-d:Hello", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __d__Hello(soap, soap_tmp___d__Hello.d__Hello, &d__HelloResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_d__ResolveType(soap, &d__HelloResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_d__ResolveType(soap, &d__HelloResponse, "d:HelloResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_d__ResolveType(soap, &d__HelloResponse, "d:HelloResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___d__Bye(struct soap *soap)
{	struct __d__Bye soap_tmp___d__Bye;
	struct d__ResolveType d__ByeResponse;
	soap_default_d__ResolveType(soap, &d__ByeResponse);
	soap_default___d__Bye(soap, &soap_tmp___d__Bye);
	soap->encodingStyle = NULL;
	if (!soap_get___d__Bye(soap, &soap_tmp___d__Bye, "-d:Bye", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __d__Bye(soap, soap_tmp___d__Bye.d__Bye, &d__ByeResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_d__ResolveType(soap, &d__ByeResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_d__ResolveType(soap, &d__ByeResponse, "d:ByeResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_d__ResolveType(soap, &d__ByeResponse, "d:ByeResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}
*/
SOAP_FMAC5 int SOAP_FMAC6 soap_serve___d__Probe(struct soap *soap)
{	struct __d__Probe soap_tmp___d__Probe;
	struct d__ProbeMatchesType d__ProbeResponse;
	soap_default_d__ProbeMatchesType(soap, &d__ProbeResponse);
	soap_default___d__Probe(soap, &soap_tmp___d__Probe);
	soap->encodingStyle = NULL;
	if (!soap_get___d__Probe(soap, &soap_tmp___d__Probe, "-d:Probe", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __d__Probe(soap, soap_tmp___d__Probe.d__Probe, &d__ProbeResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_d__ProbeMatchesType(soap, &d__ProbeResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_d__ProbeMatchesType(soap, &d__ProbeResponse, "d:ProbeMatches", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_d__ProbeMatchesType(soap, &d__ProbeResponse, "d:ProbeMatches", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

#ifdef __cplusplus
}
#endif

#if defined(__BORLANDC__)
#pragma option pop
#pragma option pop
#endif

/* End of soapServer.c */
