#ifndef __LINUX_I2C_HX8526_H
#define __LINUX_I2C_HX8526_H

/* linux/i2c/hx8526.h */

typedef enum
{
	HX8526_FAMILY_0,
	HX8526_FAMILY_1,
	HX8526_FAMILY_2,

	HX8526_FAMILY_END,
} hx8526_product_family_t;

struct hx8526_fix_data {
	u8	x_invert;
	u8	y_invert;
	u8	x_rescale;
	u8	y_rescale;
	u16	x_min;
	u16	x_max;
	u16	y_min;
	u16	y_max;

	u8	family_code;
	u8	reserved1;
	u16	reserved2;
};

struct hx8526_platform_data {
	struct hx8526_fix_data	fix[HX8526_FAMILY_END];

	int (*get_pendown_state)(void);
	void (*clear_penirq)(void);
	int (*init_platform_hw)(void);
	void (*exit_platform_hw)(void);
};

#endif
