
#ifndef _DEVICECFGFILE_H_
#define _DEVICECFGFILE_H_

#include "cjson/cJSON.h"
#include "GeneralDef.h"

/**   @class DeviceCfgFile
 *    @brief 豸ļ,Ϊ
 */
class DeviceCfgFile
{
public:
    static DeviceCfgFile& GetInstance();
    void SaveToFile();
    void ReadFromFile();
private:
    DeviceCfgFile();
    ~DeviceCfgFile();
    DeviceCfgFile(const DeviceCfgFile&);
    DeviceCfgFile& operator=(const DeviceCfgFile&);
    
    static cJSON* WriteDeviceToNode(const STRU_DEVICE_INFO& device, int nIndex);
    static BOOL ReadDeviceFromNode(const cJSON* pNode, PLOCAL_DEVICE_INFO pDevice, int* pIndex);

    const static char* c_strNode_Devices;               //ڵ

    const static char* c_strNode_DeviceID;              //豸IDڵ
    const static char* c_strNode_SerialNo;              //豸serial numberڵ
    const static char* c_strNode_ChanNum;               //豸channel numberڵ
    const static char* c_strNode_StartChan;             //豸start channel numberڵ
    const static char* c_strNode_AlarmInNum;            //豸alarm in numberڵ
    const static char* c_strNode_AlarmOutNum;           //豸alarm out numberڵ
    const static char* c_strNode_IPChanNum;             //豸ip channel numberڵ
    const static char* c_strNode_MirrorChanNum;         //豸ͨڵ
    const static char* c_strNode_StartMirrorChanNo;     //豸ʼͨŽڵ
    const static char* c_strNode_LocalNodeName;         //豸local device nodeڵ
    const static char* c_strNode_DeviceType;            //豸device typeڵ
    const static char* c_strNode_DiskNum;               //豸HD numberڵ
    const static char* c_strNode_LoginUserName;         //豸login user nameڵ
    const static char* c_strNode_LoginUserPwd;          //豸login user passwordڵ
    const static char* c_strNode_DeviceIP;              //豸device ipڵ
    const static char* c_strNode_DeviceMultiIP;         //豸multi-cast group addressڵ
    const static char* c_strNode_DevicePort;            //豸port numberڵ
    const static char* c_strNode_DeviceName;            //豸device nameڵ
    const static char* c_strNode_Chans;                 //豸channelsڵ
    const static char* c_strNode_LoginMode;             //豸LoginModeڵ
    const static char* c_strNode_Https;                 //豸Httpsڵ

    const static char* c_strNode_ChanID;                //豸channel idڵ
    const static char* c_strNode_DeviceIndex;           //豸device nameڵ
    const static char* c_strNode_ChanIndex;             //豸channel indexڵ
    const static char* c_strNode_ChanName;              //豸channel nameڵ
    const static char* c_strNode_Protocol;              //豸network protocolڵ
    const static char* c_strNode_PicResolution;         //豸pic resolutionڵ
    const static char* c_strNode_PicQuality;            //豸pic qualityڵ
    const static char* c_strNode_Enable;                //豸channel enableڵ
    const static char* c_strPreviewMode;                //豸priview modeڵ
    const static char* c_strPreviewProtocolType;        //豸priview protocol typeڵ
    const static char* c_strVideoCodingType;            //豸video coding typeڵ
    const static char* c_strStreamType;                 //豸ͽڵ
    const static char* c_strLinkMode;                   //豸ӷʽڵ
};

BOOL GetNodeVal_JSON(const cJSON* pFather, const char* strName, int* nVal);
BOOL GetNodeVal_JSON(const cJSON* pFather, const char* strName, char* strVal, int nLen);
#endif
