/* soapServer.c
   Generated by gSOAP 2.7.16 from onvif.h
   Copyright(C) 2000-2010, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif
#include "soapH.h"
#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) soapServer.c ver 2.7.16 2012-05-31 19:40:06 GMT")


SOAP_FMAC5 int SOAP_FMAC6 soap_serve(struct soap *soap)
{
#ifndef WITH_FASTCGI
	unsigned int k = soap->max_keep_alive;
#endif

	do
	{
#ifdef WITH_FASTCGI
		if (FCGI_Accept() < 0)
		{
			soap->error = SOAP_EOF;
			return soap_send_fault(soap);
		}
#endif

		soap_begin(soap);

#ifndef WITH_FASTCGI
		if (soap->max_keep_alive > 0 && !--k)
			soap->keep_alive = 0;
#endif

		if (soap_begin_recv(soap))
		{	if (soap->error < SOAP_STOP)
			{
#ifdef WITH_FASTCGI
				soap_send_fault(soap);
#else 
				return soap_send_fault(soap);
#endif
			}
			soap_closesock(soap);

			continue;
		}

		if (soap_envelope_begin_in(soap)
		 || soap_recv_header(soap)
		 || soap_body_begin_in(soap)
		 || soap_serve_request(soap)
		 || (soap->fserveloop && soap->fserveloop(soap)))
		{
#ifdef WITH_FASTCGI
			soap_send_fault(soap);
#else
			return soap_send_fault(soap);
#endif
		}

#ifdef WITH_FASTCGI
		soap_destroy(soap);
		soap_end(soap);
	} while (1);
#else
	} while (soap->keep_alive);
#endif
	return SOAP_OK;
}

#ifndef WITH_NOSERVEREQUEST
SOAP_FMAC5 int SOAP_FMAC6 soap_serve_request(struct soap *soap)
{
        _wsse__Security *security = soap_wsse_Security(soap);

	soap_peek_element(soap);
	if (!soap_match_tag(soap, soap->tag, "d:Hello"))
		return soap_serve___d__Hello(soap);
	if (!soap_match_tag(soap, soap->tag, "d:Bye"))
		return soap_serve___d__Bye(soap);
	if (!soap_match_tag(soap, soap->tag, "d:Probe"))
		return soap_serve___d__Probe(soap);
        if(!security) {
                if(CheckHttpAuthority(soap) == SOAP_ERR) {
                        soap->error = 401;
                        return soap->error;
                }
        } else {
                if(Security_header_verify(soap)) {
                        return soap->error;
                }
        }
	if (!soap_match_tag(soap, soap->tag, "tev:PullMessages"))
		return soap_serve___ns3__PullMessages(soap);
	if (!soap_match_tag(soap, soap->tag, "tev:SetSynchronizationPoint"))
		return soap_serve___ns3__SetSynchronizationPoint(soap);
	if (!soap_match_tag(soap, soap->tag, "tev:CreatePullPointSubscription"))
		return soap_serve___ns4__CreatePullPointSubscription(soap);
	if (!soap_match_tag(soap, soap->tag, "tev:GetEventProperties"))
		return soap_serve___ns4__GetEventProperties(soap);
	if (!soap_match_tag(soap, soap->tag, "wsnt:Renew"))
		return soap_serve___ns5__Renew(soap);
	if (!soap_match_tag(soap, soap->tag, "wsnt:Unsubscribe"))
		return soap_serve___ns5__Unsubscribe(soap);
	if (!soap_match_tag(soap, soap->tag, "wsnt:Subscribe"))
		return soap_serve___ns6__Subscribe(soap);
	if (!soap_match_tag(soap, soap->tag, "wsnt:Notify"))
		return soap_serve___ns7__Notify(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetDeviceInformation"))
		return soap_serve___tds__GetDeviceInformation(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetSystemDateAndTime"))
		return soap_serve___tds__SetSystemDateAndTime(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetSystemDateAndTime"))
		return soap_serve___tds__GetSystemDateAndTime(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetSystemFactoryDefault"))
		return soap_serve___tds__SetSystemFactoryDefault(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SystemReboot"))
		return soap_serve___tds__SystemReboot(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetSystemLog"))
		return soap_serve___tds__GetSystemLog(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetScopes"))
		return soap_serve___tds__GetScopes(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetScopes"))
		return soap_serve___tds__SetScopes(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:AddScopes"))
		return soap_serve___tds__AddScopes(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:RemoveScopes"))
		return soap_serve___tds__RemoveScopes(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetDiscoveryMode"))
		return soap_serve___tds__GetDiscoveryMode(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetDiscoveryMode"))
		return soap_serve___tds__SetDiscoveryMode(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetUsers"))
		return soap_serve___tds__GetUsers(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:CreateUsers"))
		return soap_serve___tds__CreateUsers(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:DeleteUsers"))
		return soap_serve___tds__DeleteUsers(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetUser"))
		return soap_serve___tds__SetUser(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetWsdlUrl"))
		return soap_serve___tds__GetWsdlUrl(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetCapabilities"))
		return soap_serve___tds__GetCapabilities(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetHostname"))
		return soap_serve___tds__GetHostname(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetHostname"))
		return soap_serve___tds__SetHostname(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetDNS"))
		return soap_serve___tds__GetDNS(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetDNS"))
		return soap_serve___tds__SetDNS(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetNTP"))
		return soap_serve___tds__GetNTP(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetNTP"))
		return soap_serve___tds__SetNTP(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetDynamicDNS"))
		return soap_serve___tds__GetDynamicDNS(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetDynamicDNS"))
		return soap_serve___tds__SetDynamicDNS(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetNetworkInterfaces"))
		return soap_serve___tds__GetNetworkInterfaces(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetNetworkInterfaces"))
		return soap_serve___tds__SetNetworkInterfaces(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetNetworkProtocols"))
		return soap_serve___tds__GetNetworkProtocols(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetNetworkProtocols"))
		return soap_serve___tds__SetNetworkProtocols(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetNetworkDefaultGateway"))
		return soap_serve___tds__GetNetworkDefaultGateway(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetNetworkDefaultGateway"))
		return soap_serve___tds__SetNetworkDefaultGateway(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetZeroConfiguration"))
		return soap_serve___tds__GetZeroConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetZeroConfiguration"))
		return soap_serve___tds__SetZeroConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetRelayOutputs"))
		return soap_serve___tds__GetRelayOutputs(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetRelayOutputSettings"))
		return soap_serve___tds__SetRelayOutputSettings(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetRelayOutputState"))
		return soap_serve___tds__SetRelayOutputState(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GetConfigurations"))
		return soap_serve___tptz__GetConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GetPresets"))
		return soap_serve___tptz__GetPresets(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:SetPreset"))
		return soap_serve___tptz__SetPreset(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:RemovePreset"))
		return soap_serve___tptz__RemovePreset(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GotoPreset"))
		return soap_serve___tptz__GotoPreset(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GetStatus"))
		return soap_serve___tptz__GetStatus(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GetConfiguration"))
		return soap_serve___tptz__GetConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GetNodes"))
		return soap_serve___tptz__GetNodes(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GetNode"))
		return soap_serve___tptz__GetNode(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:SetConfiguration"))
		return soap_serve___tptz__SetConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GetConfigurationOptions"))
		return soap_serve___tptz__GetConfigurationOptions(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GotoHomePosition"))
		return soap_serve___tptz__GotoHomePosition(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:SetHomePosition"))
		return soap_serve___tptz__SetHomePosition(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:ContinuousMove"))
		return soap_serve___tptz__ContinuousMove(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:AbsoluteMove"))
		return soap_serve___tptz__AbsoluteMove(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:Stop"))
		return soap_serve___tptz__Stop(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GetConfigurations"))
		return soap_serve___tptz__GetConfigurations_(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GetPresets"))
		return soap_serve___tptz__GetPresets_(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:SetPreset"))
		return soap_serve___tptz__SetPreset_(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:RemovePreset"))
		return soap_serve___tptz__RemovePreset_(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GotoPreset"))
		return soap_serve___tptz__GotoPreset_(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GetStatus"))
		return soap_serve___tptz__GetStatus_(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GetConfiguration"))
		return soap_serve___tptz__GetConfiguration_(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GetNodes"))
		return soap_serve___tptz__GetNodes_(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GetNode"))
		return soap_serve___tptz__GetNode_(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:SetConfiguration"))
		return soap_serve___tptz__SetConfiguration_(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GetConfigurationOptions"))
		return soap_serve___tptz__GetConfigurationOptions_(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:GotoHomePosition"))
		return soap_serve___tptz__GotoHomePosition_(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:SetHomePosition"))
		return soap_serve___tptz__SetHomePosition_(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:ContinuousMove"))
		return soap_serve___tptz__ContinuousMove_(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:AbsoluteMove"))
		return soap_serve___tptz__AbsoluteMove_(soap);
	if (!soap_match_tag(soap, soap->tag, "tptz:Stop"))
		return soap_serve___tptz__Stop_(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetVideoSources"))
		return soap_serve___trt__GetVideoSources(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetAudioSources"))
		return soap_serve___trt__GetAudioSources(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:CreateProfile"))
		return soap_serve___trt__CreateProfile(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetProfile"))
		return soap_serve___trt__GetProfile(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetProfiles"))
		return soap_serve___trt__GetProfiles(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:AddVideoEncoderConfiguration"))
		return soap_serve___trt__AddVideoEncoderConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:AddVideoSourceConfiguration"))
		return soap_serve___trt__AddVideoSourceConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:AddAudioEncoderConfiguration"))
		return soap_serve___trt__AddAudioEncoderConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:AddAudioSourceConfiguration"))
		return soap_serve___trt__AddAudioSourceConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:AddPTZConfiguration"))
		return soap_serve___trt__AddPTZConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:AddMetadataConfiguration"))
		return soap_serve___trt__AddMetadataConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:RemoveVideoEncoderConfiguration"))
		return soap_serve___trt__RemoveVideoEncoderConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:RemoveVideoSourceConfiguration"))
		return soap_serve___trt__RemoveVideoSourceConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:RemoveAudioEncoderConfiguration"))
		return soap_serve___trt__RemoveAudioEncoderConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:RemoveAudioSourceConfiguration"))
		return soap_serve___trt__RemoveAudioSourceConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:RemovePTZConfiguration"))
		return soap_serve___trt__RemovePTZConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:RemoveMetadataConfiguration"))
		return soap_serve___trt__RemoveMetadataConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:DeleteProfile"))
		return soap_serve___trt__DeleteProfile(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetVideoSourceConfigurations"))
		return soap_serve___trt__GetVideoSourceConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetVideoEncoderConfigurations"))
		return soap_serve___trt__GetVideoEncoderConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetAudioSourceConfigurations"))
		return soap_serve___trt__GetAudioSourceConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetAudioEncoderConfigurations"))
		return soap_serve___trt__GetAudioEncoderConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetMetadataConfigurations"))
		return soap_serve___trt__GetMetadataConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetVideoSourceConfiguration"))
		return soap_serve___trt__GetVideoSourceConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetVideoEncoderConfiguration"))
		return soap_serve___trt__GetVideoEncoderConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetAudioSourceConfiguration"))
		return soap_serve___trt__GetAudioSourceConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetAudioEncoderConfiguration"))
		return soap_serve___trt__GetAudioEncoderConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetMetadataConfiguration"))
		return soap_serve___trt__GetMetadataConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetCompatibleVideoEncoderConfigurations"))
		return soap_serve___trt__GetCompatibleVideoEncoderConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetCompatibleVideoSourceConfigurations"))
		return soap_serve___trt__GetCompatibleVideoSourceConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetCompatibleAudioEncoderConfigurations"))
		return soap_serve___trt__GetCompatibleAudioEncoderConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetCompatibleAudioSourceConfigurations"))
		return soap_serve___trt__GetCompatibleAudioSourceConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetCompatibleMetadataConfigurations"))
		return soap_serve___trt__GetCompatibleMetadataConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:SetVideoSourceConfiguration"))
		return soap_serve___trt__SetVideoSourceConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:SetVideoEncoderConfiguration"))
		return soap_serve___trt__SetVideoEncoderConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:SetAudioSourceConfiguration"))
		return soap_serve___trt__SetAudioSourceConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:SetAudioEncoderConfiguration"))
		return soap_serve___trt__SetAudioEncoderConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:SetMetadataConfiguration"))
		return soap_serve___trt__SetMetadataConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetVideoSourceConfigurationOptions"))
		return soap_serve___trt__GetVideoSourceConfigurationOptions(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetVideoEncoderConfigurationOptions"))
		return soap_serve___trt__GetVideoEncoderConfigurationOptions(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetAudioSourceConfigurationOptions"))
		return soap_serve___trt__GetAudioSourceConfigurationOptions(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetAudioEncoderConfigurationOptions"))
		return soap_serve___trt__GetAudioEncoderConfigurationOptions(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetMetadataConfigurationOptions"))
		return soap_serve___trt__GetMetadataConfigurationOptions(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetGuaranteedNumberOfVideoEncoderInstances"))
		return soap_serve___trt__GetGuaranteedNumberOfVideoEncoderInstances(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetStreamUri"))
		return soap_serve___trt__GetStreamUri(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:SetSynchronizationPoint"))
		return soap_serve___trt__SetSynchronizationPoint(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetSnapshotUri"))
		return soap_serve___trt__GetSnapshotUri(soap);
	return soap->error = SOAP_NO_METHOD;
}
#endif

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___d__Hello(struct soap *soap)
{	struct __d__Hello soap_tmp___d__Hello;
	struct d__ResolveType d__HelloResponse;
	soap_default_d__ResolveType(soap, &d__HelloResponse);
	soap_default___d__Hello(soap, &soap_tmp___d__Hello);
	soap->encodingStyle = NULL;
	if (!soap_get___d__Hello(soap, &soap_tmp___d__Hello, "-d:Hello", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __d__Hello(soap, soap_tmp___d__Hello.d__Hello, &d__HelloResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_d__ResolveType(soap, &d__HelloResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_d__ResolveType(soap, &d__HelloResponse, "d:HelloResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_d__ResolveType(soap, &d__HelloResponse, "d:HelloResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___d__Bye(struct soap *soap)
{	struct __d__Bye soap_tmp___d__Bye;
	struct d__ResolveType d__ByeResponse;
	soap_default_d__ResolveType(soap, &d__ByeResponse);
	soap_default___d__Bye(soap, &soap_tmp___d__Bye);
	soap->encodingStyle = NULL;
	if (!soap_get___d__Bye(soap, &soap_tmp___d__Bye, "-d:Bye", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __d__Bye(soap, soap_tmp___d__Bye.d__Bye, &d__ByeResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_d__ResolveType(soap, &d__ByeResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_d__ResolveType(soap, &d__ByeResponse, "d:ByeResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_d__ResolveType(soap, &d__ByeResponse, "d:ByeResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___d__Probe(struct soap *soap)
{	struct __d__Probe soap_tmp___d__Probe;
	struct d__ProbeMatchesType d__ProbeMatches;
	soap_default_d__ProbeMatchesType(soap, &d__ProbeMatches);
	soap_default___d__Probe(soap, &soap_tmp___d__Probe);
	soap->encodingStyle = NULL;
	if (!soap_get___d__Probe(soap, &soap_tmp___d__Probe, "-d:Probe", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __d__Probe(soap, soap_tmp___d__Probe.d__Probe, &d__ProbeMatches);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_d__ProbeMatchesType(soap, &d__ProbeMatches);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_d__ProbeMatchesType(soap, &d__ProbeMatches, "d:ProbeMatches", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_d__ProbeMatchesType(soap, &d__ProbeMatches, "d:ProbeMatches", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___ns3__PullMessages(struct soap *soap)
{	struct __ns3__PullMessages soap_tmp___ns3__PullMessages;
	struct _tev__PullMessagesResponse tev__PullMessagesResponse;
	soap_default__tev__PullMessagesResponse(soap, &tev__PullMessagesResponse);
	soap_default___ns3__PullMessages(soap, &soap_tmp___ns3__PullMessages);
	soap->encodingStyle = NULL;
	if (!soap_get___ns3__PullMessages(soap, &soap_tmp___ns3__PullMessages, "-ns3:PullMessages", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __ns3__PullMessages(soap, soap_tmp___ns3__PullMessages.tev__PullMessages, &tev__PullMessagesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tev__PullMessagesResponse(soap, &tev__PullMessagesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tev__PullMessagesResponse(soap, &tev__PullMessagesResponse, "tev:PullMessagesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tev__PullMessagesResponse(soap, &tev__PullMessagesResponse, "tev:PullMessagesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___ns3__SetSynchronizationPoint(struct soap *soap)
{	struct __ns3__SetSynchronizationPoint soap_tmp___ns3__SetSynchronizationPoint;
	struct _tev__SetSynchronizationPointResponse tev__SetSynchronizationPointResponse;
	soap_default__tev__SetSynchronizationPointResponse(soap, &tev__SetSynchronizationPointResponse);
	soap_default___ns3__SetSynchronizationPoint(soap, &soap_tmp___ns3__SetSynchronizationPoint);
	soap->encodingStyle = NULL;
	if (!soap_get___ns3__SetSynchronizationPoint(soap, &soap_tmp___ns3__SetSynchronizationPoint, "-ns3:SetSynchronizationPoint", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __ns3__SetSynchronizationPoint(soap, soap_tmp___ns3__SetSynchronizationPoint.tev__SetSynchronizationPoint, &tev__SetSynchronizationPointResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tev__SetSynchronizationPointResponse(soap, &tev__SetSynchronizationPointResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tev__SetSynchronizationPointResponse(soap, &tev__SetSynchronizationPointResponse, "tev:SetSynchronizationPointResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tev__SetSynchronizationPointResponse(soap, &tev__SetSynchronizationPointResponse, "tev:SetSynchronizationPointResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___ns4__CreatePullPointSubscription(struct soap *soap)
{	struct __ns4__CreatePullPointSubscription soap_tmp___ns4__CreatePullPointSubscription;
	struct _tev__CreatePullPointSubscriptionResponse tev__CreatePullPointSubscriptionResponse;
	soap_default__tev__CreatePullPointSubscriptionResponse(soap, &tev__CreatePullPointSubscriptionResponse);
	soap_default___ns4__CreatePullPointSubscription(soap, &soap_tmp___ns4__CreatePullPointSubscription);
	soap->encodingStyle = NULL;
	if (!soap_get___ns4__CreatePullPointSubscription(soap, &soap_tmp___ns4__CreatePullPointSubscription, "-ns4:CreatePullPointSubscription", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __ns4__CreatePullPointSubscription(soap, soap_tmp___ns4__CreatePullPointSubscription.tev__CreatePullPointSubscription, &tev__CreatePullPointSubscriptionResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tev__CreatePullPointSubscriptionResponse(soap, &tev__CreatePullPointSubscriptionResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tev__CreatePullPointSubscriptionResponse(soap, &tev__CreatePullPointSubscriptionResponse, "tev:CreatePullPointSubscriptionResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tev__CreatePullPointSubscriptionResponse(soap, &tev__CreatePullPointSubscriptionResponse, "tev:CreatePullPointSubscriptionResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___ns4__GetEventProperties(struct soap *soap)
{	struct __ns4__GetEventProperties soap_tmp___ns4__GetEventProperties;
	struct _tev__GetEventPropertiesResponse tev__GetEventPropertiesResponse;
	soap_default__tev__GetEventPropertiesResponse(soap, &tev__GetEventPropertiesResponse);
	soap_default___ns4__GetEventProperties(soap, &soap_tmp___ns4__GetEventProperties);
	soap->encodingStyle = NULL;
	if (!soap_get___ns4__GetEventProperties(soap, &soap_tmp___ns4__GetEventProperties, "-ns4:GetEventProperties", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __ns4__GetEventProperties(soap, soap_tmp___ns4__GetEventProperties.tev__GetEventProperties, &tev__GetEventPropertiesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tev__GetEventPropertiesResponse(soap, &tev__GetEventPropertiesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tev__GetEventPropertiesResponse(soap, &tev__GetEventPropertiesResponse, "tev:GetEventPropertiesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tev__GetEventPropertiesResponse(soap, &tev__GetEventPropertiesResponse, "tev:GetEventPropertiesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___ns5__Renew(struct soap *soap)
{	struct __ns5__Renew soap_tmp___ns5__Renew;
	struct _wsnt__RenewResponse wsnt__RenewResponse;
	soap_default__wsnt__RenewResponse(soap, &wsnt__RenewResponse);
	soap_default___ns5__Renew(soap, &soap_tmp___ns5__Renew);
	soap->encodingStyle = NULL;
	if (!soap_get___ns5__Renew(soap, &soap_tmp___ns5__Renew, "-ns5:Renew", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __ns5__Renew(soap, soap_tmp___ns5__Renew.wsnt__Renew, &wsnt__RenewResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__wsnt__RenewResponse(soap, &wsnt__RenewResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__wsnt__RenewResponse(soap, &wsnt__RenewResponse, "wsnt:RenewResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__wsnt__RenewResponse(soap, &wsnt__RenewResponse, "wsnt:RenewResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___ns5__Unsubscribe(struct soap *soap)
{	struct __ns5__Unsubscribe soap_tmp___ns5__Unsubscribe;
	struct _wsnt__UnsubscribeResponse wsnt__UnsubscribeResponse;
	soap_default__wsnt__UnsubscribeResponse(soap, &wsnt__UnsubscribeResponse);
	soap_default___ns5__Unsubscribe(soap, &soap_tmp___ns5__Unsubscribe);
	soap->encodingStyle = NULL;
	if (!soap_get___ns5__Unsubscribe(soap, &soap_tmp___ns5__Unsubscribe, "-ns5:Unsubscribe", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __ns5__Unsubscribe(soap, soap_tmp___ns5__Unsubscribe.wsnt__Unsubscribe, &wsnt__UnsubscribeResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__wsnt__UnsubscribeResponse(soap, &wsnt__UnsubscribeResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__wsnt__UnsubscribeResponse(soap, &wsnt__UnsubscribeResponse, "wsnt:UnsubscribeResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__wsnt__UnsubscribeResponse(soap, &wsnt__UnsubscribeResponse, "wsnt:UnsubscribeResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___ns6__Subscribe(struct soap *soap)
{	struct __ns6__Subscribe soap_tmp___ns6__Subscribe;
	struct _wsnt__SubscribeResponse wsnt__SubscribeResponse;
	soap_default__wsnt__SubscribeResponse(soap, &wsnt__SubscribeResponse);
	soap_default___ns6__Subscribe(soap, &soap_tmp___ns6__Subscribe);
	soap->encodingStyle = NULL;
	if (!soap_get___ns6__Subscribe(soap, &soap_tmp___ns6__Subscribe, "-ns6:Subscribe", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __ns6__Subscribe(soap, soap_tmp___ns6__Subscribe.wsnt__Subscribe, &wsnt__SubscribeResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__wsnt__SubscribeResponse(soap, &wsnt__SubscribeResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__wsnt__SubscribeResponse(soap, &wsnt__SubscribeResponse, "wsnt:SubscribeResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__wsnt__SubscribeResponse(soap, &wsnt__SubscribeResponse, "wsnt:SubscribeResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___ns7__Notify(struct soap *soap)
{	struct __ns7__Notify soap_tmp___ns7__Notify;
	soap_default___ns7__Notify(soap, &soap_tmp___ns7__Notify);
	soap->encodingStyle = NULL;
	if (!soap_get___ns7__Notify(soap, &soap_tmp___ns7__Notify, "-ns7:Notify", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __ns7__Notify(soap, soap_tmp___ns7__Notify.wsnt__Notify);
	if (soap->error)
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetDeviceInformation(struct soap *soap)
{	struct __tds__GetDeviceInformation soap_tmp___tds__GetDeviceInformation;
	struct _tds__GetDeviceInformationResponse tds__GetDeviceInformationResponse;
	soap_default__tds__GetDeviceInformationResponse(soap, &tds__GetDeviceInformationResponse);
	soap_default___tds__GetDeviceInformation(soap, &soap_tmp___tds__GetDeviceInformation);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetDeviceInformation(soap, &soap_tmp___tds__GetDeviceInformation, "-tds:GetDeviceInformation", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetDeviceInformation(soap, soap_tmp___tds__GetDeviceInformation.tds__GetDeviceInformation, &tds__GetDeviceInformationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetDeviceInformationResponse(soap, &tds__GetDeviceInformationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetDeviceInformationResponse(soap, &tds__GetDeviceInformationResponse, "tds:GetDeviceInformationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetDeviceInformationResponse(soap, &tds__GetDeviceInformationResponse, "tds:GetDeviceInformationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetSystemDateAndTime(struct soap *soap)
{	struct __tds__SetSystemDateAndTime soap_tmp___tds__SetSystemDateAndTime;
	struct _tds__SetSystemDateAndTimeResponse tds__SetSystemDateAndTimeResponse;
	soap_default__tds__SetSystemDateAndTimeResponse(soap, &tds__SetSystemDateAndTimeResponse);
	soap_default___tds__SetSystemDateAndTime(soap, &soap_tmp___tds__SetSystemDateAndTime);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetSystemDateAndTime(soap, &soap_tmp___tds__SetSystemDateAndTime, "-tds:SetSystemDateAndTime", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetSystemDateAndTime(soap, soap_tmp___tds__SetSystemDateAndTime.tds__SetSystemDateAndTime, &tds__SetSystemDateAndTimeResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetSystemDateAndTimeResponse(soap, &tds__SetSystemDateAndTimeResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetSystemDateAndTimeResponse(soap, &tds__SetSystemDateAndTimeResponse, "tds:SetSystemDateAndTimeResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetSystemDateAndTimeResponse(soap, &tds__SetSystemDateAndTimeResponse, "tds:SetSystemDateAndTimeResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetSystemDateAndTime(struct soap *soap)
{	struct __tds__GetSystemDateAndTime soap_tmp___tds__GetSystemDateAndTime;
	struct _tds__GetSystemDateAndTimeResponse tds__GetSystemDateAndTimeResponse;
	soap_default__tds__GetSystemDateAndTimeResponse(soap, &tds__GetSystemDateAndTimeResponse);
	soap_default___tds__GetSystemDateAndTime(soap, &soap_tmp___tds__GetSystemDateAndTime);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetSystemDateAndTime(soap, &soap_tmp___tds__GetSystemDateAndTime, "-tds:GetSystemDateAndTime", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetSystemDateAndTime(soap, soap_tmp___tds__GetSystemDateAndTime.tds__GetSystemDateAndTime, &tds__GetSystemDateAndTimeResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetSystemDateAndTimeResponse(soap, &tds__GetSystemDateAndTimeResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetSystemDateAndTimeResponse(soap, &tds__GetSystemDateAndTimeResponse, "tds:GetSystemDateAndTimeResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetSystemDateAndTimeResponse(soap, &tds__GetSystemDateAndTimeResponse, "tds:GetSystemDateAndTimeResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetSystemFactoryDefault(struct soap *soap)
{	struct __tds__SetSystemFactoryDefault soap_tmp___tds__SetSystemFactoryDefault;
	struct _tds__SetSystemFactoryDefaultResponse tds__SetSystemFactoryDefaultResponse;
	soap_default__tds__SetSystemFactoryDefaultResponse(soap, &tds__SetSystemFactoryDefaultResponse);
	soap_default___tds__SetSystemFactoryDefault(soap, &soap_tmp___tds__SetSystemFactoryDefault);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetSystemFactoryDefault(soap, &soap_tmp___tds__SetSystemFactoryDefault, "-tds:SetSystemFactoryDefault", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetSystemFactoryDefault(soap, soap_tmp___tds__SetSystemFactoryDefault.tds__SetSystemFactoryDefault, &tds__SetSystemFactoryDefaultResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetSystemFactoryDefaultResponse(soap, &tds__SetSystemFactoryDefaultResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetSystemFactoryDefaultResponse(soap, &tds__SetSystemFactoryDefaultResponse, "tds:SetSystemFactoryDefaultResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetSystemFactoryDefaultResponse(soap, &tds__SetSystemFactoryDefaultResponse, "tds:SetSystemFactoryDefaultResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SystemReboot(struct soap *soap)
{	struct __tds__SystemReboot soap_tmp___tds__SystemReboot;
	struct _tds__SystemRebootResponse tds__SystemRebootResponse;
	soap_default__tds__SystemRebootResponse(soap, &tds__SystemRebootResponse);
	soap_default___tds__SystemReboot(soap, &soap_tmp___tds__SystemReboot);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SystemReboot(soap, &soap_tmp___tds__SystemReboot, "-tds:SystemReboot", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SystemReboot(soap, soap_tmp___tds__SystemReboot.tds__SystemReboot, &tds__SystemRebootResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SystemRebootResponse(soap, &tds__SystemRebootResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SystemRebootResponse(soap, &tds__SystemRebootResponse, "tds:SystemRebootResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SystemRebootResponse(soap, &tds__SystemRebootResponse, "tds:SystemRebootResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetSystemLog(struct soap *soap)
{	struct __tds__GetSystemLog soap_tmp___tds__GetSystemLog;
	struct _tds__GetSystemLogResponse tds__GetSystemLogResponse;
	soap_default__tds__GetSystemLogResponse(soap, &tds__GetSystemLogResponse);
	soap_default___tds__GetSystemLog(soap, &soap_tmp___tds__GetSystemLog);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetSystemLog(soap, &soap_tmp___tds__GetSystemLog, "-tds:GetSystemLog", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetSystemLog(soap, soap_tmp___tds__GetSystemLog.tds__GetSystemLog, &tds__GetSystemLogResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetSystemLogResponse(soap, &tds__GetSystemLogResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetSystemLogResponse(soap, &tds__GetSystemLogResponse, "tds:GetSystemLogResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetSystemLogResponse(soap, &tds__GetSystemLogResponse, "tds:GetSystemLogResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetScopes(struct soap *soap)
{	struct __tds__GetScopes soap_tmp___tds__GetScopes;
	struct _tds__GetScopesResponse tds__GetScopesResponse;
	soap_default__tds__GetScopesResponse(soap, &tds__GetScopesResponse);
	soap_default___tds__GetScopes(soap, &soap_tmp___tds__GetScopes);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetScopes(soap, &soap_tmp___tds__GetScopes, "-tds:GetScopes", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetScopes(soap, soap_tmp___tds__GetScopes.tds__GetScopes, &tds__GetScopesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetScopesResponse(soap, &tds__GetScopesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetScopesResponse(soap, &tds__GetScopesResponse, "tds:GetScopesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetScopesResponse(soap, &tds__GetScopesResponse, "tds:GetScopesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetScopes(struct soap *soap)
{	struct __tds__SetScopes soap_tmp___tds__SetScopes;
	struct _tds__SetScopesResponse tds__SetScopesResponse;
	soap_default__tds__SetScopesResponse(soap, &tds__SetScopesResponse);
	soap_default___tds__SetScopes(soap, &soap_tmp___tds__SetScopes);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetScopes(soap, &soap_tmp___tds__SetScopes, "-tds:SetScopes", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetScopes(soap, soap_tmp___tds__SetScopes.tds__SetScopes, &tds__SetScopesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetScopesResponse(soap, &tds__SetScopesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetScopesResponse(soap, &tds__SetScopesResponse, "tds:SetScopesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetScopesResponse(soap, &tds__SetScopesResponse, "tds:SetScopesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__AddScopes(struct soap *soap)
{	struct __tds__AddScopes soap_tmp___tds__AddScopes;
	struct _tds__AddScopesResponse tds__AddScopesResponse;
	soap_default__tds__AddScopesResponse(soap, &tds__AddScopesResponse);
	soap_default___tds__AddScopes(soap, &soap_tmp___tds__AddScopes);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__AddScopes(soap, &soap_tmp___tds__AddScopes, "-tds:AddScopes", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__AddScopes(soap, soap_tmp___tds__AddScopes.tds__AddScopes, &tds__AddScopesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__AddScopesResponse(soap, &tds__AddScopesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__AddScopesResponse(soap, &tds__AddScopesResponse, "tds:AddScopesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__AddScopesResponse(soap, &tds__AddScopesResponse, "tds:AddScopesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
        if(soap->hello_callback) soap->hello_callback();
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__RemoveScopes(struct soap *soap)
{	struct __tds__RemoveScopes soap_tmp___tds__RemoveScopes;
	struct _tds__RemoveScopesResponse tds__RemoveScopesResponse;
	soap_default__tds__RemoveScopesResponse(soap, &tds__RemoveScopesResponse);
	soap_default___tds__RemoveScopes(soap, &soap_tmp___tds__RemoveScopes);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__RemoveScopes(soap, &soap_tmp___tds__RemoveScopes, "-tds:RemoveScopes", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__RemoveScopes(soap, soap_tmp___tds__RemoveScopes.tds__RemoveScopes, &tds__RemoveScopesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__RemoveScopesResponse(soap, &tds__RemoveScopesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__RemoveScopesResponse(soap, &tds__RemoveScopesResponse, "tds:RemoveScopesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__RemoveScopesResponse(soap, &tds__RemoveScopesResponse, "tds:RemoveScopesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
        if(soap->hello_callback) soap->hello_callback();
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetDiscoveryMode(struct soap *soap)
{	struct __tds__GetDiscoveryMode soap_tmp___tds__GetDiscoveryMode;
	struct _tds__GetDiscoveryModeResponse tds__GetDiscoveryModeResponse;
	soap_default__tds__GetDiscoveryModeResponse(soap, &tds__GetDiscoveryModeResponse);
	soap_default___tds__GetDiscoveryMode(soap, &soap_tmp___tds__GetDiscoveryMode);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetDiscoveryMode(soap, &soap_tmp___tds__GetDiscoveryMode, "-tds:GetDiscoveryMode", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetDiscoveryMode(soap, soap_tmp___tds__GetDiscoveryMode.tds__GetDiscoveryMode, &tds__GetDiscoveryModeResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetDiscoveryModeResponse(soap, &tds__GetDiscoveryModeResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetDiscoveryModeResponse(soap, &tds__GetDiscoveryModeResponse, "tds:GetDiscoveryModeResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetDiscoveryModeResponse(soap, &tds__GetDiscoveryModeResponse, "tds:GetDiscoveryModeResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetDiscoveryMode(struct soap *soap)
{	struct __tds__SetDiscoveryMode soap_tmp___tds__SetDiscoveryMode;
	struct _tds__SetDiscoveryModeResponse tds__SetDiscoveryModeResponse;
	soap_default__tds__SetDiscoveryModeResponse(soap, &tds__SetDiscoveryModeResponse);
	soap_default___tds__SetDiscoveryMode(soap, &soap_tmp___tds__SetDiscoveryMode);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetDiscoveryMode(soap, &soap_tmp___tds__SetDiscoveryMode, "-tds:SetDiscoveryMode", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetDiscoveryMode(soap, soap_tmp___tds__SetDiscoveryMode.tds__SetDiscoveryMode, &tds__SetDiscoveryModeResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetDiscoveryModeResponse(soap, &tds__SetDiscoveryModeResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetDiscoveryModeResponse(soap, &tds__SetDiscoveryModeResponse, "tds:SetDiscoveryModeResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetDiscoveryModeResponse(soap, &tds__SetDiscoveryModeResponse, "tds:SetDiscoveryModeResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetUsers(struct soap *soap)
{	struct __tds__GetUsers soap_tmp___tds__GetUsers;
	struct _tds__GetUsersResponse tds__GetUsersResponse;
	soap_default__tds__GetUsersResponse(soap, &tds__GetUsersResponse);
	soap_default___tds__GetUsers(soap, &soap_tmp___tds__GetUsers);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetUsers(soap, &soap_tmp___tds__GetUsers, "-tds:GetUsers", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetUsers(soap, soap_tmp___tds__GetUsers.tds__GetUsers, &tds__GetUsersResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetUsersResponse(soap, &tds__GetUsersResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetUsersResponse(soap, &tds__GetUsersResponse, "tds:GetUsersResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetUsersResponse(soap, &tds__GetUsersResponse, "tds:GetUsersResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__CreateUsers(struct soap *soap)
{	struct __tds__CreateUsers soap_tmp___tds__CreateUsers;
	struct _tds__CreateUsersResponse tds__CreateUsersResponse;
	soap_default__tds__CreateUsersResponse(soap, &tds__CreateUsersResponse);
	soap_default___tds__CreateUsers(soap, &soap_tmp___tds__CreateUsers);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__CreateUsers(soap, &soap_tmp___tds__CreateUsers, "-tds:CreateUsers", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__CreateUsers(soap, soap_tmp___tds__CreateUsers.tds__CreateUsers, &tds__CreateUsersResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__CreateUsersResponse(soap, &tds__CreateUsersResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__CreateUsersResponse(soap, &tds__CreateUsersResponse, "tds:CreateUsersResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__CreateUsersResponse(soap, &tds__CreateUsersResponse, "tds:CreateUsersResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__DeleteUsers(struct soap *soap)
{	struct __tds__DeleteUsers soap_tmp___tds__DeleteUsers;
	struct _tds__DeleteUsersResponse tds__DeleteUsersResponse;
	soap_default__tds__DeleteUsersResponse(soap, &tds__DeleteUsersResponse);
	soap_default___tds__DeleteUsers(soap, &soap_tmp___tds__DeleteUsers);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__DeleteUsers(soap, &soap_tmp___tds__DeleteUsers, "-tds:DeleteUsers", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__DeleteUsers(soap, soap_tmp___tds__DeleteUsers.tds__DeleteUsers, &tds__DeleteUsersResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__DeleteUsersResponse(soap, &tds__DeleteUsersResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__DeleteUsersResponse(soap, &tds__DeleteUsersResponse, "tds:DeleteUsersResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__DeleteUsersResponse(soap, &tds__DeleteUsersResponse, "tds:DeleteUsersResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetUser(struct soap *soap)
{	struct __tds__SetUser soap_tmp___tds__SetUser;
	struct _tds__SetUserResponse tds__SetUserResponse;
	soap_default__tds__SetUserResponse(soap, &tds__SetUserResponse);
	soap_default___tds__SetUser(soap, &soap_tmp___tds__SetUser);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetUser(soap, &soap_tmp___tds__SetUser, "-tds:SetUser", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetUser(soap, soap_tmp___tds__SetUser.tds__SetUser, &tds__SetUserResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetUserResponse(soap, &tds__SetUserResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetUserResponse(soap, &tds__SetUserResponse, "tds:SetUserResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetUserResponse(soap, &tds__SetUserResponse, "tds:SetUserResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetWsdlUrl(struct soap *soap)
{	struct __tds__GetWsdlUrl soap_tmp___tds__GetWsdlUrl;
	struct _tds__GetWsdlUrlResponse tds__GetWsdlUrlResponse;
	soap_default__tds__GetWsdlUrlResponse(soap, &tds__GetWsdlUrlResponse);
	soap_default___tds__GetWsdlUrl(soap, &soap_tmp___tds__GetWsdlUrl);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetWsdlUrl(soap, &soap_tmp___tds__GetWsdlUrl, "-tds:GetWsdlUrl", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetWsdlUrl(soap, soap_tmp___tds__GetWsdlUrl.tds__GetWsdlUrl, &tds__GetWsdlUrlResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetWsdlUrlResponse(soap, &tds__GetWsdlUrlResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetWsdlUrlResponse(soap, &tds__GetWsdlUrlResponse, "tds:GetWsdlUrlResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetWsdlUrlResponse(soap, &tds__GetWsdlUrlResponse, "tds:GetWsdlUrlResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetCapabilities(struct soap *soap)
{	struct __tds__GetCapabilities soap_tmp___tds__GetCapabilities;
	struct _tds__GetCapabilitiesResponse tds__GetCapabilitiesResponse;
	soap_default__tds__GetCapabilitiesResponse(soap, &tds__GetCapabilitiesResponse);
	soap_default___tds__GetCapabilities(soap, &soap_tmp___tds__GetCapabilities);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetCapabilities(soap, &soap_tmp___tds__GetCapabilities, "-tds:GetCapabilities", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetCapabilities(soap, soap_tmp___tds__GetCapabilities.tds__GetCapabilities, &tds__GetCapabilitiesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetCapabilitiesResponse(soap, &tds__GetCapabilitiesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetCapabilitiesResponse(soap, &tds__GetCapabilitiesResponse, "tds:GetCapabilitiesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetCapabilitiesResponse(soap, &tds__GetCapabilitiesResponse, "tds:GetCapabilitiesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetHostname(struct soap *soap)
{	struct __tds__GetHostname soap_tmp___tds__GetHostname;
	struct _tds__GetHostnameResponse tds__GetHostnameResponse;
	soap_default__tds__GetHostnameResponse(soap, &tds__GetHostnameResponse);
	soap_default___tds__GetHostname(soap, &soap_tmp___tds__GetHostname);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetHostname(soap, &soap_tmp___tds__GetHostname, "-tds:GetHostname", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetHostname(soap, soap_tmp___tds__GetHostname.tds__GetHostname, &tds__GetHostnameResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetHostnameResponse(soap, &tds__GetHostnameResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetHostnameResponse(soap, &tds__GetHostnameResponse, "tds:GetHostnameResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetHostnameResponse(soap, &tds__GetHostnameResponse, "tds:GetHostnameResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetHostname(struct soap *soap)
{	struct __tds__SetHostname soap_tmp___tds__SetHostname;
	struct _tds__SetHostnameResponse tds__SetHostnameResponse;
	soap_default__tds__SetHostnameResponse(soap, &tds__SetHostnameResponse);
	soap_default___tds__SetHostname(soap, &soap_tmp___tds__SetHostname);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetHostname(soap, &soap_tmp___tds__SetHostname, "-tds:SetHostname", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetHostname(soap, soap_tmp___tds__SetHostname.tds__SetHostname, &tds__SetHostnameResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetHostnameResponse(soap, &tds__SetHostnameResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetHostnameResponse(soap, &tds__SetHostnameResponse, "tds:SetHostnameResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetHostnameResponse(soap, &tds__SetHostnameResponse, "tds:SetHostnameResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetDNS(struct soap *soap)
{	struct __tds__GetDNS soap_tmp___tds__GetDNS;
	struct _tds__GetDNSResponse tds__GetDNSResponse;
	soap_default__tds__GetDNSResponse(soap, &tds__GetDNSResponse);
	soap_default___tds__GetDNS(soap, &soap_tmp___tds__GetDNS);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetDNS(soap, &soap_tmp___tds__GetDNS, "-tds:GetDNS", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetDNS(soap, soap_tmp___tds__GetDNS.tds__GetDNS, &tds__GetDNSResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetDNSResponse(soap, &tds__GetDNSResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetDNSResponse(soap, &tds__GetDNSResponse, "tds:GetDNSResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetDNSResponse(soap, &tds__GetDNSResponse, "tds:GetDNSResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetDNS(struct soap *soap)
{	struct __tds__SetDNS soap_tmp___tds__SetDNS;
	struct _tds__SetDNSResponse tds__SetDNSResponse;
	soap_default__tds__SetDNSResponse(soap, &tds__SetDNSResponse);
	soap_default___tds__SetDNS(soap, &soap_tmp___tds__SetDNS);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetDNS(soap, &soap_tmp___tds__SetDNS, "-tds:SetDNS", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetDNS(soap, soap_tmp___tds__SetDNS.tds__SetDNS, &tds__SetDNSResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetDNSResponse(soap, &tds__SetDNSResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetDNSResponse(soap, &tds__SetDNSResponse, "tds:SetDNSResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetDNSResponse(soap, &tds__SetDNSResponse, "tds:SetDNSResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetNTP(struct soap *soap)
{	struct __tds__GetNTP soap_tmp___tds__GetNTP;
	struct _tds__GetNTPResponse tds__GetNTPResponse;
	soap_default__tds__GetNTPResponse(soap, &tds__GetNTPResponse);
	soap_default___tds__GetNTP(soap, &soap_tmp___tds__GetNTP);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetNTP(soap, &soap_tmp___tds__GetNTP, "-tds:GetNTP", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetNTP(soap, soap_tmp___tds__GetNTP.tds__GetNTP, &tds__GetNTPResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetNTPResponse(soap, &tds__GetNTPResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetNTPResponse(soap, &tds__GetNTPResponse, "tds:GetNTPResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetNTPResponse(soap, &tds__GetNTPResponse, "tds:GetNTPResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetNTP(struct soap *soap)
{	struct __tds__SetNTP soap_tmp___tds__SetNTP;
	struct _tds__SetNTPResponse tds__SetNTPResponse;
	soap_default__tds__SetNTPResponse(soap, &tds__SetNTPResponse);
	soap_default___tds__SetNTP(soap, &soap_tmp___tds__SetNTP);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetNTP(soap, &soap_tmp___tds__SetNTP, "-tds:SetNTP", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetNTP(soap, soap_tmp___tds__SetNTP.tds__SetNTP, &tds__SetNTPResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetNTPResponse(soap, &tds__SetNTPResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetNTPResponse(soap, &tds__SetNTPResponse, "tds:SetNTPResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetNTPResponse(soap, &tds__SetNTPResponse, "tds:SetNTPResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetDynamicDNS(struct soap *soap)
{	struct __tds__GetDynamicDNS soap_tmp___tds__GetDynamicDNS;
	struct _tds__GetDynamicDNSResponse tds__GetDynamicDNSResponse;
	soap_default__tds__GetDynamicDNSResponse(soap, &tds__GetDynamicDNSResponse);
	soap_default___tds__GetDynamicDNS(soap, &soap_tmp___tds__GetDynamicDNS);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetDynamicDNS(soap, &soap_tmp___tds__GetDynamicDNS, "-tds:GetDynamicDNS", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetDynamicDNS(soap, soap_tmp___tds__GetDynamicDNS.tds__GetDynamicDNS, &tds__GetDynamicDNSResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetDynamicDNSResponse(soap, &tds__GetDynamicDNSResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetDynamicDNSResponse(soap, &tds__GetDynamicDNSResponse, "tds:GetDynamicDNSResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetDynamicDNSResponse(soap, &tds__GetDynamicDNSResponse, "tds:GetDynamicDNSResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetDynamicDNS(struct soap *soap)
{	struct __tds__SetDynamicDNS soap_tmp___tds__SetDynamicDNS;
	struct _tds__SetDynamicDNSResponse tds__SetDynamicDNSResponse;
	soap_default__tds__SetDynamicDNSResponse(soap, &tds__SetDynamicDNSResponse);
	soap_default___tds__SetDynamicDNS(soap, &soap_tmp___tds__SetDynamicDNS);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetDynamicDNS(soap, &soap_tmp___tds__SetDynamicDNS, "-tds:SetDynamicDNS", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetDynamicDNS(soap, soap_tmp___tds__SetDynamicDNS.tds__SetDynamicDNS, &tds__SetDynamicDNSResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetDynamicDNSResponse(soap, &tds__SetDynamicDNSResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetDynamicDNSResponse(soap, &tds__SetDynamicDNSResponse, "tds:SetDynamicDNSResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetDynamicDNSResponse(soap, &tds__SetDynamicDNSResponse, "tds:SetDynamicDNSResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetNetworkInterfaces(struct soap *soap)
{	struct __tds__GetNetworkInterfaces soap_tmp___tds__GetNetworkInterfaces;
	struct _tds__GetNetworkInterfacesResponse tds__GetNetworkInterfacesResponse;
	soap_default__tds__GetNetworkInterfacesResponse(soap, &tds__GetNetworkInterfacesResponse);
	soap_default___tds__GetNetworkInterfaces(soap, &soap_tmp___tds__GetNetworkInterfaces);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetNetworkInterfaces(soap, &soap_tmp___tds__GetNetworkInterfaces, "-tds:GetNetworkInterfaces", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetNetworkInterfaces(soap, soap_tmp___tds__GetNetworkInterfaces.tds__GetNetworkInterfaces, &tds__GetNetworkInterfacesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetNetworkInterfacesResponse(soap, &tds__GetNetworkInterfacesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetNetworkInterfacesResponse(soap, &tds__GetNetworkInterfacesResponse, "tds:GetNetworkInterfacesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetNetworkInterfacesResponse(soap, &tds__GetNetworkInterfacesResponse, "tds:GetNetworkInterfacesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetNetworkInterfaces(struct soap *soap)
{	struct __tds__SetNetworkInterfaces soap_tmp___tds__SetNetworkInterfaces;
	struct _tds__SetNetworkInterfacesResponse tds__SetNetworkInterfacesResponse;
	soap_default__tds__SetNetworkInterfacesResponse(soap, &tds__SetNetworkInterfacesResponse);
	soap_default___tds__SetNetworkInterfaces(soap, &soap_tmp___tds__SetNetworkInterfaces);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetNetworkInterfaces(soap, &soap_tmp___tds__SetNetworkInterfaces, "-tds:SetNetworkInterfaces", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetNetworkInterfaces(soap, soap_tmp___tds__SetNetworkInterfaces.tds__SetNetworkInterfaces, &tds__SetNetworkInterfacesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetNetworkInterfacesResponse(soap, &tds__SetNetworkInterfacesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetNetworkInterfacesResponse(soap, &tds__SetNetworkInterfacesResponse, "tds:SetNetworkInterfacesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetNetworkInterfacesResponse(soap, &tds__SetNetworkInterfacesResponse, "tds:SetNetworkInterfacesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetNetworkProtocols(struct soap *soap)
{	struct __tds__GetNetworkProtocols soap_tmp___tds__GetNetworkProtocols;
	struct _tds__GetNetworkProtocolsResponse tds__GetNetworkProtocolsResponse;
	soap_default__tds__GetNetworkProtocolsResponse(soap, &tds__GetNetworkProtocolsResponse);
	soap_default___tds__GetNetworkProtocols(soap, &soap_tmp___tds__GetNetworkProtocols);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetNetworkProtocols(soap, &soap_tmp___tds__GetNetworkProtocols, "-tds:GetNetworkProtocols", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetNetworkProtocols(soap, soap_tmp___tds__GetNetworkProtocols.tds__GetNetworkProtocols, &tds__GetNetworkProtocolsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetNetworkProtocolsResponse(soap, &tds__GetNetworkProtocolsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetNetworkProtocolsResponse(soap, &tds__GetNetworkProtocolsResponse, "tds:GetNetworkProtocolsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetNetworkProtocolsResponse(soap, &tds__GetNetworkProtocolsResponse, "tds:GetNetworkProtocolsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetNetworkProtocols(struct soap *soap)
{	struct __tds__SetNetworkProtocols soap_tmp___tds__SetNetworkProtocols;
	struct _tds__SetNetworkProtocolsResponse tds__SetNetworkProtocolsResponse;
	soap_default__tds__SetNetworkProtocolsResponse(soap, &tds__SetNetworkProtocolsResponse);
	soap_default___tds__SetNetworkProtocols(soap, &soap_tmp___tds__SetNetworkProtocols);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetNetworkProtocols(soap, &soap_tmp___tds__SetNetworkProtocols, "-tds:SetNetworkProtocols", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetNetworkProtocols(soap, soap_tmp___tds__SetNetworkProtocols.tds__SetNetworkProtocols, &tds__SetNetworkProtocolsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetNetworkProtocolsResponse(soap, &tds__SetNetworkProtocolsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetNetworkProtocolsResponse(soap, &tds__SetNetworkProtocolsResponse, "tds:SetNetworkProtocolsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetNetworkProtocolsResponse(soap, &tds__SetNetworkProtocolsResponse, "tds:SetNetworkProtocolsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetNetworkDefaultGateway(struct soap *soap)
{	struct __tds__GetNetworkDefaultGateway soap_tmp___tds__GetNetworkDefaultGateway;
	struct _tds__GetNetworkDefaultGatewayResponse tds__GetNetworkDefaultGatewayResponse;
	soap_default__tds__GetNetworkDefaultGatewayResponse(soap, &tds__GetNetworkDefaultGatewayResponse);
	soap_default___tds__GetNetworkDefaultGateway(soap, &soap_tmp___tds__GetNetworkDefaultGateway);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetNetworkDefaultGateway(soap, &soap_tmp___tds__GetNetworkDefaultGateway, "-tds:GetNetworkDefaultGateway", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetNetworkDefaultGateway(soap, soap_tmp___tds__GetNetworkDefaultGateway.tds__GetNetworkDefaultGateway, &tds__GetNetworkDefaultGatewayResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetNetworkDefaultGatewayResponse(soap, &tds__GetNetworkDefaultGatewayResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetNetworkDefaultGatewayResponse(soap, &tds__GetNetworkDefaultGatewayResponse, "tds:GetNetworkDefaultGatewayResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetNetworkDefaultGatewayResponse(soap, &tds__GetNetworkDefaultGatewayResponse, "tds:GetNetworkDefaultGatewayResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetNetworkDefaultGateway(struct soap *soap)
{	struct __tds__SetNetworkDefaultGateway soap_tmp___tds__SetNetworkDefaultGateway;
	struct _tds__SetNetworkDefaultGatewayResponse tds__SetNetworkDefaultGatewayResponse;
	soap_default__tds__SetNetworkDefaultGatewayResponse(soap, &tds__SetNetworkDefaultGatewayResponse);
	soap_default___tds__SetNetworkDefaultGateway(soap, &soap_tmp___tds__SetNetworkDefaultGateway);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetNetworkDefaultGateway(soap, &soap_tmp___tds__SetNetworkDefaultGateway, "-tds:SetNetworkDefaultGateway", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetNetworkDefaultGateway(soap, soap_tmp___tds__SetNetworkDefaultGateway.tds__SetNetworkDefaultGateway, &tds__SetNetworkDefaultGatewayResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetNetworkDefaultGatewayResponse(soap, &tds__SetNetworkDefaultGatewayResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetNetworkDefaultGatewayResponse(soap, &tds__SetNetworkDefaultGatewayResponse, "tds:SetNetworkDefaultGatewayResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetNetworkDefaultGatewayResponse(soap, &tds__SetNetworkDefaultGatewayResponse, "tds:SetNetworkDefaultGatewayResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetZeroConfiguration(struct soap *soap)
{	struct __tds__GetZeroConfiguration soap_tmp___tds__GetZeroConfiguration;
	struct _tds__GetZeroConfigurationResponse tds__GetZeroConfigurationResponse;
	soap_default__tds__GetZeroConfigurationResponse(soap, &tds__GetZeroConfigurationResponse);
	soap_default___tds__GetZeroConfiguration(soap, &soap_tmp___tds__GetZeroConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetZeroConfiguration(soap, &soap_tmp___tds__GetZeroConfiguration, "-tds:GetZeroConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetZeroConfiguration(soap, soap_tmp___tds__GetZeroConfiguration.tds__GetZeroConfiguration, &tds__GetZeroConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetZeroConfigurationResponse(soap, &tds__GetZeroConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetZeroConfigurationResponse(soap, &tds__GetZeroConfigurationResponse, "tds:GetZeroConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetZeroConfigurationResponse(soap, &tds__GetZeroConfigurationResponse, "tds:GetZeroConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetZeroConfiguration(struct soap *soap)
{	struct __tds__SetZeroConfiguration soap_tmp___tds__SetZeroConfiguration;
	struct _tds__SetZeroConfigurationResponse tds__SetZeroConfigurationResponse;
	soap_default__tds__SetZeroConfigurationResponse(soap, &tds__SetZeroConfigurationResponse);
	soap_default___tds__SetZeroConfiguration(soap, &soap_tmp___tds__SetZeroConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetZeroConfiguration(soap, &soap_tmp___tds__SetZeroConfiguration, "-tds:SetZeroConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetZeroConfiguration(soap, soap_tmp___tds__SetZeroConfiguration.tds__SetZeroConfiguration, &tds__SetZeroConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetZeroConfigurationResponse(soap, &tds__SetZeroConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetZeroConfigurationResponse(soap, &tds__SetZeroConfigurationResponse, "tds:SetZeroConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetZeroConfigurationResponse(soap, &tds__SetZeroConfigurationResponse, "tds:SetZeroConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetRelayOutputs(struct soap *soap)
{	struct __tds__GetRelayOutputs soap_tmp___tds__GetRelayOutputs;
	struct _tds__GetRelayOutputsResponse tds__GetRelayOutputsResponse;
	soap_default__tds__GetRelayOutputsResponse(soap, &tds__GetRelayOutputsResponse);
	soap_default___tds__GetRelayOutputs(soap, &soap_tmp___tds__GetRelayOutputs);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetRelayOutputs(soap, &soap_tmp___tds__GetRelayOutputs, "-tds:GetRelayOutputs", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetRelayOutputs(soap, soap_tmp___tds__GetRelayOutputs.tds__GetRelayOutputs, &tds__GetRelayOutputsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetRelayOutputsResponse(soap, &tds__GetRelayOutputsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetRelayOutputsResponse(soap, &tds__GetRelayOutputsResponse, "tds:GetRelayOutputsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetRelayOutputsResponse(soap, &tds__GetRelayOutputsResponse, "tds:GetRelayOutputsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetRelayOutputSettings(struct soap *soap)
{	struct __tds__SetRelayOutputSettings soap_tmp___tds__SetRelayOutputSettings;
	struct _tds__SetRelayOutputSettingsResponse tds__SetRelayOutputSettingsResponse;
	soap_default__tds__SetRelayOutputSettingsResponse(soap, &tds__SetRelayOutputSettingsResponse);
	soap_default___tds__SetRelayOutputSettings(soap, &soap_tmp___tds__SetRelayOutputSettings);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetRelayOutputSettings(soap, &soap_tmp___tds__SetRelayOutputSettings, "-tds:SetRelayOutputSettings", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetRelayOutputSettings(soap, soap_tmp___tds__SetRelayOutputSettings.tds__SetRelayOutputSettings, &tds__SetRelayOutputSettingsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetRelayOutputSettingsResponse(soap, &tds__SetRelayOutputSettingsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetRelayOutputSettingsResponse(soap, &tds__SetRelayOutputSettingsResponse, "tds:SetRelayOutputSettingsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetRelayOutputSettingsResponse(soap, &tds__SetRelayOutputSettingsResponse, "tds:SetRelayOutputSettingsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetRelayOutputState(struct soap *soap)
{	struct __tds__SetRelayOutputState soap_tmp___tds__SetRelayOutputState;
	struct _tds__SetRelayOutputStateResponse tds__SetRelayOutputStateResponse;
	soap_default__tds__SetRelayOutputStateResponse(soap, &tds__SetRelayOutputStateResponse);
	soap_default___tds__SetRelayOutputState(soap, &soap_tmp___tds__SetRelayOutputState);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetRelayOutputState(soap, &soap_tmp___tds__SetRelayOutputState, "-tds:SetRelayOutputState", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetRelayOutputState(soap, soap_tmp___tds__SetRelayOutputState.tds__SetRelayOutputState, &tds__SetRelayOutputStateResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetRelayOutputStateResponse(soap, &tds__SetRelayOutputStateResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetRelayOutputStateResponse(soap, &tds__SetRelayOutputStateResponse, "tds:SetRelayOutputStateResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetRelayOutputStateResponse(soap, &tds__SetRelayOutputStateResponse, "tds:SetRelayOutputStateResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GetConfigurations(struct soap *soap)
{	struct __tptz__GetConfigurations soap_tmp___tptz__GetConfigurations;
	struct _tptz__GetConfigurationsResponse tptz__GetConfigurationsResponse;
	soap_default__tptz__GetConfigurationsResponse(soap, &tptz__GetConfigurationsResponse);
	soap_default___tptz__GetConfigurations(soap, &soap_tmp___tptz__GetConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GetConfigurations(soap, &soap_tmp___tptz__GetConfigurations, "-tptz:GetConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GetConfigurations(soap, soap_tmp___tptz__GetConfigurations.tptz__GetConfigurations, &tptz__GetConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GetConfigurationsResponse(soap, &tptz__GetConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GetConfigurationsResponse(soap, &tptz__GetConfigurationsResponse, "tptz:GetConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GetConfigurationsResponse(soap, &tptz__GetConfigurationsResponse, "tptz:GetConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GetPresets(struct soap *soap)
{	struct __tptz__GetPresets soap_tmp___tptz__GetPresets;
	struct _tptz__GetPresetsResponse tptz__GetPresetsResponse;
	soap_default__tptz__GetPresetsResponse(soap, &tptz__GetPresetsResponse);
	soap_default___tptz__GetPresets(soap, &soap_tmp___tptz__GetPresets);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GetPresets(soap, &soap_tmp___tptz__GetPresets, "-tptz:GetPresets", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GetPresets(soap, soap_tmp___tptz__GetPresets.tptz__GetPresets, &tptz__GetPresetsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GetPresetsResponse(soap, &tptz__GetPresetsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GetPresetsResponse(soap, &tptz__GetPresetsResponse, "tptz:GetPresetsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GetPresetsResponse(soap, &tptz__GetPresetsResponse, "tptz:GetPresetsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__SetPreset(struct soap *soap)
{	struct __tptz__SetPreset soap_tmp___tptz__SetPreset;
	struct _tptz__SetPresetResponse tptz__SetPresetResponse;
	soap_default__tptz__SetPresetResponse(soap, &tptz__SetPresetResponse);
	soap_default___tptz__SetPreset(soap, &soap_tmp___tptz__SetPreset);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__SetPreset(soap, &soap_tmp___tptz__SetPreset, "-tptz:SetPreset", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__SetPreset(soap, soap_tmp___tptz__SetPreset.tptz__SetPreset, &tptz__SetPresetResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__SetPresetResponse(soap, &tptz__SetPresetResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__SetPresetResponse(soap, &tptz__SetPresetResponse, "tptz:SetPresetResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__SetPresetResponse(soap, &tptz__SetPresetResponse, "tptz:SetPresetResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__RemovePreset(struct soap *soap)
{	struct __tptz__RemovePreset soap_tmp___tptz__RemovePreset;
	struct _tptz__RemovePresetResponse tptz__RemovePresetResponse;
	soap_default__tptz__RemovePresetResponse(soap, &tptz__RemovePresetResponse);
	soap_default___tptz__RemovePreset(soap, &soap_tmp___tptz__RemovePreset);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__RemovePreset(soap, &soap_tmp___tptz__RemovePreset, "-tptz:RemovePreset", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__RemovePreset(soap, soap_tmp___tptz__RemovePreset.tptz__RemovePreset, &tptz__RemovePresetResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__RemovePresetResponse(soap, &tptz__RemovePresetResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__RemovePresetResponse(soap, &tptz__RemovePresetResponse, "tptz:RemovePresetResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__RemovePresetResponse(soap, &tptz__RemovePresetResponse, "tptz:RemovePresetResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GotoPreset(struct soap *soap)
{	struct __tptz__GotoPreset soap_tmp___tptz__GotoPreset;
	struct _tptz__GotoPresetResponse tptz__GotoPresetResponse;
	soap_default__tptz__GotoPresetResponse(soap, &tptz__GotoPresetResponse);
	soap_default___tptz__GotoPreset(soap, &soap_tmp___tptz__GotoPreset);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GotoPreset(soap, &soap_tmp___tptz__GotoPreset, "-tptz:GotoPreset", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GotoPreset(soap, soap_tmp___tptz__GotoPreset.tptz__GotoPreset, &tptz__GotoPresetResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GotoPresetResponse(soap, &tptz__GotoPresetResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GotoPresetResponse(soap, &tptz__GotoPresetResponse, "tptz:GotoPresetResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GotoPresetResponse(soap, &tptz__GotoPresetResponse, "tptz:GotoPresetResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GetStatus(struct soap *soap)
{	struct __tptz__GetStatus soap_tmp___tptz__GetStatus;
	struct _tptz__GetStatusResponse tptz__GetStatusResponse;
	soap_default__tptz__GetStatusResponse(soap, &tptz__GetStatusResponse);
	soap_default___tptz__GetStatus(soap, &soap_tmp___tptz__GetStatus);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GetStatus(soap, &soap_tmp___tptz__GetStatus, "-tptz:GetStatus", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GetStatus(soap, soap_tmp___tptz__GetStatus.tptz__GetStatus, &tptz__GetStatusResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GetStatusResponse(soap, &tptz__GetStatusResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GetStatusResponse(soap, &tptz__GetStatusResponse, "tptz:GetStatusResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GetStatusResponse(soap, &tptz__GetStatusResponse, "tptz:GetStatusResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GetConfiguration(struct soap *soap)
{	struct __tptz__GetConfiguration soap_tmp___tptz__GetConfiguration;
	struct _tptz__GetConfigurationResponse tptz__GetConfigurationResponse;
	soap_default__tptz__GetConfigurationResponse(soap, &tptz__GetConfigurationResponse);
	soap_default___tptz__GetConfiguration(soap, &soap_tmp___tptz__GetConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GetConfiguration(soap, &soap_tmp___tptz__GetConfiguration, "-tptz:GetConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GetConfiguration(soap, soap_tmp___tptz__GetConfiguration.tptz__GetConfiguration, &tptz__GetConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GetConfigurationResponse(soap, &tptz__GetConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GetConfigurationResponse(soap, &tptz__GetConfigurationResponse, "tptz:GetConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GetConfigurationResponse(soap, &tptz__GetConfigurationResponse, "tptz:GetConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GetNodes(struct soap *soap)
{	struct __tptz__GetNodes soap_tmp___tptz__GetNodes;
	struct _tptz__GetNodesResponse tptz__GetNodesResponse;
	soap_default__tptz__GetNodesResponse(soap, &tptz__GetNodesResponse);
	soap_default___tptz__GetNodes(soap, &soap_tmp___tptz__GetNodes);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GetNodes(soap, &soap_tmp___tptz__GetNodes, "-tptz:GetNodes", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GetNodes(soap, soap_tmp___tptz__GetNodes.tptz__GetNodes, &tptz__GetNodesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GetNodesResponse(soap, &tptz__GetNodesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GetNodesResponse(soap, &tptz__GetNodesResponse, "tptz:GetNodesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GetNodesResponse(soap, &tptz__GetNodesResponse, "tptz:GetNodesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GetNode(struct soap *soap)
{	struct __tptz__GetNode soap_tmp___tptz__GetNode;
	struct _tptz__GetNodeResponse tptz__GetNodeResponse;
	soap_default__tptz__GetNodeResponse(soap, &tptz__GetNodeResponse);
	soap_default___tptz__GetNode(soap, &soap_tmp___tptz__GetNode);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GetNode(soap, &soap_tmp___tptz__GetNode, "-tptz:GetNode", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GetNode(soap, soap_tmp___tptz__GetNode.tptz__GetNode, &tptz__GetNodeResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GetNodeResponse(soap, &tptz__GetNodeResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GetNodeResponse(soap, &tptz__GetNodeResponse, "tptz:GetNodeResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GetNodeResponse(soap, &tptz__GetNodeResponse, "tptz:GetNodeResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__SetConfiguration(struct soap *soap)
{	struct __tptz__SetConfiguration soap_tmp___tptz__SetConfiguration;
	struct _tptz__SetConfigurationResponse tptz__SetConfigurationResponse;
	soap_default__tptz__SetConfigurationResponse(soap, &tptz__SetConfigurationResponse);
	soap_default___tptz__SetConfiguration(soap, &soap_tmp___tptz__SetConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__SetConfiguration(soap, &soap_tmp___tptz__SetConfiguration, "-tptz:SetConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__SetConfiguration(soap, soap_tmp___tptz__SetConfiguration.tptz__SetConfiguration, &tptz__SetConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__SetConfigurationResponse(soap, &tptz__SetConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__SetConfigurationResponse(soap, &tptz__SetConfigurationResponse, "tptz:SetConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__SetConfigurationResponse(soap, &tptz__SetConfigurationResponse, "tptz:SetConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GetConfigurationOptions(struct soap *soap)
{	struct __tptz__GetConfigurationOptions soap_tmp___tptz__GetConfigurationOptions;
	struct _tptz__GetConfigurationOptionsResponse tptz__GetConfigurationOptionsResponse;
	soap_default__tptz__GetConfigurationOptionsResponse(soap, &tptz__GetConfigurationOptionsResponse);
	soap_default___tptz__GetConfigurationOptions(soap, &soap_tmp___tptz__GetConfigurationOptions);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GetConfigurationOptions(soap, &soap_tmp___tptz__GetConfigurationOptions, "-tptz:GetConfigurationOptions", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GetConfigurationOptions(soap, soap_tmp___tptz__GetConfigurationOptions.tptz__GetConfigurationOptions, &tptz__GetConfigurationOptionsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GetConfigurationOptionsResponse(soap, &tptz__GetConfigurationOptionsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GetConfigurationOptionsResponse(soap, &tptz__GetConfigurationOptionsResponse, "tptz:GetConfigurationOptionsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GetConfigurationOptionsResponse(soap, &tptz__GetConfigurationOptionsResponse, "tptz:GetConfigurationOptionsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GotoHomePosition(struct soap *soap)
{	struct __tptz__GotoHomePosition soap_tmp___tptz__GotoHomePosition;
	struct _tptz__GotoHomePositionResponse tptz__GotoHomePositionResponse;
	soap_default__tptz__GotoHomePositionResponse(soap, &tptz__GotoHomePositionResponse);
	soap_default___tptz__GotoHomePosition(soap, &soap_tmp___tptz__GotoHomePosition);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GotoHomePosition(soap, &soap_tmp___tptz__GotoHomePosition, "-tptz:GotoHomePosition", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GotoHomePosition(soap, soap_tmp___tptz__GotoHomePosition.tptz__GotoHomePosition, &tptz__GotoHomePositionResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GotoHomePositionResponse(soap, &tptz__GotoHomePositionResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GotoHomePositionResponse(soap, &tptz__GotoHomePositionResponse, "tptz:GotoHomePositionResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GotoHomePositionResponse(soap, &tptz__GotoHomePositionResponse, "tptz:GotoHomePositionResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__SetHomePosition(struct soap *soap)
{	struct __tptz__SetHomePosition soap_tmp___tptz__SetHomePosition;
	struct __tptz__SetHomePositionResponse soap_tmp___tptz__SetHomePositionResponse;
	char * soap_tmp__tptz__SetHomePositionResponse;
	soap_default___tptz__SetHomePositionResponse(soap, &soap_tmp___tptz__SetHomePositionResponse);
	soap_tmp__tptz__SetHomePositionResponse = NULL;
	soap_tmp___tptz__SetHomePositionResponse.tptz__SetHomePositionResponse = &soap_tmp__tptz__SetHomePositionResponse;
	soap_default___tptz__SetHomePosition(soap, &soap_tmp___tptz__SetHomePosition);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__SetHomePosition(soap, &soap_tmp___tptz__SetHomePosition, "-tptz:SetHomePosition", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__SetHomePosition(soap, soap_tmp___tptz__SetHomePosition.tptz__SetHomePosition, &soap_tmp__tptz__SetHomePositionResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize___tptz__SetHomePositionResponse(soap, &soap_tmp___tptz__SetHomePositionResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put___tptz__SetHomePositionResponse(soap, &soap_tmp___tptz__SetHomePositionResponse, "-tptz:SetHomePositionResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put___tptz__SetHomePositionResponse(soap, &soap_tmp___tptz__SetHomePositionResponse, "-tptz:SetHomePositionResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__ContinuousMove(struct soap *soap)
{	struct __tptz__ContinuousMove soap_tmp___tptz__ContinuousMove;
	struct _tptz__ContinuousMoveResponse tptz__ContinuousMoveResponse;
	soap_default__tptz__ContinuousMoveResponse(soap, &tptz__ContinuousMoveResponse);
	soap_default___tptz__ContinuousMove(soap, &soap_tmp___tptz__ContinuousMove);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__ContinuousMove(soap, &soap_tmp___tptz__ContinuousMove, "-tptz:ContinuousMove", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__ContinuousMove(soap, soap_tmp___tptz__ContinuousMove.tptz__ContinuousMove, &tptz__ContinuousMoveResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__ContinuousMoveResponse(soap, &tptz__ContinuousMoveResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__ContinuousMoveResponse(soap, &tptz__ContinuousMoveResponse, "tptz:ContinuousMoveResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__ContinuousMoveResponse(soap, &tptz__ContinuousMoveResponse, "tptz:ContinuousMoveResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__AbsoluteMove(struct soap *soap)
{	struct __tptz__AbsoluteMove soap_tmp___tptz__AbsoluteMove;
	struct _tptz__AbsoluteMoveResponse tptz__AbsoluteMoveResponse;
	soap_default__tptz__AbsoluteMoveResponse(soap, &tptz__AbsoluteMoveResponse);
	soap_default___tptz__AbsoluteMove(soap, &soap_tmp___tptz__AbsoluteMove);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__AbsoluteMove(soap, &soap_tmp___tptz__AbsoluteMove, "-tptz:AbsoluteMove", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__AbsoluteMove(soap, soap_tmp___tptz__AbsoluteMove.tptz__AbsoluteMove, &tptz__AbsoluteMoveResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__AbsoluteMoveResponse(soap, &tptz__AbsoluteMoveResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__AbsoluteMoveResponse(soap, &tptz__AbsoluteMoveResponse, "tptz:AbsoluteMoveResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__AbsoluteMoveResponse(soap, &tptz__AbsoluteMoveResponse, "tptz:AbsoluteMoveResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__Stop(struct soap *soap)
{	struct __tptz__Stop soap_tmp___tptz__Stop;
	struct _tptz__StopResponse tptz__StopResponse;
	soap_default__tptz__StopResponse(soap, &tptz__StopResponse);
	soap_default___tptz__Stop(soap, &soap_tmp___tptz__Stop);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__Stop(soap, &soap_tmp___tptz__Stop, "-tptz:Stop", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__Stop(soap, soap_tmp___tptz__Stop.tptz__Stop, &tptz__StopResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__StopResponse(soap, &tptz__StopResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__StopResponse(soap, &tptz__StopResponse, "tptz:StopResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__StopResponse(soap, &tptz__StopResponse, "tptz:StopResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GetConfigurations_(struct soap *soap)
{	struct __tptz__GetConfigurations_ soap_tmp___tptz__GetConfigurations_;
	struct _tptz__GetConfigurationsResponse tptz__GetConfigurationsResponse;
	soap_default__tptz__GetConfigurationsResponse(soap, &tptz__GetConfigurationsResponse);
	soap_default___tptz__GetConfigurations_(soap, &soap_tmp___tptz__GetConfigurations_);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GetConfigurations_(soap, &soap_tmp___tptz__GetConfigurations_, "-tptz:GetConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GetConfigurations_(soap, soap_tmp___tptz__GetConfigurations_.tptz__GetConfigurations, &tptz__GetConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GetConfigurationsResponse(soap, &tptz__GetConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GetConfigurationsResponse(soap, &tptz__GetConfigurationsResponse, "tptz:GetConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GetConfigurationsResponse(soap, &tptz__GetConfigurationsResponse, "tptz:GetConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GetPresets_(struct soap *soap)
{	struct __tptz__GetPresets_ soap_tmp___tptz__GetPresets_;
	struct _tptz__GetPresetsResponse tptz__GetPresetsResponse;
	soap_default__tptz__GetPresetsResponse(soap, &tptz__GetPresetsResponse);
	soap_default___tptz__GetPresets_(soap, &soap_tmp___tptz__GetPresets_);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GetPresets_(soap, &soap_tmp___tptz__GetPresets_, "-tptz:GetPresets", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GetPresets_(soap, soap_tmp___tptz__GetPresets_.tptz__GetPresets, &tptz__GetPresetsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GetPresetsResponse(soap, &tptz__GetPresetsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GetPresetsResponse(soap, &tptz__GetPresetsResponse, "tptz:GetPresetsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GetPresetsResponse(soap, &tptz__GetPresetsResponse, "tptz:GetPresetsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__SetPreset_(struct soap *soap)
{	struct __tptz__SetPreset_ soap_tmp___tptz__SetPreset_;
	struct _tptz__SetPresetResponse tptz__SetPresetResponse;
	soap_default__tptz__SetPresetResponse(soap, &tptz__SetPresetResponse);
	soap_default___tptz__SetPreset_(soap, &soap_tmp___tptz__SetPreset_);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__SetPreset_(soap, &soap_tmp___tptz__SetPreset_, "-tptz:SetPreset", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__SetPreset_(soap, soap_tmp___tptz__SetPreset_.tptz__SetPreset, &tptz__SetPresetResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__SetPresetResponse(soap, &tptz__SetPresetResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__SetPresetResponse(soap, &tptz__SetPresetResponse, "tptz:SetPresetResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__SetPresetResponse(soap, &tptz__SetPresetResponse, "tptz:SetPresetResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__RemovePreset_(struct soap *soap)
{	struct __tptz__RemovePreset_ soap_tmp___tptz__RemovePreset_;
	struct _tptz__RemovePresetResponse tptz__RemovePresetResponse;
	soap_default__tptz__RemovePresetResponse(soap, &tptz__RemovePresetResponse);
	soap_default___tptz__RemovePreset_(soap, &soap_tmp___tptz__RemovePreset_);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__RemovePreset_(soap, &soap_tmp___tptz__RemovePreset_, "-tptz:RemovePreset", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__RemovePreset_(soap, soap_tmp___tptz__RemovePreset_.tptz__RemovePreset, &tptz__RemovePresetResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__RemovePresetResponse(soap, &tptz__RemovePresetResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__RemovePresetResponse(soap, &tptz__RemovePresetResponse, "tptz:RemovePresetResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__RemovePresetResponse(soap, &tptz__RemovePresetResponse, "tptz:RemovePresetResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GotoPreset_(struct soap *soap)
{	struct __tptz__GotoPreset_ soap_tmp___tptz__GotoPreset_;
	struct _tptz__GotoPresetResponse tptz__GotoPresetResponse;
	soap_default__tptz__GotoPresetResponse(soap, &tptz__GotoPresetResponse);
	soap_default___tptz__GotoPreset_(soap, &soap_tmp___tptz__GotoPreset_);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GotoPreset_(soap, &soap_tmp___tptz__GotoPreset_, "-tptz:GotoPreset", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GotoPreset_(soap, soap_tmp___tptz__GotoPreset_.tptz__GotoPreset, &tptz__GotoPresetResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GotoPresetResponse(soap, &tptz__GotoPresetResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GotoPresetResponse(soap, &tptz__GotoPresetResponse, "tptz:GotoPresetResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GotoPresetResponse(soap, &tptz__GotoPresetResponse, "tptz:GotoPresetResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GetStatus_(struct soap *soap)
{	struct __tptz__GetStatus_ soap_tmp___tptz__GetStatus_;
	struct _tptz__GetStatusResponse tptz__GetStatusResponse;
	soap_default__tptz__GetStatusResponse(soap, &tptz__GetStatusResponse);
	soap_default___tptz__GetStatus_(soap, &soap_tmp___tptz__GetStatus_);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GetStatus_(soap, &soap_tmp___tptz__GetStatus_, "-tptz:GetStatus", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GetStatus_(soap, soap_tmp___tptz__GetStatus_.tptz__GetStatus, &tptz__GetStatusResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GetStatusResponse(soap, &tptz__GetStatusResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GetStatusResponse(soap, &tptz__GetStatusResponse, "tptz:GetStatusResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GetStatusResponse(soap, &tptz__GetStatusResponse, "tptz:GetStatusResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GetConfiguration_(struct soap *soap)
{	struct __tptz__GetConfiguration_ soap_tmp___tptz__GetConfiguration_;
	struct _tptz__GetConfigurationResponse tptz__GetConfigurationResponse;
	soap_default__tptz__GetConfigurationResponse(soap, &tptz__GetConfigurationResponse);
	soap_default___tptz__GetConfiguration_(soap, &soap_tmp___tptz__GetConfiguration_);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GetConfiguration_(soap, &soap_tmp___tptz__GetConfiguration_, "-tptz:GetConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GetConfiguration_(soap, soap_tmp___tptz__GetConfiguration_.tptz__GetConfiguration, &tptz__GetConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GetConfigurationResponse(soap, &tptz__GetConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GetConfigurationResponse(soap, &tptz__GetConfigurationResponse, "tptz:GetConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GetConfigurationResponse(soap, &tptz__GetConfigurationResponse, "tptz:GetConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GetNodes_(struct soap *soap)
{	struct __tptz__GetNodes_ soap_tmp___tptz__GetNodes_;
	struct _tptz__GetNodesResponse tptz__GetNodesResponse;
	soap_default__tptz__GetNodesResponse(soap, &tptz__GetNodesResponse);
	soap_default___tptz__GetNodes_(soap, &soap_tmp___tptz__GetNodes_);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GetNodes_(soap, &soap_tmp___tptz__GetNodes_, "-tptz:GetNodes", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GetNodes_(soap, soap_tmp___tptz__GetNodes_.tptz__GetNodes, &tptz__GetNodesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GetNodesResponse(soap, &tptz__GetNodesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GetNodesResponse(soap, &tptz__GetNodesResponse, "tptz:GetNodesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GetNodesResponse(soap, &tptz__GetNodesResponse, "tptz:GetNodesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GetNode_(struct soap *soap)
{	struct __tptz__GetNode_ soap_tmp___tptz__GetNode_;
	struct _tptz__GetNodeResponse tptz__GetNodeResponse;
	soap_default__tptz__GetNodeResponse(soap, &tptz__GetNodeResponse);
	soap_default___tptz__GetNode_(soap, &soap_tmp___tptz__GetNode_);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GetNode_(soap, &soap_tmp___tptz__GetNode_, "-tptz:GetNode", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GetNode_(soap, soap_tmp___tptz__GetNode_.tptz__GetNode, &tptz__GetNodeResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GetNodeResponse(soap, &tptz__GetNodeResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GetNodeResponse(soap, &tptz__GetNodeResponse, "tptz:GetNodeResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GetNodeResponse(soap, &tptz__GetNodeResponse, "tptz:GetNodeResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__SetConfiguration_(struct soap *soap)
{	struct __tptz__SetConfiguration_ soap_tmp___tptz__SetConfiguration_;
	struct _tptz__SetConfigurationResponse tptz__SetConfigurationResponse;
	soap_default__tptz__SetConfigurationResponse(soap, &tptz__SetConfigurationResponse);
	soap_default___tptz__SetConfiguration_(soap, &soap_tmp___tptz__SetConfiguration_);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__SetConfiguration_(soap, &soap_tmp___tptz__SetConfiguration_, "-tptz:SetConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__SetConfiguration_(soap, soap_tmp___tptz__SetConfiguration_.tptz__SetConfiguration, &tptz__SetConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__SetConfigurationResponse(soap, &tptz__SetConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__SetConfigurationResponse(soap, &tptz__SetConfigurationResponse, "tptz:SetConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__SetConfigurationResponse(soap, &tptz__SetConfigurationResponse, "tptz:SetConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GetConfigurationOptions_(struct soap *soap)
{	struct __tptz__GetConfigurationOptions_ soap_tmp___tptz__GetConfigurationOptions_;
	struct _tptz__GetConfigurationOptionsResponse tptz__GetConfigurationOptionsResponse;
	soap_default__tptz__GetConfigurationOptionsResponse(soap, &tptz__GetConfigurationOptionsResponse);
	soap_default___tptz__GetConfigurationOptions_(soap, &soap_tmp___tptz__GetConfigurationOptions_);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GetConfigurationOptions_(soap, &soap_tmp___tptz__GetConfigurationOptions_, "-tptz:GetConfigurationOptions", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GetConfigurationOptions_(soap, soap_tmp___tptz__GetConfigurationOptions_.tptz__GetConfigurationOptions, &tptz__GetConfigurationOptionsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GetConfigurationOptionsResponse(soap, &tptz__GetConfigurationOptionsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GetConfigurationOptionsResponse(soap, &tptz__GetConfigurationOptionsResponse, "tptz:GetConfigurationOptionsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GetConfigurationOptionsResponse(soap, &tptz__GetConfigurationOptionsResponse, "tptz:GetConfigurationOptionsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__GotoHomePosition_(struct soap *soap)
{	struct __tptz__GotoHomePosition_ soap_tmp___tptz__GotoHomePosition_;
	struct _tptz__GotoHomePositionResponse tptz__GotoHomePositionResponse;
	soap_default__tptz__GotoHomePositionResponse(soap, &tptz__GotoHomePositionResponse);
	soap_default___tptz__GotoHomePosition_(soap, &soap_tmp___tptz__GotoHomePosition_);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__GotoHomePosition_(soap, &soap_tmp___tptz__GotoHomePosition_, "-tptz:GotoHomePosition", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__GotoHomePosition_(soap, soap_tmp___tptz__GotoHomePosition_.tptz__GotoHomePosition, &tptz__GotoHomePositionResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__GotoHomePositionResponse(soap, &tptz__GotoHomePositionResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__GotoHomePositionResponse(soap, &tptz__GotoHomePositionResponse, "tptz:GotoHomePositionResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__GotoHomePositionResponse(soap, &tptz__GotoHomePositionResponse, "tptz:GotoHomePositionResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__SetHomePosition_(struct soap *soap)
{	struct __tptz__SetHomePosition_ soap_tmp___tptz__SetHomePosition_;
	struct __tptz__SetHomePosition_Response soap_tmp___tptz__SetHomePosition_Response;
	char * soap_tmp__tptz__SetHomePositionResponse;
	soap_default___tptz__SetHomePosition_Response(soap, &soap_tmp___tptz__SetHomePosition_Response);
	soap_tmp__tptz__SetHomePositionResponse = NULL;
	soap_tmp___tptz__SetHomePosition_Response.tptz__SetHomePositionResponse = &soap_tmp__tptz__SetHomePositionResponse;
	soap_default___tptz__SetHomePosition_(soap, &soap_tmp___tptz__SetHomePosition_);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__SetHomePosition_(soap, &soap_tmp___tptz__SetHomePosition_, "-tptz:SetHomePosition", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__SetHomePosition_(soap, soap_tmp___tptz__SetHomePosition_.tptz__SetHomePosition, &soap_tmp__tptz__SetHomePositionResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize___tptz__SetHomePosition_Response(soap, &soap_tmp___tptz__SetHomePosition_Response);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put___tptz__SetHomePosition_Response(soap, &soap_tmp___tptz__SetHomePosition_Response, "-tptz:SetHomePosition-Response", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put___tptz__SetHomePosition_Response(soap, &soap_tmp___tptz__SetHomePosition_Response, "-tptz:SetHomePosition-Response", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__ContinuousMove_(struct soap *soap)
{	struct __tptz__ContinuousMove_ soap_tmp___tptz__ContinuousMove_;
	struct _tptz__ContinuousMoveResponse tptz__ContinuousMoveResponse;
	soap_default__tptz__ContinuousMoveResponse(soap, &tptz__ContinuousMoveResponse);
	soap_default___tptz__ContinuousMove_(soap, &soap_tmp___tptz__ContinuousMove_);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__ContinuousMove_(soap, &soap_tmp___tptz__ContinuousMove_, "-tptz:ContinuousMove", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__ContinuousMove_(soap, soap_tmp___tptz__ContinuousMove_.tptz__ContinuousMove, &tptz__ContinuousMoveResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__ContinuousMoveResponse(soap, &tptz__ContinuousMoveResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__ContinuousMoveResponse(soap, &tptz__ContinuousMoveResponse, "tptz:ContinuousMoveResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__ContinuousMoveResponse(soap, &tptz__ContinuousMoveResponse, "tptz:ContinuousMoveResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__AbsoluteMove_(struct soap *soap)
{	struct __tptz__AbsoluteMove_ soap_tmp___tptz__AbsoluteMove_;
	struct _tptz__AbsoluteMoveResponse tptz__AbsoluteMoveResponse;
	soap_default__tptz__AbsoluteMoveResponse(soap, &tptz__AbsoluteMoveResponse);
	soap_default___tptz__AbsoluteMove_(soap, &soap_tmp___tptz__AbsoluteMove_);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__AbsoluteMove_(soap, &soap_tmp___tptz__AbsoluteMove_, "-tptz:AbsoluteMove", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__AbsoluteMove_(soap, soap_tmp___tptz__AbsoluteMove_.tptz__AbsoluteMove, &tptz__AbsoluteMoveResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__AbsoluteMoveResponse(soap, &tptz__AbsoluteMoveResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__AbsoluteMoveResponse(soap, &tptz__AbsoluteMoveResponse, "tptz:AbsoluteMoveResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__AbsoluteMoveResponse(soap, &tptz__AbsoluteMoveResponse, "tptz:AbsoluteMoveResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tptz__Stop_(struct soap *soap)
{	struct __tptz__Stop_ soap_tmp___tptz__Stop_;
	struct _tptz__StopResponse tptz__StopResponse;
	soap_default__tptz__StopResponse(soap, &tptz__StopResponse);
	soap_default___tptz__Stop_(soap, &soap_tmp___tptz__Stop_);
	soap->encodingStyle = NULL;
	if (!soap_get___tptz__Stop_(soap, &soap_tmp___tptz__Stop_, "-tptz:Stop", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tptz__Stop_(soap, soap_tmp___tptz__Stop_.tptz__Stop, &tptz__StopResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tptz__StopResponse(soap, &tptz__StopResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tptz__StopResponse(soap, &tptz__StopResponse, "tptz:StopResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tptz__StopResponse(soap, &tptz__StopResponse, "tptz:StopResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetVideoSources(struct soap *soap)
{	struct __trt__GetVideoSources soap_tmp___trt__GetVideoSources;
	struct _trt__GetVideoSourcesResponse trt__GetVideoSourcesResponse;
	soap_default__trt__GetVideoSourcesResponse(soap, &trt__GetVideoSourcesResponse);
	soap_default___trt__GetVideoSources(soap, &soap_tmp___trt__GetVideoSources);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetVideoSources(soap, &soap_tmp___trt__GetVideoSources, "-trt:GetVideoSources", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetVideoSources(soap, soap_tmp___trt__GetVideoSources.trt__GetVideoSources, &trt__GetVideoSourcesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetVideoSourcesResponse(soap, &trt__GetVideoSourcesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetVideoSourcesResponse(soap, &trt__GetVideoSourcesResponse, "trt:GetVideoSourcesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetVideoSourcesResponse(soap, &trt__GetVideoSourcesResponse, "trt:GetVideoSourcesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetAudioSources(struct soap *soap)
{	struct __trt__GetAudioSources soap_tmp___trt__GetAudioSources;
	struct _trt__GetAudioSourcesResponse trt__GetAudioSourcesResponse;
	soap_default__trt__GetAudioSourcesResponse(soap, &trt__GetAudioSourcesResponse);
	soap_default___trt__GetAudioSources(soap, &soap_tmp___trt__GetAudioSources);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetAudioSources(soap, &soap_tmp___trt__GetAudioSources, "-trt:GetAudioSources", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetAudioSources(soap, soap_tmp___trt__GetAudioSources.trt__GetAudioSources, &trt__GetAudioSourcesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetAudioSourcesResponse(soap, &trt__GetAudioSourcesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetAudioSourcesResponse(soap, &trt__GetAudioSourcesResponse, "trt:GetAudioSourcesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetAudioSourcesResponse(soap, &trt__GetAudioSourcesResponse, "trt:GetAudioSourcesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__CreateProfile(struct soap *soap)
{	struct __trt__CreateProfile soap_tmp___trt__CreateProfile;
	struct _trt__CreateProfileResponse trt__CreateProfileResponse;
	soap_default__trt__CreateProfileResponse(soap, &trt__CreateProfileResponse);
	soap_default___trt__CreateProfile(soap, &soap_tmp___trt__CreateProfile);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__CreateProfile(soap, &soap_tmp___trt__CreateProfile, "-trt:CreateProfile", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__CreateProfile(soap, soap_tmp___trt__CreateProfile.trt__CreateProfile, &trt__CreateProfileResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__CreateProfileResponse(soap, &trt__CreateProfileResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__CreateProfileResponse(soap, &trt__CreateProfileResponse, "trt:CreateProfileResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__CreateProfileResponse(soap, &trt__CreateProfileResponse, "trt:CreateProfileResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetProfile(struct soap *soap)
{	struct __trt__GetProfile soap_tmp___trt__GetProfile;
	struct _trt__GetProfileResponse trt__GetProfileResponse;
	soap_default__trt__GetProfileResponse(soap, &trt__GetProfileResponse);
	soap_default___trt__GetProfile(soap, &soap_tmp___trt__GetProfile);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetProfile(soap, &soap_tmp___trt__GetProfile, "-trt:GetProfile", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetProfile(soap, soap_tmp___trt__GetProfile.trt__GetProfile, &trt__GetProfileResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetProfileResponse(soap, &trt__GetProfileResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetProfileResponse(soap, &trt__GetProfileResponse, "trt:GetProfileResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetProfileResponse(soap, &trt__GetProfileResponse, "trt:GetProfileResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetProfiles(struct soap *soap)
{	struct __trt__GetProfiles soap_tmp___trt__GetProfiles;
	struct _trt__GetProfilesResponse trt__GetProfilesResponse;
	soap_default__trt__GetProfilesResponse(soap, &trt__GetProfilesResponse);
	soap_default___trt__GetProfiles(soap, &soap_tmp___trt__GetProfiles);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetProfiles(soap, &soap_tmp___trt__GetProfiles, "-trt:GetProfiles", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetProfiles(soap, soap_tmp___trt__GetProfiles.trt__GetProfiles, &trt__GetProfilesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetProfilesResponse(soap, &trt__GetProfilesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetProfilesResponse(soap, &trt__GetProfilesResponse, "trt:GetProfilesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetProfilesResponse(soap, &trt__GetProfilesResponse, "trt:GetProfilesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__AddVideoEncoderConfiguration(struct soap *soap)
{	struct __trt__AddVideoEncoderConfiguration soap_tmp___trt__AddVideoEncoderConfiguration;
	struct _trt__AddVideoEncoderConfigurationResponse trt__AddVideoEncoderConfigurationResponse;
	soap_default__trt__AddVideoEncoderConfigurationResponse(soap, &trt__AddVideoEncoderConfigurationResponse);
	soap_default___trt__AddVideoEncoderConfiguration(soap, &soap_tmp___trt__AddVideoEncoderConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__AddVideoEncoderConfiguration(soap, &soap_tmp___trt__AddVideoEncoderConfiguration, "-trt:AddVideoEncoderConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__AddVideoEncoderConfiguration(soap, soap_tmp___trt__AddVideoEncoderConfiguration.trt__AddVideoEncoderConfiguration, &trt__AddVideoEncoderConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__AddVideoEncoderConfigurationResponse(soap, &trt__AddVideoEncoderConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__AddVideoEncoderConfigurationResponse(soap, &trt__AddVideoEncoderConfigurationResponse, "trt:AddVideoEncoderConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__AddVideoEncoderConfigurationResponse(soap, &trt__AddVideoEncoderConfigurationResponse, "trt:AddVideoEncoderConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__AddVideoSourceConfiguration(struct soap *soap)
{	struct __trt__AddVideoSourceConfiguration soap_tmp___trt__AddVideoSourceConfiguration;
	struct _trt__AddVideoSourceConfigurationResponse trt__AddVideoSourceConfigurationResponse;
	soap_default__trt__AddVideoSourceConfigurationResponse(soap, &trt__AddVideoSourceConfigurationResponse);
	soap_default___trt__AddVideoSourceConfiguration(soap, &soap_tmp___trt__AddVideoSourceConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__AddVideoSourceConfiguration(soap, &soap_tmp___trt__AddVideoSourceConfiguration, "-trt:AddVideoSourceConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__AddVideoSourceConfiguration(soap, soap_tmp___trt__AddVideoSourceConfiguration.trt__AddVideoSourceConfiguration, &trt__AddVideoSourceConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__AddVideoSourceConfigurationResponse(soap, &trt__AddVideoSourceConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__AddVideoSourceConfigurationResponse(soap, &trt__AddVideoSourceConfigurationResponse, "trt:AddVideoSourceConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__AddVideoSourceConfigurationResponse(soap, &trt__AddVideoSourceConfigurationResponse, "trt:AddVideoSourceConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__AddAudioEncoderConfiguration(struct soap *soap)
{	struct __trt__AddAudioEncoderConfiguration soap_tmp___trt__AddAudioEncoderConfiguration;
	struct _trt__AddAudioEncoderConfigurationResponse trt__AddAudioEncoderConfigurationResponse;
	soap_default__trt__AddAudioEncoderConfigurationResponse(soap, &trt__AddAudioEncoderConfigurationResponse);
	soap_default___trt__AddAudioEncoderConfiguration(soap, &soap_tmp___trt__AddAudioEncoderConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__AddAudioEncoderConfiguration(soap, &soap_tmp___trt__AddAudioEncoderConfiguration, "-trt:AddAudioEncoderConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__AddAudioEncoderConfiguration(soap, soap_tmp___trt__AddAudioEncoderConfiguration.trt__AddAudioEncoderConfiguration, &trt__AddAudioEncoderConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__AddAudioEncoderConfigurationResponse(soap, &trt__AddAudioEncoderConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__AddAudioEncoderConfigurationResponse(soap, &trt__AddAudioEncoderConfigurationResponse, "trt:AddAudioEncoderConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__AddAudioEncoderConfigurationResponse(soap, &trt__AddAudioEncoderConfigurationResponse, "trt:AddAudioEncoderConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__AddAudioSourceConfiguration(struct soap *soap)
{	struct __trt__AddAudioSourceConfiguration soap_tmp___trt__AddAudioSourceConfiguration;
	struct _trt__AddAudioSourceConfigurationResponse trt__AddAudioSourceConfigurationResponse;
	soap_default__trt__AddAudioSourceConfigurationResponse(soap, &trt__AddAudioSourceConfigurationResponse);
	soap_default___trt__AddAudioSourceConfiguration(soap, &soap_tmp___trt__AddAudioSourceConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__AddAudioSourceConfiguration(soap, &soap_tmp___trt__AddAudioSourceConfiguration, "-trt:AddAudioSourceConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__AddAudioSourceConfiguration(soap, soap_tmp___trt__AddAudioSourceConfiguration.trt__AddAudioSourceConfiguration, &trt__AddAudioSourceConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__AddAudioSourceConfigurationResponse(soap, &trt__AddAudioSourceConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__AddAudioSourceConfigurationResponse(soap, &trt__AddAudioSourceConfigurationResponse, "trt:AddAudioSourceConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__AddAudioSourceConfigurationResponse(soap, &trt__AddAudioSourceConfigurationResponse, "trt:AddAudioSourceConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__AddPTZConfiguration(struct soap *soap)
{	struct __trt__AddPTZConfiguration soap_tmp___trt__AddPTZConfiguration;
	struct _trt__AddPTZConfigurationResponse trt__AddPTZConfigurationResponse;
	soap_default__trt__AddPTZConfigurationResponse(soap, &trt__AddPTZConfigurationResponse);
	soap_default___trt__AddPTZConfiguration(soap, &soap_tmp___trt__AddPTZConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__AddPTZConfiguration(soap, &soap_tmp___trt__AddPTZConfiguration, "-trt:AddPTZConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__AddPTZConfiguration(soap, soap_tmp___trt__AddPTZConfiguration.trt__AddPTZConfiguration, &trt__AddPTZConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__AddPTZConfigurationResponse(soap, &trt__AddPTZConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__AddPTZConfigurationResponse(soap, &trt__AddPTZConfigurationResponse, "trt:AddPTZConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__AddPTZConfigurationResponse(soap, &trt__AddPTZConfigurationResponse, "trt:AddPTZConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__AddMetadataConfiguration(struct soap *soap)
{	struct __trt__AddMetadataConfiguration soap_tmp___trt__AddMetadataConfiguration;
	struct _trt__AddMetadataConfigurationResponse trt__AddMetadataConfigurationResponse;
	soap_default__trt__AddMetadataConfigurationResponse(soap, &trt__AddMetadataConfigurationResponse);
	soap_default___trt__AddMetadataConfiguration(soap, &soap_tmp___trt__AddMetadataConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__AddMetadataConfiguration(soap, &soap_tmp___trt__AddMetadataConfiguration, "-trt:AddMetadataConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__AddMetadataConfiguration(soap, soap_tmp___trt__AddMetadataConfiguration.trt__AddMetadataConfiguration, &trt__AddMetadataConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__AddMetadataConfigurationResponse(soap, &trt__AddMetadataConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__AddMetadataConfigurationResponse(soap, &trt__AddMetadataConfigurationResponse, "trt:AddMetadataConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__AddMetadataConfigurationResponse(soap, &trt__AddMetadataConfigurationResponse, "trt:AddMetadataConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__RemoveVideoEncoderConfiguration(struct soap *soap)
{	struct __trt__RemoveVideoEncoderConfiguration soap_tmp___trt__RemoveVideoEncoderConfiguration;
	struct _trt__RemoveVideoEncoderConfigurationResponse trt__RemoveVideoEncoderConfigurationResponse;
	soap_default__trt__RemoveVideoEncoderConfigurationResponse(soap, &trt__RemoveVideoEncoderConfigurationResponse);
	soap_default___trt__RemoveVideoEncoderConfiguration(soap, &soap_tmp___trt__RemoveVideoEncoderConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__RemoveVideoEncoderConfiguration(soap, &soap_tmp___trt__RemoveVideoEncoderConfiguration, "-trt:RemoveVideoEncoderConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__RemoveVideoEncoderConfiguration(soap, soap_tmp___trt__RemoveVideoEncoderConfiguration.trt__RemoveVideoEncoderConfiguration, &trt__RemoveVideoEncoderConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__RemoveVideoEncoderConfigurationResponse(soap, &trt__RemoveVideoEncoderConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__RemoveVideoEncoderConfigurationResponse(soap, &trt__RemoveVideoEncoderConfigurationResponse, "trt:RemoveVideoEncoderConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__RemoveVideoEncoderConfigurationResponse(soap, &trt__RemoveVideoEncoderConfigurationResponse, "trt:RemoveVideoEncoderConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__RemoveVideoSourceConfiguration(struct soap *soap)
{	struct __trt__RemoveVideoSourceConfiguration soap_tmp___trt__RemoveVideoSourceConfiguration;
	struct _trt__RemoveVideoSourceConfigurationResponse trt__RemoveVideoSourceConfigurationResponse;
	soap_default__trt__RemoveVideoSourceConfigurationResponse(soap, &trt__RemoveVideoSourceConfigurationResponse);
	soap_default___trt__RemoveVideoSourceConfiguration(soap, &soap_tmp___trt__RemoveVideoSourceConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__RemoveVideoSourceConfiguration(soap, &soap_tmp___trt__RemoveVideoSourceConfiguration, "-trt:RemoveVideoSourceConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__RemoveVideoSourceConfiguration(soap, soap_tmp___trt__RemoveVideoSourceConfiguration.trt__RemoveVideoSourceConfiguration, &trt__RemoveVideoSourceConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__RemoveVideoSourceConfigurationResponse(soap, &trt__RemoveVideoSourceConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__RemoveVideoSourceConfigurationResponse(soap, &trt__RemoveVideoSourceConfigurationResponse, "trt:RemoveVideoSourceConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__RemoveVideoSourceConfigurationResponse(soap, &trt__RemoveVideoSourceConfigurationResponse, "trt:RemoveVideoSourceConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__RemoveAudioEncoderConfiguration(struct soap *soap)
{	struct __trt__RemoveAudioEncoderConfiguration soap_tmp___trt__RemoveAudioEncoderConfiguration;
	struct _trt__RemoveAudioEncoderConfigurationResponse trt__RemoveAudioEncoderConfigurationResponse;
	soap_default__trt__RemoveAudioEncoderConfigurationResponse(soap, &trt__RemoveAudioEncoderConfigurationResponse);
	soap_default___trt__RemoveAudioEncoderConfiguration(soap, &soap_tmp___trt__RemoveAudioEncoderConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__RemoveAudioEncoderConfiguration(soap, &soap_tmp___trt__RemoveAudioEncoderConfiguration, "-trt:RemoveAudioEncoderConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__RemoveAudioEncoderConfiguration(soap, soap_tmp___trt__RemoveAudioEncoderConfiguration.trt__RemoveAudioEncoderConfiguration, &trt__RemoveAudioEncoderConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__RemoveAudioEncoderConfigurationResponse(soap, &trt__RemoveAudioEncoderConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__RemoveAudioEncoderConfigurationResponse(soap, &trt__RemoveAudioEncoderConfigurationResponse, "trt:RemoveAudioEncoderConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__RemoveAudioEncoderConfigurationResponse(soap, &trt__RemoveAudioEncoderConfigurationResponse, "trt:RemoveAudioEncoderConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__RemoveAudioSourceConfiguration(struct soap *soap)
{	struct __trt__RemoveAudioSourceConfiguration soap_tmp___trt__RemoveAudioSourceConfiguration;
	struct _trt__RemoveAudioSourceConfigurationResponse trt__RemoveAudioSourceConfigurationResponse;
	soap_default__trt__RemoveAudioSourceConfigurationResponse(soap, &trt__RemoveAudioSourceConfigurationResponse);
	soap_default___trt__RemoveAudioSourceConfiguration(soap, &soap_tmp___trt__RemoveAudioSourceConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__RemoveAudioSourceConfiguration(soap, &soap_tmp___trt__RemoveAudioSourceConfiguration, "-trt:RemoveAudioSourceConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__RemoveAudioSourceConfiguration(soap, soap_tmp___trt__RemoveAudioSourceConfiguration.trt__RemoveAudioSourceConfiguration, &trt__RemoveAudioSourceConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__RemoveAudioSourceConfigurationResponse(soap, &trt__RemoveAudioSourceConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__RemoveAudioSourceConfigurationResponse(soap, &trt__RemoveAudioSourceConfigurationResponse, "trt:RemoveAudioSourceConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__RemoveAudioSourceConfigurationResponse(soap, &trt__RemoveAudioSourceConfigurationResponse, "trt:RemoveAudioSourceConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__RemovePTZConfiguration(struct soap *soap)
{	struct __trt__RemovePTZConfiguration soap_tmp___trt__RemovePTZConfiguration;
	struct _trt__RemovePTZConfigurationResponse trt__RemovePTZConfigurationResponse;
	soap_default__trt__RemovePTZConfigurationResponse(soap, &trt__RemovePTZConfigurationResponse);
	soap_default___trt__RemovePTZConfiguration(soap, &soap_tmp___trt__RemovePTZConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__RemovePTZConfiguration(soap, &soap_tmp___trt__RemovePTZConfiguration, "-trt:RemovePTZConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__RemovePTZConfiguration(soap, soap_tmp___trt__RemovePTZConfiguration.trt__RemovePTZConfiguration, &trt__RemovePTZConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__RemovePTZConfigurationResponse(soap, &trt__RemovePTZConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__RemovePTZConfigurationResponse(soap, &trt__RemovePTZConfigurationResponse, "trt:RemovePTZConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__RemovePTZConfigurationResponse(soap, &trt__RemovePTZConfigurationResponse, "trt:RemovePTZConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__RemoveMetadataConfiguration(struct soap *soap)
{	struct __trt__RemoveMetadataConfiguration soap_tmp___trt__RemoveMetadataConfiguration;
	struct _trt__RemoveMetadataConfigurationResponse trt__RemoveMetadataConfigurationResponse;
	soap_default__trt__RemoveMetadataConfigurationResponse(soap, &trt__RemoveMetadataConfigurationResponse);
	soap_default___trt__RemoveMetadataConfiguration(soap, &soap_tmp___trt__RemoveMetadataConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__RemoveMetadataConfiguration(soap, &soap_tmp___trt__RemoveMetadataConfiguration, "-trt:RemoveMetadataConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__RemoveMetadataConfiguration(soap, soap_tmp___trt__RemoveMetadataConfiguration.trt__RemoveMetadataConfiguration, &trt__RemoveMetadataConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__RemoveMetadataConfigurationResponse(soap, &trt__RemoveMetadataConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__RemoveMetadataConfigurationResponse(soap, &trt__RemoveMetadataConfigurationResponse, "trt:RemoveMetadataConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__RemoveMetadataConfigurationResponse(soap, &trt__RemoveMetadataConfigurationResponse, "trt:RemoveMetadataConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__DeleteProfile(struct soap *soap)
{	struct __trt__DeleteProfile soap_tmp___trt__DeleteProfile;
	struct _trt__DeleteProfileResponse trt__DeleteProfileResponse;
	soap_default__trt__DeleteProfileResponse(soap, &trt__DeleteProfileResponse);
	soap_default___trt__DeleteProfile(soap, &soap_tmp___trt__DeleteProfile);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__DeleteProfile(soap, &soap_tmp___trt__DeleteProfile, "-trt:DeleteProfile", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__DeleteProfile(soap, soap_tmp___trt__DeleteProfile.trt__DeleteProfile, &trt__DeleteProfileResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__DeleteProfileResponse(soap, &trt__DeleteProfileResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__DeleteProfileResponse(soap, &trt__DeleteProfileResponse, "trt:DeleteProfileResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__DeleteProfileResponse(soap, &trt__DeleteProfileResponse, "trt:DeleteProfileResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetVideoSourceConfigurations(struct soap *soap)
{	struct __trt__GetVideoSourceConfigurations soap_tmp___trt__GetVideoSourceConfigurations;
	struct _trt__GetVideoSourceConfigurationsResponse trt__GetVideoSourceConfigurationsResponse;
	soap_default__trt__GetVideoSourceConfigurationsResponse(soap, &trt__GetVideoSourceConfigurationsResponse);
	soap_default___trt__GetVideoSourceConfigurations(soap, &soap_tmp___trt__GetVideoSourceConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetVideoSourceConfigurations(soap, &soap_tmp___trt__GetVideoSourceConfigurations, "-trt:GetVideoSourceConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetVideoSourceConfigurations(soap, soap_tmp___trt__GetVideoSourceConfigurations.trt__GetVideoSourceConfigurations, &trt__GetVideoSourceConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetVideoSourceConfigurationsResponse(soap, &trt__GetVideoSourceConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetVideoSourceConfigurationsResponse(soap, &trt__GetVideoSourceConfigurationsResponse, "trt:GetVideoSourceConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetVideoSourceConfigurationsResponse(soap, &trt__GetVideoSourceConfigurationsResponse, "trt:GetVideoSourceConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetVideoEncoderConfigurations(struct soap *soap)
{	struct __trt__GetVideoEncoderConfigurations soap_tmp___trt__GetVideoEncoderConfigurations;
	struct _trt__GetVideoEncoderConfigurationsResponse trt__GetVideoEncoderConfigurationsResponse;
	soap_default__trt__GetVideoEncoderConfigurationsResponse(soap, &trt__GetVideoEncoderConfigurationsResponse);
	soap_default___trt__GetVideoEncoderConfigurations(soap, &soap_tmp___trt__GetVideoEncoderConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetVideoEncoderConfigurations(soap, &soap_tmp___trt__GetVideoEncoderConfigurations, "-trt:GetVideoEncoderConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetVideoEncoderConfigurations(soap, soap_tmp___trt__GetVideoEncoderConfigurations.trt__GetVideoEncoderConfigurations, &trt__GetVideoEncoderConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetVideoEncoderConfigurationsResponse(soap, &trt__GetVideoEncoderConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetVideoEncoderConfigurationsResponse(soap, &trt__GetVideoEncoderConfigurationsResponse, "trt:GetVideoEncoderConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetVideoEncoderConfigurationsResponse(soap, &trt__GetVideoEncoderConfigurationsResponse, "trt:GetVideoEncoderConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetAudioSourceConfigurations(struct soap *soap)
{	struct __trt__GetAudioSourceConfigurations soap_tmp___trt__GetAudioSourceConfigurations;
	struct _trt__GetAudioSourceConfigurationsResponse trt__GetAudioSourceConfigurationsResponse;
	soap_default__trt__GetAudioSourceConfigurationsResponse(soap, &trt__GetAudioSourceConfigurationsResponse);
	soap_default___trt__GetAudioSourceConfigurations(soap, &soap_tmp___trt__GetAudioSourceConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetAudioSourceConfigurations(soap, &soap_tmp___trt__GetAudioSourceConfigurations, "-trt:GetAudioSourceConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetAudioSourceConfigurations(soap, soap_tmp___trt__GetAudioSourceConfigurations.trt__GetAudioSourceConfigurations, &trt__GetAudioSourceConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetAudioSourceConfigurationsResponse(soap, &trt__GetAudioSourceConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetAudioSourceConfigurationsResponse(soap, &trt__GetAudioSourceConfigurationsResponse, "trt:GetAudioSourceConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetAudioSourceConfigurationsResponse(soap, &trt__GetAudioSourceConfigurationsResponse, "trt:GetAudioSourceConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetAudioEncoderConfigurations(struct soap *soap)
{	struct __trt__GetAudioEncoderConfigurations soap_tmp___trt__GetAudioEncoderConfigurations;
	struct _trt__GetAudioEncoderConfigurationsResponse trt__GetAudioEncoderConfigurationsResponse;
	soap_default__trt__GetAudioEncoderConfigurationsResponse(soap, &trt__GetAudioEncoderConfigurationsResponse);
	soap_default___trt__GetAudioEncoderConfigurations(soap, &soap_tmp___trt__GetAudioEncoderConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetAudioEncoderConfigurations(soap, &soap_tmp___trt__GetAudioEncoderConfigurations, "-trt:GetAudioEncoderConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetAudioEncoderConfigurations(soap, soap_tmp___trt__GetAudioEncoderConfigurations.trt__GetAudioEncoderConfigurations, &trt__GetAudioEncoderConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetAudioEncoderConfigurationsResponse(soap, &trt__GetAudioEncoderConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetAudioEncoderConfigurationsResponse(soap, &trt__GetAudioEncoderConfigurationsResponse, "trt:GetAudioEncoderConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetAudioEncoderConfigurationsResponse(soap, &trt__GetAudioEncoderConfigurationsResponse, "trt:GetAudioEncoderConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetMetadataConfigurations(struct soap *soap)
{	struct __trt__GetMetadataConfigurations soap_tmp___trt__GetMetadataConfigurations;
	struct _trt__GetMetadataConfigurationsResponse trt__GetMetadataConfigurationsResponse;
	soap_default__trt__GetMetadataConfigurationsResponse(soap, &trt__GetMetadataConfigurationsResponse);
	soap_default___trt__GetMetadataConfigurations(soap, &soap_tmp___trt__GetMetadataConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetMetadataConfigurations(soap, &soap_tmp___trt__GetMetadataConfigurations, "-trt:GetMetadataConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetMetadataConfigurations(soap, soap_tmp___trt__GetMetadataConfigurations.trt__GetMetadataConfigurations, &trt__GetMetadataConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetMetadataConfigurationsResponse(soap, &trt__GetMetadataConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetMetadataConfigurationsResponse(soap, &trt__GetMetadataConfigurationsResponse, "trt:GetMetadataConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetMetadataConfigurationsResponse(soap, &trt__GetMetadataConfigurationsResponse, "trt:GetMetadataConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetVideoSourceConfiguration(struct soap *soap)
{	struct __trt__GetVideoSourceConfiguration soap_tmp___trt__GetVideoSourceConfiguration;
	struct _trt__GetVideoSourceConfigurationResponse trt__GetVideoSourceConfigurationResponse;
	soap_default__trt__GetVideoSourceConfigurationResponse(soap, &trt__GetVideoSourceConfigurationResponse);
	soap_default___trt__GetVideoSourceConfiguration(soap, &soap_tmp___trt__GetVideoSourceConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetVideoSourceConfiguration(soap, &soap_tmp___trt__GetVideoSourceConfiguration, "-trt:GetVideoSourceConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetVideoSourceConfiguration(soap, soap_tmp___trt__GetVideoSourceConfiguration.trt__GetVideoSourceConfiguration, &trt__GetVideoSourceConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetVideoSourceConfigurationResponse(soap, &trt__GetVideoSourceConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetVideoSourceConfigurationResponse(soap, &trt__GetVideoSourceConfigurationResponse, "trt:GetVideoSourceConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetVideoSourceConfigurationResponse(soap, &trt__GetVideoSourceConfigurationResponse, "trt:GetVideoSourceConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetVideoEncoderConfiguration(struct soap *soap)
{	struct __trt__GetVideoEncoderConfiguration soap_tmp___trt__GetVideoEncoderConfiguration;
	struct _trt__GetVideoEncoderConfigurationResponse trt__GetVideoEncoderConfigurationResponse;
	soap_default__trt__GetVideoEncoderConfigurationResponse(soap, &trt__GetVideoEncoderConfigurationResponse);
	soap_default___trt__GetVideoEncoderConfiguration(soap, &soap_tmp___trt__GetVideoEncoderConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetVideoEncoderConfiguration(soap, &soap_tmp___trt__GetVideoEncoderConfiguration, "-trt:GetVideoEncoderConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetVideoEncoderConfiguration(soap, soap_tmp___trt__GetVideoEncoderConfiguration.trt__GetVideoEncoderConfiguration, &trt__GetVideoEncoderConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetVideoEncoderConfigurationResponse(soap, &trt__GetVideoEncoderConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetVideoEncoderConfigurationResponse(soap, &trt__GetVideoEncoderConfigurationResponse, "trt:GetVideoEncoderConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetVideoEncoderConfigurationResponse(soap, &trt__GetVideoEncoderConfigurationResponse, "trt:GetVideoEncoderConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetAudioSourceConfiguration(struct soap *soap)
{	struct __trt__GetAudioSourceConfiguration soap_tmp___trt__GetAudioSourceConfiguration;
	struct _trt__GetAudioSourceConfigurationResponse trt__GetAudioSourceConfigurationResponse;
	soap_default__trt__GetAudioSourceConfigurationResponse(soap, &trt__GetAudioSourceConfigurationResponse);
	soap_default___trt__GetAudioSourceConfiguration(soap, &soap_tmp___trt__GetAudioSourceConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetAudioSourceConfiguration(soap, &soap_tmp___trt__GetAudioSourceConfiguration, "-trt:GetAudioSourceConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetAudioSourceConfiguration(soap, soap_tmp___trt__GetAudioSourceConfiguration.trt__GetAudioSourceConfiguration, &trt__GetAudioSourceConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetAudioSourceConfigurationResponse(soap, &trt__GetAudioSourceConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetAudioSourceConfigurationResponse(soap, &trt__GetAudioSourceConfigurationResponse, "trt:GetAudioSourceConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetAudioSourceConfigurationResponse(soap, &trt__GetAudioSourceConfigurationResponse, "trt:GetAudioSourceConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetAudioEncoderConfiguration(struct soap *soap)
{	struct __trt__GetAudioEncoderConfiguration soap_tmp___trt__GetAudioEncoderConfiguration;
	struct _trt__GetAudioEncoderConfigurationResponse trt__GetAudioEncoderConfigurationResponse;
	soap_default__trt__GetAudioEncoderConfigurationResponse(soap, &trt__GetAudioEncoderConfigurationResponse);
	soap_default___trt__GetAudioEncoderConfiguration(soap, &soap_tmp___trt__GetAudioEncoderConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetAudioEncoderConfiguration(soap, &soap_tmp___trt__GetAudioEncoderConfiguration, "-trt:GetAudioEncoderConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetAudioEncoderConfiguration(soap, soap_tmp___trt__GetAudioEncoderConfiguration.trt__GetAudioEncoderConfiguration, &trt__GetAudioEncoderConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetAudioEncoderConfigurationResponse(soap, &trt__GetAudioEncoderConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetAudioEncoderConfigurationResponse(soap, &trt__GetAudioEncoderConfigurationResponse, "trt:GetAudioEncoderConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetAudioEncoderConfigurationResponse(soap, &trt__GetAudioEncoderConfigurationResponse, "trt:GetAudioEncoderConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetMetadataConfiguration(struct soap *soap)
{	struct __trt__GetMetadataConfiguration soap_tmp___trt__GetMetadataConfiguration;
	struct _trt__GetMetadataConfigurationResponse trt__GetMetadataConfigurationResponse;
	soap_default__trt__GetMetadataConfigurationResponse(soap, &trt__GetMetadataConfigurationResponse);
	soap_default___trt__GetMetadataConfiguration(soap, &soap_tmp___trt__GetMetadataConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetMetadataConfiguration(soap, &soap_tmp___trt__GetMetadataConfiguration, "-trt:GetMetadataConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetMetadataConfiguration(soap, soap_tmp___trt__GetMetadataConfiguration.trt__GetMetadataConfiguration, &trt__GetMetadataConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetMetadataConfigurationResponse(soap, &trt__GetMetadataConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetMetadataConfigurationResponse(soap, &trt__GetMetadataConfigurationResponse, "trt:GetMetadataConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetMetadataConfigurationResponse(soap, &trt__GetMetadataConfigurationResponse, "trt:GetMetadataConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap)
{	struct __trt__GetCompatibleVideoEncoderConfigurations soap_tmp___trt__GetCompatibleVideoEncoderConfigurations;
	struct _trt__GetCompatibleVideoEncoderConfigurationsResponse trt__GetCompatibleVideoEncoderConfigurationsResponse;
	soap_default__trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, &trt__GetCompatibleVideoEncoderConfigurationsResponse);
	soap_default___trt__GetCompatibleVideoEncoderConfigurations(soap, &soap_tmp___trt__GetCompatibleVideoEncoderConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetCompatibleVideoEncoderConfigurations(soap, &soap_tmp___trt__GetCompatibleVideoEncoderConfigurations, "-trt:GetCompatibleVideoEncoderConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetCompatibleVideoEncoderConfigurations(soap, soap_tmp___trt__GetCompatibleVideoEncoderConfigurations.trt__GetCompatibleVideoEncoderConfigurations, &trt__GetCompatibleVideoEncoderConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, &trt__GetCompatibleVideoEncoderConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, &trt__GetCompatibleVideoEncoderConfigurationsResponse, "trt:GetCompatibleVideoEncoderConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, &trt__GetCompatibleVideoEncoderConfigurationsResponse, "trt:GetCompatibleVideoEncoderConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetCompatibleVideoSourceConfigurations(struct soap *soap)
{	struct __trt__GetCompatibleVideoSourceConfigurations soap_tmp___trt__GetCompatibleVideoSourceConfigurations;
	struct _trt__GetCompatibleVideoSourceConfigurationsResponse trt__GetCompatibleVideoSourceConfigurationsResponse;
	soap_default__trt__GetCompatibleVideoSourceConfigurationsResponse(soap, &trt__GetCompatibleVideoSourceConfigurationsResponse);
	soap_default___trt__GetCompatibleVideoSourceConfigurations(soap, &soap_tmp___trt__GetCompatibleVideoSourceConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetCompatibleVideoSourceConfigurations(soap, &soap_tmp___trt__GetCompatibleVideoSourceConfigurations, "-trt:GetCompatibleVideoSourceConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetCompatibleVideoSourceConfigurations(soap, soap_tmp___trt__GetCompatibleVideoSourceConfigurations.trt__GetCompatibleVideoSourceConfigurations, &trt__GetCompatibleVideoSourceConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetCompatibleVideoSourceConfigurationsResponse(soap, &trt__GetCompatibleVideoSourceConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetCompatibleVideoSourceConfigurationsResponse(soap, &trt__GetCompatibleVideoSourceConfigurationsResponse, "trt:GetCompatibleVideoSourceConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetCompatibleVideoSourceConfigurationsResponse(soap, &trt__GetCompatibleVideoSourceConfigurationsResponse, "trt:GetCompatibleVideoSourceConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap)
{	struct __trt__GetCompatibleAudioEncoderConfigurations soap_tmp___trt__GetCompatibleAudioEncoderConfigurations;
	struct _trt__GetCompatibleAudioEncoderConfigurationsResponse trt__GetCompatibleAudioEncoderConfigurationsResponse;
	soap_default__trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, &trt__GetCompatibleAudioEncoderConfigurationsResponse);
	soap_default___trt__GetCompatibleAudioEncoderConfigurations(soap, &soap_tmp___trt__GetCompatibleAudioEncoderConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetCompatibleAudioEncoderConfigurations(soap, &soap_tmp___trt__GetCompatibleAudioEncoderConfigurations, "-trt:GetCompatibleAudioEncoderConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetCompatibleAudioEncoderConfigurations(soap, soap_tmp___trt__GetCompatibleAudioEncoderConfigurations.trt__GetCompatibleAudioEncoderConfigurations, &trt__GetCompatibleAudioEncoderConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, &trt__GetCompatibleAudioEncoderConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, &trt__GetCompatibleAudioEncoderConfigurationsResponse, "trt:GetCompatibleAudioEncoderConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, &trt__GetCompatibleAudioEncoderConfigurationsResponse, "trt:GetCompatibleAudioEncoderConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetCompatibleAudioSourceConfigurations(struct soap *soap)
{	struct __trt__GetCompatibleAudioSourceConfigurations soap_tmp___trt__GetCompatibleAudioSourceConfigurations;
	struct _trt__GetCompatibleAudioSourceConfigurationsResponse trt__GetCompatibleAudioSourceConfigurationsResponse;
	soap_default__trt__GetCompatibleAudioSourceConfigurationsResponse(soap, &trt__GetCompatibleAudioSourceConfigurationsResponse);
	soap_default___trt__GetCompatibleAudioSourceConfigurations(soap, &soap_tmp___trt__GetCompatibleAudioSourceConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetCompatibleAudioSourceConfigurations(soap, &soap_tmp___trt__GetCompatibleAudioSourceConfigurations, "-trt:GetCompatibleAudioSourceConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetCompatibleAudioSourceConfigurations(soap, soap_tmp___trt__GetCompatibleAudioSourceConfigurations.trt__GetCompatibleAudioSourceConfigurations, &trt__GetCompatibleAudioSourceConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetCompatibleAudioSourceConfigurationsResponse(soap, &trt__GetCompatibleAudioSourceConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetCompatibleAudioSourceConfigurationsResponse(soap, &trt__GetCompatibleAudioSourceConfigurationsResponse, "trt:GetCompatibleAudioSourceConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetCompatibleAudioSourceConfigurationsResponse(soap, &trt__GetCompatibleAudioSourceConfigurationsResponse, "trt:GetCompatibleAudioSourceConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetCompatibleMetadataConfigurations(struct soap *soap)
{	struct __trt__GetCompatibleMetadataConfigurations soap_tmp___trt__GetCompatibleMetadataConfigurations;
	struct _trt__GetCompatibleMetadataConfigurationsResponse trt__GetCompatibleMetadataConfigurationsResponse;
	soap_default__trt__GetCompatibleMetadataConfigurationsResponse(soap, &trt__GetCompatibleMetadataConfigurationsResponse);
	soap_default___trt__GetCompatibleMetadataConfigurations(soap, &soap_tmp___trt__GetCompatibleMetadataConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetCompatibleMetadataConfigurations(soap, &soap_tmp___trt__GetCompatibleMetadataConfigurations, "-trt:GetCompatibleMetadataConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetCompatibleMetadataConfigurations(soap, soap_tmp___trt__GetCompatibleMetadataConfigurations.trt__GetCompatibleMetadataConfigurations, &trt__GetCompatibleMetadataConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetCompatibleMetadataConfigurationsResponse(soap, &trt__GetCompatibleMetadataConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetCompatibleMetadataConfigurationsResponse(soap, &trt__GetCompatibleMetadataConfigurationsResponse, "trt:GetCompatibleMetadataConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetCompatibleMetadataConfigurationsResponse(soap, &trt__GetCompatibleMetadataConfigurationsResponse, "trt:GetCompatibleMetadataConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__SetVideoSourceConfiguration(struct soap *soap)
{	struct __trt__SetVideoSourceConfiguration soap_tmp___trt__SetVideoSourceConfiguration;
	struct _trt__SetVideoSourceConfigurationResponse trt__SetVideoSourceConfigurationResponse;
	soap_default__trt__SetVideoSourceConfigurationResponse(soap, &trt__SetVideoSourceConfigurationResponse);
	soap_default___trt__SetVideoSourceConfiguration(soap, &soap_tmp___trt__SetVideoSourceConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__SetVideoSourceConfiguration(soap, &soap_tmp___trt__SetVideoSourceConfiguration, "-trt:SetVideoSourceConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__SetVideoSourceConfiguration(soap, soap_tmp___trt__SetVideoSourceConfiguration.trt__SetVideoSourceConfiguration, &trt__SetVideoSourceConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__SetVideoSourceConfigurationResponse(soap, &trt__SetVideoSourceConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__SetVideoSourceConfigurationResponse(soap, &trt__SetVideoSourceConfigurationResponse, "trt:SetVideoSourceConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__SetVideoSourceConfigurationResponse(soap, &trt__SetVideoSourceConfigurationResponse, "trt:SetVideoSourceConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__SetVideoEncoderConfiguration(struct soap *soap)
{	struct __trt__SetVideoEncoderConfiguration soap_tmp___trt__SetVideoEncoderConfiguration;
	struct _trt__SetVideoEncoderConfigurationResponse trt__SetVideoEncoderConfigurationResponse;
	soap_default__trt__SetVideoEncoderConfigurationResponse(soap, &trt__SetVideoEncoderConfigurationResponse);
	soap_default___trt__SetVideoEncoderConfiguration(soap, &soap_tmp___trt__SetVideoEncoderConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__SetVideoEncoderConfiguration(soap, &soap_tmp___trt__SetVideoEncoderConfiguration, "-trt:SetVideoEncoderConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__SetVideoEncoderConfiguration(soap, soap_tmp___trt__SetVideoEncoderConfiguration.trt__SetVideoEncoderConfiguration, &trt__SetVideoEncoderConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__SetVideoEncoderConfigurationResponse(soap, &trt__SetVideoEncoderConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__SetVideoEncoderConfigurationResponse(soap, &trt__SetVideoEncoderConfigurationResponse, "trt:SetVideoEncoderConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__SetVideoEncoderConfigurationResponse(soap, &trt__SetVideoEncoderConfigurationResponse, "trt:SetVideoEncoderConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__SetAudioSourceConfiguration(struct soap *soap)
{	struct __trt__SetAudioSourceConfiguration soap_tmp___trt__SetAudioSourceConfiguration;
	struct _trt__SetAudioSourceConfigurationResponse trt__SetAudioSourceConfigurationResponse;
	soap_default__trt__SetAudioSourceConfigurationResponse(soap, &trt__SetAudioSourceConfigurationResponse);
	soap_default___trt__SetAudioSourceConfiguration(soap, &soap_tmp___trt__SetAudioSourceConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__SetAudioSourceConfiguration(soap, &soap_tmp___trt__SetAudioSourceConfiguration, "-trt:SetAudioSourceConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__SetAudioSourceConfiguration(soap, soap_tmp___trt__SetAudioSourceConfiguration.trt__SetAudioSourceConfiguration, &trt__SetAudioSourceConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__SetAudioSourceConfigurationResponse(soap, &trt__SetAudioSourceConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__SetAudioSourceConfigurationResponse(soap, &trt__SetAudioSourceConfigurationResponse, "trt:SetAudioSourceConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__SetAudioSourceConfigurationResponse(soap, &trt__SetAudioSourceConfigurationResponse, "trt:SetAudioSourceConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__SetAudioEncoderConfiguration(struct soap *soap)
{	struct __trt__SetAudioEncoderConfiguration soap_tmp___trt__SetAudioEncoderConfiguration;
	struct _trt__SetAudioEncoderConfigurationResponse trt__SetAudioEncoderConfigurationResponse;
	soap_default__trt__SetAudioEncoderConfigurationResponse(soap, &trt__SetAudioEncoderConfigurationResponse);
	soap_default___trt__SetAudioEncoderConfiguration(soap, &soap_tmp___trt__SetAudioEncoderConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__SetAudioEncoderConfiguration(soap, &soap_tmp___trt__SetAudioEncoderConfiguration, "-trt:SetAudioEncoderConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__SetAudioEncoderConfiguration(soap, soap_tmp___trt__SetAudioEncoderConfiguration.trt__SetAudioEncoderConfiguration, &trt__SetAudioEncoderConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__SetAudioEncoderConfigurationResponse(soap, &trt__SetAudioEncoderConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__SetAudioEncoderConfigurationResponse(soap, &trt__SetAudioEncoderConfigurationResponse, "trt:SetAudioEncoderConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__SetAudioEncoderConfigurationResponse(soap, &trt__SetAudioEncoderConfigurationResponse, "trt:SetAudioEncoderConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__SetMetadataConfiguration(struct soap *soap)
{	struct __trt__SetMetadataConfiguration soap_tmp___trt__SetMetadataConfiguration;
	struct _trt__SetMetadataConfigurationResponse trt__SetMetadataConfigurationResponse;
	soap_default__trt__SetMetadataConfigurationResponse(soap, &trt__SetMetadataConfigurationResponse);
	soap_default___trt__SetMetadataConfiguration(soap, &soap_tmp___trt__SetMetadataConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__SetMetadataConfiguration(soap, &soap_tmp___trt__SetMetadataConfiguration, "-trt:SetMetadataConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__SetMetadataConfiguration(soap, soap_tmp___trt__SetMetadataConfiguration.trt__SetMetadataConfiguration, &trt__SetMetadataConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__SetMetadataConfigurationResponse(soap, &trt__SetMetadataConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__SetMetadataConfigurationResponse(soap, &trt__SetMetadataConfigurationResponse, "trt:SetMetadataConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__SetMetadataConfigurationResponse(soap, &trt__SetMetadataConfigurationResponse, "trt:SetMetadataConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetVideoSourceConfigurationOptions(struct soap *soap)
{	struct __trt__GetVideoSourceConfigurationOptions soap_tmp___trt__GetVideoSourceConfigurationOptions;
	struct _trt__GetVideoSourceConfigurationOptionsResponse trt__GetVideoSourceConfigurationOptionsResponse;
	soap_default__trt__GetVideoSourceConfigurationOptionsResponse(soap, &trt__GetVideoSourceConfigurationOptionsResponse);
	soap_default___trt__GetVideoSourceConfigurationOptions(soap, &soap_tmp___trt__GetVideoSourceConfigurationOptions);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetVideoSourceConfigurationOptions(soap, &soap_tmp___trt__GetVideoSourceConfigurationOptions, "-trt:GetVideoSourceConfigurationOptions", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetVideoSourceConfigurationOptions(soap, soap_tmp___trt__GetVideoSourceConfigurationOptions.trt__GetVideoSourceConfigurationOptions, &trt__GetVideoSourceConfigurationOptionsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetVideoSourceConfigurationOptionsResponse(soap, &trt__GetVideoSourceConfigurationOptionsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetVideoSourceConfigurationOptionsResponse(soap, &trt__GetVideoSourceConfigurationOptionsResponse, "trt:GetVideoSourceConfigurationOptionsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetVideoSourceConfigurationOptionsResponse(soap, &trt__GetVideoSourceConfigurationOptionsResponse, "trt:GetVideoSourceConfigurationOptionsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetVideoEncoderConfigurationOptions(struct soap *soap)
{	struct __trt__GetVideoEncoderConfigurationOptions soap_tmp___trt__GetVideoEncoderConfigurationOptions;
	struct _trt__GetVideoEncoderConfigurationOptionsResponse trt__GetVideoEncoderConfigurationOptionsResponse;
	soap_default__trt__GetVideoEncoderConfigurationOptionsResponse(soap, &trt__GetVideoEncoderConfigurationOptionsResponse);
	soap_default___trt__GetVideoEncoderConfigurationOptions(soap, &soap_tmp___trt__GetVideoEncoderConfigurationOptions);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetVideoEncoderConfigurationOptions(soap, &soap_tmp___trt__GetVideoEncoderConfigurationOptions, "-trt:GetVideoEncoderConfigurationOptions", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetVideoEncoderConfigurationOptions(soap, soap_tmp___trt__GetVideoEncoderConfigurationOptions.trt__GetVideoEncoderConfigurationOptions, &trt__GetVideoEncoderConfigurationOptionsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetVideoEncoderConfigurationOptionsResponse(soap, &trt__GetVideoEncoderConfigurationOptionsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetVideoEncoderConfigurationOptionsResponse(soap, &trt__GetVideoEncoderConfigurationOptionsResponse, "trt:GetVideoEncoderConfigurationOptionsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetVideoEncoderConfigurationOptionsResponse(soap, &trt__GetVideoEncoderConfigurationOptionsResponse, "trt:GetVideoEncoderConfigurationOptionsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetAudioSourceConfigurationOptions(struct soap *soap)
{	struct __trt__GetAudioSourceConfigurationOptions soap_tmp___trt__GetAudioSourceConfigurationOptions;
	struct _trt__GetAudioSourceConfigurationOptionsResponse trt__GetAudioSourceConfigurationOptionsResponse;
	soap_default__trt__GetAudioSourceConfigurationOptionsResponse(soap, &trt__GetAudioSourceConfigurationOptionsResponse);
	soap_default___trt__GetAudioSourceConfigurationOptions(soap, &soap_tmp___trt__GetAudioSourceConfigurationOptions);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetAudioSourceConfigurationOptions(soap, &soap_tmp___trt__GetAudioSourceConfigurationOptions, "-trt:GetAudioSourceConfigurationOptions", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetAudioSourceConfigurationOptions(soap, soap_tmp___trt__GetAudioSourceConfigurationOptions.trt__GetAudioSourceConfigurationOptions, &trt__GetAudioSourceConfigurationOptionsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetAudioSourceConfigurationOptionsResponse(soap, &trt__GetAudioSourceConfigurationOptionsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetAudioSourceConfigurationOptionsResponse(soap, &trt__GetAudioSourceConfigurationOptionsResponse, "trt:GetAudioSourceConfigurationOptionsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetAudioSourceConfigurationOptionsResponse(soap, &trt__GetAudioSourceConfigurationOptionsResponse, "trt:GetAudioSourceConfigurationOptionsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetAudioEncoderConfigurationOptions(struct soap *soap)
{	struct __trt__GetAudioEncoderConfigurationOptions soap_tmp___trt__GetAudioEncoderConfigurationOptions;
	struct _trt__GetAudioEncoderConfigurationOptionsResponse trt__GetAudioEncoderConfigurationOptionsResponse;
	soap_default__trt__GetAudioEncoderConfigurationOptionsResponse(soap, &trt__GetAudioEncoderConfigurationOptionsResponse);
	soap_default___trt__GetAudioEncoderConfigurationOptions(soap, &soap_tmp___trt__GetAudioEncoderConfigurationOptions);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetAudioEncoderConfigurationOptions(soap, &soap_tmp___trt__GetAudioEncoderConfigurationOptions, "-trt:GetAudioEncoderConfigurationOptions", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetAudioEncoderConfigurationOptions(soap, soap_tmp___trt__GetAudioEncoderConfigurationOptions.trt__GetAudioEncoderConfigurationOptions, &trt__GetAudioEncoderConfigurationOptionsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetAudioEncoderConfigurationOptionsResponse(soap, &trt__GetAudioEncoderConfigurationOptionsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetAudioEncoderConfigurationOptionsResponse(soap, &trt__GetAudioEncoderConfigurationOptionsResponse, "trt:GetAudioEncoderConfigurationOptionsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetAudioEncoderConfigurationOptionsResponse(soap, &trt__GetAudioEncoderConfigurationOptionsResponse, "trt:GetAudioEncoderConfigurationOptionsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetMetadataConfigurationOptions(struct soap *soap)
{	struct __trt__GetMetadataConfigurationOptions soap_tmp___trt__GetMetadataConfigurationOptions;
	struct _trt__GetMetadataConfigurationOptionsResponse trt__GetMetadataConfigurationOptionsResponse;
	soap_default__trt__GetMetadataConfigurationOptionsResponse(soap, &trt__GetMetadataConfigurationOptionsResponse);
	soap_default___trt__GetMetadataConfigurationOptions(soap, &soap_tmp___trt__GetMetadataConfigurationOptions);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetMetadataConfigurationOptions(soap, &soap_tmp___trt__GetMetadataConfigurationOptions, "-trt:GetMetadataConfigurationOptions", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetMetadataConfigurationOptions(soap, soap_tmp___trt__GetMetadataConfigurationOptions.trt__GetMetadataConfigurationOptions, &trt__GetMetadataConfigurationOptionsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetMetadataConfigurationOptionsResponse(soap, &trt__GetMetadataConfigurationOptionsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetMetadataConfigurationOptionsResponse(soap, &trt__GetMetadataConfigurationOptionsResponse, "trt:GetMetadataConfigurationOptionsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetMetadataConfigurationOptionsResponse(soap, &trt__GetMetadataConfigurationOptionsResponse, "trt:GetMetadataConfigurationOptionsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetGuaranteedNumberOfVideoEncoderInstances(struct soap *soap)
{	struct __trt__GetGuaranteedNumberOfVideoEncoderInstances soap_tmp___trt__GetGuaranteedNumberOfVideoEncoderInstances;
	struct _trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse;
	soap_default__trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse(soap, &trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse);
	soap_default___trt__GetGuaranteedNumberOfVideoEncoderInstances(soap, &soap_tmp___trt__GetGuaranteedNumberOfVideoEncoderInstances);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetGuaranteedNumberOfVideoEncoderInstances(soap, &soap_tmp___trt__GetGuaranteedNumberOfVideoEncoderInstances, "-trt:GetGuaranteedNumberOfVideoEncoderInstances", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetGuaranteedNumberOfVideoEncoderInstances(soap, soap_tmp___trt__GetGuaranteedNumberOfVideoEncoderInstances.trt__GetGuaranteedNumberOfVideoEncoderInstances, &trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse(soap, &trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse(soap, &trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse, "trt:GetGuaranteedNumberOfVideoEncoderInstancesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse(soap, &trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse, "trt:GetGuaranteedNumberOfVideoEncoderInstancesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetStreamUri(struct soap *soap)
{	struct __trt__GetStreamUri soap_tmp___trt__GetStreamUri;
	struct _trt__GetStreamUriResponse trt__GetStreamUriResponse;
	soap_default__trt__GetStreamUriResponse(soap, &trt__GetStreamUriResponse);
	soap_default___trt__GetStreamUri(soap, &soap_tmp___trt__GetStreamUri);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetStreamUri(soap, &soap_tmp___trt__GetStreamUri, "-trt:GetStreamUri", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetStreamUri(soap, soap_tmp___trt__GetStreamUri.trt__GetStreamUri, &trt__GetStreamUriResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetStreamUriResponse(soap, &trt__GetStreamUriResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetStreamUriResponse(soap, &trt__GetStreamUriResponse, "trt:GetStreamUriResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetStreamUriResponse(soap, &trt__GetStreamUriResponse, "trt:GetStreamUriResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__SetSynchronizationPoint(struct soap *soap)
{	struct __trt__SetSynchronizationPoint soap_tmp___trt__SetSynchronizationPoint;
	struct _trt__SetSynchronizationPointResponse trt__SetSynchronizationPointResponse;
	soap_default__trt__SetSynchronizationPointResponse(soap, &trt__SetSynchronizationPointResponse);
	soap_default___trt__SetSynchronizationPoint(soap, &soap_tmp___trt__SetSynchronizationPoint);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__SetSynchronizationPoint(soap, &soap_tmp___trt__SetSynchronizationPoint, "-trt:SetSynchronizationPoint", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__SetSynchronizationPoint(soap, soap_tmp___trt__SetSynchronizationPoint.trt__SetSynchronizationPoint, &trt__SetSynchronizationPointResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__SetSynchronizationPointResponse(soap, &trt__SetSynchronizationPointResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__SetSynchronizationPointResponse(soap, &trt__SetSynchronizationPointResponse, "trt:SetSynchronizationPointResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__SetSynchronizationPointResponse(soap, &trt__SetSynchronizationPointResponse, "trt:SetSynchronizationPointResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetSnapshotUri(struct soap *soap)
{	struct __trt__GetSnapshotUri soap_tmp___trt__GetSnapshotUri;
	struct _trt__GetSnapshotUriResponse trt__GetSnapshotUriResponse;
	soap_default__trt__GetSnapshotUriResponse(soap, &trt__GetSnapshotUriResponse);
	soap_default___trt__GetSnapshotUri(soap, &soap_tmp___trt__GetSnapshotUri);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetSnapshotUri(soap, &soap_tmp___trt__GetSnapshotUri, "-trt:GetSnapshotUri", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetSnapshotUri(soap, soap_tmp___trt__GetSnapshotUri.trt__GetSnapshotUri, &trt__GetSnapshotUriResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetSnapshotUriResponse(soap, &trt__GetSnapshotUriResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetSnapshotUriResponse(soap, &trt__GetSnapshotUriResponse, "trt:GetSnapshotUriResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetSnapshotUriResponse(soap, &trt__GetSnapshotUriResponse, "trt:GetSnapshotUriResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

#ifdef __cplusplus
}
#endif

#if defined(__BORLANDC__)
#pragma option pop
#pragma option pop
#endif

/* End of soapServer.c */
