/* soapServer.c
   Generated by gSOAP 2.7.16 from onvif.h
   Copyright(C) 2000-2010, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif
#include "soapH.h"
#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) soapServer.c ver 2.7.16 2011-12-05 08:22:34 GMT")


SOAP_FMAC5 int SOAP_FMAC6 soap_serve(struct soap *soap)
{
#ifndef WITH_FASTCGI
	unsigned int k = soap->max_keep_alive;
#endif

	do
	{
#ifdef WITH_FASTCGI
		if (FCGI_Accept() < 0)
		{
			soap->error = SOAP_EOF;
			return soap_send_fault(soap);
		}
#endif

		soap_begin(soap);

#ifndef WITH_FASTCGI
		if (soap->max_keep_alive > 0 && !--k)
			soap->keep_alive = 0;
#endif

		if (soap_begin_recv(soap))
		{	if (soap->error < SOAP_STOP)
			{
#ifdef WITH_FASTCGI
				soap_send_fault(soap);
#else 
				return soap_send_fault(soap);
#endif
			}
			soap_closesock(soap);

			continue;
		}

		if (soap_envelope_begin_in(soap)
		 || soap_recv_header(soap)
		 || soap_body_begin_in(soap)
		 || soap_serve_request(soap)
		 || (soap->fserveloop && soap->fserveloop(soap)))
		{
#ifdef WITH_FASTCGI
			soap_send_fault(soap);
#else
			return soap_send_fault(soap);
#endif
		}

#ifdef WITH_FASTCGI
		soap_destroy(soap);
		soap_end(soap);
	} while (1);
#else
	} while (soap->keep_alive);
#endif
	return SOAP_OK;
}

#ifndef WITH_NOSERVEREQUEST
SOAP_FMAC5 int SOAP_FMAC6 soap_serve_request(struct soap *soap)
{
        _wsse__Security *security = soap_wsse_Security(soap);

	soap_peek_element(soap);
	if (!soap_match_tag(soap, soap->tag, "d:Hello"))
		return soap_serve___d__Hello(soap);
	if (!soap_match_tag(soap, soap->tag, "d:Bye"))
		return soap_serve___d__Bye(soap);
	if (!soap_match_tag(soap, soap->tag, "d:Probe"))
		return soap_serve___d__Probe(soap);
        if(!security) {
                if(CheckHttpAuthority(soap) == SOAP_ERR) {
                        soap->error = 401;
                        return soap->error;
                }
        } else {
                if(Security_header_verify(soap)) {
                        return soap->error;
                }
        }
	if (!soap_match_tag(soap, soap->tag, "tds:GetDeviceInformation"))
		return soap_serve___tds__GetDeviceInformation(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetSystemDateAndTime"))
		return soap_serve___tds__SetSystemDateAndTime(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetSystemDateAndTime"))
		return soap_serve___tds__GetSystemDateAndTime(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetSystemFactoryDefault"))
		return soap_serve___tds__SetSystemFactoryDefault(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SystemReboot"))
		return soap_serve___tds__SystemReboot(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetScopes"))
		return soap_serve___tds__GetScopes(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetScopes"))
		return soap_serve___tds__SetScopes(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:AddScopes"))
		return soap_serve___tds__AddScopes(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:RemoveScopes"))
		return soap_serve___tds__RemoveScopes(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetDiscoveryMode"))
		return soap_serve___tds__GetDiscoveryMode(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetDiscoveryMode"))
		return soap_serve___tds__SetDiscoveryMode(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetUsers"))
		return soap_serve___tds__GetUsers(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:CreateUsers"))
		return soap_serve___tds__CreateUsers(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:DeleteUsers"))
		return soap_serve___tds__DeleteUsers(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetUser"))
		return soap_serve___tds__SetUser(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetWsdlUrl"))
		return soap_serve___tds__GetWsdlUrl(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetCapabilities"))
		return soap_serve___tds__GetCapabilities(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetHostname"))
		return soap_serve___tds__GetHostname(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetHostname"))
		return soap_serve___tds__SetHostname(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetDNS"))
		return soap_serve___tds__GetDNS(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetDNS"))
		return soap_serve___tds__SetDNS(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetNTP"))
		return soap_serve___tds__GetNTP(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetNTP"))
		return soap_serve___tds__SetNTP(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetDynamicDNS"))
		return soap_serve___tds__GetDynamicDNS(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetDynamicDNS"))
		return soap_serve___tds__SetDynamicDNS(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetNetworkInterfaces"))
		return soap_serve___tds__GetNetworkInterfaces(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetNetworkInterfaces"))
		return soap_serve___tds__SetNetworkInterfaces(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetNetworkDefaultGateway"))
		return soap_serve___tds__GetNetworkDefaultGateway(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetNetworkDefaultGateway"))
		return soap_serve___tds__SetNetworkDefaultGateway(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:GetZeroConfiguration"))
		return soap_serve___tds__GetZeroConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "tds:SetZeroConfiguration"))
		return soap_serve___tds__SetZeroConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetVideoSources"))
		return soap_serve___trt__GetVideoSources(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetAudioSources"))
		return soap_serve___trt__GetAudioSources(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:CreateProfile"))
		return soap_serve___trt__CreateProfile(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetProfile"))
		return soap_serve___trt__GetProfile(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetProfiles"))
		return soap_serve___trt__GetProfiles(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:AddVideoEncoderConfiguration"))
		return soap_serve___trt__AddVideoEncoderConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:AddVideoSourceConfiguration"))
		return soap_serve___trt__AddVideoSourceConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:AddAudioEncoderConfiguration"))
		return soap_serve___trt__AddAudioEncoderConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:AddAudioSourceConfiguration"))
		return soap_serve___trt__AddAudioSourceConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:RemoveVideoEncoderConfiguration"))
		return soap_serve___trt__RemoveVideoEncoderConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:RemoveVideoSourceConfiguration"))
		return soap_serve___trt__RemoveVideoSourceConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:RemoveAudioEncoderConfiguration"))
		return soap_serve___trt__RemoveAudioEncoderConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:RemoveAudioSourceConfiguration"))
		return soap_serve___trt__RemoveAudioSourceConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:DeleteProfile"))
		return soap_serve___trt__DeleteProfile(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetVideoSourceConfigurations"))
		return soap_serve___trt__GetVideoSourceConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetVideoEncoderConfigurations"))
		return soap_serve___trt__GetVideoEncoderConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetAudioSourceConfigurations"))
		return soap_serve___trt__GetAudioSourceConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetAudioEncoderConfigurations"))
		return soap_serve___trt__GetAudioEncoderConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetVideoSourceConfiguration"))
		return soap_serve___trt__GetVideoSourceConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetVideoEncoderConfiguration"))
		return soap_serve___trt__GetVideoEncoderConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetAudioSourceConfiguration"))
		return soap_serve___trt__GetAudioSourceConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetAudioEncoderConfiguration"))
		return soap_serve___trt__GetAudioEncoderConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetCompatibleVideoEncoderConfigurations"))
		return soap_serve___trt__GetCompatibleVideoEncoderConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetCompatibleVideoSourceConfigurations"))
		return soap_serve___trt__GetCompatibleVideoSourceConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetCompatibleAudioEncoderConfigurations"))
		return soap_serve___trt__GetCompatibleAudioEncoderConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetCompatibleAudioSourceConfigurations"))
		return soap_serve___trt__GetCompatibleAudioSourceConfigurations(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:SetVideoSourceConfiguration"))
		return soap_serve___trt__SetVideoSourceConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:SetVideoEncoderConfiguration"))
		return soap_serve___trt__SetVideoEncoderConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:SetAudioSourceConfiguration"))
		return soap_serve___trt__SetAudioSourceConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:SetAudioEncoderConfiguration"))
		return soap_serve___trt__SetAudioEncoderConfiguration(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetVideoSourceConfigurationOptions"))
		return soap_serve___trt__GetVideoSourceConfigurationOptions(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetVideoEncoderConfigurationOptions"))
		return soap_serve___trt__GetVideoEncoderConfigurationOptions(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetAudioSourceConfigurationOptions"))
		return soap_serve___trt__GetAudioSourceConfigurationOptions(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetAudioEncoderConfigurationOptions"))
		return soap_serve___trt__GetAudioEncoderConfigurationOptions(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetStreamUri"))
		return soap_serve___trt__GetStreamUri(soap);
	if (!soap_match_tag(soap, soap->tag, "trt:GetSnapshotUri"))
		return soap_serve___trt__GetSnapshotUri(soap);
	return soap->error = SOAP_NO_METHOD;
}
#endif

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___d__Hello(struct soap *soap)
{	struct __d__Hello soap_tmp___d__Hello;
	struct d__ResolveType d__HelloResponse;
	soap_default_d__ResolveType(soap, &d__HelloResponse);
	soap_default___d__Hello(soap, &soap_tmp___d__Hello);
	soap->encodingStyle = NULL;
	if (!soap_get___d__Hello(soap, &soap_tmp___d__Hello, "-d:Hello", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __d__Hello(soap, soap_tmp___d__Hello.d__Hello, &d__HelloResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_d__ResolveType(soap, &d__HelloResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_d__ResolveType(soap, &d__HelloResponse, "d:HelloResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_d__ResolveType(soap, &d__HelloResponse, "d:HelloResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___d__Bye(struct soap *soap)
{	struct __d__Bye soap_tmp___d__Bye;
	struct d__ResolveType d__ByeResponse;
	soap_default_d__ResolveType(soap, &d__ByeResponse);
	soap_default___d__Bye(soap, &soap_tmp___d__Bye);
	soap->encodingStyle = NULL;
	if (!soap_get___d__Bye(soap, &soap_tmp___d__Bye, "-d:Bye", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __d__Bye(soap, soap_tmp___d__Bye.d__Bye, &d__ByeResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_d__ResolveType(soap, &d__ByeResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_d__ResolveType(soap, &d__ByeResponse, "d:ByeResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_d__ResolveType(soap, &d__ByeResponse, "d:ByeResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___d__Probe(struct soap *soap)
{	struct __d__Probe soap_tmp___d__Probe;
	struct d__ProbeMatchesType d__ProbeMatches;
	soap_default_d__ProbeMatchesType(soap, &d__ProbeMatches);
	soap_default___d__Probe(soap, &soap_tmp___d__Probe);
	soap->encodingStyle = NULL;
	if (!soap_get___d__Probe(soap, &soap_tmp___d__Probe, "-d:Probe", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __d__Probe(soap, soap_tmp___d__Probe.d__Probe, &d__ProbeMatches);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_d__ProbeMatchesType(soap, &d__ProbeMatches);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_d__ProbeMatchesType(soap, &d__ProbeMatches, "d:ProbeMatches", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_d__ProbeMatchesType(soap, &d__ProbeMatches, "d:ProbeMatches", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetDeviceInformation(struct soap *soap)
{	struct __tds__GetDeviceInformation soap_tmp___tds__GetDeviceInformation;
	struct _tds__GetDeviceInformationResponse tds__GetDeviceInformationResponse;
	soap_default__tds__GetDeviceInformationResponse(soap, &tds__GetDeviceInformationResponse);
	soap_default___tds__GetDeviceInformation(soap, &soap_tmp___tds__GetDeviceInformation);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetDeviceInformation(soap, &soap_tmp___tds__GetDeviceInformation, "-tds:GetDeviceInformation", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetDeviceInformation(soap, soap_tmp___tds__GetDeviceInformation.tds__GetDeviceInformation, &tds__GetDeviceInformationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetDeviceInformationResponse(soap, &tds__GetDeviceInformationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetDeviceInformationResponse(soap, &tds__GetDeviceInformationResponse, "tds:GetDeviceInformationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetDeviceInformationResponse(soap, &tds__GetDeviceInformationResponse, "tds:GetDeviceInformationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetSystemDateAndTime(struct soap *soap)
{	struct __tds__SetSystemDateAndTime soap_tmp___tds__SetSystemDateAndTime;
	struct _tds__SetSystemDateAndTimeResponse tds__SetSystemDateAndTimeResponse;
	soap_default__tds__SetSystemDateAndTimeResponse(soap, &tds__SetSystemDateAndTimeResponse);
	soap_default___tds__SetSystemDateAndTime(soap, &soap_tmp___tds__SetSystemDateAndTime);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetSystemDateAndTime(soap, &soap_tmp___tds__SetSystemDateAndTime, "-tds:SetSystemDateAndTime", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetSystemDateAndTime(soap, soap_tmp___tds__SetSystemDateAndTime.tds__SetSystemDateAndTime, &tds__SetSystemDateAndTimeResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetSystemDateAndTimeResponse(soap, &tds__SetSystemDateAndTimeResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetSystemDateAndTimeResponse(soap, &tds__SetSystemDateAndTimeResponse, "tds:SetSystemDateAndTimeResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetSystemDateAndTimeResponse(soap, &tds__SetSystemDateAndTimeResponse, "tds:SetSystemDateAndTimeResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetSystemDateAndTime(struct soap *soap)
{	struct __tds__GetSystemDateAndTime soap_tmp___tds__GetSystemDateAndTime;
	struct _tds__GetSystemDateAndTimeResponse tds__GetSystemDateAndTimeResponse;
	soap_default__tds__GetSystemDateAndTimeResponse(soap, &tds__GetSystemDateAndTimeResponse);
	soap_default___tds__GetSystemDateAndTime(soap, &soap_tmp___tds__GetSystemDateAndTime);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetSystemDateAndTime(soap, &soap_tmp___tds__GetSystemDateAndTime, "-tds:GetSystemDateAndTime", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetSystemDateAndTime(soap, soap_tmp___tds__GetSystemDateAndTime.tds__GetSystemDateAndTime, &tds__GetSystemDateAndTimeResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetSystemDateAndTimeResponse(soap, &tds__GetSystemDateAndTimeResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetSystemDateAndTimeResponse(soap, &tds__GetSystemDateAndTimeResponse, "tds:GetSystemDateAndTimeResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetSystemDateAndTimeResponse(soap, &tds__GetSystemDateAndTimeResponse, "tds:GetSystemDateAndTimeResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetSystemFactoryDefault(struct soap *soap)
{	struct __tds__SetSystemFactoryDefault soap_tmp___tds__SetSystemFactoryDefault;
	struct _tds__SetSystemFactoryDefaultResponse tds__SetSystemFactoryDefaultResponse;
	soap_default__tds__SetSystemFactoryDefaultResponse(soap, &tds__SetSystemFactoryDefaultResponse);
	soap_default___tds__SetSystemFactoryDefault(soap, &soap_tmp___tds__SetSystemFactoryDefault);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetSystemFactoryDefault(soap, &soap_tmp___tds__SetSystemFactoryDefault, "-tds:SetSystemFactoryDefault", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetSystemFactoryDefault(soap, soap_tmp___tds__SetSystemFactoryDefault.tds__SetSystemFactoryDefault, &tds__SetSystemFactoryDefaultResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetSystemFactoryDefaultResponse(soap, &tds__SetSystemFactoryDefaultResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetSystemFactoryDefaultResponse(soap, &tds__SetSystemFactoryDefaultResponse, "tds:SetSystemFactoryDefaultResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetSystemFactoryDefaultResponse(soap, &tds__SetSystemFactoryDefaultResponse, "tds:SetSystemFactoryDefaultResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SystemReboot(struct soap *soap)
{	struct __tds__SystemReboot soap_tmp___tds__SystemReboot;
	struct _tds__SystemRebootResponse tds__SystemRebootResponse;
	soap_default__tds__SystemRebootResponse(soap, &tds__SystemRebootResponse);
	soap_default___tds__SystemReboot(soap, &soap_tmp___tds__SystemReboot);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SystemReboot(soap, &soap_tmp___tds__SystemReboot, "-tds:SystemReboot", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SystemReboot(soap, soap_tmp___tds__SystemReboot.tds__SystemReboot, &tds__SystemRebootResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SystemRebootResponse(soap, &tds__SystemRebootResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SystemRebootResponse(soap, &tds__SystemRebootResponse, "tds:SystemRebootResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SystemRebootResponse(soap, &tds__SystemRebootResponse, "tds:SystemRebootResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetScopes(struct soap *soap)
{	struct __tds__GetScopes soap_tmp___tds__GetScopes;
	struct _tds__GetScopesResponse tds__GetScopesResponse;
	soap_default__tds__GetScopesResponse(soap, &tds__GetScopesResponse);
	soap_default___tds__GetScopes(soap, &soap_tmp___tds__GetScopes);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetScopes(soap, &soap_tmp___tds__GetScopes, "-tds:GetScopes", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetScopes(soap, soap_tmp___tds__GetScopes.tds__GetScopes, &tds__GetScopesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetScopesResponse(soap, &tds__GetScopesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetScopesResponse(soap, &tds__GetScopesResponse, "tds:GetScopesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetScopesResponse(soap, &tds__GetScopesResponse, "tds:GetScopesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetScopes(struct soap *soap)
{	struct __tds__SetScopes soap_tmp___tds__SetScopes;
	struct _tds__SetScopesResponse tds__SetScopesResponse;
	soap_default__tds__SetScopesResponse(soap, &tds__SetScopesResponse);
	soap_default___tds__SetScopes(soap, &soap_tmp___tds__SetScopes);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetScopes(soap, &soap_tmp___tds__SetScopes, "-tds:SetScopes", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetScopes(soap, soap_tmp___tds__SetScopes.tds__SetScopes, &tds__SetScopesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetScopesResponse(soap, &tds__SetScopesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetScopesResponse(soap, &tds__SetScopesResponse, "tds:SetScopesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetScopesResponse(soap, &tds__SetScopesResponse, "tds:SetScopesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__AddScopes(struct soap *soap)
{	struct __tds__AddScopes soap_tmp___tds__AddScopes;
	struct _tds__AddScopesResponse tds__AddScopesResponse;
	soap_default__tds__AddScopesResponse(soap, &tds__AddScopesResponse);
	soap_default___tds__AddScopes(soap, &soap_tmp___tds__AddScopes);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__AddScopes(soap, &soap_tmp___tds__AddScopes, "-tds:AddScopes", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__AddScopes(soap, soap_tmp___tds__AddScopes.tds__AddScopes, &tds__AddScopesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__AddScopesResponse(soap, &tds__AddScopesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__AddScopesResponse(soap, &tds__AddScopesResponse, "tds:AddScopesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__AddScopesResponse(soap, &tds__AddScopesResponse, "tds:AddScopesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
        if(soap->hello_callback) soap->hello_callback();
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__RemoveScopes(struct soap *soap)
{	struct __tds__RemoveScopes soap_tmp___tds__RemoveScopes;
	struct _tds__RemoveScopesResponse tds__RemoveScopesResponse;
	soap_default__tds__RemoveScopesResponse(soap, &tds__RemoveScopesResponse);
	soap_default___tds__RemoveScopes(soap, &soap_tmp___tds__RemoveScopes);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__RemoveScopes(soap, &soap_tmp___tds__RemoveScopes, "-tds:RemoveScopes", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__RemoveScopes(soap, soap_tmp___tds__RemoveScopes.tds__RemoveScopes, &tds__RemoveScopesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__RemoveScopesResponse(soap, &tds__RemoveScopesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__RemoveScopesResponse(soap, &tds__RemoveScopesResponse, "tds:RemoveScopesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__RemoveScopesResponse(soap, &tds__RemoveScopesResponse, "tds:RemoveScopesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
        if(soap->hello_callback) soap->hello_callback();
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetDiscoveryMode(struct soap *soap)
{	struct __tds__GetDiscoveryMode soap_tmp___tds__GetDiscoveryMode;
	struct _tds__GetDiscoveryModeResponse tds__GetDiscoveryModeResponse;
	soap_default__tds__GetDiscoveryModeResponse(soap, &tds__GetDiscoveryModeResponse);
	soap_default___tds__GetDiscoveryMode(soap, &soap_tmp___tds__GetDiscoveryMode);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetDiscoveryMode(soap, &soap_tmp___tds__GetDiscoveryMode, "-tds:GetDiscoveryMode", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetDiscoveryMode(soap, soap_tmp___tds__GetDiscoveryMode.tds__GetDiscoveryMode, &tds__GetDiscoveryModeResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetDiscoveryModeResponse(soap, &tds__GetDiscoveryModeResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetDiscoveryModeResponse(soap, &tds__GetDiscoveryModeResponse, "tds:GetDiscoveryModeResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetDiscoveryModeResponse(soap, &tds__GetDiscoveryModeResponse, "tds:GetDiscoveryModeResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetDiscoveryMode(struct soap *soap)
{	struct __tds__SetDiscoveryMode soap_tmp___tds__SetDiscoveryMode;
	struct _tds__SetDiscoveryModeResponse tds__SetDiscoveryModeResponse;
	soap_default__tds__SetDiscoveryModeResponse(soap, &tds__SetDiscoveryModeResponse);
	soap_default___tds__SetDiscoveryMode(soap, &soap_tmp___tds__SetDiscoveryMode);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetDiscoveryMode(soap, &soap_tmp___tds__SetDiscoveryMode, "-tds:SetDiscoveryMode", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetDiscoveryMode(soap, soap_tmp___tds__SetDiscoveryMode.tds__SetDiscoveryMode, &tds__SetDiscoveryModeResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetDiscoveryModeResponse(soap, &tds__SetDiscoveryModeResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetDiscoveryModeResponse(soap, &tds__SetDiscoveryModeResponse, "tds:SetDiscoveryModeResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetDiscoveryModeResponse(soap, &tds__SetDiscoveryModeResponse, "tds:SetDiscoveryModeResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetUsers(struct soap *soap)
{	struct __tds__GetUsers soap_tmp___tds__GetUsers;
	struct _tds__GetUsersResponse tds__GetUsersResponse;
	soap_default__tds__GetUsersResponse(soap, &tds__GetUsersResponse);
	soap_default___tds__GetUsers(soap, &soap_tmp___tds__GetUsers);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetUsers(soap, &soap_tmp___tds__GetUsers, "-tds:GetUsers", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetUsers(soap, soap_tmp___tds__GetUsers.tds__GetUsers, &tds__GetUsersResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetUsersResponse(soap, &tds__GetUsersResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetUsersResponse(soap, &tds__GetUsersResponse, "tds:GetUsersResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetUsersResponse(soap, &tds__GetUsersResponse, "tds:GetUsersResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__CreateUsers(struct soap *soap)
{	struct __tds__CreateUsers soap_tmp___tds__CreateUsers;
	struct _tds__CreateUsersResponse tds__CreateUsersResponse;
	soap_default__tds__CreateUsersResponse(soap, &tds__CreateUsersResponse);
	soap_default___tds__CreateUsers(soap, &soap_tmp___tds__CreateUsers);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__CreateUsers(soap, &soap_tmp___tds__CreateUsers, "-tds:CreateUsers", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__CreateUsers(soap, soap_tmp___tds__CreateUsers.tds__CreateUsers, &tds__CreateUsersResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__CreateUsersResponse(soap, &tds__CreateUsersResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__CreateUsersResponse(soap, &tds__CreateUsersResponse, "tds:CreateUsersResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__CreateUsersResponse(soap, &tds__CreateUsersResponse, "tds:CreateUsersResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__DeleteUsers(struct soap *soap)
{	struct __tds__DeleteUsers soap_tmp___tds__DeleteUsers;
	struct _tds__DeleteUsersResponse tds__DeleteUsersResponse;
	soap_default__tds__DeleteUsersResponse(soap, &tds__DeleteUsersResponse);
	soap_default___tds__DeleteUsers(soap, &soap_tmp___tds__DeleteUsers);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__DeleteUsers(soap, &soap_tmp___tds__DeleteUsers, "-tds:DeleteUsers", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__DeleteUsers(soap, soap_tmp___tds__DeleteUsers.tds__DeleteUsers, &tds__DeleteUsersResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__DeleteUsersResponse(soap, &tds__DeleteUsersResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__DeleteUsersResponse(soap, &tds__DeleteUsersResponse, "tds:DeleteUsersResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__DeleteUsersResponse(soap, &tds__DeleteUsersResponse, "tds:DeleteUsersResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetUser(struct soap *soap)
{	struct __tds__SetUser soap_tmp___tds__SetUser;
	struct _tds__SetUserResponse tds__SetUserResponse;
	soap_default__tds__SetUserResponse(soap, &tds__SetUserResponse);
	soap_default___tds__SetUser(soap, &soap_tmp___tds__SetUser);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetUser(soap, &soap_tmp___tds__SetUser, "-tds:SetUser", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetUser(soap, soap_tmp___tds__SetUser.tds__SetUser, &tds__SetUserResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetUserResponse(soap, &tds__SetUserResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetUserResponse(soap, &tds__SetUserResponse, "tds:SetUserResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetUserResponse(soap, &tds__SetUserResponse, "tds:SetUserResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetWsdlUrl(struct soap *soap)
{	struct __tds__GetWsdlUrl soap_tmp___tds__GetWsdlUrl;
	struct _tds__GetWsdlUrlResponse tds__GetWsdlUrlResponse;
	soap_default__tds__GetWsdlUrlResponse(soap, &tds__GetWsdlUrlResponse);
	soap_default___tds__GetWsdlUrl(soap, &soap_tmp___tds__GetWsdlUrl);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetWsdlUrl(soap, &soap_tmp___tds__GetWsdlUrl, "-tds:GetWsdlUrl", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetWsdlUrl(soap, soap_tmp___tds__GetWsdlUrl.tds__GetWsdlUrl, &tds__GetWsdlUrlResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetWsdlUrlResponse(soap, &tds__GetWsdlUrlResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetWsdlUrlResponse(soap, &tds__GetWsdlUrlResponse, "tds:GetWsdlUrlResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetWsdlUrlResponse(soap, &tds__GetWsdlUrlResponse, "tds:GetWsdlUrlResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetCapabilities(struct soap *soap)
{	struct __tds__GetCapabilities soap_tmp___tds__GetCapabilities;
	struct _tds__GetCapabilitiesResponse tds__GetCapabilitiesResponse;
	soap_default__tds__GetCapabilitiesResponse(soap, &tds__GetCapabilitiesResponse);
	soap_default___tds__GetCapabilities(soap, &soap_tmp___tds__GetCapabilities);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetCapabilities(soap, &soap_tmp___tds__GetCapabilities, "-tds:GetCapabilities", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetCapabilities(soap, soap_tmp___tds__GetCapabilities.tds__GetCapabilities, &tds__GetCapabilitiesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetCapabilitiesResponse(soap, &tds__GetCapabilitiesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetCapabilitiesResponse(soap, &tds__GetCapabilitiesResponse, "tds:GetCapabilitiesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetCapabilitiesResponse(soap, &tds__GetCapabilitiesResponse, "tds:GetCapabilitiesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetHostname(struct soap *soap)
{	struct __tds__GetHostname soap_tmp___tds__GetHostname;
	struct _tds__GetHostnameResponse tds__GetHostnameResponse;
	soap_default__tds__GetHostnameResponse(soap, &tds__GetHostnameResponse);
	soap_default___tds__GetHostname(soap, &soap_tmp___tds__GetHostname);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetHostname(soap, &soap_tmp___tds__GetHostname, "-tds:GetHostname", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetHostname(soap, soap_tmp___tds__GetHostname.tds__GetHostname, &tds__GetHostnameResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetHostnameResponse(soap, &tds__GetHostnameResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetHostnameResponse(soap, &tds__GetHostnameResponse, "tds:GetHostnameResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetHostnameResponse(soap, &tds__GetHostnameResponse, "tds:GetHostnameResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetHostname(struct soap *soap)
{	struct __tds__SetHostname soap_tmp___tds__SetHostname;
	struct _tds__SetHostnameResponse tds__SetHostnameResponse;
	soap_default__tds__SetHostnameResponse(soap, &tds__SetHostnameResponse);
	soap_default___tds__SetHostname(soap, &soap_tmp___tds__SetHostname);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetHostname(soap, &soap_tmp___tds__SetHostname, "-tds:SetHostname", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetHostname(soap, soap_tmp___tds__SetHostname.tds__SetHostname, &tds__SetHostnameResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetHostnameResponse(soap, &tds__SetHostnameResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetHostnameResponse(soap, &tds__SetHostnameResponse, "tds:SetHostnameResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetHostnameResponse(soap, &tds__SetHostnameResponse, "tds:SetHostnameResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetDNS(struct soap *soap)
{	struct __tds__GetDNS soap_tmp___tds__GetDNS;
	struct _tds__GetDNSResponse tds__GetDNSResponse;
	soap_default__tds__GetDNSResponse(soap, &tds__GetDNSResponse);
	soap_default___tds__GetDNS(soap, &soap_tmp___tds__GetDNS);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetDNS(soap, &soap_tmp___tds__GetDNS, "-tds:GetDNS", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetDNS(soap, soap_tmp___tds__GetDNS.tds__GetDNS, &tds__GetDNSResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetDNSResponse(soap, &tds__GetDNSResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetDNSResponse(soap, &tds__GetDNSResponse, "tds:GetDNSResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetDNSResponse(soap, &tds__GetDNSResponse, "tds:GetDNSResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetDNS(struct soap *soap)
{	struct __tds__SetDNS soap_tmp___tds__SetDNS;
	struct _tds__SetDNSResponse tds__SetDNSResponse;
	soap_default__tds__SetDNSResponse(soap, &tds__SetDNSResponse);
	soap_default___tds__SetDNS(soap, &soap_tmp___tds__SetDNS);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetDNS(soap, &soap_tmp___tds__SetDNS, "-tds:SetDNS", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetDNS(soap, soap_tmp___tds__SetDNS.tds__SetDNS, &tds__SetDNSResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetDNSResponse(soap, &tds__SetDNSResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetDNSResponse(soap, &tds__SetDNSResponse, "tds:SetDNSResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetDNSResponse(soap, &tds__SetDNSResponse, "tds:SetDNSResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetNTP(struct soap *soap)
{	struct __tds__GetNTP soap_tmp___tds__GetNTP;
	struct _tds__GetNTPResponse tds__GetNTPResponse;
	soap_default__tds__GetNTPResponse(soap, &tds__GetNTPResponse);
	soap_default___tds__GetNTP(soap, &soap_tmp___tds__GetNTP);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetNTP(soap, &soap_tmp___tds__GetNTP, "-tds:GetNTP", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetNTP(soap, soap_tmp___tds__GetNTP.tds__GetNTP, &tds__GetNTPResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetNTPResponse(soap, &tds__GetNTPResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetNTPResponse(soap, &tds__GetNTPResponse, "tds:GetNTPResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetNTPResponse(soap, &tds__GetNTPResponse, "tds:GetNTPResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetNTP(struct soap *soap)
{	struct __tds__SetNTP soap_tmp___tds__SetNTP;
	struct _tds__SetNTPResponse tds__SetNTPResponse;
	soap_default__tds__SetNTPResponse(soap, &tds__SetNTPResponse);
	soap_default___tds__SetNTP(soap, &soap_tmp___tds__SetNTP);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetNTP(soap, &soap_tmp___tds__SetNTP, "-tds:SetNTP", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetNTP(soap, soap_tmp___tds__SetNTP.tds__SetNTP, &tds__SetNTPResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetNTPResponse(soap, &tds__SetNTPResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetNTPResponse(soap, &tds__SetNTPResponse, "tds:SetNTPResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetNTPResponse(soap, &tds__SetNTPResponse, "tds:SetNTPResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetDynamicDNS(struct soap *soap)
{	struct __tds__GetDynamicDNS soap_tmp___tds__GetDynamicDNS;
	struct _tds__GetDynamicDNSResponse tds__GetDynamicDNSResponse;
	soap_default__tds__GetDynamicDNSResponse(soap, &tds__GetDynamicDNSResponse);
	soap_default___tds__GetDynamicDNS(soap, &soap_tmp___tds__GetDynamicDNS);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetDynamicDNS(soap, &soap_tmp___tds__GetDynamicDNS, "-tds:GetDynamicDNS", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetDynamicDNS(soap, soap_tmp___tds__GetDynamicDNS.tds__GetDynamicDNS, &tds__GetDynamicDNSResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetDynamicDNSResponse(soap, &tds__GetDynamicDNSResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetDynamicDNSResponse(soap, &tds__GetDynamicDNSResponse, "tds:GetDynamicDNSResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetDynamicDNSResponse(soap, &tds__GetDynamicDNSResponse, "tds:GetDynamicDNSResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetDynamicDNS(struct soap *soap)
{	struct __tds__SetDynamicDNS soap_tmp___tds__SetDynamicDNS;
	struct _tds__SetDynamicDNSResponse tds__SetDynamicDNSResponse;
	soap_default__tds__SetDynamicDNSResponse(soap, &tds__SetDynamicDNSResponse);
	soap_default___tds__SetDynamicDNS(soap, &soap_tmp___tds__SetDynamicDNS);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetDynamicDNS(soap, &soap_tmp___tds__SetDynamicDNS, "-tds:SetDynamicDNS", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetDynamicDNS(soap, soap_tmp___tds__SetDynamicDNS.tds__SetDynamicDNS, &tds__SetDynamicDNSResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetDynamicDNSResponse(soap, &tds__SetDynamicDNSResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetDynamicDNSResponse(soap, &tds__SetDynamicDNSResponse, "tds:SetDynamicDNSResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetDynamicDNSResponse(soap, &tds__SetDynamicDNSResponse, "tds:SetDynamicDNSResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetNetworkInterfaces(struct soap *soap)
{	struct __tds__GetNetworkInterfaces soap_tmp___tds__GetNetworkInterfaces;
	struct _tds__GetNetworkInterfacesResponse tds__GetNetworkInterfacesResponse;
	soap_default__tds__GetNetworkInterfacesResponse(soap, &tds__GetNetworkInterfacesResponse);
	soap_default___tds__GetNetworkInterfaces(soap, &soap_tmp___tds__GetNetworkInterfaces);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetNetworkInterfaces(soap, &soap_tmp___tds__GetNetworkInterfaces, "-tds:GetNetworkInterfaces", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetNetworkInterfaces(soap, soap_tmp___tds__GetNetworkInterfaces.tds__GetNetworkInterfaces, &tds__GetNetworkInterfacesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetNetworkInterfacesResponse(soap, &tds__GetNetworkInterfacesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetNetworkInterfacesResponse(soap, &tds__GetNetworkInterfacesResponse, "tds:GetNetworkInterfacesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetNetworkInterfacesResponse(soap, &tds__GetNetworkInterfacesResponse, "tds:GetNetworkInterfacesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetNetworkInterfaces(struct soap *soap)
{	struct __tds__SetNetworkInterfaces soap_tmp___tds__SetNetworkInterfaces;
	struct _tds__SetNetworkInterfacesResponse tds__SetNetworkInterfacesResponse;
	soap_default__tds__SetNetworkInterfacesResponse(soap, &tds__SetNetworkInterfacesResponse);
	soap_default___tds__SetNetworkInterfaces(soap, &soap_tmp___tds__SetNetworkInterfaces);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetNetworkInterfaces(soap, &soap_tmp___tds__SetNetworkInterfaces, "-tds:SetNetworkInterfaces", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetNetworkInterfaces(soap, soap_tmp___tds__SetNetworkInterfaces.tds__SetNetworkInterfaces, &tds__SetNetworkInterfacesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetNetworkInterfacesResponse(soap, &tds__SetNetworkInterfacesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetNetworkInterfacesResponse(soap, &tds__SetNetworkInterfacesResponse, "tds:SetNetworkInterfacesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetNetworkInterfacesResponse(soap, &tds__SetNetworkInterfacesResponse, "tds:SetNetworkInterfacesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetNetworkDefaultGateway(struct soap *soap)
{	struct __tds__GetNetworkDefaultGateway soap_tmp___tds__GetNetworkDefaultGateway;
	struct _tds__GetNetworkDefaultGatewayResponse tds__GetNetworkDefaultGatewayResponse;
	soap_default__tds__GetNetworkDefaultGatewayResponse(soap, &tds__GetNetworkDefaultGatewayResponse);
	soap_default___tds__GetNetworkDefaultGateway(soap, &soap_tmp___tds__GetNetworkDefaultGateway);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetNetworkDefaultGateway(soap, &soap_tmp___tds__GetNetworkDefaultGateway, "-tds:GetNetworkDefaultGateway", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetNetworkDefaultGateway(soap, soap_tmp___tds__GetNetworkDefaultGateway.tds__GetNetworkDefaultGateway, &tds__GetNetworkDefaultGatewayResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetNetworkDefaultGatewayResponse(soap, &tds__GetNetworkDefaultGatewayResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetNetworkDefaultGatewayResponse(soap, &tds__GetNetworkDefaultGatewayResponse, "tds:GetNetworkDefaultGatewayResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetNetworkDefaultGatewayResponse(soap, &tds__GetNetworkDefaultGatewayResponse, "tds:GetNetworkDefaultGatewayResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetNetworkDefaultGateway(struct soap *soap)
{	struct __tds__SetNetworkDefaultGateway soap_tmp___tds__SetNetworkDefaultGateway;
	struct _tds__SetNetworkDefaultGatewayResponse tds__SetNetworkDefaultGatewayResponse;
	soap_default__tds__SetNetworkDefaultGatewayResponse(soap, &tds__SetNetworkDefaultGatewayResponse);
	soap_default___tds__SetNetworkDefaultGateway(soap, &soap_tmp___tds__SetNetworkDefaultGateway);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetNetworkDefaultGateway(soap, &soap_tmp___tds__SetNetworkDefaultGateway, "-tds:SetNetworkDefaultGateway", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetNetworkDefaultGateway(soap, soap_tmp___tds__SetNetworkDefaultGateway.tds__SetNetworkDefaultGateway, &tds__SetNetworkDefaultGatewayResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetNetworkDefaultGatewayResponse(soap, &tds__SetNetworkDefaultGatewayResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetNetworkDefaultGatewayResponse(soap, &tds__SetNetworkDefaultGatewayResponse, "tds:SetNetworkDefaultGatewayResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetNetworkDefaultGatewayResponse(soap, &tds__SetNetworkDefaultGatewayResponse, "tds:SetNetworkDefaultGatewayResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__GetZeroConfiguration(struct soap *soap)
{	struct __tds__GetZeroConfiguration soap_tmp___tds__GetZeroConfiguration;
	struct _tds__GetZeroConfigurationResponse tds__GetZeroConfigurationResponse;
	soap_default__tds__GetZeroConfigurationResponse(soap, &tds__GetZeroConfigurationResponse);
	soap_default___tds__GetZeroConfiguration(soap, &soap_tmp___tds__GetZeroConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__GetZeroConfiguration(soap, &soap_tmp___tds__GetZeroConfiguration, "-tds:GetZeroConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__GetZeroConfiguration(soap, soap_tmp___tds__GetZeroConfiguration.tds__GetZeroConfiguration, &tds__GetZeroConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__GetZeroConfigurationResponse(soap, &tds__GetZeroConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__GetZeroConfigurationResponse(soap, &tds__GetZeroConfigurationResponse, "tds:GetZeroConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__GetZeroConfigurationResponse(soap, &tds__GetZeroConfigurationResponse, "tds:GetZeroConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___tds__SetZeroConfiguration(struct soap *soap)
{	struct __tds__SetZeroConfiguration soap_tmp___tds__SetZeroConfiguration;
	struct _tds__SetZeroConfigurationResponse tds__SetZeroConfigurationResponse;
	soap_default__tds__SetZeroConfigurationResponse(soap, &tds__SetZeroConfigurationResponse);
	soap_default___tds__SetZeroConfiguration(soap, &soap_tmp___tds__SetZeroConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___tds__SetZeroConfiguration(soap, &soap_tmp___tds__SetZeroConfiguration, "-tds:SetZeroConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __tds__SetZeroConfiguration(soap, soap_tmp___tds__SetZeroConfiguration.tds__SetZeroConfiguration, &tds__SetZeroConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__tds__SetZeroConfigurationResponse(soap, &tds__SetZeroConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__tds__SetZeroConfigurationResponse(soap, &tds__SetZeroConfigurationResponse, "tds:SetZeroConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__tds__SetZeroConfigurationResponse(soap, &tds__SetZeroConfigurationResponse, "tds:SetZeroConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetVideoSources(struct soap *soap)
{	struct __trt__GetVideoSources soap_tmp___trt__GetVideoSources;
	struct _trt__GetVideoSourcesResponse trt__GetVideoSourcesResponse;
	soap_default__trt__GetVideoSourcesResponse(soap, &trt__GetVideoSourcesResponse);
	soap_default___trt__GetVideoSources(soap, &soap_tmp___trt__GetVideoSources);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetVideoSources(soap, &soap_tmp___trt__GetVideoSources, "-trt:GetVideoSources", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetVideoSources(soap, soap_tmp___trt__GetVideoSources.trt__GetVideoSources, &trt__GetVideoSourcesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetVideoSourcesResponse(soap, &trt__GetVideoSourcesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetVideoSourcesResponse(soap, &trt__GetVideoSourcesResponse, "trt:GetVideoSourcesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetVideoSourcesResponse(soap, &trt__GetVideoSourcesResponse, "trt:GetVideoSourcesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetAudioSources(struct soap *soap)
{	struct __trt__GetAudioSources soap_tmp___trt__GetAudioSources;
	struct _trt__GetAudioSourcesResponse trt__GetAudioSourcesResponse;
	soap_default__trt__GetAudioSourcesResponse(soap, &trt__GetAudioSourcesResponse);
	soap_default___trt__GetAudioSources(soap, &soap_tmp___trt__GetAudioSources);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetAudioSources(soap, &soap_tmp___trt__GetAudioSources, "-trt:GetAudioSources", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetAudioSources(soap, soap_tmp___trt__GetAudioSources.trt__GetAudioSources, &trt__GetAudioSourcesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetAudioSourcesResponse(soap, &trt__GetAudioSourcesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetAudioSourcesResponse(soap, &trt__GetAudioSourcesResponse, "trt:GetAudioSourcesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetAudioSourcesResponse(soap, &trt__GetAudioSourcesResponse, "trt:GetAudioSourcesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__CreateProfile(struct soap *soap)
{	struct __trt__CreateProfile soap_tmp___trt__CreateProfile;
	struct _trt__CreateProfileResponse trt__CreateProfileResponse;
	soap_default__trt__CreateProfileResponse(soap, &trt__CreateProfileResponse);
	soap_default___trt__CreateProfile(soap, &soap_tmp___trt__CreateProfile);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__CreateProfile(soap, &soap_tmp___trt__CreateProfile, "-trt:CreateProfile", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__CreateProfile(soap, soap_tmp___trt__CreateProfile.trt__CreateProfile, &trt__CreateProfileResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__CreateProfileResponse(soap, &trt__CreateProfileResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__CreateProfileResponse(soap, &trt__CreateProfileResponse, "trt:CreateProfileResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__CreateProfileResponse(soap, &trt__CreateProfileResponse, "trt:CreateProfileResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetProfile(struct soap *soap)
{	struct __trt__GetProfile soap_tmp___trt__GetProfile;
	struct _trt__GetProfileResponse trt__GetProfileResponse;
	soap_default__trt__GetProfileResponse(soap, &trt__GetProfileResponse);
	soap_default___trt__GetProfile(soap, &soap_tmp___trt__GetProfile);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetProfile(soap, &soap_tmp___trt__GetProfile, "-trt:GetProfile", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetProfile(soap, soap_tmp___trt__GetProfile.trt__GetProfile, &trt__GetProfileResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetProfileResponse(soap, &trt__GetProfileResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetProfileResponse(soap, &trt__GetProfileResponse, "trt:GetProfileResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetProfileResponse(soap, &trt__GetProfileResponse, "trt:GetProfileResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetProfiles(struct soap *soap)
{	struct __trt__GetProfiles soap_tmp___trt__GetProfiles;
	struct _trt__GetProfilesResponse trt__GetProfilesResponse;
	soap_default__trt__GetProfilesResponse(soap, &trt__GetProfilesResponse);
	soap_default___trt__GetProfiles(soap, &soap_tmp___trt__GetProfiles);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetProfiles(soap, &soap_tmp___trt__GetProfiles, "-trt:GetProfiles", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetProfiles(soap, soap_tmp___trt__GetProfiles.trt__GetProfiles, &trt__GetProfilesResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetProfilesResponse(soap, &trt__GetProfilesResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetProfilesResponse(soap, &trt__GetProfilesResponse, "trt:GetProfilesResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetProfilesResponse(soap, &trt__GetProfilesResponse, "trt:GetProfilesResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__AddVideoEncoderConfiguration(struct soap *soap)
{	struct __trt__AddVideoEncoderConfiguration soap_tmp___trt__AddVideoEncoderConfiguration;
	struct _trt__AddVideoEncoderConfigurationResponse trt__AddVideoEncoderConfigurationResponse;
	soap_default__trt__AddVideoEncoderConfigurationResponse(soap, &trt__AddVideoEncoderConfigurationResponse);
	soap_default___trt__AddVideoEncoderConfiguration(soap, &soap_tmp___trt__AddVideoEncoderConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__AddVideoEncoderConfiguration(soap, &soap_tmp___trt__AddVideoEncoderConfiguration, "-trt:AddVideoEncoderConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__AddVideoEncoderConfiguration(soap, soap_tmp___trt__AddVideoEncoderConfiguration.trt__AddVideoEncoderConfiguration, &trt__AddVideoEncoderConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__AddVideoEncoderConfigurationResponse(soap, &trt__AddVideoEncoderConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__AddVideoEncoderConfigurationResponse(soap, &trt__AddVideoEncoderConfigurationResponse, "trt:AddVideoEncoderConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__AddVideoEncoderConfigurationResponse(soap, &trt__AddVideoEncoderConfigurationResponse, "trt:AddVideoEncoderConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__AddVideoSourceConfiguration(struct soap *soap)
{	struct __trt__AddVideoSourceConfiguration soap_tmp___trt__AddVideoSourceConfiguration;
	struct _trt__AddVideoSourceConfigurationResponse trt__AddVideoSourceConfigurationResponse;
	soap_default__trt__AddVideoSourceConfigurationResponse(soap, &trt__AddVideoSourceConfigurationResponse);
	soap_default___trt__AddVideoSourceConfiguration(soap, &soap_tmp___trt__AddVideoSourceConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__AddVideoSourceConfiguration(soap, &soap_tmp___trt__AddVideoSourceConfiguration, "-trt:AddVideoSourceConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__AddVideoSourceConfiguration(soap, soap_tmp___trt__AddVideoSourceConfiguration.trt__AddVideoSourceConfiguration, &trt__AddVideoSourceConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__AddVideoSourceConfigurationResponse(soap, &trt__AddVideoSourceConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__AddVideoSourceConfigurationResponse(soap, &trt__AddVideoSourceConfigurationResponse, "trt:AddVideoSourceConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__AddVideoSourceConfigurationResponse(soap, &trt__AddVideoSourceConfigurationResponse, "trt:AddVideoSourceConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__AddAudioEncoderConfiguration(struct soap *soap)
{	struct __trt__AddAudioEncoderConfiguration soap_tmp___trt__AddAudioEncoderConfiguration;
	struct _trt__AddAudioEncoderConfigurationResponse trt__AddAudioEncoderConfigurationResponse;
	soap_default__trt__AddAudioEncoderConfigurationResponse(soap, &trt__AddAudioEncoderConfigurationResponse);
	soap_default___trt__AddAudioEncoderConfiguration(soap, &soap_tmp___trt__AddAudioEncoderConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__AddAudioEncoderConfiguration(soap, &soap_tmp___trt__AddAudioEncoderConfiguration, "-trt:AddAudioEncoderConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__AddAudioEncoderConfiguration(soap, soap_tmp___trt__AddAudioEncoderConfiguration.trt__AddAudioEncoderConfiguration, &trt__AddAudioEncoderConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__AddAudioEncoderConfigurationResponse(soap, &trt__AddAudioEncoderConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__AddAudioEncoderConfigurationResponse(soap, &trt__AddAudioEncoderConfigurationResponse, "trt:AddAudioEncoderConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__AddAudioEncoderConfigurationResponse(soap, &trt__AddAudioEncoderConfigurationResponse, "trt:AddAudioEncoderConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__AddAudioSourceConfiguration(struct soap *soap)
{	struct __trt__AddAudioSourceConfiguration soap_tmp___trt__AddAudioSourceConfiguration;
	struct _trt__AddAudioSourceConfigurationResponse trt__AddAudioSourceConfigurationResponse;
	soap_default__trt__AddAudioSourceConfigurationResponse(soap, &trt__AddAudioSourceConfigurationResponse);
	soap_default___trt__AddAudioSourceConfiguration(soap, &soap_tmp___trt__AddAudioSourceConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__AddAudioSourceConfiguration(soap, &soap_tmp___trt__AddAudioSourceConfiguration, "-trt:AddAudioSourceConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__AddAudioSourceConfiguration(soap, soap_tmp___trt__AddAudioSourceConfiguration.trt__AddAudioSourceConfiguration, &trt__AddAudioSourceConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__AddAudioSourceConfigurationResponse(soap, &trt__AddAudioSourceConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__AddAudioSourceConfigurationResponse(soap, &trt__AddAudioSourceConfigurationResponse, "trt:AddAudioSourceConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__AddAudioSourceConfigurationResponse(soap, &trt__AddAudioSourceConfigurationResponse, "trt:AddAudioSourceConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__RemoveVideoEncoderConfiguration(struct soap *soap)
{	struct __trt__RemoveVideoEncoderConfiguration soap_tmp___trt__RemoveVideoEncoderConfiguration;
	struct _trt__RemoveVideoEncoderConfigurationResponse trt__RemoveVideoEncoderConfigurationResponse;
	soap_default__trt__RemoveVideoEncoderConfigurationResponse(soap, &trt__RemoveVideoEncoderConfigurationResponse);
	soap_default___trt__RemoveVideoEncoderConfiguration(soap, &soap_tmp___trt__RemoveVideoEncoderConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__RemoveVideoEncoderConfiguration(soap, &soap_tmp___trt__RemoveVideoEncoderConfiguration, "-trt:RemoveVideoEncoderConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__RemoveVideoEncoderConfiguration(soap, soap_tmp___trt__RemoveVideoEncoderConfiguration.trt__RemoveVideoEncoderConfiguration, &trt__RemoveVideoEncoderConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__RemoveVideoEncoderConfigurationResponse(soap, &trt__RemoveVideoEncoderConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__RemoveVideoEncoderConfigurationResponse(soap, &trt__RemoveVideoEncoderConfigurationResponse, "trt:RemoveVideoEncoderConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__RemoveVideoEncoderConfigurationResponse(soap, &trt__RemoveVideoEncoderConfigurationResponse, "trt:RemoveVideoEncoderConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__RemoveVideoSourceConfiguration(struct soap *soap)
{	struct __trt__RemoveVideoSourceConfiguration soap_tmp___trt__RemoveVideoSourceConfiguration;
	struct _trt__RemoveVideoSourceConfigurationResponse trt__RemoveVideoSourceConfigurationResponse;
	soap_default__trt__RemoveVideoSourceConfigurationResponse(soap, &trt__RemoveVideoSourceConfigurationResponse);
	soap_default___trt__RemoveVideoSourceConfiguration(soap, &soap_tmp___trt__RemoveVideoSourceConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__RemoveVideoSourceConfiguration(soap, &soap_tmp___trt__RemoveVideoSourceConfiguration, "-trt:RemoveVideoSourceConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__RemoveVideoSourceConfiguration(soap, soap_tmp___trt__RemoveVideoSourceConfiguration.trt__RemoveVideoSourceConfiguration, &trt__RemoveVideoSourceConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__RemoveVideoSourceConfigurationResponse(soap, &trt__RemoveVideoSourceConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__RemoveVideoSourceConfigurationResponse(soap, &trt__RemoveVideoSourceConfigurationResponse, "trt:RemoveVideoSourceConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__RemoveVideoSourceConfigurationResponse(soap, &trt__RemoveVideoSourceConfigurationResponse, "trt:RemoveVideoSourceConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__RemoveAudioEncoderConfiguration(struct soap *soap)
{	struct __trt__RemoveAudioEncoderConfiguration soap_tmp___trt__RemoveAudioEncoderConfiguration;
	struct _trt__RemoveAudioEncoderConfigurationResponse trt__RemoveAudioEncoderConfigurationResponse;
	soap_default__trt__RemoveAudioEncoderConfigurationResponse(soap, &trt__RemoveAudioEncoderConfigurationResponse);
	soap_default___trt__RemoveAudioEncoderConfiguration(soap, &soap_tmp___trt__RemoveAudioEncoderConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__RemoveAudioEncoderConfiguration(soap, &soap_tmp___trt__RemoveAudioEncoderConfiguration, "-trt:RemoveAudioEncoderConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__RemoveAudioEncoderConfiguration(soap, soap_tmp___trt__RemoveAudioEncoderConfiguration.trt__RemoveAudioEncoderConfiguration, &trt__RemoveAudioEncoderConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__RemoveAudioEncoderConfigurationResponse(soap, &trt__RemoveAudioEncoderConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__RemoveAudioEncoderConfigurationResponse(soap, &trt__RemoveAudioEncoderConfigurationResponse, "trt:RemoveAudioEncoderConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__RemoveAudioEncoderConfigurationResponse(soap, &trt__RemoveAudioEncoderConfigurationResponse, "trt:RemoveAudioEncoderConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__RemoveAudioSourceConfiguration(struct soap *soap)
{	struct __trt__RemoveAudioSourceConfiguration soap_tmp___trt__RemoveAudioSourceConfiguration;
	struct _trt__RemoveAudioSourceConfigurationResponse trt__RemoveAudioSourceConfigurationResponse;
	soap_default__trt__RemoveAudioSourceConfigurationResponse(soap, &trt__RemoveAudioSourceConfigurationResponse);
	soap_default___trt__RemoveAudioSourceConfiguration(soap, &soap_tmp___trt__RemoveAudioSourceConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__RemoveAudioSourceConfiguration(soap, &soap_tmp___trt__RemoveAudioSourceConfiguration, "-trt:RemoveAudioSourceConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__RemoveAudioSourceConfiguration(soap, soap_tmp___trt__RemoveAudioSourceConfiguration.trt__RemoveAudioSourceConfiguration, &trt__RemoveAudioSourceConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__RemoveAudioSourceConfigurationResponse(soap, &trt__RemoveAudioSourceConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__RemoveAudioSourceConfigurationResponse(soap, &trt__RemoveAudioSourceConfigurationResponse, "trt:RemoveAudioSourceConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__RemoveAudioSourceConfigurationResponse(soap, &trt__RemoveAudioSourceConfigurationResponse, "trt:RemoveAudioSourceConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__DeleteProfile(struct soap *soap)
{	struct __trt__DeleteProfile soap_tmp___trt__DeleteProfile;
	struct _trt__DeleteProfileResponse trt__DeleteProfileResponse;
	soap_default__trt__DeleteProfileResponse(soap, &trt__DeleteProfileResponse);
	soap_default___trt__DeleteProfile(soap, &soap_tmp___trt__DeleteProfile);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__DeleteProfile(soap, &soap_tmp___trt__DeleteProfile, "-trt:DeleteProfile", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__DeleteProfile(soap, soap_tmp___trt__DeleteProfile.trt__DeleteProfile, &trt__DeleteProfileResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__DeleteProfileResponse(soap, &trt__DeleteProfileResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__DeleteProfileResponse(soap, &trt__DeleteProfileResponse, "trt:DeleteProfileResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__DeleteProfileResponse(soap, &trt__DeleteProfileResponse, "trt:DeleteProfileResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetVideoSourceConfigurations(struct soap *soap)
{	struct __trt__GetVideoSourceConfigurations soap_tmp___trt__GetVideoSourceConfigurations;
	struct _trt__GetVideoSourceConfigurationsResponse trt__GetVideoSourceConfigurationsResponse;
	soap_default__trt__GetVideoSourceConfigurationsResponse(soap, &trt__GetVideoSourceConfigurationsResponse);
	soap_default___trt__GetVideoSourceConfigurations(soap, &soap_tmp___trt__GetVideoSourceConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetVideoSourceConfigurations(soap, &soap_tmp___trt__GetVideoSourceConfigurations, "-trt:GetVideoSourceConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetVideoSourceConfigurations(soap, soap_tmp___trt__GetVideoSourceConfigurations.trt__GetVideoSourceConfigurations, &trt__GetVideoSourceConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetVideoSourceConfigurationsResponse(soap, &trt__GetVideoSourceConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetVideoSourceConfigurationsResponse(soap, &trt__GetVideoSourceConfigurationsResponse, "trt:GetVideoSourceConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetVideoSourceConfigurationsResponse(soap, &trt__GetVideoSourceConfigurationsResponse, "trt:GetVideoSourceConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetVideoEncoderConfigurations(struct soap *soap)
{	struct __trt__GetVideoEncoderConfigurations soap_tmp___trt__GetVideoEncoderConfigurations;
	struct _trt__GetVideoEncoderConfigurationsResponse trt__GetVideoEncoderConfigurationsResponse;
	soap_default__trt__GetVideoEncoderConfigurationsResponse(soap, &trt__GetVideoEncoderConfigurationsResponse);
	soap_default___trt__GetVideoEncoderConfigurations(soap, &soap_tmp___trt__GetVideoEncoderConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetVideoEncoderConfigurations(soap, &soap_tmp___trt__GetVideoEncoderConfigurations, "-trt:GetVideoEncoderConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetVideoEncoderConfigurations(soap, soap_tmp___trt__GetVideoEncoderConfigurations.trt__GetVideoEncoderConfigurations, &trt__GetVideoEncoderConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetVideoEncoderConfigurationsResponse(soap, &trt__GetVideoEncoderConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetVideoEncoderConfigurationsResponse(soap, &trt__GetVideoEncoderConfigurationsResponse, "trt:GetVideoEncoderConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetVideoEncoderConfigurationsResponse(soap, &trt__GetVideoEncoderConfigurationsResponse, "trt:GetVideoEncoderConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetAudioSourceConfigurations(struct soap *soap)
{	struct __trt__GetAudioSourceConfigurations soap_tmp___trt__GetAudioSourceConfigurations;
	struct _trt__GetAudioSourceConfigurationsResponse trt__GetAudioSourceConfigurationsResponse;
	soap_default__trt__GetAudioSourceConfigurationsResponse(soap, &trt__GetAudioSourceConfigurationsResponse);
	soap_default___trt__GetAudioSourceConfigurations(soap, &soap_tmp___trt__GetAudioSourceConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetAudioSourceConfigurations(soap, &soap_tmp___trt__GetAudioSourceConfigurations, "-trt:GetAudioSourceConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetAudioSourceConfigurations(soap, soap_tmp___trt__GetAudioSourceConfigurations.trt__GetAudioSourceConfigurations, &trt__GetAudioSourceConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetAudioSourceConfigurationsResponse(soap, &trt__GetAudioSourceConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetAudioSourceConfigurationsResponse(soap, &trt__GetAudioSourceConfigurationsResponse, "trt:GetAudioSourceConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetAudioSourceConfigurationsResponse(soap, &trt__GetAudioSourceConfigurationsResponse, "trt:GetAudioSourceConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetAudioEncoderConfigurations(struct soap *soap)
{	struct __trt__GetAudioEncoderConfigurations soap_tmp___trt__GetAudioEncoderConfigurations;
	struct _trt__GetAudioEncoderConfigurationsResponse trt__GetAudioEncoderConfigurationsResponse;
	soap_default__trt__GetAudioEncoderConfigurationsResponse(soap, &trt__GetAudioEncoderConfigurationsResponse);
	soap_default___trt__GetAudioEncoderConfigurations(soap, &soap_tmp___trt__GetAudioEncoderConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetAudioEncoderConfigurations(soap, &soap_tmp___trt__GetAudioEncoderConfigurations, "-trt:GetAudioEncoderConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetAudioEncoderConfigurations(soap, soap_tmp___trt__GetAudioEncoderConfigurations.trt__GetAudioEncoderConfigurations, &trt__GetAudioEncoderConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetAudioEncoderConfigurationsResponse(soap, &trt__GetAudioEncoderConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetAudioEncoderConfigurationsResponse(soap, &trt__GetAudioEncoderConfigurationsResponse, "trt:GetAudioEncoderConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetAudioEncoderConfigurationsResponse(soap, &trt__GetAudioEncoderConfigurationsResponse, "trt:GetAudioEncoderConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetVideoSourceConfiguration(struct soap *soap)
{	struct __trt__GetVideoSourceConfiguration soap_tmp___trt__GetVideoSourceConfiguration;
	struct _trt__GetVideoSourceConfigurationResponse trt__GetVideoSourceConfigurationResponse;
	soap_default__trt__GetVideoSourceConfigurationResponse(soap, &trt__GetVideoSourceConfigurationResponse);
	soap_default___trt__GetVideoSourceConfiguration(soap, &soap_tmp___trt__GetVideoSourceConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetVideoSourceConfiguration(soap, &soap_tmp___trt__GetVideoSourceConfiguration, "-trt:GetVideoSourceConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetVideoSourceConfiguration(soap, soap_tmp___trt__GetVideoSourceConfiguration.trt__GetVideoSourceConfiguration, &trt__GetVideoSourceConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetVideoSourceConfigurationResponse(soap, &trt__GetVideoSourceConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetVideoSourceConfigurationResponse(soap, &trt__GetVideoSourceConfigurationResponse, "trt:GetVideoSourceConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetVideoSourceConfigurationResponse(soap, &trt__GetVideoSourceConfigurationResponse, "trt:GetVideoSourceConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetVideoEncoderConfiguration(struct soap *soap)
{	struct __trt__GetVideoEncoderConfiguration soap_tmp___trt__GetVideoEncoderConfiguration;
	struct _trt__GetVideoEncoderConfigurationResponse trt__GetVideoEncoderConfigurationResponse;
	soap_default__trt__GetVideoEncoderConfigurationResponse(soap, &trt__GetVideoEncoderConfigurationResponse);
	soap_default___trt__GetVideoEncoderConfiguration(soap, &soap_tmp___trt__GetVideoEncoderConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetVideoEncoderConfiguration(soap, &soap_tmp___trt__GetVideoEncoderConfiguration, "-trt:GetVideoEncoderConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetVideoEncoderConfiguration(soap, soap_tmp___trt__GetVideoEncoderConfiguration.trt__GetVideoEncoderConfiguration, &trt__GetVideoEncoderConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetVideoEncoderConfigurationResponse(soap, &trt__GetVideoEncoderConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetVideoEncoderConfigurationResponse(soap, &trt__GetVideoEncoderConfigurationResponse, "trt:GetVideoEncoderConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetVideoEncoderConfigurationResponse(soap, &trt__GetVideoEncoderConfigurationResponse, "trt:GetVideoEncoderConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetAudioSourceConfiguration(struct soap *soap)
{	struct __trt__GetAudioSourceConfiguration soap_tmp___trt__GetAudioSourceConfiguration;
	struct _trt__GetAudioSourceConfigurationResponse trt__GetAudioSourceConfigurationResponse;
	soap_default__trt__GetAudioSourceConfigurationResponse(soap, &trt__GetAudioSourceConfigurationResponse);
	soap_default___trt__GetAudioSourceConfiguration(soap, &soap_tmp___trt__GetAudioSourceConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetAudioSourceConfiguration(soap, &soap_tmp___trt__GetAudioSourceConfiguration, "-trt:GetAudioSourceConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetAudioSourceConfiguration(soap, soap_tmp___trt__GetAudioSourceConfiguration.trt__GetAudioSourceConfiguration, &trt__GetAudioSourceConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetAudioSourceConfigurationResponse(soap, &trt__GetAudioSourceConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetAudioSourceConfigurationResponse(soap, &trt__GetAudioSourceConfigurationResponse, "trt:GetAudioSourceConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetAudioSourceConfigurationResponse(soap, &trt__GetAudioSourceConfigurationResponse, "trt:GetAudioSourceConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetAudioEncoderConfiguration(struct soap *soap)
{	struct __trt__GetAudioEncoderConfiguration soap_tmp___trt__GetAudioEncoderConfiguration;
	struct _trt__GetAudioEncoderConfigurationResponse trt__GetAudioEncoderConfigurationResponse;
	soap_default__trt__GetAudioEncoderConfigurationResponse(soap, &trt__GetAudioEncoderConfigurationResponse);
	soap_default___trt__GetAudioEncoderConfiguration(soap, &soap_tmp___trt__GetAudioEncoderConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetAudioEncoderConfiguration(soap, &soap_tmp___trt__GetAudioEncoderConfiguration, "-trt:GetAudioEncoderConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetAudioEncoderConfiguration(soap, soap_tmp___trt__GetAudioEncoderConfiguration.trt__GetAudioEncoderConfiguration, &trt__GetAudioEncoderConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetAudioEncoderConfigurationResponse(soap, &trt__GetAudioEncoderConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetAudioEncoderConfigurationResponse(soap, &trt__GetAudioEncoderConfigurationResponse, "trt:GetAudioEncoderConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetAudioEncoderConfigurationResponse(soap, &trt__GetAudioEncoderConfigurationResponse, "trt:GetAudioEncoderConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap)
{	struct __trt__GetCompatibleVideoEncoderConfigurations soap_tmp___trt__GetCompatibleVideoEncoderConfigurations;
	struct _trt__GetCompatibleVideoEncoderConfigurationsResponse trt__GetCompatibleVideoEncoderConfigurationsResponse;
	soap_default__trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, &trt__GetCompatibleVideoEncoderConfigurationsResponse);
	soap_default___trt__GetCompatibleVideoEncoderConfigurations(soap, &soap_tmp___trt__GetCompatibleVideoEncoderConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetCompatibleVideoEncoderConfigurations(soap, &soap_tmp___trt__GetCompatibleVideoEncoderConfigurations, "-trt:GetCompatibleVideoEncoderConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetCompatibleVideoEncoderConfigurations(soap, soap_tmp___trt__GetCompatibleVideoEncoderConfigurations.trt__GetCompatibleVideoEncoderConfigurations, &trt__GetCompatibleVideoEncoderConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, &trt__GetCompatibleVideoEncoderConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, &trt__GetCompatibleVideoEncoderConfigurationsResponse, "trt:GetCompatibleVideoEncoderConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetCompatibleVideoEncoderConfigurationsResponse(soap, &trt__GetCompatibleVideoEncoderConfigurationsResponse, "trt:GetCompatibleVideoEncoderConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetCompatibleVideoSourceConfigurations(struct soap *soap)
{	struct __trt__GetCompatibleVideoSourceConfigurations soap_tmp___trt__GetCompatibleVideoSourceConfigurations;
	struct _trt__GetCompatibleVideoSourceConfigurationsResponse trt__GetCompatibleVideoSourceConfigurationsResponse;
	soap_default__trt__GetCompatibleVideoSourceConfigurationsResponse(soap, &trt__GetCompatibleVideoSourceConfigurationsResponse);
	soap_default___trt__GetCompatibleVideoSourceConfigurations(soap, &soap_tmp___trt__GetCompatibleVideoSourceConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetCompatibleVideoSourceConfigurations(soap, &soap_tmp___trt__GetCompatibleVideoSourceConfigurations, "-trt:GetCompatibleVideoSourceConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetCompatibleVideoSourceConfigurations(soap, soap_tmp___trt__GetCompatibleVideoSourceConfigurations.trt__GetCompatibleVideoSourceConfigurations, &trt__GetCompatibleVideoSourceConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetCompatibleVideoSourceConfigurationsResponse(soap, &trt__GetCompatibleVideoSourceConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetCompatibleVideoSourceConfigurationsResponse(soap, &trt__GetCompatibleVideoSourceConfigurationsResponse, "trt:GetCompatibleVideoSourceConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetCompatibleVideoSourceConfigurationsResponse(soap, &trt__GetCompatibleVideoSourceConfigurationsResponse, "trt:GetCompatibleVideoSourceConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap)
{	struct __trt__GetCompatibleAudioEncoderConfigurations soap_tmp___trt__GetCompatibleAudioEncoderConfigurations;
	struct _trt__GetCompatibleAudioEncoderConfigurationsResponse trt__GetCompatibleAudioEncoderConfigurationsResponse;
	soap_default__trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, &trt__GetCompatibleAudioEncoderConfigurationsResponse);
	soap_default___trt__GetCompatibleAudioEncoderConfigurations(soap, &soap_tmp___trt__GetCompatibleAudioEncoderConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetCompatibleAudioEncoderConfigurations(soap, &soap_tmp___trt__GetCompatibleAudioEncoderConfigurations, "-trt:GetCompatibleAudioEncoderConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetCompatibleAudioEncoderConfigurations(soap, soap_tmp___trt__GetCompatibleAudioEncoderConfigurations.trt__GetCompatibleAudioEncoderConfigurations, &trt__GetCompatibleAudioEncoderConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, &trt__GetCompatibleAudioEncoderConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, &trt__GetCompatibleAudioEncoderConfigurationsResponse, "trt:GetCompatibleAudioEncoderConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetCompatibleAudioEncoderConfigurationsResponse(soap, &trt__GetCompatibleAudioEncoderConfigurationsResponse, "trt:GetCompatibleAudioEncoderConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetCompatibleAudioSourceConfigurations(struct soap *soap)
{	struct __trt__GetCompatibleAudioSourceConfigurations soap_tmp___trt__GetCompatibleAudioSourceConfigurations;
	struct _trt__GetCompatibleAudioSourceConfigurationsResponse trt__GetCompatibleAudioSourceConfigurationsResponse;
	soap_default__trt__GetCompatibleAudioSourceConfigurationsResponse(soap, &trt__GetCompatibleAudioSourceConfigurationsResponse);
	soap_default___trt__GetCompatibleAudioSourceConfigurations(soap, &soap_tmp___trt__GetCompatibleAudioSourceConfigurations);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetCompatibleAudioSourceConfigurations(soap, &soap_tmp___trt__GetCompatibleAudioSourceConfigurations, "-trt:GetCompatibleAudioSourceConfigurations", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetCompatibleAudioSourceConfigurations(soap, soap_tmp___trt__GetCompatibleAudioSourceConfigurations.trt__GetCompatibleAudioSourceConfigurations, &trt__GetCompatibleAudioSourceConfigurationsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetCompatibleAudioSourceConfigurationsResponse(soap, &trt__GetCompatibleAudioSourceConfigurationsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetCompatibleAudioSourceConfigurationsResponse(soap, &trt__GetCompatibleAudioSourceConfigurationsResponse, "trt:GetCompatibleAudioSourceConfigurationsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetCompatibleAudioSourceConfigurationsResponse(soap, &trt__GetCompatibleAudioSourceConfigurationsResponse, "trt:GetCompatibleAudioSourceConfigurationsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__SetVideoSourceConfiguration(struct soap *soap)
{	struct __trt__SetVideoSourceConfiguration soap_tmp___trt__SetVideoSourceConfiguration;
	struct _trt__SetVideoSourceConfigurationResponse trt__SetVideoSourceConfigurationResponse;
	soap_default__trt__SetVideoSourceConfigurationResponse(soap, &trt__SetVideoSourceConfigurationResponse);
	soap_default___trt__SetVideoSourceConfiguration(soap, &soap_tmp___trt__SetVideoSourceConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__SetVideoSourceConfiguration(soap, &soap_tmp___trt__SetVideoSourceConfiguration, "-trt:SetVideoSourceConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__SetVideoSourceConfiguration(soap, soap_tmp___trt__SetVideoSourceConfiguration.trt__SetVideoSourceConfiguration, &trt__SetVideoSourceConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__SetVideoSourceConfigurationResponse(soap, &trt__SetVideoSourceConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__SetVideoSourceConfigurationResponse(soap, &trt__SetVideoSourceConfigurationResponse, "trt:SetVideoSourceConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__SetVideoSourceConfigurationResponse(soap, &trt__SetVideoSourceConfigurationResponse, "trt:SetVideoSourceConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__SetVideoEncoderConfiguration(struct soap *soap)
{	struct __trt__SetVideoEncoderConfiguration soap_tmp___trt__SetVideoEncoderConfiguration;
	struct _trt__SetVideoEncoderConfigurationResponse trt__SetVideoEncoderConfigurationResponse;
	soap_default__trt__SetVideoEncoderConfigurationResponse(soap, &trt__SetVideoEncoderConfigurationResponse);
	soap_default___trt__SetVideoEncoderConfiguration(soap, &soap_tmp___trt__SetVideoEncoderConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__SetVideoEncoderConfiguration(soap, &soap_tmp___trt__SetVideoEncoderConfiguration, "-trt:SetVideoEncoderConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__SetVideoEncoderConfiguration(soap, soap_tmp___trt__SetVideoEncoderConfiguration.trt__SetVideoEncoderConfiguration, &trt__SetVideoEncoderConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__SetVideoEncoderConfigurationResponse(soap, &trt__SetVideoEncoderConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__SetVideoEncoderConfigurationResponse(soap, &trt__SetVideoEncoderConfigurationResponse, "trt:SetVideoEncoderConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__SetVideoEncoderConfigurationResponse(soap, &trt__SetVideoEncoderConfigurationResponse, "trt:SetVideoEncoderConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__SetAudioSourceConfiguration(struct soap *soap)
{	struct __trt__SetAudioSourceConfiguration soap_tmp___trt__SetAudioSourceConfiguration;
	struct _trt__SetAudioSourceConfigurationResponse trt__SetAudioSourceConfigurationResponse;
	soap_default__trt__SetAudioSourceConfigurationResponse(soap, &trt__SetAudioSourceConfigurationResponse);
	soap_default___trt__SetAudioSourceConfiguration(soap, &soap_tmp___trt__SetAudioSourceConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__SetAudioSourceConfiguration(soap, &soap_tmp___trt__SetAudioSourceConfiguration, "-trt:SetAudioSourceConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__SetAudioSourceConfiguration(soap, soap_tmp___trt__SetAudioSourceConfiguration.trt__SetAudioSourceConfiguration, &trt__SetAudioSourceConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__SetAudioSourceConfigurationResponse(soap, &trt__SetAudioSourceConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__SetAudioSourceConfigurationResponse(soap, &trt__SetAudioSourceConfigurationResponse, "trt:SetAudioSourceConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__SetAudioSourceConfigurationResponse(soap, &trt__SetAudioSourceConfigurationResponse, "trt:SetAudioSourceConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__SetAudioEncoderConfiguration(struct soap *soap)
{	struct __trt__SetAudioEncoderConfiguration soap_tmp___trt__SetAudioEncoderConfiguration;
	struct _trt__SetAudioEncoderConfigurationResponse trt__SetAudioEncoderConfigurationResponse;
	soap_default__trt__SetAudioEncoderConfigurationResponse(soap, &trt__SetAudioEncoderConfigurationResponse);
	soap_default___trt__SetAudioEncoderConfiguration(soap, &soap_tmp___trt__SetAudioEncoderConfiguration);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__SetAudioEncoderConfiguration(soap, &soap_tmp___trt__SetAudioEncoderConfiguration, "-trt:SetAudioEncoderConfiguration", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__SetAudioEncoderConfiguration(soap, soap_tmp___trt__SetAudioEncoderConfiguration.trt__SetAudioEncoderConfiguration, &trt__SetAudioEncoderConfigurationResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__SetAudioEncoderConfigurationResponse(soap, &trt__SetAudioEncoderConfigurationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__SetAudioEncoderConfigurationResponse(soap, &trt__SetAudioEncoderConfigurationResponse, "trt:SetAudioEncoderConfigurationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__SetAudioEncoderConfigurationResponse(soap, &trt__SetAudioEncoderConfigurationResponse, "trt:SetAudioEncoderConfigurationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetVideoSourceConfigurationOptions(struct soap *soap)
{	struct __trt__GetVideoSourceConfigurationOptions soap_tmp___trt__GetVideoSourceConfigurationOptions;
	struct _trt__GetVideoSourceConfigurationOptionsResponse trt__GetVideoSourceConfigurationOptionsResponse;
	soap_default__trt__GetVideoSourceConfigurationOptionsResponse(soap, &trt__GetVideoSourceConfigurationOptionsResponse);
	soap_default___trt__GetVideoSourceConfigurationOptions(soap, &soap_tmp___trt__GetVideoSourceConfigurationOptions);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetVideoSourceConfigurationOptions(soap, &soap_tmp___trt__GetVideoSourceConfigurationOptions, "-trt:GetVideoSourceConfigurationOptions", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetVideoSourceConfigurationOptions(soap, soap_tmp___trt__GetVideoSourceConfigurationOptions.trt__GetVideoSourceConfigurationOptions, &trt__GetVideoSourceConfigurationOptionsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetVideoSourceConfigurationOptionsResponse(soap, &trt__GetVideoSourceConfigurationOptionsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetVideoSourceConfigurationOptionsResponse(soap, &trt__GetVideoSourceConfigurationOptionsResponse, "trt:GetVideoSourceConfigurationOptionsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetVideoSourceConfigurationOptionsResponse(soap, &trt__GetVideoSourceConfigurationOptionsResponse, "trt:GetVideoSourceConfigurationOptionsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetVideoEncoderConfigurationOptions(struct soap *soap)
{	struct __trt__GetVideoEncoderConfigurationOptions soap_tmp___trt__GetVideoEncoderConfigurationOptions;
	struct _trt__GetVideoEncoderConfigurationOptionsResponse trt__GetVideoEncoderConfigurationOptionsResponse;
	soap_default__trt__GetVideoEncoderConfigurationOptionsResponse(soap, &trt__GetVideoEncoderConfigurationOptionsResponse);
	soap_default___trt__GetVideoEncoderConfigurationOptions(soap, &soap_tmp___trt__GetVideoEncoderConfigurationOptions);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetVideoEncoderConfigurationOptions(soap, &soap_tmp___trt__GetVideoEncoderConfigurationOptions, "-trt:GetVideoEncoderConfigurationOptions", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetVideoEncoderConfigurationOptions(soap, soap_tmp___trt__GetVideoEncoderConfigurationOptions.trt__GetVideoEncoderConfigurationOptions, &trt__GetVideoEncoderConfigurationOptionsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetVideoEncoderConfigurationOptionsResponse(soap, &trt__GetVideoEncoderConfigurationOptionsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetVideoEncoderConfigurationOptionsResponse(soap, &trt__GetVideoEncoderConfigurationOptionsResponse, "trt:GetVideoEncoderConfigurationOptionsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetVideoEncoderConfigurationOptionsResponse(soap, &trt__GetVideoEncoderConfigurationOptionsResponse, "trt:GetVideoEncoderConfigurationOptionsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetAudioSourceConfigurationOptions(struct soap *soap)
{	struct __trt__GetAudioSourceConfigurationOptions soap_tmp___trt__GetAudioSourceConfigurationOptions;
	struct _trt__GetAudioSourceConfigurationOptionsResponse trt__GetAudioSourceConfigurationOptionsResponse;
	soap_default__trt__GetAudioSourceConfigurationOptionsResponse(soap, &trt__GetAudioSourceConfigurationOptionsResponse);
	soap_default___trt__GetAudioSourceConfigurationOptions(soap, &soap_tmp___trt__GetAudioSourceConfigurationOptions);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetAudioSourceConfigurationOptions(soap, &soap_tmp___trt__GetAudioSourceConfigurationOptions, "-trt:GetAudioSourceConfigurationOptions", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetAudioSourceConfigurationOptions(soap, soap_tmp___trt__GetAudioSourceConfigurationOptions.trt__GetAudioSourceConfigurationOptions, &trt__GetAudioSourceConfigurationOptionsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetAudioSourceConfigurationOptionsResponse(soap, &trt__GetAudioSourceConfigurationOptionsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetAudioSourceConfigurationOptionsResponse(soap, &trt__GetAudioSourceConfigurationOptionsResponse, "trt:GetAudioSourceConfigurationOptionsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetAudioSourceConfigurationOptionsResponse(soap, &trt__GetAudioSourceConfigurationOptionsResponse, "trt:GetAudioSourceConfigurationOptionsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetAudioEncoderConfigurationOptions(struct soap *soap)
{	struct __trt__GetAudioEncoderConfigurationOptions soap_tmp___trt__GetAudioEncoderConfigurationOptions;
	struct _trt__GetAudioEncoderConfigurationOptionsResponse trt__GetAudioEncoderConfigurationOptionsResponse;
	soap_default__trt__GetAudioEncoderConfigurationOptionsResponse(soap, &trt__GetAudioEncoderConfigurationOptionsResponse);
	soap_default___trt__GetAudioEncoderConfigurationOptions(soap, &soap_tmp___trt__GetAudioEncoderConfigurationOptions);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetAudioEncoderConfigurationOptions(soap, &soap_tmp___trt__GetAudioEncoderConfigurationOptions, "-trt:GetAudioEncoderConfigurationOptions", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetAudioEncoderConfigurationOptions(soap, soap_tmp___trt__GetAudioEncoderConfigurationOptions.trt__GetAudioEncoderConfigurationOptions, &trt__GetAudioEncoderConfigurationOptionsResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetAudioEncoderConfigurationOptionsResponse(soap, &trt__GetAudioEncoderConfigurationOptionsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetAudioEncoderConfigurationOptionsResponse(soap, &trt__GetAudioEncoderConfigurationOptionsResponse, "trt:GetAudioEncoderConfigurationOptionsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetAudioEncoderConfigurationOptionsResponse(soap, &trt__GetAudioEncoderConfigurationOptionsResponse, "trt:GetAudioEncoderConfigurationOptionsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetStreamUri(struct soap *soap)
{	struct __trt__GetStreamUri soap_tmp___trt__GetStreamUri;
	struct _trt__GetStreamUriResponse trt__GetStreamUriResponse;
	soap_default__trt__GetStreamUriResponse(soap, &trt__GetStreamUriResponse);
	soap_default___trt__GetStreamUri(soap, &soap_tmp___trt__GetStreamUri);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetStreamUri(soap, &soap_tmp___trt__GetStreamUri, "-trt:GetStreamUri", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetStreamUri(soap, soap_tmp___trt__GetStreamUri.trt__GetStreamUri, &trt__GetStreamUriResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetStreamUriResponse(soap, &trt__GetStreamUriResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetStreamUriResponse(soap, &trt__GetStreamUriResponse, "trt:GetStreamUriResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetStreamUriResponse(soap, &trt__GetStreamUriResponse, "trt:GetStreamUriResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve___trt__GetSnapshotUri(struct soap *soap)
{	struct __trt__GetSnapshotUri soap_tmp___trt__GetSnapshotUri;
	struct _trt__GetSnapshotUriResponse trt__GetSnapshotUriResponse;
	soap_default__trt__GetSnapshotUriResponse(soap, &trt__GetSnapshotUriResponse);
	soap_default___trt__GetSnapshotUri(soap, &soap_tmp___trt__GetSnapshotUri);
	soap->encodingStyle = NULL;
	if (!soap_get___trt__GetSnapshotUri(soap, &soap_tmp___trt__GetSnapshotUri, "-trt:GetSnapshotUri", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = __trt__GetSnapshotUri(soap, soap_tmp___trt__GetSnapshotUri.trt__GetSnapshotUri, &trt__GetSnapshotUriResponse);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize__trt__GetSnapshotUriResponse(soap, &trt__GetSnapshotUriResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put__trt__GetSnapshotUriResponse(soap, &trt__GetSnapshotUriResponse, "trt:GetSnapshotUriResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put__trt__GetSnapshotUriResponse(soap, &trt__GetSnapshotUriResponse, "trt:GetSnapshotUriResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

#ifdef __cplusplus
}
#endif

#if defined(__BORLANDC__)
#pragma option pop
#pragma option pop
#endif

/* End of soapServer.c */
