#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <stdio.h>

#define MAXRECVSTRING 8012

int main(int argc, char *argv[])
{
	int sock; /* Socket */
	struct sockaddr_in multicastAddr; /* Multicast Address */
	char *multicastIP; /* IP Multicast Address */
	unsigned short multicastPort; /* Port */
	char recvString[MAXRECVSTRING+1]; /*Buffer for received string */
	int recvStringLen; /* Length of received string */
	struct ip_mreq multicastRequest; /* Multicast address join structure */
	
	if (argc != 3) /* Test for correct number of arguments */
	{
		fprintf(stderr,"Usage: %s<Multicast IP> <Multicast Port>\n", argv[0]);
		exit(1);
	}
	multicastIP = argv[1]; /* First arg: Multicast IP address(dotted quad) */
	multicastPort = atoi(argv[2]);/* Second arg: Multicast port */
	
	/* Create a best-effort datagram socket using UDP */
	if ((sock = socket(PF_INET, SOCK_DGRAM,IPPROTO_UDP)) < 0)
		perror("socket() failed");
	/* Construct bind structure */
	memset(&multicastAddr, 0,sizeof(multicastAddr)); /* Zero out structure */
	multicastAddr.sin_family = AF_INET; /* Internet address family */
	multicastAddr.sin_addr.s_addr = htonl(INADDR_ANY); /* Any incoming interface */
	multicastAddr.sin_port = htons(multicastPort); /* Multicast port */
	
	/* Bind to the multicast port */
	if (bind(sock, (struct sockaddr *)&multicastAddr, sizeof(multicastAddr)) < 0)
		perror("bind() failed");
	
	/* Specify the multicast group */
	multicastRequest.imr_multiaddr.s_addr = inet_addr(multicastIP);
	
	/* Accept multicast from any interface */
	multicastRequest.imr_interface.s_addr = htonl(INADDR_ANY);
	
	/* Join the multicast address */
	
	if (setsockopt(sock, IPPROTO_IP, IP_ADD_MEMBERSHIP, (void *) &multicastRequest, sizeof(multicastRequest)) < 0)
		perror("setsockopt() failed");
	
	/* Receive a single datagram from the server */
	int c;
	int x1 = 1000000; /* initialize loop variables */
	int x2 = 0;
	while (x2 < x1)
	{
		/* x1++ */
		/*  uncomment the line above to have a limit */
		if ((recvStringLen = recvfrom(sock, recvString, MAXRECVSTRING, 0, NULL, 0)) < 0)
			perror("recvfrom() failed");
		recvString[recvStringLen] = '\0';
		time_t tim=time(NULL); /* get time stamp to print with recieved data */
		char *s=ctime(&tim);
		s[strlen(s)-1]=0; 
		// remove \n
		/* printf("it is %s now.\n", s); */
	
		printf("Time Received: %s : %s\n", s, recvString); /* Print the received string */
	
	}
	close(sock);
	exit(0);
} /* main */
