/*******************************************************************
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: cardif_linux_rtnetlink.c
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _CARDIF_LINUX_RTNETLINK_H_
#define _CARDIF_LINUX_RTNETLINK_H_

#ifndef IF_LINK_MODE_DORMANT
#define IF_LINK_MODE_DORMANT  1
#endif

#ifndef IF_LINK_MODE_DEFAULT
#define IF_LINK_MODE_DEFAULT  0
#endif

void cardif_linux_rtnetlink_init(struct interface_data *);
void cardif_linux_rtnetlink_cleanup(struct interface_data *);
int cardif_linux_rtnetlink_check_event(struct interface_data *, int);
void cardif_linux_rtnetlink_do_link(struct interface_data *,
				    struct nlmsghdr *, int, int,
				    struct wireless_state *);
void cardif_linux_rtnetlink_ifla_wireless(struct interface_data *, int, char *,
					  int, struct wireless_state *);
void cardif_linux_rtnetlink_ifla_operstate(struct interface_data *, int, 
					   char *, int, 
					   struct wireless_state *);
void cardif_linux_rtnetlink_check_custom(struct interface_data *, char *);
int cardif_linux_rtnetlink_get_we_ver(struct interface_data *);
uint8_t cardif_linux_rtnetlink_scancheck(struct interface_data *);
void cardif_linux_rtnetlink_set_linkmode(struct interface_data *, uint8_t);
void cardif_linux_rtnetlink_set_operstate(struct interface_data *, uint8_t);
#endif
