/*
 * (C) Copyright 2009 Freescale Semiconductor, Inc.
 *
 * (C) Copyright 2008, Excito Elektronik i Sk=E5ne AB
 *
 * Author: Tor Krill tor@excito.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <usb.h>
#include <asm/io.h>

#include "ehci.h"
#include "ehci-core.h"

#define CONFIG_SYS_A1_USB_UHCI_ADDR	0x90C00000
#define CONFIG_SYS_A1_USB_OTG_ADDR	0x90C08000
#define CONFIG_SYS_A1_USB_EHCI_ADDR	0x90C0C000

/*
 * Create the appropriate control structures to manage
 * a new EHCI host controller.
 */
int ehci_hcd_init(void)
{
	struct usb_ehci *ehci;

	hccr = (struct ehci_hccr *)(0x54000000);
	hcor = (struct ehci_hcor *)CONFIG_SYS_A1_USB_EHCI_ADDR;

	// stop uhci
/* Command register */
#define USBCMD      0
#define   USBCMD_EGSM       0x0008  /* Global Suspend Mode */
#define   USBCMD_CF     	0x0040  /* Config Flag (sw only) */
	writel(USBCMD_EGSM | USBCMD_CF, CONFIG_SYS_A1_USB_UHCI_ADDR +  USBCMD);
	return 0;
}

/*
 * Destroy the appropriate control structures corresponding
 * the the EHCI host controller.
 */
int ehci_hcd_stop(void)
{
	return 0;
}
