#ifndef _hal_mmp2_h_
#define _hal_mmp2_h_

/* C/C++ compilier */
#ifdef __cplusplus
#define EXTERN_C_BEGIN	extern "C" {
#define EXTERN_C_END	}
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif


EXTERN_C_BEGIN

#ifndef USER_TYPE
typedef unsigned char Byte;
typedef unsigned char bool_T;
#define USER_TYPE
#endif

#ifdef TRUE
#undef TRUE
#endif

#ifdef FALSE
#undef FALSE
#endif

#define TRUE		'\001'
#define FALSE		'\000'

/* INLINE */
#if defined (__arm)
	#define INLINE
#elif defined (__GNUC__)
	#define INLINE inline
#endif

/* PACKED_STRUCT */
#if defined(__arm)
	#define PACKED_STRUCT __packed struct
#elif defined(__GNUC__)
	#define PACKED_STRUCT struct __attribute__ ((packed))
#endif

/***********************************************************
 * Define the number of VICs hired. Currently, either 1 VIC
 * or 2 VICs are dropped into the integration.
 ***********************************************************/
#define HAL_VIC_NUM						1

/***********************************************************
 * Define the channel number of DMAP. Currently, either 4
 * or 8 channels configured in each DMAP instance.
 ***********************************************************/
#define HAL_DMAP_CHANNEL_NUM			2 // ACTi A1


/***********************************************************
 * Directives to indicate including or discluding IP drivers.
 ***********************************************************/
#define HAL_INC_SD
#define HAL_INC_WDT
#define HAL_INC_GPIO
#define HAL_INC_TV
//#define HAL_INC_LCD
//#define HAL_INC_DMAM
#define HAL_INC_DMAP

#define HAL_INC_NAND


#define HAL_INC_FLASH

#define HAL_INC_SDC

/* currently, only timer1 is available */
#define HAL_INC_TIMER1
//#define HAL_INC_TIMER2

#define HAL_INC_I2C0
#define HAL_INC_I2C1
#define HAL_INC_I2C2

#define HAL_INC_UART
#define HAL_INC_SSI
#define HAL_INC_I2S

#define HAL_INC_ETH110
		/* ethernet 10/100M bps */
#define HAL_INC_DDR2

//#define HAL_INC_IDE /* Atlas Host Controller */

#define HAL_INC_VIC1_SW1INTR
//#define HAL_INC_VIC1_SW2INTR

/****************************************/
/*       Define the Audio codec         */
/****************************************/
#if defined(HAL_INC_I2S)

	/* choose one of the following codecs used in your system */
	#define HAL_AUDIO_CODEC_UDA1380	0
	#define HAL_AUDIO_CODEC_UDA1345 0
	#define HAL_AUDIO_CODEC_TLV320	1


	/* choose one of following frequencies that your audio daughtor uses */
	//#define HAL_AUDIO_OSC_CLK 12288000
	//#define HAL_AUDIO_OSC_CLK	16934400
	#define HAL_AUDIO_OSC_CLK	24576000

#endif

/*
 * Define LCD panel
 */
/* one of the followings is set as non-zero */
#define PANEL_DATAIMAGE_VGA		1
#define PANEL_SHARP_LCY99073A	0
#define PANEL_CASIO_COM16T1151	0

#if PANEL_DATAIMAGE_VGA
	#define HAL_PANEL_WIDTH		800
	#define HAL_PANEL_HEIGHT	480
#endif

#if PANEL_SHARP_LCY99073A
	#define HAL_PANEL_WIDTH		320
	#define HAL_PANEL_HEIGHT	240
#endif

#if PANEL_CASIO_COM16T1151
	#define HAL_PANEL_WIDTH		120
	#define HAL_PANEL_WIDTH		90
#endif



/*
 * Define VGA device width and height in pixel
 */
#define HAL_VGA_DEV_WIDTH	800
#define HAL_VGA_DEV_HEIGHT	480


/****************************************/
/* Memory Mapping */
/****************************************/
/* EBD_SRAM : embedded SRAM */
#define HAL_EBD_SRAM_BASE			0x20000000
#define HAL_EBD_SRAM_SIZE			0x800			/* 2K bytes */

/* OMB_FLASH : on mother-board flash memory */
#define HAL_OMB_FLASH_BASE		0x40000000
#define HAL_OMB_FLASH_SIZE		0x04000000	/* 64M bytes */

/* DDR2 */
#define HAL_OMB_DDR2_BASE			0x50000000
#define HAL_OMB_DDR2_SIZE			0x03000000


#if 1
extern int TopOfMemory, SizeOfMemory, EndOfCode; /* these variables are defined in sdb_debug.lds/sdb_rom.lds files (for linker0 */
#define HAL_MEMORY_BASE			((unsigned int)&TopOfMemory)
#define HAL_MEMORY_SIZE			((unsigned int)&SizeOfMemory)
#else
#define HAL_MEMORY_BASE			HAL_OMB_DDR2_BASE
#define HAL_MEMORY_SIZE			HAL_OMB_DDR2_SIZE
#endif



/* memory-mapping control registers */
/****************************************************************/
#define HAL_REG_ETH110_BASE				0x90400000
/* SDC/MMC */
#define HAL_REG_SDC_BASE				0x90700000
#define HAL_REG_VIC1_BASE				0x90800000
/* static memory controller */
#define HAL_REG_SMC						0x90a00000
#define HAL_REG_USB20_BASE				0x90c00000
#define HAL_REG_DDR2C_BASE				0x90d00000
#define HAL_REG_AHBC_BASE				0x90000000
#define HAL_REG_NANDC_BASE				0x90500000
#define HAL_REG_DMA_BASE				0x90600000
#define HAL_REG_DMAP_BASE				0x90600000
#define HAL_REG_DMAM_BASE				0x90600000

	/* New memary map for APB devices */
#define HAL_REG_SYS_BASE				0x99000000
#define HAL_REG_POM_BASE				0x99100000
#define HAL_REG_WDT_BASE				0x99400000
#define HAL_REG_I2C0_BASE				0x99500000
#define HAL_REG_I2C1_BASE				0x99600000
#define HAL_REG_I2C2_BASE				0x99700000
#define HAL_REG_GPIO0_BASE				0x99800000
#define HAL_REG_GPIO1_BASE				0x99900000
#define HAL_REG_GPIO2_BASE				0x99A00000
#define HAL_REG_GPIO3_BASE				0x99B00000
#define HAL_REG_GPIO4_BASE				0x99C00000
#define HAL_REG_UART_BASE				0x99D00000		/* for testing */
#define HAL_REG_UART0_BASE				0x99D00000		/* for testing */
#define HAL_REG_UART1_BASE				0x99E00000
#define HAL_REG_UART2_BASE				0x99F00000
#define HAL_REG_UART3_BASE				0x9A000000
#define HAL_REG_UART4_BASE				0x9A100000

#define HAL_REG_SSI_BASE				0x9A200000
#define HAL_REG_ISP_BASE				0x9A300000
/* I2S */
#define HAL_REG_I2S_BASE				0x9A400000
#define HAL_REG_TIMER1_BASE				0x9A500000



#define HAL_REG_GPIO_BASE				HAL_REG_GPIO0_BASE
#define HAL_REG_GPIO_OFFSET				(HAL_REG_GPIO1_BASE - HAL_REG_GPIO0_BASE)

#define HAL_REG_VIC2_BASE				0x90800000


/* FPGA only */
#define FPGA_REG_INTERNAL_APB_BASE		0x33000000
#define FPGA_REG_PLL_CONTROL			0x00000004
#define FPGA_REG_FREQUENCY_DESIGN		0x00000010
/*LM DMAM*/
#define HAL_REG_LM_DMAM_BASE			0x80010000


/* SSI */


/* AC97 */
#define HAL_REG_AC97_BASE				0x32110000
/* TIMER2 */
#define HAL_REG_TIMER2_BASE				0x32160000
/* Pulse Width Modulation */
#define HAL_REG_PWM_BASE				0x32180000


/*
 * Vector Table
 */
extern unsigned int halc_uart_intr;
enum halIntrVector_E
{
	halc_unknown_intr	= 99,

	/* VFE complete interrupt */
	halc_ddr2_intr 		= 0,
	halc_ahbc_intr 		= 1,
	halc_usb20_intr		= 2,
	halc_eth110_intr	= 3,
	halc_dmam_intr		= 4,
	halc_dmap_intr		= 4,
	halc_sdc_intr		= 5,
	halc_nand_intr		= 6,
	halc_vcap_intr		= 7,

	halc_h264enc_intr	= 8,
	halc_h264dec_intr	= 9,
	halc_isp_intr		= 10,
	halc_ssi_intr		= 11,

	halc_uart0_intr		= 12,
	halc_uart1_intr		= 13,
	halc_uart2_intr		= 14,
	halc_uart3_intr		= 15,
	halc_uart4_intr		= 16,


	halc_gpio0_intr		= 17,
	halc_gpio1_intr		= 18,
	halc_gpio2_intr		= 19,
	halc_gpio3_intr		= 20,
	halc_gpio4_intr		= 21,
	halc_i2c0_intr		= 22,
	halc_i2c1_intr		= 23,
	halc_i2c2_intr		= 24,
	halc_i2s_tx_intr	= 25,
	halc_i2s_rx_intr	= 26,
	halc_tm1cnt1_intr	= 27,
	halc_tm1cnt2_intr	= 28,
	halc_tm1cnt3_intr	= 29,
	halc_wdt_intr		= 30,
	halc_lcd_intr		= 31,


	halc_smcc_intr		= 10,
	halc_gpio_intr		= 11,
	halc_lcd_vc			= 16,
	halc_lm_dmam_intr1	= 24,
	halc_vic2_irq		= 25,

	halc_vic2_min_intr_val	= 32,	/* for distinguish VIC1 or VIC2 interrupt */


	halc_sw1_intr		= 32+26,
	/*
	 * VIC2
	 */


#if defined(HAL_INC_SSI)
	halc_ssi1_intr		= 12+32,
#endif

#if defined(HAL_INC_TIMER2)
	halc_tm2cnt1_intr	= 13+32,
	halc_tm2cnt2_intr	= 14+32,
	halc_tm2cnt3_intr	= 15+32,
#endif

#if defined(HAL_INC_LCD)
	halc_lcd_underflow_intr			= 16+32,
	halc_lcd_nextBaseUpdate_intr	= 17+32,
	halc_lcd_AHBMasterError_intr	= 18+32,
#endif

#if defined(HAL_INC_DMAP)
	halc_dmapc1_intr	= 19+32,
	halc_dmapc2_intr	= 20+32,
	halc_dmapc3_intr	= 21+32,
	halc_dmapc4_intr	= 22+32,
	halc_dmapc5_intr	= 23+32,
	halc_dmapc6_intr	= 24+32,
	halc_dmapc7_intr	= 25+32,
	halc_dmapc8_intr	= 26+32,
	halc_dmaperr_intr	= 27+32,
#endif


	halc_dummy_intr	= 100
};



EXTERN_C_END

#endif

