#include "sys.h"
#include "dosFS.h"
#include "dosFSi.h"


void dosL2LEncodeBuf_i(unsigned char *pBuf,
		unsigned int nBufSize, unsigned int nNum)
{
/*
		int -----------> char[]
	little endian	   little endian
*/
	int i;

	if (nBufSize > 4 || nBufSize == 0)
		return;

	for (i = 0; i < nBufSize; ++i)
		pBuf[i] = (unsigned char) ((nNum >> (8 * i)) & 0xFF);
}

void dosL2LDecodeBuf_i(unsigned char *pBuf,
		unsigned int nBufSize, unsigned int *pnNum)
{
/*
		char[] -----------> int
	little endian	   little endian
*/
	int i;

	if (nBufSize > 4 || nBufSize == 0)
		return;

	*pnNum = 0;
	for (i = nBufSize-1; i >= 0; --i)
		*pnNum = ((*pnNum) << 8) + pBuf[i];
}

void dosB2LEncodeBuf_i(unsigned char *pBuf,
		unsigned int nBufSize, unsigned int nNum)
{
/*
		int -----------> char[]
	  big endian	   little endian
*/
}

void dosL2BDecodeBuf_i(unsigned char *pBuf,
		unsigned int nBufSize, unsigned int *pnNum)
{
/*
		char[] -----------> int
	little endian	      big endian
*/
}


/****************************************************/
dosBufEncode_FT dosvEncodeBufRoutine_g;
dosBufDecode_FT dosvDecodeBufRoutine_g;
bool_T dosvIsLittleEndianMachine_g;

bool_T dosGVarsInit_i(void)
{
	if (sysIsLittleEndian())
	{
		dosvIsLittleEndianMachine_g = TRUE;

		dosvEncodeBufRoutine_g = dosL2LEncodeBuf_i;
		dosvDecodeBufRoutine_g = dosL2LDecodeBuf_i;
	}
	else
	{
		dosvIsLittleEndianMachine_g = FALSE;

		dosvEncodeBufRoutine_g = dosB2LEncodeBuf_i;
		dosvDecodeBufRoutine_g = dosL2BDecodeBuf_i;
	}

	return (TRUE);
}
/****************************************************/

