//#include <string.h>

#include "sys.h"
#include "dosFS.h"
#include "dosFSi.h"

static
dosMediaFormat_E dosReadMediaBSInFAT_ii(dosBS_Id pBS, unsigned char *pBuf)
{
	/* try to read in FAT12/16 */

	char *pC;
	unsigned int nNum;


	pBS->bMBS = FALSE;
	goto LLL_SCAN_PBS;

LLL_SCAN_MBS:
	if (pBS->bMBS)
	{
		return (doscMediaUnformatted);
	}

	pBS->bMBS = TRUE;

	dosvDecodeBufRoutine_g(pBuf+0x1BE, 1, &nNum);
	pBS->mbs.p1BootId = (unsigned char) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x1BF, 1, &nNum);
	pBS->mbs.p1StartHeadNum = (unsigned char) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x1C0, 1, &nNum);
	pBS->mbs.p1StartSectorNum = (unsigned char) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x1C1, 1, &nNum);
	pBS->mbs.p1StartCylinderNum = (unsigned char) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x1C2, 1, &nNum);
	pBS->mbs.p1SystemId = (unsigned char) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x1C3, 1, &nNum);
	pBS->mbs.p1EndHeadNum = (unsigned char) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x1C4, 1, &nNum);
	pBS->mbs.p1EndSectorNum = (unsigned char) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x1C5, 1, &nNum);
	pBS->mbs.p1EndCylinderNum = (unsigned char) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x1C6, 4, &nNum);
	pBS->mbs.p1StartLogSectorNum = (unsigned int) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x1CA, 4, &nNum);
	pBS->mbs.p1Size = (unsigned int) nNum;


	/* read the partition-1 boot sector */	
	if (!pBS->io.readNSector(pBS->mbs.p1StartLogSectorNum, 1, pBuf))
	{
		return (doscMediaUnformatted);
	}

LLL_SCAN_PBS:
	/* decode the fixed data (signature) first */
	pBS->p1bs.fixedData[0] = *(pBuf+0x1FE);
	pBS->p1bs.fixedData[1] = *(pBuf+0x1FF);
	if (pBS->p1bs.fixedData[0] != 0x55 || pBS->p1bs.fixedData[1] != 0xAA)
	{
		return (doscMediaUnformatted);
	}


	pBS->p1bs.jumpCmd[0] = pBuf[0];
	pBS->p1bs.jumpCmd[1] = pBuf[1];
	pBS->p1bs.jumpCmd[2] = pBuf[2];
	pBS->p1bs.manufacture[0] = pBuf[3];
	pBS->p1bs.manufacture[1] = pBuf[4];
	pBS->p1bs.manufacture[2] = pBuf[5];
	pBS->p1bs.manufacture[3] = pBuf[6];
	pBS->p1bs.manufacture[4] = pBuf[7];
	pBS->p1bs.manufacture[5] = pBuf[8];
	pBS->p1bs.manufacture[6] = pBuf[9];
	pBS->p1bs.manufacture[7] = pBuf[10];

	dosvDecodeBufRoutine_g(pBuf+0x00B, 2, &nNum);
	pBS->p1bs.bytesPerSector = (unsigned short) nNum;
	if (nNum != DOS_BYTES_PER_SEC)
		goto LLL_SCAN_MBS;

	dosvDecodeBufRoutine_g(pBuf+0x00D, 1, &nNum);
	pBS->p1bs.sectorsPerCluster = (unsigned char) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x00E, 2, &nNum);
	pBS->p1bs.numReservedSectors = (unsigned short) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x010, 1, &nNum);
	pBS->p1bs.numFATs = (unsigned char) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x011, 2, &nNum);
	pBS->p1bs.numEntriesInRD = (unsigned short) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x013, 2, &nNum);
	pBS->p1bs.numSectorsInVolume = (unsigned short) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x015, 1, &nNum);
	pBS->p1bs.mediaDescriptor = (unsigned char) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x016, 2, &nNum);
	pBS->p1bs.sectorsPerFAT = (unsigned short) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x018, 2, &nNum);
	pBS->p1bs.sectorsPerTrack = (unsigned short) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x01A, 2, &nNum);
	pBS->p1bs.numRWHeads = (unsigned short) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x01C, 4, &nNum);
	pBS->p1bs.numHiddenSectors = (unsigned int) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x020, 4, &nNum);
	pBS->p1bs.nNumPartSecs = (unsigned int) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x024, 1, &nNum);
	pBS->p1bs.nPhyDriveNum = (unsigned char) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x025, 1, &nNum);
	pBS->p1bs.reserved_1 = (unsigned char) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x026, 1, &nNum);
	pBS->p1bs.extBootRecSignature = (unsigned char) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x027, 4, &nNum);
	pBS->p1bs.volumeId = (unsigned int) nNum;

	pBS->p1bs.volumeLabel[0] = pBuf[0x02B];
	pBS->p1bs.volumeLabel[1] = pBuf[0x02C];
	pBS->p1bs.volumeLabel[2] = pBuf[0x02D];
	pBS->p1bs.volumeLabel[3] = pBuf[0x02E];
	pBS->p1bs.volumeLabel[4] = pBuf[0x02F];
	pBS->p1bs.volumeLabel[5] = pBuf[0x030];
	pBS->p1bs.volumeLabel[6] = pBuf[0x031];
	pBS->p1bs.volumeLabel[7] = pBuf[0x032];
	pBS->p1bs.volumeLabel[8] = pBuf[0x033];
	pBS->p1bs.volumeLabel[9] = pBuf[0x034];
	pBS->p1bs.volumeLabel[10]= pBuf[0x035];

	pBS->p1bs.fileSystemType[0] = pBuf[0x036];
	pBS->p1bs.fileSystemType[1] = pBuf[0x037];
	pBS->p1bs.fileSystemType[2] = pBuf[0x038];
	pBS->p1bs.fileSystemType[3] = pBuf[0x039];
	pBS->p1bs.fileSystemType[4] = pBuf[0x03A];
	pBS->p1bs.fileSystemType[5] = pBuf[0x03B];
	pBS->p1bs.fileSystemType[6] = pBuf[0x03C];
	pBS->p1bs.fileSystemType[7] = pBuf[0x03D];

	/* derived information */
	pC = pBS->p1bs.fileSystemType;
	if ((pC[0] == 'F' || pC[0] == 'f') &&
		(pC[1] == 'A' || pC[1] == 'a') &&
		(pC[2] == 'T' || pC[2] == 't'))
	{
		/* support FAT12 and FAT16 only */

		if (pC[3] == '1' && pC[4] == '2')
			pBS->p1bs.fatSystem = DOS_FAT_BITS_12;
		else if (pC[3] == '1' && pC[4] == '6')
			pBS->p1bs.fatSystem = DOS_FAT_BITS_16;
		else
		{
			return (doscMediaUnformatted);
		}
	}
	else
	{
		return (doscMediaUnformatted);
	}

	pBS->p1bs.bytesPerCluster = pBS->p1bs.sectorsPerCluster * DOS_BYTES_PER_SEC;

	pBS->p1bs.nFATStartSector = pBS->p1bs.numReservedSectors;
	if (pBS->bMBS)
		pBS->p1bs.nFATStartSector += pBS->mbs.p1StartLogSectorNum;

	pBS->p1bs.nRDStartSector16 = pBS->p1bs.nFATStartSector +
								pBS->p1bs.numFATs * pBS->p1bs.sectorsPerFAT;
	pBS->p1bs.nDataStartSector = pBS->p1bs.nRDStartSector16 +
				pBS->p1bs.numEntriesInRD/(DOS_BYTES_PER_SEC/DOS_DIR_ENTRY_SIZE);
	

	if (pBS->p1bs.fatSystem == DOS_FAT_BITS_12)
	{
		pBS->p1bs.numLogEntriesPerFAT =
			(pBS->p1bs.sectorsPerFAT * DOS_BYTES_PER_SEC * 8)/12;
	}
	else
	{
		pBS->p1bs.numLogEntriesPerFAT =
			pBS->p1bs.sectorsPerFAT * DOS_BYTES_PER_SEC/2;
	}

	//nNum = dosGetMediaSize_i(nMdHandle);
	nNum = pBS->io.getCapacity();
	pBS->p1bs.numPhyEntriesPerFAT = (nNum - 512 * pBS->p1bs.nDataStartSector)
												/
									pBS->p1bs.bytesPerCluster;
	pBS->bValid = TRUE;

#if 0
		halUARTPrintf("Printf device information--\n\r");
		halUARTPrintf("\tsectorsPerCluster = %d\n\r", pBS->p1bs.sectorsPerCluster);
		halUARTPrintf("\tnumReservedSectors = %d\n\r", pBS->p1bs.numReservedSectors);
		halUARTPrintf("\tnumFATs = %d\n\r", pBS->p1bs.numFATs);
		halUARTPrintf("\tnumEntriesInRD = %d\n\r", pBS->p1bs.numEntriesInRD);
		halUARTPrintf("\tnumSectorsInVolume = %d\n\r", pBS->p1bs.numSectorsInVolume);
		halUARTPrintf("\tnumEntriesInRD = %d\n\r", pBS->p1bs.mediaDescriptor);
		halUARTPrintf("\tsectorsPerFAT = %d\n\r", pBS->p1bs.sectorsPerFAT);
		halUARTPrintf("\tsectorsPerTrack = %d\n\r", pBS->p1bs.sectorsPerTrack);
		halUARTPrintf("\tnumRWHeads = %d\n\r", pBS->p1bs.numRWHeads);
		halUARTPrintf("\tnumHiddenSectors = %d\n\r", pBS->p1bs.numHiddenSectors);
		halUARTPrintf("\tnNumPartSecs = %d\n\r", pBS->p1bs.nNumPartSecs);
		halUARTPrintf("\tnPhyDriveNum = %d\n\r", pBS->p1bs.nPhyDriveNum);
		halUARTPrintf("\textBootRecSignature = %d\n\r", pBS->p1bs.extBootRecSignature);
		halUARTPrintf("\tvolumeId = %08Xn\r", pBS->p1bs.volumeId);

		int i;
		halUARTPrintf("\tvolumeLabel = ");
		for(i = 0; i <= 10; i++)
			halUARTPrintf("%c",  pBS->p1bs.volumeLabel[i]);
		halUARTPrintf("\n\r");

		halUARTPrintf("\tfileSystemType = ");
		for(i = 0; i <= 7; i++)
			halUARTPrintf("%c",  pBS->p1bs.fileSystemType[i]);
		halUARTPrintf("\n\r");

		halUARTPrintf("\tbytesPerCluster = %d\n\r", pBS->p1bs.bytesPerCluster);
		halUARTPrintf("\tnFATStartSector = %d\n\r", pBS->p1bs.nFATStartSector);
		halUARTPrintf("\tnDataStartSector = %d\n\r", pBS->p1bs.nDataStartSector);
		halUARTPrintf("\tnRDStartSector16 = %d\n\r", pBS->p1bs.nRDStartSector16);
		halUARTPrintf("\tnumLogEntriesPerFAT = %d\n\r", pBS->p1bs.numLogEntriesPerFAT);
		halUARTPrintf("\tnumPhyEntriesPerFAT = %d\n\r", pBS->p1bs.numPhyEntriesPerFAT);
	#endif

	/* read one sector of FAT into the FAT cache */
	pBS->p1bs.FATCache.isDirty = FALSE;
	pBS->p1bs.FATCache.nFATSector = 0;
	if (pBS->io.readNSector(pBS->p1bs.nFATStartSector, 1, pBS->p1bs.FATCache.cacheBuf))
	{
		pBS->p1bs.FATCache.isValid = TRUE;
	}
	else
	{
		pBS->p1bs.FATCache.isValid = FALSE;
	}
	return (doscMediaFormatted);
}

static
dosMediaFormat_E dosReadMediaBSInFAT32_ii(dosBS_Id pBS, unsigned char *pBuf)
{
	/* try to read in FAT32 */

	unsigned int nNum;
	char *pC;

	pBS->bMBS = FALSE; /* suppose there is no master boot sector always */

	/* decode the fixed data (signature) first */
	pBS->p1bs.fixedData[0] = *(pBuf+0x1FE);
	pBS->p1bs.fixedData[1] = *(pBuf+0x1FF);
	if (pBS->p1bs.fixedData[0] != 0x55 || pBS->p1bs.fixedData[1] != 0xAA)
	{
		return (doscMediaUnformatted);
	}


	/* file system */
	pBS->p1bs.fileSystemType[0] = pBuf[0x052];
	pBS->p1bs.fileSystemType[1] = pBuf[0x053];
	pBS->p1bs.fileSystemType[2] = pBuf[0x054];
	pBS->p1bs.fileSystemType[3] = pBuf[0x055];
	pBS->p1bs.fileSystemType[4] = pBuf[0x056];
	pBS->p1bs.fileSystemType[5] = pBuf[0x057];
	pBS->p1bs.fileSystemType[6] = pBuf[0x058];
	pBS->p1bs.fileSystemType[7] = pBuf[0x059];

	pC = (char *) pBS->p1bs.fileSystemType;
	if ((pC[0] == 'F' || pC[0] == 'f') &&
		(pC[1] == 'A' || pC[1] == 'a') &&
		(pC[2] == 'T' || pC[2] == 't') &&
		(pC[3] == '3') &&
		(pC[4] == '2'))
	{
		pBS->p1bs.fatSystem = DOS_FAT_BITS_32;
	}
	else
	{
		return (doscMediaUnformatted);
	}


	pBS->p1bs.jumpCmd[0] = pBuf[0];
	pBS->p1bs.jumpCmd[1] = pBuf[1];
	pBS->p1bs.jumpCmd[2] = pBuf[2];
	pBS->p1bs.manufacture[0] = pBuf[3];
	pBS->p1bs.manufacture[1] = pBuf[4];
	pBS->p1bs.manufacture[2] = pBuf[5];
	pBS->p1bs.manufacture[3] = pBuf[6];
	pBS->p1bs.manufacture[4] = pBuf[7];
	pBS->p1bs.manufacture[5] = pBuf[8];
	pBS->p1bs.manufacture[6] = pBuf[9];
	pBS->p1bs.manufacture[7] = pBuf[10];

	dosvDecodeBufRoutine_g(pBuf+0x00B, 2, &nNum);
	pBS->p1bs.bytesPerSector = (unsigned short) nNum;
	if (nNum != DOS_BYTES_PER_SEC)
		return (doscMediaUnformatted);

	dosvDecodeBufRoutine_g(pBuf+0x00D, 1, &nNum);
	pBS->p1bs.sectorsPerCluster = (unsigned char) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x00E, 2, &nNum);
	pBS->p1bs.numReservedSectors = (unsigned short) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x010, 1, &nNum);
	pBS->p1bs.numFATs = (unsigned char) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x011, 2, &nNum);
	if (nNum != 0)
		return (doscMediaUnformatted);

	dosvDecodeBufRoutine_g(pBuf+0x013, 2, &nNum);
	if (nNum != 0)
		return (doscMediaUnformatted);

	dosvDecodeBufRoutine_g(pBuf+0x015, 1, &nNum);
	pBS->p1bs.mediaDescriptor = (unsigned char) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x016, 2, &nNum);
	if (nNum != 0)
		return (doscMediaUnformatted);

	dosvDecodeBufRoutine_g(pBuf+0x018, 2, &nNum);
	pBS->p1bs.sectorsPerTrack = (unsigned short) nNum;
	
	dosvDecodeBufRoutine_g(pBuf+0x01A, 2, &nNum);
	pBS->p1bs.numRWHeads = (unsigned short) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x01C, 4, &nNum);
	pBS->p1bs.numHiddenSectors = (unsigned int) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x020, 4, &nNum);
	pBS->p1bs.nNumPartSecs = (unsigned int) nNum;

	dosvDecodeBufRoutine_g(pBuf+0x024, 4, &nNum);
	pBS->p1bs.sectorsPerFAT = (unsigned int) nNum;


	/* TODO : read other information here */



	/* derived information! */

	pBS->p1bs.fatSystem = DOS_FAT_BITS_32;

	pBS->p1bs.bytesPerCluster = pBS->p1bs.sectorsPerCluster * DOS_BYTES_PER_SEC;

	pBS->p1bs.nFATStartSector = pBS->p1bs.numReservedSectors;

	dosvDecodeBufRoutine_g(pBuf+0x02C, 4, &nNum);
	pBS->p1bs.nRDStartSector16 = 0; /* not used in FAT32 */
	pBS->p1bs.nRDStartCluster32 = nNum;;

	pBS->p1bs.nDataStartSector = pBS->p1bs.nFATStartSector +
						pBS->p1bs.numFATs * pBS->p1bs.sectorsPerFAT;


	pBS->p1bs.numLogEntriesPerFAT = pBS->p1bs.sectorsPerFAT * DOS_BYTES_PER_SEC/4;

	nNum = pBS->io.getCapacity();
	pBS->p1bs.numPhyEntriesPerFAT = (nNum - 512 * pBS->p1bs.nDataStartSector)
												/
									pBS->p1bs.bytesPerCluster;

	pBS->bValid = TRUE;


	/* read one sector of FAT into the FAT cache */
	pBS->p1bs.FATCache.isDirty = FALSE;
	pBS->p1bs.FATCache.nFATSector = 0;
	if (pBS->io.readNSector(pBS->p1bs.nFATStartSector, 1, pBS->p1bs.FATCache.cacheBuf))
	{
		pBS->p1bs.FATCache.isValid = TRUE;
	}
	else
	{
		pBS->p1bs.FATCache.isValid = FALSE;
	}

	return (doscMediaFormatted);
}

dosMediaFormat_E dosReadMediaBootSector_i(dosBS_Id pBS)
{
	unsigned char pBuf[DOS_BYTES_PER_SEC];


	/* read the master boot sector */
	if (!pBS->io.readNSector(0, 1, pBuf))
	{
		return (doscMediaUnformatted);
	}


	/* decode the fixed data (signature) first */
	pBS->mbs.fixedData[0] = *(pBuf+0x1FE);
	pBS->mbs.fixedData[1] = *(pBuf+0x1FF);
	if (pBS->mbs.fixedData[0] != 0x55 || pBS->mbs.fixedData[1] != 0xAA)
	{
		return (doscMediaUnformatted);
	}


	if (doscMediaFormatted == dosReadMediaBSInFAT_ii(pBS, pBuf))
		return (doscMediaFormatted);


	if (doscMediaFormatted == dosReadMediaBSInFAT32_ii(pBS, pBuf))
		return (doscMediaFormatted);


	return (doscMediaUnformatted);
}

int dosTranClusterToAbsSector_i(dosBS_S *pBS, int nCluster)
{
	return (pBS->p1bs.nDataStartSector + (nCluster-2)*pBS->p1bs.sectorsPerCluster);
}

int dosTranAbsSectorToCluster_i(dosBS_S *pBS, int nSector)
{
	return ((nSector - pBS->p1bs.nDataStartSector)/pBS->p1bs.sectorsPerCluster + 2);
}

/*

Relationship between read/write buffer, cache, and media card.

  
 	                                           =====  <-- nCluster
	                                             |       (nClusterSector)
	               pBS->nStartSector             | 
	                        |                    |
	   pBuf --> ===         |                  =====  <-- nOffset
	            /.          |     Cache          |\
	           / .          +--->  === --------- | \
       nAccSize  .                  |            |  \
	           \ . <----+-----------|----------- |   \
	            \.      |           |            |    \
	             x <-+--|-----------. <--+------ |     \
	             x   |  |           .    |       |      \
	             x   |  |           .    |       |       \
	             x   |  |          ===   |       |        \
	             x   |  |                |       |         \
	             x   |  nCurSector     nOff      |          > nBytes
	             x   |                           |         /
	             x  nCurOffset                   |        /
	             x                               |       /
	             x                               |      /
	             x                               |     /
	             x                               |    /
	             x                               |   /
	             x                               |  /
	             x                               | /
	             x                               |/
	            ===                            =====  
*/

bool_T dosReadDOSDAClusterNByte_i(
				dosBS_Id pBS,
				dosDataCache_S *pCache,
				unsigned int nCluster,
				unsigned int nOffset,
				unsigned int nBytes,
				unsigned char *pBuf)
{
	int nClusterSector;	/* the beginning sector number of the cluster */
	int nAccSize;	/* accumulated size read */
	int nCurSector;
	int nCurOffset;
	int nOff;

	int nReadThisRound;


	nClusterSector = dosTranClusterToAbsSector_i(pBS, nCluster);

	for (nAccSize = 0; nAccSize < nBytes; )
	{
		nCurSector = nClusterSector + (nOffset+nAccSize)/DOS_BYTES_PER_SEC;
		nCurOffset = (nOffset+nAccSize)%DOS_BYTES_PER_SEC;

#if 1
		if (pCache->isValid && pCache->isDirty)
		{
			if (nCurSector < pCache->nStartSector || 
				nCurSector >= pCache->nStartSector + DOS_CACHE_SIZE_SECTORS)
			{
				pBS->io.writeNSector(pCache->nStartSector, DOS_CACHE_SIZE_SECTORS, pCache->cacheBuf);
				pCache->isDirty = FALSE;
			}
		}


		/* the pCahce is not dirty now */


		if (pCache->isValid)
		{
			if (nCurSector < pCache->nStartSector || 
				nCurSector >= pCache->nStartSector + DOS_CACHE_SIZE_SECTORS)
			{
				/* miss! the wanted data isn't in current cache */
				goto LLL_CACHE_INVALID;
			}
			else
			{
				/* hit! the wanted data is in the current cache */

				nOff = nCurOffset + (nCurSector-pCache->nStartSector)*DOS_BYTES_PER_SEC;

				nReadThisRound = nBytes - nAccSize;
				nReadThisRound = (nReadThisRound < DOS_DATA_CACHE_SIZE - nOff) ?
						  		  nReadThisRound : DOS_DATA_CACHE_SIZE - nOff;

				memcpy(pBuf+nAccSize, pCache->cacheBuf+nOff, nReadThisRound);

				nAccSize += nReadThisRound;
			}
		}
		else
		{
LLL_CACHE_INVALID:
			nOff = nCurOffset;
			if (nOff == 0)
			{
				nReadThisRound = nBytes - nAccSize;
				nReadThisRound = (nReadThisRound < DOS_DATA_CACHE_SIZE) ?
						  		  nReadThisRound : DOS_DATA_CACHE_SIZE;

				if (nReadThisRound == DOS_DATA_CACHE_SIZE)
				{
					pBS->io.readNSector(nCurSector, DOS_CACHE_SIZE_SECTORS, pBuf+nAccSize);
						/* into pBuf */

					nAccSize += DOS_DATA_CACHE_SIZE;
					continue;
				}
			}

			pBS->io.readNSector(nCurSector, DOS_CACHE_SIZE_SECTORS, pCache->cacheBuf); /* into cache */
			pCache->nStartSector = nCurSector;
			pCache->isValid = TRUE;
			pCache->isDirty = FALSE;

			nReadThisRound = nBytes - nAccSize;
			nReadThisRound = (nReadThisRound < DOS_DATA_CACHE_SIZE - nOff) ?
							  nReadThisRound : DOS_DATA_CACHE_SIZE - nOff;

			memcpy(pBuf+nAccSize, pCache->cacheBuf+nOff, nReadThisRound);
			nAccSize += nReadThisRound;
		}


#else
		if (pCache->isValid && pCache->isDirty)
		{
			if (nCurSector < pCache->nStartSector || 
				nCurSector >= pCache->nStartSector + DOS_CACHE_SIZE_SECTORS)
			{
				pBS->io.writeNSector(pCache->nStartSector, DOS_CACHE_SIZE_SECTORS, pCache->cacheBuf);

				pBS->io.readNSector(nCurSector, DOS_CACHE_SIZE_SECTORS, pCache->cacheBuf);
				pCache->nStartSector = nCurSector;
				pCache->isValid = TRUE;
				pCache->isDirty = FALSE;
			}
		}

		if (!pCache->isValid || nCurSector < pCache->nStartSector ||
			nCurSector >= pCache->nStartSector + DOS_CACHE_SIZE_SECTORS)
		{
			/* need to update the cache */

			if (!pBS->io.readNSector(nCurSector, DOS_CACHE_SIZE_SECTORS, pCache->cacheBuf))
			{
				pCache->isValid = FALSE;
				return (FALSE);
			}

			pCache->nStartSector = nCurSector;
			pCache->isDirty = FALSE;
			pCache->isValid = TRUE;
		}

		nOff = nCurOffset + (nCurSector - pCache->nStartSector)*DOS_BYTES_PER_SEC;

		nReadThisRound = nBytes - nAccSize;
		nReadThisRound = (nReadThisRound < DOS_DATA_CACHE_SIZE - nOff) ?
						  nReadThisRound : DOS_DATA_CACHE_SIZE - nOff;

		memcpy(pBuf+nAccSize, pCache->cacheBuf+nOff, nReadThisRound);

		nAccSize += nReadThisRound;
#endif
	}

	return (TRUE);
}

void dosFlushCache_i(dosBS_Id pBS, dosDataCache_S *pCache)
{
	if (pCache->isValid && pCache->isDirty)
	{
		pBS->io.writeNSector(pCache->nStartSector, DOS_CACHE_SIZE_SECTORS, pCache->cacheBuf);
		pCache->isDirty = FALSE;
	}
}

bool_T dosWriteDOSDAClusterNByte_i(
				dosBS_Id pBS,
				dosDataCache_S *pCache,
				unsigned int nCluster,
				unsigned int nOffset,
				unsigned int nBytes,
				unsigned char *pBuf)
{
	int nClusterSector;	/* the beginning sector number of the cluster */
	int nAccSize;	/* accumulated size read */
	int nCurSector;
	int nCurOffset;
	int nOff;

	int nWriteThisRound;

	nClusterSector = dosTranClusterToAbsSector_i(pBS, nCluster);

	for (nAccSize = 0; nAccSize < nBytes; )
	{
		nCurSector = nClusterSector + (nOffset+nAccSize)/DOS_BYTES_PER_SEC;
		nCurOffset = (nOffset+nAccSize)%DOS_BYTES_PER_SEC;


		if (pCache->isValid && pCache->isDirty &&
			(nCurSector < pCache->nStartSector ||
			nCurSector >= pCache->nStartSector + DOS_CACHE_SIZE_SECTORS))
		{
			pBS->io.writeNSector(pCache->nStartSector, DOS_CACHE_SIZE_SECTORS, pCache->cacheBuf);
			//halUARTPrintf("debug 1----------cachebuf=0x%08x\n\r", pCache->cacheBuf);
				/* write data from cache to the media card */

			pCache->isValid = TRUE;
			pCache->isDirty = FALSE;
		}



		/*
		 * pCache is writable now. Note that pCache->isDirty is FALSE now!
		 */


		if (pCache->isValid && nCurSector >= pCache->nStartSector &&
			nCurSector < pCache->nStartSector + DOS_CACHE_SIZE_SECTORS)
		{
			/*
			 * the "write position" overlaps cache buffer
			 */

			if (nCurOffset == 0 && nBytes - nAccSize == pBS->p1bs.bytesPerCluster)
			{
				pBS->io.writeNSector(nCurSector, pBS->p1bs.sectorsPerCluster, pBuf);
				//halUARTPrintf("debug 2----------pBuf=0x%08x\n\r", pBuf);
			
				pCache->isValid = FALSE; /* <-- note, this should be false */
				pCache->isDirty = FALSE;

				nAccSize += pBS->p1bs.bytesPerCluster;
			}
			else
			{
				nOff = nCurOffset + (nCurSector - pCache->nStartSector)*DOS_BYTES_PER_SEC;
		    
				nWriteThisRound = nBytes - nAccSize;
				nWriteThisRound = (nWriteThisRound < DOS_DATA_CACHE_SIZE - nOff) ?
								   nWriteThisRound : DOS_DATA_CACHE_SIZE - nOff;
		    
				memcpy(pCache->cacheBuf+nOff, pBuf+nAccSize, nWriteThisRound);
		    
				nAccSize += nWriteThisRound;
		    
				pCache->isDirty = TRUE;
			}
		}
		else
		{
			/*
			 * the "write position" doesn't overlap cache buffer
			 */

			if (nCurOffset == 0 && nBytes - nAccSize == pBS->p1bs.bytesPerCluster)
			{
				pBS->io.writeNSector(nCurSector, pBS->p1bs.sectorsPerCluster, pBuf);
				nAccSize += pBS->p1bs.bytesPerCluster;
			}
			else
			{
				pCache->nStartSector = nCurSector;
				nOff = nCurOffset;
                
				nWriteThisRound = nBytes - nAccSize;
				nWriteThisRound = (nWriteThisRound < DOS_DATA_CACHE_SIZE - nOff) ?
								   nWriteThisRound : DOS_DATA_CACHE_SIZE - nOff;
                
				if (nOff == 0 && nWriteThisRound == DOS_DATA_CACHE_SIZE)
				{
					/* we don't need to read from the card ; write from buffer to the card directly */
                
					pBS->io.writeNSector(nCurSector, DOS_CACHE_SIZE_SECTORS, pBuf+nAccSize);
					//halUARTPrintf("debug 3----------pBuf=0x%08x\n\r", pBuf+nAccSize);

				
					pCache->isValid = FALSE;
					pCache->isDirty = FALSE;
				}
				else
				{
					/* read data from the card to the cache first; write buffer to cache next */
                
					pBS->io.readNSector(nCurSector, DOS_CACHE_SIZE_SECTORS, pCache->cacheBuf);
					memcpy(pCache->cacheBuf+nOff, pBuf+nAccSize, nWriteThisRound);
                
					pCache->isValid = TRUE;
					pCache->isDirty = TRUE;
				}
                
				nAccSize += nWriteThisRound;
			}
		}
	}

	return (TRUE);
}

bool_T dosWriteDOSDAClusterNByte_Flush_i(
				dosBS_Id pBS,
				dosDataCache_S *pCache,
				unsigned int nCluster,
				unsigned int nOffset,
				unsigned int nBytes,
				unsigned char *pBuf)
{
	dosWriteDOSDAClusterNByte_i(pBS, pCache,
		nCluster, nOffset, nBytes, pBuf);

	dosFlushCache_i(pBS, pCache);

	return (TRUE);
}

void dosWriteDOSDAClusterBlank_i(dosBS_Id pBS, unsigned int nCluster)
{
	int nClusterSector, i;


	nClusterSector = dosTranClusterToAbsSector_i(pBS, nCluster);

	for (i = 0; i < pBS->p1bs.sectorsPerCluster; ++i)
		dosWriteMediaSectorBlank_i(pBS, nClusterSector+i);
}

bool_T dosWriteMediaFATSector_i(dosBS_Id pBS, unsigned int nSector)
{
	/* NOTE: the FAT cache is controlled by this function's caller;
		in the "dosFAT.c layer" */

	pBS->io.writeNSector(nSector, 1, pBS->p1bs.FATCache.cacheBuf);
	return (TRUE);
}

bool_T dosReadMediaFATSector_i(dosBS_Id pBS, unsigned int nSector)
{
	/* NOTE: the FAT cache is controlled by this function's caller;
		in the "dosFAT.c layer" */

	pBS->io.readNSector(nSector, 1, pBS->p1bs.FATCache.cacheBuf);
	return (TRUE);
}

bool_T dosWriteMediaSectorNByte_i(
				dosBS_Id pBS,
				unsigned int nSector,
				unsigned int nOffset,
				unsigned int nSize,
				unsigned char *pBuf)
{
#if 1
	int nOff;
	dosDataCache_S *pCache;

	pCache = &(pBS->DataCache);

	sysDAssert(nSize <= 512 && nOffset < 512 && nSize+nOffset <= 512);

	if (pCache->isValid && nSector >= pCache->nStartSector &&
		nSector < (pCache->nStartSector + DOS_CACHE_SIZE_SECTORS))
	{
		nOff = (nSector - pCache->nStartSector) * 512 + nOffset;
		memcpy(pCache->cacheBuf + nOff, pBuf, nSize);

		pCache->isDirty = TRUE;
	}
	else
	{
		//flush out
		dosFlushCache_i(pBS, pCache);

		//read new into cache
		pBS->io.writeNSector(nSector, DOS_CACHE_SIZE_SECTORS, pCache->cacheBuf);

		//write
		memcpy(pCache->cacheBuf + nOffset, pBuf, nSize);

		pCache->nStartSector = nSector;
		pCache->isValid = TRUE;
		pCache->isDirty = TRUE;
	}

	return (TRUE);


#else
	int pBuf2[DOS_BYTES_PER_SEC/sizeof(int)];

	if (nOffset == 0 && nSize == DOS_BYTES_PER_SEC)
	{
		if ((int) pBuf % 4 == 0)
		{
			pBS->io.writeNSector(nSector, 1, pBuf);
		}
		else
		{
			memcpy(pBuf2, pBuf, DOS_BYTES_PER_SEC);
			pBS->io.writeNSector(nSector, 1, pBuf2);
		}
	}
	else
	{
		unsigned char *pBuf22; /* pointer to pBuf2 to ease programming */

		pBuf22 = (unsigned char *) pBuf2;

		pBS->io.readNSector(nSector, 1, pBuf22);
		memcpy(pBuf22+nOffset, pBuf, nSize);
		pBS->io.writeNSector(nSector, 1, pBuf22);
	}

	return (TRUE);
#endif
}

bool_T dosReadMediaSectorNByte_i(
				dosBS_Id pBS,
				unsigned int nSector,
				unsigned int nOffset,
				unsigned int nSize,
				unsigned char *pBuf)
{
#if 1
	int nOff;
	dosDataCache_S *pCache;

	pCache = &(pBS->DataCache);

	sysDAssert(nSize <= 512 && nOffset < 512 && nSize+nOffset <= 512);

	if (pCache->isValid && nSector >= pCache->nStartSector &&
		nSector < (pCache->nStartSector + DOS_CACHE_SIZE_SECTORS))
	{
		nOff = (nSector - pCache->nStartSector) * 512 + nOffset;
		memcpy(pBuf, pCache->cacheBuf + nOff, nSize);
	}
	else
	{
		//flush out
		dosFlushCache_i(pBS, pCache);

		//read new into cache
		pBS->io.readNSector(nSector, DOS_CACHE_SIZE_SECTORS, pCache->cacheBuf);
		pCache->nStartSector = nSector;
		pCache->isValid = TRUE;
		pCache->isDirty = FALSE;

		memcpy(pBuf, pCache->cacheBuf + nOffset, nSize);
	}

	return (TRUE);

#else
	if (nOffset == 0 && nSize == DOS_BYTES_PER_SEC && (int) pBuf % 4 == 0)
	{
		pBS->io.readNSector(nSector, 1, pBuf);
	}
	else
	{
		int pBuf2[DOS_BYTES_PER_SEC/sizeof(int)];
		unsigned char *pBuf22; /* pointer to pBuf2 to ease programming */

		pBuf22 = (unsigned char *) pBuf2;

		pBS->io.readNSector(nSector, 1, pBuf22);
		memcpy(pBuf, pBuf22+nOffset, nSize);
	}

	return (TRUE);
#endif
}

bool_T dosWriteMediaSectorBlank_i(
				dosBS_Id pBS,
				unsigned int nSector)
{
	int nOff;
	dosDataCache_S *pCache;


	pCache = &(pBS->DataCache);

	if (pCache->isValid && nSector >= pCache->nStartSector &&
		nSector < (pCache->nStartSector + DOS_CACHE_SIZE_SECTORS))
	{
		nOff = (nSector - pCache->nStartSector) * DOS_BYTES_PER_SEC;
		memset(pCache->cacheBuf + nOff, 0, DOS_BYTES_PER_SEC);

		pCache->isDirty = TRUE;
	}
	else
	{
		//flush out
		dosFlushCache_i(pBS, pCache);

		//read new into cache
		pBS->io.readNSector(nSector, DOS_CACHE_SIZE_SECTORS, pCache->cacheBuf);

		//modify cache
		memset(pCache->cacheBuf, 0, DOS_BYTES_PER_SEC);

		pCache->nStartSector = nSector;
		pCache->isValid = TRUE;
		pCache->isDirty = TRUE;
	}

	return (TRUE);
}

