#ifndef __A1_NET_H__
#define __A1_NET_H__
#include <linux/types.h>

/*
 *------------------------------------------------------
 * ETHERNET Controller Register 
 *------------------------------------------------------
 */
#define A1_ETH_BASE		0x90400000

typedef struct _ETHERNETCON {
	volatile u32 ETHECSR0;			/*System Control Register */
	volatile u32 ETHECSR1;			/*Transmit Poll Demand Register */
	volatile u32 ETHECSR2;			/*Receive Poll Demand Register */
	volatile u32 ETHECSR3;			/*Transmit Descriptor Base Address Register */
	volatile u32 ETHECSR4;			/*Receive Descriptor Base Address Register */
	volatile u32 ETHECSR5;			/*Network Status Report Register */
	volatile u32 ETHECSR6;			/*Network Operation Mode Register */
	volatile u32 ETHECSR7;			/*Interrupt Mask Register */
	volatile u32 ETHECSR8;			/*Flow Control Register */
	volatile u32 ETHECSR9;			/*External Management Access Register */
	volatile u32 ETHECSR10;			/*Boot ROM Address Register (Reserved). */
	volatile u32 ETHECSR11;			/*General Purpose Timer Register (Reserved) */
} ETHERNETCON, *pETHERNETCON;

// Tx Rx descriptor poll demand register
#define ETH_CSR1_TXPOLL		(0x1)
#define ETH_CSR1_RXPOLL		(0x1)

// System control register.
#define ETH_CSR0_0			(0x1)	/* Soft reset */
#define ETH_CSR0_1M			(0xffff0000)	/* IP ID number */
#define ETH_CSR0_2M			(0xfff0)	/* Reversion ID */

//Ethernet interrupt
#define ETH_INT_TRCMP		(0x1 << 14)	/* Transfer complete include TX RX */
#define ETH_INT_ABNRML		(0x1 << 13)	/* All abnormal happen */
#define ETH_INT_TXCMP		(0x1 << 12)	/* Current frame transmit complete. */
#define ETH_INT_RXCMP		(0x1 << 11)	/* Current frame receive complete. */
#define ETH_INT_TXPROCSTP	(0x1 << 10)	/* TX process enter stop state. */
#define ETH_INT_RXPROCSTP	(0x1 << 9)	/* RX process enter stop state. */
#define ETH_INT_TXUNDERF	(0x1 << 5)	/* TX fifo have been underflow. */
#define ETH_INT_RXOVERF		(0x1 << 4)	/* RX fifo have been overflow. */
#define ETH_INT_TXUNAVAIL	(0x1 << 3)	/* The next Tx descriptor unavailable. */
#define ETH_INT_RXUNAVAIL	(0x1 << 2)	/* The next Rx descriptor unavailable. */
#define ETH_INT_SBE			(0x1 << 1)	/* System bus error. */
#define ETH_INT_LSC			(0x1 << 0)	/* Link status change. */

//External Management Access register
#define ETH_CSR9_LSF		(0x1 << 9) /* Load SROM, When set indicate  */
#define ETH_CSR9_RSOM		(0x1 << 8) /* Relod SROM */
#define ETH_CSR9_MDI		(0x1 << 7) /* MII Management Data In */
#define ETH_CSR9_MRWS		(0x1 << 6) /* MII Management R/W Mode Select */
#define ETH_CSR9_MDO		(0x1 << 5) /* MII Management Data out*/
#define ETH_CSR9_MDC		(0x1 << 4) /* MII Management clock */
#define ETH_CSR9_SDO		(0x1 << 3) /* Receive data from SROM */
#define ETH_CSR9_EEDI		(0x1 << 2) /* Write data to SROM */
#define	ETH_CSR9_SCLK		(0x1 << 1) /* Clock to SROM */
#define ETH_CSR9_SSEL		(0x1 << 0) /* Chip select to SROM */

//Receive descriptors
#define ETH_RX_OWNBY_ME		(0x1) /* Descriptor owned by Mercury */
#define ETH_RX_OWNBY_HOST	(0x0) /* Descriptor owned by Host */
#define ETH_TX_PF			(0x0) /* Perfect filter in tdes1 */
#define ETH_TX_HF			(0x1) /* Hash filter in tdes1 */
#define ETH_TX_IF			(0x2) /* Inverse filter in tdes1 */
#define ETH_TX_HOF			(0x3) /* Hash only filter in tdes1 */

//Networking Operation Mode register
#define ETH_CSR6_BLBOTH		(0x1 << 20) /* Burst length 1:32 or 16 bytes */
#define ETH_CSR6_TH64B		(0x0 << 18) /* Threshold level when TX fifo reach level,tx mac will start to transform */
#define ETH_CSR6_TH128B		(0x1 << 18) /* Threshold level when TX fifo reach level,tx mac will start to transform */
#define ETH_CSR6_TH256B		(0x2 << 18) /* Threshold level when TX fifo reach level,tx mac will start to transform */
#define ETH_CSR6_TH512B		(0x3 << 18) /* Threshold level when TX fifo reach level,tx mac will start to transform */
#define ETH_CSR6_SFE		(0x1 << 17) /* Frame transmission will be started after full frame has been moved into FIFO */
#define ETH_CSR6_FCE		(0x1 << 16) /* Enable flow control */
#define ETH_CSR6_RA			(0x1 << 10) /* Receive all  frame */
#define ETH_CSR6_TXCNTL		(0x1 << 9)  /* Transmit Start/Stop command */
#define ETH_CSR6_RXCNTL		(0x1 << 8)  /* Receive Start/Stop command */
#define ETH_CSR6_FCM		(0x1 << 7)  /* Simulate force collision */
#define ETH_CSR6_LOPMN		(0x0 << 5)  /* Loop back mode:normal */
#define ETH_CSR6_LOPMI		(0x0 << 5)  /* Loop back mode:internal */
#define ETH_CSR6_OPMHD		(0x0 << 4)  /* Half duplex mode */
#define ETH_CSR6_OPMFD		(0x1 << 4)  /* Full duplex mode */
#define ETH_CSR6_HFM		(0x1 << 3)  /* Hash filter mode */
#define ETH_CSR6_IAFM		(0x1 << 2)  /* Inverse Address filtering mode */
#define ETH_CSR6_HOFM		(0x1 << 1)  /* Hash-only filter mode */
#define ETH_CSR6_PFM		(0x1 << 0)  /* Perfect filter mode */

typedef enum _phy_data {phy_bit0 = 0, phy_bit1} phy_data;

typedef struct _eth_tx_descript{
	union{
		struct{
			u32 status:31;
			u32 own:1;
		}stdes0;
		u32 tdes0;
	}_tdes0;	
	union{
		struct{
			u32 tbs1_size:11; //Transmit Buffer 1 Size
			u32 tbs2_size:11; //Transmit Buffer 2 Size
			u32 pd:1;  // Padding disable.
			u32 ce:1;  // Chain enable.
			u32 erd:1; // End of ring descriptor.
			u32 acd:1; // Append CRC disable.
			u32 sf:1;  // Setup frame.
			u32 ft:2;  // Filtering type.
			u32 fs:1;  // First segment-reserved.
			u32 ls:1;  // Last segment -reserved.
			u32 fci:1; // Frame completion interrupt.
		}stdes1;		
		u32 tdes1;
	}_tdes1;	
	u32 ba;  //Buffer address.
	u32 nda; //Next descriptor address.	
}eth_tx_descript,*peth_tx_descript;

typedef struct _eth_rx_descript{
	union{
		struct{
			u32 foe:1; //fifo overflow error
			u32 ce:1;  //crc error
			u32 ae:1;  //alignment error
			u32 pe:1;  //physical error
			u32 le:1;  //Length error
			u32 ft:1;  //frame type 1: ether type 0:802.3 frame
			u32 lcs:1; //late collision seen
			u32 elf:1; //excessive length 1:1518bytes 0:1522bytes
			u32 ed:1;  //end descriptor
			u32 bd:1;  //Begin descriptor
			u32 mf:1;  //Multicast frame.
			u32 rf:1;  //Runt frame
			u32 lbm:2; //Loop back mode
			u32 due:1; //Descriptor Unavailable error
			u32 es:1;  //Error summary
			u32 fl:14; //frame legth.
			u32 ff:1;  //Address filter fail
			u32 own:1; //own bit
		}srdes0;
		u32 rdes0;
	}_rdes0;	
	union{
		struct{
			u32 rbs1_size:11;
			u32 rbs2_size:11;
			u32 ce:1;  // Chain enable.
			u32 rsv:9; // Reserved.
		}srdes1;
		u32 rdes1;
	}_rdes1;//RX descriptor 1. 
	u32 ba;   //Buffer address.
	u32 nda;  //Next descriptor address.	
}eth_rx_descript,*peth_rx_descript;

#define A1_ETH_PHYADD		(0x1)
#define A1_ETH_PHY_LS		(0x4) //Link status
#endif							/* __A1_NET_H__ */
