
//#define dprintk //dprintk
#include <linux/module.h>
#include <linux/mm.h>
#include <asm/io.h>
#include <linux/slab.h>

#if 0
#define dprintk        printk
#else
#define dprintk(msg...) do { } while(0)
#endif
 
void
HexDump(unsigned char *buf, unsigned int length)
{

 unsigned int        i = 0;
 unsigned int        j = 0;
 
 printk("\n");
 for (i = 0; i < length; i += 16)
    {
     printk("%04X    ", i);
     for (j = i; (j < i + 8) && (j < length); j++)
    {
     printk(" %02X", buf[j]);
    }
     if (j == i + 8) printk("-");
     for (j = i + 8; (j < i + 16) && (j < length); j++)
    {
     printk("%02X ", buf[j]);
    }
     printk("\n");
    }

} /* end HexDump */

void Speed_Switch(unsigned int bHighSpeed)
{    
    if(bHighSpeed)
    {
        // High Speed 
        /*
        dev_desc->buffer[0] = 0x02000112;
        dev_desc->buffer[1] = 0x40000000;
        dev_desc->buffer[2] = 0x20000520;
        dev_desc->buffer[3] = 0x00000100;
        dev_desc->buffer[4] = 0x00000100;
        */
         // High Speed 
        dev_desc->buffer[0] = 0x02000112;
        dev_desc->buffer[1] = 0x40000000;
        dev_desc->buffer[2] = 0x20000520;
       // dev_desc->buffer[3] = 0x00000100;
       // dev_desc->buffer[4] = 0x00000100;		
		
 // alex dev_desc->buffer[3] = 0x00000100;
        dev_desc->buffer[3] = 0x02010100;
// alex        dev_desc->buffer[4] = 0x00000100;
  	 dev_desc->buffer[4] = 0x00000104;	
  	 
        dev_desc->buffer[5] = 0x00000000;
        dev_desc->buffer[6] = 0x00000000;
        dev_desc->buffer[7] = 0x00000000;
        dev_desc->buffer[8] = 0x0200060a;
        dev_desc->buffer[9] = 0x08000000;
        dev_desc->buffer[10] = 0xbeaf0001;
        dev_desc->buffer[11] = 0x00010090;
        dev_desc->buffer[12] = 0x00000100;
        dev_desc->buffer[13] = 0x00000000;
        dev_desc->buffer[14] = 0x00000000;
        dev_desc->buffer[15] = 0x00000000;
        dev_desc->buffer[16] = 0x00000000;
        dev_desc->buffer[17] = 0x00000000;

		config_desc->buffer[0]  = 0x00230209;
        config_desc->buffer[1]  = 0xc0010101;
        config_desc->buffer[2]  = 0x00040932;
        config_desc->buffer[3]  = 0x06080200;
        config_desc->buffer[4]  = 0x05070050;
        config_desc->buffer[5]  = 0x02000281;
        config_desc->buffer[6]  = 0x02050700;
        config_desc->buffer[7]  = 0x00020002;
	    config_desc->buffer[8]  = 0x00030903;
//		config_desc->buffer[8]  = 0x03830507; //; Configuration1 Descriptor
        config_desc->buffer[9]  = 0x00010008;
        config_desc->buffer[10] = 0x00000000;
        config_desc->buffer[11] = 0x00000000;
        config_desc->buffer[12] = 0x00000000;
        config_desc->buffer[13] = 0x00000000;
        config_desc->buffer[14] = 0x00000000;
        config_desc->buffer[15] = 0x00000000;
    }
    else
    {
        // Class Speed
        dprintk("dev class sped\n");
        /* orign
        dev_desc->buffer[0] = 0x01100112; //--orign       
        dev_desc->buffer[1] = 0x40000000;
        dev_desc->buffer[2] = 0x20000520;
        //dev_desc->buffer[3] = 0x00000100;// --orign
        //dev_desc->buffer[4] = 0x00000100; //--orign
        //--Shirley,MSC
        dev_desc->buffer[3] = 0x02010100;
        dev_desc->buffer[4] = 0x00000104;
        //---
        dev_desc->buffer[5] = 0x00000000;
        dev_desc->buffer[6] = 0x00000000;
        dev_desc->buffer[7] = 0x00000000;
        dev_desc->buffer[8] = 0x0110060a;
        dev_desc->buffer[9] = 0x08000000;
        dev_desc->buffer[10] = 0xbeaf0001;
        dev_desc->buffer[11] = 0x00010090;
        dev_desc->buffer[12] = 0x00000100;
        dev_desc->buffer[13] = 0x00000000;
        dev_desc->buffer[14] = 0x00000000;
        dev_desc->buffer[15] = 0x00000000;
        dev_desc->buffer[16] = 0x00000000;
        dev_desc->buffer[17] = 0x00000000;
		*/
		dev_desc->buffer[0] = 0x02000112;
        dev_desc->buffer[1] = 0x40000000;
        dev_desc->buffer[2] = 0x20000520;
       // dev_desc->buffer[3] = 0x00000100;
       // dev_desc->buffer[4] = 0x00000100;		
		
 // alex dev_desc->buffer[3] = 0x00000100;
        dev_desc->buffer[3] = 0x02010100;
// alex        dev_desc->buffer[4] = 0x00000100;
  	 dev_desc->buffer[4] = 0x00000104;	
  	 
        dev_desc->buffer[5] = 0x00000000;
        dev_desc->buffer[6] = 0x00000000;
        dev_desc->buffer[7] = 0x00000000;
        dev_desc->buffer[8] = 0x0200060a;
        dev_desc->buffer[9] = 0x08000000;
        dev_desc->buffer[10] = 0xbeaf0001;
        dev_desc->buffer[11] = 0x00010090;
        dev_desc->buffer[12] = 0x00000100;
        dev_desc->buffer[13] = 0x00000000;
        dev_desc->buffer[14] = 0x00000000;
        dev_desc->buffer[15] = 0x00000000;
        dev_desc->buffer[16] = 0x00000000;
        dev_desc->buffer[17] = 0x00000000;
        
        config_desc->buffer[0]  = 0x00230209;
        config_desc->buffer[1]  = 0xc0010101;
        config_desc->buffer[2]  = 0x00040932;
        config_desc->buffer[3]  = 0x06080200;
        config_desc->buffer[4]  = 0x05070050;
        config_desc->buffer[5]  = 0x00400281;
        config_desc->buffer[6]  = 0x02050700;
        config_desc->buffer[7]  = 0x00004002;
         config_desc->buffer[8]  = 0x00030903; 
        //config_desc->buffer[8]  = 0x03830507; //; Configuration1 Descriptor
        config_desc->buffer[9]  = 0x00010008;
        config_desc->buffer[10] = 0x00000000;
        config_desc->buffer[11] = 0x00000000;
        config_desc->buffer[12] = 0x00000000;
        config_desc->buffer[13] = 0x00000000;
        config_desc->buffer[14] = 0x00000000;
        config_desc->buffer[15] = 0x00000000;

    }    
        
}

void Data_Structures(unsigned int bHighSpeed)
{
    //dprintk("Inside the Data Structures \n");

    //handle_s = (struct USBHandle *)&m_usbvHandle_g;
    handle_s = (struct USBHandle*)kmalloc(sizeof(struct USBHandle), GFP_KERNEL|GFP_DMA);
    //dprintk("Initialising the Data Structures \n");

    cbw_buffer = (struct CBW_BUFFER *) kmalloc(sizeof(struct CBW_BUFFER),GFP_KERNEL|GFP_DMA);
    
    dev_desc = (struct Device_Descriptor *) kmalloc(sizeof(struct Device_Descriptor),GFP_KERNEL|GFP_DMA);
    config_desc = (struct Configuration_Descriptor *) kmalloc(sizeof(struct Configuration_Descriptor),GFP_KERNEL|GFP_DMA);
    Inquiry_Buffer = (struct StdInquiryData *) kmalloc (sizeof(struct StdInquiryData),GFP_KERNEL|GFP_DMA);
    scsicmd23 = (struct ScsiCmd *) kmalloc (sizeof(struct ScsiCmd),GFP_KERNEL|GFP_DMA);
    modbuffer = (struct Mode_Buffer *) kmalloc (sizeof(struct Mode_Buffer),GFP_KERNEL|GFP_DMA);
    string_desc = (struct String_Descriptor *) kmalloc (sizeof(struct String_Descriptor),GFP_KERNEL|GFP_DMA);
    cswbuf = (struct csw_buffer *)kmalloc(sizeof (struct csw_buffer),GFP_KERNEL|GFP_DMA);
    capability = (struct Capab * )kmalloc(sizeof (struct Capab),GFP_KERNEL|GFP_DMA);
    skbuf= (struct Skey_Buffer *)kmalloc(sizeof (struct Skey_Buffer),GFP_KERNEL|GFP_DMA);
    xfer_buffer = (unsigned char *)kmalloc(64,GFP_KERNEL|GFP_DMA);
    otherbuf = (struct Other_Speed *) kmalloc(sizeof(struct Other_Speed),GFP_KERNEL|GFP_DMA);
    //mbr_buffer[0] = (unsigned int *)kmalloc(512,GFP_KERNEL);

    //GUC Data Structures given to me
    //  Initialize SCSI buffer 
    handle_s->SKEY_BUFFER[0]  = 0x00060070;
    handle_s->SKEY_BUFFER[1]  = 0x0a000000;
    handle_s->SKEY_BUFFER[2]  = 0x00000000;
    handle_s->SKEY_BUFFER[3]  = 0x00000028;
    handle_s->SKEY_BUFFER[4]  = 0x00000000;

    //handle_s->INQRY_BUFFER[0] = 0x02028000;
    //handle_s->INQRY_BUFFER[1] = 0x00000000;
    handle_s->INQRY_BUFFER[0] = 0x01008000; // By Macleod 2006.01.11
    handle_s->INQRY_BUFFER[1] = 0x0000001F; // By Macleod 2006.01.11
	handle_s->INQRY_BUFFER[2] = 0x636D7374; // tsmc TPD
    handle_s->INQRY_BUFFER[3] = 0x44505420; 
	handle_s->INQRY_BUFFER[4] = 0x47333130; // 013G3 (GUC DC)
	handle_s->INQRY_BUFFER[5] = 0x47282033;
	handle_s->INQRY_BUFFER[6] = 0x44204355;
	handle_s->INQRY_BUFFER[7] = 0x20202943;
	handle_s->INQRY_BUFFER[8] = 0x20312E31; //1.1

    handle_s->CMD23_BUFFER[0] = 0x08000000;
    handle_s->CMD23_BUFFER[1] = 0xfff30100;
    handle_s->CMD23_BUFFER[2] = 0x00020000;
    
    handle_s->MODE_BUFFER[0]  = 0x00000003;
    
    Speed_Switch(bHighSpeed);


    //my string descriptor
    string_desc->buffer[0]    = 0x04090304; // String0 Descriptor
    string_desc->buffer[1]    = 0x00000000;
    string_desc->buffer[2]    = 0x0074030A; // String1 Descriptor
    string_desc->buffer[3]    = 0x006D0073;
    string_desc->buffer[4]    = 0x00000063;
    string_desc->buffer[5]    = 0x00000000;
    string_desc->buffer[6]    = 0x00550314; // String2 Descriptor
    string_desc->buffer[7]    = 0x00500041;
    string_desc->buffer[8]    = 0x002D0046;
    string_desc->buffer[9]    = 0x00300032;
    string_desc->buffer[10]   = 0x00300030;
    string_desc->buffer[11]   = 0x00000000;
    string_desc->buffer[12]   = 0x00310308; // String3 Descriptor
    string_desc->buffer[13]   = 0x0031002E;
    string_desc->buffer[14]   = 0x00000000;
    string_desc->buffer[15]   = 0x00000000;
    
    // alex added for logo test

    string_desc->buffer[16]    =  0x0031032A; // String4 Descriptor
    string_desc->buffer[17]    =  0x00300030;
    string_desc->buffer[18]    =  0x00320030;
    string_desc->buffer[19]    =  0x00300030;
    string_desc->buffer[20]    =  0x00310030;
    string_desc->buffer[21]    =  0x00300030;
    string_desc->buffer[22]    =  0x00300030; 
    string_desc->buffer[23]    =  0x00300030;
    string_desc->buffer[24]    =  0x00300030;
    string_desc->buffer[25]    =  0x00370038;
    string_desc->buffer[26]    =  0x00000032;	
    string_desc->buffer[27]    =  0x00000000;
    
    //my inquiry
    //Inquiry_Buffer->buffer[0] = 0x02028000;
    //Inquiry_Buffer->buffer[1] = 0x00000000;
    Inquiry_Buffer->buffer[0] = 0x01008000; // By Macleod 2006.01.11
    Inquiry_Buffer->buffer[1] = 0x0000001F; // By Macleod 2006.01.11
	Inquiry_Buffer->buffer[2] = 0x636D7374; // tsmc TPD
    Inquiry_Buffer->buffer[3] = 0x44505420;
	Inquiry_Buffer->buffer[4] = 0x47333130;
	Inquiry_Buffer->buffer[5] = 0x47282033;
	Inquiry_Buffer->buffer[6] = 0x44204355;
	Inquiry_Buffer->buffer[7] = 0x20202943;
	Inquiry_Buffer->buffer[8] = 0x20312E31; 

    //my cmd23
    scsicmd23->buffer[0] = 0x08000000;
    scsicmd23->buffer[1] = 0xfff30100;
    scsicmd23->buffer[2] = 0x00020000;

    //my modesense
    modbuffer->buffer[0] = 0x00000003;
    //modbuffer->buffer[0] = 0x0800000B;
    //modbuffer->buffer[1] = 0x007D0000;
    //modbuffer->buffer[2] = 0x00020000;
    
    //my skeybuf
    //  Initialize SCSI buffer 
    skbuf->buffer[0]  = 0x00050070;
    skbuf->buffer[1]  = 0x0A000000;
    skbuf->buffer[2]  = 0x00000000;
    skbuf->buffer[3]  = 0x00000024;
    skbuf->buffer[4]  = 0x00000000;
    
    dprintk("Data Structures initialised \n");

}



void Init_Hw()
{
    
}


void write10(struct USBHandle *usb_handle)
{
    unsigned char* pBuf;
    int  control;                 // SCSI command control field
    int  tranf_length;            // SCSI command transfer length

    //------------------------------------------
    // Read CBW buffer
    // 1. Extract control field
    // 2. Extract transfer length
    //------------------------------------------
    /*pBuf = (unsigned char* )usb_handle->CBW_BUFFER;
    control = (int)pBuf[0x18];
    tranf_length = (int)pBuf[0x17] + ((int)pBuf[0x16] << 8);*/

    pBuf = (unsigned char * )cbw_buffer->buffer;
    control = (int)pBuf[0x18];
    tranf_length = (int)pBuf[0x17] + ((int)pBuf[0x16] << 8);


    //------------------------------------------
    // Set SENSE KEY/ASC/ASCQ/CSW
    // 1. Control feild != 0
    //    Sense: Illegal request
    //    ASC: Logic unit not support
    //------------------------------------------

    //pBuf = (unsigned char* )handle_s->SKEY_BUFFER;
    pBuf = (unsigned char* )skbuf->buffer;
    dprintk("Inside write10\n");
    if (control != 0) 
    {
    //    dprintk("Illegal request \n");
        pBuf[2] = (pBuf[2] & 0xf0) | ILLEGAL_REQ;
        pBuf[12] = LU_NOT_SUP;
        handle_s->cswstatus_c = CMD_FAIL;
    }
    else 
    {
    //    dprintk("Csw Status Good \n");
        pBuf[2] = (pBuf[2] & 0xf0) | NO_SENSE;
        pBuf[12] = NO_ADD_SENSE;
        handle_s->cswstatus_c = GOOD;
    }
  handle_s->noff = 0;
  // data_length (bytes) = tranf_length (block) * 512 (bytes/block)
  handle_s->data_length = tranf_length   <<   9;

  //------------------------------------------
  // If transfer length == 0,
  // 1. NO data transfer, enter STATUS stage
  //------------------------------------------
  if (tranf_length == 0)
  {
    //dprintk("Stage Status-Write \n");
    handle_s->bulk_cs = BULK_STATUS;
  }
  else
  {
    //dprintk("Stage Data-Write \n");
    handle_s->bulk_cs = BULK_DATA;
  }
  dprintk("Outside write10\n");

}

void read10_orig(struct USBHandle *usb_handle)
{
  int  control;                // SCSI command control field
  int  tranf_length;           // SCSI command transfer length
  unsigned char* pBuf;
  unsigned int value;
  unsigned int host_count;
  unsigned int temp;
  
   //printk("Inside read10 \n");
  //------------------------------------------
  // Read CBW buffer
  // 1. Extract control field
  // 2. Extract transfer length
  //------------------------------------------
  consistent_sync(cbw_buffer->buffer,31,DMA_FROM_DEVICE);
  pBuf = (unsigned char* )cbw_buffer->buffer;
  //HexDump(pBuf, 31);
  control = (int)pBuf[0x18];  
  tranf_length = (int)pBuf[0x17] + ((int)pBuf[0x16] << 8);

  //------------------------------------------
  // Set SENSE KEY/ASC/ASCQ/CSW
  // 1. Control feild != 0
  //    Sense: Illegal request
  //    ASC: Logic unit not support
  //------------------------------------------
  pBuf = (unsigned char* )handle_s->SKEY_BUFFER;    
  if (control != 0) 
  {
      // dprintk("control != 0 \n");
        pBuf[2]   =    (pBuf[2] & 0xf0)    |    ILLEGAL_REQ;
        pBuf[12]  =    LU_NOT_SUP;
        handle_s->cswstatus_c  =    CMD_FAIL;
  } // end of if (control)
  else 
  {
    if (MediaInit)
    {
        // dprintk("MediaInit set \n");
        pBuf[2] = (pBuf[2] & 0xf0) | NO_SENSE;
        pBuf[12] = NO_ADD_SENSE;
        handle_s->cswstatus_c = GOOD;
    }
    else 
    {
        // dprintk("Media Init is not set \n");
        pBuf[2]   =    (pBuf[2] & 0xf0)    |    NOT_READY;
        pBuf[12]  =    MEDIA_NOT_PRESENT;
        handle_s->cswstatus_c  =    CMD_FAIL;
        tranf_length   =    0;
    } // end of else (MediaInit)
  } // end of else (control)



  //------------------------------------------
  // If transfer length == 0,
  // 1. NO data transfer, enter STATUS stage
  //------------------------------------------
  //already commented data_length (bytes) = tranf_length (block) * 512 (bytes/block)
  //(Inquiry_Buffer->buffer,(((unsigned char *)Inquiry_Buffer->buffer)+36));


  //dprintk("handle_s->data_addr is %08x \n",handle_s->data_addr);

  //dmac_clean_range((unsigned long *)handle_s->data_addr,(unsigned char*)handle_s->data_addr + 512);

  
  handle_s->data_length = tranf_length << 9;

  if (tranf_length == 0)
        handle_s->bulk_cs = BULK_STATUS;
  else 
  {    
       //ReadPhyMediaSectorNByte_i(usb_handle->Clba, 0, 512, data_buffer);
       #ifndef SDRAM_DMA
            // dprintk("SDRAM not defined \n");
            ReadPhyVDiskNByte(handle_s->Clba, 0, 512, data_buffer);
       #endif

       // *USBMDAR = (unsigned int)usb_handle->data_addr;
       // *USBACR  = 0x02000123;

       // Prepare first Bulk-IN data (enable DMA)
       writel((unsigned int)handle_s->data_addr,medusa_base+MDAR);
       //dprintk("MDAR is %08x \n",readl(medusa_base+MDAR));
       temp = 0x02000123;
       writel(temp,medusa_base+ACR);

       while (1) 
       {
         //value = *USBACR & 0x00000830;
       value = (readl(medusa_base+ACR) & 0x00000830 );
         if (value == 0) // DMA ok
         {
             //dprintk("No Error after Dma for first 512 \n");
             break;
         }
         else if (value == 0x00000800) 
         { // DMA error
                // *USBACR   |=   0x800;
                // *USBFHHR  =    0x01020000;
                temp = readl(medusa_base+ACR);
                temp |= 0x800;
                writel(temp,medusa_base+ACR);

                //temp = 0x01020000; //--orign
                //writel(temp,medusa_base+FHHR); //--orign
                 //Shirley update for BFCR
               writel(0x20000, medusa_base + FHHR);
               writel(0x1, medusa_base + BFCR);
                return;
         } // end of else
       } // end of while(1)

       host_count = 0;
       // *USBIDR = 0x01000000;
       // Use polling mechanism
       
       temp = 0x01000000;
       writel(temp,medusa_base+IDR);
    
              

       handle_s->data_length_c = handle_s->data_length_c + 512;
     //phy_des_addr = virt_to_bus(&data_buffer[index]);
     //handle_s->data_addr = phy_des_addr;
       
       //index = index+512;
       handle_s->data_addr = handle_s->data_addr + 512;


       while (handle_s->data_length_c < handle_s->data_length) 
       {
            //*USBMDAR = (unsigned int)usb_handle->data_addr;
            //*USBACR  = 0x02000123;

           //dprintk("read10 : before writing the address \n");

// alex_dma           dmac_clean_range((unsigned long)handle_s->data_addr,(unsigned long)(((unsigned char *)handle_s->data_addr)+512));
             consistent_sync((void *)handle_s->data_addr,512,DMA_TO_DEVICE);
            // Prepare rest bulk-in data (enable DMA)
            writel((unsigned int)handle_s->data_addr,medusa_base+MDAR);
            // dprintk("MDAR is %08x \n",readl(medusa_base+MDAR));
            temp = 0x02000123;
            writel(temp,medusa_base+ACR);
           
                while (1) 
            {       // Check Bulk-IN status
                temp = readl(medusa_base+ISR);                
                if (temp & 0x1000000)  // Bulk-IN data is completed
                {
                             if (host_count < handle_s->data_length_c) 
                    {
                                                //*USBISR = 0x1000000;
                                                // Clear Bulk-IN ISR
                        temp = 0x1000000;
                        writel(temp,medusa_base+ISR);
                                                host_count = host_count + 512;
                    }
                }  
                // Check DMA status
                //value = *USBACR & 0x830;
                value = readl(medusa_base+ACR);
                value &= 0x830;
                if (value == 0)
                {
                    // dprintk("No Error after Dma \n");
                    break;
                }
                else if (value == 0x800) 
                {
                    //*USBACR   |=   0x800;
                                         //*USBFHHR  =    0x01020000;
                    temp = readl(medusa_base+ACR);
                    temp = temp | 0x800;
                    writel(temp,medusa_base+ACR);

                    
                    //temp = 0x01020000; //--orign
                    //writel(temp,medusa_base+FHHR); //--orign
                     //Shirley update for BFCR
               		writel(0x20000, medusa_base + FHHR);
               		writel(0x1, medusa_base + BFCR);
                    printk("Inside read10, DMA failed!!! \n");
                                        return;
                }
                //else
                // printk("Unhandled DMA status: %x\n", value);
                 
                           } // end of while
                                        
            if (host_count < usb_handle->data_length_c) 
            {
               while (1) 
               {
                   //value = *USBISR & 0x1000000;
                   temp = (readl(medusa_base+ISR) &  0x1000000);
                              mdelay(10);
                              
                   if (temp != 0) 
                   {                                 
                       //*USBISR  =    0x1000000;
                       temp = 0x1000000;
                       writel(temp,medusa_base+ISR);
                                          host_count    =     host_count     +    512;
                                          dprintk("host_count %x\n", host_count);
                                          break; 
                                   }
                                   else
                                   {
                                    printk("Not expceted value: %x\n", temp); 
                                    mdelay(100);
                                   }
               } 
               
            } // end of if 
            
            handle_s->data_length_c = handle_s->data_length_c + 512;     
            //phy_des_addr = virt_to_bus(&data_buffer[index]);
            //handle_s->data_addr = phy_des_addr;

            handle_s->data_addr = handle_s->data_addr + 512; 
       } // end of while
       
       // Read10 data stage is completed.
       handle_s->bulk_cs = BULK_DATA;


  //printk("Inside read10, OK!! status %x, %x %x\n", handle_s->bulk_cs, handle_s->data_length_c, handle_s->data_length);
  //printk("Transfer Length: %x\n", tranf_length);


  if((handle_s->data_length_c >= handle_s->data_length) && (bHighSpeed == 1) ) 
  {
//    dprintk("Data Transfer done enter Status Stage \n");
    //dmac_clean_range((unsigned long *)handle_s->data_addr,(((unsigned char *)handle_s->data_addr)+handle_s->data_length));
    ////dmac_clean_range((unsigned long *) handle_s->data_addr,(((unsigned char *)handle_s->data_addr)+handle_s->data_length));
    handle_s->bulk_cs = BULK_STATUS;
    //csw_cache
    //try1
//    dmac_clean_range(cswbuf->buffer,(((unsigned char *)cswbuf->buffer)+13));
    dprintk("CSW--\n");
// alex_dma    dmac_clean_range((unsigned long)cswbuf->buffer,(unsigned long)(((unsigned char *)cswbuf->buffer)+13));    
    consistent_sync(cswbuf->buffer,13,DMA_TO_DEVICE);    
    cswcheck(handle_s);
  }       

       
       // *USBIER = 0x01000000;
       temp = 0x01000000;
       writel(temp,medusa_base+IER);



  } // end of else
  
  //dmac_clean_range((unsigned int *)handle_s->data_addr,(((unsigned char *)handle_s->data_addr)+handle_s->data_length));
  //dmac_clean_range(handle_s->data_addr,(((unsigned char *)handle_s->data_addr)+512)); 
  
  
} // end of READ10


void read10(struct USBHandle *usb_handle)
{
  int  control;                // SCSI command control field
  int  tranf_length;           // SCSI command transfer length
  unsigned char* pBuf;
  unsigned int value;
  unsigned int host_count;
  unsigned int temp;
  unsigned int int_wait, count=0;
  
   //printk("Inside read10 \n");
  //------------------------------------------
  // Read CBW buffer
  // 1. Extract control field
  // 2. Extract transfer length
  //------------------------------------------
  consistent_sync(cbw_buffer->buffer,31,DMA_FROM_DEVICE);
  pBuf = (unsigned char* )cbw_buffer->buffer;
  //HexDump(pBuf, 31);
  control = (int)pBuf[0x18];  
  tranf_length = (int)pBuf[0x17] + ((int)pBuf[0x16] << 8);

  //------------------------------------------
  // Set SENSE KEY/ASC/ASCQ/CSW
  // 1. Control feild != 0
  //    Sense: Illegal request
  //    ASC: Logic unit not support
  //------------------------------------------
  //pBuf = (unsigned char* )handle_s->SKEY_BUFFER;    
  pBuf = (unsigned char* )skbuf->buffer;
  if (control != 0) 
  {
    dprintk("control != 0 \n");
        pBuf[2]   =    (pBuf[2] & 0xf0)    |    ILLEGAL_REQ;
        pBuf[12]  =    LU_NOT_SUP;
        handle_s->cswstatus_c  =    CMD_FAIL;
  } // end of if (control)
  else 
  {
    if (MediaInit)
    {
        // dprintk("MediaInit set \n");
        pBuf[2] = (pBuf[2] & 0xf0) | NO_SENSE;
        pBuf[12] = NO_ADD_SENSE;
        handle_s->cswstatus_c = GOOD;
    }
    else 
    {
        // dprintk("Media Init is not set \n");
        pBuf[2]   =    (pBuf[2] & 0xf0)    |    NOT_READY;
        pBuf[12]  =    MEDIA_NOT_PRESENT;
        handle_s->cswstatus_c  =    CMD_FAIL;
        tranf_length   =    0;
    } // end of else (MediaInit)
  } // end of else (control)



  //------------------------------------------
  // If transfer length == 0,
  // 1. NO data transfer, enter STATUS stage
  //------------------------------------------
  //already commented data_length (bytes) = tranf_length (block) * 512 (bytes/block)
  //(Inquiry_Buffer->buffer,(((unsigned char *)Inquiry_Buffer->buffer)+36));


  //dprintk("handle_s->data_addr is %08x \n",handle_s->data_addr);

  //dmac_clean_range((unsigned long *)handle_s->data_addr,(unsigned char*)handle_s->data_addr + 512);

  
  handle_s->data_length = tranf_length << 9;
  dprintk("tranf_length: %x\n", tranf_length);

  if (tranf_length == 0)
        handle_s->bulk_cs = BULK_STATUS;
  else 
  {    
       //ReadPhyMediaSectorNByte_i(usb_handle->Clba, 0, 512, data_buffer);
       #ifndef SDRAM_DMA
            // dprintk("SDRAM not defined \n");
            ReadPhyVDiskNByte(handle_s->Clba, 0, 512, data_buffer);
       #endif

       // *USBMDAR = (unsigned int)usb_handle->data_addr;
       // *USBACR  = 0x02000123;

       host_count = 0;
       count = 0;
       temp = 0x01000000;
       writel(temp,medusa_base+IDR);       
      

      while (handle_s->data_length_c < handle_s->data_length)
      {
          
       count++;
       
       // Prepare first Bulk-IN data (enable DMA)
// alex_dma       dmac_clean_range((unsigned long)handle_s->data_addr,(unsigned long)(((unsigned char *)handle_s->data_addr)+512));
       consistent_sync(bus_to_virt(handle_s->data_addr), 512,DMA_TO_DEVICE);
       writel((unsigned int)handle_s->data_addr,medusa_base+MDAR);
       //dprintk("MDAR is %08x \n",readl(medusa_base+MDAR));
       temp = 0x02000123;
       writel(temp,medusa_base+ACR);       
       int_wait = 0;
             
              while(1)
              {
                   temp = readl(medusa_base+ISR);
                   if (temp & 0x1000000) // Bulk-IN data is completed, ISR
                    break;
                   else if(int_wait >= 5000) 
                   {
                    temp=readl(medusa_base+ACR);
                  printk("Inside read10, no ISR response failed!!! %d, %x\n", count, temp);
                  return;                
                   }
                   else
                    int_wait++;
                   udelay(10); 
              }
              
          // Check DMA status
          //value = *USBACR & 0x830;
          value = readl(medusa_base+ACR);
          value &= 0x830;          
          if (value == 0x800) 
          {
              //*USBACR   |=   0x800;
                //*USBFHHR  =    0x01020000;
              temp = readl(medusa_base+ACR);
              temp = temp | 0x800;
              writel(temp,medusa_base+ACR);
          
              //temp = 0x01020000; //--orign
              //writel(temp,medusa_base+FHHR); //--orign
               //Shirley update for BFCR
               writel(0x20000, medusa_base + FHHR);
               writel(0x1, medusa_base + BFCR);
              printk("Inside read10, DMA failed!!! \n");
                return;
          }
          else
            host_count += 512;
         
            handle_s->data_length_c += 512;     
            handle_s->data_addr += 512;          
                  
          // Clear ISR    
      temp = 0x1000000;
      writel(temp,medusa_base+ISR);              
              
       }

    
       // Read10 data stage is completed.
       handle_s->bulk_cs = BULK_DATA;


  //printk("Inside read10, OK!! status %x, %x %x\n", handle_s->bulk_cs, handle_s->data_length_c, handle_s->data_length);
  //printk("Transfer Length: %x\n", tranf_length);


  if((handle_s->data_length_c >= handle_s->data_length) ) //&& (bHighSpeed == 1) ) 
  {
//    dprintk("Data Transfer done enter Status Stage \n");
    //dmac_clean_range((unsigned long *)handle_s->data_addr,(((unsigned char *)handle_s->data_addr)+handle_s->data_length));
    ////dmac_clean_range((unsigned long *) handle_s->data_addr,(((unsigned char *)handle_s->data_addr)+handle_s->data_length));
    handle_s->bulk_cs = BULK_STATUS;
    //csw_cache
    //try1
//    dmac_clean_range(cswbuf->buffer,(((unsigned char *)cswbuf->buffer)+13));
    dprintk("CSW--\n");
// alex_dma    dmac_clean_range((unsigned long)cswbuf->buffer,(unsigned long)(((unsigned char *)cswbuf->buffer)+13));    
    consistent_sync(cswbuf->buffer,13,DMA_TO_DEVICE);    
    cswcheck(handle_s);
  }       

       
       // *USBIER = 0x01000000;
       temp = 0x01000000;
       writel(temp,medusa_base+IER);



  } // end of else
  
  //dmac_clean_range((unsigned int *)handle_s->data_addr,(((unsigned char *)handle_s->data_addr)+handle_s->data_length));
  //dmac_clean_range(handle_s->data_addr,(((unsigned char *)handle_s->data_addr)+512)); 
  
  
} // end of READ10



void testunit(struct USBHandle *usb_handle)
{
  int  control;                 // SCSI command control field
  unsigned char* pBuf;

  pBuf = (unsigned char* )cbw_buffer->buffer;
  control = (int)pBuf[0x14];

  // Set SENSE KEY/ASC/ASCQ/CSW
  pBuf = (unsigned char* )handle_s->SKEY_BUFFER;
  
  if (control != 0)
  {
    //dprintk("Command Fails \n");
    pBuf[2]  = (pBuf[2] & 0xf0) | ILLEGAL_REQ;
    pBuf[12] = LU_NOT_SUP;
    handle_s->cswstatus_c = CMD_FAIL;
  } // end of if
  else 
  {
    if (MediaInit) 
    {
        //dprintk("No Add Sense \n");
      pBuf[2]  = (pBuf[2] & 0xf0) | NO_SENSE;   // Sense Key
      pBuf[12] = NO_ADD_SENSE;                  // ASC
      handle_s->cswstatus_c = GOOD;
    } // end of if (MediaInit)
    else 
    {
     //dprintk("Command fails..... \n");
      pBuf[2]   = (pBuf[2] & 0xf0) | NOT_READY;
      pBuf[12]  = MEDIA_NOT_PRESENT;
      handle_s->cswstatus_c = CMD_FAIL;
    } // end of else (MediaInit)
  } // end of else
  handle_s->data_length = 0;
} // end of testunit

void reqsense(struct USBHandle *usb_handle)
{
  int  control;                // SCSI command control field
  int  allct_length;           // SCSI command allocation length
  unsigned char* pBuf;
  
  //------------------------------------------
  // Read CBW buffer
  // 1. Extract control field
  // 2. Extract allocation length
  //------------------------------------------
  pBuf = (unsigned char* )cbw_buffer->buffer;
  control = (int)pBuf[0x14];
  allct_length = (int)pBuf[0x13];
  
  //if(allct_length == 0xff)
  // allct_length = 18; // By Macleod 2006.01.12
  
  //------------------------------------------
  // Set SENSE KEY/ASC/ASCQ/CSW
  // 1. Control feild != 0
  //    Sense: Illegal request
  //    ASC: Logic unit not support
  //------------------------------------------
  //pBuf = (unsigned char* )handle_s->SKEY_BUFFER;
  pBuf = (unsigned char* )skbuf->buffer;
  if (control != 0) 
  {

        pBuf[2] = (pBuf[2] & 0xf0) | ILLEGAL_REQ;
        pBuf[12] = LU_NOT_SUP;
        handle_s->cswstatus_c = CMD_FAIL;
  }
  else 
  {
    skbuf->buffer[0]  = 0x00050070;
    skbuf->buffer[1]  = 0x0A000000;
    skbuf->buffer[2]  = 0x00000000;
    skbuf->buffer[3]  = 0x00000024;
    skbuf->buffer[4]  = 0x00000000;      
      
        handle_s->cswstatus_c = GOOD;
  }
  
  handle_s->data_length  =    allct_length;
  
  //------------------------------------------
  // If allocation length == 0,
  // 1. NO data transfer, enter STATUS stage
  //------------------------------------------
  if ((allct_length == 0) || (allct_length == 1))
  { 		
        handle_s->bulk_cs = BULK_STATUS;
        handle_s->cswstatus_c = CMD_FAIL;
        // *USBFHHR  =    0x01020000;         //Halt Bulk IN        
        //writel(0x01020000,medusa_base+FHHR);  //--orign
         //Shirley update for BFCR
         writel(0x20000, medusa_base + FHHR);
         writel(0x1, medusa_base + BFCR);
  }
      
  else
       handle_s->bulk_cs = BULK_DATA;
} // end of requsense

void inquery(struct USBHandle *usb_handle)
{
  int  control;                // SCSI command control field
  int  cmddt_evpd;             // Inquery command CmdDt/Evpd
  int  allct_length;           // SCSI command allocation length
  unsigned char* pBuf;
  
  //------------------------------------------
  // Read CBW buffer
  // 1. Extract control field
  // 2. Extract CmdDt/Evpd
  // 3. Extract allocation length
  //------------------------------------------
  pBuf =    (unsigned char* )cbw_buffer->buffer;
  control   =    (int)pBuf[0x14];
  cmddt_evpd     =    (int)pBuf[0x10]     &    0x3;
  allct_length   =    (int)pBuf[0x13];
  
  //if(allct_length == 0xff)  
  // allct_length   =    36; //by Macleod 2006.1.11
   
  //------------------------------------------
  // Set SENSE KEY/ASC/ASCQ/CSW
  // 1. Control feild != 0
  //    Sense: Illegal request
  //    ASC: Logic unit not support
  // 2. CmdDt or Evpd != 0
  //    Sense: Illegal request
  //    ASC: Invalid field in CDB
  //------------------------------------------
  pBuf =    (unsigned char* )handle_s->SKEY_BUFFER;
  if   (control != 0)
  {
       dprintk("1. Ilegal request \n");
       pBuf[2]   =    (pBuf[2] & 0xf0)    |    ILLEGAL_REQ;
       pBuf[12]  =    LU_NOT_SUP;
       handle_s->cswstatus_c  =    CMD_FAIL;
  }
  /*
  else if   (cmddt_evpd != 0)
  {
      printk("2. Ilegal request \n");
       pBuf[2]   =    (pBuf[2] & 0xf0)    |    ILLEGAL_REQ;
       pBuf[12]  =    INVALID_CDB;
       handle_s->cswstatus_c  =    CMD_FAIL;
  }
  */
  
  else
  { 
       dprintk("Good request \n");
       pBuf[2]   =    (pBuf[2] & 0xf0)    |    NO_SENSE;      //Sense Key
       pBuf[12]  =    NO_ADD_SENSE;                           //ASC
       handle_s->cswstatus_c  =    GOOD;
  }
  //--Shirley add, 2007/1/4, MSC
 // if(allct_length == 0x24)
 // {
 // 	handle_s->bulk_cs = BULK_DATA;
 // }
  
  handle_s->data_length  =    allct_length;
  
  //------------------------------------------
  // If allocation length == 0,
  // 1. NO data transfer, enter STATUS stage
  //------------------------------------------
  if ((allct_length == 0) || (allct_length == 0x01))
  {
       dprintk("Bulk Status Stage is set \n");
       handle_s->bulk_cs =    BULK_STATUS;
       handle_s->cswstatus_c  =    CMD_FAIL;
       // *USBFHHR  =    0x01020000;         //Halt Bulk IN        
       writel(0x01020000,medusa_base+FHHR);
  }
  else
  {
       dprintk("Bulk Data Stage is set %x\n", allct_length);
       handle_s->bulk_cs =    BULK_DATA;
  }
  
} // end of inquery

void modesense(struct USBHandle *usb_handle)
{
int  control;                // SCSI command contrl field
int  page_code;              // Mode Sense page code
int  allct_length;           // SCSI command allocation length
unsigned char* pBuf;

//------------------------------------------
// Read CBW buffer
// 1. Extract control field
// 2. Extract page code
// 3. Extract allocation length
//------------------------------------------
//pBuf =    (unsigned char* )handle_s->CBW_BUFFER;

//pBuf =    (unsigned char* )handle_s->CBW_BUFFER;
pBuf =    (unsigned char* )cbw_buffer->buffer;
control   =    (int)pBuf[0x14];
page_code =    (int)pBuf[0x11];
allct_length   =    (int)pBuf[0x13];
//------------------------------------------
// Set SENSE KEY/ASC/ASCQ/CSW
// 1. Control feild != 0
//    Sense: Illegal request
//    ASC: Logic unit not support
// 2. page code != 0x3f
//    Sense: Illegla request
//    ASC: Invalid field in CDB
//------------------------------------------
pBuf =    (unsigned char* )handle_s->SKEY_BUFFER;

dprintk("modesense length %x\n", allct_length);

if   (control != 0)
     {
     dprintk("modesense fail1\n");     
     pBuf[2]   =    (pBuf[2] & 0xf0)    |    ILLEGAL_REQ;
     pBuf[12]  =    LU_NOT_SUP;
     handle_s->cswres_c     =    allct_length;
     handle_s->cswstatus_c  =    CMD_FAIL;
     }
else if   ((page_code == 0x3f) || (page_code == 0x1c) || (page_code == 0x0c) ||
          (page_code == 0x00))
          {
          dprintk("modesense good\n");    
          pBuf[2]   =    (pBuf[2] & 0xf0)    |    NO_SENSE;
          pBuf[12]  =    NO_ADD_SENSE;
          handle_s->data_length  =    4;  // for win2000 testing
          //handle_s->cswres_c     =    allct_length   -    12;
          handle_s->cswres_c     =    4;
          handle_s->cswstatus_c  =    GOOD;
          }
else
     {
     dprintk("modesense fail2\n");    
     pBuf[2]   =    (pBuf[2] & 0xf0)    |    ILLEGAL_REQ;
     pBuf[12]  =    INVALID_CDB;
     handle_s->data_length  =    0;
     handle_s->cswres_c     =    allct_length;
     handle_s->cswstatus_c  =    CMD_FAIL;
     }
}


void mass_reset(struct USBHandle *usb_handle)
{
usb_handle->SKEY_BUFFER[0]    =    0x00060070;
usb_handle->SKEY_BUFFER[1]    =    0x0a000000;
usb_handle->SKEY_BUFFER[2]    =    0x00000000;
usb_handle->SKEY_BUFFER[3]    =    0x00000028;
usb_handle->SKEY_BUFFER[4]    =    0x00000000;
}

void startstop(struct USBHandle *usb_handle)
{
int  control;                // SCSI command control field
int  loej;                   // Start stop unit command load/eject
int  start;                  // Start stop unit command start/stop
unsigned char* pBuf;

//------------------------------------------
// Read CBW buffer
// 1. Extract control field
// 2. Extract load/eject
// 3. Extract start/stop
//------------------------------------------
//pBuf =    (unsigned char* )handle_s->CBW_BUFFER;
pBuf =    (unsigned char* )cbw_buffer->buffer;
control   =    (int)pBuf[0x14];
loej      =    (int)pBuf[0x13]     &    0x02;
start     =    (int)pBuf[0x13]     &    0x01;

//------------------------------------------
// Set SENSE KEY/ASC/ASCQ/CSW
// 1. Control feild != 0
//    Sense: Illegal request
//    ASC: Logic unit not support
//------------------------------------------
pBuf =    (unsigned char* )handle_s->SKEY_BUFFER;
if   (control != 0)
     {
     pBuf[2]   =    (pBuf[2] & 0xf0)    |    ILLEGAL_REQ;
     pBuf[12]  =    LU_NOT_SUP;
     handle_s->cswstatus_c  =    CMD_FAIL;
     }
else
     {
     pBuf[2]   =    (pBuf[2] & 0xf0)    |    NO_SENSE;
     pBuf[12]  =    NO_ADD_SENSE;
     handle_s->cswstatus_c  =    GOOD;
     }
handle_s->data_length  =    0;
}

void removal(struct USBHandle *usb_handle)
{
unsigned char* pBuf;

pBuf =    (unsigned char* )handle_s->SKEY_BUFFER;
pBuf[2]   =    (pBuf[2] & 0xf0)    |    ILLEGAL_REQ;
pBuf[12]  =    INVALID_OPC;
handle_s->cswstatus_c  =    CMD_FAIL;
handle_s->data_length  =    0;
}



void cmd23(struct USBHandle *usb_handle)
{
int  control;                // SCSI command control field
unsigned char* pBuf;

//------------------------------------------
// Read CBW buffer
// 1. Extract control field
//------------------------------------------
//pBuf =    (unsigned char* )handle_s->CBW_BUFFER;
pBuf =    (unsigned char* )cbw_buffer->buffer;
control   =    (int)pBuf[0x18];

//------------------------------------------
// Set SENSE KEY/ASC/ASCQ/CSW
// 1. Control feild != 0
//    Sense: Illegal request
//    ASC: Logic unit not support
//------------------------------------------
pBuf =    (unsigned char* )handle_s->SKEY_BUFFER;
if   (control != 0)
     {
     pBuf[2]   =    (pBuf[2] & 0xf0)    |    ILLEGAL_REQ;
     pBuf[12]  =    LU_NOT_SUP;
     handle_s->cswstatus_c  =    CMD_FAIL;
     }
else
     {
     pBuf[2]   =    (pBuf[2] & 0xf0)    |    NO_SENSE;
     pBuf[12]  =    NO_ADD_SENSE;
     handle_s->cswstatus_c  =    GOOD;
     }
handle_s->data_length  =    12;
}



void capacity(struct USBHandle *usb_handle)
{
int  control;                // SCSI command control field
int  pmi;                    // Read capacity command PMI field
int  lba;                    // SCSI command LBA field
unsigned char* pBuf;

//------------------------------------------
// Read CBW buffer
// 1. Extract control field
// 2. Extract PMI
// 3. Extract LBA
//------------------------------------------
//pBuf =    (unsigned char* )handle_s->CBW_BUFFER;
pBuf =    (unsigned char* )cbw_buffer->buffer;
control   =    (int)pBuf[0x18];
pmi  =    (int)pBuf[0x17]     &    0x01;
lba  =    (int)pBuf[0x14]     +    ((int)pBuf[0x13] << 8)   +
          ((int)pBuf[0x12] << 16)  +    ((int)pBuf[0x11] << 24);
//------------------------------------------
// Set SENSE KEY/ASC/ASCQ/CSW
// 1. Control feild != 0
//    Sense: Illegal request
//    ASC: Logic unit not support
// 2. PMI = 0 and LBA != 0
//    Sense: Illegal request
//    ASC: Invalid field in CDB
//------------------------------------------
pBuf =    (unsigned char* )handle_s->SKEY_BUFFER;
if   (control != 0)
     {
     pBuf[2]   =    (pBuf[2] & 0xf0)    |    ILLEGAL_REQ;
     pBuf[12]  =    LU_NOT_SUP;
     }
else if   ((pmi == 0) && (lba != 0))
          {
          pBuf[2]   =    (pBuf[2] & 0xf0)    |    ILLEGAL_REQ;
          pBuf[12]  =    INVALID_CDB;
          }
else
     {
     if   (MediaInit)
          {
          pBuf[2]   =    (pBuf[2] & 0xf0)    |    NO_SENSE;      //Sense Key
          pBuf[12]  =    NO_ADD_SENSE;                           //ASC
          handle_s->cswstatus_c  =    GOOD;
          handle_s->data_length  =    8;
          }
     else
          {
          pBuf[2]   =    (pBuf[2] & 0xf0)    |    NOT_READY;
          pBuf[12]  =    MEDIA_NOT_PRESENT;
          handle_s->cswstatus_c  =    CMD_FAIL;
          handle_s->bulk_cs      =    BULK_STATUS;
          handle_s->data_length  =    0;
          }
     }
}


void verify(struct USBHandle *usb_handle)
{
  int  control;                // SCSI command control field
  int  tranf_length;           // SCSI command transfer length
  int  bytchk;                 // Verify command BYTCHK field
  int  blkvfy;                 // verify command BLKVFY field
  unsigned char* pBuf;
  
  int  CBW_OFFSET ;
  int  CBWB_BYTE1;
  int  CBWB10_CTRL;
  int  CBWB10_LENGTH;
  int  SKEY_OFFSET;
  int  SENSE_BUFFER;
  int  ASC_OFFSET;
  
  //CBW_OFFSET     =    (int)usb_handle->CBW_BUFFER;
  CBW_OFFSET     =    (int)cbw_buffer->buffer;
  CBWB_BYTE1     =    CBW_OFFSET     +    0x10;
  CBWB10_CTRL    =    CBW_OFFSET     +    0x18;
  CBWB10_LENGTH  =    CBW_OFFSET     +    0x16;
  
  SENSE_BUFFER   =   (int)handle_s->SKEY_BUFFER;
  SKEY_OFFSET    =   SENSE_BUFFER    +    0x2;
  ASC_OFFSET     =   SENSE_BUFFER + 0xC;

  //------------------------------------------
  // Read CBW buffer
  // 1. Extract control field
  // 2. Extract transfer length
  // 2. Extract BYTCHK field
  // 2. Extract BLKVFY field
  //------------------------------------------
  //pBuf =    (unsigned char* )usb_handle->CBW_BUFFER;
  pBuf =    (unsigned char* )cbw_buffer->buffer;

  control   =    (int)pBuf[0x18];
  tranf_length   =    (int)pBuf[0x17]     +    ((int)pBuf[0x16] << 8);
  blkvfy    =     (int)pBuf[0x10]    &    0x04;
  bytchk    =     (int)pBuf[0x10]    &    0x02;

  //------------------------------------------
  // Set SENSE KEY/ASC/ASCQ/CSW
  // 1. Control feild != 0
  //    Sense: Illegal request
  //    ASC: Logic unit not support
  // 2. BYTCHK = 2, BLKVFY = 4
  //    Sense: Illegal request
  //    ASC: Invalid field in CDB
  //------------------------------------------
  pBuf =    (unsigned char* )handle_s->SKEY_BUFFER;
  if   (control != 0)
       {
       pBuf[2]   =    (pBuf[2] & 0xf0)    |    ILLEGAL_REQ;
       pBuf[12]  =    LU_NOT_SUP;
       handle_s->cswstatus_c  =    CMD_FAIL;
       }
  else if   ((bytchk == 2) && (blkvfy == 4))
            {
            pBuf[2]   =    (pBuf[2] & 0xf0)    |    ILLEGAL_REQ;
            pBuf[12]  =    INVALID_CDB;
            }
  else
       {
       pBuf[2]   =    (pBuf[2] & 0xf0)    |    NO_SENSE;      //Sense Key
       pBuf[12]  =    NO_ADD_SENSE;                           //ASC
       handle_s->cswstatus_c  =    GOOD;
       }
  // data_length (bytes) = tranf_length (block) * 512 (bytes/block)
  handle_s->data_length  =    tranf_length   <<   9;
  //------------------------------------------
  // If transfer length == 0,
  // 1. NO data transfer, enter STATUS stage
  //------------------------------------------
  if   ((tranf_length == 0) || (bytchk == 0))
       handle_s->bulk_cs =    BULK_STATUS;
  else
       handle_s->bulk_cs =    BULK_DATA;
}

void cmdff(struct USBHandle *usb_handle)
{
int  control;                // SCSI command control field
unsigned char* pBuf;

//------------------------------------------
// Read CBW buffer
// 1. Extract control field
//------------------------------------------
//pBuf =    (unsigned char* )usb_handle->CBW_BUFFER;
pBuf =    (unsigned char* )cbw_buffer->buffer;

control   =    (int)pBuf[0x14];
//------------------------------------------
// Set SENSE KEY/ASC/ASCQ/CSW
//------------------------------------------
pBuf =    (unsigned char* )handle_s->SKEY_BUFFER;
if   (control != 0)
     {
     pBuf[2]   =    (pBuf[2] & 0xf0)    |    ILLEGAL_REQ;
     pBuf[12]  =    LU_NOT_SUP;
     handle_s->cswstatus_c  =    CMD_FAIL;
     }
else
     {
     pBuf[2]   =    (pBuf[2] & 0xf0)    |    NO_SENSE;      //Sense Key
     pBuf[12]  =    NO_ADD_SENSE;                           //ASC
     handle_s->cswstatus_c  =    GOOD;
     }
handle_s->data_length  =    512;
}

void InitSectors()
{
	static int initialed = 0;
	unsigned int temp;

	unsigned int * pBuf =  (unsigned int *)VDISK_BASE;
        unsigned char *pBBuf = (unsigned char *)pBuf;


    temp = VDISK_BASE;

	
	// Only initial once!
	if(initialed)
	 return;
	else
	 initialed = 1;
	 
	
    //dprintk("Inside InitSectors \n");


    
    


	//disk_buffer= (unsigned long *) ioremap_nocache(VDISK_BASE,512);
	// By Macleod 2006.03.14, for VDisk use.
	disk_buffer= (unsigned long *) ioremap_nocache(VDISK_BASE,32*SZ_1M);
	
	if(!disk_buffer)
	 panic("IORemap device physical area error!!!");

	memset(disk_buffer, 0, 2*SZ_1M); // Clear disk garbage!

    //mbr_buffer
    //dprintk("disk_buffer is %08x \n",disk_buffer);
    pBBuf = (void *)disk_buffer;

    setBootSector((unsigned int *)disk_buffer);

    /*phy_mbr_buffer = (unsigned long*)virt_to_bus(disk_buffer);
    secPtr = ((pBBuf[23]*0x100 + pBBuf[22]) * 2 + 32) * 128;
    for  (i=128;i<secPtr;i++)
        pBuf[i]   =    0x0;*/

}

void setBootSector(unsigned int *buffer) 
{

    //unsigned int pBuf[128];
    //dprintk("Initialising the Boot Sectors \n");
    disk_buffer[0]   =    0x4d903ceb;
    disk_buffer[1]   =    0x534f4453;
    disk_buffer[2]   =    0x00302e35;//[11:8],
    disk_buffer[3]   =    0x00010202;//[15:12],   [11:12]=0x200 BytesPerSec, [13]=0x02 SecPerClus, [14]=1 fixed RsvdSecCnt
    disk_buffer[4]   =    0x00020002;//[19:16],   [16]=0x02 fixed NutFATs,  [18:17]=0x200 RootEntCnt
    disk_buffer[5]   =    0x007af800;//[23:20],   [20:19]=0 TotSec16,  [21]=0xf8 fixed Media,  [23:22]=0x00f4/2=0x7a FATSz16
    disk_buffer[6]   =    0x00ff003f;//[27:24],   [25:24]=0x003f SecPerTrk,   [27:26]= 0x00ff NumHeads
    disk_buffer[7]   =    0x00000000;//[31:28],   
    disk_buffer[8]   =    0x0000f500;//[35:32],   0x1ea00/2=0xf500 TotSec16/32
    disk_buffer[9]   =    0x78290000;
    disk_buffer[10]  =    0x4edcc10f;
    disk_buffer[11]  =    0x414e204f;
    disk_buffer[12]  =    0x2020454d;
    disk_buffer[13]  =    0x41462020;
    disk_buffer[14]  =    0x20363154;
    disk_buffer[15]  =    0xc9332020;
    disk_buffer[16]  =    0xf0bcd18e;
    disk_buffer[17]  =    0xb8d98e7b;
    disk_buffer[18]  =    0xc08e2000;
    disk_buffer[19]  =    0x7c00bdfc;
    disk_buffer[20]  =    0x7d244e38;
    disk_buffer[21]  =    0x99c18b24;
    disk_buffer[22]  =    0x72013ce8;
    disk_buffer[23]  =    0x3aeb831c;
    disk_buffer[24]  =    0x7c1ca166;
    disk_buffer[25]  =    0x073b6626;
    disk_buffer[26]  =    0xfc578a26;
    disk_buffer[27]  =    0xca800675;
    disk_buffer[28]  =    0x02568802;
    disk_buffer[29]  =    0x7310c380;
    disk_buffer[30]  =    0x8ac933eb;
    disk_buffer[31]  =    0xf7981046;
    disk_buffer[32]  =    0x46031666;
    disk_buffer[33]  =    0x1e56131c;
    disk_buffer[34]  =    0x130e4603;
    disk_buffer[35]  =    0x11768bd1;
    disk_buffer[36]  =    0xfc468960;
    disk_buffer[37]  =    0xb8fe5689;
    disk_buffer[38]  =    0xe6f70020;
    disk_buffer[39]  =    0x030b5e8b;
    disk_buffer[40]  =    0xf3f748c3;
    disk_buffer[41]  =    0x11fc4601;
    disk_buffer[42]  =    0xbf61fe4e;
    disk_buffer[43]  =    0xe6e80000;
    disk_buffer[44]  =    0x26397200;
    disk_buffer[45]  =    0x17742d38;
    disk_buffer[46]  =    0xbe0bb160;
    disk_buffer[47]  =    0xa6f37da1;
    disk_buffer[48]  =    0x4e327461;
    disk_buffer[49]  =    0xc7830974;
    disk_buffer[50]  =    0x72fb3b20;
    disk_buffer[51]  =    0xa0dcebe6;
    disk_buffer[52]  =    0x7db47dfb;
    disk_buffer[53]  =    0x98acf08b;
    disk_buffer[54]  =    0x480c7440;
    disk_buffer[55]  =    0x0eb41374;
    disk_buffer[56]  =    0xcd0007bb;
    disk_buffer[57]  =    0xa0efeb10;
    disk_buffer[58]  =    0xe6eb7dfd;
    disk_buffer[59]  =    0xeb7dfca0;
    disk_buffer[60]  =    0xcd16cde1;
    disk_buffer[61]  =    0x558b2619;
    disk_buffer[62]  =    0x01b0521a;
    disk_buffer[63]  =    0xe80000bb;
    disk_buffer[64]  =    0xe872003b;
    disk_buffer[65]  =    0x24568a5b;
    disk_buffer[66]  =    0x8b7c0bbe;
    disk_buffer[67]  =    0xf046c7fc;
    disk_buffer[68]  =    0x46c77d3d;
    disk_buffer[69]  =    0x8c7d29f4;
    disk_buffer[70]  =    0xf24e89d9;
    disk_buffer[71]  =    0xc6f64e89;
    disk_buffer[72]  =    0xcb7d9606;
    disk_buffer[73]  =    0x000003ea;
    disk_buffer[74]  =    0xc8b60f20;
    disk_buffer[75]  =    0xf8468b66;
    disk_buffer[76]  =    0x1c460366;
    disk_buffer[77]  =    0x66d08b66;
    disk_buffer[78]  =    0xeb10eac1;
    disk_buffer[79]  =    0xc8b60f5e;
    disk_buffer[80]  =    0x468a4a4a;
    disk_buffer[81]  =    0xf7e4320d;
    disk_buffer[82]  =    0xfc4603e2;
    disk_buffer[83]  =    0xebfe5613;
    disk_buffer[84]  =    0x0650524a;
    disk_buffer[85]  =    0x6a016a53;
    disk_buffer[86]  =    0x468b9110;
    disk_buffer[87]  =    0x33929618;
    disk_buffer[88]  =    0x91f6f7d2;
    disk_buffer[89]  =    0x8742f6f7;
    disk_buffer[90]  =    0x1a76f7ca;
    disk_buffer[91]  =    0xe88af28a;
    disk_buffer[92]  =    0x0a02ccc0;
    disk_buffer[93]  =    0x0201b8cc;
    disk_buffer[94]  =    0x0e027e80;
    disk_buffer[95]  =    0x42b40475;
    disk_buffer[96]  =    0x568af48b;
    disk_buffer[97]  =    0x6113cd24;
    disk_buffer[98]  =    0x400b7261;
    disk_buffer[99]  =    0x03420175;
    disk_buffer[100] =    0x75490b5e;
    disk_buffer[101] =    0x41c3f806;
    disk_buffer[102] =    0x600000bb;
    disk_buffer[103] =    0xeb006a66;
    disk_buffer[104] =    0x4c544eb0;
    disk_buffer[105] =    0x20205244;
    disk_buffer[106] =    0x20202020;
    disk_buffer[107] =    0x544e0a0d;
    disk_buffer[108] =    0x2052444c;
    disk_buffer[109] =    0x6d207369;
    disk_buffer[110] =    0x69737369;
    disk_buffer[111] =    0x0dff676e;
    disk_buffer[112] =    0x7369440a;
    disk_buffer[113] =    0x7265206b;
    disk_buffer[114] =    0xff726f72;
    disk_buffer[115] =    0x72500a0d;
    disk_buffer[116] =    0x20737365;
    disk_buffer[117] =    0x20796e61;
    disk_buffer[118] =    0x2079656b;
    disk_buffer[119] =    0x72206f74;
    disk_buffer[120] =    0x61747365;
    disk_buffer[121] =    0x0a0d7472;
    disk_buffer[122] =    0x00000000;
    disk_buffer[123] =    0x00000000;
    disk_buffer[124] =    0x00000000;
    disk_buffer[125] =    0x00000000;
    disk_buffer[126] =    0xac000000;
    disk_buffer[127] =    0xaa55ccbf;



    //sysMemCpy(buffer, pBuf, 512);

//    secPtr = ((pBBuf[23]*0x100 + pBBuf[22]) * 2 + 32) * 128;
//    for  (i=128;i<secPtr;i++)
//        buffer[i]   =    0x0;
}


int ReadPhyVDiskNByte(unsigned int nSector, unsigned int nOffset,
               unsigned int nSize, unsigned char *pBuf)
{
unsigned int loc, i;
unsigned int *pDst;
unsigned int *pSrc;

pDst =    (unsigned int *)pBuf;
loc  =    (nSector * 512)     +    nOffset; 
loc  =    loc  +    (unsigned int)disk_buffer; //VDISK_BASE;  Eric
pSrc =    (unsigned int *)loc;
for  (i=0;i<(nSize/4);i++)
     {
     *pDst     =    *pSrc;
     pSrc++;
     pDst++;
     }
return    nSize;
}


int WritePhyVDiskNByte(unsigned int nSector, unsigned int nOffset, 
               unsigned int nSize, unsigned char *pBuf)
{
unsigned int loc, i;
unsigned int *pDst;
unsigned int *pSrc;

pSrc =    (unsigned int *)pBuf;
loc  =    (nSector * 512)     +    nOffset; 
loc  =    loc  +    (unsigned int)disk_buffer; //VDISK_BASE; Eric
pDst =    (unsigned int *)loc;
for  (i=0;i<(nSize/4);i++)
     {
     *pDst     =    *pSrc;
     pSrc++;
     pDst++;
     }
return    1;
}


void Allocate_memory()
{
    int k=0;

    // Memory Allocation for Sectors

    // For First 0x20 Sectors
    Sector[0x0] = (unsigned char *)kmalloc(512,GFP_KERNEL);  // Master Boot Record
    PhySector[0x0] = (unsigned char *)virt_to_bus(Sector);

    Sector[0x1] = (unsigned char *)kmalloc(512,GFP_KERNEL);  
    PhySector[0x1] = (unsigned char *)virt_to_bus(Sector);


    // Assigning the same memory for all the 19 sectors
    for(k=0x2;k<0x20;k++)    
    {
        Sector[k] = Sector[0x1];
        PhySector[k] = PhySector[0x1];
    }

/*
// For next 0x28 Sectors (Upto First FAT Table)
    TempAddr = (unsigned char *)MmAllocateContiguousMemory(5120,HiAddr);
    TempPhyAddr = MmGetPhysicalAddress(TempAddr);
    RtlZeroMemory(TempAddr,5120);
    for(w=0x20,y=0; w<0x2A; w++,y=y+512)
    {
        dx->Sector[w] = TempAddr + y;
        Temp1PhyAddr.LowPart = TempPhyAddr.LowPart + y;
        dx->PhySector[w] = Temp1PhyAddr;
    }
    dx->Sector[0x2A] = (unsigned char *)MmAllocateContiguousMemory(512,HiAddr);
    dx->PhySector[0x2A] = MmGetPhysicalAddress(dx->Sector[0x2A]);
    RtlZeroMemory(dx->Sector[0x2A],512);
    // Assigning the same memory for all the 29 sectors
    for(z=0x2B;z<0x48;z++)    
    {
        dx->Sector[z] = dx->Sector[0x2A];
        dx->PhySector[z] = dx->PhySector[0x2A];
    }

// For next 0x3E0 Sectors (Upto Second FAT Table)
    TempAddr = (unsigned char *)MmAllocateContiguousMemory(512,HiAddr);
    TempPhyAddr = MmGetPhysicalAddress(TempAddr);
    RtlZeroMemory(TempAddr,512);
    dx->Sector[0x48] = TempAddr;
    dx->PhySector[0x48] = TempPhyAddr;

    dx->Sector[0x49] = (unsigned char *)MmAllocateContiguousMemory(512,HiAddr);
    dx->PhySector[0x49] = MmGetPhysicalAddress(dx->Sector[0x49]);
    RtlZeroMemory(dx->Sector[0x49],512);
    // Assigning the same memory for all the 987 sectors
    for(z1=0x4a;z1<0x428;z1++)    
    {
        dx->Sector[z1] = dx->Sector[0x49];
        dx->PhySector[z1] = dx->PhySector[0x49];
    }


// For next 0x3E0 Sectors (Upto Root Directory Sector)
    TempAddr = (unsigned char *)MmAllocateContiguousMemory(512,HiAddr);
    TempPhyAddr = MmGetPhysicalAddress(TempAddr);
    RtlZeroMemory(TempAddr,512);
    dx->Sector[0x428] = TempAddr;
    dx->PhySector[0x428] = TempPhyAddr;

    dx->Sector[0x429] = (unsigned char *)MmAllocateContiguousMemory(512,HiAddr);
    dx->PhySector[0x429] = MmGetPhysicalAddress(dx->Sector[0x429]);
    RtlZeroMemory(dx->Sector[0x429],512);
    // Assigning the same memory for all the 987 sectors
    for(z2=0x42a;z2<0x808;z2++)    
    {
        dx->Sector[z2] = dx->Sector[0x429];
        dx->PhySector[z2] = dx->PhySector[0x429];
    }

// For the remaining Sectors
    TempAddr = (unsigned char *)MmAllocateContiguousMemory(32768,HiAddr);
    TempPhyAddr = MmGetPhysicalAddress(TempAddr);
    RtlZeroMemory(TempAddr,32768);
    for(k1=0x808,i1=0; k1<0x86C; k1++,i1=i1+512)
    {
        dx->Sector[k1] = TempAddr + i1;
        Temp1PhyAddr.LowPart = TempPhyAddr.LowPart + i1;
        dx->PhySector[k1] = Temp1PhyAddr;
    }
    dx->Sector[0x86C] = (unsigned char *)MmAllocateContiguousMemory(512,HiAddr);
    dx->PhySector[0x86C] = MmGetPhysicalAddress(dx->Sector[0x86C]);
    RtlZeroMemory(dx->Sector[0x86C],512);
    // Assigning the same memory for all the --- sectors
    for(z3=0x86C;z3<0x870;z3++)    
    {
        dx->Sector[z3] = dx->Sector[0x86C];
        dx->PhySector[z3] = dx->PhySector[0x86C];
    }

    return;*/




}
