#ifndef __UMVP_GPIO_H
#define __UMVP_GPIO_H

/* notify user space application signal NO. */
#define SIG_GPIO  			43
#define GPIO_MAX_DOS		4

/* ##### definitions in gpio_data, added by mingyoung ##### */
struct gpio_data {

	/* 8 DIs. But, in H/W, it has 4 DIs.
	 * GPIO0_01:DI1, GPIO0_02:DI1, GPIO0_03:DI1, GPIO0_04:DI1 */
	unsigned char DI; /* DI[0]:DI1, ..., DI[8]=DI8 */

	/* 8 DOs. But, in H/W, it has 4 DOs.
	 * GPIO0_12:DI1, GPIO0_13:DI1, GPIO0_14:DI1, GPIO0_15:DI1 */
	unsigned char DO; /* DO[0]:DO1, ..., DO[8]=DO8 */
	/* DO_mask : mask bits for setting DOs.
	 * the corresponding bit. 1: set the pin level based on DO setting, 0: not set */
	unsigned char DO_mask;

	/* GPIO functions */
	/* reset: GPIO2_31 (input), 0: the reset button was pressed, 1: otherwise */
	unsigned char reset:1;
	/* pt_stop: GPIO2_30 (input), 0: camera stops, 1: camera is in pan/tilt movement */
	unsigned char pt_stop:1;

	/* day_night: GPIO3_30 (input), 0: night, 1: day */
	unsigned char day_night:1;
	/* power_led: GPIO3_28 (output), 0: LED off, 1: LED on */
	unsigned char power_led:1;
	/* pcba_test: GPIO3_27 (input), 0: enter PCBA test mode, 1: Otherwise */
	unsigned char pcba_test:1;
	/* isp_cal: GPIO3_26 (input), 0: enter ISP calibration mode, 1: Otherwise */
	unsigned char isp_cal:1;
	/* reserved */
	unsigned char rsvd:2;
	/* user space PID */
//	pid_t 		  usPID;
};
#define	GPIOCGGPIOMASK		_IOR('G', 0, unsigned long)
#define	GPIOCGBUTTONMASK	_IOR('G', 1, unsigned long)
#define	GPIOCGDIRECT		_IOR('G', 2, unsigned long)
#define	GPIOCSDIRECT		_IOW('G', 3, unsigned long)
#define	GPIOCGVALUE			_IOR('G', 4, unsigned long)
#define	GPIOCSVALUE			_IOW('G', 5, unsigned long)
#define	GPIOCPOLL			_IO('G', 6)
#define	GPIOCGKEY			_IOR('G', 7, struct gpio_key)

/* ##### ioctl command set for accessing gpio_data ##### */
#define GPIODATAGET			_IOR('G', 8, struct gpio_data)
#define GPIOSETDO			_IOR('G', 9, struct gpio_data)
#define GPIOPOWERLED		_IOR('G', 10, struct gpio_data)
#define	GPIOSETPID			_IOW('G', 11, unsigned long)

/*****************************************************************************************
 * GPIO registers
 ****************************************************************************************/
/* ##### GPIO group register base address */
#define GPIO0_BASE_ADDR			IO_ADDRESS(UMVP_GPIO0_BASE)
#define GPIO1_BASE_ADDR         IO_ADDRESS(UMVP_GPIO1_BASE)
#define GPIO2_BASE_ADDR         IO_ADDRESS(UMVP_GPIO2_BASE)
#define GPIO3_BASE_ADDR         IO_ADDRESS(UMVP_GPIO3_BASE)

#define GPIO0_REG(offset)		(*(volatile __u32 *)(GPIO0_BASE_ADDR+(offset)))
#define GPIO1_REG(offset)   	(*(volatile __u32 *)(GPIO1_BASE_ADDR+(offset)))
#define GPIO2_REG(offset)   	(*(volatile __u32 *)(GPIO2_BASE_ADDR+(offset)))
#define GPIO3_REG(offset)   	(*(volatile __u32 *)(GPIO3_BASE_ADDR+(offset)))

/* ##### GPIO register offset ##### */
#define GPIODATA				0x0000 /* The data register */
#define GPIODIR					0x0004 /* Data direction control register */
#define GPIOIS					0x0008 /* Interrupt sensitive control register */
#define GPIOIBE					0x000C /* Both edge interrupt control register */
#define GPIOIEV					0x0010 /* Interrupt event control register */
#define GPIOIE					0x0014 /* Interrupt mask register */
#define GPIOAFSEL				0x0018 /* Mode control register */
#define GPIORIS					0x001C /* Raw interrupt status register */
#define GPIOMIS					0x0020 /* Masked interrupt status register */
#define GPIOIC					0x0024 /* Interrupt clear register */
#define GPIOMASK				0x0028 /* Data read/write mask register */
#define GPIODBEN				0x002C /* Debounce enable register */

#endif  // __UMVP_GPIO_H
