//  ***************************************************************************
// 
//   Copyright (c) 2009  Evatronix SA 
//
//  ***************************************************************************
//
//   Please review the terms of the license agreement before using     
//   this file. If you are not an authorized user, please destroy this 
//   source code file and notify Evatronix SA immediately that you     
//   inadvertently received an unauthorized copy.                      
//
//  ***************************************************************************
/// @file           nf_utils.h
/// @brief          Aditional helpful functions.
/// @version        $Revision: 1.2 $
/// @author         Piotr Sroka
/// @date           $Date: 2010-04-27 09:54:37 $
//  ***************************************************************************
#ifndef NF_UTILS_H
#define NF_UTILS_H

/******************************************************************************/
/*!  							   
 * @fn          uint8_t wait_for_value(uint32_t reg_addr, uint32_t mask, 
 *                                      uint32_t timeout_us, uint8_t is_set)
 * @brief 	Function waits until data at address reg_addr masked 
 *                  with mask will be equal 1 or 0 (depend on is_set parameter)
 * @param       reg_addr address of data which is checking	
 * @param	mask this parameter defines which bits should be checked
 * @param	timeout_us time in micro seconds that the function 
 *                  waits for value 
 * @param       is_set this parameter defines if selected by mask 
 *                  bits should be set or cleared
 * @return	Function returns 0 if everything is ok 
 *                  otherwise returns error number   
*/
/******************************************************************************/
uint8_t wait_for_value(uint32_t reg_addr, uint32_t mask, uint32_t timeout_us, 
                       uint8_t is_set);

/******************************************************************************/
/*!  							   
 * @fn          is_erased(nf_memory_t *memory, uint32_t page)
 * @brief 	Function checks if page is erased 
 * @param       memory nand flash memory object	
 * @param       page page to checks	
 * @return	Function returns 0 if everything is ok 
 *                  otherwise returns error number   
*/
/******************************************************************************/
uint8_t is_erased(nf_memory_t *memory, uint32_t page);
uint8_t get_fsb(uint32_t value);
#endif
