// vim: ts=4 sw=4
/* ######################################################################################
 * Net.h
 * created by MingYoung. date: 2006/07/19
 * Description:
 *    header file of libnet.a
 * ###################################################################################### */
#ifndef _Net_
#define _Net_
#define BROADCAST_IP		"255.255.255.255"
#define SOCK_ADDR_SIZE		sizeof(struct sockaddr_in)
#define SOCK_ADDR6_SIZE		sizeof(struct sockaddr_in6)

#define UDP_MDU             	1472 /* in bytes */

/* ######################################################################################
 * Definitions of IPv4 Addressing
 * ###################################################################################### */
/* ##### Definition in type in tIPv4 ##### */
enum {
	IP_UNICAST=0,
	IP_MULTICAST,
	IP_BROADCAST,
	IP_NETMASK,
	IP_UNKNOWN
};
/* ##### Definition of tIPv4 ##### */
typedef struct {
	int  type;
	int  IpNum[4];
	char IpStr[16];
} tIPv4;
enum {
	SOCK_BLOCKING=0,
	SOCK_NONBLOCKING
};
/* ######################################################################################
 * Definitions of Socket Option Variables
 * ###################################################################################### */
enum {
	SOCK_OPT_DISABLE=0,
	SOCK_OPT_ENABLE
};
/* ######################################################################################
 * Definitions of the Igmp Control Database
 * ###################################################################################### */
#define IGMP_QUERY_INTERVAL	60 /* in seconds */
#define IGMP_MAX_RESP_TIME      (IGMP_MAX_HOST_REPORT_DELAY*IGMP_TIMER_SCALE)  /* 100 */
#define IGMP_INTERVAL_FACTOR    5  /* 1 to 10, 5: 2:sec */
#define IGMP_ADVISE_INTERVAL    (IGMP_MAX_RESP_TIME/IGMP_INTERVAL_FACTOR)
#define MIN_IP_HEAD_LEN		20 /* 20 bytes */
#define MIN_IGMP_QUERY_LEN	(MIN_IP_HEAD_LEN+IGMP_MINLEN)
typedef struct {
	int    sock;
	time_t ts;
} tIgmpDB;
/* ######################################################################################
 * Extern Functions form MyLibs/Network/Socket.c
 * ###################################################################################### */
extern int  IPv4AddrResolution(struct sockaddr_in *, char *, int);
extern void IPv4AddrSet(struct sockaddr_in *, char *, int);
extern int  IPv4NumAddrCheck(int *, int);
extern int  IPv4Text2Addr(char *, tIPv4 *, int);
extern int  DoesSockHasData(int, unsigned int);
extern int  SockBind(int, char *, int);
extern int	SockBind6(int, char *, int);
extern int  SockBlockingConnect(int, struct sockaddr_in *);
extern int SockBlockingConnect6(int sock, struct sockaddr_in6 *);
extern int IsIPV4 (struct sockaddr_storage *addr);
extern char *InetNtop (struct sockaddr_storage *);
extern unsigned int InetNtoport (struct sockaddr_storage *);
extern int IsAddrZero (struct sockaddr_storage *);
extern void SetAddrZero (struct sockaddr_storage *);
extern int  SockNonblockingConnect(int, struct sockaddr_in *, int);
extern int  SockBlockingModeSet(int, int);
extern int  SockClose(int *sock);
extern int  SockOptBcastAddrSet(int, int);
extern int  SockOptErrCodeGet(int, int *);
extern int  SockOptMcastInterfaceSet(int, char *);
extern int  SockOptMcastIPSet(int, char *, char *);
extern int  SockOptMcastLoopbackSet(int, int);
extern int  SockOptReuseAddrSet(int, int);
extern int  SockOptTosSet(int, int);
extern int  SockOptTtlSet(int, int);
extern int  TcpSockCreate(int *);
extern int  UdpSockCreate(int *);
extern int	TcpSock6Create(int *);
extern int	UdpSock6Create(int *);
/* ######################################################################################
 * Extern Functions form MyLibs/Network/Tcp.c
 * ###################################################################################### */
extern int  SockOptTcpNoDelay(int, int);
extern int  SockOptTcpLingerSet(int, int, int);
extern int  TcpAccept(int, struct sockaddr_in *);
extern int	TcpAccept6(int, struct sockaddr_storage *);
extern int  TcpListen(int, int);
extern int  TcpSockBlockWrite(int, unsigned char *, int);
extern int  TcpSockNonBlockRead(int, unsigned char *, int, int);
extern int TcpSockNonBlockWrite(int , unsigned char *, int , int );
extern int TcpSockNonBlockRead_V2(int, unsigned char *, int, int, int);
/* ######################################################################################
 * Extern Functions form MyLibs/Network/Udp.c
 * ###################################################################################### */
extern int UdpSockBlockRead(int, unsigned char *, int, struct sockaddr_in *);
extern int UdpSockNonBlockRead(int, unsigned char *, int, struct sockaddr_in *, unsigned int);		
extern int UdpSockWrite(int, unsigned char *, int, struct sockaddr_in *);
/* ######################################################################################
 * Extern Funxtions from MyLibs/Network/Igmp.c
 * ###################################################################################### */
extern void IgmpDBInit(time_t, tIgmpDB *);
extern int  IgmpQueryHandler(char *, char *, tIgmpDB *);
extern int  IsIgmpQueryTimeExpired(int, time_t, tIgmpDB *);
#endif							/* _Net_ */
