#define DEFAULT_PRIVKEYFILE	  	"/etc/config/privkeySrv.pem"
#define DEFAULT_CERTFILE 	    	"/etc/config/certSrv.pem"
#define DEFAULT_CERTREQFILE		"/etc/config/certReqSrv.pem"

#define RUNTIME_CERTFILE     		"/var/www/certSrv.pem"
#define RUNTIME_CERTREQFILE  		"/var/www/certReqSrv.pem"

#define HTTPS_INPUTARGS_BUFSIZE		512
#define HTTPS_CREATE_RETMSG_BUFSIZE	2048
#define HTTPS_PROP_RETMSG_BUFSIZE	5120
#define HTTPS_NAME_RETMSG_BUFSIZE	68
#define HTTPS_OP_RETMSG_BUFSIZE		256
/*
#define HTTPS_CERT_BEGIN_SYMBOL 	"----BEGIN CERTIFICATE----"
#define HTTPS_CSR_BEGIN_SYMBOL	    	"----BEGIN CERTIFICATE REQUEST----"
*/
#define HTTPS_CERT_BEGIN_SYMBOL 	"BEGIN CERTIFICATE"
#define HTTPS_CSR_BEGIN_SYMBOL	    	"BEGIN CERTIFICATE REQUEST"
#define HTTPS_CN_BEGIN_SYMBOL		"CN="

/* Data length of Subject definition of X.509 digital certificate */
#define HTTPS_COUNTRY_SIZE		2
#define HTTPS_COUNTRY_BUFSIZE		(HTTPS_COUNTRY_SIZE + 2)
#define HTTPS_PROVINCE_SIZE		40
#define HTTPS_PROVINCE_BUFSIZE		(HTTPS_PROVINCE_SIZE + 4)
#define HTTPS_LOCALITY_SIZE		40
#define HTTPS_LOCALITY_BUFSIZE		(HTTPS_LOCALITY_SIZE + 4)
#define HTTPS_ORGANIZATION_SIZE		40
#define HTTPS_ORGANIZATION_BUFSIZE	(HTTPS_ORGANIZATION_SIZE + 4)
#define HTTPS_DIVISION_SIZE		40
#define HTTPS_DIVISION_BUFSIZE		(HTTPS_DIVISION_SIZE + 4)
#define HTTPS_COMMONANME_SIZE		64
#define HTTPS_COMMONANME_BUFSIZE	(HTTPS_COMMONANME_SIZE + 4)
#define HTTPS_VALIDITY_SIZE		4
#define HTTPS_KEYLEN_SIZE		4

/* Return Status */
enum {
	HTTPS_ERROR_FILE = -2, 
	HTTPS_ERROR = -1, 
	HTTPS_OK = 0 
};

/* Certificate Type */
enum {
	HTTPS_CERTTYPE_CERT = 0, 
	HTTPS_CERTTYPE_CSR 
};

/* Operation modes of https_cer() */
enum {
	HTTPS_CER_OP_QUERY = 0, 
	HTTPS_CER_OP_UPLOAD, 
	HTTPS_CER_OP_REMOVE 
};

/* 
 * Structure for exchanging HTTPS data
 */
/* https_cert_create(), https_csr_create */
typedef struct {
	char 	inputArgs [HTTPS_INPUTARGS_BUFSIZE];	// input arguments 
	int 	argsLen;				// data length of input arguments
	char 	retMsg [HTTPS_CREATE_RETMSG_BUFSIZE]; 	// return message 
	int 	retLen;					// data length of return message
} tHttpsApiCreate; 
/* https_get_cert_prop(), https_get_csr_prop() */
typedef struct {
	char 	retMsg [HTTPS_PROP_RETMSG_BUFSIZE]; 	// return message 
	int 	retLen;					// data length of return message
} tHttpsApiProp; 
/* https_get_cert_name(), https_get_csr_name() */
typedef struct {
	char 	retMsg [HTTPS_NAME_RETMSG_BUFSIZE]; 	// return message 
	int 	retLen;					// data length of return message
} tHttpsApiName; 
/* https_cer(), https_csr_remove() */
typedef struct {
	char 	inputArgs [HTTPS_INPUTARGS_BUFSIZE];	// input arguments
	int 	argsLen;				// data length of input arguments
	char 	retMsg [HTTPS_OP_RETMSG_BUFSIZE]; 	// return message
	int 	retLen;					// data length of return message
} tHttpsApiCerOp; 

/* HTTPS APIs */
int https_cert_create (tHttpsApiCreate *);
int https_csr_create (tHttpsApiCreate *);
int https_get_cert_prop (tHttpsApiProp *);
int https_get_csr_prop (tHttpsApiProp *);
int https_get_cert_common_name (tHttpsApiName *);
int https_get_csr_common_name (tHttpsApiName *);

/*
 * int https_cer (int op, tHttpApiCerOp *api) 
 *
 * == DESCRIPTION ==
 * This function support three operations: remove, upload and query.
 *
 * op: HTTPS_CER_OP_QUERY | HTTPS_CER_OP_UPLOAD | HTTPS_CER_OP_REMOVE 
 * 	HTTPS_CER_OP_QUERY:  query certificate filename
 * 	HTTPS_CER_OP_UPLOAD: upload certificate to IP Camera
 * 	HTTPS_CER_OP_REMOVE: remove certificate and key files
 * *api: 
 * 	https_cer() must declares an pointer *api of struct tHttpsApiCerOp that defined in certgen.h .
 * 	api->in_args: char* | NULL
 * 			a string of file name for uploading
 * 			If operation mode is HTTPS_CER_OP_QUERY or HTTPS_CER_OP_REMOVE, api->in_args must be NULL or "".
 * 	api->argsLen: integer
 * 			The length of api->in_args.
 * 			If operation mode is HTTPS_CER_OP_QUERY or HTTPS_CER_OP_REMOVE, api->argsLen must be 0.
 * 	api->retMsg: char*
 * 			Return message 
 * 	api->retLen: integer
 * 			The Length of api->retMsg.	
 *
 * == RETURN VALUE ==
 * On success, HTTPS_OK(0) is returned; on error, https_cer() returns HTTPS_ERROR(-1).
 *
 * == EXAMPLE ==
 * If you don't know how to use these operations, there are some examples below.
 * 1. Querying filename operation
 * 	tHttpsApiCerOp httpsapi;
 *	//
 * 	// Do Something	
 *	//
 * 	if (https_cer (HTTPS_CER_OP_QUERY, &httpsapi) == HTTPS_OK) {
 * 		PrintFunction ("%s", httpsapi.retMsg);
 *		total_retLen += httpsapi.retLen; 
 *		//
 * 		// Do Something	
 *		//
 * 	} else{
 * 		// Handling Exception 
 * 	}
 * 2. Uploading operation:
 * 	tHttpsApiCerOp httpsapi;
 *	//
 * 	// Do Something	
 *	//
 *	strcpy (httpsapi.in_args, fData->field[0].UploadFileName);
 *	httpsapi.argsLen = strlen (httpsapi.in_args);
 * 	if (https_cer (HTTPS_CER_OP_UPLOAD, &httpsapi) == HTTPS_OK) {
 * 		PrintFunction ("%s", httpsapi.retMsg);
 *		total_retLen += httpsapi.retLen; 
 *		//
 * 		// Do Something	
 *		//
 *	} else {
 * 		// Handling Exception 
 * 	}
 * 3. Removing operation:
 * 	tHttpsApiCerOp httpsapi;
 * 	int total_retLen = 0; 
 *	//
 * 	// Do Something	
 *	//
 * 	if (https_cer (HTTPS_CER_OP_REMOVE, &httpsapi) == HTTPS_OK) {
 * 		PrintFunction ("%s", httpsapi.retMsg);
 *		total_retLen += httpsapi.retLen; 
 *		//
 * 		// Do Something	
 *		//
 * 	} else {
 * 		// Handling Exception 
 * 	}
 */
int https_cer (int op, tHttpsApiCerOp *);

/* 
 * int https_csr_remove (tHttpsApiCerOp *api) 
 * == DESCRIPTION ==
 * This function removes certificate and key files without checking file status.
 *
 * *api:
 * 	https_cer() must declares an pointer *api of struct tHttpsApiCerOp that defined in certgen.h .
 * 	api->retMsg: char*
 * 			Return message 
 * 	api->retLen: integer
 * 			The Length of api->retMsg.	
 *
 * == RETURN VALUE ==
 * The return code and return message are always 0(HTTPS_OK) and "OK".
 *
 * == EXAMPLE ==
 * If you don't know how to use these operations, there is an examples for you.
 * 	tHttpsApiCerOp httpsapi;
 * 	int total_retLen = 0; 
 *	//
 * 	// Do Something	
 *	//
 * 	if (https_csr_remove (&httpsapi) == HTTPS_OK) {
 * 		PrintFunction ("%s", httpsapi.retMsg);
 *		total_retLen += httpsapi.retLen; 
 *		//
 * 		// Do Something	
 *		//
 * 	} else {
 * 		// Handling Exception 
 * 	}
 */
int https_csr_remove (tHttpsApiCerOp *);
