ISP_SRCS	=
ISP_SRCS	+= main.c
#-----------------------------------------------------------------------
# HAL Source list
#
HAL_SRCS	=
#- HAL_AAA
HAL_SRCS	+= $(pxHAL)/hal_aaa/hal_aaa.c

#- HAL_GPIO
HAL_SRCS	+= $(pxHAL)/hal_gpio/hal_gpio.c

#- HAL_CDSP
HAL_SRCS	+= $(pxHAL)/hal_cdsp/hal_front.c
HAL_SRCS	+= $(pxHAL)/hal_cdsp/hal_cdsp.c
HAL_SRCS	+= $(pxHAL)/hal_cdsp/hal_scaler.c
HAL_SRCS	+= $(pxHAL)/hal_cdsp/hal_dispfmt.c
HAL_SRCS	+= $(pxHAL)/hal_cdsp/hal_prmask.c
#- HAL_IIC
HAL_SRCS	+= $(pxHAL)/hal_iic/hal_iic.c

#- HAL_SSI
HAL_SRCS	+= $(pxHAL)/hal_ssi/hal_ssi_motor.c
HAL_SRCS	+= $(pxHAL)/hal_ssi/hal_ssi_imx122.c
HAL_SRCS	+= $(pxHAL)/hal_ssi/hal_ssi_pt_motor.c

#- HAL_IRQ
HAL_SRCS	+= $(pxHAL)/hal_irq/hal_irq.c
#- HAL_MISC
HAL_SRCS	+= $(pxHAL)/hal_misc/hal_misc.c
#- HAL_TIMER
HAL_SRCS	+= $(pxHAL)/hal_tmr/hal_timer.c
HAL_SRCS	+= $(pxHAL)/hal_tmr/hal_systimer.c
HAL_SRCS	+= $(pxHAL)/hal_tmr/hal_sysdelay.c
HAL_SRCS	+= $(pxHAL)/hal_tmr/hal_apptimer.c
HAL_SRCS	+= $(pxHAL)/hal_tmr/hal_ostimer.c

#- HAL_GLOBAL
HAL_SRCS	+= $(pxHAL)/hal_global/hal_global.c

#- HAL_LMC
HAL_SRCS	+= $(pxHAL)/hal_lmc/hal_smc.c

#- HAL_SMC
HAL_SRCS	+= $(pxHAL)/hal_smc/hal_pt_smc.c

#-----------------------------------------------------------------------
# Middleware Source list
#
MDW_SRCS	=

#- 3A
MDW_SRCS	+= $(pxMDW)/aaa/aaa_sys.c
MDW_SRCS	+= $(pxMDW)/aaa/aaa_ae.c
MDW_SRCS	+= $(pxMDW)/aaa/aaa_awb.c
MDW_SRCS	+= $(pxMDW)/aaa/aaa_af.c

#- BOOT
MDW_SRCS	+= $(pxMDW)/boot/isp_main.c
MDW_SRCS	+= $(pxMDW)/boot/host_task.c

#- GLOBAL
MDW_SRCS	+= $(pxMDW)/global/gen_utility.c
MDW_SRCS	+= $(pxMDW)/global/modesw.c
MDW_SRCS	+= $(pxMDW)/global/sys_timer.c
MDW_SRCS	+= $(pxMDW)/global/one_shot.c
MDW_SRCS	+= $(pxMDW)/global/mem_dump.c 
MDW_SRCS	+= $(pxMDW)/global/print2buf.c
MDW_SRCS	+= $(pxMDW)/global/watchdog.c

#- CDSP
MDW_SRCS	+= $(pxMDW)/cdsp/mw_cdsp.c

#- IIC
MDW_SRCS	+= $(pxMDW)/iic/mw_iic.c

#- SSI
MDW_SRCS	+= $(pxMDW)/ssi/mw_ssi_motor.c
MDW_SRCS	+= $(pxMDW)/ssi/mw_ssi_imx122.c
MDW_SRCS	+= $(pxMDW)/ssi/mw_ssi_pt.c

#- SYSCONF
MDW_SRCS	+= $(pxMDW)/sysconf/sysconf_ctrl.c
MDW_SRCS	+= $(pxMDW)/sysconf/sysconf_prof.c
MDW_SRCS	+= $(pxMDW)/sysconf/sysconf_mtd.c

#- CALIB
MDW_SRCS	+= $(pxMDW)/calib/calib_mtd.c

#- MTD
MDW_SRCS	+= $(pxMDW)/mtd/mtd_ctrl.c

#Serial
MDW_SRCS	+= $(pxMDW)/serial/mw_serial.c
#-----------------------------------------------------------------------
# API Source list
#
API_SRCS	=
API_SRCS	+= $(pxAPI)/i80_aaa.c
API_SRCS	+= $(pxAPI)/i80_global.c
API_SRCS	+= $(pxAPI)/i80_os.c
API_SRCS	+= $(pxAPI)/i80_gpio.c
API_SRCS	+= $(pxAPI)/i80_msg.c
API_SRCS	+= $(pxAPI)/i80_sysconf.c
API_SRCS	+= $(pxAPI)/i80_timer.c
API_SRCS	+= $(pxAPI)/i80_sensor.c
API_SRCS	+= $(pxAPI)/i80_front.c
API_SRCS	+= $(pxAPI)/i80_iic.c
API_SRCS	+= $(pxAPI)/i80_spi.c
API_SRCS	+= $(pxAPI)/i80_modesw.c
API_SRCS	+= $(pxAPI)/i80_cdsp.c
API_SRCS	+= $(pxAPI)/i80_smc.c
API_SRCS	+= $(pxAPI)/i80_sensor_serial.c
API_SRCS	+= $(pxAPI)/i80_irq.c
API_SRCS	+= $(pxAPI)/i80_motor_ctrl.c
API_SRCS	+= $(pxAPI)/i80_pt_smc.c
API_SRCS	+= $(pxAPI)/i80_watchdog.c

#-----------------------------------------------------------------------
# SENSOR Source list
#
#- FLOW
API_SRCS	+= $(pxAPI)/sensor/flow/sensor_core.c
API_SRCS	+= $(pxAPI)/sensor/flow/sensor_dev.c
API_SRCS	+= $(pxAPI)/sensor/flow/sensor_front.c
API_SRCS	+= $(pxAPI)/sensor/flow/sensor_model.c
API_SRCS	+= $(pxAPI)/sensor/flow/sensor_serial.c
API_SRCS	+= $(pxAPI)/sensor/flow/sensor_new_frame.c

#- MODEL : dummy
API_SRCS	+= $(pxAPI)/sensor/model/dummy_tg.c
API_SRCS	+= $(pxAPI)/sensor/model/dummy_afe.c
#- MODEL : ovt_4689
API_SRCS	+= $(pxAPI)/sensor/model/ovt_4689/ovt4689_tg.c
API_SRCS	+= $(pxAPI)/sensor/model/ovt_4689/ovt4689_afe.c
API_SRCS	+= $(pxAPI)/sensor/model/ovt_4689/ovt4689_common.c
#- MODEL : ovt_5653
API_SRCS	+= $(pxAPI)/sensor/model/ovt_5653/ovt5653_tg.c
API_SRCS	+= $(pxAPI)/sensor/model/ovt_5653/ovt5653_afe.c
API_SRCS	+= $(pxAPI)/sensor/model/ovt_5653/ovt5653_common.c
#- MODEL : mt_9p031
#API_SRCS	+= $(pxAPI)/sensor/model/mt_9p031/mt9p031_tg.c
#API_SRCS	+= $(pxAPI)/sensor/model/mt_9p031/mt9p031_afe.c
#- MODEL : mt_9j003
API_SRCS	+= $(pxAPI)/sensor/model/mt_9j003/mt9j003_common.c
API_SRCS	+= $(pxAPI)/sensor/model/mt_9j003/mt9j003_tg.c
API_SRCS	+= $(pxAPI)/sensor/model/mt_9j003/mt9j003_afe.c
#- MODEL : mt_9p004  Porting Aptina 9P004
API_SRCS	+= $(pxAPI)/sensor/model/mt_9p004/mt9p004_common.c
API_SRCS	+= $(pxAPI)/sensor/model/mt_9p004/mt9p004_tg.c
API_SRCS	+= $(pxAPI)/sensor/model/mt_9p004/mt9p004_afe.c
#- MODEL : mt_9p004_c  Porting Aptina 9P004_crop
API_SRCS	+= $(pxAPI)/sensor/model/mt_9p004/mt9p004_c_tg.c
API_SRCS	+= $(pxAPI)/sensor/model/mt_9p004/mt9p004_c_afe.c
#- MODEL : ovt9715  Porting OVT-9715
API_SRCS	+= $(pxAPI)/sensor/model/ovt_9715/ovt9715_tg.c
API_SRCS	+= $(pxAPI)/sensor/model/ovt_9715/ovt9715_afe.c
#- MODEL : imx122  Porting SONY IMX122
API_SRCS	+= $(pxAPI)/sensor/model/sony_imx122/imx122_common.c
API_SRCS	+= $(pxAPI)/sensor/model/sony_imx122/imx122_tg.c
API_SRCS	+= $(pxAPI)/sensor/model/sony_imx122/imx122_afe.c
#- MODEL :   Porting SONY AR0331
API_SRCS	+= $(pxAPI)/sensor/model/ar_0331/ar0331_common.c
API_SRCS	+= $(pxAPI)/sensor/model/ar_0331/ar0331_tg.c
API_SRCS	+= $(pxAPI)/sensor/model/ar_0331/ar0331_afe.c
#- MODEL : ar_0130 Porting AR0130
API_SRCS	+= $(pxAPI)/sensor/model/ar_0130/ar0130_common.c
API_SRCS	+= $(pxAPI)/sensor/model/ar_0130/ar0130_tg.c
API_SRCS	+= $(pxAPI)/sensor/model/ar_0130/ar0130_afe.c


#----- SDK SRCS
SDK_SRCS	=
SDK_SRCS	+= $(ISP_SRCS)
SDK_SRCS	+= $(HAL_SRCS)
SDK_SRCS	+= $(MDW_SRCS)
SDK_SRCS	+= $(API_SRCS)
